--[[
Name: Babble-Boss-2.2
Revision: 20005
Author(s): ckknight (ckknight@gmail.com)
Website: http://ckknight.wowinterface.com/
Documentation: http://wiki.wowace.com/index.php/Babble-Boss-2.2
SVN: http://svn.wowace.com/root/trunk/Babble-2.2/Babble-Boss-2.2
Description: BOSS名称本地化库
Dependencies: AceLibrary, AceLocale-2.2
]]

local MAJOR_VERSION = "Babble-Boss-2.2"
local MINOR_VERSION = 20006

if not AceLibrary then error(MAJOR_VERSION .. " requires AceLibrary") end

if not AceLibrary:HasInstance("AceLocale-2.2") then error(MAJOR_VERSION .. " requires AceLocale-2.2") end

local _, x = AceLibrary("AceLocale-2.2"):GetLibraryVersion()
MINOR_VERSION = MINOR_VERSION * 100000 + x

if not AceLibrary:IsNewVersion(MAJOR_VERSION, MINOR_VERSION) then return end

local BabbleBoss = AceLibrary("AceLocale-2.2"):new(MAJOR_VERSION)

-- uncomment below for debug information
-- BabbleBoss:EnableDebugging()

BabbleBoss:RegisterTranslations("enUS", function()
	return {
		["Avalanchion"] = true;
		["The Windreaver"] = true;
		["Baron Charr"] = true;
		["Princess Tempestria"] = true;
		["Grethok the Controller"] = true;
		["Patchwerk"] = true;
		["Grobbulus"] = true;
		["Gluth"] = true;
		["Feugen"] = true;
		["Stalagg"] = true;
		["Thaddius"] = true;
		["Anub'Rekhan"] = true;
		["Grand Widow Faerlina"] = true;
		["Maexxna"] = true;
		["Instructor Razuvious"] = true;
		["Deathknight Understudy"] = true;
		["Gothik the Harvester"] = true;
		["Highlord Mograine"] = true;
		["Thane Korth'azz"] = true;
		["Lady Blaumeux"] = true;
		["Sir Zeliek"] = true;
		["The Four Horsemen"] = true;
		["Noth the Plaguebringer"] = true;
		["Heigan the Unclean"] = true;
		["Loatheb"] = true;
		["Sapphiron"] = true;
		["Kel'Thuzad"] = true;
		["Lord Victor Nefarius"] = true;
		["Nefarian"] = true;
		["Vaelastrasz the Corrupt"] = true;
		["Razorgore the Untamed"] = true;
		["Broodlord Lashlayer"] = true;
		["Chromaggus"] = true;
		["Ebonroc"] = true;
		["Firemaw"] = true;
		["Flamegor"] = true;
		["Majordomo Executus"] = true;
		["Ragnaros"] = true;
		["Baron Geddon"] = true;
		["Golemagg the Incinerator"] = true;
		["Garr"] = true;
		["Sulfuron Harbinger"] = true;
		["Shazzrah"] = true;
		["Lucifron"] = true;
		["Gehennas"] = true;
		["Magmadar"] = true;
		["Onyxia"] = true;
		["Azuregos"] = true;
		["Lord Kazzak"] = true;
		["Ysondre"] = true;
		["Emeriss"] = true;
		["Taerar"] = true;
		["Lethon"] = true;
		["High Priestess Jeklik"] = true;
		["High Priest Venoxis"] = true;
		["High Priest Thekal"] = true;
		["High Priestess Arlokk"] = true;
		["High Priestess Mar'li"] = true;
		["Jin'do the Hexxer"] = true;
		["Bloodlord Mandokir"] = true;
		["Gahz'ranka"] = true;
		["Gri'lek"] = true;
		["Hazza'rah"] = true;
		["Renataki"] = true;
		["Wushoolay"] = true;
		["Hakkar"] = true;
		["Ayamiss the Hunter"] = true;
		["Buru the Gorger"] = true;
		["General Rajaxx"] = true;
		["Lieutenant General Andorov"] = true;
		["Moam"] = true;
		["Anubisath Guardian"] = true;
		["Ossirian the Unscarred"] = true;
		["Lord Kri"] = true;
		["Princess Yauj"] = true;
		["Vem"] = true;
		["The Bug Family"] = true;
		["Eye of C'Thun"] = true;
		["C'Thun"] = true;
		["Anubisath Defender"] = true;
		["Anubisath Warder"] = true;
		["Fankriss the Unyielding"] = true;
		["Princess Huhuran"] = true;
		["Ouro"] = true;
		["Battleguard Sartura"] = true;
		["The Prophet Skeram"] = true;
		["Emperor Vek'lor"] = true;
		["Emperor Vek'nilash"] = true;
		["The Twin Emperors"] = true;
		["Viscidus"] = true;
		["Alzzin the Wildshaper"] = true;
		["Ambassador Flamelash"] = true;
		["Anger'rel"] = true;
		["Archivist Galford"] = true;
		["Atal'alarion"] = true;
		["Avatar of Hakkar"] = true;
		["Bael'Gar"] = true;
		["Balnazzar"] = true;
		["Baroness Anastari"] = true;
		["Baron Rivendare"] = true;
		["Cannon Master Willey"] = true;
		["Captain Kromcrush"] = true;
		["Celebras the Cursed"] = true;
		["Crystal Fang"] = true;
		["Darkmaster Gandling"] = true;
		["Doctor Theolen Krastinov"] = true;
		["Doom'rel"] = true;
		["Dope'rel"] = true;
		["Dreamscythe"] = true;
		["Emperor Dagran Thaurissan"] = true;
		["Fineous Darkvire"] = true;
		["Gasher"] = true;
		["General Angerforge"] = true;
		["General Drakkisath"] = true;
		["Gloom'rel"] = true;
		["Golem Lord Argelmach"] = true;
		["Goraluk Anvilcrack"] = true;
		["Guard Fengus"] = true;
		["Guard Mol'dar"] = true;
		["Guard Slip'kik"] = true;
		["Gyth"] = true;
		["Halycon"] = true;
		["Hate'rel"] = true;
		["Hazzas"] = true;
		["Hearthsinger Forresten"] = true;
		["The Unforgiven"] = true;
		["High Interrogator Gerstahn"] = true;
		["Highlord Omokk"] = true;
		["Hukku"] = true;
		["Hurley Blackbreath"] = true;
		["Hydrospawn"] = true;
		["Illyanna Ravenoak"] = true;
		["Immol'thar"] = true;
		["Instructor Malicia"] = true;
		["Jammal'an the Prophet"] = true;
		["Jandice Barov"] = true;
		["King Gordok"] = true;
		["Kirtonos the Herald"] = true;
		["Lady Illucia Barov"] = true;
		["Landslide"] = true;
		["Lethtendris"] = true;
		["Lord Alexei Barov"] = true;
		["Lord Incendius"] = true;
		["Lord Vyletongue"] = true;
		["Lorekeeper Polkelt"] = true;
		["Loro"] = true;
		["Magister Kalendris"] = true;
		["Magistrate Barthilas"] = true;
		["Magmus"] = true;
		["Maleki the Pallid"] = true;
		["Marduk Blackpool"] = true;
		["Meshlok the Harvester"] = true;
		["Mijan"] = true;
		["Morphaz"] = true;
		["Mother Smolderweb"] = true;
		["Nerub'enkan"] = true;
		["Noxxion"] = true;
		["Ogom the Wretched"] = true;
		["Overlord Wyrmthalak"] = true;
		["Phalanx"] = true;
		["Plugger Spazzring"] = true;
		["Postmaster Malown"] = true;
		["Princess Moira Bronzebeard"] = true;
		["Princess Theradras"] = true;
		["Prince Tortheldrin"] = true;
		["Pusillin"] = true;
		["Pyroguard Emberseer"] = true;
		["Ramstein the Gorger"] = true;
		["Ras Frostwhisper"] = true;
		["Rattlegore"] = true;
		["Razorlash"] = true;
		["Warchief Rend Blackhand"] = true;
		["Ribbly Screwspigot"] = true;
		["Rotgrip"] = true;
		["Seeth'rel"] = true;
		["Shade of Eranikus"] = true;
		["Shadow Hunter Vosh'gajin"] = true;
		["Solakar Flamewreath"] = true;
		["Stomper Kreeg"] = true;
		["Tendris Warpwood"] = true;
		["The Beast"] = true;
		["The Ravenian"] = true;
		["Timmy the Cruel"] = true;
		["Tinkerer Gizlock"] = true;
		["Tsu'zee"] = true;
		["Vectus"] = true;
		["Vile'rel"] = true;
		["War Master Voone"] = true;
		["Weaver"] = true;
		["Zevrim Thornhoof"] = true;
		["Zolo"] = true;
		["Zul'Lor"] = true;
		
		-- From Mendeleev
		["Cho'Rush the Observer"] = true;
		["Lord Hel'nurath"] = true;
		["Pimgib"] = true;
		["Knot Thimblejack's Cache"] = true;
		["Cannonmaster Willey"] = true;
		["Emperor Dagran Thaurissian"] = true;
		["Archmage Arugal"] = true;
		["Archmage Arugal's Voidwalker"] = true;
		["Baron Silverlaine"] = true;
		["Commander Springvale"] = true;
		["Deathsworn Captain"] = true;
		["Fenrus the Devourer"] = true;
		["Odo the Blindwatcher"] = true;
		["Razorclaw the Butcher"] = true;
		["Wolf Master Nandos"] = true;
		["Rend Blackhand"] = true;
		["Kurinnaxx"] = true;
            
		["Maur Grimtotem"] = true;
		["Oggleflint"] = true;
		["Taragaman the Hungerer"] = true;
		["Jergosh the Invoker"] = true;
		["Bazzalan"] = true;
		["Disciple of Naralex"] = true;
		["Lord Cobrahn"] = true;
		["Lady Anacondra"] = true;
		["Kresh"] = true;
		["Lord Pythas"] = true;
		["Skum"] = true;
		["Lord Serpentis"] = true;
		["Verdan the Everliving"] = true;
		["Verdan the Everliving"] = true;
		["Mutanus the Devourer"] = true;
		["Naralex"] = true;
		["Deviate Faerie Dragon"] = true;
		["Ghamoo-ra"] = true;
		["Lady Sarevess"] = true;
		["Gelihast"] = true;
		["Lorgus Jett"] = true;
		["Baron Aquanis"] = true;
		["Twilight Lord Kelris"] = true;
		["Old Serra'kis"] = true;
		["Aku'mai"] = true;
		["Roogug"] = true;
		["Aggem Thorncurse"] = true;
		["Death Speaker Jargba"] = true;
		["Overlord Ramtusk"] = true;
		["Agathelos the Raging"] = true;
		["Blind Hunter"] = true;
		["Charlga Razorflank"] = true;
		["Earthcaller Halmgar"] = true;
		["Tuten'kash"] = true;
		["Lady Falther'ess"] = true;
		["Mordresh Fire Eye"] = true;
		["Glutton"] = true;
		["Ragglesnout"] = true;
		["Amnennar the Coldbringer"] = true;
		["Plaguemaw the Rotting"] = true;
		["Antu'sul"] = true;
		["Witch Doctor Zum'rah"] = true;
		["Shadowpriest Sezz'ziz"] = true;
		["Gahz'rilla"] = true;
		["Chief Ukorz Sandscalp"] = true;
		["Ruuzlu"] = true;
		["Isalien"] = true;
		["Revanchion"] = true;
		["Lord Roccor"] = true;
		["Anub'shiah"] = true;
		["Eviscerator"] = true;
		["Gorosh the Dervish"] = true;
		["Grizzle"] = true;
		["Hedrum the Creeper"] = true;
		["Ok'thor the Breaker"] = true;
		["Houndmaster Grebmar"] = true;
		["Pyromancer Loregrain"] = true;
		["Warder Stilgiss"] = true;
		["Verek"] = true;
		["Watchman Doomgrip"] = true;
		["Panzor the Invincible"] = true;
		["Mor Grayhoof"] = true;
		["Bannok Grimaxe"] = true;
		["Urok Doomhowl"] = true;
		["Quartermaster Zigris"] = true;
		["Gizrul the Slavener"] = true;
		["Ghok Bashguud"] = true;
		["Jed Runewatcher"] = true;
		["Lord Valthalak"] = true;
		["Grubbis"] = true;
		["Chomper"] = true;
		["Viscous Fallout"] = true;
		["Electrocutioner 6000"] = true;
		["Crowd Pummeler 9-60"] = true;
		["Dark Iron Ambassador"] = true;
		["Mekgineer Thermaplugg"] = true;
		["Houndmaster Loksey"] = true;
		["Arcanist Doan"] = true;
		["Herod"] = true;
		["High Inquisitor Fairbanks"] = true;
		["Scarlet Commander Mograine"] = true;
		["High Inquisitor Whitemane"] = true;
		["Interrogator Vishas"] = true;
		["Bloodmage Thalnos"] = true;
		["Ironspine"] = true;
		["Azshir the Sleepless"] = true;
		["Fallen Champion"] = true;
		["Lord Blackwood"] = true;
		["Death Knight Darkreaver"] = true;
		["Kormok"] = true;
		["Skul"] = true;
		["Balzaphon"] = true;
		["Malor the Zealous"] = true;
		["Sothos"] = true;
		["Jarien"] = true;
		["Stonespine"] = true;
		["Rhahk'Zor"] = true;
		["Miner Johnson"] = true;
		["Sneed"] = true;
		["Gilnid"] = true;
		["Captain Greenskin"] = true;
		["Edwin VanCleef"] = true;
		["Mr. Smite"] = true;
		["Cookie"] = true;
		["Targorr the Dread"] = true;
		["Kam Deepfury"] = true;
		["Hamhock"] = true;
		["Bazil Thredd"] = true;
		["Dextren Ward"] = true;
		["Bruegal Ironknuckle"] = true;
		["Baelog"] = true;
		["Eric \"The Swift\""] = true;
		["Olaf"] = true;
		["Revelosh"] = true;
		["Ironaya"] = true;
		["Obsidian Sentinel"] = true;
		["Ancient Stone Keeper"] = true;
		["Galgann Firehammer"] = true;
		["Grimlok"] = true;
		["Archaedas"] = true;
		["Sever"] = true;
		["Scorn"] = true;
		["Rethilgore"] = true;
		["Atiesh"] = true;
		["Stratholme Courier"] = true;
		["Ancient Core Hound"] = true;
		["Gurubashi Berserker"] = true;
        ["Elder Mottled Boar"] = true;
        ["Stoneskin Gargoyle"] = true;
        ["Winter Wolf"] = true;
        ["Large Crag Boar"] = true;
        ["Venom Stalker"] = true;
        ["Living Monstrosity"] = true;
        ["Necro Stalker"] = true;
        ["Death Talon Wyrmguard"] = true;
	}
end)

BabbleBoss:RegisterTranslations("zhCN", function()
	return {
		["Avalanchion"] = "阿瓦兰奇奥",
		["The Windreaver"] = "烈风掠夺者",
		["Baron Charr"] = "火焰男爵查尔",
		["Princess Tempestria"] = "泰比斯蒂亚公主",
		["Grethok the Controller"] = "黑翼控制者",
		["Patchwerk"] = "帕奇维克",
		["Grobbulus"] = "葛罗巴斯",
		["Gluth"] = "古鲁斯",
		["Feugen"] = "伏晨",
		["Stalagg"] = "斯塔拉格",
		["Thaddius"] = "泰迪斯",
		["Anub'Rekhan"] = "阿努布雷坎",
		["Grand Widow Faerlina"] = "黑女巫法琳娜",
		["Maexxna"] = "梅克丝娜",
		["Instructor Razuvious"] = "教官拉苏维奥斯",
		["Deathknight Understudy"] = "死亡骑士复仇者",
		["Gothik the Harvester"] = "收割者戈提克",
		["Highlord Mograine"] = "大领主莫格莱尼",
		["Thane Korth'azz"] = "库尔塔兹领主",
		["Lady Blaumeux"] = "女公爵布洛莫斯",
		["Sir Zeliek"] = "札里克爵士",
		["The Four Horsemen"] = "四骑士的宝箱",
		["Noth the Plaguebringer"] = "瘟疫者诺斯",
		["Heigan the Unclean"] = "肮脏者海根",
		["Loatheb"] = "憎恨者",
		["Sapphiron"] = "萨菲隆",
		["Kel'Thuzad"] = "克尔苏加德",
		["Lord Victor Nefarius"] = "维克多·奈法里奥斯",
		["Nefarian"] = "奈法利安",
		["Vaelastrasz the Corrupt"] = "堕落的瓦拉斯塔兹",
		["Razorgore the Untamed"] = "狂野的拉佐格尔",
		["Broodlord Lashlayer"] = "勒西雷尔",
		["Chromaggus"] = "克洛玛古斯",
		["Ebonroc"] = "埃博诺克",
		["Firemaw"] = "费尔默",
		["Flamegor"] = "弗莱格尔",
		["Majordomo Executus"] = "管理者埃克索图斯",
		["Ragnaros"] = "拉格纳罗斯",
		["Baron Geddon"] = "迦顿男爵",
		["Golemagg the Incinerator"] = "焚化者古雷曼格",
		["Garr"] = "加尔",
		["Sulfuron Harbinger"] = "萨弗隆先驱者",
		["Shazzrah"] = "沙斯拉尔",
		["Lucifron"] = "鲁西弗隆",
		["Gehennas"] = "基赫纳斯",
		["Magmadar"] = "玛格曼达",
		["Onyxia"] = "奥妮克希亚",
		["Azuregos"] = "艾索雷葛斯",
		["Lord Kazzak"] = "卡扎克",
		["Ysondre"] = "伊索德雷",
		["Emeriss"] = "艾莫莉丝",
		["Taerar"] = "泰拉尔",
		["Lethon"] = "雷索",
		["High Priestess Jeklik"] = "高阶祭司耶克里克",
		["High Priest Venoxis"] = "高阶祭司温诺希斯",
		["High Priest Thekal"] = "High Priest Thekal",
		["High Priestess Arlokk"] = "哈卡莱先知",
		["High Priestess Mar'li"] = "哈卡莱安魂者",
		["Jin'do the Hexxer"] = "妖术师金度",
		["Bloodlord Mandokir"] = "血领主曼多基尔",
		["Gahz'ranka"] = "加兹兰卡",
		["Gri'lek"] = "格里雷克",
		["Hazza'rah"] = "哈札拉尔",
		["Renataki"] = "雷纳塔基",
		["Wushoolay"] = "乌苏雷",
		["Hakkar"] = "哈卡",
		["Ayamiss the Hunter"] = "狩猎者阿亚米斯",
		["Buru the Gorger"] = "吞咽者布鲁",
		["General Rajaxx"] = "拉贾克斯将军",
		["Lieutenant General Andorov"] = "安多洛夫中将",
		["Moam"] = "莫阿姆",
		["Anubisath Guardian"] = "阿努比萨斯守卫者",
		["Ossirian the Unscarred"] = "无疤者奥斯里安",
		["Lord Kri"] = "克里勋爵",
		["Princess Yauj"] = "亚尔基公主",
		["Vem"] = "维姆",
		["The Bug Family"] = "虫子一家",
		["Eye of C'Thun"] = "克苏恩之眼",
		["C'Thun"] = "克苏恩",
		["Anubisath Defender"] = "阿努比萨斯防御者",
		["Anubisath Warder"] = "阿努比萨斯守卫",
		["Fankriss the Unyielding"] = "顽强的范克瑞斯",
		["Princess Huhuran"] = "哈霍兰公主",
		["Ouro"] = "奥罗",
		["Battleguard Sartura"] = "沙尔图拉",
		["The Prophet Skeram"] = "预言者斯克拉姆",
		["Emperor Vek'lor"] = "维克洛尔大帝",
		["Emperor Vek'nilash"] = "维克尼拉斯大帝",
		["The Twin Emperors"] = "双子皇帝",
		["Viscidus"] = "维希度斯",
		["Alzzin the Wildshaper"] = "奥兹恩",
		["Ambassador Flamelash"] = "弗莱拉斯大使",
		["Anger'rel"] = "安格雷尔",
		["Archivist Galford"] = "档案管理员加尔福特",
		["Atal'alarion"] = "阿塔拉利恩",
		["Avatar of Hakkar"] = "哈卡的化身",
		["Bael'Gar"] = "贝尔加",
		["Balnazzar"] = "巴纳札尔",
		["Baroness Anastari"] = "安娜丝塔丽男爵夫人",
		["Baron Rivendare"] = "瑞文戴尔男爵",
		["Cannon Master Willey"] = "炮手威利",
		["Captain Kromcrush"] = "克罗卡斯",
		["Celebras the Cursed"] = "被诅咒的塞雷布拉斯",
		["Crystal Fang"] = "水晶之牙",
		["Darkmaster Gandling"] = "通灵院长·加丁",
		["Doctor Theolen Krastinov"] = "瑟尔林·卡斯迪诺夫教授",
		["Doom'rel"] = "杜姆雷尔",
		["Dope'rel"] = "多普雷尔",
		["Dreamscythe"] = "德姆塞卡尔",
		["Emperor Dagran Thaurissan"] = "达格兰·索瑞森大帝",
		["Fineous Darkvire"] = "弗诺斯·达克维尔",
		["Gasher"] = "加什尔",
		["General Angerforge"] = "安格弗将军",
		["General Drakkisath"] = "达基萨斯将军",
		["Gloom'rel"] = "格鲁雷尔",
		["Golem Lord Argelmach"] = "傀儡统帅阿格曼奇",
		["Goraluk Anvilcrack"] = "古拉鲁克",
		["Guard Fengus"] = "卫兵芬古斯",
		["Guard Mol'dar"] = "卫兵摩尔达",
		["Guard Slip'kik"] = "卫兵斯里基克",
		["Gyth"] = "盖斯",
		["Halycon"] = "哈雷肯",
		["Hate'rel"] = "黑特雷尔",
		["Hazzas"] = "哈札斯",
		["Hearthsinger Forresten"] = "弗雷斯特恩",
		["The Unforgiven"] = "不可宽恕者";
		["High Interrogator Gerstahn"] = "审讯官格斯塔恩",
		["Highlord Omokk"] = "欧莫克大王",
		["Hukku"] = "胡库",
		["Hurley Blackbreath"] = "霍尔雷·黑须",
		["Hydrospawn"] = "海多斯博恩",
		["Illyanna Ravenoak"] = "伊琳娜·暗木",
		["Immol'thar"] = "伊莫塔尔",
		["Instructor Malicia"] = "讲师玛丽希亚",
		["Jammal'an the Prophet"] = "预言者迦玛兰",
		["Jandice Barov"] = "詹迪斯·巴罗夫",
		["King Gordok"] = "戈多克大王",
		["Kirtonos the Herald"] = "传令官基尔图诺斯",
		["Lady Illucia Barov"] = "伊露希亚·巴罗夫",
		["Landslide"] = "兰斯利德",
		["Lethtendris"] = "蕾瑟塔蒂丝",
		["Lord Alexei Barov"] = "阿雷克斯·巴罗夫",
		["Lord Incendius"] = "伊森迪奥斯",
		["Lord Vyletongue"] = "维利塔恩",
		["Lorekeeper Polkelt"] = "博学者普克尔特",
		["Loro"] = "洛若尔",
		["Magister Kalendris"] = "卡雷迪斯镇长",
		["Magistrate Barthilas"] = "巴瑟拉斯镇长",
		["Magmus"] = "玛格姆斯",
		["Maleki the Pallid"] = "苍白的玛勒基",
		["Marduk Blackpool"] = "马杜克·布莱克波尔",
		["Meshlok the Harvester"] = "收割者麦什洛克",
		["Mijan"] = "米杉",
		["Morphaz"] = "摩弗拉斯",
		["Mother Smolderweb"] = "烟网蛛后",
		["Nerub'enkan"] = "奈鲁布恩坎",
		["Noxxion"] = "诺克赛恩",
		["Ogom the Wretched"] = "可悲的奥戈姆",
		["Overlord Wyrmthalak"] = "维姆萨拉克",
		["Phalanx"] = "法拉克斯",
		["Plugger Spazzring"] = "普拉格",
		["Postmaster Malown"] = "邮差玛罗恩",
		["Princess Moira Bronzebeard"] = "铁炉堡公主茉艾拉·铜须",
		["Princess Theradras"] = "瑟莱德丝公主",
		["Prince Tortheldrin"] = "托塞德林王子",
		["Pusillin"] = "普希林",
		["Pyroguard Emberseer"] = "烈焰卫士艾博希尔",
		["Ramstein the Gorger"] = "吞咽者拉姆斯登",
		["Ras Frostwhisper"] = "莱斯·霜语",
		["Rattlegore"] = "血骨傀儡",
		["Razorlash"] = "锐刺鞭笞者",
		["Warchief Rend Blackhand"] = "大酋长雷德·黑手",
		["Ribbly Screwspigot"] = "雷布里·斯库比格特",
		["Rotgrip"] = "洛特格里普",
		["Seeth'rel"] = "西斯雷尔",
		["Shade of Eranikus"] = "伊兰尼库斯的阴影",
		["Shadow Hunter Vosh'gajin"] = "暗影猎手沃许加斯",
		["Solakar Flamewreath"] = "索拉卡·火冠",
		["Stomper Kreeg"] = "践踏者克雷格",
		["Tendris Warpwood"] = "特迪斯·扭木",
		["The Beast"] = "比斯巨兽",
		["The Ravenian"] = "拉文尼亚",
		["Timmy the Cruel"] = "悲惨的提米",
		["Tinkerer Gizlock"] = "工匠吉兹洛克",
		["Tsu'zee"] = "苏斯",
		["Vectus"] = "维克图斯",
		["Vile'rel"] = "瓦勒雷尔",
		["War Master Voone"] = "指挥官沃恩",
		["Weaver"] = "德拉维沃尔",
		["Zevrim Thornhoof"] = "瑟雷姆·刺蹄",
		["Zolo"] = "祖罗",
		["Zul'Lor"] = "祖罗尔",
		
		-- From Mendeleev
		["Cho'Rush the Observer"] = "观察者克鲁什",
		["Lord Hel'nurath"] = "赫尔努拉斯",
		["Pimgib"] = "匹姆吉布",
		["Knot Thimblejack's Cache"] = "诺特·希姆加克的储物箱",
		["Cannonmaster Willey"] = "炮手威利",
		["Emperor Dagran Thaurissian"] = "达格兰·索瑞森大帝",
		["Archmage Arugal"] = "大法师阿鲁高",
		["Archmage Arugal's Voidwalker"] = "阿鲁高的虚空行者",
		["Baron Silverlaine"] = "席瓦莱恩男爵",
		["Commander Springvale"] = "指挥官斯普林瓦尔",
		["Deathsworn Captain"] = "死亡之誓队长",
		["Fenrus the Devourer"] = "吞噬者芬鲁斯",
		["Odo the Blindwatcher"] = "盲眼守卫奥杜",
		["Razorclaw the Butcher"] = "屠夫拉佐克劳",
		["Wolf Master Nandos"] = "狼王南杜斯",
		["Rend Blackhand"] = "大酋长雷德·黑手",
		["Kurinnaxx"] = "库林纳克斯",
            
		["Maur Grimtotem"] = "玛尔·恐怖图腾",
		["Oggleflint"] = "奥格弗林特",
		["Taragaman the Hungerer"] = "饥饿者塔拉加曼",
		["Jergosh the Invoker"] = "祈求者耶戈什",
		["Bazzalan"] = "巴札兰",
		["Disciple of Naralex"] = "纳拉雷克斯的信徒",
		["Lord Cobrahn"] = "考布莱恩",
		["Lady Anacondra"] = "安娜科德拉",
		["Kresh"] = "克雷什",
		["Lord Pythas"] = "皮萨斯",
		["Skum"] = "斯卡姆",
		["Lord Serpentis"] = "瑟芬迪斯",
		["Verdan the Everliving"] = "永生者沃尔丹",
		["Mutanus the Devourer"] = "吞噬者穆坦努斯",
		["Naralex"] = "纳拉雷克斯",
		["Deviate Faerie Dragon"] = "变异精灵龙",
		["Ghamoo-ra"] = "加摩拉",
		["Lady Sarevess"] = "萨利维丝",
		["Gelihast"] = "格里哈斯特",
		["Lorgus Jett"] = "洛古斯·杰特",
		["Baron Aquanis"] = "阿奎尼斯男爵",
		["Twilight Lord Kelris"] = "梦游者克尔里斯",
		["Old Serra'kis"] = "瑟拉吉斯",
		["Aku'mai"] = "阿库麦尔",
		["Roogug"] = "鲁古格",
		["Aggem Thorncurse"] = "阿格姆",
		["Death Speaker Jargba"] = "亡语者贾格巴",
		["Overlord Ramtusk"] = "主宰拉姆塔斯",
		["Agathelos the Raging"] = "暴怒的阿迦赛罗斯",
		["Blind Hunter"] = "盲眼猎手",
		["Charlga Razorflank"] = "卡尔加·刺肋",
		["Earthcaller Halmgar"] = "唤地者哈穆加",
		["Tuten'kash"] = "图特卡什",
		["Lady Falther'ess"] = "Lady Falther'ess",
		["Mordresh Fire Eye"] = "火眼莫德雷斯",
		["Glutton"] = "暴食者",
		["Ragglesnout"] = "拉戈斯诺特",
		["Amnennar the Coldbringer"] = "寒冰之王亚门纳尔",
		["Plaguemaw the Rotting"] = "腐烂的普雷莫尔",
		["Antu'sul"] = "安图苏尔",
		["Witch Doctor Zum'rah"] = "巫医祖穆拉恩",
		["Shadowpriest Sezz'ziz"] = "暗影祭司塞瑟斯",
		["Gahz'rilla"] = "Gahz'rilla",
		["Chief Ukorz Sandscalp"] = "乌克兹·沙顶",
		["Ruuzlu"] = "卢兹鲁",
		["Isalien"] = "依萨利恩",
		["Revanchion"] = "Revanchion",
		["Lord Roccor"] = "洛考尔",
		["Anub'shiah"] = "阿努希尔",
		["Eviscerator"] = "剜眼者",
		["Gorosh the Dervish"] = "修行者高罗什",
		["Grizzle"] = "格里兹尔",
		["Hedrum the Creeper"] = "爬行者赫杜姆",
		["Ok'thor the Breaker"] = "破坏者奥科索尔",
		["Houndmaster Grebmar"] = "驯犬者格雷布玛尔",
		["Pyromancer Loregrain"] = "控火师罗格雷恩",
		["Warder Stilgiss"] = "典狱官斯迪尔基斯",
		["Verek"] = "维雷克",
		["Watchman Doomgrip"] = "卫兵杜格瑞普",
		["Panzor the Invincible"] = "无敌的潘佐尔",
		["Mor Grayhoof"] = "莫尔·灰蹄",
		["Bannok Grimaxe"] = "班诺克·巨斧",
		["Urok Doomhowl"] = "乌洛克",
		["Quartermaster Zigris"] = "军需官兹格雷斯",
		["Gizrul the Slavener"] = "奴役者基兹卢尔",
		["Ghok Bashguud"] = "霍克·巴什古德",
		["Jed Runewatcher"] = "杰德";
		["Lord Valthalak"] = "瓦萨拉克";
		["Grubbis"] = "格鲁比斯";
		["Chomper"] = "咀嚼者";
		["Viscous Fallout"] = "粘性辐射尘";
		["Electrocutioner 6000"] = "电刑器6000型";
		["Crowd Pummeler 9-60"] = "群体打击者9-60";
		["Dark Iron Ambassador"] = "黑铁大师";
		["Mekgineer Thermaplugg"] = "麦克尼尔·瑟玛普拉格";
		["Houndmaster Loksey"] = "驯犬者洛克希";
		["Arcanist Doan"] = "秘法师杜安";
		["Herod"] = "赫洛德";
		["High Inquisitor Fairbanks"] = "大检察官法尔班克斯";
		["Scarlet Commander Mograine"] = "血色十字军指挥官莫格莱尼";
		["High Inquisitor Whitemane"] = "大检察官怀特迈恩";
		["Interrogator Vishas"] = "审讯员韦沙斯";
		["Bloodmage Thalnos"] = "血法师萨尔诺斯";
		["Ironspine"] = "铁脊死灵";
		["Azshir the Sleepless"] = "永醒的艾希尔";
		["Fallen Champion"] = "亡灵勇士";
		["Lord Blackwood"] = "黑木王";
		["Death Knight Darkreaver"] = "死亡骑士达克雷尔";
		["Kormok"] = "库尔莫克";
		["Skul"] = "斯库尔";
		["Balzaphon"] = "巴尔萨冯";
		["Malor the Zealous"] = "狂热的玛洛尔";
		["Sothos"] = "索托斯";
		["Jarien"] = "亚雷恩";
		["Stonespine"] = "石脊";
		["Rhahk'Zor"] = "拉克佐";
		["Miner Johnson"] = "矿工约翰森";
		["Sneed"] = "斯尼德";
		["Gilnid"] = "基尔尼格";
		["Captain Greenskin"] = "绿皮队长";
		["Edwin VanCleef"] = "艾德温·范克里夫";
		["Mr. Smite"] = "重拳先生";
		["Cookie"] = "曲奇";
		["Targorr the Dread"] = "可怕的塔格尔";
		["Kam Deepfury"] = "卡姆·深怒";
		["Hamhock"] = "哈姆霍克";
		["Bazil Thredd"] = "巴基尔·斯瑞德";
		["Dextren Ward"] = "迪克斯特·瓦德";
		["Bruegal Ironknuckle"] = "布鲁戈·艾尔克纳寇";
		["Baelog"] = "巴尔洛戈";
		["Eric \"The Swift\""] = "埃瑞克";
		["Olaf"] = "奥拉夫";
		["Revelosh"] = "鲁维罗什";
		["Ironaya"] = "艾隆纳亚";
		["Obsidian Sentinel"] = "黑曜石哨兵";
		["Ancient Stone Keeper"] = "古代的石头看守者";
		["Galgann Firehammer"] = "加加恩·火锤";
		["Grimlok"] = "格瑞姆洛克";
		["Archaedas"] = "阿扎达斯";
		["Sever"] = "Sever";
		["Scorn"] = "Scorn";
		["Rethilgore"] = "雷希戈尔";
		["Atiesh"] = "埃提耶什";
		["Stratholme Courier"] = "斯坦索姆信使";
		["Ancient Core Hound"] = "上古熔火恶犬";
		["Gurubashi Berserker"] = "古拉巴什狂暴者";
        ["Elder Mottled Boar"] = "老杂斑野猪",
        ["Stoneskin Gargoyle"] = "岩肤石像鬼",
        ["Venom Stalker"] = "毒液捕猎者",
        ["Living Monstrosity"] = "畸形妖";
        ["Necro Stalker"] = "死灵捕猎者";
        ["Death Talon Wyrmguard"] = "死爪龙人护卫";
	}
end)

BabbleBoss:Debug()
BabbleBoss:SetStrictness(true)

AceLibrary:Register(BabbleBoss, MAJOR_VERSION, MINOR_VERSION)
BabbleBoss = nil
