﻿--[[
	Name: Babble-Spell-2.2
	Revision: $Rev: 25188 $
	Author(s): ckknight (ckknight@gmail.com)
	Website: http://ckknight.wowinterface.com/
	Documentation: http://wiki.wowace.com/index.php/Babble-Spell-2.2
	SVN: http://svn.wowace.com/root/trunk/Babble-2.2/Babble-Spell-2.2
	Description: A library to provide localizations for spells.
	Dependencies: AceLibrary, AceLocale-2.2
]]

local MAJOR_VERSION = "Babble-Spell-2.2"
local MINOR_VERSION = tonumber(string.sub("$Revision: 25188 $", 12, -3))

if not AceLibrary then error(MAJOR_VERSION .. " requires AceLibrary") end
if not AceLibrary:HasInstance("AceLocale-2.2") then error(MAJOR_VERSION .. " requires AceLocale-2.2") end

local _, x = AceLibrary("AceLocale-2.2"):GetLibraryVersion()
MINOR_VERSION = MINOR_VERSION * 100000 + x

if not AceLibrary:IsNewVersion(MAJOR_VERSION, MINOR_VERSION) then return end

local BabbleSpell = AceLibrary("AceLocale-2.2"):new(MAJOR_VERSION)

-- uncomment below for debug information
-- BabbleSpell:EnableDebugging()

BabbleSpell:RegisterTranslations("enUS", function()
    return {
		["Abolish Disease"]="Abolish Disease",
		["Abolish Poison Effect"]="Abolish Poison Effect",
		["Abolish Poison"]="Abolish Poison",
		["Acid Breath"]="Acid Breath",
		["Acid of Hakkar"]="Acid of Hakkar",
		["Counterspell - Silenced"]="Counterspell - Silenced",
		["Acid Spit"]="Acid Spit",
		["Acid Splash"]="Acid Splash",
		["Activate MG Turret"]="Activate MG Turret",
		["Admiral's Hat"]="Admiral's Hat",
		["Adored"]="Adored",
		["Adrenaline Rush"]="Adrenaline Rush",
		["Advanced Target Dummy Spawn Effect"]="Advanced Target Dummy Spawn Effect",
		["Aegis Heal"]="Aegis Heal",
		["Misdirection"] = "Misdirection",
		["Aegis of Preservation"]="Aegis of Preservation",
		["Aftermath"]="Aftermath",
		["Mass Dispel"] = "Mass Dispel",
		["Steady Shot"] = "Steady Shot",
		["Agamaggan's Agility"]="Agamaggan's Agility",
		["Agamaggan's Strength"]="Agamaggan's Strength",
		["Aggression"]="Aggression",
		["Agility"]="Agility",
		["Aimed Shot"]="Aimed Shot",
		["Alchemy"]="Alchemy",
		["Alterac Spring Water"]="Alterac Spring Water",
		["Ambush"]="Ambush",
		["Amplify Curse"]="Amplify Curse",
		["Amplify Damage"]="Amplify Damage",
		["Intervene"] = "Intervene",
		["Amplify Flames"]="Amplify Flames",
		["Amplify Magic"]="Amplify Magic",
		["Ancestor's Vengeance"]="Ancestor's Vengeance",
		["Ancestral Healing"]="Ancestral Healing",
		["Ancestral Knowledge"]="Ancestral Knowledge",
		["Ancestral Spirit"]="Ancestral Spirit",
		["Ancient Despair"]="Ancient Despair",
		["Ancient Dread"]="Ancient Dread",
		["Ancient Hysteria"]="Ancient Hysteria",
		["Anger Management"]="Anger Management",
		["Anticipation"]="Anticipation",
		["Antimagic Pulse"]="Antimagic Pulse",
		["Aqua Jet"]="Aqua Jet",
		["Aquatic Form"]="Aquatic Form",
		["Arcane Blast"]="Arcane Blast",
		["Arcane Brilliance"]="Arcane Brilliance",
		["Arcane Bolt"]="Arcane Bolt",
		["Arcane Bomb"]="Arcane Bomb",
		["Arcane Concentration"]="Arcane Concentration",
		["Arcane Detonation"]="Arcane Detonation",
		["Arcane Elixir"]="Arcane Elixir",
		["Arcane Explosion"]="Arcane Explosion",
		["Arcane Focus"]="Arcane Focus",
		["Arcane Infused"]="Arcane Infused",
		["Arcane Instability"]="Arcane Instability",
		["Arcane Intellect"]="Arcane Intellect",
		["Arcane Meditation"]="Arcane Meditation",
		["Arcane Mind"]="Arcane Mind",
		["Arcane Missiles"]="Arcane Missiles",
		["Arcane Missile"]="Arcane Missile",
		["Arcane Potency"]="Arcane Potency",
		["Arcane Power"]="Arcane Power",
		["Arcane Protection"]="Arcane Protection",
		["Arcane Resistance"]="Arcane Resistance",
		["Arcane Shot"]="Arcane Shot",
		["Arcane Shroud"]="Arcane Shroud",
		["Arcane Subtlety"]="Arcane Subtlety",
		["Arcing Smash"]="Arcing Smash",
		["Arctic Reach"]="Arctic Reach",
		["Argent Avenger"]="Argent Avenger",
		["Argent Dawn"]="Argent Dawn",
		["Argent Dawn Commission"]="Argent Dawn Commission",
		["Armageddon"]="Armageddon",
		["Armor"]="Armor",
		["Armor of Faith"]="Armor of Faith",
		["Armor Shatter"]="Armor Shatter",
		["Armorsmith"]="Armorsmith",
		["Arugal's Curse"]="Arugal's Curse",
		["Arugal's Gift"]="Arugal's Gift",
		["Ascendance"]="Ascendance",
		["Ashbringer"]="Ashbringer",
		["Aspect of Arlokk"]="Aspect of Arlokk",
		["Aspect of Jeklik"]="Aspect of Jeklik",
		["Aspect of Mar'li"]="Aspect of Mar'li",
		["Aspect of the Beast"]="Aspect of the Beast",
		["Aspect of the Cheetah"]="Aspect of the Cheetah",
		["Aspect of the Hawk"]="Aspect of the Hawk",
		["Aspect of the Monkey"]="Aspect of the Monkey",
		["Aspect of the Pack"]="Aspect of the Pack",
		["Aspect of the Wild"]="Aspect of the Wild",
		["Aspect of Venoxis"]="Aspect of Venoxis",
		["Astral Recall"]="Astral Recall",
		["Attack"]="Attack",
		["Attacking"]="Attacking",
		["Attuned Dampener"]="Attuned Dampener",
		["Aura of Command"]="Aura of Command",
		["Aura of Fear"]="Aura of Fear",
		["Aura of Rot"]="Aura of Rot",
		["Aura of the Blue Dragon"]="Aura of the Blue Dragon",
		["Aural Shock"]="Aural Shock",
		["Auto Shot"]="Auto Shot",
		["Axe Flurry"]="Axe Flurry",
		["Axe Toss"]="Axe Toss",
		["Axe Specialization"]="Axe Specialization",
		["Aynasha's Arrow"]="Aynasha's Arrow",
		["Aynasha's Bow"]="Aynasha's Bow",
		["Aynasha's Root"]="Aynasha's Root",
		["Backhand"]="Backhand",
		["Backstab"]="Backstab",
		["Badge of the Swarmguard"]="Badge of the Swarmguard",
		["Bane"]="Bane",
		["Baneful Poison"]="Baneful Poison",
		["Banish"]="Banish",
		["Banshee Curse"]="Banshee Curse",
		["Banshee Shriek"]="Banshee Shriek",
		["Pain Suppression"] = "Pain Suppression",
		["Barbed Sting"]="Barbed Sting",
		["Barkskin Effect"]="Barkskin Effect",
		["Barkskin"]="Barkskin",
		["Barrage"]="Barrage",
		["Bash"]="Bash",
		["Basic Campfire"]="Basic Campfire",
		["Basilisk Skin"]="Basilisk Skin",
		["Bat Costume"]="Bat Costume",
		["Battle Fury"]="Battle Fury",
		["Battle Shout"]="Battle Shout",
		["Battle Stance Passive"]="Battle Stance Passive",
		["Battle Squawk"]="Battle Squawk",
		["Battle Stance"]="Battle Stance",
		["Battle Standard"]="Battle Standard",
		["Battlegear of Eternal Justice"]="Battlegear of Eternal Justice",
		["Battlegear of Might"]="Battlegear of Might",
		["Bear Form"]="Bear Form",
		["Beast Lore"]="Beast Lore",
		["Beast Slaying"]="Beast Slaying",
		["Beast Training"]="Beast Training",
		["Befuddlement"]="Befuddlement",
		["Benediction"]="Benediction",
		["Berserker Charge"]="Berserker Charge",
		["Berserker Rage"]="Berserker Rage",
		["Berserker Stance Passive"]="Berserker Stance Passive",
		["Berserker Stance"]="Berserker Stance",
		["Berserking"]="Berserking",
		["Bestial Discipline"]="Bestial Discipline",
		["Bestial Swiftness"]="Bestial Swiftness",
		["Bestial Wrath"]="Bestial Wrath",
		["Big Bronze Bomb"]="Big Bronze Bomb",
		["Big Iron Bomb"]="Big Iron Bomb",
		["Biletoad Infection"]="Biletoad Infection",
		["Bite"]="Bite",
		["Black Arrow"]="Black Arrow",
		["Blackout"]="Blackout",
		["Blacksmithing"]="Blacksmithing",
		["Blade Flurry"]="Blade Flurry",
		["Bladestorm"]="Bladestorm",
		["Blast Wave"]="Blast Wave",
		["Blaze"]="Blaze",
		["Blazing Emblem"]="Blazing Emblem",
		["Blessed Recovery"]="Blessed Recovery",
		["Blessed Sunfruit"]="Blessed Sunfruit",
		["Blessed Sunfruit Juice"]="Blessed Sunfruit Juice",
		["Blessing of Blackfathom"]="Blessing of Blackfathom",
		["Blessing of Freedom"]="Blessing of Freedom",
		["Blessing of Kings"]="Blessing of Kings",
		["Blessing of Light"]="Blessing of Light",
		["Blessing of Might"]="Blessing of Might",
		["Blessing of Protection"]="Blessing of Protection",
		["Blessing of Sacrifice"]="Blessing of Sacrifice",
		["Blessing of Salvation"]="Blessing of Salvation",
		["Blessing of Sanctuary"]="Blessing of Sanctuary",
		["Blessing of Shahram"]="Blessing of Shahram",
		["Blessing of the Black Book"]="Blessing of the Black Book",
		["Blessing of the Claw"]="Blessing of the Claw",
		["Blessing of Wisdom"]="Blessing of Wisdom",
		["Blight"]="Blight",
		["Blind"]="Blind",
		["Blinding Light"]="Blinding Light",
		["Blinding Powder"]="Blinding Powder",
		["Blink"]="Blink",
		["Blizzard"]="Blizzard",
		["Block"]="Block",
		["Blood Craze"]="Blood Craze",
		["Blood Frenzy"]="Blood Frenzy",
		["Blood Funnel"]="Blood Funnel",
		["Blood Fury"]="Blood Fury",
		["Blood Leech"]="Blood Leech",
		["Blood Pact"]="Blood Pact",
		["Bloodpetal Poison"]="Blood Pact",
		["Waterbolt"] =	"Waterbolt",
		["Blood Siphon"]="Blood Siphon",
		["Blood Tap"]="Blood Tap",
		["Bloodfang"]="Bloodfang",
		["Bloodpetal Poison"]="Bloodpetal Poison",
		["Bloodrage"]="Bloodrage",
		["Bloodthirst"]="Bloodthirst",
		["Boar Charge"]="Boar Charge",
		["Bomb"]="Bomb",
		["Summon Water Elemental"] = "Summon Water Elemental",
		["Bone Armor"]="Bone Armor",
		["Bonereaver's Edge"]="Bonereaver's Edge",
		["Bonespike"]="Bonespike",
		["Booming Voice"]="Booming Voice",
		["Bottle of Poison"]="Bottle of Poison",
		["Boulder"]="Boulder",
		["Bow Specialization"]="Bow Specialization",
		["Bows"]="Bows",
		["Brain Damage"]="Brain Damage",
		["Brain Food"]="Brain Food",
		["Brain Hacker"]="Brain Hacker",
		["Brain Wash"]="Brain Wash",
		["Breath of Fire"]="Breath of Fire",
		["Bright Campfire"]="Bright Campfire",
		["Brilliant Light"]="Brilliant Light",
		["Brittle Armor"]="Brittle Armor",
		["Brutal Impact"]="Brutal Impact",
		["Burning Soul"]="Burning Soul",
		["Burst of Energy"]="Burst of Energy",
		["Burst of Knowledge"]="Burst of Knowledge",
		["Butcher Drain"]="Butcher Drain",
		["Buttermilk Delight"]="Buttermilk Delight",
		["Cadaver Worms"]="Cadaver Worms",
		["Call Pet"]="Call Pet",
		["Call of Flame"]="Call of Flame",
		["Call of the Grave"]="Call of the Grave",
		["Call of Thunder"]="Call of Thunder",
		["Camouflage"]="Camouflage",
		["Cannibalize"]="Cannibalize",
		["Cannon Fire"]="Cannon Fire",
		["Cat Form"]="Cat Form",
		["Cataclysm"]="Cataclysm",
		["Cause Insanity"]="Cause Insanity",
		["Cauterizing Flames"]="Cauterizing Flames",
		["Cenarion Favor"]="Cenarion Favor",
		["Chain Bolt"]="Chain Bolt",
		["Chain Burn"]="Chain Burn",
		["Chain Heal"]="Chain Heal",
		["Chain Healing Wave"]="Chain Healing Wave",
		["Chain Lightning"]="Chain Lightning",
		["Chained Bolt"]="Chained Bolt",
		["Chains of Ice"]="Chains of Ice",
		["Shield Bash - Silenced"] = "Shield Bash - Silenced",
		["Challenging Roar"]="Challenging Roar",
		["Challenging Shout"]="Challenging Shout",
		["Champion of the Dawn"]="Champion of the Dawn",
		["Chaos Fire"]="Chaos Fire",
		["Charge Rage Bonus Effect"]="Charge Rage Bonus Effect",
		["Charge"]="Charge",
		["Charge Stun"]="Charge Stun",
		["Cheap Shot"]="Cheap Shot",
		["Cheat Death"]="Cheat Death",
		["Chicken Fury"]="Chicken Fury",
		["Chilled"]="Chilled",
		["Chilling Touch"]="Chilling Touch",
		["Chitinous Spikes"]="Chitinous Spikes",
		["Chromatic Infusion"]="Chromatic Infusion",
		["Chromatic Resistance"]="Chromatic Resistance",
		["Circle of Flame"]="Circle of Flame",
		["Claw"]="Claw",
		["Claw Grasp"]="Claw Grasp",
		["Clean Escape"]="Clean Escape",
		["Cleanse"]="Cleanse",
		["Cleanse Nova"]="Cleanse Nova",
		["Clearcasting"]="Clearcasting",
		["Cleave"]="Cleave",
		["Cleave Armor"]="Cleave Armor",
		["Clever Traps"]="Clever Traps",
		["Cloak of Fire"]="Cloak of Fire",
		["Cloaking"]="Cloaking",
		["Closing"]="Closing",
		["Cloth"]="Cloth",
		["Coarse Dynamite"]="Coarse Dynamite",
		["Coarse Sharpening Stone"]="Coarse Sharpening Stone",
		["Cobra Reflexes"]="Cobra Reflexes",
		["Cold Blood"]="Cold Blood",
		["Cold Eye"]="Cold Eye",
		["Cold Snap"]="Cold Snap",
		["Cologne"]="Cologne",
		["Combat Endurance"]="Combat Endurance",
		["Combustion"]="Combustion",
		["Command"]="Command",
		["Concentration Aura"]="Concentration Aura",
		["Concussion Blow"]="Concussion Blow",
		["Concussion"]="Concussion",
		["Concussive Shot"]="Concussive Shot",
		["Cone of Cold"]="Cone of Cold",
		["Cone of Fire"]="Cone of Fire",
		["Conflagrate"]="Conflagrate",
		["Conjure Food"]="Conjure Food",
		["Conjure Mana Agate"]="Conjure Mana Agate",
		["Conjure Mana Citrine"]="Conjure Mana Citrine",
		["Conjure Mana Jade"]="Conjure Mana Jade",
		["Conjure Mana Ruby"]="Conjure Mana Ruby",
		["Conjure Water"]="Conjure Water",
		["Consecrated Sharpening Stone"]="Consecrated Sharpening Stone",
		["Consecration"]="Consecration",
		["Consume Flesh"]="Consume Flesh",
		["Consume Shadows"]="Consume Shadows",
		["Consuming Shadows"]="Consuming Shadows",
		["Contagion of Rot"]="Contagion of Rot",
		["Control Machine"]="Control Machine",
		["Convection"]="Convection",
		["Conviction"]="Conviction",
		["Cooking"]="Cooking",
		["Corrosive Acid Breath"]="Corrosive Acid Breath",
		["Corrosive Ooze"]="Corrosive Ooze",
		["Corrosive Poison"]="Corrosive Poison",
		["Corrupted Blood"]="Corrupted Blood",
		["Corrupted Intellect"]="Corrupted Intellect",
		["Corrupted Fear"]="Corrupted Fear",
		["Corruption"]="Corruption",
		["Counterattack"]="Counterattack",
		["Counterspell"]="Counterspell",
		["Cower"]="Cower",
		["Cozy Fire"]="Cozy Fire",
		["Crazed"]="Crazed",
		["Create Firestone"]="Create Firestone",
		["Create Healthstone"]="Create Healthstone",
		["Create Soulstone"]="Create Soulstone",
		["Create Spellstone"]="Create Spellstone",
		["Creeper Venom"]="Creeper Venom",
		["Creeping Mold"]="Creeping Mold",
		["Crest of Retribution"]="Crest of Retribution",
		["Cripple"]="Cripple",
		["Crippling Poison II"]="Crippling Poison II",
		["Crippling Poison"]="Crippling Poison",
		["Critical Mass"]="Critical Mass",
		["Crossbows"]="Crossbows",
		["Crowd Pummel"]="Crowd Pummel",
		["Shamanistic Rage"] = "Shamanistic Rage",
		["Cruelty"]="Cruelty",
		["Crusader Strike"]="Crusader Strike",
		["Crusader's Wrath"]="Crusader's Wrath",
		["Crystal Charge"]="Crystal Charge",
		["Crystal Force"]="Crystal Force",
		["Crystal of Zin-Malor"]="Crystal of Zin-Malor",
		["Crystal Restore"]="Crystal Restore",
		["Crystal Spire"]="Crystal Spire",
		["Crystal Ward"]="Crystal Ward",
		["Crystal Yield"]="Crystal Yield",
		["Crystalline Slumber"]="Crystalline Slumber",
		["Cultivation"]="Cultivation",
		["Cure Disease"]="Cure Disease",
		["Ice Lance"] = "Ice Lance",
		["Cure Poison"]="Cure Poison",
		["Curse of Agony"]="Curse of Agony",
		["Curse of Blood"]="Curse of Blood",
		["Curse of Doom Effect"]="Curse of Doom Effect",
		["Curse of Doom"]="Curse of Doom",
		["Curse of Exhaustion"]="Curse of Exhaustion",
		["Curse of Idiocy"]="Curse of Idiocy",
		["Curse of Mending"]="Curse of Mending",
		["Curse of Recklessness"]="Curse of Recklessness",
		["Curse of Shadow"]="Curse of Shadow",
		["Curse of Shahram"]="Curse of Shahram",
		["Curse of Stalvan"]="Curse of Stalvan",
		["Curse of the Elemental Lord"]="Curse of the Elemental Lord",
		["Curse of the Fallen Magram"]="Curse of the Fallen Magram",
		["Curse of Thorns"]="Curse of Thorns",
		["Curse of Thule"]="Curse of Thule",
		["Curse of Timmy"]="Curse of Timmy",
		["Curse of Tongues"]="Curse of Tongues",
		["Curse of Tuten'kash"]="Curse of Tuten'kash",
		["Curse of Weakness"]="Curse of Weakness",
		["Curse of the Elements"]="Curse of the Elements",
		["Cursed Blood"]="Cursed Blood",
		["Dagger Specialization"]="Dagger Specialization",
		["Daggers"]="Daggers",
		["Damage Absorb"]="Damage Absorb",
		["Dampen Magic"]="Dampen Magic",
		["Dark Desire"]="Dark Desire",
		["Dark Iron Bomb"]="Dark Iron Bomb",
		["Dark Mending"]="Dark Mending",
		["Dark Offering"]="Dark Offering",
		["Dark Pact"]="Dark Pact",
		["Dark Rune"]="Dark Rune",
		["Dark Sludge"]="Dark Sludge",
		["Dark Strike"]="Dark Strike",
		["Darken Vision"]="Darken Vision",
		["Darkness"]="Darkness",
		["Darnassus Gift of Friendship"]="Darnassus Gift of Friendship",
		["Dash"]="Dash",
		["Daunting Growl"]="Daunting Growl",
		["Dazed"]="Dazed",
		["Deadly Poison II"]="Deadly Poison II",
		["Deadly Poison III"]="Deadly Poison III",
		["Deadly Poison IV"]="Deadly Poison IV",
		["Deadly Poison V"]="Deadly Poison V",
		["Deadly Poison"]="Deadly Poison",
		["Deadmines Dynamite"]="Deadmines Dynamite",
		["Deafening Screech"]="Deafening Screech",
		["Death Coil"]="Death Coil",
		["Death Wish"]="Death Wish",
		["Decapitate"]="Decapitate",
		["Decayed Agility"]="Decayed Agility",
		["Decayed Strength"]="Decayed Strength",
		["Deep Sleep"]="Deep Sleep",
		["Deep Slumber"]="Deep Slumber",
		["Deep Wound"]="Deep Wound",
		["Deep Wounds"]="Deep Wounds",
		["Defense"]="Defense",
		["Defensive Stance Passive"]="Defensive Stance Passive",
		["Defensive Stance"]="Defensive Stance",
		["Defensive State 2"]="Defensive State 2",
		["Defensive State"]="Defensive State",
		["Defiance"]="Defiance",
		["Defibrillate"]="Defibrillate",
		["Deflection"]="Deflection",
		["Delusions of Jin'do"]="Delusions of Jin'do",
		["Demon Armor"]="Demon Armor",
		["Demon Skin"]="Demon Skin",
		["Demonfork"]="Demonfork",
		["Demonic Embrace"]="Demonic Embrace",
		["Demonic Rune"]="Demonic Rune",
		["Demonic Sacrifice"]="Demonic Sacrifice",
		["Demoralizing Roar"]="Demoralizing Roar",
		["Demoralizing Shout"]="Demoralizing Shout",
		["Dense Dynamite"]="Dense Dynamite",
		["Dense Sharpening Stone"]="Dense Sharpening Stone",
		["Desperate Prayer"]="Desperate Prayer",
		["Destiny"]="Destiny",
		["Kick - Silenced"] = "Kick - Silenced",
		["Destructive Reach"]="Destructive Reach",
		["Detect Demon"]="Detect Demon",
		["Detect Greater Invisibility"]="Detect Greater Invisibility",
		["Detect Invisibility"]="Detect Invisibility",
		["Detect Lesser Invisibility"]="Detect Lesser Invisibility",
		["Detect Magic"]="Detect Magic",
		["Detect Traps"]="Detect Traps",
		["Detect Undead"]="Detect Undead",
		["Detect"]="Detect",
		["Deterrence"]="Deterrence",
		["Detonation"]="Detonation",
		["Devastation"]="Devastation",
		["Devilsaur Fury"]="Devilsaur Fury",
		["Devotion Aura"]="Devotion Aura",
		["Devour Magic Effect"]="Devour Magic Effect",
		["Devour Magic"]="Devour Magic",
		["Devouring Plague"]="Devouring Plague",
		["Diamond Flask"]="Diamond Flask",
		["Dim Sum"]="Dim Sum",
		["Dimensional Siphon"]="Dimensional Siphon",
		["Diplomacy"]="Diplomacy",
		["Dire Bear Form"]="Dire Bear Form",
		["Dire Growl"]="Dire Growl",
		["Disarm Trap"]="Disarm Trap",
		["Disarm"]="Disarm",
		["Discombobulate"]="Discombobulate",
		["Disease Cleansing Totem"]="Disease Cleansing Totem",
		["Disease Cloud"]="Disease Cloud",
		["Disease Touch"]="Disease Touch",
		["Seed of Corruption"] = "Seed of Corruption",
		["Diseased Shot"]="Diseased Shot",
		["Diseased Spit"]="Diseased Spit",
		["Disenchant"]="Disenchant",
		["Disengage"]="Disengage",
		["Disjunction"]="Disjunction",
		["Dismiss Pet"]="Dismiss Pet",
		["Dispel Magic"]="Dispel Magic",
		["Dispel Poison"]="Dispel Poison",
		["Distilled Wisdom"]="Distilled Wisdom",
		["Distract"]="Distract",
		["Distracting Pain"]="Distracting Pain",
		["Distracting Shot"]="Distracting Shot",
		["Dive"]="Dive",
		["Divine Favor"]="Divine Favor",
		["Divine Fury"]="Divine Fury",
		["Divine Intellect"]="Divine Intellect",
		["Divine Intervention"]="Divine Intervention",
		["Divine Protection"]="Divine Protection",
		["Divine Shield"]="Divine Shield",
		["Divine Spirit"]="Divine Spirit",
		["Divine Strength"]="Divine Strength",
		["Diving Sweep"]="Diving Sweep",
		["Dodge"]="Dodge",
		["Dominate Mind"]="Dominate Mind",
		["Dragonbreath Chili"]="Dragonbreath Chili",
		["Dragonscale Leatherworking"]="Dragonscale Leatherworking",
		["Dragon's Call"]="Dragon's Call",
		["Drain Life"]="Drain Life",
		["Drain Mana"]="Drain Mana",
		["Kill Command"] = "Kill Command",
		["Drain Soul"]="Drain Soul",
		["Draw of Thistlenettle"]="Draw of Thistlenettle",
		["Dreamless Sleep"]="Dreamless Sleep",
		["Dream Vision"]="Dream Vision",
		["Dredge Sickness"]="Dredge Sickness",
		["Drink"]="Drink",
		["Drink Minor Potion"]="Drink Minor Potion",
		["Druid's Slumber"]="Druid's Slumber",
		["Dual Wield Specialization"]="Dual Wield Specialization",
		["Dual Wield"]="Dual Wield",
		["Duel"]="Duel",
		["Healing Way"]="Healing Way",
		["Dust Cloud"]="Dust Cloud",
		["Dust Field"]="Dust Field",
		["Eagle Eye"]="Eagle Eye",
		["Earth Shock"]="Earth Shock",
		["Earthbind"]="Earthbind",
		["Earthbind Totem"]="Earthbind Totem",
		["Earthborer Acid"]="Earthborer Acid",
		["Earthgrab"]="Earthgrab",
		["Earthshaker"]="Earthshaker",
		["Earthstrike"]="Earthstrike",
		["Earthquake"]="Earthquake",
		["Echeyakee's Grace"]="Echeyakee's Grace",
		["Efficiency"]="Efficiency",
		["Elderberry Pie"]="Elderberry Pie",
		["Electric Discharge"]="Electric Discharge",
		["Electrified Net"]="Electrified Net",
		["Elemental Focus"]="Elemental Focus",
		["Elemental Fury"]="Elemental Fury",
		["Elemental Leatherworking"]="Elemental Leatherworking",
		["Elemental Mastery"]="Elemental Mastery",
		["Elemental Protection"]="Elemental Protection",
		["Elemental Sharpening Stone"]="Elemental Sharpening Stone",
		["Elemental Vulnerability"]="Elemental Vulnerability",
		["Elixir of Brute Force"]="Elixir of Brute Force",
		["Elixir of Demonslaying"]="Elixir of Demonslaying",
		["Elixir of Dodging"]="Elixir of Dodging",
		["Elixir of Resistance"]="Elixir of Resistance",
		["Elixir of the Giants"]="Elixir of the Giants",
		["Elixir of the Mongoose"]="Elixir of the Mongoose",
		["Elixir of the Sages"]="Elixir of the Sages",
		["Elune's Blessing"]="Elune's Blessing",
		["Elune's Candle"]="Elune's Candle",
		["Elune's Grace"]="Elune's Grace",
		["Elusiveness"]="Elusiveness",
		["Emberstorm"]="Emberstorm",
		["Enchanted Quickness"]="Enchanted Quickness",
		["Enchanting"]="Enchanting",
		["Endurance Training"]="Endurance Training",
		["Endurance"]="Endurance",
		["Energized Shield"]="Energized Shield",
		["Engineering Specialization"]="Engineering Specialization",
		["Engineering"]="Engineering",
		["Engulfing Shadows"]="Engulfing Shadows",
		["Enigma's Answer"]="Enigma's Answer",
		["Enlarge"]="Enlarge",
		["Enrage"]="Enrage",
		["Enraging Memories"]="Enraging Memories",
		["Enriched Manna Biscuit"]="Enriched Manna Biscuit",
		["Enslave Demon"]="Enslave Demon",
		["Entangle"]="Entangle",
		["Entangling Roots"]="Entangling Roots",
		["Entrapment"]="Entrapment",
		["Enveloping Web"]="Enveloping Web",
		["Enveloping Webs"]="Enveloping Webs",
		["Enveloping Winds"]="Enveloping Winds",
		["Ephemeral Power"]="Ephemeral Power",
		["Epiphany"]="Epiphany",
		["Escape Artist"]="Escape Artist",
		["Eskhandar's Rage"]="Eskhandar's Rage",
		["Eskhandar's Rake"]="Eskhandar's Rake",
		["Essence of Sapphiron"]="Essence of Sapphiron",
		["Evasion"]="Evasion",
		["Eventide"]="Eventide",
		["Evil Twin"]="Evil Twin",
		["Eviscerate"]="Eviscerate",
		["Evocation"]="Evocation",
		["Execute"]="Execute",
		["Exorcism"]="Exorcism",
		["Expansive Mind"]="Expansive Mind",
		["Explode"]="Explode",
		["Exploding Shot"]="Exploding Shot",
		["Exploit Weakness"]="Exploit Weakness",
		["Explosion"]="Explosion",
		["Explosive Sheep"]="Explosive Sheep",
		["Explosive Shot"]="Explosive Shot",
		["Explosive Trap Effect"]="Explosive Trap Effect",
		["Explosive Trap"]="Explosive Trap",
		["Expose Armor"]="Expose Armor",
		["Expose Weakness"] = "Expose Weakness",
		["Eye for an Eye"]="Eye for an Eye",
		["Eye of Kilrogg"]="Eye of Kilrogg",
		["Eyes of the Beast"]="Eyes of the Beast",
		["Ez-Thro Dynamite"]="Ez-Thro Dynamite",
		["Fade"]="Fade",
		["Faerie Fire"]="Faerie Fire",
		["Faerie Fire (Feral)"]="Faerie Fire (Feral)",
		["Fanatic Blade"]="Fanatic Blade",
		["Fanatic Blade Effect"]="Fanatic Blade Effect",
		["Fang of the Crystal Spider"]="Fang of the Crystal Spider",
		["Far Sight"]="Far Sight",
		["Fatal Bite"]="Fatal Bite",
		["Fatal Wound"]="Fatal Wound",
		["Fear Ward"]="Fear Ward",
		["Fear"]="Fear",
		["Fearless"]="Fearless",
		["Feed Pet"]="Feed Pet",
		["Feed Pet Effect"]="Feed Pet Effect",
		["Feedback"]="Feedback",
		["Feign Death"]="Feign Death",
		["Feint"]="Feint",
		["Fel Concentration"]="Fel Concentration",
		["Fel Domination"]="Fel Domination",
		["Fel Intellect"]="Fel Intellect",
		["Fel Stamina"]="Fel Stamina",
		["Fel Stomp"]="Fel Stomp",
		["Felfire"]="Felfire",
		["Feline Grace"]="Feline Grace",
		["Feline Swiftness"]="Feline Swiftness",
		["Felstriker"]="Felstriker",
		["Felstrom Resurrection"]="Felstrom Resurrection",
		["Feral Aggression"]="Feral Aggression",
		["Feral Charge"]="Feral Charge",
		["Feral Instinct"]="Feral Instinct",
		["Ferocious Bite"]="Ferocious Bite",
		["Quick Shots"] = "Quick Shots",
		["Ferocity"]="Ferocity",
		["Festival Fortune!"]="Festival Fortune\33",
		["Fetish"]="Fetish",
		["Fevered Fatigue"]="Fevered Fatigue",
		["Fevered Plague"]="Fevered Plague",
		["Fiend Fury"]="Fiend Fury",
		["Fiery Aura"]="Fiery Aura",
		["Fiery Blaze"]="Fiery Blaze",
		["Fiery Burst"]="Fiery Burst",
		["Fiery Weapon"]="Fiery Weapon",
		["Find Herbs"]="Find Herbs",
		["Find Minerals"]="Find Minerals",
		["Find Treasure"]="Find Treasure",
		["Fire Blast"]="Fire Blast",
		["Fire Blossom"]="Fire Blossom",
		["Fire Festival Fortitude"]="Fire Festival Fortitude",
		["Fire Festival Fury"]="Fire Festival Fury",
		["Fire Nova"]="Fire Nova",
		["Fire Nova Totem"]="Fire Nova Totem",
		["Fire Power"]="Fire Power",
		["Fire Protection"]="Fire Protection",
		["Fire Reflector"]="Fire Reflector",
		["Fire Resistance Aura"]="Fire Resistance Aura",
		["Fire Resistance Totem"]="Fire Resistance Totem",
		["Fire Resistance"]="Fire Resistance",
		["Fire Shield"]="Fire Shield",
		["Fire Shield II"]="Fire Shield II",
		["Fire Shield Effect"]="Fire Shield Effect",
		["Fire Shield Effect II"]="Fire Shield Effect II",
		["Fire Shield Effect III"]="Fire Shield Effect III",
		["Fire Shield Effect IV"]="Fire Shield Effect IV",
		["Enamored Water Spirit"] = "Enamored Water Spirit",
		["Fire Shot"]="Fire Shot",
		["Fire Storm"]="Fire Storm",
		["Fire Strike"]="Fire Strike",
		["Fire Vulnerability"]="Fire Vulnerability",
		["Fire Ward"]="Fire Ward",
		["Fireball"]="Fireball",
		["Fireball Volley"]="Fireball Volley",
		["Firebolt"]="Firebolt",
		["Fire-toasted Bun"]="Fire-toasted Bun",
		["Fire's Glow"]="Fire's Glow",
		["First Aid"]="First Aid",
		["Fishing Poles"]="Fishing Poles",
		["Snake Trap"] = "Snake Trap",
		["Fishing"]="Fishing",
		["Fishliver Oil"]="Fishliver Oil",
		["Fist of Ragnaros"]="Fist of Ragnaros",
		["Fist of Shahram"]="Fist of Shahram",
		["Fist of Stone"]="Fist of Stone",
		["Fist Weapon Specialization"]="Fist Weapon Specialization",
		["Fist Weapons"]="Fist Weapons",
		["Fixate"]="Fixate",
		["Flame Blast"]="Flame Blast",
		["Flame Breath"]="Flame Breath",
		["Flame Buffet"]="Flame Buffet",
		["Flame Cannon"]="Flame Cannon",
		["Flame Lash"]="Flame Lash",
		["Flame Shock"]="Flame Shock",
		["Flame Spear"]="Flame Spear",
		["Flame Spike"]="Flame Spike",
		["Flame Spray"]="Flame Spray",
		["Flame Throwing"]="Flame Throwing",
		["Flame Wrath"]="Flame Wrath",
		["Flames of Shahram"]="Flames of Shahram",
		["Flameshocker's Revenge"]="Flameshocker's Revenge",
		["Flameshocker's Touch"]="Flameshocker's Touch",
		["Flamestrike"]="Flamestrike",
		["Flamethrower"]="Flamethrower",
		["Flametongue Attack"]="Flametongue Attack",
		["Flametongue Totem"]="Flametongue Totem",
		["Flametongue Weapon"]="Flametongue Weapon",
		["Flaming Cannonball"]="Flaming Cannonball",
		["Flaming Shell"]="Flaming Shell",
		["Flare"]="Flare",
		["Shadowfury"] = "Shadowfury",
		["Flash Bomb"]="Flash Bomb",
		["Flash Heal"]="Flash Heal",
		["Flash of Light"]="Flash of Light",
		["Flask of the Titans"]="Flask of the Titans",
		["Flaying Vine"]="Flaying Vine",
		["Flee"]="Flee",
		["Flip Out"]="Flip Out",
		["Flurry"]="Flurry",
		["Remorseless"] = "Remorseless",
		["Focused Casting"]="Focused Casting",
		["Focus"]="Focus",
		["Food"]="Food",
		["Forbearance"]="Forbearance",
		["Force of Will"]="Force of Will",
		["Force Punch"]="Force Punch",
		["Force Reactive Disk"]="Force Reactive Disk",
		["Forcefield Collapse"]="Forcefield Collapse",
		["Forked Lightning"]="Forked Lightning",
		["Form of the Moonstalker"]="Form of the Moonstalker",
		["Forsaken Skills"]="Forsaken Skills",
		["Frailty"]="Frailty",
		["Freeze Solid"]="Freeze Solid",
		["Freeze"]="Freeze",
		["Free Action"]="Free Action",
		["Freezing Trap Effect"]="Freezing Trap Effect",
		["Freezing Trap"]="Freezing Trap",
		["Frenzied Command"]="Frenzied Command",
		["Frenzied Regeneration"]="Frenzied Regeneration",
		["Frenzy"]="Frenzy",
		["Frightalon"]="Frightalon",
		["Frost Armor"]="Frost Armor",
		["Frost Arrow"]="Frost Arrow",
		["Frost Blast"]="Frost Blast",
		["Frost Breath"]="Frost Breath",
		["Frost Channeling"]="Frost Channeling",
		["Frost Nova"]="Frost Nova",
		["Victory Rush"] = "Victory Rush",
		["Frost Power"]="Frost Power",
		["Frost Protection"]="Frost Protection",
		["Frost Reflector"]="Frost Reflector",
		["Frost Resistance Aura"]="Frost Resistance Aura",
		["Shadow Word: Death"] = "Shadow Word: Death",
		["Frost Resistance Totem"]="Frost Resistance Totem",
		["Frost Resistance"]="Frost Resistance",
		["Frost Shock"]="Frost Shock",
		["Frost Shot"]="Frost Shot",
		["Frost Trap"]="Frost Trap",
		["Frost Trap Aura"]="Frost Trap Aura",
		["Frost Ward"]="Frost Ward",
		["Frostbite"]="Frostbite",
		["Frostbolt"]="Frostbolt",
		["Frostbolt Volley"]="Frostbolt Volley",
		["Frostbrand Weapon"]="Frostbrand Weapon",
		["Frostmane Strength"]="Frostmane Strength",
		["Frosty Zap"]="Frosty Zap",
		["Fumble"]="Fumble",
		["Furbolg Form"]="Furbolg Form",
		["Furbolg Medicine Pouch"]="Furbolg Medicine Pouch",
		["Furious Howl"]="Furious Howl",
		["Furor"]="Furor",
		["Fury of Forgewright"]="Fury of Forgewright",
		["Fury of Ragnaros"]="Fury of Ragnaros",
		["Fury of the Bogling"]="Fury of the Bogling",
		["Gahz'ranka Slam"]="Gahz'ranka Slam",
		["Gahz'rilla Slam"]="Gahz'rilla Slam",
		["Garrote"]="Garrote",
		["Gehennas' Curse"]="Gehennas' Curse",
		["Generic"]="Generic",
		["Geyser"]="Geyser",
		["Ghost Costume"]="Ghost Costume",
		["Ghost Wolf"]="Ghost Wolf",
		["Ghostly Strike"]="Ghostly Strike",
		["Gift of Arthas"]="Gift of Arthas",
		["Gift of Life"]="Gift of Life",
		["Gift of Nature"]="Gift of Nature",
		["Gift of Stone"]="Gift of Stone",
		["Gift of the Wild"]="Gift of the Wild",
		["Glacial Roar"]="Glacial Roar",
		["Glimpse of Madness"]="Glimpse of Madness",
		["Glyph of Deflection"]="Glyph of Deflection",
		["Gnarlpine Vengeance"]="Gnarlpine Vengeance",
		["Gnomish Death Ray"]="Gnomish Death Ray",
		["Gnomish Rocket Boots"]="Gnomish Rocket Boots",
		["Goblin Bomb"]="Goblin Bomb",
		["Goblin Dragon Gun"]="Goblin Dragon Gun",
		["Goblin Mortar"]="Goblin Mortar",
		["Goblin Rocket Boots"]="Goblin Rocket Boots",
		["Goblin Sapper Charge"]="Goblin Sapper Charge",
		["Gordok Green Grog"]="Gordok Green Grog",
		["Gordok Ogre Suit"]="Gordok Ogre Suit",
		["Gouge"]="Gouge",
		["Grab Weapon"]="Grab Weapon",
		["Grace of Air Totem"]="Grace of Air Totem",
		["Grace of Earth"]="Grace of Earth",
		["Grasping Vines"]="Grasping Vines",
		["Great Rage"]="Great Rage",
		["Great Stamina"]="Great Stamina",
		["Greater Agility"]="Greater Agility",
		["Greater Arcane Elixir"]="Greater Arcane Elixir",
		["Greater Armor"]="Greater Armor",
		["Greater Blessing of Kings"]="Greater Blessing of Kings",
		["Greater Blessing of Light"]="Greater Blessing of Light",
		["Greater Blessing of Might"]="Greater Blessing of Might",
		["Greater Blessing of Salvation"]="Greater Blessing of Salvation",
		["Greater Blessing of Sanctuary"]="Greater Blessing of Sanctuary",
		["Greater Blessing of Wisdom"]="Greater Blessing of Wisdom",
		["Greater Dreamless Sleep"]="Greater Dreamless Sleep",
		["Greater Firepower"]="Greater Firepower",
		["Greater Heal"]="Greater Heal",
		["Greater Healthstone"]="Greater Healthstone",
		["Greater Intellect"]="Greater Intellect",
		["Greater Mark of the Dawn"]="Greater Mark of the Dawn",
		["Greater Stoneshield"]="Greater Stoneshield",
		["Greater Water Breathing"]="Greater Water Breathing",
		["Grim Reach"]="Grim Reach",
		["Ground Stomp"]="Ground Stomp",
		["Ground Tremor"]="Ground Tremor",
		["Grounding Totem"]="Grounding Totem",
		["Grovel"]="Grovel",
		["Grow"]="Grow",
		["Growl"]="Growl",
		["Guardian Effect"]="Guardian Effect",
		["Guardian's Favor"]="Guardian's Favor",
		["Guile of the Raptor"]="Guile of the Raptor",
		["Guillotine"]="Guillotine",
		["Gun Specialization"]="Gun Specialization",
		["Guns"]="Guns",
		["Gust of Wind"]="Gust of Wind",
		["Gutgore Ripper"]="Gutgore Ripper",
		["Hail Storm"]="Hail Storm",
		["Hallow's End Aura"]="Hallow's End Aura",
		["Hallow's End Candy"]="Hallow's End Candy",
		["Hallow's End Fright"]="Hallow's End Fright",
		["Hammer of Justice"]="Hammer of Justice",
		["Hammer of Wrath"]="Hammer of Wrath",
		["Hamstring"]="Hamstring",
		["Hand of Ragnaros"]="Hand of Ragnaros",
		["Harass"]="Harass",
		["Hardiness"]="Hardiness",
		["Harm Prevention Belt"]="Harm Prevention Belt",
		["Haste"]="Haste",
		["Haunting Spirits"]="Haunting Spirits",
		["Hawk Eye"]="Hawk Eye",
		["Head Butt"]="Head Butt",
		["Head Crack"]="Head Crack",
		["Head Rush"]="Head Rush",
		["Headmaster's Charge"]="Headmaster's Charge",
		["Heal"]="Heal",
		["Heal Pet"]="Heal Pet",
		["Heal Self"]="Heal Self",
		["Healing Circle"]="Healing Circle",
		["Healing Draught"]="Healing Draught",
		["Healing Focus"]="Healing Focus",
		["Healing Light"]="Healing Light",
		["Healing Potion"]="Healing Potion",
		["Healing Stream Totem"]="Healing Stream Totem",
		["Healing Touch"]="Healing Touch",
		["Healing Wave"]="Healing Wave",
		["Health"]="Health",
		["Health II"]="Health II",
		["Health Funnel"]="Health Funnel",
		["Health Regeneration"]="Health Regeneration",
		["Healthstone"]="Healthstone",
		["Healthy Spirit"]="Healthy Spirit",
		["Heart of the Scale"]="Heart of the Scale",
		["Heart of the Wild"]="Heart of the Wild",
		["Heartbroken"]="Heartbroken",
		["Heaven's Blessing"]="Heaven's Blessing",
		["Heavy Dynamite"]="Heavy Dynamite",
		["Heavy Sharpening Stone"]="Heavy Sharpening Stone",
		["Hellfire Effect"]="Hellfire Effect",
		["Hellfire"]="Hellfire",
		["Hemorrhage"]="Hemorrhage",
		["Herb Gathering"]="Herb Gathering",
		["Herbalism"]="Herbalism",
		["Heroic Strike"]="Heroic Strike",
		["Heroism"]="Heroism",
		["Hex"]="Hex",
		["Hex of Jammal'an"]="Hex of Jammal'an",
		["Hex of Ravenclaw"]="Hex of Ravenclaw",
		["Hex of Weakness"]="Hex of Weakness",
		["Hi-Explosive Bomb"]="Hi-Explosive Bomb",
		["Hibernate"]="Hibernate",
		["Hide"]="Hide",
		["Holy Fire"]="Holy Fire",
		["Holy Light"]="Holy Light",
		["Holy Mightstone"]="Holy Mightstone",
		["Holy Nova"]="Holy Nova",
		["Silencing Shot"] = "Silencing Shot",
		["Holy Power"]="Holy Power",
		["Holy Protection"]="Holy Protection",
		["Holy Reach"]="Holy Reach",
		["Holy Shield"]="Holy Shield",
		["Holy Shock"]="Holy Shock",
		["Holy Smite"]="Holy Smite",
		["Holy Specialization"]="Holy Specialization",
		["Holy Strength"]="Holy Strength",
		["Holy Strike"]="Holy Strike",
		["Holy Sunder"]="Holy Sunder",
		["Holy Wrath"]="Holy Wrath",
		["Honorless Target"]="Honorless Target",
		["Hooked Net"]="Hooked Net",
		["Horse Riding"]="Horse Riding",
		["Howl of Terror"]="Howl of Terror",
		["Howling Blade"]="Howling Blade",
		["Humanoid Slaying"]="Humanoid Slaying",
		["Hunter Armor Energize"]="Hunter Armor Energize",
		["Hunter's Mark"]="Hunter's Mark",
		["Hurricane"]="Hurricane",
		["Ice Armor"]="Ice Armor",
		["Ice Barrier"]="Ice Barrier",
		["Ice Blast"]="Ice Blast",
		["Ice Block"]="Ice Block",
		["Ice Claw"]="Ice Claw",
		["Ice Nova"]="Ice Nova",
		["Ice Shards"]="Ice Shards",
		["Icicle"]="Icicle",
		["Icy Energy"]="Icy Energy",
		["Vampiric Touch"] = "Vampiric Touch",
		["Icy Grasp"]="Icy Grasp",
		["Ignite"]="Ignite",
		["Ignite Mana"]="Ignite Mana",
		["Illidan's Fury"]="Illidan's Fury",
		["Illumination"]="Illumination",
		["Immolate"]="Immolate",
		["Immolation Trap Effect"]="Immolation Trap Effect",
		["Immolation Trap"]="Immolation Trap",
		["Immune Root"]="Immune Root",
		["Impact"]="Impact",
		["Impale"]="Impale",
		["Impending Doom"]="Impending Doom",
		["Improved Ambush"]="Improved Ambush",
		["Improved Arcane Explosion"]="Improved Arcane Explosion",
		["Improved Arcane Missiles"]="Improved Arcane Missiles",
		["Improved Arcane Shot"]="Improved Arcane Shot",
		["Improved Aspect of the Hawk"]="Improved Aspect of the Hawk",
		["Improved Aspect of the Monkey"]="Improved Aspect of the Monkey",
		["Improved Backstab"]="Improved Backstab",
		["Improved Battle Shout"]="Improved Battle Shout",
		["Improved Berserker Rage"]="Improved Berserker Rage",
		["Improved Blessing of Might"]="Improved Blessing of Might",
		["Improved Blessing of Wisdom"]="Improved Blessing of Wisdom",
		["Improved Blizzard"]="Improved Blizzard",
		["Improved Blocking"]="Improved Blocking",
		["Improved Bloodrage"]="Improved Bloodrage",
		["Improved Chain Heal"]="Improved Chain Heal",
		["Improved Chain Lightning"]="Improved Chain Lightning",
		["Improved Challenging Shout"]="Improved Challenging Shout",
		["Improved Charge"]="Improved Charge",
		["Improved Cheap Shot"]="Improved Cheap Shot",
		["Improved Cleave"]="Improved Cleave",
		["Improved Concentration Aura"]="Improved Concentration Aura",
		["Improved Concussive Shot"]="Improved Concussive Shot",
		["Improved Cone of Cold"]="Improved Cone of Cold",
		["Improved Corruption"]="Improved Corruption",
		["Improved Counterspell"]="Improved Counterspell",
		["Improved Curse of Agony"]="Improved Curse of Agony",
		["Improved Curse of Exhaustion"]="Improved Curse of Exhaustion",
		["Improved Curse of Weakness"]="Improved Curse of Weakness",
		["Improved Dampen Magic"]="Improved Dampen Magic",
		["Improved Deadly Poison"]="Improved Deadly Poison",
		["Improved Demoralizing Shout"]="Improved Demoralizing Shout",
		["Improved Devotion Aura"]="Improved Devotion Aura",
		["Improved Disarm"]="Improved Disarm",
		["Spell Reflection"] = "Spell Reflection",
		["Improved Distract"]="Improved Distract",
		["Improved Drain Life"]="Improved Drain Life",
		["Improved Drain Mana"]="Improved Drain Mana",
		["Improved Drain Soul"]="Improved Drain Soul",
		["Improved Enrage"]="Improved Enrage",
		["Improved Enslave Demon"]="Improved Enslave Demon",
		["Improved Entangling Roots"]="Improved Entangling Roots",
		["Improved Evasion"]="Improved Evasion",
		["Improved Eviscerate"]="Improved Eviscerate",
		["Improved Execute"]="Improved Execute",
		["Improved Expose Armor"]="Improved Expose Armor",
		["Improved Eyes of the Beast"]="Improved Eyes of the Beast",
		["Improved Fade"]="Improved Fade",
		["Improved Feign Death"]="Improved Feign Death",
		["Improved Fire Blast"]="Improved Fire Blast",
		["Improved Fire Nova Totem"]="Improved Fire Nova Totem",
		["Improved Fire Ward"]="Improved Fire Ward",
		["Improved Fireball"]="Improved Fireball",
		["Improved Firebolt"]="Improved Firebolt",
		["Improved Firestone"]="Improved Firestone",
		["Improved Flamestrike"]="Improved Flamestrike",
		["Improved Flametongue Weapon"]="Improved Flametongue Weapon",
		["Improved Flash of Light"]="Improved Flash of Light",
		["Improved Frost Nova"]="Improved Frost Nova",
		["Improved Frost Ward"]="Improved Frost Ward",
		["Improved Frostbolt"]="Improved Frostbolt",
		["Improved Frostbrand Weapon"]="Improved Frostbrand Weapon",
		["Improved Garrote"]="Improved Garrote",
		["Improved Ghost Wolf"]="Improved Ghost Wolf",
		["Improved Gouge"]="Improved Gouge",
		["Improved Grace of Air Totem"]="Improved Grace of Air Totem",
		["Improved Grounding Totem"]="Improved Grounding Totem",
		["Improved Hammer of Justice"]="Improved Hammer of Justice",
		["Improved Hamstring"]="Improved Hamstring",
		["Improved Healing Stream Totem"]="Improved Healing Stream Totem",
		["Improved Healing Touch"]="Improved Healing Touch",
		["Improved Healing Wave"]="Improved Healing Wave",
		["Improved Healing"]="Improved Healing",
		["Improved Health Funnel"]="Improved Health Funnel",
		["Improved Healthstone"]="Improved Healthstone",
		["Improved Heroic Strike"]="Improved Heroic Strike",
		["Improved Hunter's Mark"]="Improved Hunter's Mark",
		["Improved Immolate"]="Improved Immolate",
		["Improved Imp"]="Improved Imp",
		["Improved Inner Fire"]="Improved Inner Fire",
		["Improved Instant Poison"]="Improved Instant Poison",
		["Improved Intercept"]="Improved Intercept",
		["Improved Intimidating Shout"]="Improved Intimidating Shout",
		["Improved Judgement"]="Improved Judgement",
		["Improved Kick"]="Improved Kick",
		["Improved Kidney Shot"]="Improved Kidney Shot",
		["Improved Lash of Pain"]="Improved Lash of Pain",
		["Improved Lay on Hands"]="Improved Lay on Hands",
		["Improved Lesser Healing Wave"]="Improved Lesser Healing Wave",
		["Improved Life Tap"]="Improved Life Tap",
		["Improved Lightning Bolt"]="Improved Lightning Bolt",
		["Improved Lightning Shield"]="Improved Lightning Shield",
		["Improved Magma Totem"]="Improved Magma Totem",
		["Improved Mana Burn"]="Improved Mana Burn",
		["Improved Mana Shield"]="Improved Mana Shield",
		["Improved Mana Spring Totem"]="Improved Mana Spring Totem",
		["Improved Mark of the Wild"]="Improved Mark of the Wild",
		["Improved Mend Pet"]="Improved Mend Pet",
		["Improved Mind Blast"]="Improved Mind Blast",
		["Improved Moonfire"]="Improved Moonfire",
		["Improved Nature's Grasp"]="Improved Nature's Grasp",
		["Improved Overpower"]="Improved Overpower",
		["Improved Power Word: Fortitude"]="Improved Power Word: Fortitude",
		["Improved Power Word: Shield"]="Improved Power Word: Shield",
		["Improved Prayer of Healing"]="Improved Prayer of Healing",
		["Improved Psychic Scream"]="Improved Psychic Scream",
		["Improved Pummel"]="Improved Pummel",
		["Improved Regrowth"]="Improved Regrowth",
		["Improved Reincarnation"]="Improved Reincarnation",
		["Improved Rejuvenation"]="Improved Rejuvenation",
		["Improved Rend"]="Improved Rend",
		["Improved Renew"]="Improved Renew",
		["Improved Retribution Aura"]="Improved Retribution Aura",
		["Improved Revenge"]="Improved Revenge",
		["Improved Revive Pet"]="Improved Revive Pet",
		["Improved Righteous Fury"]="Improved Righteous Fury",
		["Improved Rockbiter Weapon"]="Improved Rockbiter Weapon",
		["Improved Rupture"]="Improved Rupture",
		["Improved Sap"]="Improved Sap",
		["Improved Scorch"]="Improved Scorch",
		["Improved Scorpid Sting"]="Improved Scorpid Sting",
		["Improved Seal of Righteousness"]="Improved Seal of Righteousness",
		["Improved Seal of the Crusader"]="Improved Seal of the Crusader",
		["Improved Searing Pain"]="Improved Searing Pain",
		["Improved Searing Totem"]="Improved Searing Totem",
		["Improved Serpent Sting"]="Improved Serpent Sting",
		["Improved Shadow Bolt"]="Improved Shadow Bolt",
		["Improved Shadow Word: Pain"]="Improved Shadow Word: Pain",
		["Improved Shield Bash"]="Improved Shield Bash",
		["Improved Shield Block"]="Improved Shield Block",
		["Improved Shield Wall"]="Improved Shield Wall",
		["Improved Shred"]="Improved Shred",
		["Improved Sinister Strike"]="Improved Sinister Strike",
		["Improved Slam"]="Improved Slam",
		["Improved Slice and Dice"]="Improved Slice and Dice",
		["Improved Spellstone"]="Improved Spellstone",
		["Improved Sprint"]="Improved Sprint",
		["Improved Starfire"]="Improved Starfire",
		["Improved Stoneclaw Totem"]="Improved Stoneclaw Totem",
		["Improved Stoneskin Totem"]="Improved Stoneskin Totem",
		["Improved Strength of Earth Totem"]="Improved Strength of Earth Totem",
		["Improved Succubus"]="Improved Succubus",
		["Improved Sunder Armor"]="Improved Sunder Armor",
		["Improved Taunt"]="Improved Taunt",
		["Improved Thorns"]="Improved Thorns",
		["Improved Thunder Clap"]="Improved Thunder Clap",
		["Improved Tranquility"]="Improved Tranquility",
		["Improved Vampiric Embrace"]="Improved Vampiric Embrace",
		["Improved Vanish"]="Improved Vanish",
		["Improved Voidwalker"]="Improved Voidwalker",
		["Improved Windfury Weapon"]="Improved Windfury Weapon",
		["Improved Wing Clip"]="Improved Wing Clip",
		["Improved Wrath"]="Improved Wrath",
		["Incinerate"]="Incinerate",
		["Incite Flames"]="Incite Flames",
		["Increased Agility"]="Increased Agility",
		["Increased Intellect"]="Increased Intellect",
		["Increased Spirit"]="Increased Spirit",
		["Increased Stamina"]="Increased Stamina",
		["Unstable Affliction"] = "Unstable Affliction",
		["Infallible Mind"]="Infallible Mind",
		["Infected Bite"]="Infected Bite",
		["Infected Wound"]="Infected Wound",
		["Inferno"]="Inferno",
		["Inferno Shell"]="Inferno Shell",
		["Initiative"]="Initiative",
		["Inner Fire"]="Inner Fire",
		["Inner Focus"]="Inner Focus",
		["Innervate"]="Innervate",
		["Insect Swarm"]="Insect Swarm",
		["Insight"]="Insight",
		["Insight of the Qiraji"]="Insight of the Qiraji",
		["Inspiration"]="Inspiration",
		["Instant Poison II"]="Instant Poison II",
		["Instant Poison III"]="Instant Poison III",
		["Instant Poison IV"]="Instant Poison IV",
		["Instant Poison V"]="Instant Poison V",
		["Instant Poison VI"]="Instant Poison VI",
		["Instant Poison"]="Instant Poison",
		["Intensity"]="Intensity",
		["Intercept"]="Intercept",
		["Intercept Stun"]="Intercept Stun",
		["Intimidating Roar"]="Intimidating Roar",
		["Intimidating Shout"]="Intimidating Shout",
		["Intimidation"]="Intimidation",
		["Intoxicating Venom"]="Intoxicating Venom",
		["Invigorate"]="Invigorate",
		["Invisibility"]="Invisibility",
		["Invulnerability"]="Invulnerability",
		["Iron Grenade"]="Iron Grenade",
		["Iron Shield Spike"]="Iron Shield Spike",
		["Iron Will"]="Iron Will",
		["Ironforge Gift of Friendship"]="Ironforge Gift of Friendship",
		["Ishamuhale's Rage"]="Ishamuhale's Rage",
		["Item - Purify"]="Item - Purify",
		["Jang'thraze"]="Jang'thraze",
		["Jeklik's Crushing Blow"]="Jeklik's Crushing Blow",
		["Jewelcrafting"]="Jewelcrafting",
		["Jom Gabbar"]="Jom Gabbar",
		["Judgement of Command"]="Judgement of Command",
		["Judgement of Justice"]="Judgement of Justice",
		["Judgement of Light"]="Judgement of Light",
		["Judgement of Righteousness"]="Judgement of Righteousness",
		["Judgement of Wisdom"]="Judgement of Wisdom",
		["Judgement of the Crusader"]="Judgement of the Crusader",
		["Judgement"]="Judgement",
		["Juju Chill"]="Juju Chill",
		["Juju Ember"]="Juju Ember",
		["Juju Escape"]="Juju Escape",
		["Juju Flurry"]="Juju Flurry",
		["Juju Guile"]="Juju Guile",
		["Juju Might"]="Juju Might",
		["Juju Power"]="Juju Power",
		["Julie's Blessing"]="Julie's Blessing",
		["Keeper's Sting"]="Keeper's Sting",
		["Kick"]="Kick",
		["Kidney Shot"]="Kidney Shot",
		["Killer Instinct"]="Killer Instinct",
		["King of the Gordok"]="King of the Gordok",
		["Kiss of the Spider"]="Kiss of the Spider",
		["Knock Away"]="Knock Away",
		["Knockdown"]="Knockdown",
		["Kodo Riding"]="Kodo Riding",
		["Kreeg's Stout Beatdown"]="Kreeg's Stout Beatdown",
		["Lakota'mani's Thunder"]="Lakota'mani's Thunder",
		["Large Copper Bomb"]="Large Copper Bomb",
		["Large Seaforium Backfire"]="Large Seaforium Backfire",
		["Larva Goo"]="Larva Goo",
		["Lash"]="Lash",
		["Lash of Pain"]="Lash of Pain",
		["Last Stand"]="Last Stand",
		["Lasting Judgement"]="Lasting Judgement",
		["Lava Bomb"]="Lava Bomb",
		["Lava Breath"]="Lava Breath",
		["Lava Spout Totem"]="Lava Spout Totem",
		["Lay on Hands"]="Lay on Hands",
		["Leader of the Pack"]="Leader of the Pack",
		["Leather"]="Leather",
		["Leatherworking"]="Leatherworking",
		["Leech Poison"]="Leech Poison",
		["Leper Gnome Costume"]="Leper Gnome Costume",
		["Lesser Agility"]="Lesser Agility",
		["Lesser Armor"]="Lesser Armor",
		["Lesser Heal"]="Lesser Heal",
		["Lesser Healing Wave"]="Lesser Healing Wave",
		["Lesser Healthstone"]="Lesser Healthstone",
		["Lesser Intellect"]="Lesser Intellect",
		["Lesser Invisibility"]="Lesser Invisibility",
		["Lesser Mark of the Dawn"]="Lesser Mark of the Dawn",
		["Lesser Strength"]="Lesser Strength",
		["Lethal Shots"]="Lethal Shots",
		["Lethality"]="Lethality",
		["Levitate"]="Levitate",
		["Libram"]="Libram",
		["Lich Slap"]="Lich Slap",
		["Life Harvest"]="Life Harvest",
		["Life Steal"]="Life Steal",
		["Life Tap"]="Life Tap",
		["Lifegiving Gem"]="Lifegiving Gem",
		["Lifestone Healing"]="Lifestone Healing",
		["Light of Elune"]="Light of Elune",
		["Lightheaded"]="Lightheaded",
		["Lightning"]="Lightning",
		["Lightning Barrier"]="Lightning Barrier",
		["Lightning Blast"]="Lightning Blast",
		["Lightning Bolt"]="Lightning Bolt",
		["Lightning Breath"]="Lightning Breath",
		["Lightning Cloud"]="Lightning Cloud",
		["Lightning Mastery"]="Lightning Mastery",
		["Lightning Reflexes"]="Lightning Reflexes",
		["Lightning Shield"]="Lightning Shield",
		["Lightning Strike"]="Lightning Strike",
		["Lightning Wave"]="Lightning Wave",
		["Lightwell Renew"]="Lightwell Renew",
		["Summon Felguard"] = "Summon Felguard",
		["Lightwell"]="Lightwell",
		["Linken's Boomerang"]="Linken's Boomerang",
		["Living Bomb"]="Living Bomb",
		["Living Free Action"]="Living Free Action",
		["Living Flames"]="Living Flames",
		["Lizard Bolt"]="Lizard Bolt",
		["Loatheb's Reflection"]="Loatheb's Reflection",
		["Localized Toxin"]="Localized Toxin",
		["Lockpicking"]="Lockpicking",
		["Long Daze"]="Long Daze",
		["Longsight"]="Longsight",
		["Lord General's Sword"]="Lord General's Sword",
		["Low Swipe"]="Low Swipe",
		["Lucifron's Curse"]="Lucifron's Curse",
		["Luffa"]="Luffa",
		["Lunar Fortune"]="Lunar Fortune",
		["M73 Frag Grenade"]="M73 Frag Grenade",
		["Mace Specialization"]="Mace Specialization",
		["Mace Stun Effect"]="Mace Stun Effect",
		["Unleashed Rage"] = "Unleashed Rage",
		["Machine Gun"]="Machine Gun",
		["Mage Armor"]="Mage Armor",
		["Magenta Cap Sickness"]="Magenta Cap Sickness",
		["Maggot Slime"]="Maggot Slime",
		["Magic Wings"]="Magic Wings",
		["Magma Shackles"]="Magma Shackles",
		["Magma Splash"]="Magma Splash",
		["Magma Totem"]="Magma Totem",
		["Mail"]="Mail",
		["Major Healthstone"]="Major Healthstone",
		["Malice"]="Malice",
		["Malfunction"]="Malfunction",
		["Malfunction Explosion"]="Malfunction Explosion",
		["Malown's Slam"]="Malown's Slam",
		["Mana Burn"]="Mana Burn",
		["Mana Drain"]="Mana Drain",
		["Mana Infusion"]="Mana Infusion",
		["Mana Regeneration"]="Mana Regeneration",
		["Mana Rejuvenation"]="Mana Rejuvenation",
		["Mana Shield"]="Mana Shield",
		["Mana Spring Totem"]="Mana Spring Totem",
		["Mana Surge"]="Mana Surge",
		["Mana Tide Totem"]="Mana Tide Totem",
		["Mangle"]="Mangle",
		["Mark of Arlokk"]="Mark of Arlokk",
		["Mark of Flames"]="Mark of Flames",
		["Mark of Shame"]="Mark of Shame",
		["Mark of the Chosen"]="Mark of the Chosen",
		["Mark of the Chosen Effect"]="Mark of the Chosen Effect",
		["Mark of the Dawn"]="Mark of the Dawn",
		["Mark of the Dragon Lord"]="Mark of the Dragon Lord",
		["Mark of the Wild"]="Mark of the Wild",
		["Martyrdom"]="Martyrdom",
		["Mar'li's Brain Boost"]="Mar'li's Brain Boost",
		["Massive Destruction"]="Massive Destruction",
		["Massive Tremor"]="Massive Tremor",
		["Master Angler"]="Master Angler",
		["Master Demonologist"]="Master Demonologist",
		["Master Summoner"]="Master Summoner",
		["Master of Deception"]="Master of Deception",
		["Maul"]="Maul",
		["Mechanical Patch Kit"]="Mechanical Patch Kit",
		["Mechanostrider Piloting"]="Mechanostrider Piloting",
		["Meditation"]="Meditation",
		["Megavolt"]="Megavolt",
		["Melee Specialization"]="Melee Specialization",
		["Melt Armor"]="Melt Armor",
		["Melt Ore"]="Melt Ore",
		["Mend Pet"]="Mend Pet",
		["Mental Agility"]="Mental Agility",
		["Mental Strength"]="Mental Strength",
		["Mercurial Shield"]="Mercurial Shield",
		["Metamorphosis Rune"]="Metamorphosis Rune",
		["Midsummer Sausage"]="Midsummer Sausage",
		["Might of Shahram"]="Might of Shahram",
		["Mighty Blow"]="Mighty Blow",
		["Mighty Rage"]="Mighty Rage",
		["The Beast Within"] = "The Beast Within",
		["Mind Blast"]="Mind Blast",
		["Mind Control"]="Mind Control",
		["Mind Flay"]="Mind Flay",
		["Mind Quickening"]="Mind Quickening",
		["Mind Soothe"]="Mind Soothe",
		["Mind Tremor"]="Mind Tremor",
		["Mind Vision"]="Mind Vision",
		["Mind-numbing Poison II"]="Mind-numbing Poison II",
		["Mind-numbing Poison III"]="Mind-numbing Poison III",
		["Mind-numbing Poison"]="Mind-numbing Poison",
		["Minions of Malathrom"]="Minions of Malathrom",
		["Mining"]="Mining",
		["Minor Healthstone"]="Minor Healthstone",
		["Miring Mud"]="Miring Mud",
		["Mistletoe"]="Mistletoe",
		["Mithril Frag Bomb"]="Mithril Frag Bomb",
		["Mithril Shield Spike"]="Mithril Shield Spike",
		["Mobility Malfunction"]="Mobility Malfunction",
		["Mocking Blow"]="Mocking Blow",
		["Moist Towelette"]="Moist Towelette",
		["Molten Blast"]="Molten Blast",
		["Molten Metal"]="Molten Metal",
		["Mongoose Bite"]="Mongoose Bite",
		["Monster Slaying"]="Monster Slaying",
		["Moonfire"]="Moonfire",
		["Moonfury"]="Moonfury",
		["Moonglow"]="Moonglow",
		["Moonkin Aura"]="Moonkin Aura",
		["Moonkin Form"]="Moonkin Form",
		["Mortal Cleave"]="Mortal Cleave",
		["Mortal Shots"]="Mortal Shots",
		["Mortal Strike"]="Mortal Strike",
		["Moss Hide"]="Moss Hide",
		["Multi-Shot"]="Multi-Shot",
		["Murder"]="Murder",
		["Muscle Tear"]="Muscle Tear",
		["Mystical Disjunction"]="Mystical Disjunction",
		["Naralex's Nightmare"]="Naralex's Nightmare",
		["Naraxis Web"]="Naraxis Web",
		["Natural Armor"]="Natural Armor",
		["Natural Shapeshifter"]="Natural Shapeshifter",
		["Natural Weapons"]="Natural Weapons",
		["Nature Aligned"]="Nature Aligned",
		["Nature Protection"]="Nature Protection",
		["Nature Resistance Totem"]="Nature Resistance Totem",
		["Nature Resistance"]="Nature Resistance",
		["Nature's Ally"]="Nature's Ally",
		["Nature's Bounty"]="Nature's Bounty",
		["Nature's Focus"]="Nature's Focus",
		["Nature's Grace"]="Nature's Grace",
		["Nature's Grasp"]="Nature's Grasp",
		["Nature's Reach"]="Nature's Reach",
		["Nature's Swiftness"]="Nature's Swiftness",
		["Net"]="Net",
		["Netherwind Focus"]="Netherwind Focus",
		["Net-o-Matic"]="Net-o-Matic",
		["Night Dragon's Breath"]="Night Dragon's Breath",
		["Nightfall"]="Nightfall",
		["Nimble Healing Touch"]="Nimble Healing Touch",
		["Nimble Reflexes"]="Nimble Reflexes",
		["Ninja Costume"]="Ninja Costume",
		["Noggenfogger Elixir"]="Noggenfogger Elixir",
		["Not There"]="Not There",
		["Noxious Catalyst"]="Noxious Catalyst",
		["Noxious Cloud"]="Noxious Cloud",
		["Numbing Pain"]="Numbing Pain",
		["Obsidian Insight"]="Obsidian Insight",
		["Omen of Clarity"]="Omen of Clarity",
		["One-Handed Axes"]="One-Handed Axes",
		["One-Handed Maces"]="One-Handed Maces",
		["One-Handed Swords"]="One-Handed Swords",
		["One-Handed Weapon Specialization"]="One-Handed Weapon Specialization",
		["Opening - No Text"]="Opening - No Text",
		["Opening"]="Opening",
		["Opportunity"]="Opportunity",
		["Oracular Heal"]="Oracular Heal",
		["Orb of Deception"]="Orb of Deception",
		["Orgrimmar Gift of Friendship"]="Orgrimmar Gift of Friendship",
		["Overpower"]="Overpower",
		["Pacify"]="Pacify",
		["Pagle's Broken Reel"]="Pagle's Broken Reel",
		["Panic"]="Panic",
		["Paralyzing Poison"]="Paralyzing Poison",
		["Paranoia"]="Paranoia",
		["Parasite"]="Parasite",
		["Parasitic Serpent"]="Parasitic Serpent",
		["Parry"]="Parry",
		["Party Time!"]="Party Time\33",
		["Pathfinding"]="Pathfinding",
		["Perception"]="Perception",
		["Perfume"]="Perfume",
		["Permafrost"]="Permafrost",
		["Persistent Shield"]="Persistent Shield",
		["Pet Aggression"]="Pet Aggression",
		["Pet Hardiness"]="Pet Hardiness",
		["Pet Recovery"]="Pet Recovery",
		["Pet Resistance"]="Pet Resistance",
		["Petrification"]="Petrification",
		["Petrify"]="Petrify",
		["Phantom Strike"]="Phantom Strike",
		["Phase Shift"]="Phase Shift",
		["Physical Protection"]="Physical Protection",
		["Piccolo of the Flaming Fire"]="Piccolo of the Flaming Fire",
		["Pick Lock"]="Pick Lock",
		["Pick Pocket"]="Pick Pocket",
		["Pierce Armor"]="Pierce Armor",
		["Piercing Howl"]="Piercing Howl",
		["Piercing Ice"]="Piercing Ice",
		["Piercing Shadow"]="Piercing Shadow",
		["Piercing Shot"]="Piercing Shot",
		["Pirate Costume"]="Pirate Costume",
		["Plague Cloud"]="Plague Cloud",
		["Plague Mind"]="Plague Mind",
		["Plate Mail"]="Plate Mail",
		["Poison"]="Poison",
		["Poison Bolt"]="Poison Bolt",
		["Poison Bolt Volley"]="Poison Bolt Volley",
		["Poison Cleansing Totem"]="Poison Cleansing Totem",
		["Poison Cloud"]="Poison Cloud",
		["Poison Shock"]="Poison Shock",
		["Poisoned Harpoon"]="Poisoned Harpoon",
		["Poisoned Shot"]="Poisoned Shot",
		["Poisonous Blood"]="Poisonous Blood",
		["Poisonous Stab"]="Poisonous Stab",
		["Poisons"]="Poisons",
		["Polearm Specialization"]="Polearm Specialization",
		["Polearms"]="Polearms",
		["Polished Armor"]="Polished Armor",
		["Polymorph"]="Polymorph",
		["Polymorph: Chicken"]="Polymorph: Chicken",
		["Polymorph: Pig"]="Polymorph: Pig",
		["Polymorph: Turtle"]="Polymorph: Turtle",
		["Portal: Darnassus"]="Portal: Darnassus",
		["Ritual of Souls"] = "Ritual of Souls",
		["Portal: Ironforge"]="Portal: Ironforge",
		["Portal: Orgrimmar"]="Portal: Orgrimmar",
		["Portal: Stormwind"]="Portal: Stormwind",
		["Portal: Thunder Bluff"]="Portal: Thunder Bluff",
		["Portal: Undercity"]="Portal: Undercity",
		["Potion Strength II"]="Potion Strength II",
		["Pounce Bleed"]="Pounce Bleed",
		["Pounce"]="Pounce",
		["Power Infusion"]="Power Infusion",
		["Power of the Guardian"]="Power of the Guardian",
		["Power Word: Fortitude"]="Power Word: Fortitude",
		["Power Word: Shield"]="Power Word: Shield",
		["Prayer Beads Blessing"]="Prayer Beads Blessing",
		["Prayer of Fortitude"]="Prayer of Fortitude",
		["Prayer of Healing"]="Prayer of Healing",
		["Prayer of Shadow Protection"]="Prayer of Shadow Protection",
		["Prayer of Spirit"]="Prayer of Spirit",
		["Precision"]="Precision",
		["Predatory Strikes"]="Predatory Strikes",
		["Premeditation"]="Premeditation",
		["Preparation"]="Preparation",
		["Presence of Death"]="Presence of Death",
		["Presence of Mind"]="Presence of Mind",
		["Primal Blessing"]="Primal Blessing",
		["Primal Fury"]="Primal Fury",
		["Maim"] = "Maim",
		["Primal Instinct"]="Primal Instinct",
		["Prismstone"]="Prismstone",
		["Proudmoore's Defense"]="Proudmoore's Defense",
		["Proximity Bomb Explode"]="Proximity Bomb Explode",
		["Prowl"]="Prowl",
		["Psychic Scream"]="Psychic Scream",
		["Pummel"]="Pummel",
		["Puncture"]="Puncture",
		["Puncture Armor"]="Puncture Armor",
		["Purge"]="Purge",
		["Purification"]="Purification",
		["Purify"]="Purify",
		["Pursuit of Justice"]="Pursuit of Justice",
		["Putrid Breath"]="Putrid Breath",
		["Putrid Enzyme"]="Putrid Enzyme",
		["Pyroblast"]="Pyroblast",
		["Pyroclasm"]="Pyroclasm",
		["Pyroclast Barrage"]="Pyroclast Barrage",
		["Quick Bloodlust"]="Quick Bloodlust",
		["Quick Flame Ward"]="Quick Flame Ward",
		["Quick Frost Ward"]="Quick Frost Ward",
		["Quick Shot"]="Quick Shot",
		["Quick Sidestep"]="Quick Sidestep",
		["Quickness"]="Quickness",
		["Shadowfiend"] = "Shadowfiend",
		["Quill Shot"]="Quill Shot",
		["Rabies"]="Rabies",
		["Radiation"]="Radiation",
		["Radiation Bolt"]="Radiation Bolt",
		["Radiation Cloud"]="Radiation Cloud",
		["Rage"]="Rage",
		["Rage of Ages"]="Rage of Ages",
		["Ragged John's Neverending Cup"]="Ragged John's Neverending Cup",
		["Rain of Fire"]="Rain of Fire",
		["Rake"]="Rake",
		["Ram Riding"]="Ram Riding",
		["Rampage"]="Rampage",
		["Ramstein's Lightning Bolts"]="Ramstein's Lightning Bolts",
		["Rancid Blood"]="Rancid Blood",
		["Ranged Weapon Specialization"]="Ranged Weapon Specialization",
		["Rapid Concealment"]="Rapid Concealment",
		["Rapid Fire"]="Rapid Fire",
		["Rapid Healing"]="Rapid Healing",
		["Raptor Punch"]="Raptor Punch",
		["Raptor Riding"]="Raptor Riding",
		["Raptor Strike"]="Raptor Strike",
		["Ravage"]="Ravage",
		["Ravenous Claw"]="Ravenous Claw",
		["Razor Mane"]="Razor Mane",
		["Razorhide"]="Razorhide",
		["Reactive Fade"]="Reactive Fade",
		["Readiness"]="Readiness",
		["Rebirth"]="Rebirth",
		["Rebuild"]="Rebuild",
		["Recently Bandaged"]="Recently Bandaged",
		["Reckless Charge"]="Reckless Charge",
		["Recklessness"]="Recklessness",
		["Reckoning"]="Reckoning",
		["Recombobulate"]="Recombobulate",
		["Redemption"]="Redemption",
		["Redoubt"]="Redoubt",
		["Reflection"]="Reflection",
		["Refocus"]="Refocus",
		["Regeneration"]="Regeneration",
		["Regrowth"]="Regrowth",
		["Reincarnation"]="Reincarnation",
		["Rejuvenation"]="Rejuvenation",
		["Rejuvenation Potion"]="Rejuvenation Potion",
		["Relentless Strikes"]="Relentless Strikes",
		["Remorseless Attacks"]="Remorseless Attacks",
		["Remove Curse"]="Remove Curse",
		["Remove Insignia"]="Remove Insignia",
		["Remove Lesser Curse"]="Remove Lesser Curse",
		["Rend"]="Rend",
		["Rend Flesh"]="Rend Flesh",
		["Renew"]="Renew",
		["Repentance"]="Repentance",
		["Replenish Mana"]="Replenish Mana",
		["Repulsive Gaze"]="Repulsive Gaze",
		["Resist Fire"]="Resist Fire",
		["Resistance"]="Resistance",
		["Restless Strength"]="Restless Strength",
		["Restoration"]="Restoration",
		["Restore Energy"]="Restore Energy",
		["Restore Life"]="Restore Life",
		["Restore Mana"]="Restore Mana",
		["Resurrection"]="Resurrection",
		["Retaliation"]="Retaliation",
		["Retribution Aura"]="Retribution Aura",
		["Revealed Flaw"]="Revealed Flaw",
		["Revenge Stun"]="Revenge Stun",
		["Revenge"]="Revenge",
		["Reverberation"]="Reverberation",
		["Revitalize"]="Revitalize",
		["Revive Pet"]="Revive Pet",
		["Rhahk'Zor Slam"]="Rhahk'Zor Slam",
		["Ribbon of Souls"]="Ribbon of Souls",
		["Righteous Fury"]="Righteous Fury",
		["Rip"]="Rip",
		["Riposte"]="Riposte",
		["Rising Spirit"]="Rising Spirit",
		["Ritual of Doom Effect"]="Ritual of Doom Effect",
		["Ritual of Doom"]="Ritual of Doom",
		["Ritual of Summoning"]="Ritual of Summoning",
		["Rockbiter Weapon"]="Rockbiter Weapon",
		["Rocket Blast"]="Rocket Blast",
		["Rocket Boots Malfunction"]="Rocket Boots Malfunction",
		["Rogue Armor Energize"]="Rogue Armor Energize",
		["Rogue Passive"]="Rogue Passive",
		["Rough Copper Bomb"]="Rough Copper Bomb",
		["Rough Dynamite"]="Rough Dynamite",
		["Rough Sharpening Stone"]="Rough Sharpening Stone",
		["Ruin"]="Ruin",
		["Running Speed"]="Running Speed",
		["Rupture"]="Rupture",
		["Rushing Charge"]="Rushing Charge",
		["Ruthlessness"]="Ruthlessness",
		["Sacred Cleansing"]="Sacred Cleansing",
		["Sacrifice"]="Sacrifice",
		["Safe Fall"]="Safe Fall",
		["Sanctified Orb"]="Sanctified Orb",
		["Sanctity Aura"]="Sanctity Aura",
		["Sanctuary"]="Sanctuary",
		["Sap"]="Sap",
		["Sapper Explode"]="Sapper Explode",
		["Savage Fury"]="Savage Fury",
		["Savage Strikes"]="Savage Strikes",
		["Savagery"]="Savagery",
		["Savior's Sacrifice"]="Savior's Sacrifice",
		["Sayge's Dark Fortune of Agility"]="Sayge's Dark Fortune of Agility",
		["Sayge's Dark Fortune of Armor"]="Sayge's Dark Fortune of Armor",
		["Sayge's Dark Fortune of Damage"]="Sayge's Dark Fortune of Damage",
		["Sayge's Dark Fortune of Intelligence"]="Sayge's Dark Fortune of Intelligence",
		["Sayge's Dark Fortune of Resistance"]="Sayge's Dark Fortune of Resistance",
		["Sayge's Dark Fortune of Spirit"]="Sayge's Dark Fortune of Spirit",
		["Sayge's Dark Fortune of Stamina"]="Sayge's Dark Fortune of Stamina",
		["Sayge's Dark Fortune of Strength"]="Sayge's Dark Fortune of Strength",
		["Scare Beast"]="Scare Beast",
		["Scarlet Illusion"]="Scarlet Illusion",
		["Scatter Shot"]="Scatter Shot",
		["Scorch"]="Scorch",
		["Scorpid Poison"]="Scorpid Poison",
		["Scorpid Sting"]="Scorpid Sting",
		["Screams of the Past"]="Screams of the Past",
		["Screech"]="Screech",
		["Scourge Strike"]="Scourge Strike",
		["Seal Fate"]="Seal Fate",
		["Seal of Command"]="Seal of Command",
		["Seal of Justice"]="Seal of Justice",
		["Seal of Light"]="Seal of Light",
		["Seal of Reckoning"]="Seal of Reckoning",
		["Seal of Righteousness"]="Seal of Righteousness",
		["Seal of Wisdom"]="Seal of Wisdom",
		["Seal of the Crusader"]="Seal of the Crusader",
		["Searing Arrow"]="Searing Arrow",
		["Searing Blast"]="Searing Blast",
		["Searing Light"]="Searing Light",
		["Searing Pain"]="Searing Pain",
		["Searing Totem"]="Searing Totem",
		["Second Wind"] = "Second Wind",
		["Seduction"]="Seduction",
		["Seeping Willow"]="Seeping Willow",
		["Self Healing"]="Self Healing",
		["Self Invulnerability"]="Self Invulnerability",
		["Sense Demons"]="Sense Demons",
		["Sense Undead"]="Sense Undead",
		["Sentry Totem"]="Sentry Totem",
		["Serpent Sting"]="Serpent Sting",
		["Serpent's Hiss"]="Serpent's Hiss",
		["Serrated Bite"]="Serrated Bite",
		["Setup"]="Setup",
		["Shackle Undead"]="Shackle Undead",
		["Shadow Affinity"]="Shadow Affinity",
		["Shadow Bolt"]="Shadow Bolt",
		["Shadow Bolt Volley"]="Shadow Bolt Volley",
		["Shadow Focus"]="Shadow Focus",
		["Shadow Mastery"]="Shadow Mastery",
		["Shadow Port"]="Shadow Port",
		["Shadow Power"]="Shadow Power",
		["Shadow Protection"]="Shadow Protection",
		["Shadow Reach"]="Shadow Reach",
		["Shadow Reflector"]="Shadow Reflector",
		["Shadow Resistance Aura"]="Shadow Resistance Aura",
		["Shadow Resistance"]="Shadow Resistance",
		["Shadow Shock"]="Shadow Shock",
		["Shadow Shot"]="Shadow Shot",
		["Shadow Trance"]="Shadow Trance",
		["Shadow Vulnerability"]="Shadow Vulnerability",
		["Shadow Ward"]="Shadow Ward",
		["Shadow Weaving"]="Shadow Weaving",
		["Shadow Word: Pain"]="Shadow Word: Pain",
		["Shadowburn"]="Shadowburn",
		["Shadowform"]="Shadowform",
		["Wrath of Air Totem"] = "Wrath of Air Totem",
		["Shadowguard"]="Shadowguard",
		["Shadowmeld Passive"]="Shadowmeld Passive",
		["Shadowmeld"]="Shadowmeld",
		["Shard of the Fallen Star"]="Shard of the Fallen Star",
		["Sharpened Claws"]="Sharpened Claws",
		["Shatter"]="Shatter",
		["Shazzrah's Curse"]="Shazzrah's Curse",
		["Sheen of Zanza"]="Sheen of Zanza",
		["Sheep"]="Sheep",
		["Shell Shield"]="Shell Shield",
		["Shield Bash"]="Shield Bash",
		["Shield Block"]="Shield Block",
		["Totem of Wrath"] = "Totem of Wrath",
		["Shield Slam"]="Shield Slam",
		["Shield Specialization"]="Shield Specialization",
		["Shield Spike"]="Shield Spike",
		["Shield Wall"]="Shield Wall",
		["Shield"]="Shield",
		["Shimmer Stout"]="Shimmer Stout",
		["Shock"]="Shock",
		["Shoot Bow"]="Shoot Bow",
		["Shoot Crossbow"]="Shoot Crossbow",
		["Shoot Gun"]="Shoot Gun",
		["Shoot"]="Shoot",
		["Shred"]="Shred",
		["Shrink"]="Shrink",
		["Shrink Ray"]="Shrink Ray",
		["Silence"]="Silence",
		["Silent Resolve"]="Silent Resolve",
		["Silithid Pox"]="Silithid Pox",
		["Sinister Strike"]="Sinister Strike",
		["Siphon Health"]="Siphon Health",
		["Siphon Life"]="Siphon Life",
		["Skeleton Costume"]="Skeleton Costume",
		["Skinning"]="Skinning",
		["Skull Crack"]="Skull Crack",
		["Skullforge Brand"]="Skullforge Brand",
		["Slam"]="Slam",
		["Slayer's Crest"]="Slayer's Crest",
		["Sleep"]="Sleep",
		["Sleepy"]="Sleepy",
		["Slice and Dice"]="Slice and Dice",
		["Sling Mud"]="Sling Mud",
		["Sloth Effect"]="Sloth Effect",
		["Slow"]="Slow",
		["Slow Fall"]="Slow Fall",
		["Slowing Poison"]="Slowing Poison",
		["Sludge"]="Sludge",
		["Sludge Toxin"]="Sludge Toxin",
		["Small Bronze Bomb"]="Small Bronze Bomb",
		["Small Seaforium Backfire"]="Small Seaforium Backfire",
		["Smash"]="Smash",
		["Smelting"]="Smelting",
		["Smite"]="Smite",
		["Smite Demon"]="Smite Demon",
		["Smite Stomp"]="Smite Stomp",
		["Smite Slam"]="Smite Slam",
		["Smoke Bomb"]="Smoke Bomb",
		["Smokey's Lighter"]="Smokey's Lighter",
		["Snap Kick"]="Snap Kick",
		["Sneak"]="Sneak",
		["Snowball"]="Snowball",
		["Solid Dynamite"]="Solid Dynamite",
		["Solid Sharpening Stone"]="Solid Sharpening Stone",
		["Songflower Serenade"]="Songflower Serenade",
		["Sonic Burst"]="Sonic Burst",
		["Soothe Animal"]="Soothe Animal",
		["Soothing Kiss"]="Soothing Kiss",
		["Soul Bite"]="Soul Bite",
		["Soul Breaker"]="Soul Breaker",
		["Soul Burn"]="Soul Burn",
		["Soul Drain"]="Soul Drain",
		["Soul Fire"]="Soul Fire",
		["Soul Link"]="Soul Link",
		["Soul Siphon"]="Soul Siphon",
		["Lifebloom"] = "Lifebloom",
		["Soul Tap"]="Soul Tap",
		["Soulstone Resurrection"]="Soulstone Resurrection",
		["Speed"]="Speed",
		["Speed of Owatanka"]="Speed of Owatanka",
		["Spell Blasting"]="Spell Blasting",
		["Spell Lock"]="Spell Lock",
		["Spell Warding"]="Spell Warding",
		["Spider's Kiss"]="Spider's Kiss",
		["Spinal Reaper"]="Spinal Reaper",
		["Spirit Bond"]="Spirit Bond",
		["Spirit Burst"]="Spirit Burst",
		["Spirit Decay"]="Spirit Decay",
		["Spirit of Boar"]="Spirit of Boar",
		["Spirit of Redemption"]="Spirit of Redemption",
		["Spirit of the Wind"]="Spirit of the Wind",
		["Spirit of Zanza"]="Spirit of Zanza",
		["Spirit Tap"]="Spirit Tap",
		["Spiritual Domination"]="Spiritual Domination",
		["Spiritual Focus"]="Spiritual Focus",
		["Spiritual Guidance"]="Spiritual Guidance",
		["Spiritual Healing"]="Spiritual Healing",
		["Spit"]="Spit",
		["Spore Cloud"]="Spore Cloud",
		["Spotlight"]="Spotlight",
		["Sprint"]="Sprint",
		["Stalker's Ally"]="Stalker's Ally",
		["Starfall"]="Starfall",
		["Starfire"]="Starfire",
		["Starfire Stun"]="Starfire Stun",
		["Starshards"]="Starshards",
		["Static Barrier"]="Static Barrier",
		["Static Electricity"]="Static Electricity",
		["Staves"]="Staves",
		["Stealth"]="Stealth",
		["Stealth Detection"]="Stealth Detection",
		["Stomp"]="Stomp",
		["Stone Skin"]="Stone Skin",
		["Stoneclaw Totem"]="Stoneclaw Totem",
		["Stoneform"]="Stoneform",
		["Stoneshield"]="Stoneshield",
		["Stoneskin Totem"]="Stoneskin Totem",
		["Stormcaller's Wrath"]="Stormcaller's Wrath",
		["Stormstout"]="Stormstout",
		["Stormstrike"]="Stormstrike",
		["Stormwind Gift of Friendship"]="Stormwind Gift of Friendship",
		["Strength"]="Strength",
		["Strength of Earth Totem"]="Strength of Earth Totem",
		["Strength of Isha Awak"]="Strength of Isha Awak",
		["Strength of Stone"]="Strength of Stone",
		["Strength of the Champion"]="Strength of the Champion",
		["Strike"]="Strike",
		["Strike of the Scorpok"]="Strike of the Scorpok",
		["Stuck"]="Stuck",
		["Stun"]="Stun",
		["Stunning Blow"]="Stunning Blow",
		["Stygian Grasp"]="Stygian Grasp",
		["Subtlety"]="Subtlety",
		["Suffering"]="Suffering",
		["Sul'thraze"]="Sul'thraze",
		["Summon Charger"]="Summon Charger",
		["Summon Dreadsteed"]="Summon Dreadsteed",
		["Summon Felhunter"]="Summon Felhunter",
		["Summon Felsteed"]="Summon Felsteed",
		["Summon Imp"]="Summon Imp",
		["Summon Spawn of Bael'Gar"]="Summon Spawn of Bael'Gar",
		["Summon Succubus"]="Summon Succubus",
		["Summon Voidwalker"]="Summon Voidwalker",
		["Summon Warhorse"]="Summon Warhorse",
		["Sunder Armor"]="Sunder Armor",
		["Super Shrink Ray"]="Super Shrink Ray",
		["Suppression"]="Suppression",
		["Supreme Power"]="Supreme Power",
		["Surefooted"]="Surefooted",
		["Surge"]="Surge",
		["Surge of Strength"]="Surge of Strength",
		["Survivalist"]="Survivalist",
		["Sweeping Slam"]="Sweeping Slam",
		["Sweeping Strikes"]="Sweeping Strikes",
		["Sweet Surprise"]="Sweet Surprise",
		["Swiftmend"]="Swiftmend",
		["Swiftness of Zanza"]="Swiftness of Zanza",
		["Swim Speed"]="Swim Speed",
		["Swipe"]="Swipe",
		["Swoop"]="Swoop",
		["Sword Specialization"]="Sword Specialization",
		["System Shock"]="System Shock",
		["Tactical Mastery"]="Tactical Mastery",
		["Tainted Blood"]="Tainted Blood",
		["Tainted Howl"]="Tainted Howl",
		["Tailoring"]="Tailoring",
		["Talisman of Binding"]="Talisman of Binding",
		["Tame Beast"]="Tame Beast",
		["Tamed Pet Passive"]="Tamed Pet Passive",
		["Target Dummy Spawn Effect"]="Target Dummy Spawn Effect",
		["Target Lock"]="Target Lock",
		["Taunt"]="Taunt",
		["Tea with Sugar"]="Tea with Sugar",
		["Teleport: Darnassus"]="Teleport: Darnassus",
		["Teleport: Ironforge"]="Teleport: Ironforge",
		["Teleport: Moonglade"]="Teleport: Moonglade",
		["Teleport: Orgrimmar"]="Teleport: Orgrimmar",
		["Teleport: Stormwind"]="Teleport: Stormwind",
		["Teleport: Thunder Bluff"]="Teleport: Thunder Bluff",
		["Teleport: Undercity"]="Teleport: Undercity",
		["Tendon Rip"]="Tendon Rip",
		["Tendon Slice"]="Tendon Slice",
		["Terrify"]="Terrify",
		["Terrifying Howl"]="Terrifying Howl",
		["Terrifying Screech"]="Terrifying Screech",
		["Testament of Hope"]="Testament of Hope",
		["Tetanus"]="Tetanus",
		["The Big One"]="The Big One",
		["The Burrower's Shell"]="The Burrower's Shell",
		["The Eye of Diminution"]="The Eye of Diminution",
		["The Eye of the Dead"]="The Eye of the Dead",
		["The Furious Storm"]="The Furious Storm",
		["The Green Tower"]="The Green Tower",
		["The Human Spirit"]="The Human Spirit",
		["The Lion Horn of Stormwind"]="The Lion Horn of Stormwind",
		["Thick Hide"]="Thick Hide",
		["Thorium Grenade"]="Thorium Grenade",
		["Thorium Shield Spike"]="Thorium Shield Spike",
		["Thorn Volley"]="Thorn Volley",
		["Thorns"]="Thorns",
		["Thousand Blades"]="Thousand Blades",
		["Thrash"]="Thrash",
		["Threatening Gaze"]="Threatening Gaze",
		["Threatening Growl"]="Threatening Growl",
		["Throw"]="Throw",
		["Throw Axe"]="Throw Axe",
		["Throw Dynamite"]="Throw Dynamite",
		["Throw Liquid Fire"]="Throw Liquid Fire",
		["Throw Wrench"]="Throw Wrench",
		["Throwing Specialization"]="Throwing Specialization",
		["Throwing Weapon Specialization"]="Throwing Weapon Specialization",
		["Thrown"]="Thrown",
		["Thunder Bluff Gift of Friendship"]="Thunder Bluff Gift of Friendship",
		["Thunder Clap"]="Thunder Clap",
		["Thunderbrew Lager"]="Thunderbrew Lager",
		["Thunderclap"]="Thunderclap",
		["Thundering Strikes"]="Thundering Strikes",
		["Thunderfury"]="Thunderfury",
		["Thundershock"]="Thundershock",
		["Thunderstomp"]="Thunderstomp",
		["Tidal Charm"]="Tidal Charm",
		["Tidal Focus"]="Tidal Focus",
		["Tidal Mastery"]="Tidal Mastery",
		["Tiger Riding"]="Tiger Riding",
		["Tiger's Fury"]="Tiger's Fury",
		["Toasted Smorc"]="Toasted Smorc",
		["Torment"]="Torment",
		["Totem"]="Totem",
		["Totemic Focus"]="Totemic Focus",
		["Totemic Power"]="Totemic Power",
		["Touch of Death"]="Touch of Death",
		["Touch of Weakness"]="Touch of Weakness",
		["Touch of Zanzil"]="Touch of Zanzil",
		["Toughness"]="Toughness",
		["Toxic Saliva"]="Toxic Saliva",
		["Toxic Spit"]="Toxic Spit",
		["Toxic Volley"]="Toxic Volley",
		["Track Beasts"]="Track Beasts",
		["Track Demons"]="Track Demons",
		["Track Dragonkin"]="Track Dragonkin",
		["Track Elementals"]="Track Elementals",
		["Track Giants"]="Track Giants",
		["Track Hidden"]="Track Hidden",
		["Track Humanoids"]="Track Humanoids",
		["Track Undead"]="Track Undead",
		["Trample"]="Trample",
		["Tranquil Air Totem"]="Tranquil Air Totem",
		["Tranquil Spirit"]="Tranquil Spirit",
		["Tranquility"]="Tranquility",
		["Tranquilizing Poison"]="Tranquilizing Poison",
		["Tranquilizing Shot"]="Tranquilizing Shot",
		["Transporter Malfunction"]="Transporter Malfunction",
		["Trap"]="Trap",
		["Trap Mastery"]="Trap Mastery",
		["Travel Form"]="Travel Form",
		["Tremor Totem"]="Tremor Totem",
		["Tribal Leatherworking"]="Tribal Leatherworking",
		["Tricked or Treated"]="Tricked or Treated",
		["Trick"]="Trick",
		["Trogg Ale"]="Trogg Ale",
		["Trueshot Aura"]="Trueshot Aura",
		["Tunneler Acid"]="Tunneler Acid",
		["Turn Undead"]="Turn Undead",
		["Twisted Tranquility"]="Twisted Tranquility",
		["Twisting Nether"]="Twisting Nether",
		["Two-Handed Axes and Maces"]="Two-Handed Axes and Maces",
		["Two-Handed Axes"]="Two-Handed Axes",
		["Two-Handed Maces"]="Two-Handed Maces",
		["Two-Handed Swords"]="Two-Handed Swords",
		["Two-Handed Weapon Specialization"]="Two-Handed Weapon Specialization",
		["Unarmed"]="Unarmed",
		["Unbreakable Will"]="Unbreakable Will",
		["Unbridled Wrath Effect"]="Unbridled Wrath Effect",
		["Unbridled Wrath"]="Unbridled Wrath",
		["Undead Horsemanship"]="Undead Horsemanship",
		["Undercity Gift of Friendship"]="Undercity Gift of Friendship",
		["Underwater Breathing"]="Underwater Breathing",
		["Unending Breath"]="Unending Breath",
		["Unholy Aura"]="Unholy Aura",
		["Unholy Frenzy"]="Unholy Frenzy",
		["Unholy Power"]="Unholy Power",
		["Unholy Shield"]="Unholy Shield",
		["Universal Remote"]="Universal Remote",
		["Unleashed Fury"]="Unleashed Fury",
		["Unstable Concoction"]="Unstable Concoction",
		["Unstable Power"]="Unstable Power",
		["Untamed Fury"]="Untamed Fury",
		["Unyielding Faith"]="Unyielding Faith",
		["Updraft"]="Updraft",
		["Uppercut"]="Uppercut",
		["Uther's Light Effect"]="Uther's Light Effect",
		["Vampiric Embrace"]="Vampiric Embrace",
		["Vampirism"]="Vampirism",
		["Vanish"]="Vanish",
		["Vanished"]="Vanished",
		["Veil of Shadow"]="Veil of Shadow",
		["Vengeance"]="Vengeance",
		["Venom Shot"]="Venom Shot",
		["Venom Spit"]="Venom Spit",
		["Venom Sting"]="Venom Sting",
		["Venomhide Poison"]="Venomhide Poison",
		["Venomous Totem"]="Venomous Totem",
		["Very Berry Cream"]="Very Berry Cream",
		["Vicious Bite"]="Vicious Bite",
		["Vicious Rend"]="Vicious Rend",
		["Vigor"]="Vigor",
		["Vile Poisons"]="Vile Poisons",
		["Vindication"]="Vindication",
		["Viper Sting"]="Viper Sting",
		["Virulent Poison"]="Virulent Poison",
		["Visions of the Past"]="Visions of the Past",
		["Void Bolt"]="Void Bolt",
		["Volatile Infection"]="Volatile Infection",
		["Volley"]="Volley",
		["Voodoo Hex"]="Voodoo Hex",
		["Wail of the Banshee"]="Wail of the Banshee",
		["Wailing Dead"]="Wailing Dead",
		["Walking Bomb Effect"]="Walking Bomb Effect",
		["Wand Specialization"]="Wand Specialization",
		["Wandering Plague"]="Wandering Plague",
		["Wands"]="Wands",
		["War Stomp"]="War Stomp",
		["Warrior's Resolve"]="Warrior's Resolve",
		["Warrior's Wrath"]="Warrior's Wrath",
		["Washte Pawne's Resolve"]="Washte Pawne's Resolve",
		["Water"]="Water",
		["Water Breathing"]="Water Breathing",
		["Water Walking"]="Water Walking",
		["Wavering Will"]="Wavering Will",
		["Weak Frostbolt"]="Weak Frostbolt",
		["Weak Poison"]="Weak Poison",
		["Weakened Soul"]="Weakened Soul",
		["Weakening Disease"]="Weakening Disease",
		["Weaponsmith"]="Weaponsmith",
		["Web"]="Web",
		["Web Explosion"]="Web Explosion",
		["Web Spin"]="Web Spin",
		["Web Spray"]="Web Spray",
		["Well Fed"]="Well Fed",
		["Whipper Root Tuber"]="Whipper Root Tuber",
		["Whirling Barrage"]="Whirling Barrage",
		["Whirling Trip"]="Whirling Trip",
		["Whirlwind"]="Whirlwind",
		["Wide Slash"]="Wide Slash",
		["Wildvine Potion"]="Wildvine Potion",
		["Will of Hakkar"]="Will of Hakkar",
		["Will of Shahram"]="Will of Shahram",
		["Will of the Forsaken"]="Will of the Forsaken",
		["Wilt"]="Wilt",
		["Windblossom Berries"]="Windblossom Berries",
		["Windfury Totem"]="Windfury Totem",
		["Windfury Weapon"]="Windfury Weapon",
		["Windreaper"]="Windreaper",
		["Windsor's Frenzy"]="Windsor's Frenzy",
		["Windwall Totem"]="Windwall Totem",
		["Wing Clip"]="Wing Clip",
		["Wing Flap"]="Wing Flap",
		["Winter's Chill"]="Winter's Chill",
		["Wisdom of Agamaggan"]="Wisdom of Agamaggan",
		["Wisp Costume"]="Wisp Costume",
		["Wisp Spirit"]="Wisp Spirit",
		["Wither Strike"]="Wither Strike",
		["Wither Touch"]="Wither Touch",
		["Withered Touch"]="Withered Touch",
		["Withering Heat"]="Withering Heat",
		["Wolf Riding"]="Wolf Riding",
		["World Enlarger"]="World Enlarger",
		["Wound Poison II"]="Wound Poison II",
		["Wound Poison III"]="Wound Poison III",
		["Wound Poison IV"]="Wound Poison IV",
		["Wound Poison"]="Wound Poison",
		["Wound"]="Wound",
		["Wrath"]="Wrath",
		["Wyvern Sting"]="Wyvern Sting",
		["Yaaarrrr"]="Yaaarrrr",
		["Zeal"]="Zeal",
		["Zulian Slice"]="Zulian Slice",
		["Ancestral Fortitude"]="Ancestral Fortitude",
	}
end)

BabbleSpell:RegisterTranslations("zhCN", function()
	return {
		["Abolish Disease"]="驱除疾病",
		["Abolish Poison Effect"]="驱毒术效果",
		["Abolish Poison"]="驱毒术",
		["Acid Breath"]="酸息术",
		["Acid of Hakkar"]="哈卡酸液",
		["Acid Spit"]="酸液喷射",
		["Acid Splash"]="酸液溅射",
		["Activate MG Turret"]="速射炮台",
		["Admiral's Hat"]="将军之帽",
		["Adored"]="爱慕",
		["Adrenaline Rush"]="冲动",
		["Advanced Target Dummy Spawn Effect"]="Shiny Lure Spawn Effect",
		["Aegis Heal"]="庇护治疗",
		["Aegis of Preservation"]="庇护",
		["Aftermath"]="清算",
		["Agamaggan's Agility"]="阿迦玛甘的敏捷",
		["Agamaggan's Strength"]="阿迦玛甘的力量",
		["Aggression"]="侵略",
		["Agility"]="敏捷",
		["Intervene"] = "Intervene",
		["Aimed Shot"]="瞄准射击",
		["Alchemy"]="炼金术",
		["Alterac Spring Water"]="奥特兰克泉水",
		["Ambush"]="伏击",
		["Amplify Curse"]="诅咒增幅",
		["Amplify Damage"]="伤害增效",
		["Amplify Flames"]="火焰增效",
		["Amplify Magic"]="魔法增效",
		["Ancestor's Vengeance"]="先祖的复仇",
		["Ancestral Healing"]="先祖治疗",
		["Ancestral Knowledge"]="先祖知识",
		["Ancestral Spirit"]="先祖之魂",
		["Ancient Despair"]="上古绝望",
		["Ancient Dread"]="上古恐慌",
		["Ancient Hysteria"]="上古狂乱",
		["Anger Management"]="愤怒掌控",
		["Anticipation"]="预知",
		["Antimagic Pulse"]="反魔法脉冲",
		["Aqua Jet"]="水流喷射",
		["Aquatic Form"]="水栖形态",
		["Arcane Blast"]="奥术冲击",
		["Arcane Brilliance"]="奥术光辉",
		["Arcane Bolt"]="奥术箭",
		["Arcane Bomb"]="奥术炸弹",
		["Arcane Concentration"]="奥术专注",
		["Arcane Detonation"]="奥术爆炸",
		["Arcane Elixir"]="奥法药剂",
		["Arcane Explosion"]="魔爆术",
		["Arcane Focus"]="奥术集中",
		["Arcane Infused"]="奥术灌输",
		["Arcane Instability"]="奥术增效",
		["Arcane Intellect"]="奥术智慧",
		["Arcane Meditation"]="奥术冥想",
		["Arcane Mind"]="奥术心智",
		["Mass Dispel"] = "群体驱魔",
		["Arcane Missiles"]="奥术飞弹",
		["Arcane Missile"]="奥术飞弹",
		["Arcane Potency"]="奥术潜能",
		["Arcane Power"]="奥术强化",
		["Arcane Protection"]="奥术防护",
		["Arcane Resistance"]="奥术抗性",
		["Arcane Shot"]="奥术射击",
		["Arcane Shroud"]="奥术环绕",
		["Arcane Subtlety"]="奥术精妙",
		["Arcing Smash"]="圆弧斩",
		["Arctic Reach"]="极寒延伸",
		["Argent Avenger"]="银色复仇者",
		["Argent Dawn"]="银色黎明",
		["Argent Dawn Commission"]="银色黎明委任徽章",
		["Armageddon"]="末日决战",
		["Armor"]="护甲",
		["Armor of Faith"]="信仰",
		["Armor Shatter"]="护甲粉碎",
		["Armorsmith"]="护甲锻造师",
		["Arugal's Curse"]="阿鲁高的诅咒",
		["Arugal's Gift"]="阿鲁高的礼物",
		["Ascendance"]="优越",
		["Ashbringer"]="灰烬使者",
		["Aspect of Arlokk"]="娅尔罗的守护",
		["Aspect of Jeklik"]="耶克里克的守护",
		["Aspect of Mar'li"]="玛尔里的守护",
		["Aspect of the Beast"]="野兽守护",
		["Shamanistic Rage"] = "Shamanistic Rage",
		["Aspect of the Cheetah"] = "猎豹守护",
		["Aspect of the Hawk"] = "雄鹰守护",
		["Aspect of the Monkey"] = "灵猴守护",
		["Aspect of the Pack"] = "豹群守护",
		["Aspect of the Wild"]="野性守护",
		["Aspect of Venoxis"]="温诺希斯的守护",
		["Astral Recall"]="星界传送",
		["Attack"]="攻击",
		["Attacking"]="攻击",
		["Attuned Dampener"]="瘟疫中和器",
		["Aura of Command"]="统御光环",
		["Aura of Fear"]="恐惧光环",
		["Aura of Rot"]="腐蚀光环",
		["Aura of the Blue Dragon"]="蓝龙光环",
		["Aural Shock"]="听觉震荡",
		["Auto Shot"]="自动射击",
		["Axe Flurry"]="利斧乱舞",
		["Axe Toss"]="斧类武器投掷",
		["Axe Specialization"]="斧专精",
		["Aynasha's Arrow"]="阿娜莎之箭",
		["Aynasha's Bow"]="阿娜莎之弓",
		["Aynasha's Root"]="阿娜莎之根",
		["Backhand"]="反手一击",
		["Backstab"]="背刺",
		["Badge of the Swarmguard"]="虫群卫士徽章",
		["Bane"]="灾祸",
		["Baneful Poison"]="祸害之毒",
		["Banish"]="放逐术",
		["Banshee Curse"]="女妖诅咒",
		["Banshee Shriek"]="女妖尖叫",
		["Barbed Sting"]="倒钩之刺",
		["Barkskin Effect"]="树皮术效果",
		["Barkskin"]="树皮术",
		["Barrage"]="弹幕",
		["Bash"]="重击",
		["Basic Campfire"]="基础营火",
		["Basilisk Skin"]="蜥蜴之皮",
		["Bat Costume"]="蝙蝠装束",
		["Battle Fury"]="战斗狂怒",
		["Battle Shout"]="战斗怒吼",
		["Battle Stance Passive"]="战斗姿态（被动）",
		["Battle Squawk"]="作战鸣叫",
		["Battle Stance"]="战斗姿态",
		["Battle Standard"]="军旗",
		["Battlegear of Eternal Justice"]="永恒公正",
		["Battlegear of Might"]="力量",
		["Bear Form"]="熊形态",
		["Beast Lore"]="野兽知识",
		["Beast Slaying"]="野兽杀手",
		["Beast Training"]="训练野兽",
		["Befuddlement"]="笨拙术",
		["Benediction"]="祈福",
		["Berserker Charge"]="狂暴冲锋",
		["Berserker Rage"]="狂暴之怒",
		["Berserker Stance Passive"]="狂暴姿态（被动）",
		["Berserker Stance"]="狂暴姿态",
		["Berserking"]="狂暴",
		["Bestial Discipline"]="野兽戒律",
		["Bestial Swiftness"]="野兽迅捷",
		["Bestial Wrath"]="狂野怒火",
		["Big Bronze Bomb"]="重磅青铜炸弹",
		["Big Iron Bomb"]="重磅铁制炸弹",
		["Biletoad Infection"]="毒蟾蜍感染",
		["Bite"]="撕咬",
		["Black Arrow"]="黑箭",
		["Blackout"]="昏阙",
		["Blacksmithing"]="锻造",
		["Blade Flurry"]="剑刃乱舞",
		["Bladestorm"]="旋风斩",
		["Blast Wave"]="冲击波",
		["Summon Felguard"] = "召唤地狱卫士",
		["Blaze"]="光辉",
		["Blazing Emblem"]="闪耀徽章",
		["Blessed Recovery"]="神恩回复",
		["Blessed Sunfruit"]="神圣太阳果",
		["Blessed Sunfruit Juice"]="神圣太阳果汁",
		["Blessing of Blackfathom"]="黑暗深渊的祝福",
		["Blessing of Freedom"]="自由祝福",
		["Blessing of Kings"] = "王者祝福",
		["Blessing of Light"] = "光明祝福",
		["Blessing of Might"] = "力量祝福",
		["Blessing of Protection"] = "保护祝福",
		["Blessing of Sacrifice"] = "牺牲祝福",
		["Blessing of Salvation"] = "拯救祝福",
		["Blessing of Sanctuary"] = "庇护祝福",
		["Blessing of Shahram"]="沙赫拉姆的祝福",
		["Blessing of the Black Book"]="黑龙之书的祝福",
		["Blessing of the Claw"]="利爪祝福",
		["Blessing of Wisdom"]="智慧祝福",
		["Blight"]="荒芜",
		["Blind"]="致盲",
		["Blinding Light"]="盲目之光",
		["Blinding Powder"]="致盲粉",
		["Blink"]="闪现术",
		["Blizzard"]="暴风雪",
		["Block"]="格挡",
		["Blood Craze"]="血之狂热",
		["Blood Frenzy"]="血之狂暴",
		["Blood Funnel"]="鲜血通道",
		["Blood Fury"]="血性狂暴",
		["Blood Leech"]="吸血术",
		["Blood Pact"]="血之契印",
		["Bloodpetal Poison"]="血之契印",
		["Blood Siphon"]="血液虹吸",
		["Blood Tap"]="血液分流",
		["Bloodfang"]="血牙",
		["Victory Rush"] = "Victory Rush",
		["Silencing Shot"] = "沉默射击",
		["Bloodpetal Poison"]="血瓣花毒药",
		["Bloodrage"]="血性狂暴",
		["Bloodthirst"]="嗜血",
		["Boar Charge"]="野猪冲撞",
		["Bomb"]="炸弹",
		["Bone Armor"]="骨甲术",
		["Bonereaver's Edge"]="削骨之刃",
		["Bonespike"]="血矛",
		["Booming Voice"]="震耳嗓音",
		["Bottle of Poison"]="毒药瓶",
		["Boulder"]="投石",
		["Bow Specialization"]="弓专精n",
		["Bows"]="弓",
		["Brain Damage"]="脑部损伤",
		["Brain Food"]="补充营养",
		["Brain Hacker"]="碎灵",
		["Brain Wash"]="洗脑",
		["Breath of Fire"]="火焰吐息",
		["Bright Campfire"]="明亮篝火",
		["Brilliant Light"]="辉煌之光",
		["Brittle Armor"]="脆弱护甲",
		["Brutal Impact"]="野蛮冲",
		["Burning Soul"]="燃烧之魂",
		["Burst of Energy"]="能量爆发",
		["Burst of Knowledge"]="学识爆发",
		["Butcher Drain"]="屠夫吸取",
		["Buttermilk Delight"]="快乐奶油",
		["Cadaver Worms"]="死尸虫",
		["Call Pet"]="召唤宠物",
		["Call of Flame"]="烈焰召唤",
		["Call of the Grave"]="火焰的召唤",
		["Call of Thunder"]="雷霆召唤",
		["Camouflage"]="伪装",
		["Cannibalize"]="食尸",
		["Cannon Fire"]="炮火",
		["Cat Form"]="猎豹形态",
		["Cataclysm"]="灾变",
		["Cause Insanity"]="导致疯狂",
		["Cauterizing Flames"]="灼烧之焰",
		["Cenarion Favor"]="塞纳里奥的好感",
		["Ritual of Souls"] = "Ritual of Souls",
		["Chain Bolt"]="闪电链",
		["Chain Burn"]="法力燃烧链",
		["Chain Heal"]="治疗链",
		["Chain Healing Wave"]="链状治疗波",
		["Chain Lightning"]="闪电链",
		["Chained Bolt"]="闪电链",
		["Chains of Ice"]="冰链术",
		["Challenging Roar"]="挑战咆哮",
		["Challenging Shout"]="挑战怒吼",
		["Champion of the Dawn"]="黎明勇士",
		["Chaos Fire"]="混乱之火",
		["Charge Rage Bonus Effect"]="冲锋怒气加成效果",
		["Charge"]="冲锋",
		["Charge Stun"]="冲锋击昏",
		["Cheap Shot"]="偷袭",
		["Cheat Death"]="逃脱死亡",
		["Chicken Fury"]="小鸡之怒",
		["Chilled"]="冰冻",
		["Chilling Touch"]="寒冰之触",
		["Chitinous Spikes"]="几丁质尖刺",
		["Chromatic Infusion"]="多彩能量",
		["Chromatic Resistance"]="多彩抗性",
		["Circle of Flame"]="烈焰之环",
		["Claw"]="爪击",
		["Claw Grasp"]="利爪握取",
		["Clean Escape"]="净化逃脱",
		["Cleanse"]="清洁术",
		["Cleanse Nova"]="净化新星",
		["Clearcasting"]="节能施法",
		["Cleave"]="顺劈斩",
		["Cleave Armor"]="破甲斩",
		["Clever Traps"]="灵巧陷阱",
		["Cloak of Fire"]="火焰披风",
		["Cloaking"]="隐蔽",
		["Kill Command"] = "Kill Command",
		["Closing"]="关闭",
		["Cloth"]="布甲",
		["Coarse Dynamite"]="劣质炸药",
		["Coarse Sharpening Stone"]="粗制磨刀石",
		["Cobra Reflexes"]="毒蛇反射",
		["Cold Blood"]="冷血",
		["Cold Eye"]="冰冻之眼",
		["Cold Snap"]="急速冷却",
		["Cologne"]="古龙水",
		["Combat Endurance"]="作战持久",
		["Combustion"]="燃烧",
		["Command"]="命令",
		["Concentration Aura"]="专注光环",
		["Concussion Blow"]="震荡猛击",
		["Concussion"]="震荡",
		["Concussive Shot"]="震荡射击",
		["Cone of Cold"]="冰锥术",
		["Cone of Fire"]="火锥术",
		["Conflagrate"]="燃烧",
		["Conjure Food"]="造食术",
		["Conjure Mana Agate"]="制造魔法玛瑙",
		["Conjure Mana Citrine"]="制造魔法黄水晶",
		["Conjure Mana Jade"]="制造魔法翡翠",
		["Conjure Mana Ruby"]="制造魔法红宝石",
		["Conjure Water"]="造水术",
		["Consecrated Sharpening Stone"]="神圣磨刀石",
		["Consecration"]="奉献",
		["Consume Flesh"]="食肉",
		["Snake Trap"] = "Snake Trap",
		["Consume Shadows"]="吞噬暗影",
		["Consuming Shadows"]="吞噬之影",
		["Contagion of Rot"]="腐化传染",
		["Control Machine"]="控制机械",
		["Convection"]="传导",
		["Conviction"]="定罪",
		["Cooking"]="烹饪",
		["Corrosive Acid Breath"]="腐蚀酸液吐息",
		["Corrosive Ooze"]="腐蚀泥浆",
		["Corrosive Poison"]="腐蚀毒药",
		["Corrupted Blood"]="堕落之血",
		["Corrupted Intellect"]="腐化智力",
		["Corrupted Fear"]="腐化恐惧",
		["Corruption"]="腐蚀术",
		["Counterattack"]="反击",
		["Counterspell"]="法术反制",
		["Cower"]="畏缩",
		["Cozy Fire"]="惬意小火",
		["Crazed"]="癫狂",
		["Create Firestone"]="制造火焰石",
		["Create Healthstone"]="制造治疗石",
		["Create Soulstone"]="制造灵魂石",
		["Create Spellstone"]="制造法术石",
		["Creeper Venom"]="慢性毒药",
		["Creeping Mold"]="慢性毒菌",
		["Crest of Retribution"]="惩戒之盾",
		["Cripple"]="残废术",
		["Crippling Poison II"]="致残毒药 II",
		["Crippling Poison"]="致残毒药",
		["Critical Mass"]="火焰重击",
		["Crossbows"]="弓",
		["Crowd Pummel"]="群体打击",
		["Cruelty"]="残忍",
		["Crusader Strike"]="十字军打击",
		["Crusader's Wrath"]="十字军之怒",
		["Crystal Charge"]="爆炸水晶",
		["Crystal Force"]="精神水晶",
		["Crystal of Zin-Malor"]="辛玛洛水晶",
		["Crystal Restore"]="恢复水晶",
		["Crystal Spire"]="尖刺水晶",
		["Crystal Ward"]="防御水晶",
		["Crystal Yield"]="破甲水晶",
		["Crystalline Slumber"]="水晶沉睡",
		["Cultivation"]="栽培",
		["Cure Disease"]="祛病术",
		["Cure Poison"]="消毒术",
		["Curse of Agony"]="痛苦诅咒",
		["Curse of Blood"]="血之诅咒",
		["Curse of Doom Effect"]="厄运诅咒效果",
		["Curse of Doom"]="厄运诅咒",
		["Curse of Exhaustion"]="疲劳诅咒",
		["Curse of Idiocy"]="痴呆诅咒",
		["Curse of Mending"]="治疗诅咒",
		["Curse of Recklessness"]="鲁莽诅咒",
		["Curse of Shadow"]="暗影诅咒",
		["Curse of Shahram"]="沙赫拉姆诅咒",
		["Curse of Stalvan"]="斯塔文的诅咒",
		["Curse of the Elemental Lord"]="元素领主的诅咒",
		["Curse of the Fallen Magram"]="玛格拉姆灵魂诅咒",
		["Curse of Thorns"]="荆棘诅咒",
		["Curse of Thule"]="图勒的诅咒",
		["Curse of Timmy"]="提米的诅咒",
		["Curse of Tongues"]="语言诅咒",
		["Curse of Tuten'kash"]="图特卡什的诅咒",
		["Curse of Weakness"]="虚弱诅咒",
		["Curse of the Elements"]="元素诅咒",
		["Cursed Blood"]="诅咒之血",
		["Dagger Specialization"]="匕首专精",
		["Daggers"]="匕首",
		["Damage Absorb"]="伤害吸收",
		["Dampen Magic"]="魔法抑制",
		["Dark Desire"]="黑色欲望",
		["Dark Iron Bomb"]="黑铁炸弹",
		["Dark Mending"]="黑暗治疗",
		["Dark Offering"]="黑暗祭品",
		["Dark Pact"]="黑暗契约",
		["Dark Rune"]="黑暗符文",
		["Dark Sludge"]="黑暗污泥",
		["Dark Strike"]="黑暗打击",
		["Darken Vision"]="暗淡幻象",
		["Darkness"]="黑暗",
		["Darnassus Gift of Friendship"]="达纳苏斯友谊礼品包",
		["Dash"]="急奔",
		["Daunting Growl"]="威吓低吼",
		["Seed of Corruption"] = "Seed of Corruption",
		["Dazed"]="眩晕",
		["Deadly Poison II"]="致命毒药 II",
		["Deadly Poison III"]="致命毒药 III",
		["Deadly Poison IV"]="致命毒药 IV",
		["Deadly Poison V"]="致命毒药 V",
		["Deadly Poison"]="致命毒药",
		["Deadmines Dynamite"]="死亡矿井炸药",
		["Deafening Screech"]="震耳尖啸",
		["Death Coil"]="死亡缠绕",
		["Death Wish"]="死亡之愿",
		["Pain Suppression"] = "Pain Suppression",
		["Decapitate"]="斩首",
		["Decayed Agility"]="敏捷衰减",
		["Decayed Strength"]="力量衰减",
		["Deep Sleep"]="深度睡眠",
		["Deep Slumber"]="深度沉睡",
		["Deep Wound"]="重伤",
		["Defense"]="防御",
		["Defensive Stance Passive"]="防御姿态（被动）",
		["Defensive Stance"]="防御姿态",
		["Defensive State 2"]="防御状态 2",
		["Defensive State"]="防御状态",
		["Defiance"]="挑衅",
		["Defibrillate"]="电击",
		["Deflection"]="偏斜",
		["Delusions of Jin'do"]="金度的欺骗",
		["Demon Armor"]="魔甲术",
		["Demon Skin"]="恶魔皮肤",
		["Demonfork"]="恶魔之叉",
		["Demonic Embrace"]="恶魔之拥",
		["Demonic Rune"]="恶魔符文",
		["Demonic Sacrifice"]="恶魔牺牲",
		["Demoralizing Roar"]="挫志咆哮",
		["Demoralizing Shout"]="挫志怒吼",
		["Dense Dynamite"]="致密炸弹",
		["Dense Sharpening Stone"]="致密磨刀石",
		["Desperate Prayer"]="绝望祷言",
		["Destiny"]="命运",
		["Destructive Reach"]="毁灭延伸",
		["Detect Demon"]="侦测恶魔",
		["Detect Greater Invisibility"]="侦测强效隐形",
		["Detect Invisibility"]="侦测隐形",
		["Detect Lesser Invisibility"]="侦测次级隐形",
		["Detect Magic"]="侦测魔法",
		["Detect Traps"]="侦测陷阱",
		["Detect Undead"]="侦测亡灵",
		["Detect"]="侦测",
		["Deterrence"]="威慑",
		["Detonation"]="自爆",
		["Devastation"]="毁灭",
		["Devilsaur Fury"]="魔暴龙之怒",
		["Devotion Aura"]="虔诚光环",
		["Devour Magic Effect"]="吞噬魔法效果",
		["Devour Magic"]="吞噬魔法",
		["Devouring Plague"]="噬灵瘟疫",
		["Diamond Flask"]="钻石水瓶",
		["Dim Sum"]="点心",
		["Dimensional Siphon"]="维度虹吸",
		["Diplomacy"]="外交",
		["Dire Bear Form"]="巨熊形态",
		["Dire Growl"]="恐怖低吼",
		["Disarm Trap"]="解除陷阱",
		["Disarm"]="缴械",
		["Discombobulate"]="退化",
		["Disease Cleansing Totem"]="祛病图腾",
		["Disease Cloud"]="疾病之云",
		["Disease Touch"]="疾病之触",
		["Diseased Shot"]="疾病射击",
		["Diseased Spit"]="疾病喷吐",
		["Disenchant"]="分解",
		["Disengage"]="逃脱",
		["Disjunction"]="分离",
		["Dismiss Pet"]="解散野兽",
		["Dispel Magic"]="驱散魔法",
		["Dispel Poison"]="驱散毒药",
		["Distilled Wisdom"]="萃取智慧",
		["Distract"]="扰乱",
		["Distracting Pain"]="扰乱之痛",
		["Distracting Shot"]="扰乱射击",
		["Dive"]="俯冲",
		["Healing Way"]="治疗之道",
		["Divine Favor"]="神恩术",
		["Divine Fury"]="神圣之怒",
		["Divine Intellect"]="神圣智慧",
		["Divine Intervention"]="神圣干涉",
		["Divine Protection"]="圣佑术",
		["Divine Shield"]="圣盾术",
		["Divine Spirit"]="神圣之灵",
		["Divine Strength"]="神圣之力",
		["Diving Sweep"]="翻滚扫击",
		["Dodge"]="躲闪",
		["Dominate Mind"]="统御意志",
		["Dragonbreath Chili"]="龙息红椒",
		["Dragonscale Leatherworking"]="龙鳞制皮",
		["Dragon's Call"]="龙之召唤",
		["Drain Life"]="吸取生命",
		["Drain Mana"]="吸取法力",
		["Drain Soul"]="吸取灵魂",
		["Draw of Thistlenettle"]="希斯耐特吸血术",
		["Dreamless Sleep"]="无梦睡眠",
		["Dream Vision"]="梦境视界",
		["Dredge Sickness"]="病弱",
		["Drink"]="喝水",
		["Drink Minor Potion"]="喝下初级药水",
		["Druid's Slumber"]="德鲁伊的睡眠",
		["Dual Wield Specialization"]="双武器专精",
		["Dual Wield"]="双武器",
		["Duel"]="决斗",
		["Dust Cloud"]="灰尘之云",
		["Dust Field"]="灰尘力场",
		["Eagle Eye"]="鹰眼术",
		["Earth Shock"]="大地震击",
		["Earthbind"]="地缚术",
		["Earthbind Totem"]="地缚图腾",
		["Earthborer Acid"]="钻土虫酸液",
		["Earthgrab"]="陷地",
		["Earthshaker"]="震地者",
		["Earthstrike"]="大地之击",
		["Earthquake"]="地震术",
		["Echeyakee's Grace"]="埃其亚基的恩赐",
		["Efficiency"]="效率",
		["Elderberry Pie"]="蜜饯馅饼",
		["Electric Discharge"]="放电",
		["Electrified Net"]="充电网",
		["Elemental Focus"]="元素集中",
		["Elemental Fury"]="元素之怒",
		["Elemental Leatherworking"]="元素制皮",
		["Elemental Mastery"]="元素掌握",
		["Elemental Protection"]="元素防护",
		["Elemental Sharpening Stone"]="元素磨刀石",
		["Elemental Vulnerability"]="元素易伤",
		["Elixir of Brute Force"]="蛮力药剂",
		["Elixir of Demonslaying"]="屠魔药剂",
		["Elixir of Dodging"]="闪避药剂",
		["Elixir of Resistance"]="抗性药剂",
		["Elixir of the Giants"]="巨人药剂",
		["Elixir of the Mongoose"]="猫鼬药剂",
		["Elixir of the Sages"]="先知药剂",
		["Elune's Blessing"]="艾露恩的祝福",
		["Elune's Candle"]="艾露恩的蜡烛",
		["Elune's Grace"]="艾露恩的赐福",
		["Elusiveness"]="飘忽不定",
		["Emberstorm"]="琥珀风暴",
		["Enchanted Quickness"]="魔化迅捷",
		["Enchanting"]="附魔",
		["Endurance Training"]="耐久训练",
		["Endurance"]="耐久",
		["Energized Shield"]="能量护盾",
		["Engineering Specialization"]="工程学专精",
		["Engineering"]="工程学",
		["Engulfing Shadows"]="吞噬之影",
		["Enigma's Answer"]="神秘的答案",
		["Enlarge"]="巨化术",
		["Enrage"]="狂怒",
		["Enraging Memories"]="愤怒的回忆",
		["Enriched Manna Biscuit"]="可口的魔法点心",
		["Enslave Demon"]="奴役恶魔",
		["Entangle"]="纠缠",
		["Entangling Roots"]="纠缠根须",
		["Entrapment"]="诱捕",
		["Enveloping Web"]="包围之网",
		["Enveloping Webs"]="包围之网",
		["Enveloping Winds"]="包围之风",
		["Ephemeral Power"]="短暂强力",
		["Epiphany"]="显灵",
		["Escape Artist"]="逃命专家",
		["Eskhandar's Rage"]="伊森哈德之怒",
		["Eskhandar's Rake"]="伊森哈德扫击",
		["Essence of Sapphiron"]="萨菲隆的精华",
		["Evasion"]="闪避",
		["Eventide"]="Eventide",
		["Evil Twin"]="邪恶双子",
		["Eviscerate"]="剔骨",
		["Evocation"]="唤醒",
		["Execute"]="斩杀",
		["Exorcism"]="驱邪术",
		["Expansive Mind"]="开阔思维",
		["Explode"]="爆炸",
		["Exploding Shot"]="爆炸射击",
		["Exploit Weakness"]="攻击弱点",
		["Explosion"]="爆炸",
		["Explosive Sheep"]="自爆绵羊",
		["Explosive Shot"]="爆炸射击",
		["Explosive Trap Effect"]="爆炸陷阱效果",
		["Explosive Trap"]="爆炸陷阱",
		["Expose Armor"]="破甲",
		["Expose Weakness"] = "破甲虚弱",
		["Eye for an Eye"]="以眼还眼",
		["Eye of Kilrogg"]="基尔罗格之眼",
		["Eyes of the Beast"]="野兽之眼",
		["Ez-Thro Dynamite"]="简易投掷炸弹",
		["Fade"]="渐隐术",
		["Faerie Fire"]="精灵之火",
		["Faerie Fire (Feral)"]="精灵之火（野性）",
		["Fanatic Blade"]="狂热之刃",
		["Fanatic Blade Effect"]="狂热之刃效果",
		["Fang of the Crystal Spider"]="水晶蜘蛛之牙",
		["Far Sight"]="视界术",
		["Fatal Bite"]="致命刺痛",
		["Fatal Wound"]="重创",
		["Fear Ward"]="防护恐惧结界",
		["Fear"]="恐惧术",
		["Fearless"]="无畏",
		["Feed Pet"]="喂养宠物",
		["Feed Pet Effect"]="喂养宠物效果",
		["Feedback"]="回馈",
		["Feign Death"]="假死",
		["Feint"]="佯攻",
		["Fel Concentration"]="恶魔专注",
		["Fel Domination"]="恶魔支配",
		["Fel Intellect"]="恶魔智力",
		["Fel Stamina"]="恶魔耐力",
		["Counterspell - Silenced"]="法术反制 - 沉默",
		["Fel Stomp"]="恶魔践踏",
		["Felfire"]="魔火",
		["Feline Grace"]="豹之优雅",
		["Feline Swiftness"]="豹之迅捷",
		["Felstriker"]="恶魔之击",
		["Felstrom Resurrection"]="菲斯托姆复活",
		["Feral Aggression"]="野性侵略",
		["Feral Charge"]="野性冲锋",
		["Feral Instinct"]="野性本能",
		["Ferocious Bite"]="凶猛撕咬",
		["Ferocity"]="凶暴",
		["Festival Fortune!"]="节日的财富！",
		["Fetish"]="神像",
		["Fevered Fatigue"]="热疫疲倦",
		["Fevered Plague"]="热疫",
		["Fiend Fury"]="恶魔之怒",
		["Fiery Aura"]="烈焰光环",
		["Fiery Blaze"]="炽热火焰",
		["Fiery Burst"]="火焰爆发",
		["Fiery Weapon"]="灼热武器",
		["Find Herbs"]="寻找草药",
		["Find Minerals"]="寻找矿物",
		["Find Treasure"]="寻找财宝",
		["Fire Blast"]="火焰冲击",
		["Fire Blossom"]="火焰之花",
		["Fire Festival Fortitude"]="火焰节之韧",
		["Fire Festival Fury"]="火焰节之怒",
		["Fire Nova"]="火焰新星",
		["Fire Nova Totem"]="火焰新星图腾",
		["Fire Power"]="火焰强化",
		["Fire Protection"]="防护火焰",
		["Fire Reflector"]="火焰反射器",
		["Fire Resistance Aura"]="火焰抗性光环",
		["Fire Resistance Totem"]="抗火图腾",
		["Fire Resistance"]="火焰抗性",
		["Fire Shield"]="火焰之盾",
		["Fire Shield II"]="火焰之盾 II",
		["Fire Shield Effect"]="火焰之盾效果",
		["Fire Shield Effect II"]="火焰之盾效果 II",
		["Fire Shield Effect III"]="F火焰之盾效果 III",
		["Fire Shield Effect IV"]="火焰之盾效果 IV",
		["Fire Shot"]="火焰射击",
		["Fire Storm"]="火焰风暴",
		["Kick - Silenced"] = "脚踢 - 沉默",
		["Fire Strike"]="火焰打击",
		["Fire Vulnerability"]="痛苦诅咒",
		["Fire Ward"]="防护火焰结界",
		["Fireball"]="火球术",
		["Fireball Volley"]="连珠火球",
		["Firebolt"]="火焰箭",
		["Fire-toasted Bun"]="火烤甜面包",
		["Fire's Glow"]="火光",
		["First Aid"]="急救",
		["Fishing Poles"]="鱼竿",
		["Fishing"]="钓鱼",
		["Fishliver Oil"]="鱼肝油",
		["Fist of Ragnaros"]="拉格纳罗斯之拳",
		["Fist of Shahram"]="沙赫拉姆之拳",
		["Fist of Stone"]="石拳",
		["Fist Weapon Specialization"]="拳套专精",
		["Fist Weapons"]="拳套",
		["Fixate"]="凝视",
		["Flame Blast"]="烈焰冲击",
		["Flame Breath"]="火息术",
		["Flame Buffet"]="烈焰打击",
		["Flame Cannon"]="烈焰火炮",
		["Flame Lash"]="烈焰鞭笞",
		["Flame Shock"]="烈焰震击",
		["Flame Spear"]="烈焰之矛",
		["Flame Spike"]="烈焰尖刺",
		["Flame Spray"]="烈焰喷射",
		["Flame Throwing"]="烈焰投掷",
		["Flame Wrath"]="烈焰之怒",
		["Flames of Shahram"]="沙赫拉姆烈焰",
		["Flameshocker's Revenge"]="烈焰震击者的复仇",
		["Flameshocker's Touch"]="烈焰震击者之触",
		["Flamestrike"]="烈焰风暴",
		["Flamethrower"]="火焰喷射器",
		["Flametongue Attack"]="火舌攻击",
		["Flametongue Totem"]="火舌图腾",
		["Flametongue Weapon"]="火舌武器",
		["Flaming Cannonball"]="烈焰弹",
		["Flaming Shell"]="火焰弹",
		["Flare"]="照明弹",
		["Flash Bomb"]="闪光雷",
		["Flash Heal"]="快速治疗",
		["Flash of Light"]="圣光闪现",
		["Flask of the Titans"]="泰坦合剂",
		["Flaying Vine"]="劫掠之藤",
		["Flee"]="逃跑",
		["Flip Out"]="精神错乱",
		["Flurry"]="乱舞",
		["Focused Casting"]="专注施法",
		["Focus"]="集中",
		["Food"]="进食",
		["Forbearance"]="自律",
		["Force of Will"]="意志之力",
		["Force Punch"]="重击",
		["Force Reactive Disk"]="力反馈盾牌",
		["Forcefield Collapse"]="力场崩溃",
		["Forked Lightning"]="叉状闪电",
		["Form of the Moonstalker"]="月夜猛虎形态",
		["Forsaken Skills"]="遗弃技能",
		["Frailty"]="脆弱",
		["Freeze Solid"]="冰霜凝固",
		["Freeze"]="冰冻",
		["Free Action"]="自由行动",
		["Freezing Trap Effect"]="冰冻陷阱效果",
		["Freezing Trap"]="冰冻陷阱",
		["Frenzied Command"]="狂暴命令",
		["Frenzied Regeneration"]="狂暴回复",
		["Frenzy"]="疯狂",
		["Frightalon"]="惊骇之爪",
		["Frost Armor"]="霜甲术",
		["Frost Arrow"]="冰霜箭",
		["Frost Blast"]="冰霜冲击",
		["Frost Breath"]="冰息术",
		["Frost Channeling"]="冰霜导能",
		["Frost Nova"]="冰霜新星",
		["Frost Power"]="冰霜强化",
		["Frost Protection"]="防护冰霜",
		["Frost Reflector"]="冰霜反射器",
		["Frost Resistance Aura"]="冰霜抗性光环",
		["Frost Resistance Totem"]="抗寒图腾",
		["Frost Resistance"]="冰霜抗性",
		["Frost Shock"]="冰霜震击",
		["Frost Shot"]="冰霜射击",
		["Frost Trap"]="冰霜陷阱",
		["Frost Trap Aura"]="冰霜陷阱光环",
		["Frost Ward"]="防护冰霜结界",
		["Frostbite"]="霜寒刺骨",
		["Frostbolt"]="寒冰箭",
		["Frostbolt Volley"]="连发寒冰箭",
		["Frostbrand Weapon"]="冰封武器",
		["Unleashed Rage"] = "怒火释放",
		["Frostmane Strength"]="霜鬃之力",
		["Frosty Zap"]="寒冰恢复",
		["Fumble"]="迟钝术",
		["Furbolg Form"]="熊怪形态",
		["Furbolg Medicine Pouch"]="熊怪医疗包",
		["Furious Howl"]="狂怒之嚎",
		["Furor"]="激怒",
		["Fury of Forgewright"]="铸铁之怒",
		["Fury of Ragnaros"]="拉格纳罗斯之怒",
		["Fury of the Bogling"]="沼精之怒",
		["Gahz'ranka Slam"]="加兹兰卡猛击",
		["Gahz'rilla Slam"]="加兹瑞拉猛击",
		["Garrote"]="绞喉",
		["Gehennas' Curse"]="基赫纳斯的诅咒",
		["Generic"]="Generic",
		["Geyser"]="喷泉",
		["Ghost Costume"]="鬼魂装束",
		["Ghost Wolf"]="幽魂之狼",
		["Ghostly Strike"]="鬼魅攻击",
		["Gift of Arthas"]="阿尔萨斯的礼物",
		["Gift of Life"]="生命赐福",
		["Gift of Nature"]="自然赐福",
		["Gift of Stone"]="石之赐福",
		["Gift of the Wild"]="野性赐福",
		["Glacial Roar"]="寒冰咆哮",
		["Glimpse of Madness"]="疯狂之眼",
		["Glyph of Deflection"]="偏斜雕文",
		["Gnarlpine Vengeance"]="瘤背复仇",
		["Gnomish Death Ray"]="侏儒死亡射线",
		["Gnomish Rocket Boots"]="侏儒火箭靴",
		["Goblin Bomb"]="地精炸弹",
		["Goblin Dragon Gun"]="地精龙枪",
		["Goblin Mortar"]="地精迫击炮",
		["Goblin Rocket Boots"]="地精火箭靴",
		["Goblin Sapper Charge"]="地精工兵炸药",
		["Gordok Green Grog"]="戈多克绿酒",
		["Gordok Ogre Suit"]="戈多克食人魔装",
		["Gouge"]="凿击",
		["Grab Weapon"]="抓住武器",
		["Grace of Air Totem"]="风之优雅图腾",
		["Grace of Earth"]="大地之优雅",
		["Grasping Vines"]="缠绕之藤",
		["Great Rage"]="暴怒",
		["Great Stamina"]="持久耐力",
		["Greater Agility"]="强效敏捷",
		["Greater Arcane Elixir"]="强效奥法药剂",
		["Greater Armor"]="强效护甲",
		["Greater Blessing of Kings"] = "强效王者祝福",
		["Greater Blessing of Light"] = "强效光明祝福",
		["Greater Blessing of Might"] = "强效力量祝福",
		["Greater Blessing of Salvation"] = "强效拯救祝福",
		["Greater Blessing of Sanctuary"] = "强效庇护祝福",
		["Greater Blessing of Wisdom"]="强效智慧祝福",
		["Greater Dreamless Sleep"]="强效昏睡",
		["Greater Firepower"]="强效火力",
		["Greater Heal"]="强效治疗术",
		["Greater Healthstone"]="强效治疗石",
		["Greater Intellect"]="强效智力",
		["Greater Mark of the Dawn"]="强力黎明印记",
		["Greater Stoneshield"]="强效石盾",
		["Greater Water Breathing"]="强效水下呼吸",
		["Grim Reach"]="无情延伸",
		["Ground Stomp"]="大地践踏",
		["Ground Tremor"]="大地震颤",
		["Grounding Totem"]="根基图腾",
		["Grovel"]="匍匐",
		["Grow"]="成长",
		["Growl"]="低吼",
		["Guardian Effect"]="守护效果",
		["Guardian's Favor"]="守护者的宠爱",
		["Guile of the Raptor"]="迅猛龙的狡诈",
		["Guillotine"]="处斩",
		["Gun Specialization"]="枪械专精",
		["Guns"]="枪械",
		["Gust of Wind"]="阵风",
		["Gutgore Ripper"]="血腥撕裂者",
		["Hail Storm"]="冰雹",
		["Hallow's End Aura"]="复活节光环",
		["Hallow's End Candy"]="复活节糖果",
		["Hallow's End Fright"]="复活节惊骇",
		["Hammer of Justice"]="制裁之锤",
		["Hammer of Wrath"]="愤怒之锤",
		["Hamstring"]="断筋",
		["Hand of Ragnaros"]="拉格纳罗斯之手",
		["Harass"]="侵扰",
		["Hardiness"]="坚韧",
		["Harm Prevention Belt"]="侏儒防护腰带",
		["Haste"]="加速术",
		["Haunting Spirits"]="鬼魅灵魂",
		["Hawk Eye"]="鹰眼",
		["Head Butt"]="撞头",
		["Head Crack"]="裂颅",
		["Head Rush"]="冲动能量",
		["Remorseless"] = "冷酷",
		["Headmaster's Charge"]="院长之杖",
		["Heal"]="治疗术",
		["Heal Pet"]="治疗宠物",
		["Heal Self"]="自我治疗",
		["Healing Circle"]="治疗之环",
		["Healing Draught"]="治疗药膏",
		["Healing Focus"]="治疗专注",
		["Healing Light"]="治疗之光",
		["Healing Potion"]="治疗药水",
		["Healing Stream Totem"]="治疗之泉图腾",
		["Healing Touch"]="治疗之触",
		["Healing Wave"]="治疗波",
		["Health"]="生命",
		["Health II"]="生命 II",
		["Health Funnel"]="生命通道",
		["Health Regeneration"]="生命回复",
		["Healthstone"]="治疗石",
		["Healthy Spirit"]="强健灵魂",
		["Heart of the Scale"]="龙鳞之心",
		["Heart of the Wild"]="野性之心",
		["Heartbroken"]="心碎",
		["Heaven's Blessing"]="天堂祝福",
		["Heavy Dynamite"]="烈性炸药",
		["Heavy Sharpening Stone"]="重磨刀石",
		["Hellfire Effect"]="地狱烈焰效果",
		["Hellfire"]="地狱烈焰",
		["Hemorrhage"]="出血",
		["Herb Gathering"]="采集草药",
		["Herbalism"]="草药学",
		["Heroic Strike"]="英勇打击",
		["Heroism"]="英雄",
		["Hex"]="妖术",
		["Hex of Jammal'an"]="迦玛兰的妖术",
		["Hex of Ravenclaw"]="鸦爪妖术",
		["Hex of Weakness"]="虚弱妖术",
		["Hi-Explosive Bomb"]="高爆炸弹",
		["Hibernate"]="休眠",
		["Hide"]="隐藏",
		["Holy Fire"]="神圣之火",
		["Holy Light"]="圣光术",
		["Holy Mightstone"]="神圣力量之石",
		["Holy Nova"]="神圣新星",
		["Holy Power"]="神圣强化",
		["Holy Protection"]="防护神圣",
		["Holy Reach"]="神圣延伸",
		["Holy Shield"]="神圣之盾",
		["Holy Shock"]="神圣震击",
		["Holy Smite"]="圣光击",
		["Holy Specialization"]="神圣专精",
		["Holy Strength"]="神圣力量",
		["Holy Strike"]="神圣打击",
		["Holy Sunder"]="神圣破甲",
		["Holy Wrath"]="神圣愤怒",
		["Honorless Target"]="无荣誉目标",
		["Hooked Net"]="钩网",
		["Horse Riding"]="骑术：马",
		["Howl of Terror"]="恐惧嚎叫",
		["Howling Blade"]="哀嚎之刃",
		["Humanoid Slaying"]="人型生物杀手",
		["Hunter Armor Energize"]="猎人护甲充能",
		["Hunter's Mark"]="猎人印记",
		["Hurricane"]="飓风",
		["Ice Armor"]="冰甲术",
		["Ice Barrier"]="寒冰护体",
		["Ice Blast"]="冰爆术",
		["Ice Block"]="寒冰屏障",
		["Ice Claw"]="寒冰爪",
		["Ice Nova"]="寒冰新星",
		["Ice Shards"]="寒冰碎片",
		["Icicle"]="冰柱",
		["Icy Energy"]="寒冰能量",
		["Icy Grasp"]="寒冷抓握",
		["Ignite"]="点燃",
		["Ignite Mana"]="点燃法力",
		["Illidan's Fury"]="伊利丹之怒",
		["Illumination"]="启发",
		["Immolate"]="献祭",
		["Immolation Trap Effect"]="献祭陷阱效果",
		["Immolation Trap"]="献祭陷阱",
		["Immune Root"]="免疫定身",
		["Impact"]="冲击",
		["Impale"]="穿刺",
		["Impending Doom"]="末日降临",
		["Improved Ambush"]="强化伏击",
		["Improved Arcane Explosion"]="强化魔爆术",
		["Improved Arcane Missiles"]="强化奥术飞弹",
		["Improved Arcane Shot"]="强化奥术射击",
		["Improved Aspect of the Hawk"]="强化雄鹰守护",
		["Improved Aspect of the Monkey"]="强化灵猴守护",
		["Improved Backstab"]="强化背刺",
		["Improved Battle Shout"]="强化战斗怒吼",
		["Improved Berserker Rage"]="强化狂暴之怒",
		["Improved Blessing of Might"]="强化力量祝福",
		["Improved Blessing of Wisdom"]="强化智慧祝福",
		["Improved Blizzard"]="强化暴风雪",
		["Improved Blocking"]="强化格挡",
		["Improved Bloodrage"]="强化血性狂暴",
		["Improved Chain Heal"]="强化治疗链",
		["Improved Chain Lightning"]="强化闪电链",
		["Improved Challenging Shout"]="强化挑战怒吼",
		["Improved Charge"]="强化冲锋",
		["Improved Cheap Shot"]="强化偷袭",
		["Waterbolt"] =	"Waterbolt",
		["Improved Cleave"]="强化顺劈斩",
		["Improved Concentration Aura"]="强化专注光环",
		["Improved Concussive Shot"]="强化震荡射击",
		["Improved Cone of Cold"]="强化冰锥术",
		["Improved Corruption"]="强化腐蚀术",
		["Improved Counterspell"]="强化法术反制",
		["Improved Curse of Agony"]="强化痛苦诅咒",
		["Improved Curse of Exhaustion"]="强化疲劳诅咒",
		["Improved Curse of Weakness"]="强化虚弱诅咒",
		["Improved Dampen Magic"]="强化魔法抑制",
		["Improved Deadly Poison"]="强化致命毒药",
		["Improved Demoralizing Shout"]="强化挫志怒吼",
		["Improved Devotion Aura"]="强化虔诚光环",
		["Improved Disarm"]="强化缴械",
		["Improved Distract"]="强化扰乱",
		["Improved Drain Life"]="强化吸取生命",
		["Improved Drain Mana"]="强化吸取法力",
		["Improved Drain Soul"]="强化吸取灵魂",
		["Improved Enrage"]="强化狂怒",
		["Improved Enslave Demon"]="强化奴役恶魔",
		["Improved Entangling Roots"]="强化纠缠根须",
		["Improved Evasion"]="强化闪避",
		["Improved Eviscerate"]="强化剔骨",
		["Improved Execute"]="强化斩杀",
		["Improved Expose Armor"]="强化破甲",
		["Improved Eyes of the Beast"]="强化野兽之眼",
		["Improved Fade"]="强化渐隐术",
		["Improved Feign Death"]="强化假死",
		["Improved Fire Blast"]="强化火焰冲击",
		["Improved Fire Nova Totem"]="强化火焰新星图腾",
		["Improved Fire Ward"]="强化防护火焰结界",
		["Improved Fireball"]="强化火球术",
		["Improved Firebolt"]="强化火焰箭",
		["Improved Firestone"]="强化火焰石",
		["Improved Flamestrike"]="强化烈焰风暴",
		["Improved Flametongue Weapon"]="强化火舌武器",
		["Improved Flash of Light"]="强化圣光闪现",
		["Improved Frost Nova"]="强化冰霜新星",
		["Improved Frost Ward"]="强化防护冰霜结界",
		["Improved Frostbolt"]="强化寒冰箭",
		["Improved Frostbrand Weapon"]="强化冰封武器",
		["Improved Garrote"]="强化绞喉",
		["Wrath of Air Totem"] = "Wrath of Air Totem",
		["Improved Ghost Wolf"]="强化幽魂之狼",
		["Improved Gouge"]="强化凿击",
		["Improved Grace of Air Totem"]="强化风之优雅图腾",
		["Improved Grounding Totem"]="强化根基图腾",
		["Improved Hammer of Justice"]="强化制裁之锤",
		["Improved Hamstring"]="强化断筋",
		["Improved Healing Stream Totem"]="强化治疗之泉图腾",
		["Improved Healing Touch"]="强化治疗之触",
		["Improved Healing Wave"]="强化治疗波",
		["Improved Healing"]="强化治疗术",
		["Improved Health Funnel"]="强化生命通道",
		["Improved Healthstone"]="强化治疗石",
		["Improved Heroic Strike"]="强化英勇打击",
		["Improved Hunter's Mark"]="强化猎人印记",
		["Improved Immolate"]="强化献祭",
		["Improved Imp"]="强化小鬼",
		["Improved Inner Fire"]="强化心灵之火",
		["Improved Instant Poison"]="强化速效毒药",
		["Improved Intercept"]="强化拦截",
		["Improved Intimidating Shout"]="强化破胆怒吼",
		["Improved Judgement"]="强化审判",
		["Improved Kick"]="强化脚踢",
		["Improved Kidney Shot"]="强化肾击",
		["Improved Lash of Pain"]="强化剧痛鞭笞",
		["Improved Lay on Hands"]="强化圣疗术",
		["Improved Lesser Healing Wave"]="强化次级治疗波",
		["Improved Life Tap"]="强化生命分流",
		["Improved Lightning Bolt"]="强化闪电箭",
		["Unstable Affliction"] = "Unstable Affliction",
		["Improved Lightning Shield"]="强化闪电之盾",
		["Improved Magma Totem"]="强化熔岩图腾",
		["Improved Mana Burn"]="强化法力燃烧",
		["Improved Mana Shield"]="强化法力护盾",
		["Improved Mana Spring Totem"]="强化法力之泉图腾",
		["Improved Mark of the Wild"]="强化野性印记",
		["Improved Mend Pet"]="强化治疗宠物",
		["Improved Mind Blast"]="强化心灵震爆",
		["Improved Moonfire"]="强化月火术",
		["Improved Nature's Grasp"]="强化自然之握",
		["Improved Overpower"]="强化压制",
		["Improved Power Word: Fortitude"]="强化真言术：韧",
		["Improved Power Word: Shield"]="强化真言术：盾",
		["Improved Prayer of Healing"]="强化治疗祷言",
		["Improved Psychic Scream"]="强化心灵尖啸",
		["Improved Pummel"]="强化拳击",
		["Improved Regrowth"]="强化愈合",
		["Improved Reincarnation"]="强化复生",
		["Improved Rejuvenation"]="强化回春术",
		["Improved Rend"]="强化撕裂",
		["Improved Renew"]="强化恢复",
		["Improved Retribution Aura"]="强化惩罚光环",
		["Improved Revenge"]="强化复仇",
		["Improved Revive Pet"]="强化复活宠物",
		["Improved Righteous Fury"]="强化正义之怒",
		["Improved Rockbiter Weapon"]="强化石化武器",
		["Improved Rupture"]="强化割裂",
		["Improved Sap"]="强化闷棍",
		["Improved Scorch"]="强化灼烧",
		["Improved Scorpid Sting"]="强化毒蝎钉刺",
		["Improved Seal of Righteousness"]="强化正义圣印",
		["Improved Seal of the Crusader"]="强化十字军圣印",
		["Improved Searing Pain"]="强化灼热之痛",
		["Improved Searing Totem"]="强化灼热图腾",
		["Shadow Word: Death"] = "Shadow Word: Death",
		["Improved Serpent Sting"]="强化毒蛇钉刺",
		["Improved Shadow Bolt"]="强化暗影箭",
		["Improved Shadow Word: Pain"]="强化暗言术：痛",
		["Improved Shield Bash"]="强化盾击",
		["Improved Shield Block"]="强化盾牌格挡",
		["Improved Shield Wall"]="强化盾墙",
		["Improved Shred"]="强化撕碎",
		["Shield Bash - Silenced"] = "盾击 - 沉默",
		["Enamored Water Spirit"] = "被迷惑的水之魂",
		["Ancestral Fortitude"] = "先祖坚韧",
		["Improved Sinister Strike"]="强化邪恶攻击",
		["Improved Slam"]="强化猛击",
		["Improved Slice and Dice"]="强化切割",
		["Improved Spellstone"]="强化法术石",
		["Improved Sprint"]="强化疾跑",
		["Improved Starfire"]="强化星火术",
		["The Beast Within"] = "The Beast Within",
		["Improved Stoneclaw Totem"]="强化石爪图腾",
		["Improved Stoneskin Totem"]="强化石肤图腾",
		["Improved Strength of Earth Totem"]="强化大地之力图腾",
		["Improved Succubus"]="强化魅魔",
		["Improved Sunder Armor"]="强化破甲攻击",
		["Improved Taunt"]="强化嘲讽",
		["Improved Thorns"]="强化荆棘术",
		["Improved Thunder Clap"]="强化雷霆一击",
		["Improved Tranquility"]="强化宁静",
		["Improved Vampiric Embrace"]="强化吸血鬼的拥抱",
		["Improved Vanish"]="强化消失",
		["Improved Voidwalker"]="强化虚空行者",
		["Improved Windfury Weapon"]="强化风怒武器",
		["Improved Wing Clip"]="强化摔绊",
		["Improved Wrath"]="强化愤怒",
		["Incinerate"]="烧尽",
		["Maim"] = "Maim",
		["Incite Flames"]="煽动烈焰",
		["Increased Agility"]="敏捷提高",
		["Increased Intellect"]="智力提高",
		["Increased Spirit"]="精神提高",
		["Increased Stamina"]="耐力提高",
		["Infallible Mind"]="坚定信念",
		["Infected Bite"]="感染撕咬",
		["Infected Wound"]="感染之伤",
		["Inferno"]="地狱火",
		["Inferno Shell"]="地狱火罩",
		["Initiative"]="先发制人",
		["Inner Fire"]="心灵之火",
		["Inner Focus"]="心灵专注",
		["Innervate"]="激活",
		["Insect Swarm"]="虫群",
		["Insight"]="洞察",
		["Insight of the Qiraji"]="其拉的洞察",
		["Inspiration"]="灵感",
		["Instant Poison II"]="速效毒药 II",
		["Instant Poison III"]="速效毒药 III",
		["Instant Poison IV"]="速效毒药 IV",
		["Instant Poison V"]="速效毒药 V",
		["Instant Poison VI"]="速效毒药 VI",
		["Instant Poison"]="速效毒药",
		["Intensity"]="速效毒药",
		["Intercept"]="拦截",
		["Intercept Stun"]="拦截昏迷",
		["Intimidating Roar"]="破胆咆哮",
		["Intimidating Shout"]="破胆怒吼",
		["Intimidation"]="胁迫",
		["Intoxicating Venom"]="兴奋毒剂",
		["Invigorate"]="鼓舞",
		["Invisibility"]="隐形术",
		["Invulnerability"]="无敌",
		["Iron Grenade"]="铁皮手雷",
		["Iron Shield Spike"]="铁质盾刺",
		["Iron Will"]="钢铁意志",
		["Ironforge Gift of Friendship"]="铁炉堡友谊礼品包",
		["Ishamuhale's Rage"]="伊沙姆哈尔之怒",
		["Item - Purify"]="Item - Purify",
		["Jang'thraze"]="迦萨斯",
		["Jeklik's Crushing Blow"]="耶克里克的致命攻击",
		["Jewelcrafting"]="Jewelcrafting",
		["Jom Gabbar"]="沙虫之毒",
		["Judgement of Command"]="命令审判",
		["Judgement of Justice"]="公正审判",
		["Judgement of Light"]="圣光审判",
		["Judgement of Righteousness"]="正义审判",
		["Judgement of Wisdom"]="智慧审判",
		["Judgement of the Crusader"]="十字军审判",
		["Judgement"]="审判",
		["Juju Chill"]="魂能之寒",
		["Juju Ember"]="魂能之灰",
		["Juju Escape"]="魂能之遁",
		["Juju Flurry"]="魂能之速",
		["Juju Guile"]="魂能之诈",
		["Juju Might"]="魂能之击",
		["Juju Power"]="魂能之力",
		["Julie's Blessing"]="朱莉叶的祝福",
		["Keeper's Sting"]="守护之刺",
		["Kick"]="脚踢",
		["Kidney Shot"]="肾击",
		["Killer Instinct"]="杀戮本能",
		["King of the Gordok"]="戈多克之王",
		["Kiss of the Spider"]="蜘蛛之吻",
		["Knock Away"]="击退",
		["Knockdown"]="击倒",
		["Kodo Riding"]="科多兽坐骑",
		["Kreeg's Stout Beatdown"]="克雷格的烈酒",
		["Lakota'mani's Thunder"]="拉克塔曼尼的雷霆",
		["Large Copper Bomb"]="大型铜壳炸弹",
		["Large Seaforium Backfire"]="大型爆盐炸弹逆火",
		["Larva Goo"]="幼虫粘液",
		["Lash"]="鞭笞",
		["Lash of Pain"]="剧痛鞭笞",
		["Last Stand"]="破釜沉舟",
		["Lasting Judgement"]="持久审判",
		["Lava Bomb"]="熔岩炸弹",
		["Lava Breath"]="熔岩吐息",
		["Lava Spout Totem"]="熔岩喷射图腾",
		["Lay on Hands"]="圣疗术",
		["Leader of the Pack"]="兽群领袖",
		["Leather"]="皮甲",
		["Leatherworking"]="制皮",
		["Leech Poison"]="吸血毒药",
		["Leper Gnome Costume"]="麻风侏儒装束",
		["Lesser Agility"]="次级敏捷",
		["Lesser Armor"]="次级护甲",
		["Lesser Heal"]="次级治疗术",
		["Lesser Healing Wave"]="次级治疗波",
		["Lesser Healthstone"]="次级治疗石",
		["Lesser Intellect"]="次级智力",
		["Lesser Invisibility"]="次级隐形术",
		["Lesser Mark of the Dawn"]="次级黎明印记",
		["Lesser Strength"]="次级力量",
		["Lethal Shots"]="夺命射击",
		["Lethality"]="致命偷袭",
		["Levitate"]="漂浮术",
		["Libram"]="圣物",
		["Lich Slap"]="巫妖之击",
		["Life Harvest"]="生命收割",
		["Life Steal"]="生命偷取",
		["Life Tap"]="生命分流",
		["Lifegiving Gem"]="生命宝石",
		["Lifestone Healing"]="生命石治疗",
		["Light of Elune"]="月神之光",
		["Lightheaded"]="使用节日酒杯",
		["Lightning"]="闪电",
		["Lightning Barrier"]="闪电屏障",
		["Lightning Blast"]="闪电震爆",
		["Lightning Bolt"]="闪电箭",
		["Lightning Breath"]="闪电吐息",
		["Lightning Cloud"]="落雷之云",
		["Lightning Mastery"]="闪电掌握",
		["Lightning Reflexes"]="闪电反射",
		["Lightning Shield"]="闪电之盾",
		["Lightning Strike"]="闪电攻击",
		["Lightning Wave"]="闪电波",
		["Lightwell Renew"]="光明之泉回复",
		["Lightwell"]="光明之泉",
		["Linken's Boomerang"]="林克的回旋镖",
		["Living Bomb"]="活化炸弹",
		["Living Free Action"]="活力自由行动",
		["Living Flames"]="活化烈焰",
		["Lizard Bolt"]="蜥蜴之矢",
		["Loatheb's Reflection"]="洛欧塞布之影",
		["Localized Toxin"]="局部毒药",
		["Lockpicking"]="开锁",
		["Long Daze"]="长时间眩晕",
		["Longsight"]="长视术",
		["Lord General's Sword"]="安格弗的剑",
		["Low Swipe"]="扫荡",
		["Lucifron's Curse"]="鲁西弗隆的诅咒",
		["Luffa"]="丝瓜",
		["Ice Lance"] = "Ice Lance",
		["Lunar Fortune"]="春节的财富！",
		["M73 Frag Grenade"]="M73破片手榴弹",
		["Mace Specialization"]="锤类武器专精",
		["Mace Stun Effect"]="锤击昏迷效果",
		["Machine Gun"]="机关枪",
		["Mage Armor"]="魔甲术",
		["Magenta Cap Sickness"]="紫色蘑菇疾病",
		["Maggot Slime"]="蛆虫粘液",
		["Magic Wings"]="魔法之翼",
		["Magma Shackles"]="熔岩镣铐",
		["Totem of Wrath"] = "Totem of Wrath",
		["Magma Splash"]="熔岩喷溅",
		["Magma Totem"]="熔岩图腾",
		["Mail"]="锁甲",
		["Major Healthstone"]="特效治疗石",
		["Malice"]="恶意",
		["Malfunction"]="故障",
		["Malfunction Explosion"]="故障爆炸",
		["Malown's Slam"]="马龙之肘",
		["Mana Burn"]="法力燃烧",
		["Mana Drain"]="吸取法力",
		["Mana Infusion"]="法力灌注",
		["Mana Regeneration"]="法力回复",
		["Mana Rejuvenation"]="法力再生",
		["Mana Shield"]="法力护盾",
		["Mana Spring Totem"]="法力之泉图腾",
		["Mana Surge"]="法力澎湃",
		["Mana Tide Totem"]="法力之潮图腾",
		["Mangle"]="割碎",
		["Mark of Arlokk"]="娅尔罗的印记",
		["Mark of Flames"]="烈焰印记",
		["Mark of Shame"]="耻辱印记",
		["Mark of the Chosen"]="天选印记",
		["Mark of the Chosen Effect"]="天选印记效果",
		["Mark of the Dawn"]="黎明印记",
		["Mark of the Dragon Lord"]="龙王印记",
		["Mark of the Wild"]="野性印记",
		["Martyrdom"]="殉难",
		["Mar'li's Brain Boost"]="玛尔里的思想加速",
		["Massive Destruction"]="大规模杀伤性魔法",
		["Massive Tremor"]="剧烈震颤",
		["Master Angler"]="钓鱼大师",
		["Master Demonologist"]="恶魔学识大师",
		["Master Summoner"]="召唤大师",
		["Master of Deception"]="欺诈高手",
		["Maul"]="槌击",
		["Mechanical Patch Kit"]="机械修补包",
		["Mechanostrider Piloting"]="骑术：机械陆行鸟",
		["Meditation"]="冥想",
		["Megavolt"]="百万伏特",
		["Melee Specialization"]="近战专精",
		["Melt Armor"]="熔化护甲",
		["Melt Ore"]="熔化矿石",
		["Mend Pet"]="治疗宠物",
		["Mental Agility"]="精神敏锐",
		["Mental Strength"]="心灵之力",
		["Mercurial Shield"]="水银护盾",
		["Metamorphosis Rune"]="变形符文",
		["Midsummer Sausage"]="仲夏腊肠",
		["Might of Shahram"]="沙赫拉姆之力",
		["Mighty Blow"]="全力一击",
		["Mighty Rage"]="强效怒气",
		["Mind Blast"]="心灵震爆",
		["Mind Control"]="精神控制",
		["Mind Flay"]="精神鞭笞",
		["Mind Quickening"]="思维敏捷",
		["Mind Soothe"]="安抚心灵",
		["Mind Tremor"]="心灵震颤",
		["Mind Vision"]="心灵视界",
		["Mind-numbing Poison II"]="麻痹毒药 II",
		["Mind-numbing Poison III"]="麻痹毒药n III",
		["Mind-numbing Poison"]="麻痹毒药",
		["Minions of Malathrom"]="玛拉索姆的爪牙",
		["Mining"]="采矿",
		["Minor Healthstone"]="初级治疗石",
		["Miring Mud"]="黑暗泥浆",
		["Mistletoe"]="槲寄生",
		["Mithril Frag Bomb"]="秘银破片炸弹",
		["Mithril Shield Spike"]="秘银盾刺",
		["Mobility Malfunction"]="活动故障",
		["Mocking Blow"]="惩戒痛击",
		["Moist Towelette"]="潮湿毛巾",
		["Molten Blast"]="熔岩爆裂",
		["Molten Metal"]="熔铁之水",
		["Mongoose Bite"]="猫鼬撕咬",
		["Monster Slaying"]="怪物杀手",
		["Moonfire"]="月火术",
		["Moonfury"]="月怒",
		["Moonglow"]="月光",
		["Moonkin Aura"]="枭兽光环",
		["Moonkin Form"]="枭兽形态",
		["Mortal Cleave"]="致死顺劈",
		["Mortal Shots"]="致死射击",
		["Mortal Strike"]="致死打击",
		["Moss Hide"]="苔鲜之皮",
		["Multi-Shot"]="多重射击",
		["Murder"]="谋杀",
		["Muscle Tear"]="撕裂肌肉",
		["Mystical Disjunction"]="秘法分离",
		["Naralex's Nightmare"]="纳拉雷克斯的梦魇",
		["Naraxis Web"]="纳拉克西斯之网",
		["Natural Armor"]="自然护甲",
		["Natural Shapeshifter"]="自然变形",
		["Natural Weapons"]="武器平衡",
		["Nature Aligned"]="自然之盟",
		["Nature Protection"]="防护自然",
		["Nature Resistance Totem"]="自然抗性图腾",
		["Nature Resistance"]="自然抗性",
		["Nature's Ally"]="自然之友",
		["Nature's Bounty"]="自然的慷慨",
		["Nature's Focus"]="自然集中",
		["Nature's Grace"]="自然之赐",
		["Nature's Grasp"]="自然之握",
		["Nature's Reach"]="自然延伸",
		["Nature's Swiftness"]="自然迅捷",
		["Net"]="投网",
		["Netherwind Focus"]="灵风专注",
		["Net-o-Matic"]="撒网器",
		["Night Dragon's Breath"]="夜龙之息",
		["Nightfall"]="夜幕",
		["Nimble Healing Touch"]="敏捷治疗之触",
		["Nimble Reflexes"]="迅捷反射",
		["Ninja Costume"]="忍者装束",
		["Noggenfogger Elixir"]="诺格弗格药剂",
		["Not There"]="移位",
		["Noxious Catalyst"]="毒害之灾",
		["Noxious Cloud"]="毒害之云",
		["Numbing Pain"]="麻木之痛",
		["Obsidian Insight"]="黑曜石洞察",
		["Omen of Clarity"]="清晰预兆",
		["One-Handed Axes"]="单手斧",
		["One-Handed Maces"]="单手锤",
		["One-Handed Swords"]="单手剑",
		["One-Handed Weapon Specialization"]="单手武器专精",
		["Opening - No Text"]="Opening - No Text",
		["Opening"]="打开",
		["Opportunity"]="伺机而动",
		["Oracular Heal"]="神谕治疗",
		["Orb of Deception"]="欺诈宝珠",
		["Orgrimmar Gift of Friendship"]="奥格瑞玛友谊礼品包",
		["Overpower"]="压制",
		["Pacify"]="抚慰",
		["Pagle's Broken Reel"]="纳格的卷尺",
		["Panic"]="恐慌",
		["Paralyzing Poison"]="麻痹之毒",
		["Paranoia"]="多疑",
		["Parasite"]="寄生",
		["Parasitic Serpent"]="寄生蛇",
		["Parry"]="招架",
		["Party Time!"]="派对时间！",
		["Pathfinding"]="寻路",
		["Perception"]="感知",
		["Perfume"]="熏香",
		["Permafrost"]="极寒冰霜",
		["Persistent Shield"]="持续护盾",
		["Pet Aggression"]="宠物好斗",
		["Pet Hardiness"]="宠物耐久",
		["Pet Recovery"]="宠物恢复",
		["Pet Resistance"]="宠物抗魔",
		["Petrification"]="石化",
		["Petrify"]="僵化",
		["Phantom Strike"]="幽影突袭",
		["Phase Shift"]="相位变换",
		["Physical Protection"]="物理防护",
		["Piccolo of the Flaming Fire"]="烈焰短笛",
		["Pick Lock"]="开锁",
		["Pick Pocket"]="偷窃",
		["Pierce Armor"]="刺穿护甲",
		["Piercing Howl"]="刺耳怒吼",
		["Piercing Ice"]="刺骨寒冰",
		["Piercing Shadow"]="刺骨暗影",
		["Piercing Shot"]="穿刺射击",
		["Pirate Costume"]="海盗装束",
		["Plague Cloud"]="瘟疫之云",
		["Plague Mind"]="瘟疫心灵",
		["Plate Mail"]="板甲",
		["Poison"]="毒药",
		["Poison Bolt"]="毒液箭",
		["Poison Bolt Volley"]="毒箭之雨",
		["Poison Cleansing Totem"]="清毒图腾",
		["Poison Cloud"]="毒云",
		["Poison Shock"]="毒性震击",
		["Poisoned Harpoon"]="毒性鱼叉",
		["Poisoned Shot"]="毒性射击",
		["Poisonous Blood"]="酸性血液",
		["Poisonous Stab"]="含毒之刺",
		["Poisons"]="毒药",
		["Shadowfury"] = "Shadowfury",
		["Polearm Specialization"]="长柄武器专精",
		["Polearms"]="长柄武器",
		["Polished Armor"]="打磨护甲",
		["Polymorph"]="变形术",
		["Polymorph: Chicken"]="变鸡术",
		["Polymorph: Pig"]="变形术：猪",
		["Polymorph: Turtle"]="变形术：龟",
		["Portal: Darnassus"] = "传送门：达纳苏斯",
		["Portal: Ironforge"] = "传送门：铁炉堡",
		["Portal: Orgrimmar"] = "传送门：奥格瑞玛",
		["Portal: Stormwind"] = "传送门：暴风城",
		["Portal: Thunder Bluff"] = "传送门：雷霆崖",
		["Portal: Undercity"] = "传送门：幽暗城",
		["Potion Strength II"]="药水力量 II",
		["Pounce Bleed"]="血袭",
		["Pounce"]="突袭",
		["Power Infusion"]="能量灌注",
		["Power of the Guardian"]="守护者的力量",
		["Power Word: Fortitude"]="真言术：韧",
		["Power Word: Shield"]="真言术：盾",
		["Prayer Beads Blessing"]="祈祷之珠",
		["Prayer of Fortitude"]="坚韧祷言",
		["Prayer of Healing"]="治疗祷言",
		["Prayer of Shadow Protection"]="暗影防护祷言",
		["Prayer of Spirit"]="精神祷言",
		["Precision"]="精确",
		["Predatory Strikes"]="猛兽攻击",
		["Premeditation"]="预谋",
		["Preparation"]="伺机待发",
		["Presence of Death"]="死亡显现",
		["Presence of Mind"]="气定神闲",
		["Primal Blessing"]="原始祝福",
		["Primal Fury"]="原始狂怒",
		["Primal Instinct"]="原始本能",
		["Prismstone"]="彩色石",
		["Proudmoore's Defense"]="普罗德摩尔的防护",
		["Proximity Bomb Explode"]="自走炸弹爆炸",
		["Prowl"]="潜伏",
		["Psychic Scream"]="心灵尖啸",
		["Pummel"]="拳击",
		["Puncture"]="刺破",
		["Puncture Armor"]="刺破护甲",
		["Purge"]="净化术",
		["Purification"]="净化",
		["Purify"]="纯净术",
		["Pursuit of Justice"]="正义追击",
		["Putrid Breath"]="腐烂气息",
		["Putrid Enzyme"]="腐烂蛋白",
		["Pyroblast"]="炎爆术",
		["Pyroclasm"]="火焰冲撞",
		["Pyroclast Barrage"]="火屑弹幕",
		["Quick Bloodlust"]="快速嗜",
		["Quick Flame Ward"]="快速烈焰防护结界",
		["Quick Frost Ward"]="快速冰霜防护结界",
		["Quick Shot"]="快速射击",
		["Quick Shots"]="快速射击",
		["Quick Sidestep"]="快速回避",
		["Quickness"]="迅捷",
		["Quill Shot"]="毒刺射击",
		["Rabies"]="狂犬病",
		["Radiation"]="辐射",
		["Radiation Bolt"]="辐射之箭",
		["Radiation Cloud"]="辐射之云",
		["Rage"]="怒气",
		["Rage of Ages"]="远古之怒",
		["Ragged John's Neverending Cup"]="约翰的无尽之杯",
		["Rain of Fire"]="火焰之雨",
		["Rake"]="扫击",
		["Ram Riding"]="骑术：羊",
		["Rampage"]="暴怒",
		["Ramstein's Lightning Bolts"]="拉姆斯登的闪电钉",
		["Rancid Blood"]="腐臭之血",
		["Ranged Weapon Specialization"]="远程武器专精",
		["Rapid Concealment"]="Rapid Concealment",
		["Rapid Fire"]="急速射击",
		["Rapid Healing"]="疾速治疗",
		["Raptor Punch"]="龙血酒",
		["Raptor Riding"]="骑术：迅猛龙",
		["Raptor Strike"]="猛禽一击",
		["Ravage"]="毁灭",
		["Ravenous Claw"]="困兽之爪",
		["Razor Mane"]="剃刀之鬃",
		["Razorhide"]="野猪之皮",
		["Reactive Fade"]="活性消隐",
		["Readiness"]="准备就绪",
		["Rebirth"]="复生",
		["Rebuild"]="重建",
		["Recently Bandaged"]="新近包扎",
		["Reckless Charge"]="无畏冲锋",
		["Recklessness"]="鲁莽",
		["Reckoning"]="清算",
		["Recombobulate"]="激活净化器",
		["Redemption"]="救赎",
		["Redoubt"]="盾牌壁垒",
		["Reflection"]="反射",
		["Refocus"]="重新准备",
		["Regeneration"]="再生",
		["Regrowth"]="愈合",
		["Reincarnation"]="复生",
		["Rejuvenation"]="回春术",
		["Rejuvenation Potion"]="回春药水",
		["Relentless Strikes"]="无情打击",
		["Remorseless Attacks"]="冷酷攻击",
		["Remove Curse"]="解除诅咒",
		["Remove Insignia"]="解除徽记",
		["Remove Lesser Curse"]="解除次级诅咒",
		["Rend"]="撕裂",
		["Rend Flesh"]="撕裂肉体",
		["Renew"]="恢复",
		["Repentance"]="忏悔",
		["Replenish Mana"]="补充法力",
		["Repulsive Gaze"]="憎恨怒视",
		["Resist Fire"]="抵抗火焰",
		["Resistance"]="抗性",
		["Restless Strength"]="充沛之力",
		["Restoration"]="恢复",
		["Restore Energy"]="恢复能量",
		["Restore Life"]="恢复生命",
		["Restore Mana"]="恢复法力",
		["Resurrection"]="复活术",
		["Retaliation"]="反击风暴",
		["Retribution Aura"]="惩罚光环",
		["Revealed Flaw"]="破绽",
		["Revenge Stun"]="复仇昏迷",
		["Revenge"]="复仇",
		["Reverberation"]="回响",
		["Revitalize"]="新生",
		["Revive Pet"]="复活宠物",
		["Rhahk'Zor Slam"]="拉克佐猛击",
		["Ribbon of Souls"]="灵魂撕裂",
		["Righteous Fury"]="正义之怒",
		["Rip"]="撕扯",
		["Riposte"]="还击",
		["Rising Spirit"]="高涨士气",
		["Ritual of Doom Effect"]="末日仪式效果",
		["Ritual of Doom"]="末日仪式",
		["Ritual of Summoning"]="召唤仪式",
		["Rockbiter Weapon"]="石化武器",
		["Rocket Blast"]="火箭爆炸",
		["Rocket Boots Malfunction"]="火箭靴故障",
		["Rogue Armor Energize"]="盗贼护甲充能",
		["Rogue Passive"]="盗贼被动效果",
		["Rough Copper Bomb"]="劣质铜壳炸弹",
		["Rough Dynamite"]="劣质炸药",
		["Rough Sharpening Stone"]="劣质磨刀石",
		["Ruin"]="毁灭",
		["Running Speed"]="跑步速度",
		["Rupture"]="割裂",
		["Rushing Charge"]="急速冲锋",
		["Ruthlessness"]="无情",
		["Sacred Cleansing"]="神圣净化",
		["Sacrifice"]="牺牲",
		["Safe Fall"]="安全降落",
		["Sanctified Orb"]="神圣宝珠",
		["Sanctity Aura"]="圣洁光环",
		["Sanctuary"]="庇护",
		["Summon Water Elemental"] = "召唤水元素",
		["Sap"]="闷棍",
		["Sapper Explode"]="工兵爆破",
		["Savage Fury"]="野蛮暴怒",
		["Savage Strikes"]="野蛮打击",
		["Savagery"]="野性",
		["Savior's Sacrifice"]="救助者的牺牲",
		["Sayge's Dark Fortune of Agility"]="塞格的黑暗塔罗牌：敏捷",
		["Sayge's Dark Fortune of Armor"]="塞格的黑暗塔罗牌：护甲",
		["Sayge's Dark Fortune of Damage"]="塞格的黑暗塔罗牌：伤害",
		["Sayge's Dark Fortune of Intelligence"]="塞格的黑暗塔罗牌：智力",
		["Sayge's Dark Fortune of Resistance"]="塞格的黑暗塔罗牌：抗性",
		["Sayge's Dark Fortune of Spirit"]="塞格的黑暗塔罗牌：精神",
		["Sayge's Dark Fortune of Stamina"]="塞格的黑暗塔罗牌：耐力",
		["Sayge's Dark Fortune of Strength"]="塞格的黑暗塔罗牌：力量",
		["Scare Beast"]="恐吓野兽",
		["Scarlet Illusion"]="血色幻象",
		["Scatter Shot"]="驱散射击",
		["Scorch"]="灼烧",
		["Scorpid Poison"]="蝎毒",
		["Scorpid Sting"]="毒蝎钉刺",
		["Screams of the Past"]="往日的尖啸",
		["Screech"]="尖啸",
		["Scourge Strike"]="天灾打击",
		["Seal Fate"]="封印命运",
		["Seal of Command"]="命令圣印",
		["Seal of Justice"]="公正圣印",
		["Spell Reflection"] = "法术反转",
		["Seal of Light"]="光明圣印",
		["Seal of Reckoning"]="清算圣印",
		["Seal of Righteousness"]="正义圣印",
		["Seal of Wisdom"]="智慧圣印",
		["Seal of the Crusader"]="十字军圣印",
		["Searing Arrow"]="灼热箭",
		["Searing Blast"]="灼热冲击",
		["Searing Light"]="灼热之光",
		["Searing Pain"]="灼热之痛",
		["Searing Totem"]="灼热图腾",
		["Second Wind"] = "复苏之风",
		["Seduction"]="诱惑",
		["Seeping Willow"]="横扫重锤",
		["Self Healing"]="自我治疗",
		["Self Invulnerability"]="无敌",
		["Sense Demons"]="感知恶魔",
		["Sense Undead"]="感知亡灵",
		["Sentry Totem"]="岗哨图腾",
		["Serpent Sting"]="毒蛇钉刺",
		["Serpent's Hiss"]="毒蛇嘶鸣",
		["Serrated Bite"]="尖牙撕咬",
		["Setup"]="调整",
		["Shackle Undead"]="束缚亡灵",
		["Shadow Affinity"]="暗影亲和y",
		["Shadow Bolt"]="暗影箭",
		["Shadow Bolt Volley"]="暗影箭雨",
		["Shadow Focus"]="暗影集中",
		["Shadow Mastery"]="暗影掌握",
		["Shadow Port"]="暗影传送",
		["Shadow Power"]="暗影强化",
		["Shadow Protection"]="暗影防护",
		["Shadow Reach"]="暗影延伸",
		["Shadow Reflector"]="暗影反射器",
		["Shadow Resistance Aura"]="暗影抗性光环",
		["Shadow Resistance"]="暗影抗性",
		["Shadow Shock"]="暗影震击",
		["Shadow Shot"]="暗影射击",
		["Vampiric Touch"] = "Vampiric Touch",
		["Shadow Trance"]="暗影冥思",
		["Shadow Vulnerability"]="暗影易伤",
		["Shadow Ward"]="防护暗影结界",
		["Shadow Weaving"]="暗影之波",
		["Shadowfiend"] = "Shadowfiend",
		["Shadow Word: Pain"]="暗言术：痛",
		["Shadowburn"]="暗影灼烧",
		["Shadowform"]="暗影形态",
		["Shadowguard"]="暗影守卫",
		["Misdirection"] = "Misdirection",
		["Shadowmeld Passive"]="影遁",
		["Shadowmeld"]="影遁",
		["Shard of the Fallen Star"]="坠落星辰碎片",
		["Sharpened Claws"]="锋利兽爪",
		["Shatter"]="碎冰",
		["Shazzrah's Curse"]="沙斯拉尔的诅咒",
		["Sheen of Zanza"]="赞扎之光",
		["Sheep"]="自爆绵羊",
		["Shell Shield"]="甲壳护盾",
		["Shield Bash"]="盾击",
		["Shield Block"]="盾牌格挡",
		["Shield Slam"]="盾牌猛击",
		["Shield Specialization"]="盾牌专精",
		["Shield Spike"]="盾刺",
		["Shield Wall"]="盾墙",
		["Shield"]="盾牌",
		["Shimmer Stout"]="微光酒",
		["Shock"]="震击",
		["Shoot Bow"]="弓射击",
		["Shoot Crossbow"]="弩射击",
		["Shoot Gun"]="枪械射击",
		["Shoot"]="射击",
		["Shred"]="撕碎",
		["Shrink"]="缩小",
		["Shrink Ray"]="缩小射线",
		["Silence"]="沉默",
		["Silent Resolve"]="无声消退",
		["Silithid Pox"]="异种蝎群瘟疫",
		["Sinister Strike"]="邪恶攻击",
		["Siphon Health"]="虹吸生命",
		["Siphon Life"]="生命虹吸",
		["Skeleton Costume"]="骷髅装束",
		["Skinning"]="剥皮",
		["Skull Crack"]="颅骨爆裂",
		["Skullforge Brand"]="颅骨烙印",
		["Slam"]="猛击",
		["Slayer's Crest"]="屠龙者的纹章",
		["Sleep"]="沉睡",
		["Sleepy"]="昏昏欲睡",
		["Slice and Dice"]="切割",
		["Sling Mud"]="投掷泥浆",
		["Sloth Effect"]="怠惰效果",
		["Slow"]="减速术",
		["Slow Fall"]="缓落术",
		["Slowing Poison"]="减速毒药",
		["Sludge"]="淤泥",
		["Sludge Toxin"]="淤泥毒药",
		["Small Bronze Bomb"]="小型青铜炸弹",
		["Small Seaforium Backfire"]="小型爆盐炸弹逆火",
		["Smash"]="撞击",
		["Smelting"]="熔炼",
		["Smite"]="惩击",
		["Smite Demon"]="惩击恶魔",
		["Smite Stomp"]="重拳先生践踏",
		["Smite Slam"]="重拳猛击",
		["Smoke Bomb"]="烟雾弹",
		["Smokey's Lighter"]="烟鬼的打火器",
		["Snap Kick"]="蹬踏",
		["Sneak"]="隐秘行动",
		["Snowball"]="雪球",
		["Solid Dynamite"]="实心炸弹",
		["Solid Sharpening Stone"]="坚固的磨刀石",
		["Songflower Serenade"]="风歌夜曲",
		["Sonic Burst"]="音素爆破",
		["Soothe Animal"]="安抚动物",
		["Soothing Kiss"]="安抚之吻",
		["Soul Bite"]="灵魂撕咬",
		["Soul Breaker"]="灵魂击碎者",
		["Soul Burn"]="灵魂燃烧",
		["Soul Drain"]="灵魂消耗",
		["Soul Fire"]="灵魂之火",
		["Soul Link"]="灵魂链接",
		["Soul Siphon"]="灵魂虹吸",
		["Soul Tap"]="灵魂分流",
		["Soulstone Resurrection"]="灵魂石复活",
		["Speed"]="速度",
		["Speed of Owatanka"]="奥瓦坦卡之速",
		["Spell Blasting"]="法术爆裂",
		["Spell Lock"]="法术封锁",
		["Spell Warding"]="法术屏障",
		["Spider's Kiss"]="蜘蛛之吻",
		["Spinal Reaper"]="脊骨收割者",
		["Spirit Bond"]="灵魂联结",
		["Spirit Burst"]="灵魂爆裂",
		["Spirit Decay"]="灵魂凋零",
		["Spirit of Boar"]="野猪之魂",
		["Spirit of Redemption"]="救赎之魂",
		["Spirit of the Wind"]="风之魂",
		["Spirit of Zanza"]="赞扎之魂",
		["Spirit Tap"]="精神分流",
		["Spiritual Domination"]="精神矍铄",
		["Spiritual Focus"]="精神集中",
		["Spiritual Guidance"]="精神指引",
		["Spiritual Healing"]="精神治疗",
		["Spit"]="喷吐",
		["Spore Cloud"]="孢子之云",
		["Spotlight"]="聚光",
		["Sprint"]="疾跑",
		["Stalker's Ally"]="追猎者之盟",
		["Starfall"]="星辰坠落",
		["Starfire"]="星火术",
		["Starfire Stun"]="星火昏迷",
		["Starshards"]="星辰碎片",
		["Static Barrier"]="静电屏障",
		["Static Electricity"]="闪电之盾",
		["Staves"]="法杖",
		["Stealth"]="潜行",
		["Stealth Detection"]="侦测潜行",
		["Stomp"]="践踏",
		["Stone Skin"]="石肤术",
		["Stoneclaw Totem"]="石爪图腾",
		["Stoneform"]="石像形态",
		["Stoneshield"]="石盾术",
		["Stoneskin Totem"]="石肤图腾",
		["Stormcaller's Wrath"]="风暴召唤者之怒",
		["Stormstout"]="风暴烈酒",
		["Stormstrike"]="风暴打击",
		["Stormwind Gift of Friendship"]="暴风城友谊礼品包",
		["Strength"]="力量",
		["Strength of Earth Totem"]="大地之力图腾",
		["Strength of Isha Awak"]="依沙瓦克之力",
		["Strength of Stone"]="巨石之力",
		["Strength of the Champion"]="勇士之力",
		["Strike"]="打击",
		["Strike of the Scorpok"]="厚甲蝎之击",
		["Stuck"]="卡死",
		["Stun"]="昏迷",
		["Stunning Blow"]="昏迷猛击",
		["Stygian Grasp"]="冥河之握",
		["Subtlety"]="微妙",
		["Suffering"]="受难",
		["Sul'thraze"]="苏萨斯",
		["Summon Charger"]="召唤战马",
		["Summon Dreadsteed"]="召唤恐惧战马",
		["Summon Felhunter"]="召唤地狱猎犬",
		["Summon Felsteed"]="召唤地狱战马",
		["Summon Imp"]="召唤小鬼",
		["Summon Spawn of Bael'Gar"]="召唤贝尔加的产物",
		["Summon Succubus"]="召唤魅魔",
		["Summon Voidwalker"]="召唤虚空行者",
		["Summon Warhorse"]="召唤军马",
		["Sunder Armor"]="破甲攻击",
		["Super Shrink Ray"]="超级收缩射线",
		["Suppression"]="镇压",
		["Supreme Power"]="至高能量",
		["Surefooted"]="稳固",
		["Surge"]="汹涌",
		["Surge of Strength"]="力量漩涡",
		["Survivalist"]="生存专家",
		["Sweeping Slam"]="横扫猛击",
		["Sweeping Strikes"]="横扫攻击",
		["Sweet Surprise"]="甜蜜惊喜",
		["Swiftmend"]="迅捷治愈",
		["Swiftness of Zanza"]="赞扎之速",
		["Swim Speed"]="游泳速度",
		["Swipe"]="挥击",
		["Swoop"]="飞扑",
		["Sword Specialization"]="剑类武器专精",
		["System Shock"]="系统震荡",
		["Tactical Mastery"]="战术掌握",
		["Tainted Blood"]="腐坏之血",
		["Tainted Howl"]="污浊嚎叫",
		["Tailoring"]="裁缝",
		["Talisman of Binding"]="束缚坠饰",
		["Tame Beast"]="驯服野兽",
		["Tamed Pet Passive"]="Tamed Pet Passive",
		["Target Dummy Spawn Effect"]="Target Dummy Spawn Effect",
		["Target Lock"]="目标锁定",
		["Taunt"]="嘲讽",
		["Tea with Sugar"]="糖水茶",
		["Teleport: Darnassus"] = "传送：达纳苏斯",
		["Teleport: Ironforge"] = "传送：铁炉堡",
		["Teleport: Moonglade"] = "传送：月光林地",
		["Teleport: Orgrimmar"] = "传送：奥格瑞玛",
		["Teleport: Stormwind"] = "传送：暴风城",
		["Teleport: Thunder Bluff"] = "传送：雷霆崖",
		["Teleport: Undercity"] = "传送：幽暗城",
		["Tendon Rip"]="裂筋",
		["Tendon Slice"]="挑筋",
		["Terrify"]="恐吓",
		["Terrifying Howl"]="恐吓嚎叫",
		["Terrifying Screech"]="恐吓尖啸",
		["Testament of Hope"]="希望的证明",
		["Tetanus"]="破伤风",
		["The Big One"]="大炸弹",
		["The Burrower's Shell"]="穴居虫之壳",
		["The Eye of Diminution"]="衰落之眼",
		["The Eye of the Dead"]="亡者之眼",
		["The Furious Storm"]="狂野风暴",
		["The Green Tower"]="绿塔",
		["The Human Spirit"]="人类精魂",
		["The Lion Horn of Stormwind"]="暴风雄狮号角",
		["Thick Hide"]="厚皮",
		["Thorium Grenade"]="瑟银手榴弹",
		["Thorium Shield Spike"]="瑟银盾刺",
		["Thorn Volley"]="荆棘箭雨",
		["Thorns"]="荆棘术",
		["Thousand Blades"]="千刃",
		["Thrash"]="痛击",
		["Threatening Gaze"]="威慑凝视",
		["Threatening Growl"]="胁迫低吼",
		["Throw"]="投掷",
		["Throw Axe"]="掷斧",
		["Throw Dynamite"]="投掷炸弹",
		["Throw Liquid Fire"]="投掷燃烧瓶",
		["Throw Wrench"]="扭曲",
		["Throwing Specialization"]="投掷专精",
		["Throwing Weapon Specialization"]="投掷武器专精",
		["Thrown"]="投掷",
		["Thunder Bluff Gift of Friendship"]="雷霆崖友谊礼品包",
		["Thunder Clap"]="雷霆一击",
		["Thunderbrew Lager"]="雷霆啤酒",
		["Thunderclap"]="雷霆一击",
		["Thundering Strikes"]="雷鸣猛击",
		["Thunderfury"]="雷霆之怒",
		["Thundershock"]="雷霆震荡",
		["Thunderstomp"]="雷霆践踏",
		["Tidal Charm"]="潮汐咒符",
		["Tidal Focus"]="潮汐集中",
		["Tidal Mastery"]="潮汐掌握",
		["Tiger Riding"]="骑术：豹",
		["Tiger's Fury"]="猛虎之怒",
		["Toasted Smorc"]="牛皮糖",
		["Torment"]="折磨",
		["Totem"]="图腾",
		["Totemic Focus"]="图腾集中",
		["Totemic Power"]="图腾之力",
		["Touch of Death"]="死亡之触",
		["Touch of Weakness"]="虚弱之触",
		["Touch of Zanzil"]="赞吉尔之触",
		["Toughness"]="坚韧",
		["Toxic Saliva"]="毒性唾液",
		["Toxic Spit"]="毒性喷溅",
		["Toxic Volley"]="毒性箭雨",
		["Track Beasts"]="追踪野兽",
		["Track Demons"] = "追踪恶魔",
		["Track Dragonkin"] = "追踪龙类",
		["Track Elementals"] = "追踪元素生物",
		["Track Giants"] = "追踪巨人",
		["Track Hidden"] = "追踪隐藏生物",
		["Track Humanoids"] = "追踪人型生物",
		["Track Undead"] = "追踪亡灵",
		["Trample"]="践踏",
		["Tranquil Air Totem"]="宁静之风图腾",
		["Tranquil Spirit"]="宁静之魂",
		["Tranquility"]="宁静",
		["Deep Wounds"]="重伤",
		["Tranquilizing Poison"]="宁神毒药",
		["Tranquilizing Shot"]="宁神射击",
		["Transporter Malfunction"]="传送器故障",
		["Trap"]="陷阱",
		["Trap Mastery"]="陷阱掌握",
		["Travel Form"]="旅行形态",
		["Tremor Totem"]="战栗图腾",
		["Tribal Leatherworking"]="部族制皮",
		["Tricked or Treated"]="糖果还是恶作剧",
		["Trick"]="恶作剧",
		["Trogg Ale"]="洞穴麦酒",
		["Trueshot Aura"]="强击光环",
		["Tunneler Acid"]="坑道蝎毒",
		["Turn Undead"]="超度亡灵",
		["Steady Shot"] = "Steady Shot",
		["Twisted Tranquility"]="扭曲宁静",
		["Twisting Nether"]="扭曲虚空",
		["Two-Handed Axes and Maces"]="双手斧和锤",
		["Two-Handed Axes"]="双手斧",
		["Two-Handed Maces"]="双手锤",
		["Two-Handed Swords"]="双手剑",
		["Two-Handed Weapon Specialization"]="双手武器专精",
		["Unarmed"]="徒手",
		["Unbreakable Will"]="坚定意志",
		["Unbridled Wrath Effect"]="怒不可遏效果",
		["Unbridled Wrath"]="怒不可遏",
		["Undead Horsemanship"]="骑术：骸骨战马",
		["Undercity Gift of Friendship"]="幽暗城友谊礼品包",
		["Underwater Breathing"]="水下呼吸",
		["Unending Breath"]="魔息术",
		["Unholy Aura"]="邪恶光环",
		["Unholy Frenzy"]="邪恶狂热",
		["Unholy Power"]="邪恶强化",
		["Unholy Shield"]="邪恶之盾",
		["Universal Remote"]="通用遥控器",
		["Unleashed Fury"]="狂怒释放",
		["Unstable Concoction"]="不稳定化合物",
		["Unstable Power"]="能量无常",
		["Untamed Fury"]="狂野之怒",
		["Unyielding Faith"]="不灭信仰",
		["Updraft"]="上升气流",
		["Uppercut"]="上钩拳",
		["Uther's Light Effect"]="乌瑟尔之光效果",
		["Vampiric Embrace"]="吸血鬼的拥抱",
		["Vampirism"]="吸血",
		["Vanish"]="消失",
		["Vanished"]="消失",
		["Veil of Shadow"]="暗影迷雾",
		["Vengeance"]="复仇",
		["Venom Shot"]="毒箭",
		["Venom Spit"]="毒液喷射",
		["Venom Sting"]="毒性钉刺",
		["Venomhide Poison"]="毒皮毒药",
		["Venomous Totem"]="毒性图腾",
		["Very Berry Cream"]="水果芳香",
		["Vicious Bite"]="恶毒之咬",
		["Vicious Rend"]="恶毒撕裂",
		["Vigor"]="精力",
		["Vile Poisons"]="恶性毒药",
		["Vindication"]="辩护",
		["Viper Sting"]="蝰蛇钉刺",
		["Virulent Poison"]="恶性毒药",
		["Visions of the Past"]="往日的幻象",
		["Void Bolt"]="虚空箭",
		["Volatile Infection"]="快速传染",
		["Volley"]="乱射",
		["Voodoo Hex"]="巫毒妖术",
		["Wail of the Banshee"]="女妖之嚎",
		["Wailing Dead"]="哀嚎死者",
		["Walking Bomb Effect"]="自走炸弹效果",
		["Wand Specialization"]="魔杖专精",
		["Wandering Plague"]="游荡瘟疫",
		["Wands"]="魔杖",
		["War Stomp"]="战争践踏",
		["Warrior's Resolve"]="战士的决心",
		["Warrior's Wrath"]="战士之怒",
		["Washte Pawne's Resolve"]="瓦希塔帕恩的决心",
		["Water"]="水",
		["Water Breathing"]="水下呼吸",
		["Water Walking"]="水上行走",
		["Wavering Will"]="摇摆意志",
		["Weak Frostbolt"]="弱效寒冰箭",
		["Weak Poison"]="弱效毒药",
		["Weakened Soul"]="虚弱灵魂",
		["Weakening Disease"]="虚弱疾病",
		["Weaponsmith"]="武器锻造师",
		["Web"]="蛛网",
		["Web Explosion"]="蛛网爆炸",
		["Web Spin"]="织网",
		["Web Spray"]="蛛网喷射",
		["Well Fed"]="进食充分",
		["Whipper Root Tuber"]="鞭根块茎",
		["Whirling Barrage"]="旋风倾泻",
		["Whirling Trip"]="横扫摔绊",
		["Whirlwind"]="旋风斩",
		["Wide Slash"]="挥砍",
		["Wildvine Potion"]="野葡萄药水",
		["Will of Hakkar"]="哈卡的意志",
		["Will of Shahram"]="沙赫拉姆的意志",
		["Will of the Forsaken"]="亡灵意志",
		["Wilt"]="枯萎",
		["Windblossom Berries"]="风花果",
		["Windfury Totem"]="风怒图腾",
		["Windfury Weapon"]="风怒武器",
		["Windreaper"]="断风者",
		["Windsor's Frenzy"]="温德索尔狂暴",
		["Windwall Totem"]="风墙图腾",
		["Wing Clip"]="摔绊",
		["Wing Flap"]="拍翼",
		["Winter's Chill"]="深冬之寒",
		["Wisdom of Agamaggan"]="阿迦玛甘的智慧",
		["Wisp Costume"]="小精灵装束",
		["Wisp Spirit"]="精灵之魂",
		["Wither Strike"]="凋零打击",
		["Wither Touch"]="凋零之触",
		["Withered Touch"]="枯萎之触",
		["Withering Heat"]="枯萎热浪",
		["Wolf Riding"]="骑术：狼",
		["World Enlarger"]="世界放大器",
		["Wound Poison II"]="致伤毒药 II",
		["Wound Poison III"]="致伤毒药 III",
		["Wound Poison IV"]="致伤毒药 IV",
		["Wound Poison"]="致伤毒药",
		["Wound"]="致伤",
		["Wrath"]="愤怒",
		["Wyvern Sting"]="翼龙钉刺",
		["Yaaarrrr"]="呀啊啊啊啊",
		["Zeal"]="狂热",
		["Zulian Slice"]="祖利安切割",
	}
end)

local spellIcons = {
	--	["Anesthetic Poison"] = true,
	--	["Anguish"] = true,
	--	["Arcane Blast"] = true,
	--	["Avenger's Shield"] = true,
	--	["Avenging Wrath"] = true,
	--	["Avoidance"] = true,
	--	["Backlash"] = true,
	--	["Binding Heal"] = true,
	--	["Blazing Speed"] = true,
	--	["Bloodlust"] = true,
	--	["Circle of Healing"] = true,
	--	["Cloak of Shadows"] = true,
	--	["Consume Magic"] = true,
	--	["Crusader Aura"] = true,
	--	["Crusader Strike"] = true,
	--	["Cyclone"] = true,
	--	["Deadly Throw"] = true,
	--	["Divine Illumination"] = true,
	--	["Dragon's Breath"] = true,
	--	["Dragonscale Leatherworking"] = true,	
	--	["Earth Elemental Totem"] = true,
	--	["Earth Shield"] = true,
	--	["Envenom"] = true,
	--	["Fel Armor"] = true,
	--	["Fire Elemental Totem"] = true,
	--	["Flight Form"] = true,
	--	["Heroism"] = true,
	--	["Ice Lance"] = true,
	--	["Invisibility"] = true,
	--	["Kill Command"] = true, 
	--	["Lacerate"] = true,
	--	["Lifebloom"] = true,
	--	["Maim"] = true,
	--	["Mangle (Bear)"] = true,
	--	["Mangle (Cat)"] = true,
	--	["Misdirection"] = true,
	--	["Molten Armor"] = true,
	--	["Mutilate"] = true,
	--	["Pain Suppression"] = true,
	--	["Prayer of Mending"] = true,
	--	["Rampage"] = true,
	--	["Righteous Defense"] = true,
	--	["Ritual of Souls"] = true,
	--	["Seal of Blood"] = true,
	--	["Seal of Vengeance"] = true,
	--	["Second Wind"] = true,
	--	["Seed of Corruption"] = true,
	--	["Shadow Word: Death"] = true,
	--	["Shadowfiend"] = true,
	--	["Shadowfury"] = true,
	--	["Shadowstep"] = true,
	--	["Shamanistic Rage"] = true,
	--	["Shiv"] = true,
	--	["Slow"] = true,
	--	["Snake Trap"] = true,
	--	["Soul Siphon"] = true,
	--	["Soulshatter"] = true,
	--	["Spellsteal"] = true,
	--	["Spiritual Attunement"] = true,
	--	["Stance Mastery"] = true,
	--	["Steady Shot"] = true,
	--	["Summon Felguard"] = true,
	--	["The Beast Within"] = true,
	--	["Tree of Life"] = true,
	--	["Unleashed Rage"] = true,
	--	["Unstable Affliction"] = true,
	--	["Vampiric Touch"] = true,
	--	["Victory Rush"] = true,
	--	["Water Shield"] = true,
	["Herb Gathering"] = "spell_nature_naturetouchgrow",
	["Abolish Disease"] = "Spell_Nature_NullifyDisease",
	["Abolish Poison Effect"] = "Spell_Nature_NullifyPoison_02",
	["Abolish Poison"] = "Spell_Nature_NullifyPoison_02",
	["Acid Breath"] = "Spell_Nature_Acid_01",
	["Acid of Hakkar"] = "Spell_Nature_Acid_01",
	["Acid Spit"] = "Spell_Nature_CorrosiveBreath",
	["Acid Splash"] = "INV_Drink_06",
	["Activate MG Turret"] = "INV_Weapon_Rifle_10",
	["Adrenaline Rush"] = "Spell_Shadow_ShadowWordDominate",
	["Aftermath"] = "Spell_Fire_Fire",
	["Aggression"] = "Ability_Racial_Avatar",
	["Aimed Shot"] = "INV_Spear_07",
	["Alchemy"] = "Trade_Alchemy",
	["Ambush"] = "Ability_Rogue_Ambush",
	["Amplify Curse"] = "Spell_Shadow_Contagion",
	["Amplify Damage"] = "Spell_Nature_AbolishMagic",
	["Amplify Flames"] = "Spell_Fire_Fireball",
	["Amplify Magic"] = "Spell_Holy_FlashHeal",
	["Ancestral Fortitude"] = "Spell_Nature_UndyingStrength",
	["Ancestral Healing"] = "Spell_Nature_UndyingStrength",
	["Ancestral Knowledge"] = "Spell_Shadow_GrimWard",
	["Ancestral Spirit"] = "Spell_Nature_Regenerate",
	["Anger Management"] = "Spell_Holy_BlessingOfStamina",
	["Anticipation"] = "Spell_Nature_MirrorImage",
	["Aqua Jet"] = "Spell_Frost_ChillingBlast",
	["Aquatic Form"] = "Ability_Druid_AquaticForm",
	["Arcane Bolt"] = "Spell_Arcane_StarFire",
	["Arcane Brilliance"] = "Spell_Holy_ArcaneIntellect",
	["Arcane Concentration"] = "Spell_Shadow_ManaBurn",
	["Arcane Explosion"] = "Spell_Nature_WispSplode",
	["Arcane Focus"] = "Spell_Holy_Devotion",
	["Arcane Instability"] = "Spell_Shadow_Teleport",
	["Arcane Intellect"] = "Spell_Holy_MagicalSentry",
	["Arcane Meditation"] = "Spell_Shadow_SiphonMana",
	["Arcane Mind"] = "Spell_Shadow_Charm",
	["Arcane Missiles"] = "Spell_Nature_StarFall",
	["Arcane Potency"] = "Spell_Arcane_StarFire",
	["Arcane Power"] = "Spell_Nature_Lightning",
	["Arcane Resistance"] = "Spell_Nature_StarFall",
	["Arcane Shot"] = "Ability_ImpalingBolt",
	["Arcane Subtlety"] = "Spell_Holy_DispelMagic",
	["Arcane Weakness"] = "INV_Misc_QirajiCrystal_01",
	["Arcing Smash"] = "Ability_Warrior_Cleave",
	["Arctic Reach"] = "Spell_Shadow_DarkRitual",
	["Arugal's Curse"] = "Spell_Shadow_GatherShadows",
	["Arugal's Gift"] = "Spell_Shadow_ChillTouch",
	["Ascendance"] = "INV_Misc_Gem_Pearl_04",
	["Aspect of Arlokk"] = "Ability_Vanish",
	["Aspect of Jeklik"] = "Spell_Shadow_Teleport",
	["Aspect of Mar'li"] = "Ability_Smash",
	["Aspect of the Beast"] = "Ability_Mount_PinkTiger",
	["Aspect of the Cheetah"] = "Ability_Mount_JungleTiger",
	["Aspect of the Hawk"] = "Spell_Nature_RavenForm",
	["Aspect of the Monkey"] = "Ability_Hunter_AspectOfTheMonkey",
	["Aspect of the Pack"] = "Ability_Mount_WhiteTiger",
	["Aspect of the Wild"] = "Spell_Nature_ProtectionformNature",
	["Aspect of Venoxis"] = "Spell_Nature_CorrosiveBreath",
	["Astral Recall"] = "Spell_Nature_AstralRecal",
	["Attack"] = "Spell_Fire_SearingTotem",
	["Attacking"] = "Temp",
	["Aura of Command"] = "INV_Banner_03",
	["Aural Shock"] = "Spell_Shadow_Possession",
	["Auto Shot"] = "Ability_Whirlwind",
	["Avoidance"] = "Ability_Warrior_Revenge",
	["Axe Flurry"] = "INV_Axe_06",
	["Axe Specialization"] = "INV_Axe_06",
	["Axe Toss"] = "INV_Axe_04",
	["Backhand"] = "INV_Gauntlets_05",
	["Backstab"] = "Ability_BackStab",
	["Bane"] = "Spell_Shadow_DeathPact",
	["Baneful Poison"] = "Spell_Nature_CorrosiveBreath",
	["Banish"] = "Spell_Shadow_Cripple",
	["Banshee Curse"] = "Spell_Nature_Drowsy",
	["Banshee Shriek"] = "Spell_Shadow_ImpPhaseShift",
	["Barbed Sting"] = "Spell_Nature_NullifyPoison",
	["Barkskin Effect"] = "Spell_Nature_StoneClawTotem",
	["Barkskin"] = "Spell_Nature_StoneClawTotem",
	["Barrage"] = "Ability_UpgradeMoonGlaive",
	["Bash"] = "Ability_Druid_Bash",
	["Basic Campfire"] = "Spell_Fire_Fire",
	["Battle Shout"] = "Ability_Warrior_BattleShout",
	["Battle Stance Passive"] = "Ability_Warrior_OffensiveStance",
	["Battle Stance"] = "Ability_Warrior_OffensiveStance",
	["Bear Form"] = "Ability_Racial_BearForm",
	["Beast Lore"] = "Ability_Physical_Taunt",
	["Beast Slaying"] = "INV_Misc_Pelt_Bear_Ruin_02",
	["Beast Training"] = "Ability_Hunter_BeastCall02",
	["Befuddlement"] = "Spell_Shadow_MindSteal",
	["Benediction"] = "Spell_Frost_WindWalkOn",
	["Berserker Charge"] = "Ability_Warrior_Charge",
	["Berserker Rage"] = "Spell_Nature_AncestralGuardian",
	["Berserker Stance Passive"] = "Ability_Racial_Avatar",
	["Berserker Stance"] = "Ability_Racial_Avatar",
	["Berserking"] = "Racial_Troll_Berserk",
	["Bestial Discipline"] = "Spell_Nature_AbolishMagic",
	["Bestial Swiftness"] = "Ability_Druid_Dash",
	["Bestial Wrath"] = "Ability_Druid_FerociousBite",
	["Biletoad Infection"] = "Spell_Holy_HarmUndeadAura",
	["Bite"] = "Ability_Racial_Cannibalize",
	["Black Arrow"] = "Ability_TheBlackArrow",
	["Blackout"] = "Spell_Shadow_GatherShadows",
	["Blacksmithing"] = "Trade_BlackSmithing",
	["Blade Flurry"] = "Ability_Warrior_PunishingBlow",
	["Blast Wave"] = "Spell_Holy_Excorcism_02",
	["Blaze"] = "Spell_Fire_Incinerate",
	["Blessed Recovery"] = "Spell_Holy_BlessedRecovery",
	["Blessing of Blackfathom"] = "Spell_Frost_FrostWard",
	["Blessing of Freedom"] = "Spell_Holy_SealOfValor",
	["Blessing of Kings"] = "Spell_Magic_MageArmor",
	["Blessing of Light"] = "Spell_Holy_PrayerOfHealing02",
	["Blessing of Might"] = "Spell_Holy_FistOfJustice",
	["Blessing of Protection"] = "Spell_Holy_SealOfProtection",
	["Blessing of Sacrifice"] = "Spell_Holy_SealOfSacrifice",
	["Blessing of Salvation"] = "Spell_Holy_SealOfSalvation",
	["Blessing of Sanctuary"] = "Spell_Nature_LightningShield",
	["Blessing of Shahram"] = "Spell_Holy_LayOnHands",
	["Blessing of Wisdom"] = "Spell_Holy_SealOfWisdom",
	["Blind"] = "Spell_Shadow_MindSteal",
	["Blinding Powder"] = "INV_Misc_Ammo_Gunpowder_02",
	["Blink"] = "Spell_Arcane_Blink",
	["Blizzard"] = "Spell_Frost_IceStorm",
	["Block"] = "Ability_Defend",
	["Blood Craze"] = "Spell_Shadow_SummonImp",
	["Blood Frenzy"] = "Ability_GhoulFrenzy",
	["Blood Funnel"] = "Spell_Shadow_LifeDrain",
	["Blood Fury"] = "Racial_Orc_BerserkerStrength",
	["Blood Leech"] = "Ability_Racial_Cannibalize",
	["Blood Pact"] = "Spell_Shadow_BloodBoil",
	["Blood Siphon"] = "Spell_Shadow_LifeDrain",
	["Blood Tap"] = "Ability_Racial_Cannibalize",
	["Bloodlust"] = "Spell_Nature_Bloodlust",
	["Bloodrage"] = "Ability_Racial_BloodRage",
	["Bloodthirst"] = "Spell_Nature_BloodLust",
	["Bomb"] = "Spell_Fire_SelfDestruct",
	["Booming Voice"] = "Spell_Nature_Purge",
	["Boulder"] = "INV_Stone_14",
	["Bow Specialization"] = "INV_Weapon_Bow_12",
	["Bows"] = "INV_Weapon_Bow_05",
	["Brain Wash"] = "Spell_Shadow_AntiMagicShell",
	["Bright Campfire"] = "Spell_Fire_Fire",
	["Brutal Impact"] = "Ability_Druid_Bash",
	["Burning Adrenaline"] = "INV_Gauntlets_03",
	["Burning Soul"] = "Spell_Fire_Fire",
	["Burning Wish"] = "Spell_Shadow_PsychicScream",
	["Butcher Drain"] = "Spell_Shadow_SiphonMana",
	["Call of Flame"] = "Spell_Fire_Immolation",
	["Call of the Grave"] = "Spell_Shadow_ChillTouch",
	["Call of Thunder"] = "Spell_Nature_CallStorm",
	["Call Pet"] = "Ability_Hunter_BeastCall",
	["Camouflage"] = "Ability_Stealth",
	["Cannibalize"] = "Ability_Racial_Cannibalize",
	["Cat Form"] = "Ability_Druid_CatForm",
	["Cataclysm"] = "Spell_Fire_WindsofWoe",
	["Cause Insanity"] = "Spell_Shadow_ShadowWordDominate",
	["Chain Bolt"] = "Spell_Nature_ChainLightning",
	["Chain Burn"] = "Spell_Shadow_ManaBurn",
	["Chain Heal"] = "Spell_Nature_HealingWaveGreater",
	["Chain Lightning"] = "Spell_Nature_ChainLightning",
	["Chained Bolt"] = "Spell_Nature_ChainLightning",
	["Chains of Ice"] = "Spell_Frost_ChainsOfIce",
	["Challenging Roar"] = "Ability_Druid_ChallangingRoar",
	["Challenging Shout"] = "Ability_BullRush",
	["Charge Rage Bonus Effect"] = "Ability_Warrior_Charge",
	["Charge Stun"] = "Spell_Frost_Stun",
	["Charge"] = "Ability_Warrior_Charge",
	["Cheap Shot"] = "Ability_CheapShot",
	["Chilled"] = "Spell_Frost_FrostArmor02",
	["Chilling Touch"] = "Spell_Frost_FrostArmor",
	["Chromatic Infusion"] = "Spell_Holy_MindVision",
	["Claw"] = "Ability_Druid_Rake",
	["Cleanse Nova"] = "Spell_Holy_HolyBolt",
	["Cleanse"] = "Spell_Holy_Renew",
	["Clearcasting"] = "Spell_Shadow_ManaBurn",
	["Cleave"] = "Ability_Warrior_Cleave",
	["Clever Traps"] = "Spell_Nature_TimeStop",
	["Closing"] = "Temp",
	["Cloth"] = "INV_Chest_Cloth_21",
	["Cobra Reflexes"] = "Spell_Nature_GuardianWard",
	["Cold Blood"] = "Spell_Ice_Lament",
	["Cold Snap"] = "Spell_Frost_WizardMark",
	["Combat Endurance"] = "Spell_Nature_AncestralGuardian",
	["Combustion"] = "Spell_Fire_SealOfFire",
	["Command"] = "Ability_Warrior_WarCry",
	["Commanding Shout"] = "Spell_Magic_Magearmor",
	["Concentration Aura"] = "Spell_Holy_MindSooth",
	["Concussion Blow"] = "Ability_ThunderBolt",
	["Concussion"] = "Spell_Fire_Fireball",
	["Concussive Shot"] = "Spell_Frost_Stun",
	["Cone of Cold"] = "Spell_Frost_Glacier",
	["Conflagrate"] = "Spell_Fire_Fireball",
	["Conjure Food"] = "INV_Misc_Food_10",
	["Conjure Mana Agate"] = "INV_Misc_Gem_Emerald_01",
	["Conjure Mana Citrine"] = "INV_Misc_Gem_Opal_01",
	["Conjure Mana Jade"] = "INV_Misc_Gem_Emerald_02",
	["Conjure Mana Ruby"] = "INV_Misc_Gem_Ruby_01",
	["Conjure Water"] = "INV_Drink_06",
	["Consecration"] = "Spell_Holy_InnerFire",
	["Consume Shadows"] = "Spell_Shadow_AntiShadow",
	["Consuming Shadows"] = "Spell_Shadow_Haunting",
	["Convection"] = "Spell_Nature_WispSplode",
	["Conviction"] = "Spell_Holy_RetributionAura",
	["Cooking"] = "INV_Misc_Food_15",
	["Corrosive Acid Breath"] = "Spell_Nature_Acid_01",
	["Corrosive Ooze"] = "Spell_Shadow_AnimateDead",
	["Corrosive Poison"] = "Spell_Nature_CorrosiveBreath",
	["Corrupted Blood"] = "Spell_Shadow_CorpseExplode",
	["Corruption"] = "Spell_Shadow_AbominationExplosion",
	["Counterattack"] = "Ability_Warrior_Challange",
	["Counterspell - Silenced"] = "Spell_Frost_IceShock",
	["Counterspell"] = "Spell_Frost_IceShock",
	["Cower"] = "Ability_Druid_Cower",
	["Create Firestone (Greater)"] = "INV_Ammo_FireTar",
	["Create Firestone (Lesser)"] = "INV_Ammo_FireTar",
	["Create Firestone (Major)"] = "INV_Ammo_FireTar",
	["Create Firestone"] = "INV_Ammo_FireTar",
	["Create Healthstone (Greater)"] = "INV_Stone_04",
	["Create Healthstone (Lesser)"] = "INV_Stone_04",
	["Create Healthstone (Major)"] = "INV_Stone_04",
	["Create Healthstone (Minor)"] = "INV_Stone_04",
	["Create Healthstone"] = "INV_Stone_04",
	["Create Soulstone (Greater)"] = "Spell_Shadow_SoulGem",
	["Create Soulstone (Lesser)"] = "Spell_Shadow_SoulGem",
	["Create Soulstone (Major)"] = "Spell_Shadow_SoulGem",
	["Create Soulstone (Minor)"] = "Spell_Shadow_SoulGem",
	["Create Soulstone"] = "Spell_Shadow_SoulGem",
	["Create Spellstone (Greater)"] = "INV_Misc_Gem_Sapphire_01",
	["Create Spellstone (Major)"] = "INV_Misc_Gem_Sapphire_01",
	["Create Spellstone (Major)"] = "INV_Misc_Gem_Sapphire_01",
	["Create Spellstone"] = "INV_Misc_Gem_Sapphire_01",
	["Creeper Venom"] = "Spell_Nature_NullifyPoison",
	["Cripple"] = "Spell_Shadow_Cripple",
	["Crippling Poison II"] = "Ability_PoisonSting",
	["Crippling Poison"] = "Ability_PoisonSting",
	["Critical Mass"] = "Spell_Nature_WispHeal",
	["Crossbows"] = "INV_Weapon_Crossbow_01",
	["Crowd Pummel"] = "INV_Gauntlets_04",
	["Cruelty"] = "Ability_Rogue_Eviscerate",
	["Crusader Strike"] = "Spell_Holy_HolySmite",
	["Crusader's Wrath"] = "Spell_Nature_GroundingTotem",
	["Crystal Charge"] = "INV_Misc_Gem_Opal_01",
	["Crystal Force"] = "INV_Misc_Gem_Crystal_02",
	["Crystal Restore"] = "INV_Misc_Gem_Diamond_02",
	["Crystal Spire"] = "INV_Misc_Gem_Stone_01",
	["Crystal Ward"] = "INV_Misc_Gem_Ruby_02",
	["Crystal Yield"] = "INV_Misc_Gem_Amethyst_01",
	["Crystalline Slumber"] = "Spell_Nature_Sleep",
	["Cultivation"] = "INV_Misc_Flower_01",
	["Cure Disease"] = "Spell_Holy_NullifyDisease",
	["Cure Poison"] = "Spell_Nature_NullifyPoison",
	["Curse of Agony"] = "Spell_Shadow_CurseOfSargeras",
	["Curse of Blood"] = "Spell_Shadow_RitualOfSacrifice",
	["Curse of Doom Effect"] = "Spell_Shadow_AuraOfDarkness",
	["Curse of Doom"] = "Spell_Shadow_AuraOfDarkness",
	["Curse of Exhaustion"] = "Spell_Shadow_GrimWard",
	["Curse of Idiocy"] = "Spell_Shadow_MindRot",
	["Curse of Recklessness"] = "Spell_Shadow_UnholyStrength",
	["Curse of Shadow"] = "Spell_Shadow_CurseOfAchimonde",
	["Curse of the Deadwood"] = "Spell_Shadow_GatherShadows",
	["Curse of the Elemental Lord"] = "Spell_Fire_LavaSpawn",
	["Curse of the Elements"] = "Spell_Shadow_ChillTouch",
	["Curse of Tongues"] = "Spell_Shadow_CurseOfTounges",
	["Curse of Tuten'kash"] = "Spell_Nature_Drowsy",
	["Curse of Weakness"] = "Spell_Shadow_CurseOfMannoroth",
	["Cursed Blood"] = "Spell_Nature_Drowsy",
	["Cyclone"] = "Spell_Nature_Cyclone",
	["Dagger Specialization"] = "INV_Weapon_ShortBlade_05",
	["Daggers"] = "Ability_SteelMelee",
	["Dampen Magic"] = "Spell_Nature_AbolishMagic",
	["Dark Iron Bomb"] = "Spell_Fire_SelfDestruct",
	["Dark Offering"] = "Spell_Shadow_Haunting",
	["Dark Pact"] = "Spell_Shadow_DarkRitual",
	["Darkness"] = "Spell_Shadow_Twilight",
	["Dash"] = "Ability_Druid_Dash",
	["Dazed"] = "Spell_Frost_Stun",
	["Deadly Poison II"] = "Ability_Rogue_DualWeild",
	["Deadly Poison III"] = "Ability_Rogue_DualWeild",
	["Deadly Poison IV"] = "Ability_Rogue_DualWeild",
	["Deadly Poison V"] = "Ability_Rogue_DualWeild",
	["Deadly Poison"] = "Ability_Rogue_DualWeild",
	["Death Coil"] = "Spell_Shadow_DeathCoil",
	["Death Wish"] = "Spell_Shadow_DeathPact",
	["Deep Sleep"] = "Spell_Nature_Sleep",
	["Deep Slumber"] = "Spell_Shadow_Cripple",
	["Deep Wounds"] = "Ability_BackStab",
	["Defense"] = "Ability_Racial_ShadowMeld",
	["Defensive Stance Passive"] = "Ability_Warrior_DefensiveStance",
	["Defensive Stance"] = "Ability_Warrior_DefensiveStance",
	["Defensive State 2"] = "Ability_Defend",
	["Defensive State"] = "Ability_Defend",
	["Defiance"] = "Ability_Warrior_InnerRage",
	["Deflection"] = "Ability_Parry",
	["Delusions of Jin'do"] = "Spell_Shadow_UnholyFrenzy",
	["Demon Armor"] = "Spell_Shadow_RagingScream",
	["Demon Skin"] = "Spell_Shadow_RagingScream",
	["Demonic Embrace"] = "Spell_Shadow_Metamorphosis",
	["Demonic Frenzy"] = "Spell_Shadow_Metamorphosis",
	["Demonic Sacrifice"] = "Spell_Shadow_PsychicScream",
	["Demoralizing Roar"] = "Ability_Druid_DemoralizingRoar",
	["Demoralizing Shout"] = "Ability_Warrior_WarCry",
	["Desperate Prayer"] = "Spell_Holy_Restoration",
	["Destructive Reach"] = "Spell_Shadow_CorpseExplode",
	["Detect Greater Invisibility"] = "Spell_Shadow_DetectInvisibility",
	["Detect Invisibility"] = "Spell_Shadow_DetectInvisibility",
	["Detect Lesser Invisibility"] = "Spell_Shadow_DetectLesserInvisibility",
	["Detect Magic"] = "Spell_Holy_Dizzy",
	["Detect Traps"] = "Ability_Spy",
	["Detect"] = "Ability_Hibernation",
	["Deterrence"] = "Ability_Whirlwind",
	["Detonation"] = "Spell_Fire_Fire",
	["Devastate"] = "INV_Sword_11",
	["Devastation"] = "Spell_Fire_FlameShock",
	["Devotion Aura"] = "Spell_Holy_DevotionAura",
	["Devour Magic Effect"] = "Spell_Nature_Purge",
	["Devour Magic"] = "Spell_Nature_Purge",
	["Devouring Plague"] = "Spell_Shadow_BlackPlague",
	["Diamond Flask"] = "INV_Drink_01",
	["Diplomacy"] = "INV_Misc_Note_02",
	["Dire Bear Form"] = "Ability_Racial_BearForm",
	["Dire Growl"] = "Ability_Racial_Cannibalize",
	["Disarm Trap"] = "Spell_Shadow_GrimWard",
	["Disarm"] = "Ability_Warrior_Disarm",
	["Disease Cleansing Totem"] = "Spell_Nature_DiseaseCleansingTotem",
	["Disease Cloud"] = "Spell_Nature_AbolishMagic",
	["Diseased Shot"] = "Spell_Shadow_CallofBone",
	["Diseased Spit"] = "Spell_Shadow_CreepingPlague",
	["Disenchant"] = "Spell_Holy_RemoveCurse",
	["Disengage"] = "Ability_Rogue_Feint",
	["Disjunction"] = "Spell_Lightning_LightningBolt01",
	["Dismiss Pet"] = "Spell_Nature_SpiritWolf",
	["Dispel Magic"] = "Spell_Holy_DispelMagic",
	["Distract"] = "Ability_Rogue_Distract",
	["Distracting Pain"] = "Ability_Racial_Cannibalize",
	["Distracting Shot"] = "Spell_Arcane_Blink",
	["Dive"] = "Spell_Shadow_BurningSpirit",
	["Divine Favor"] = "Spell_Holy_Heal",
	["Divine Fury"] = "Spell_Holy_SealOfWrath",
	["Divine Intellect"] = "Spell_Nature_Sleep",
	["Divine Intervention"] = "Spell_Nature_TimeStop",
	["Divine Protection"] = "Spell_Holy_Restoration",
	["Divine Shield"] = "Spell_Holy_DivineIntervention",
	["Divine Spirit"] = "Spell_Holy_DivineSpirit",
	["Divine Strength"] = "Ability_GolemThunderClap",
	["Diving Sweep"] = "Ability_Warrior_Cleave",
	["Dodge"] = "Spell_Nature_Invisibilty",
	["Dominate Mind"] = "Spell_Shadow_ShadowWordDominate",
	["Drain Life"] = "Spell_Shadow_LifeDrain02",
	["Drain Mana"] = "Spell_Shadow_SiphonMana",
	["Drain Soul"] = "Spell_Shadow_Haunting",
	["Dredge Sickness"] = "Spell_Nature_NullifyDisease",
	["Druid's Slumber"] = "Spell_Nature_Sleep",
	["Dual Wield Specialization"] = "Ability_DualWield",
	["Dual Wield"] = "Ability_DualWield",
	["Duel"] = "Temp",
	["Dust Field"] = "Spell_Nature_Cyclone",
	["Eagle Eye"] = "Ability_Hunter_EagleEye",
	["Earth Shock"] = "Spell_Nature_EarthShock",
	["Earthbind Totem"] = "Spell_Nature_StrengthOfEarthTotem02",
	["Earthborer Acid"] = "Spell_Nature_Acid_01",
	["Earthgrab"] = "Spell_Nature_NatureTouchDecay",
	["Efficiency"] = "Spell_Frost_WizardMark",
	["Electric Discharge"] = "Spell_Lightning_LightningBolt01",
	["Electrified Net"] = "Ability_Ensnare",
	["Elemental Focus"] = "Spell_Shadow_ManaBurn",
	["Elemental Fury"] = "Spell_Fire_Volcano",
	["Elemental Mastery"] = "Spell_Nature_WispHeal",
	["Elemental Precision"] = "Spell_Ice_MagicDamage",
	["Elune's Grace"] = "Spell_Holy_ElunesGrace",
	["Elusiveness"] = "Spell_Magic_LesserInvisibilty",
	["Emberstorm"] = "Spell_Fire_SelfDestruct",
	["Enchanting"] = "Trade_Engraving",
	["Endurance Training"] = "Spell_Nature_Reincarnation",
	["Endurance"] = "Spell_Nature_UnyeildingStamina",
	["Engineering Specialization"] = "INV_Misc_Gear_01",
	["Engineering"] = "Trade_Engineering",
	["Enrage"] = "Ability_Druid_Enrage",
	["Enslave Demon"] = "Spell_Shadow_EnslaveDemon",
	["Entangling Roots"] = "Spell_Nature_StrangleVines",
	["Entrapment"] = "Spell_Nature_StrangleVines",
	["Enveloping Web"] = "Spell_Nature_EarthBind",
	["Enveloping Webs"] = "Spell_Nature_EarthBind",
	["Enveloping Winds"] = "Spell_Nature_Cyclone",
	["Ephemeral Power"] = "Spell_Holy_MindVision",
	["Escape Artist"] = "Ability_Rogue_Trip",
	["Essence of Sapphiron"] = "INV_Trinket_Naxxramas06",
	["Evasion"] = "Spell_Shadow_ShadowWard",
	["Eventide"] = "Spell_Frost_Stun",
	["Eviscerate"] = "Ability_Rogue_Eviscerate",
	["Evocation"] = "Spell_Nature_Purge",
	["Execute"] = "INV_Sword_48",
	["Exorcism"] = "Spell_Holy_Excorcism_02",
	["Expansive Mind"] = "INV_Enchant_EssenceEternalLarge",
	["Exploding Shot"] = "Spell_Fire_Fireball02",
	["Exploit Weakness"] = "Ability_BackStab",
	["Explosive Shot"] = "Spell_Fire_Fireball02",
	["Explosive Trap Effect"] = "Spell_Fire_SelfDestruct",
	["Explosive Trap"] = "Spell_Fire_SelfDestruct",
	["Expose Armor"] = "Ability_Warrior_Riposte",
	["Expose Weakness"] = "Ability_CriticalStrike",
	["Eye for an Eye"] = "Spell_Holy_EyeforanEye",
	["Eye of Kilrogg"] = "Spell_Shadow_EvilEye",
	["Eyes of the Beast"] = "Ability_EyeOfTheOwl",
	["Fade"] = "Spell_Magic_LesserInvisibilty",
	["Faerie Fire (Feral)"] = "Spell_Nature_FaerieFire",
	["Faerie Fire"] = "Spell_Nature_FaerieFire",
	["Far Sight"] = "Spell_Nature_FarSight",
	["Fatal Bite"] = "Ability_BackStab",
	["Fear Ward"] = "Spell_Holy_Excorcism",
	["Fear"] = "Spell_Shadow_Possession",
	["Feed Pet"] = "Ability_Hunter_BeastTraining",
	["Feedback"] = "Spell_Shadow_RitualOfSacrifice",
	["Feign Death"] = "Ability_Rogue_FeignDeath",
	["Feint"] = "Ability_Rogue_Feint",
	["Fel Concentration"] = "Spell_Shadow_FingerOfDeath",
	["Fel Domination"] = "Spell_Nature_RemoveCurse",
	["Fel Intellect"] = "Spell_Holy_MagicalSentry",
	["Fel Stamina"] = "Spell_Shadow_AntiShadow",
	["Fel Stomp"] = "Ability_WarStomp",
	["Felfire"] = "Spell_Fire_Fireball",
	["Feline Grace"] = "INV_Feather_01",
	["Feline Swiftness"] = "Spell_Nature_SpiritWolf",
	["Feral Aggression"] = "Ability_Druid_DemoralizingRoar",
	["Feral Charge"] = "Ability_Hunter_Pet_Bear",
	["Feral Instinct"] = "Ability_Ambush",
	["Ferocious Bite"] = "Ability_Druid_FerociousBite",
	["Ferocity"] = "INV_Misc_MonsterClaw_04",
	["Fetish"] = "INV_Misc_Horn_01",
	["Fevered Plague"] = "Spell_Nature_NullifyDisease",
	["Fiery Burst"] = "Spell_Fire_FireBolt",
	["Find Herbs"] = "INV_Misc_Flower_02",
	["Find Minerals"] = "Spell_Nature_Earthquake",
	["Find Treasure"] = "Racial_Dwarf_FindTreasure",
	["Fire Blast"] = "Spell_Fire_Fireball",
	["Fire Nova Totem"] = "Spell_Fire_SealOfFire",
	["Fire Nova"] = "Spell_Fire_SealOfFire",
	["Fire Power"] = "Spell_Fire_Immolation",
	["Fire Resistance Aura"] = "Spell_Fire_SealOfFire",
	["Fire Resistance Totem"] = "Spell_FireResistanceTotem_01",
	["Fire Resistance"] = "Spell_Fire_FireArmor",
	["Fire Shield Effect II"] = "Spell_Fire_Immolation",
	["Fire Shield Effect III"] = "Spell_Fire_Immolation",
	["Fire Shield Effect IV"] = "Spell_Fire_Immolation",
	["Fire Shield Effect"] = "Spell_Fire_Immolation",
	["Fire Shield"] = "Spell_Fire_FireArmor",
	["Fire Storm"] = "Spell_Fire_SelfDestruct",
	["Fire Vulnerability"] = "Spell_Fire_SoulBurn",
	["Fire Ward"] = "Spell_Fire_FireArmor",
	["Fire Weakness"] = "INV_Misc_QirajiCrystal_02",
	["Fireball Volley"] = "Spell_Fire_FlameBolt",
	["Fireball"] = "Spell_Fire_FlameBolt",
	["Firebolt"] = "Spell_Fire_FireBolt",
	["First Aid"] = "Spell_Holy_SealOfSacrifice",
	["Fishing Poles"] = "Trade_Fishing",
	["Fishing"] = "Trade_Fishing",
	["Fist of Ragnaros"] = "Spell_Holy_SealOfWrath",
	["Fist Weapon Specialization"] = "INV_Gauntlets_04",
	["Fist Weapons"] = "INV_Gauntlets_04",
	["Flame Buffet"] = "Spell_Fire_Fireball",
	["Flame Cannon"] = "Spell_Fire_FlameBolt",
	["Flame Lash"] = "Spell_Fire_Fireball",
	["Flame Shock"] = "Spell_Fire_FlameShock",
	["Necrotic Aura"] = "Temp",
	["Flame Spike"] = "Spell_Fire_SelfDestruct",
	["Flame Spray"] = "Spell_Fire_Fire",
	["Flame Throwing"] = "Spell_Fire_Flare",
	["Flames of Shahram"] = "Spell_Fire_SelfDestruct",
	["Flamestrike"] = "Spell_Fire_SelfDestruct",
	["Flamethrower"] = "Spell_Fire_Incinerate",
	["Flametongue Totem"] = "Spell_Nature_GuardianWard",
	["Flametongue Weapon"] = "Spell_Fire_FlameTounge",
	["Flare"] = "Spell_Fire_Flare",
	["Flash Bomb"] = "Spell_Shadow_DarkSummoning",
	["Flash Heal"] = "Spell_Holy_FlashHeal",
	["Flash of Light"] = "Spell_Holy_FlashHeal",
	["Flurry"] = "Ability_GhoulFrenzy",
	["Focused Casting"] = "Spell_Arcane_Blink",
	["Focused Mind"] = "Spell_Nature_MirrorImage",
	["Forbearance"] = "Spell_Holy_RemoveCurse",
	["Force of Nature"] = "Spell_Nature_ForceOfNature",
	["Force of Will"] = "Spell_Nature_SlowingTotem",
	["Force Punch"] = "INV_Gauntlets_31",
	["Force Reactive Disk"] = "Spell_Lightning_LightningBolt01",
	["Forked Lightning"] = "Spell_Nature_ChainLightning",
	["Forsaken Skills"] = "Spell_Shadow_AntiShadow",
	["Frailty"] = "Spell_Shadow_AnimateDead",
	["Freeze Solid"] = "Spell_Fost_Glacier",
	["Freezing Trap"] = "Spell_Frost_ChainsOfIce",
	["Frenzied Regeneration"] = "Ability_BullRush",
	["Frenzy"] = "INV_Misc_MonsterClaw_03",
	["Frost Armor"] = "Spell_Frost_FrostArmor02",
	["Frost Breath"] = "Spell_Frost_FrostNova",
	["Frost Channeling"] = "Spell_Frost_Stun",
	["Frost Nova"] = "Spell_Frost_FrostNova",
	["Frost Resistance Aura"] = "Spell_Frost_WizardMark",
	["Frost Resistance Totem"] = "Spell_FrostResistanceTotem_01",
	["Frost Resistance"] = "Spell_Frost_FrostWard",
	["Frost Shock"] = "Spell_Frost_FrostShock",
	["Frost Shot"] = "Spell_Ice_MagicDamage",
	["Frost Trap Aura"] = "Spell_Frost_FreezingBreath",
	["Frost Trap"] = "Spell_Frost_FreezingBreath",
	["Frost Ward"] = "Spell_Frost_FrostWard",
	["Frost Warding"] = "Spell_Frost_FrostWard",
	["Frost Weakness"] = "INV_Misc_QirajiCrystal_04",
	["Frostbite"] = "Spell_Frost_FrostArmor",
	["Frostbolt Volley"] = "Spell_Frost_FrostBolt02",
	["Frostbolt"] = "Spell_Frost_FrostBolt02",
	["Frostbrand Weapon"] = "Spell_Frost_FrostBrand",
	["Furious Howl"] = "Ability_Hunter_Pet_Wolf",
	["Furor"] = "Spell_Holy_BlessingOfStamina",
	["Fury of Ragnaros"] = "Spell_holy_MindSooth",
	["Gahz'ranka Slam"] = "Ability_Devour",
	["Gahz'rilla Slam"] = "Ability_Devour",
	["Garrote"] = "Ability_Rogue_Garrote",
	["Gehennas' Curse"] = "Spell_Shadow_GatherShadows",
	["Generic"] = "INV_Shield_09",
	["Ghost Wolf"] = "Spell_Nature_SpiritWolf",
	["Ghostly Strike"] = "Spell_Shadow_Curse",
	["Gift of Life"] = "INV_Misc_Gem_Pearl_05",
	["Gift of Nature"] = "Spell_Nature_ProtectionformNature",
	["Gift of the Wild"] = "Spell_Nature_Regeneration",
	["Goblin Dragon Gun"] = "Spell_Fire_Incinerate",
	["Goblin Sapper Charge"] = "Spell_Fire_SelfDestruct",
	["Gouge"] = "Ability_Gouge",
	["Grace of Air Totem"] = "Spell_Nature_InvisibilityTotem",
	["Grasping Vines"] = "Spell_Nature_StrangleVines",
	["Great Stamina"] = "Spell_Nature_UnyeildingStamina",
	["Greater Blessing of Kings"] = "Spell_Magic_GreaterBlessingofKings",
	["Greater Blessing of Light"] = "Spell_Holy_GreaterBlessingofLight",
	["Greater Blessing of Might"] = "Spell_Holy_GreaterBlessingofKings",
	["Greater Blessing of Salvation"] = "Spell_Holy_GreaterBlessingofSalvation",
	["Greater Blessing of Sanctuary"] = "Spell_Holy_GreaterBlessingofSanctuary",
	["Greater Blessing of Wisdom"] = "Spell_Holy_GreaterBlessingofWisdom",
	["Greater Heal"] = "Spell_Holy_GreaterHeal",
	["Grim Reach"] = "Spell_Shadow_CallofBone",
	["Ground Tremor"] = "Spell_Nature_Earthquake",
	["Grounding Totem"] = "Spell_Nature_GroundingTotem",
	["Grovel"] = "Temp",
	["Growl"] = "Ability_Physical_Taunt",
	["Guardian's Favor"] = "Spell_Holy_SealOfProtection",
	["Guillotine"] = "Ability_Warrior_PunishingBlow",
	["Gun Specialization"] = "INV_Musket_03",
	["Guns"] = "INV_Weapon_Rifle_01",
	["Hail Storm"] = "Spell_Frost_FrostBolt02",
	["Hammer of Justice"] = "Spell_Holy_SealOfMight",
	["Hammer of Wrath"] = "Ability_ThunderClap",
	["Hamstring"] = "Ability_ShockWave",
	["Harass"] = "Ability_Hunter_Harass",
	["Hardiness"] = "INV_Helmet_23",
	["Haunting Spirits"] = "Spell_Shadow_BlackPlague",
	["Hawk Eye"] = "Ability_TownWatch",
	["Head Crack"] = "Ability_ThunderBolt",
	["Heal"] = "Spell_Holy_Heal",
	["Healing Circle"] = "Spell_Holy_PrayerOfHealing02",
	["Healing Focus"] = "Spell_Holy_HealingFocus",
	["Healing Light"] = "Spell_Holy_HolyBolt",
	["Healing of the Ages"] = "Spell_Nature_HealingWaveGreater",
	["Healing Stream Totem"] = "INV_Spear_04",
	["Healing Touch"] = "Spell_Nature_HealingTouch",
	["Healing Wave"] = "Spell_Nature_MagicImmunity",
	["Healing Way"] = "Spell_Nature_Healingway",
	["Health Funnel"] = "Spell_Shadow_LifeDrain",
	["Heart of the Wild"] = "Spell_Holy_BlessingOfAgility",
	["Hellfire Effect"] = "Spell_Fire_Incinerate",
	["Hellfire"] = "Spell_Fire_Incinerate",
	["Hemorrhage"] = "Spell_Shadow_LifeDrain",
	["Herbalism"] = "Spell_Nature_NatureTouchGrow",
	["Heroic Strike"] = "Ability_Rogue_Ambush",
	["Heroism"] = "Spell_Holy_Renew",
	["Hex of Jammal'an"] = "Spell_Shadow_AntiShadow",
	["Hex of Weakness"] = "Spell_Shadow_FingerOfDeath",
	["Hex"] = "Spell_Nature_Polymorph",
	["Hibernate"] = "Spell_Nature_Sleep",
	["Holy Fire"] = "Spell_Holy_SearingLight",
	["Holy Light"] = "Spell_Holy_HolyBolt",
	["Holy Nova"] = "Spell_Holy_HolyNova",
	["Holy Power"] = "Spell_Holy_Power",
	["Holy Reach"] = "Spell_Holy_Purify",
	["Holy Shield"] = "Spell_Holy_BlessingOfProtection",
	["Holy Shock"] = "Spell_Holy_SearingLight",
	["Holy Smite"] = "Spell_Holy_HolySmite",
	["Holy Specialization"] = "Spell_Holy_SealOfSalvation",
	["Holy Strength"] = "Spell_Holy_BlessingOfStrength",
	["Holy Strike"] = "Ability_ThunderBolt",
	["Holy Wrath"] = "Spell_Holy_Excorcism",
	["Honorless Target"] = "Spell_Magic_LesserInvisibilty",
	["Hooked Net"] = "Ability_Ensnare",
	["Horse Riding"] = "Spell_Nature_Swiftness",
	["Howl of Terror"] = "Spell_Shadow_DeathScream",
	["Humanoid Slaying"] = "Spell_Holy_PrayerOfHealing",
	["Hunter's Mark"] = "Ability_Hunter_SniperShot",
	["Hurricane"] = "Spell_Nature_Cyclone",
	["Ice Armor"] = "Spell_Frost_FrostArmor02",
	["Ice Barrier"] = "Spell_Ice_Lament",
	["Ice Blast"] = "Spell_Frost_FrostNova",
	["Ice Block"] = "Spell_Frost_Frost",
	["Ice Nova"] = "Spell_Frost_FrostNova",
	["Ice Shards"] = "Spell_Frost_IceShard",
	["Icicle"] = "Spell_Frost_FrostBolt02",
	["Ignite"] = "Spell_Fire_Incinerate",
	["Illumination"] = "Spell_Holy_GreaterHeal",
	["Immolate"] = "Spell_Fire_Immolation",
	["Immolation Trap Effect"] = "Spell_Fire_FlameShock",
	["Immolation Trap"] = "Spell_Fire_FlameShock",
	["Impact"] = "Spell_Fire_MeteorStorm",
	["Impale"] = "Ability_Gouge",
	["Improved Ambush"] = "Ability_Rogue_Ambush",
	["Improved Arcane Explosion"] = "Spell_Nature_WispSplode",
	["Improved Arcane Missiles"] = "Spell_Nature_StarFall",
	["Improved Arcane Shot"] = "Ability_ImpalingBolt",
	["Improved Aspect of the Hawk"] = "Spell_Nature_RavenForm",
	["Improved Aspect of the Monkey"] = "Ability_Hunter_AspectOfTheMonkey",
	["Improved Backstab"] = "Ability_BackStab",
	["Improved Battle Shout"] = "Ability_Warrior_BattleShout",
	["Improved Berserker Rage"] = "Spell_Nature_AncestralGuardian",
	["Improved Blessing of Might"] = "Spell_Holy_FistOfJustice",
	["Improved Blessing of Wisdom"] = "Spell_Holy_SealOfWisdom",
	["Improved Blizzard"] = "Spell_Frost_IceStorm",
	["Improved Bloodrage"] = "Ability_Racial_BloodRage",
	["Improved Chain Heal"] = "Spell_Nature_HealingWaveGreater",
	["Improved Chain Lightning"] = "Spell_Nature_ChainLightning",
	["Improved Challenging Shout"] = "Ability_Warrior_Challange",
	["Improved Charge"] = "Ability_Warrior_Charge",
	["Improved Cheap Shot"] = "Ability_CheapShot",
	["Improved Cleave"] = "Ability_Warrior_Cleave",
	["Improved Concentration Aura"] = "Spell_Holy_MindSooth",
	["Improved Concussive Shot"] = "Spell_Frost_Stun",
	["Improved Cone of Cold"] = "Spell_Frost_Glacier",
	["Improved Corruption"] = "Spell_Shadow_AbominationExplosion",
	["Improved Counterspell"] = "Spell_Frost_IceShock",
	["Improved Curse of Agony"] = "Spell_Shadow_CurseOfSargeras",
	["Improved Curse of Exhaustion"] = "Spell_Shadow_GrimWard",
	["Improved Curse of Weakness"] = "Spell_Shadow_CurseOfMannoroth",
	["Improved Dampen Magic"] = "Spell_Nature_AbolishMagic",
	["Improved Deadly Poison"] = "Ability_Rogue_DualWeild",
	["Improved Demoralizing Shout"] = "Ability_Warrior_WarCry",
	["Improved Devotion Aura"] = "Spell_Holy_DevotionAura",
	["Improved Disarm"] = "Ability_Warrior_Disarm",
	["Improved Distract"] = "Ability_Rogue_Distract",
	["Improved Drain Life"] = "Spell_Shadow_LifeDrain02",
	["Improved Drain Mana"] = "Spell_Shadow_SiphonMana",
	["Improved Drain Soul"] = "Spell_Shadow_Haunting",
	["Improved Enrage"] = "Ability_Druid_Enrage",
	["Improved Enslave Demon"] = "Spell_Shadow_EnslaveDemon",
	["Improved Entangling Roots"] = "Spell_Nature_StrangleVines",
	["Improved Evasion"] = "Spell_Shadow_ShadowWard",
	["Improved Eviscerate"] = "Ability_Rogue_Eviscerate",
	["Improved Execute"] = "INV_Sword_48",
	["Improved Expose Armor"] = "Ability_Warrior_Riposte",
	["Improved Eyes of the Beast"] = "Ability_EyeOfTheOwl",
	["Improved Fade"] = "Spell_Magic_LesserInvisibilty",
	["Improved Feign Death"] = "Ability_Rogue_FeignDeath",
	["Improved Fire Blast"] = "Spell_Fire_Fireball",
	["Improved Fire Nova Totem"] = "Spell_Fire_SealOfFire",
	["Improved Fire Ward"] = "Spell_Fire_FireArmor",
	["Improved Fireball"] = "Spell_Fire_FlameBolt",
	["Improved Firebolt"] = "Spell_Fire_FireBolt",
	["Improved Firestone"] = "INV_Ammo_FireTar",
	["Improved Flamestrike"] = "Spell_Fire_SelfDestruct",
	["Improved Flametongue Weapon"] = "Spell_Fire_FlameTounge",
	["Improved Flash of Light"] = "Spell_Holy_FlashHeal",
	["Improved Frost Nova"] = "Spell_Frost_FreezingBreath",
	["Improved Frost Ward"] = "Spell_Frost_FrostWard",
	["Improved Frostbolt"] = "Spell_Frost_FrostBolt02",
	["Improved Frostbrand Weapon"] = "Spell_Frost_FrostBrand",
	["Improved Garrote"] = "Ability_Rogue_Garrote",
	["Improved Ghost Wolf"] = "Spell_Nature_SpiritWolf",
	["Improved Gouge"] = "Ability_Gouge",
	["Improved Grace of Air Totem"] = "Spell_Nature_InvisibilityTotem",
	["Improved Grounding Totem"] = "Spell_Nature_GroundingTotem",
	["Improved Hammer of Justice"] = "Spell_Holy_SealOfMight",
	["Improved Hamstring"] = "Ability_ShockWave",
	["Improved Healing Stream Totem"] = "INV_Spear_04",
	["Improved Healing Touch"] = "Spell_Nature_HealingTouch",
	["Improved Healing Wave"] = "Spell_Nature_MagicImmunity",
	["Improved Healing"] = "Spell_Holy_Heal02",
	["Improved Health Funnel"] = "Spell_Shadow_LifeDrain",
	["Improved Healthstone"] = "INV_Stone_04",
	["Improved Heroic Strike"] = "Ability_Rogue_Ambush",
	["Improved Hunter's Mark"] = "Ability_Hunter_SniperShot",
	["Improved Immolate"] = "Spell_Fire_Immolation",
	["Improved Imp"] = "Spell_Shadow_SummonImp",
	["Improved Inner Fire"] = "Spell_Holy_InnerFire",
	["Improved Instant Poison"] = "Ability_Poisons",
	["Improved Intercept"] = "Ability_Rogue_Sprint",
	["Improved Intimidating Shout"] = "Ability_GolemThunderClap",
	["Improved Judgement"] = "Spell_Holy_RighteousFury",
	["Improved Kick"] = "Ability_Kick",
	["Improved Kidney Shot"] = "Ability_Rogue_KidneyShot",
	["Improved Lash of Pain"] = "Spell_Shadow_Curse",
	["Improved Lay on Hands"] = "Spell_Holy_LayOnHands",
	["Improved Lesser Healing Wave"] = "Spell_Nature_HealingWaveLesser",
	["Improved Life Tap"] = "Spell_Shadow_BurningSpirit",
	["Improved Lightning Bolt"] = "Spell_Nature_Lightning",
	["Improved Lightning Shield"] = "Spell_Nature_LightningShield",
	["Improved Magma Totem"] = "Spell_Fire_SelfDestruct",
	["Improved Mana Burn"] = "Spell_Shadow_ManaBurn",
	["Improved Mana Shield"] = "Spell_Shadow_DetectLesserInvisibility",
	["Improved Mana Spring Totem"] = "Spell_Nature_ManaRegenTotem",
	["Improved Mark of the Wild"] = "Spell_Nature_Regeneration",
	["Improved Mend Pet"] = "Ability_Hunter_MendPet",
	["Improved Mind Blast"] = "Spell_Shadow_UnholyFrenzy",
	["Improved Moonfire"] = "Spell_Nature_StarFall",
	["Improved Nature's Grasp"] = "Spell_Nature_NaturesWrath",
	["Improved Overpower"] = "INV_Sword_05",
	["Improved Power Word: Fortitude"] = "Spell_Holy_WordFortitude",
	["Improved Power Word: Shield"] = "Spell_Holy_PowerWordShield",
	["Improved Prayer of Healing"] = "Spell_Holy_PrayerOfHealing02",
	["Improved Psychic Scream"] = "Spell_Shadow_PsychicScream",
	["Improved Pummel"] = "INV_Gauntlets_04",
	["Improved Regrowth"] = "Spell_Nature_ResistNature",
	["Improved Reincarnation"] = "Spell_Nature_Reincarnation",
	["Improved Rejuvenation"] = "Spell_Nature_Rejuvenation",
	["Improved Rend"] = "Ability_Gouge",
	["Improved Renew"] = "Spell_Holy_Renew",
	["Improved Retribution Aura"] = "Spell_Holy_AuraOfLight",
	["Improved Revenge"] = "Ability_Warrior_Revenge",
	["Improved Revive Pet"] = "Ability_Hunter_BeastSoothe",
	["Improved Righteous Fury"] = "Spell_Holy_SealOfFury",
	["Improved Rockbiter Weapon"] = "Spell_Nature_RockBiter",
	["Improved Rupture"] = "Ability_Rogue_Rupture",
	["Improved Sap"] = "Ability_Sap",
	["Improved Scorch"] = "Spell_Fire_SoulBurn",
	["Improved Scorpid Sting"] = "Ability_Hunter_CriticalShot",
	["Improved Seal of Righteousness"] = "Ability_ThunderBolt",
	["Improved Seal of the Crusader"] = "Spell_Holy_HolySmite",
	["Improved Searing Pain"] = "Spell_Fire_SoulBurn",
	["Improved Searing Totem"] = "Spell_Fire_SearingTotem",
	["Improved Serpent Sting"] = "Ability_Hunter_Quickshot",
	["Improved Shadow Bolt"] = "Spell_Shadow_ShadowBolt",
	["Improved Shadow Word: Pain"] = "Spell_Shadow_ShadowWordPain",
	["Improved Shield Bash"] = "Ability_Warrior_ShieldBash",
	["Improved Shield Block"] = "Ability_Defend",
	["Improved Shield Wall"] = "Ability_Warrior_ShieldWall",
	["Improved Shred"] = "Spell_Shadow_VampiricAura",
	["Improved Sinister Strike"] = "Spell_Shadow_RitualOfSacrifice",
	["Improved Slam"] = "Ability_Warrior_DecisiveStrike",
	["Improved Slice and Dice"] = "Ability_Rogue_SliceDice",
	["Improved Spellstone"] = "INV_Misc_Gem_Sapphire_01",
	["Improved Sprint"] = "Ability_Rogue_Sprint",
	["Improved Starfire"] = "Spell_Arcane_StarFire",
	["Improved Stoneclaw Totem"] = "Spell_Nature_StoneClawTotem",
	["Improved Stoneskin Totem"] = "Spell_Nature_StoneSkinTotem",
	["Improved Strength of Earth Totem"] = "Spell_Nature_EarthBindTotem",
	["Improved Succubus"] = "Spell_Shadow_SummonSuccubus",
	["Improved Sunder Armor"] = "Ability_Warrior_Sunder",
	["Improved Taunt"] = "Spell_Nature_Reincarnation",
	["Improved Thorns"] = "Spell_Nature_Thorns",
	["Improved Thunder Clap"] = "Ability_ThunderClap",
	["Improved Tranquility"] = "Spell_Nature_Tranquility",
	["Improved Vampiric Embrace"] = "Spell_Shadow_ImprovedVampiricEmbrace",
	["Improved Vanish"] = "Ability_Vanish",
	["Improved Voidwalker"] = "Spell_Shadow_SummonVoidWalker",
	["Improved Windfury Weapon"] = "Spell_Nature_Cyclone",
	["Improved Wing Clip"] = "Ability_Rogue_Trip",
	["Improved Wrath"] = "Spell_Nature_AbolishMagic",
	["Incinerate"] = "Spell_Fire_FlameShock",
	["Infected Bite"] = "Spell_Shadow_CallofBone",
	["Infected Wound"] = "Spell_Nature_NullifyDisease",
	["Inferno Shell"] = "Spell_Fire_SelfDestruct",
	["Inferno"] = "Spell_Shadow_SummonInfernal",
	["Initiative"] = "Spell_Shadow_Fumble",
	["Inner Fire"] = "Spell_Holy_InnerFire",
	["Inner Focus"] = "Spell_Frost_WindWalkOn",
	["Innervate"] = "Spell_Nature_Lightning",
	["Insect Swarm"] = "Spell_Nature_InsectSwarm",
	["Inspiration"] = "Spell_Holy_LayOnHands",
	["Instant Poison II"] = "Ability_Poisons",
	["Instant Poison III"] = "Ability_Poisons",
	["Instant Poison IV"] = "Ability_Poisons",
	["Instant Poison V"] = "Ability_Poisons",
	["Instant Poison VI"] = "Ability_Poisons",
	["Instant Poison"] = "Ability_Poisons",
	["Intensity"] = "Spell_Fire_LavaSpawn",
	["Intercept Stun"] = "Spell_Frost_Stun",
	["Intercept"] = "Ability_Rogue_Sprint",
	["Intimidating Roar"] = "Ability_GolemThunderClap",
	["Intimidating Shout"] = "Ability_GolemThunderClap",
	["Intimidation"] = "Ability_Devour",
	["Intoxicating Venom"] = "Ability_Creature_Poison_01",
	["Iron Will"] = "Spell_Magic_MageArmor",
	["Judgement of Command"] = "Ability_Warrior_InnerRage",
	["Judgement of Justice"] = "Spell_Holy_SealOfWrath",
	["Judgement of Light"] = "Spell_Holy_HealingAura",
	["Judgement of Righteousness"] = "Ability_ThunderBolt",
	["Judgement of the Crusader"] = "Spell_Holy_HolySmite",
	["Judgement of Wisdom"] = "Spell_Holy_RighteousnessAura",
	["Judgement"] = "Spell_Holy_RighteousFury",
	["Kick - Silenced"] = "Ability_Kick",
	["Kick"] = "Ability_Kick",
	["Kidney Shot"] = "Ability_Rogue_KidneyShot",
	["Killer Instinct"] = "Spell_Holy_BlessingOfStamina",
	["Knock Away"] = "INV_Gauntlets_05",
	["Knockdown"] = "Ability_GolemThunderClap",
	["Kodo Riding"] = "Spell_Nature_Swiftness",
	["Lacerate"] = "Spell_Shadow_VampiricAura",
	["Larva Goo"] = "Ability_Creature_Poison_02",
	["Lash of Pain"] = "Spell_Shadow_Curse",
	["Lash"] = "Ability_CriticalStrike",
	["Last Stand"] = "Spell_Holy_AshesToAshes",
	["Lasting Judgement"] = "Spell_Holy_HealingAura",
	["Lava Spout Totem"] = "Spell_Fire_SelfDestruct",
	["Lay on Hands"] = "Spell_Holy_LayOnHands",
	["Leader of the Pack"] = "Spell_Nature_UnyeildingStamina",
	["Leather"] = "INV_Chest_Leather_09",
	["Leatherworking"] = "INV_Misc_ArmorKit_17",
	["Leech Poison"] = "Spell_Nature_NullifyPoison",
	["Lesser Heal"] = "Spell_Holy_LesserHeal",
	["Lesser Healing Wave"] = "Spell_Nature_HealingWaveLesser",
	["Lesser Invisibility"] = "Spell_Magic_LesserInvisibilty",
	["Lethal Shots"] = "Ability_SearingArrow",
	["Lethality"] = "Ability_CriticalStrike",
	["Levitate"] = "Spell_Holy_LayOnHands",
	["Libram"] = "INV_Misc_Book_11",
	["Lich Slap"] = "Spell_Shadow_ChillTouch",
	["Life Tap"] = "Spell_Shadow_BurningSpirit",
	["Lifegiving Gem"] = "INV_Misc_Gem_Pearl_05",
	["Lightning Blast"] = "Spell_Nature_Lightning",
	["Lightning Bolt"] = "Spell_Nature_Lightning",
	["Lightning Breath"] = "Spell_Nature_Lightning",
	["Lightning Cloud"] = "Spell_Nature_CallStorm",
	["Lightning Mastery"] = "Spell_Lightning_LightningBolt01",
	["Lightning Reflexes"] = "Spell_Nature_Invisibilty",
	["Lightning Shield"] = "Spell_Nature_LightningShield",
	["Lightning Wave"] = "Spell_Nature_ChainLightning",
	["Lightwell Renew"] = "Spell_Holy_SummonLightwell",
	["Lightwell"] = "Spell_Holy_SummonLightwell",
	["Lizard Bolt"] = "Spell_Nature_Lightning",
	["Localized Toxin"] = "Spell_Nature_CorrosiveBreath",
	["Long Daze"] = "Spell_Frost_Stun",
	["Mace Specialization"] = "INV_Mace_01",
	["Mace Stun Effect"] = "Spell_Frost_Stun",
	["Machine Gun"] = "Ability_Marksmanship",
	["Mage Armor"] = "Spell_MageArmor",
	["Magic Attunement"] = "Spell_Nature_AbolishMagic",
	["Magma Splash"] = "Spell_Fire_Immolation",
	["Magma Totem"] = "Spell_Fire_SelfDestruct",
	["Mail"] = "INV_Chest_Chain_05",
	["Malice"] = "Ability_Racial_BloodRage",
	["Mana Burn"] = "Spell_Shadow_ManaBurn",
	["Mana Feed"] = "Spell_Shadow_DarkRitual",
	["Mana Shield"] = "Spell_Shadow_DetectLesserInvisibility",
	["Mana Spring Totem"] = "Spell_Nature_ManaRegenTotem",
	["Mana Tide Totem"] = "Spell_Frost_SummonWaterElemental",
	["Mangle"] = "Ability_Druid_Mangle.tga",
	["Mark of Arlokk"] = "Ability_Hunter_SniperShot",
	["Mark of the Wild"] = "Spell_Nature_Regeneration",
	["Martyrdom"] = "Spell_Nature_Tranquility",
	["Mass Dispel"] = "Spell_Shadow_Teleport",
	["Master Demonologist"] = "Spell_Shadow_ShadowPact",
	["Master of Deception"] = "Spell_Shadow_Charm",
	["Master of Elements"] = "Spell_Fire_MasterOfElements",
	["Master Summoner"] = "Spell_Shadow_ImpPhaseShift",
	["Maul"] = "Ability_Druid_Maul",
	["Mechanostrider Piloting"] = "Spell_Nature_Swiftness",
	["Meditation"] = "Spell_Nature_Sleep",
	["Megavolt"] = "Spell_Nature_ChainLightning",
	["Melee Specialization"] = "INV_Axe_02",
	["Melt Ore"] = "Spell_Fire_SelfDestruct",
	["Mend Pet"] = "Ability_Hunter_MendPet",
	["Mental Agility"] = "Ability_Hibernation",
	["Mental Strength"] = "Spell_Nature_EnchantArmor",
	["Mighty Blow"] = "INV_Gauntlets_05",
	["Mind Blast"] = "Spell_Shadow_UnholyFrenzy",
	["Mind Control"] = "Spell_Shadow_ShadowWordDominate",
	["Mind Flay"] = "Spell_Shadow_SiphonMana",
	["Mind Soothe"] = "Spell_Holy_MindSooth",
	["Mind Tremor"] = "Spell_Nature_Earthquake",
	["Mind Vision"] = "Spell_Holy_MindVision",
	["Mind-numbing Poison II"] = "Spell_Nature_NullifyDisease",
	["Mind-numbing Poison III"] = "Spell_Nature_NullifyDisease",
	["Mind-numbing Poison"] = "Spell_Nature_NullifyDisease",
	["Mining"] = "trade_mining",
	["Mocking Blow"] = "Ability_Warrior_PunishingBlow",
	["Molten Blast"] = "Spell_Fire_Fire",
	["Molten Metal"] = "Spell_Fire_Fireball",
	["Mongoose Bite"] = "Ability_Hunter_SwiftStrike",
	["Monster Slaying"] = "INV_Misc_Head_Dragon_Black",
	["Moonfire"] = "Spell_Nature_StarFall",
	["Moonfury"] = "Spell_Nature_MoonGlow",
	["Moonglow"] = "Spell_Nature_Sentinal",
	["Moonkin Aura"] = "Spell_Nature_MoonGlow",
	["Moonkin Form"] = "Spell_Nature_ForceOfNature",
	["Mortal Cleave"] = "Ability_Warrior_SavageBlow",
	["Mortal Shots"] = "Ability_PierceDamage",
	["Mortal Strike"] = "Ability_Warrior_SavageBlow",
	["Mortal Wound"] = "Ability_CriticalStrike",
	["Multi-Shot"] = "Ability_UpgradeMoonGlaive",
	["Murder"] = "Spell_Shadow_DeathScream",
	["Naralex's Nightmare"] = "Spell_Nature_Sleep",
	["Natural Armor"] = "Spell_Nature_SpiritArmor",
	["Natural Shapeshifter"] = "Spell_Nature_WispSplode",
	["Natural Weapons"] = "INV_Staff_01",
	["Nature Aligned"] = "Spell_Nature_SpiritArmor",
	["Nature Resistance Totem"] = "Spell_Nature_NatureResistanceTotem",
	["Nature Resistance"] = "Spell_Nature_ResistNature",
	["Nature Weakness"] = "INV_Misc_QirajiCrystal_03",
	["Nature's Focus"] = "Spell_Nature_HealingWaveGreater",
	["Nature's Grace"] = "Spell_Nature_NaturesBlessing",
	["Nature's Grasp"] = "Spell_Nature_NaturesWrath",
	["Nature's Reach"] = "Spell_Nature_NatureTouchGrow",
	["Nature's Swiftness"] = "Spell_Nature_RavenForm",
	["Necrotic Poison"] = "Ability_Creature_Poison_03",
	["Negative Charge"] = "Spell_ChargeNegative",
	["Net"] = "Ability_Ensnare",
	["Nightfall"] = "Spell_Shadow_Twilight",
	["Noxious Catalyst"] = "Spell_Holy_HarmUndeadAura",
	["Noxious Cloud"] = "Spell_Nature_AbolishMagic",
	["Omen of Clarity"] = "Spell_Nature_CrystalBall",
	["One-Handed Axes"] = "INV_Axe_01",
	["One-Handed Maces"] = "INV_Mace_01",
	["One-Handed Swords"] = "Ability_MeleeDamage",
	["One-Handed Weapon Specialization"] = "INV_Sword_20",
	["Opening - No Text"] = "Temp",
	["Opening"] = "Temp",
	["Opportunity"] = "Ability_Warrior_WarCry",
	["Overpower"] = "Ability_MeleeDamage",
	["Pacify"] = "Ability_Seal",
	["Paralyzing Poison"] = "Ability_PoisonSting",
	["Paranoia"] = "Spell_Shadow_AuraOfDarkness",
	["Parasitic Serpent"] = "INV_Misc_MonsterHead_03",
	["Parry"] = "Ability_Parry",
	["Pathfinding"] = "Ability_Mount_JungleTiger",
	["Perception"] = "Spell_Nature_Sleep",
	["Permafrost"] = "Spell_Frost_Wisp",
	["Pet Aggression"] = "Ability_Druid_Maul",
	["Pet Hardiness"] = "Ability_BullRush",
	["Pet Recovery"] = "Ability_Hibernation",
	["Pet Resistance"] = "Spell_Holy_BlessingOfAgility",
	["Petrify"] = "Ability_GolemThunderClap",
	["Phase Shift"] = "Spell_Shadow_ImpPhaseShift",
	["Pick Lock"] = "Spell_Nature_MoonKey",
	["Lockpicking"] = "Spell_Nature_MoonKey",
	["Pick Pocket"] = "INV_Misc_Bag_11",
	["Pierce Armor"] = "Spell_Shadow_VampiricAura",
	["Piercing Howl"] = "Spell_Shadow_DeathScream",
	["Piercing Ice"] = "Spell_Frost_Frostbolt",
	["Piercing Shadow"] = "Spell_Shadow_ChillTouch",
	["Piercing Shot"] = "Ability_SearingArrow",
	["Plague Cloud"] = "Spell_Shadow_CallofBone",
	["Plate Mail"] = "INV_Chest_Plate01",
	["Poison Bolt Volley"] = "Spell_Nature_CorrosiveBreath",
	["Poison Bolt"] = "Spell_Nature_CorrosiveBreath",
	["Poison Cleansing Totem"] = "Spell_Nature_PoisonCleansingTotem",
	["Poison Cloud"] = "Spell_Nature_NatureTouchDecay",
	["Poison Shock"] = "Spell_Nature_Acid_01",
	["Poison"] = "Spell_Nature_CorrosiveBreath",
	["Poisoned Harpoon"] = "Ability_Poisons",
	["Poisoned Shot"] = "Ability_Poisons",
	["Poisonous Blood"] = "Spell_Nature_Regenerate",
	["Poisons"] = "Trade_BrewPoison",
	["Polearm Specialization"] = "INV_Weapon_Halbard_01",
	["Polearms"] = "INV_Spear_06",
	["Polymorph"] = "Spell_Nature_Polymorph",
	["Polymorph: Pig"] = "Spell_Magic_PolymorphPig", 
	["Polymorph: Turtle"] = "Ability_Hunter_Pet_Turtle",
	["Portal: Darnassus"] = "Spell_Arcane_PortalDarnassus",
	["Portal: Ironforge"] = "Spell_Arcane_PortalIronForge",
	["Portal: Orgrimmar"] = "Spell_Arcane_PortalOrgrimmar",
	["Portal: Stormwind"] = "Spell_Arcane_PortalStormWind",
	["Portal: Thunder Bluff"] = "Spell_Arcane_PortalThunderBluff",
	["Portal: Undercity"] = "Spell_Arcane_PortalUnderCity",
	["Positive Charge"] = "Spell_ChargePositive",
	["Pounce Bleed"] = "Ability_Druid_SupriseAttack",
	["Pounce"] = "Ability_Druid_SupriseAttack",
	["Power Infusion"] = "Spell_Holy_PowerInfusion",
	["Power Word: Fortitude"] = "Spell_Holy_WordFortitude",
	["Power Word: Shield"] = "Spell_Holy_PowerWordShield",
	["Prayer Beads Blessing"] = "INV_Jewelry_Necklace_11",
	["Prayer of Fortitude"] = "Spell_Holy_PrayerOfFortitude",
	["Prayer of Healing"] = "Spell_Holy_PrayerOfHealing02",
	["Prayer of Shadow Protection"] = "Spell_Holy_PrayerofShadowProtection",
	["Prayer of Spirit"] = "Spell_Holy_PrayerofSpirit",
	["Precision"] = "Ability_Marksmanship",
	["Predatory Strikes"] = "Ability_Hunter_Pet_Cat",
	["Premeditation"] = "Spell_Shadow_Possession",
	["Preparation"] = "Spell_Shadow_AntiShadow",
	["Presence of Mind"] = "Spell_Nature_EnchantArmor",
	["Primal Fury"] = "Ability_Racial_Cannibalize",
	["Prowl"] = "Ability_Druid_SupriseAttack",
	["Psychic Scream"] = "Spell_Shadow_PsychicScream",
	["Pummel"] = "INV_Gauntlets_04",
	["Puncture"] = "Ability_Gouge",
	["Purge"] = "Spell_Nature_Purge",
	["Purification"] = "Spell_Frost_WizardMark",
	["Purify"] = "Spell_Holy_Purify",
	["Pursuit of Justice"] = "Spell_Holy_PersuitofJustice",
	["Putrid Breath"] = "Spell_Holy_HarmUndeadAura",
	["Putrid Enzyme"] = "Spell_Nature_NullifyDisease",
	["Pyroblast"] = "Spell_Fire_Fireball02",
	["Pyroclasm"] = "Spell_Fire_Volcano",
	["Quick Shots"] = "Ability_Warrior_Innerrage",
	["Quickness"] = "Ability_Racial_ShadowMeld",
	["Radiation Bolt"] = "Spell_Shadow_CorpseExplode",
	["Radiation Cloud"] = "Spell_Shadow_CorpseExplode",
	["Radiation Poisoning"] = "Spell_Shadow_CorpseExplode",
	["Radiation"] = "Spell_Shadow_CorpseExplode",
	["Rain of Fire"] = "Spell_Shadow_RainOfFire",
	["Rake"] = "Ability_Druid_Disembowel",
	["Ram Riding"] = "Spell_Nature_Swiftness",
	["Rampage"] = "Spell_Nature_NaturesWrath",
	["Ranged Weapon Specialization"] = "INV_Weapon_Rifle_06",
	["Rapid Concealment"] = "Ability_Ambush",
	["Rapid Fire"] = "Ability_Hunter_RunningShot",
	["Raptor Riding"] = "Spell_Nature_Swiftness",
	["Raptor Strike"] = "Ability_MeleeDamage",
	["Ravage"] = "Ability_Druid_Ravage",
	["Ravenous Claw"] = "Ability_GhoulFrenzy",
	["Readiness"] = "Spell_Nature_Sleep",
	["Rebirth"] = "Spell_Nature_Reincarnation",
	["Rebuild"] = "Spell_Shadow_LifeDrain",
	["Recently Bandaged"] = "INV_Misc_Bandage_08",
	["Recklessness"] = "Ability_CriticalStrike",
	["Reckoning"] = "Spell_Holy_BlessingOfStrength",
	["Recombobulate"] = "Spell_Magic_PolymorphChicken",
	["Redemption"] = "Spell_Holy_Resurrection",
	["Redoubt"] = "Ability_Defend",
	["Reflection"] = "Spell_Frost_WindWalkOn",
	["Regeneration"] = "Spell_Nature_Regenerate",
	["Regrowth"] = "Spell_Nature_ResistNature",
	["Reincarnation"] = "Spell_Nature_Reincarnation",
	["Rejuvenation"] = "Spell_Nature_Rejuvenation",
	["Relentless Strikes"] = "Ability_Warrior_DecisiveStrike",
	["Remorseless Attacks"] = "Ability_FiegnDead",
	["Remorseless"] = "Ability_Fiegndead",
	["Remove Curse"] = "Spell_Holy_RemoveCurse",
	["Remove Insignia"] = "Temp",
	["Remove Lesser Curse"] = "Spell_Nature_RemoveCurse",
	["Rend"] = "Ability_Gouge",
	["Renew"] = "Spell_Holy_Renew",
	["Repentance"] = "Spell_Holy_PrayerOfHealing",
	["Repulsive Gaze"] = "Ability_GolemThunderClap",
	["Restorative Totems"] = "Spell_Nature_ManaRegenTotem",
	["Resurrection"] = "Spell_Holy_Resurrection",
	["Retaliation"] = "Ability_Warrior_Challange",
	["Retribution Aura"] = "Spell_Holy_AuraOfLight",
	["Revenge Stun"] = "Ability_Warrior_Revenge",
	["Revenge"] = "Ability_Warrior_Revenge",
	["Reverberation"] = "Spell_Frost_FrostWard",
	["Revive Pet"] = "Ability_Hunter_BeastSoothe",
	["Rhahk'Zor Slam"] = "INV_Gauntlets_05",
	["Ribbon of Souls"] = "Spell_Nature_Lightning",
	["Righteous Fury"] = "Spell_Holy_SealOfFury",
	["Rip"] = "Ability_GhoulFrenzy",
	["Riposte"] = "Ability_Warrior_Challange",
	["Ritual of Doom Effect"] = "Spell_Arcane_PortalDarnassus",
	["Ritual of Doom"] = "Spell_Shadow_AntiMagicShell",
	["Ritual of Summoning"] = "Spell_Shadow_Twilight",
	["Rockbiter Weapon"] = "Spell_Nature_RockBiter",
	["Rogue Passive"] = "Ability_Stealth",
	["Ruin"] = "Spell_Shadow_ShadowWordPain",
	["Rupture"] = "Ability_Rogue_Rupture",
	["Ruthlessness"] = "Ability_Druid_Disembowel",
	["Sacrifice"] = "Spell_Shadow_SacrificialShield",
	["Safe Fall"] = "INV_Feather_01",
	["Sanctity Aura"] = "Spell_Holy_MindVision",
	["Sap"] = "Ability_Sap",
	["Savage Fury"] = "Ability_Druid_Ravage",
	["Savage Strikes"] = "Ability_Racial_BloodRage",
	["Scare Beast"] = "Ability_Druid_Cower",
	["Scatter Shot"] = "Ability_GolemStormBolt",
	["Scorch"] = "Spell_Fire_SoulBurn",
	["Scorpid Poison"] = "Ability_PoisonSting",
	["Scorpid Sting"] = "Ability_Hunter_CriticalShot",
	["Screams of the Past"] = "Spell_Shadow_ImpPhaseShift",
	["Screech"] = "Ability_Hunter_Pet_Bat",
	["Seal Fate"] = "Spell_Shadow_ChillTouch",
	["Seal of Command"] = "Ability_Warrior_InnerRage",
	["Seal of Justice"] = "Spell_Holy_SealOfWrath",
	["Seal of Light"] = "Spell_Holy_HealingAura",
	["Seal of Reckoning"] = "Spell_Holy_SealOfWrath",
	["Seal of Righteousness"] = "Ability_ThunderBolt",
	["Seal of the Crusader"] = "Spell_Holy_HolySmite",
	["Seal of Wisdom"] = "Spell_Holy_RighteousnessAura",
	["Searing Light"] = "Spell_Holy_SearingLightPriest",
	["Searing Pain"] = "Spell_Fire_SoulBurn",
	["Searing Totem"] = "Spell_Fire_SearingTotem",
	["Second Wind"] = "INV_Jewelry_Talisman_06",
	["Seduction"] = "Spell_Shadow_MindSteal",
	["Sense Demons"] = "Spell_Shadow_Metamorphosis",
	["Sense Undead"] = "Spell_Holy_SenseUndead",
	["Sentry Totem"] = "Spell_Nature_RemoveCurse",
	["Serpent Sting"] = "Ability_Hunter_Quickshot",
	["Setup"] = "Spell_Nature_MirrorImage",
	["Shackle Undead"] = "Spell_Nature_Slow",
	["Shadow Affinity"] = "Spell_Shadow_ShadowWard",
	["Shadow Bolt Volley"] = "Spell_Shadow_ShadowBolt",
	["Shadow Bolt"] = "Spell_Shadow_ShadowBolt",
	["Shadow Focus"] = "Spell_Shadow_BurningSpirit",
	["Shadow Mastery"] = "Spell_Shadow_ShadeTrueSight",
	["Shadow Protection"] = "Spell_Shadow_AntiShadow",
	["Shadow Reach"] = "Spell_Shadow_ChillTouch",
	["Shadow Resistance Aura"] = "Spell_Shadow_SealOfKings",
	["Shadow Resistance"] = "Spell_Shadow_AntiShadow",
	["Shadow Shock"] = "Spell_Shadow_ShadowBolt",
	["Shadow Trance"] = "Spell_Shadow_Twilight",
	["Shadow Vulnerability"] = "Spell_Shadow_ShadowBolt",
	["Shadow Ward"] = "Spell_Shadow_AntiShadow",
	["Shadow Weakness"] = "INV_Misc_QirajiCrystal_05",
	["Shadow Weaving"] = "Spell_Shadow_BlackPlague",
	["Shadow Word: Pain"] = "Spell_Shadow_ShadowWordPain",
	["Shadowburn"] = "Spell_Shadow_ScourgeBuild",
	["Shadowform"] = "Spell_Shadow_Shadowform",
	["Shadowguard"] = "Spell_Nature_LightningShield",
	["Shadowmeld Passive"] = "Ability_Ambush",
	["Shadowmeld"] = "Ability_Ambush",
	["Sharpened Claws"] = "INV_Misc_MonsterClaw_04",
	["Shatter"] = "Spell_Frost_FrostShock",
	["Shell Shield"] = "Ability_Hunter_Pet_Turtle",
	["Shield Bash - Silenced"] = "Ability_Warrior_ShieldBash",
	["Shield Bash"] = "Ability_Warrior_ShieldBash",
	["Shield Block"] = "Ability_Defend",
	["Shield Slam"] = "INV_Shield_05",
	["Shield Specialization"] = "INV_Shield_06",
	["Shield Wall"] = "Ability_Warrior_ShieldWall",
	["Shield"] = "INV_Shield_04",
	["Shock"] = "Spell_Nature_WispHeal",
	["Shoot Bow"] = "Ability_Marksmanship",
	["Shoot Crossbow"] = "Ability_Marksmanship",
	["Shoot Gun"] = "Ability_Marksmanship",
	["Shoot"] = "Ability_ShootWand",
	["Shred"] = "Spell_Shadow_VampiricAura",
	["Shrink"] = "Spell_Shadow_AntiShadow",
	["Silence"] = "Spell_Shadow_ImpPhaseShift",
	["Silencing Shot"] = "Spell_Holy_Silence",
	["Silent Resolve"] = "Spell_Nature_ManaRegenTotem",
	["Sinister Strike"] = "Spell_Shadow_RitualOfSacrifice",
	["Siphon Life"] = "Spell_Shadow_Requiem",
	["Skinning"] = "INV_Misc_Pelt_Wolf_01",
	["Skull Crack"] = "Spell_Frost_Stun",
	["Slam"] = "Ability_Warrior_DecisiveStrike",
	["Sleep"] = "Spell_Nature_Sleep",
	["Slice and Dice"] = "Ability_Rogue_SliceDice",
	["Slow Fall"] = "Spell_Magic_FeatherFall",
	["Slow"] = "Spell_Nature_Slow",
	["Slowing Poison"] = "Spell_Nature_SlowPoison",
	["Smelting"] = "Spell_Fire_FlameBlades",
	["Smite Slam"] = "INV_Gauntlets_05",
	["Smite Stomp"] = "Ability_WarStomp",
	["Smite"] = "Spell_Holy_HolySmite",
	["Smoke Bomb"] = "Ability_Hibernation",
	["Snap Kick"] = "Ability_Kick",
	["Sonic Burst"] = "Spell_Shadow_Teleport",
	["Soothe Animal"] = "Ability_Hunter_BeastSoothe",
	["Soothing Kiss"] = "Spell_Shadow_SoothingKiss",
	["Soul Bite"] = "Spell_Shadow_SiphonMana",
	["Soul Drain"] = "Spell_Shadow_LifeDrain02",
	["Soul Fire"] = "Spell_Fire_Fireball02",
	["Soul Link"] = "Spell_Shadow_GatherShadows",
	["Soul Siphon"] = "Spell_Shadow_LifeDrain02",
	["Soul Tap"] = "Spell_Shadow_LifeDrain02",
	["Soulstone Resurrection"] = "INV_Misc_Orb_04",
	["Spell Lock"] = "Spell_Shadow_MindRot",
	["Spell Reflection"] = "Spell_Shadow_Teleport",
	["Spell Warding"] = "Spell_Holy_SpellWarding",
	["Spirit Bond"] = "Ability_Druid_DemoralizingRoar",
	["Spirit Burst"] = "Spell_Shadow_Teleport",
	["Spirit of Redemption"] = "INV_Enchant_EssenceEternalLarge",
	["Spirit Tap"] = "Spell_Shadow_Requiem",
	["Spiritual Focus"] = "Spell_Arcane_Blink",
	["Spiritual Guidance"] = "Spell_Holy_SpiritualGuidence",
	["Spiritual Healing"] = "Spell_Nature_MoonGlow",
	["Spit"] = "Spell_Nature_CorrosiveBreath",
	["Spore Cloud"] = "Spell_Nature_DryadDispelMagic",
	["Sprint"] = "Ability_Rogue_Sprint",
	["Starfire Stun"] = "Spell_Arcane_StarFire",
	["Starfire"] = "Spell_Arcane_StarFire",
	["Starshards"] = "Spell_Arcane_StarFire",
	["Staves"] = "INV_Staff_08",
	["Stealth"] = "Ability_Stealth",
	["Stoneclaw Totem"] = "Spell_Nature_StoneClawTotem",
	["Stoneform"] = "Spell_Shadow_UnholyStrength",
	["Stoneskin Totem"] = "Spell_Nature_StoneSkinTotem",
	["Stormstrike"] = "Spell_Holy_SealOfMight",
	["Strength of Earth Totem"] = "Spell_Nature_EarthBindTotem",
	["Strike"] = "Ability_Rogue_Ambush",
	["Stuck"] = "Spell_Shadow_Teleport",
	["Stun"] = "Spell_Shadow_Teleport",
	["Subtlety"] = "Ability_EyeOfTheOwl",
	["Suffering"] = "Spell_Shadow_BlackPlague",
	["Summon Charger"] = "Ability_Mount_Charger",
	["Summon Dreadsteed"] = "Ability_Mount_Dreadsteed",
	["Summon Felhunter"] = "Spell_Shadow_SummonFelHunter",
	["Summon Felsteed"] = "Spell_Nature_Swiftness",
	["Summon Imp"] = "Spell_Shadow_SummonImp",
	["Summon Spawn of Bael'Gar"] = "Spell_Fire_LavaSpawn",
	["Summon Succubus"] = "Spell_Shadow_SummonSuccubus",
	["Summon Voidwalker"] = "Spell_Shadow_SummonVoidWalker",
	["Summon Warhorse"] = "Spell_Nature_Swiftness",
	["Summon Water Elemental"] = "Spell_Shadow_Sealofkings",
	["Sunder Armor"] = "Ability_Warrior_Sunder",
	["Suppression"] = "Spell_Shadow_UnsummonBuilding",
	["Surefooted"] = "Ability_Kick",
	["Survivalist"] = "Spell_Shadow_Twilight",
	["Sweeping Slam"] = "Ability_Devour",
	["Sweeping Strikes"] = "Ability_Rogue_SliceDice",
	["Swiftmend"] = "INV_Relics_IdolofRejuvenation",
	["Swipe"] = "INV_Misc_MonsterClaw_03",
	["Swoop"] = "Ability_Warrior_Cleave",
	["Sword Specialization"] = "INV_Sword_27",
	["Tactical Mastery"] = "Spell_Nature_EnchantArmor",
	["Tailoring"] = "Trade_Tailoring",
	["Tainted Blood"] = "Spell_Shadow_LifeDrain",
	["Tame Beast"] = "Ability_Hunter_BeastTaming",
	["Tamed Pet Passive"] = "Ability_Mount_PinkTiger",
	["Taunt"] = "Spell_Nature_Reincarnation",
	["Teleport: Darnassus"] = "Spell_Arcane_TeleportDarnassus",
	["Teleport: Ironforge"] = "Spell_Arcane_TeleportIronForge",
	["Teleport: Moonglade"] = "Spell_Arcane_TeleportMoonglade",
	["Teleport: Orgrimmar"] = "Spell_Arcane_TeleportOrgrimmar",
	["Teleport: Stormwind"] = "Spell_Arcane_TeleportStormWind",
	["Teleport: Thunder Bluff"] = "Spell_Arcane_TeleportThunderBluff",
	["Teleport: Undercity"] = "Spell_Arcane_TeleportUnderCity",
	["Tendon Rip"] = "Ability_CriticalStrike",
	["Tendon Slice"] = "Ability_CriticalStrike",
	["Terrify"] = "Ability_Physical_Taunt",
	["Terrifying Screech"] = "Spell_Shadow_SummonImp",
	["The Eye of the Dead"] = "INV_Trinket_Naxxramas01",
	["The Furious Storm"] = "Spell_Nature_CallStorm",
	["The Human Spirit"] = "INV_Enchant_ShardBrilliantSmall",
	["Thick Hide"] = "INV_Misc_Pelt_Bear_03",
	["Thorn Volley"] = "Spell_Nature_NaturesWrath",
	["Thorns"] = "Spell_Nature_Thorns",
	["Thousand Blades"] = "INV_Sword_53",
	["Threatening Gaze"] = "Spell_Shadow_Charm",
	["Throw Axe"] = "INV_Axe_08",
	["Throw Dynamite"] = "Spell_Fire_SelfDestruct",
	["Throw Liquid Fire"] = "Spell_Fire_MeteorStorm",
	["Throw Wrench"] = "INV_Misc_Wrench_01",
	["Throw"] = "Ability_Throw",
	["Throwing Specialization"] = "INV_ThrowingAxe_03",
	["Throwing Weapon Specialization"] = "INV_ThrowingKnife_01",
	["Thrown"] = "INV_ThrowingKnife_02",
	["Thunder Clap"] = "Spell_Nature_ThunderClap",
	["Thunderclap"] = "Spell_Nature_ThunderClap",
	["Thunderfury"] = "Spell_Nature_Cyclone",
	["Thundering Strikes"] = "Ability_ThunderBolt",
	["Thundershock"] = "Spell_Lightning_LightningBolt01",
	["Thunderstomp"] = "Ability_Hunter_Pet_Gorilla",
	["Tidal Focus"] = "Spell_Frost_ManaRecharge",
	["Tidal Mastery"] = "Spell_Nature_Tranquility",
	["Tiger Riding"] = "Spell_Nature_Swiftness",
	["Tiger's Fury"] = "Ability_Mount_JungleTiger",
	["Torment"] = "Spell_Shadow_GatherShadows",
	["Totem of Wrath"] = "Spell_Fire_TotemOfWrath",
	["Totem"] = "Spell_Nature_StoneClawTotem",
	["Totemic Focus"] = "Spell_Nature_MoonGlow",
	["Touch of Weakness"] = "Spell_Shadow_DeadofNight",
	["Toughness"] = "Spell_Holy_Devotion",
	["Toxic Saliva"] = "Spell_Nature_CorrosiveBreath",
	["Toxic Spit"] = "Spell_Nature_CorrosiveBreath",
	["Toxic Volley"] = "Spell_Nature_CorrosiveBreath",
	["Traces of Silithyst"] = "Spell_Nature_TimeStop",
	["Track Beasts"] = "Ability_Tracking",
	["Track Demons"] = "Spell_Shadow_SummonFelHunter",
	["Track Dragonkin"] = "INV_Misc_Head_Dragon_01",
	["Track Elementals"] = "Spell_Frost_SummonWaterElemental",
	["Track Giants"] = "Ability_Racial_Avatar",
	["Track Hidden"] = "Ability_Stealth",
	["Track Humanoids"] = "Spell_Holy_PrayerOfHealing",
	["Track Undead"] = "Spell_Shadow_DarkSummoning",
	["Trample"] = "Spell_Nature_NaturesWrath",
	["Tranquil Air Totem"] = "Spell_Nature_Brilliance",
	["Tranquil Spirit"] = "Spell_Holy_ElunesGrace",
	["Tranquility"] = "Spell_Nature_Tranquility",
	["Tranquilizing Poison"] = "Ability_Creature_Poison_03",
	["Tranquilizing Shot"] = "Spell_Nature_Drowsy",
	["Trap Mastery"] = "Ability_Ensnare",
	["Travel Form"] = "Ability_Druid_TravelForm",
	["Tremor Totem"] = "Spell_Nature_TremorTotem",
	["Trueshot Aura"] = "Ability_TrueShot",
	["Turn Undead"] = "Spell_Holy_TurnUndead",
	["Twisted Tranquility"] = "Spell_Nature_Tranquility",
	["Two-Handed Axes and Maces"] = "INV_Axe_10",
	["Two-Handed Axes"] = "INV_Axe_04",
	["Two-Handed Maces"] = "INV_Mace_04",
	["Two-Handed Swords"] = "Ability_MeleeDamage",
	["Two-Handed Weapon Specialization"] = "INV_Axe_09",
	["Unarmed"] = "Ability_GolemThunderClap",
	["Unbreakable Will"] = "Spell_Magic_MageArmor",
	["Unbridled Wrath Effect"] = "Spell_Nature_StoneClawTotem",
	["Unbridled Wrath"] = "Spell_Nature_StoneClawTotem",
	["Undead Horsemanship"] = "Spell_Nature_Swiftness",
	["Underwater Breathing"] = "Spell_Shadow_DemonBreath",
	["Unending Breath"] = "Spell_Shadow_DemonBreath",
	["Unholy Frenzy"] = "Spell_Nature_BloodLust",
	["Unholy Power"] = "Spell_Shadow_ShadowWordDominate",
	["Unleashed Fury"] = "Ability_BullRush",
	["Unleashed Rage"] = "Spell_Nature_Ancestralguardian",
	["Unstable Concoction"] = "Spell_Fire_Incinerate",
	["Unstable Power"] = "Trade_Engineering",
	["Unyielding Faith"] = "Spell_Holy_UnyieldingFaith",
	["Uppercut"] = "INV_Gauntlets_05",
	["Vampiric Embrace"] = "Spell_Shadow_UnsummonBuilding",
	["Vanish"] = "Ability_Vanish",
	["Vanished"] = "Ability_Vanish",
	["Veil of Shadow"] = "Spell_Shadow_GatherShadows",
	["Vengeance"] = "Spell_Nature_Purge",
	["Venom Spit"] = "Spell_Nature_CorrosiveBreath",
	["Venom Sting"] = "Ability_PoisonSting",
	["Venomhide Poison"] = "Ability_Rogue_DualWeild",
	["Vicious Rend"] = "Ability_Gouge",
	["Vigor"] = "Spell_Nature_EarthBindTotem",
	["Vile Poisons"] = "Ability_Rogue_FeignDeath",
	["Vindication"] = "Spell_Holy_Vindication",
	["Viper Sting"] = "Ability_Hunter_AimedShot",
	["Virulent Poison"] = "Spell_Nature_CorrosiveBreath",
	["Void Bolt"] = "Spell_Shadow_ShadowBolt",
	["Volley"] = "Ability_Marksmanship",
	["Walking Bomb Effect"] = "Spell_Fire_SelfDestruct",
	["Wand Specialization"] = "INV_Wand_01",
	["Wandering Plague"] = "Spell_Shadow_CorpseExplode",
	["Wands"] = "Ability_ShootWand",
	["War Stomp"] = "Ability_WarStomp",
	["Water Breathing"] = "Spell_Shadow_DemonBreath",
	["Water Walking"] = "Spell_Frost_WindWalkOn",
	["Water"] = "Spell_Frost_SummonWaterElemental",
	["Waterbolt"] =	"Spell_Frost_FrostBolt",
	["Wavering Will"] = "Spell_Shadow_AnimateDead",
	["Weakened Soul"] = "Spell_Holy_AshesToAshes",
	["Web Explosion"] = "Ability_Ensnare",
	["Web Spin"] = "Spell_Nature_EarthBind",
	["Web Spray"] = "Ability_Ensnare",
	["Web"] = "Ability_Ensnare",
	["Whirling Barrage"] = "INV_Spear_05",
	["Whirling Trip"] = "INV_Spear_05",
	["Whirlwind"] = "Ability_Whirlwind",
	["Wide Slash"] = "Ability_Warrior_Cleave",
	["Will of Hakkar"] = "Spell_Shadow_ShadowWordDominate",
	["Will of the Forsaken"] = "Spell_Shadow_RaiseDead",
	["Windfury Totem"] = "Spell_Nature_Windfury",
	["Windfury Weapon"] = "Spell_Nature_Cyclone",
	["Windsor's Frenzy"] = "Ability_Racial_BloodRage",
	["Windwall Totem"] = "Spell_Nature_EarthBind",
	["Wing Clip"] = "Ability_Rogue_Trip",
	["Wing Flap"] = "Spell_Nature_EarthBind",
	["Winter's Chill"] = "Spell_Frost_ChillingBlast",
	["Wisp Spirit"] = "Spell_Nature_WispSplode",
	["Wolf Riding"] = "Spell_Nature_Swiftness",
	["Wound Poison II"] = "INV_Misc_Herb_16",
	["Wound Poison III"] = "INV_Misc_Herb_16",
	["Wound Poison IV"] = "INV_Misc_Herb_16",
	["Wound Poison"] = "INV_Misc_Herb_16",
	["Wrath of Air Totem"] = "Spell_Nature_SlowingTotem",
	["Wrath"] = "Spell_Nature_AbolishMagic",
	["Wyvern Sting"] = "INV_Spear_02",
}

BabbleSpell:Debug()
BabbleSpell:SetStrictness(true)

function BabbleSpell:GetSpellIcon(spell)
	self:argCheck(spell, 2, "string")
	local icon = spellIcons[spell] or spellIcons[self:HasReverseTranslation(spell) and self:GetReverseTranslation(spell) or false]
	if not icon then
		return nil
	end
	return "Interface\\Icons\\" .. icon
end

function BabbleSpell:GetShortSpellIcon(spell)
	self:argCheck(spell, 2, "string")
	return spellIcons[spell] or spellIcons[self:HasReverseTranslation(spell) and self:GetReverseTranslation(spell) or false]
end

AceLibrary:Register(BabbleSpell, MAJOR_VERSION, MINOR_VERSION)
BabbleSpell = nil