--[[
Name: HealComm-1.0
Revision: $Rev: 11640 $
Author(s): aviana
Website: https://github.com/Aviana
Description: 治疗和复活相关的库
Dependencies: AceLibrary, AceEvent-2.0, RosterLib-2.0
]]

local MAJOR_VERSION = "HealComm-1.0"
local MINOR_VERSION = "$Revision: 11640 $"

if not AceLibrary then error(MAJOR_VERSION .. " requires AceLibrary") end
if not AceLibrary:IsNewVersion(MAJOR_VERSION, MINOR_VERSION) then return end
if not AceLibrary:HasInstance("RosterLib-2.0") then error(MAJOR_VERSION .. " requires RosterLib-2.0") end
if not AceLibrary:HasInstance("AceEvent-2.0") then error(MAJOR_VERSION .. " requires AceEvent-2.0") end
if not AceLibrary:HasInstance("AceHook-2.1") then error(MAJOR_VERSION .. " requires AceHook-2.1") end

local roster = AceLibrary("RosterLib-2.0")
local HealComm = {}

------------------------------------------------
-- Locales
------------------------------------------------

local L = {}
if GetLocale() == "zhCN" then
	L["Renew"] = "恢复"
	L["Rejuvenation"] = "回春术"
	L["Holy Light"] = "圣光术"
	L["Flash of Light"] = "圣光闪现"
	L["Healing Wave"] = "治疗波"
	L["Lesser Healing Wave"] = "次级治疗波"
	L["Chain Heal"] = "治疗链"
	L["Lesser Heal"] = "次级治疗术"
	L["Heal"] = "治疗术"
	L["Flash Heal"] = "快速治疗"
	L["Greater Heal"] = "强效治疗术"
	L["Prayer of Healing"] = "治疗祷言"
	L["Healing Touch"] = "治疗之触 "
	L["Regrowth"] = "愈合"
	L["Resurrection"] = "复活术"
	L["Rebirth"] = "复生"
	L["Redemption"] = "救赎"
	L["Ancestral Spirit"] = "先祖之魂"
	L["Libram of Divinity"] = "神性圣契"
	L["Libram of Light"] = "光明圣契"
	L["Totem of Sustaining"] = "持久图腾"
	L["Totem of Life"] = "生命图腾"
	L["Power Infusion"] = "能量灌注"
	L["Divine Favor"] = "神恩术"
	L["Nature Aligned"] = "自然之盟"
	L["Crusader's Wrath"] = "十字军之怒"
	L["The Furious Storm"] = "狂野风暴"
	L["Holy Power"] = "神圣强化"
	L["Prayer Beads Blessing"] = "祈祷之珠"
	L["Chromatic Infusion"] = "多彩能量"
	L["Ascendance"] = "优越"
	L["Ephemeral Power"] = "短暂强力"
	L["Unstable Power"] = "能量无常"
	L["Healing of the Ages"] = "远古治疗"
	L["Essence of Sapphiron"] = "萨菲隆的精华"
	L["The Eye of the Dead"] = "亡者之眼 "
	L["Mortal Strike"] = "致死打击"
	L["Wound Poison"] = "致伤毒药"
	L["Curse of the Deadwood"] = "死木诅咒"
	L["Veil of Shadow"] = "暗影迷雾"
	L["Gehennas' Curse"] = "基赫纳斯的诅咒"
	L["Mortal Wound"] = "重伤"
	L["Necrotic Poison"] = "死灵之毒"
	L["Necrotic Aura"] = "Necrotic Aura"
	L["Healing Way"] = "治疗之道"
	L["Warsong Gulch"] = "战歌峡谷"
	L["Arathi Basin"] = "阿拉希盆地"
	L["Alterac Valley"] = "奥特兰克山谷"
	L["Blessing of Light"] = "光明祝福"
	L["Blood Fury"] = "血性狂暴"
	L["Set: Increases the duration of your Rejuvenation spell by 3 sec."] = "套装：使你的回春术的持续时间延长3秒。" -- T2
	L["Set: Increases the duration of your Renew spell by 3 sec."] = "套装：使你的恢复术的持续时间延长3秒。" -- T2.5
	L["^Corpse of (.+)$"] = "(.+)的尸体"
else
	L["Renew"] = "Renew"
	L["Rejuvenation"] = "Rejuvenation"
	L["Holy Light"] = "Holy Light"
	L["Flash of Light"] = "Flash of Light"
	L["Healing Wave"] = "Healing Wave"
	L["Lesser Healing Wave"] = "Lesser Healing Wave"
	L["Chain Heal"] = "Chain Heal"
	L["Lesser Heal"] = "Lesser Heal"
	L["Heal"] = "Heal"
	L["Flash Heal"] = "Flash Heal"
	L["Greater Heal"] = "Greater Heal"
	L["Prayer of Healing"] = "Prayer of Healing"
	L["Healing Touch"] = "Healing Touch"
	L["Regrowth"] = "Regrowth"
	L["Resurrection"] = "Resurrection"
	L["Rebirth"] = "Rebirth"
	L["Redemption"] = "Redemption"
	L["Ancestral Spirit"] = "Ancestral Spirit"
	L["Libram of Divinity"] = "Libram of Divinity"
	L["Libram of Light"] = "Libram of Light"
	L["Totem of Sustaining"] = "Totem of Sustaining"
	L["Totem of Life"] = "Totem of Life"
	L["Power Infusion"] = "Power Infusion"
	L["Divine Favor"] = "Divine Favor"
	L["Nature Aligned"] = "Nature Aligned"
	L["Crusader's Wrath"] = "Crusader's Wrath"
	L["The Furious Storm"] = "The Furious Storm"
	L["Holy Power"] = "Holy Power"
	L["Prayer Beads Blessing"] = "Prayer Beads Blessing"
	L["Chromatic Infusion"] = "Chromatic Infusion"
	L["Ascendance"] = "Ascendance"
	L["Ephemeral Power"] = "Ephemeral Power"
	L["Unstable Power"] = "Unstable Power"
	L["Healing of the Ages"] = "Healing of the Ages"
	L["Essence of Sapphiron"] = "Essence of Sapphiron"
	L["The Eye of the Dead"] = "The Eye of the Dead"
	L["Mortal Strike"] = "Mortal Strike"
	L["Wound Poison"] = "Wound Poison"
	L["Curse of the Deadwood"] = "Curse of the Deadwood"
	L["Veil of Shadow"] = "Veil of Shadow"
	L["Gehennas' Curse"] = "Gehennas' Curse"
	L["Mortal Wound"] = "Mortal Wound"
	L["Necrotic Poison"] = "Necrotic Poison"
	L["Necrotic Aura"] = "Necrotic Aura"
	L["Healing Way"] = "Healing Way"
	L["Warsong Gulch"] = "Warsong Gulch"
	L["Arathi Basin"] = "Arathi Basin"
	L["Alterac Valley"] = "Alterac Valley"
	L["Blessing of Light"] = "Blessing of Light"
	L["Blood Fury"] = "Blood Fury"
	L["Set: Increases the duration of your Rejuvenation spell by 3 sec."] = "Set: Increases the duration of your Rejuvenation spell by 3 sec."
	L["Set: Increases the duration of your Renew spell by 3 sec."] = "Set: Increases the duration of your Renew spell by 3 sec."
	L["^Corpse of (.+)$"] = "^Corpse of (.+)$"
end
	
------------------------------------------------
-- activate, enable, disable
------------------------------------------------

local function activate(self, oldLib, oldDeactivate)
	HealComm = self
	if oldLib then
		self.Heals = oldLib.Heals
		self.GrpHeals = oldLib.GrpHeals
		self.Lookup = oldLib.Lookup
		self.pendingResurrections = oldlib.pendingResurrections
		self.Hots = oldLib.Hots
		self.SpellCastInfo = oldLib.SpellCastInfo
		oldLib:UnregisterAllEvents()
		oldLib:CancelAllScheduledEvents()
	end
	if not self.Heals then
		self.Heals = {}
	end
	if not self.GrpHeals then
		self.GrpHeals = {}
	end
	if not self.Lookup then
		self.Lookup = {}
	end
	if not self.pendingResurrections then
		self.pendingResurrections = {}
	end
	if not self.Hots then
		self.Hots = {}
	end
	if not self.SpellCastInfo then
		self.SpellCastInfo = {}
	end
	if oldDeactivate then oldDeactivate(oldLib) end
end

local function external(self, major, instance)
	if major == "AceEvent-2.0" then
		local AceEvent = instance
		AceEvent:embed(self)
		self:RegisterEvent("SPELLCAST_START")
		self:RegisterEvent("SPELLCAST_INTERRUPTED", "SPELLCAST_FAILED")
		self:RegisterEvent("SPELLCAST_FAILED")
		self:RegisterEvent("SPELLCAST_DELAYED")
		self:RegisterEvent("SPELLCAST_STOP")
		self:RegisterEvent("CHAT_MSG_ADDON")
		self:RegisterEvent("UNIT_AURA")
		self:RegisterEvent("UNIT_HEALTH")
		self:RegisterEvent("PLAYER_LOGIN")
		self:TriggerEvent("HealComm_Enabled")
	end
	if major == "AceHook-2.1" then
		local AceHook = instance
		AceHook:embed(self)
	end
end

function HealComm:PLAYER_LOGIN()
	self:HookScript(WorldFrame, "OnMouseDown", "OnMouseDown")
	self:Hook("CastSpell")
	self:Hook("CastSpellByName")
	self:Hook("UseAction")
	self:Hook("SpellTargetUnit")
	self:Hook("SpellStopTargeting")
	self:Hook("TargetUnit")
end

function HealComm:Enable()
-- not used anymore, but as addons still might be calling this method, we're keeping it.
end


function HealComm:Disable()
-- not used anymore, but as addons still might be calling this method, we're keeping it.
end

------------------------------------------------
-- Addon Code
------------------------------------------------

function strmatch(str, pat, init)
	local a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a13,a14,a15,a16,a17,a18,a19,a20 = string.find(str, pat, init)
	return a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a13,a14,a15,a16,a17,a18,a19,a20
end

HealComm.Spells = {
	[L["Holy Light"]] = {
		[1] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(1,5)
			local hlMod = 4*talentRank/100 + 1
			return (44*hlMod+(((2.5/3.5) * SpellPower)*0.1))
		end;
		[2] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(1,5)
			local hlMod = 4*talentRank/100 + 1
			return (88*hlMod+(((2.5/3.5) * SpellPower)*0.224))
		end;
		[3] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(1,5)
			local hlMod = 4*talentRank/100 + 1
			return (174*hlMod+(((2.5/3.5) * SpellPower)*0.476))
		end;
		[4] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(1,5)
			local hlMod = 4*talentRank/100 + 1
			return (334*hlMod+((2.5/3.5) * SpellPower))
		end;
		[5] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(1,5)
			local hlMod = 4*talentRank/100 + 1
			return (522*hlMod+((2.5/3.5) * SpellPower))
		end;
		[6] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(1,5)
			local hlMod = 4*talentRank/100 + 1
			return (740*hlMod+((2.5/3.5) * SpellPower))
		end;
		[7] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(1,5)
			local hlMod = 4*talentRank/100 + 1
			return (1000*hlMod+((2.5/3.5) * SpellPower))
		end;
		[8] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(1,5)
			local hlMod = 4*talentRank/100 + 1
			return (1318*hlMod+((2.5/3.5) * SpellPower))
		end;
		[9] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(1,5)
			local hlMod = 4*talentRank/100 + 1
			return (1681*hlMod+((2.5/3.5) * SpellPower))
		end;
	};
	[L["Flash of Light"]] = {
		[1] = function (SpellPower)
			local lp = 0
			if GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")) then
				local _,_,itemstring = string.find(GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")), "|H(.+)|h")
				local name = GetItemInfo(itemstring)
				if name == "Libram of Divinity" then
					lp = 53
				elseif name == "Libram of Light" then
					lp = 83
				end
			end
			local _,_,_,_,talentRank,_ = GetTalentInfo(1,5)
			local hlMod = 4*talentRank/100 + 1
			return (68*hlMod+lp+((1.5/3.5) * SpellPower))
		end;
		[2] = function (SpellPower)
			local lp = 0
			if GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")) then
				local _,_,itemstring = string.find(GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")), "|H(.+)|h")
				local name = GetItemInfo(itemstring)
				if name == "Libram of Divinity" then
					lp = 53
				elseif name == "Libram of Light" then
					lp = 83
				end
			end
			local _,_,_,_,talentRank,_ = GetTalentInfo(1,5)
			local hlMod = 4*talentRank/100 + 1
			return (104*hlMod+lp+((1.5/3.5) * SpellPower))
		end;
		[3] = function (SpellPower)
			local lp = 0
			if GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")) then
				local _,_,itemstring = string.find(GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")), "|H(.+)|h")
				local name = GetItemInfo(itemstring)
				if name == "Libram of Divinity" then
					lp = 53
				elseif name == "Libram of Light" then
					lp = 83
				end
			end
			local _,_,_,_,talentRank,_ = GetTalentInfo(1,5)
			local hlMod = 4*talentRank/100 + 1
			return (155*hlMod+lp+((1.5/3.5) * SpellPower))
		end;
		[4] = function (SpellPower)
			local lp = 0
			if GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")) then
				local _,_,itemstring = string.find(GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")), "|H(.+)|h")
				local name = GetItemInfo(itemstring)
				if name == "Libram of Divinity" then
					lp = 53
				elseif name == "Libram of Light" then
					lp = 83
				end
			end
			local _,_,_,_,talentRank,_ = GetTalentInfo(1,5)
			local hlMod = 4*talentRank/100 + 1
			return (210*hlMod+lp+((1.5/3.5) * SpellPower))
		end;
		[5] = function (SpellPower)
			local lp = 0
			if GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")) then
				local _,_,itemstring = string.find(GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")), "|H(.+)|h")
				local name = GetItemInfo(itemstring)
				if name == "Libram of Divinity" then
					lp = 53
				elseif name == "Libram of Light" then
					lp = 83
				end
			end
			local _,_,_,_,talentRank,_ = GetTalentInfo(1,5)
			local hlMod = 4*talentRank/100 + 1
			return (284*hlMod+lp+((1.5/3.5) * SpellPower))
		end;
		[6] = function (SpellPower)
			local lp = 0
			if GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")) then
				local _,_,itemstring = string.find(GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")), "|H(.+)|h")
				local name = GetItemInfo(itemstring)
				if name == "Libram of Divinity" then
					lp = 53
				elseif name == "Libram of Light" then
					lp = 83
				end
			end
			local _,_,_,_,talentRank,_ = GetTalentInfo(1,5)
			local hlMod = 4*talentRank/100 + 1
			return (364*hlMod+lp+((1.5/3.5) * SpellPower))
		end;
		[7] = function (SpellPower)
			local lp = 0
			if GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")) then
				local _,_,itemstring = string.find(GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")), "|H(.+)|h")
				local name = GetItemInfo(itemstring)
				if name == "Libram of Divinity" then
					lp = 53
				elseif name == "Libram of Light" then
					lp = 83
				end
			end
			local _,_,_,_,talentRank,_ = GetTalentInfo(1,5)
			local hlMod = 4*talentRank/100 + 1
			return (481*hlMod+lp+((1.5/3.5) * SpellPower))
		end;
	};
	[L["Healing Wave"]] = {
		[1] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,14)
			local pMod = 2*talentRank/100 + 1
			return (40*pMod+(((1.5/3.5) * SpellPower)*0.22))
		end;
		[2] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,14)
			local pMod = 2*talentRank/100 + 1
			return (72*pMod+(((2/3.5) * SpellPower)*0.38))
		end;
		[3] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,14)
			local pMod = 2*talentRank/100 + 1
			return (143*pMod+(((2.5/3.5) * SpellPower)*0.446))
		end;
		[4] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,14)
			local pMod = 2*talentRank/100 + 1
			return (293*pMod+(((3/3.5) * SpellPower)*0.7))
		end;
		[5] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,14)
			local pMod = 2*talentRank/100 + 1
			return (409*pMod+((3/3.5) * SpellPower))
		end;
		[6] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,14)
			local pMod = 2*talentRank/100 + 1
			return (580*pMod+((3/3.5) * SpellPower))
		end;
		[7] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,14)
			local pMod = 2*talentRank/100 + 1
			return (798*pMod+((3/3.5) * SpellPower))
		end;
		[8] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,14)
			local pMod = 2*talentRank/100 + 1
			return (1093*pMod+((3/3.5) * SpellPower))
		end;
		[9] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,14)
			local pMod = 2*talentRank/100 + 1
			return (1465*pMod+((3/3.5) * SpellPower))
		end;
		[10] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,14)
			local pMod = 2*talentRank/100 + 1
			return (1736*pMod+((3/3.5) * SpellPower))
		end;
	};
	[L["Lesser Healing Wave"]] = {
		[1] = function (SpellPower)
			local tp = 0
			if GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")) then
				local _,_,itemstring = string.find(GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")), "|H(.+)|h")
				local name = GetItemInfo(itemstring)
				if name == "Totem of Sustaining" then
					tp = 53
				elseif name == "Totem of Life" then
					tp = 80
				end
			end
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,14)
			local pMod = 2*talentRank/100 + 1
			return (175*pMod+tp+((1.5/3.5) * SpellPower))
		end;
		[2] = function (SpellPower)
			local tp = 0
			if GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")) then
				local _,_,itemstring = string.find(GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")), "|H(.+)|h")
				local name = GetItemInfo(itemstring)
				if name == "Totem of Sustaining" then
					tp = 53
				elseif name == "Totem of Life" then
					tp = 80
				end
			end
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,14)
			local pMod = 2*talentRank/100 + 1
			return (265*pMod+tp+((1.5/3.5) * SpellPower))
		end;
		[3] = function (SpellPower)
			local tp = 0
			if GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")) then
				local _,_,itemstring = string.find(GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")), "|H(.+)|h")
				local name = GetItemInfo(itemstring)
				if name == "Totem of Sustaining" then
					tp = 53
				elseif name == "Totem of Life" then
					tp = 80
				end
			end
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,14)
			local pMod = 2*talentRank/100 + 1
			return (360*pMod+tp+((1.5/3.5) * SpellPower))
		end;
		[4] = function (SpellPower)
			local tp = 0
			if GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")) then
				local _,_,itemstring = string.find(GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")), "|H(.+)|h")
				local name = GetItemInfo(itemstring)
				if name == "Totem of Sustaining" then
					tp = 53
				elseif name == "Totem of Life" then
					tp = 80
				end
			end
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,14)
			local pMod = 2*talentRank/100 + 1
			return (487*pMod+tp+((1.5/3.5) * SpellPower))
		end;
		[5] = function (SpellPower)
			local tp = 0
			if GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")) then
				local _,_,itemstring = string.find(GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")), "|H(.+)|h")
				local name = GetItemInfo(itemstring)
				if name == "Totem of Sustaining" then
					tp = 53
				elseif name == "Totem of Life" then
					tp = 80
				end
			end
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,14)
			local pMod = 2*talentRank/100 + 1
			return (669*pMod+tp+((1.5/3.5) * SpellPower))
		end;
		[6] = function (SpellPower)
			local tp = 0
			if GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")) then
				local _,_,itemstring = string.find(GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot")), "|H(.+)|h")
				local name = GetItemInfo(itemstring)
				if name == "Totem of Sustaining" then
					tp = 53
				elseif name == "Totem of Life" then
					tp = 80
				end
			end
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,14)
			local pMod = 2*talentRank/100 + 1
			return (881*pMod+tp+((1.5/3.5) * SpellPower))
		end;
	};
	[L["Chain Heal"]] = {
		[1] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,14)
			local pMod = 2*talentRank/100 + 1
			return (344*pMod+((2.5/3.5) * SpellPower))
		end;
		[2] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,14)
			local pMod = 2*talentRank/100 + 1
			return (435*pMod+((2.5/3.5) * SpellPower))
		end;
		[3] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,14)
			local pMod = 2*talentRank/100 + 1
			return (591*pMod+((2.5/3.5) * SpellPower))
		end;
	};
	[L["Lesser Heal"]] = {
		[1] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (52*shMod+((1.5/3.5) * (SpellPower+sgMod))*0.19)
		end;
		[2] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (79*shMod+((2/3.5) * (SpellPower+sgMod))*0.34)
		end;
		[3] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (147*shMod+((2.5/3.5) * (SpellPower+sgMod))*0.6)
		end;
	};
	[L["Heal"]] = {
		[1] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (319*shMod+((3/3.5) * (SpellPower+sgMod))*0.586)
		end;
		[2] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (471*shMod+((3/3.5) * (SpellPower+sgMod)))
		end;
		[3] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (610*shMod+((3/3.5) * (SpellPower+sgMod)))
		end;
		[4] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (759*shMod+((3/3.5) * (SpellPower+sgMod)))
		end;
	};
	[L["Flash Heal"]] = {
		[1] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (216*shMod+((1.5/3.5) * (SpellPower+sgMod)))
		end;
		[2] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (287*shMod+((1.5/3.5) * (SpellPower+sgMod)))
		end;
		[3] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (361*shMod+((1.5/3.5) * (SpellPower+sgMod)))
		end;
		[4] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (440*shMod+((1.5/3.5) * (SpellPower+sgMod)))
		end;
		[5] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (568*shMod+((1.5/3.5) * (SpellPower+sgMod)))
		end;
		[6] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (705*shMod+((1.5/3.5) * (SpellPower+sgMod)))
		end;
		[7] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (886*shMod+((1.5/3.5) * (SpellPower+sgMod)))
		end;
	};
	[L["Greater Heal"]] = {
		[1] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (957*shMod+((3/3.5) * (SpellPower+sgMod)))
		end;
		[2] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (1220*shMod+((3/3.5) * (SpellPower+sgMod)))
		end;
		[3] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (1524*shMod+((3/3.5) * (SpellPower+sgMod)))
		end;
		[4] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (1903*shMod+((3/3.5) * (SpellPower+sgMod)))
		end;
		[5] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (2081*shMod+((3/3.5) * (SpellPower+sgMod)))
		end;
	};
	[L["Prayer of Healing"]] = {
		[1] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (311*shMod+((3/3.5/3) * (SpellPower+sgMod)))
		end;
		[2] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (460*shMod+((3/3.5/3) * (SpellPower+sgMod)))
		end;
		[3] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (676*shMod+((3/3.5/3) * (SpellPower+sgMod)))
		end;
		[4] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (965*shMod+((3/3.5/3) * (SpellPower+sgMod)))
		end;
		[5] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(2,14)
			local _,Spirit,_,_ = UnitStat("player",5)
			local sgMod = Spirit * 5*talentRank/100
			local _,_,_,_,talentRank2,_ = GetTalentInfo(2,15)
			local shMod = 2*talentRank2/100 + 1
			return (1070*shMod+((3/3.5/3) * (SpellPower+sgMod)))
		end;
	};
	[L["Healing Touch"]] = {
		[1] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,12)
			local gnMod = 2*talentRank/100 + 1
			return (43*gnMod+((1.5/3.5) * SpellPower * (1-((20-4)*0.0375))))
		end;
		[2] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,12)
			local gnMod = 2*talentRank/100 + 1
			return (101*gnMod+((2/3.5) * SpellPower * (1-((20-13)*0.0375))))
		end;
		[3] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,12)
			local gnMod = 2*talentRank/100 + 1
			return (220*gnMod+((2.5/3.5) * SpellPower))
		end;
		[4] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,12)
			local gnMod = 2*talentRank/100 + 1
			return (435*gnMod+((3/3.5) * SpellPower))
		end;
		[5] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,12)
			local gnMod = 2*talentRank/100 + 1
			return ((634*gnMod)+SpellPower)
		end;
		[6] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,12)
			local gnMod = 2*talentRank/100 + 1
			return ((819*gnMod)+SpellPower)
		end;
		[7] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,12)
			local gnMod = 2*talentRank/100 + 1
			return ((1029*gnMod)+SpellPower)
		end;
		[8] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,12)
			local gnMod = 2*talentRank/100 + 1
			return ((1314*gnMod)+SpellPower)
		end;
		[9] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,12)
			local gnMod = 2*talentRank/100 + 1
			return ((1657*gnMod)+SpellPower)
		end;
		[10] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,12)
			local gnMod = 2*talentRank/100 + 1
			return ((2061*gnMod)+SpellPower)
		end;
		[11] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,12)
			local gnMod = 2*talentRank/100 + 1
			return ((2473*gnMod)+SpellPower)
		end;
	};
	[L["Regrowth"]] = {
		[1] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,12)
			local gnMod = 2*talentRank/100 + 1
			return ((91*gnMod)+(((2/3.5)*SpellPower)*0.5*0.38))
		end;
		[2] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,12)
			local gnMod = 2*talentRank/100 + 1
			return ((177*gnMod)+(((2/3.5)*SpellPower)*0.5*0.513))
		end;
		[3] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,12)
			local gnMod = 2*talentRank/100 + 1
			return ((258*gnMod)+(((2/3.5)*SpellPower)*0.5))
		end;
		[4] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,12)
			local gnMod = 2*talentRank/100 + 1
			return ((340*gnMod)+(((2/3.5)*SpellPower)*0.5))
		end;
		[5] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,12)
			local gnMod = 2*talentRank/100 + 1
			return ((432*gnMod)+(((2/3.5)*SpellPower)*0.5))
		end;
		[6] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,12)
			local gnMod = 2*talentRank/100 + 1
			return ((544*gnMod)+(((2/3.5)*SpellPower)*0.5))
		end;
		[7] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,12)
			local gnMod = 2*talentRank/100 + 1
			return ((686*gnMod)+(((2/3.5)*SpellPower)*0.5))
		end;
		[8] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,12)
			local gnMod = 2*talentRank/100 + 1
			return ((858*gnMod)+(((2/3.5)*SpellPower)*0.5))
		end;
		[9] = function (SpellPower)
			local _,_,_,_,talentRank,_ = GetTalentInfo(3,12)
			local gnMod = 2*talentRank/100 + 1
			return ((1062*gnMod)+(((2/3.5)*SpellPower)*0.5))
		end;
	};
}

local Resurrections = {
	[L["Resurrection"]] = true;
	[L["Rebirth"]] = true;
	[L["Redemption"]] = true;
	[L["Ancestral Spirit"]] = true;
}

local function strsplit(pString, pPattern)
	local Table = {}
	local fpat = "(.-)" .. pPattern
	local last_end = 1
	local s, e, cap = strfind(pString, fpat, 1)
	while s do
		if s ~= 1 or cap ~= "" then
			table.insert(Table,cap)
		end
		last_end = e+1
		s, e, cap = strfind(pString, fpat, last_end)
	end
	if last_end <= strlen(pString) then
		cap = strfind(pString, last_end)
		table.insert(Table, cap)
	end
	return Table
end

local healcommTip = CreateFrame("GameTooltip", "healcommTip", nil, "GameTooltipTemplate")
healcommTip:SetOwner(WorldFrame, "ANCHOR_NONE")

HealComm.Buffs = {
	[L["Power Infusion"]] = {amount = 0, mod = 0.2, icon = "Interface\\Icons\\Spell_Holy_PowerInfusion"};
	[L["Divine Favor"]] = {amount = 0, mod = 0.5, icon = "Interface\\Icons\\Spell_Holy_Heal"};
	[L["Nature Aligned"]] = {amount = 0, mod = 0.2, icon = "Interface\\Icons\\Spell_Nature_SpiritArmor"};
	[L["Crusader's Wrath"]] = {amount = 95, mod = 0, icon = "Interface\\Icons\\Spell_Nature_GroundingTotem"};
	[L["The Furious Storm"]] = {amount = 95, mod = 0, icon = "Interface\\Icons\\Spell_Nature_CallStorm"};
	[L["Holy Power"]] = {amount = 80, mod = 0, icon = "Interface\\Icons\\Spell_Holy_HolyNova"};
	[L["Prayer Beads Blessing"]] = {amount = 190, mod = 0, icon = "Interface\\Icons\\Inv_Jewelry_Necklace_11"};
	[L["Chromatic Infusion"]] = {amount = 190, mod = 0, icon = "Interface\\Icons\\Spell_Holy_MindVision"};
	[L["Ascendance"]] = {amount = 75, mod = 0, icon = "Interface\\Icons\\Spell_Lightning_LightningBolt01"};
	[L["Ephemeral Power"]] = {amount = 175, mod = 0, icon = "Interface\\Icons\\Spell_Holy_MindVision"};
	[L["Unstable Power"]] = {amount = 34, mod = 0, icon = "Interface\\Icons\\Spell_Lightning_LightningBolt01"};
	[L["Healing of the Ages"]] = {amount = 350, mod = 0, icon = "Interface\\Icons\\Spell_Nature_HealingWaveGreater"};
	[L["Essence of Sapphiron"]] = {amount = 130, mod = 0, icon = "Interface\\Icons\\Inv_Trinket_Naxxramas06"};
	[L["The Eye of the Dead"]] = {amount = 450, mod = 0, icon = "Interface\\Icons\\Inv_Trinket_Naxxramas01"}
}
	
HealComm.Debuffs = {
	[L["Mortal Strike"]] = {amount = 0, mod = 0.5, icon = "Interface\\Icons\\Ability_Warrior_SavageBlow"};
	[L["Wound Poison"]] = {amount = -135, mod = 0, icon = "Interface\\Icons\\Inv_Misc_Herb_16"};
	[L["Curse of the Deadwood"]] = {amount = 0, mod = 0.5, icon = "Interface\\Icons\\Spell_Shadow_GatherShadows"};
	[L["Veil of Shadow"]] = {amount = 0, mod = 0.75, icon = "Interface\\Icons\\Spell_Shadow_GatherShadows"};
	[L["Gehennas' Curse"]] = {amount = 0, mod = 0.75, icon = "Interface\\Icons\\Spell_Shadow_GatherShadows"};
	[L["Mortal Wound"]] = {amount = 0, mod = 0.1, icon = "Interface\\Icons\\Ability_CriticalStrike"};
	[L["Necrotic Poison"]] = {amount = 0, mod = 0.9, icon = "Interface\\Icons\\Ability_Creature_Poison_03"};
	[L["Blood Fury"]] = {amount = 0, mod = 0.5, icon = "Interface\\Icons\\Ability_Rogue_FeignDeath"};
	[L["Necrotic Aura"]] = {amount = 0, mod = 1, icon = "Interface\\Icons\\Ability_Creature_Disease_05"}
}
	
local function getSetBonus()
	healcommTip:SetInventoryItem("player", 1)
	local text = "healcommTipTextLeft"..(healcommTip:NumLines() or 1)
	local text = getglobal(text)
	if text then
		text = text:GetText()
	else
		return nil
	end
	if text == L["Set: Increases the duration of your Rejuvenation spell by 3 sec."] or text == L["Set: Increases the duration of your Renew spell by 3 sec."] then
		return true
	else
		return nil
	end
end
	
function HealComm:GetBuffSpellPower()
	local Spellpower = 0
	local healmod = 1
	for i=1, 32 do
		local buffTexture, buffApplications = UnitBuff("player", i)
		if not buffTexture then
			return Spellpower, healmod
		end
		healcommTip:SetUnitBuff("player", i)
		local buffName = healcommTipTextLeft1:GetText()
		if self.Buffs[buffName] and self.Buffs[buffName].icon == buffTexture then
			Spellpower = (self.Buffs[buffName].amount * buffApplications) + Spellpower
			healmod = (self.Buffs[buffName].mod * buffApplications) + healmod
		end
	end
	return Spellpower, healmod
end

function HealComm:GetUnitSpellPower(unit, spell)
	local targetpower = 0
	local targetmod = 1
	local buffTexture, buffApplications
	local debuffTexture, debuffApplications
	local buffName
	for i=1, 32 do
		if UnitIsVisible(unit) and UnitIsConnected(unit) and UnitCanAssist("player", unit) then
			buffTexture, buffApplications = UnitBuff(unit, i)
			healcommTip:SetUnitBuff(unit, i)
		else
			buffTexture, buffApplications = UnitBuff("player", i)
			healcommTip:SetUnitBuff("player", i)
		end
		if not buffTexture then
			break
		end
		buffName = healcommTipTextLeft1:GetText()
		if buffName == L["Blessing of Light"] then
			local HLBonus, FoLBonus = strmatch(healcommTipTextLeft2:GetText(),"(%d+).-(%d+)")
			if (spell == L["Flash of Light"]) then
				targetpower = FoLBonus + targetpower
			elseif spell == L["Holy Light"] then
				targetpower = HLBonus + targetpower
			end
		end
		if buffName == L["Healing Way"] and spell == L["Healing Wave"] then
			targetmod = targetmod * ((buffApplications * 0.06) + 1)
		end
	end
	for i=1, 16 do
		if UnitIsVisible(unit) and UnitIsConnected(unit) and UnitCanAssist("player", unit) then
			debuffTexture, debuffApplications = UnitDebuff(unit, i)
			healcommTip:SetUnitDebuff(unit, i)
		else
			debuffTexture, debuffApplications = UnitDebuff("player", i)
			healcommTip:SetUnitDebuff("player", i)
		end
		if not debuffTexture then
			break
		end
		local debuffName = healcommTipTextLeft1:GetText()
		if self.Debuffs[debuffName] then
			targetpower = (self.Debuffs[debuffName].amount * debuffApplications) + targetpower
			targetmod = (1-(self.Debuffs[debuffName].mod * debuffApplications)) * targetmod
		end
	end
	return targetpower, targetmod
end			

function HealComm:UNIT_HEALTH()
	local name = UnitName(arg1)
	if self.pendingResurrections[name] then
		for k,v in pairs(self.pendingResurrections[name]) do
			self.pendingResurrections[name][k] = nil
		end
		self:TriggerEvent("HealComm_Ressupdate", name)
	end
end
			
function HealComm:stopHeal(caster)
	if self:IsEventScheduled("Healcomm_"..caster) then
		self:CancelScheduledEvent("Healcomm_"..caster)
	end
	if self.Lookup[caster] then
		self.Heals[self.Lookup[caster]][caster] = nil
		self:TriggerEvent("HealComm_Healupdate", self.Lookup[caster])
		self.Lookup[caster] = nil
	end
end

function HealComm:startHeal(caster, target, size, casttime)
	self:ScheduleEvent("Healcomm_"..caster, self.stopHeal, (casttime/1000), self, caster)
	if not self.Heals[target] then
		self.Heals[target] = {}
	end
	if self.Lookup[caster] then
		self.Heals[self.Lookup[caster]][caster] = nil
		self.Lookup[caster] = nil
	end
	self.Heals[target][caster] = {amount = size, ctime = (casttime/1000)+GetTime()}
	self.Lookup[caster] = target
	self:TriggerEvent("HealComm_Healupdate", target)
end

function HealComm:delayHeal(caster, delay)
	self:CancelScheduledEvent("Healcomm_"..caster)
	if self.Lookup[caster] and self.Heals[self.Lookup[caster]] then
		self.Heals[self.Lookup[caster]][caster].ctime = self.Heals[self.Lookup[caster]][caster].ctime + (delay/1000)
		self:ScheduleEvent("Healcomm_"..caster, self.stopHeal, (self.Heals[self.Lookup[caster]][caster].ctime-GetTime()), self, caster)
	end
end

function HealComm:startGrpHeal(caster, size, casttime, party1, party2, party3, party4, party5)
	self:ScheduleEvent("Healcomm_"..caster, self.stopGrpHeal, (casttime/1000), self, caster)
	self.GrpHeals[caster] = {amount = size, ctime = (casttime/1000)+GetTime(), targets = {party1, party2, party3, party4, party5}}
	for i=1,getn(self.GrpHeals[caster].targets) do
		self:TriggerEvent("HealComm_Healupdate", self.GrpHeals[caster].targets[i])
	end
end

function HealComm:stopGrpHeal(caster)
	if self:IsEventScheduled("Healcomm_"..caster) then
		self:CancelScheduledEvent("Healcomm_"..caster)
	end
	local targets
	if self.GrpHeals[caster] then
		targets = self.GrpHeals[caster].targets
	end
	self.GrpHeals[caster] = nil
	if targets then
		for i=1,getn(targets) do
			self:TriggerEvent("HealComm_Healupdate", targets[i])
		end
	end
end

function HealComm:delayGrpHeal(caster, delay)
	self:CancelScheduledEvent("Healcomm_"..caster)
	if self.GrpHeals[caster] then
		self.GrpHeals[caster].ctime = self.GrpHeals[caster].ctime + (delay/1000)
		self:ScheduleEvent("Healcomm_"..caster, self.stopGrpHeal, (self.GrpHeals[caster].ctime-GetTime()), self, caster)
	end
end

function HealComm:startResurrection(caster, target)
	if not self.pendingResurrections[target] then
		self.pendingResurrections[target] = {}
	end
	self.pendingResurrections[target][caster] = GetTime()+70
	self:ScheduleEvent("Healcomm_"..caster..target, self.RessExpire, 70, self, caster, target)
	self:TriggerEvent("HealComm_Ressupdate", target)
end

function HealComm:cancelResurrection(caster)
	for k,v in pairs(self.pendingResurrections) do
		if v[caster] and (v[caster]-GetTime()) > 60 then
			self.pendingResurrections[k][caster] = nil
			self:TriggerEvent("HealComm_Ressupdate", k)
		end
	end
end

function HealComm:RessExpire(caster, target)
	self.pendingResurrections[target][caster] = nil
	self:TriggerEvent("HealComm_Ressupdate", target)
end

function HealComm:SendAddonMessage(msg)
	local zone = GetRealZoneText()
	if zone == L["Warsong Gulch"] or zone == L["Arathi Basin"] or zone == L["Alterac Valley"] then
		SendAddonMessage("HealComm", msg, "BATTLEGROUND")
	else
		SendAddonMessage("HealComm", msg, "RAID")
	end
end

function HealComm:SPELLCAST_START()
	if ( self.SpellCastInfo and self.SpellCastInfo[1] == arg1 and self.Spells[arg1] ) then
		local Bonus = 0
		if BonusScanner then
			Bonus = tonumber(BonusScanner:GetBonus("HEAL"))
		end
		local buffpower, buffmod = self:GetBuffSpellPower()
		local targetpower, targetmod = self.SpellCastInfo[4], self.SpellCastInfo[5]
		local Bonus = Bonus + buffpower
		local amount = ((math.floor(self.Spells[self.SpellCastInfo[1]][tonumber(self.SpellCastInfo[2])](Bonus))+targetpower)*buffmod*targetmod)
		if arg1 == L["Prayer of Healing"] then
			local targets = {UnitName("player")}
			local targetsstring = UnitName("player").."/"
			for i=1,4 do
				if CheckInteractDistance("party"..i, 4) then
					table.insert(targets, i ,UnitName("party"..i))
					targetsstring = targetsstring..UnitName("party"..i).."/"
				end
			end
			self:SendAddonMessage("GrpHeal/"..amount.."/"..arg2.."/"..targetsstring)
			self:startGrpHeal(UnitName("player"), amount, arg2, targets[1], targets[2], targets[3], targets[4], targets[5])
		else
			self:SendAddonMessage("Heal/"..self.SpellCastInfo[3].."/"..amount.."/"..arg2.."/")
			self:startHeal(UnitName("player"), self.SpellCastInfo[3], amount, arg2)
		end
	elseif ( self.SpellCastInfo and self.SpellCastInfo[1] == arg1 and Resurrections[arg1] ) then
		self:SendAddonMessage("Resurrection/"..self.SpellCastInfo[3].."/start/")
		self:startResurrection(UnitName("player"), self.SpellCastInfo[3])
	end
	self.spellIsCasting = arg1
end

function HealComm:SPELLCAST_FAILED()
	if self:IsEventScheduled("TriggerRegrowthHot") then
		self:CancelScheduledEvent("TriggerRegrowthHot")
	end

	if self.Spells[self.spellIsCasting] then
		if self.spellIsCasting == L["Prayer of Healing"] then
			self:SendAddonMessage("GrpHealstop")
			self:stopGrpHeal(UnitName("player"))
		else
			self:SendAddonMessage("Healstop")
			self:stopHeal(UnitName("player"))
		end
	elseif Resurrections[self.spellIsCasting] then
		self:SendAddonMessage("Resurrection/stop/")
		self:cancelResurrection(UnitName("player"))
	end
	self.CurrentSpellRank = nil
	self.CurrentSpellName =  nil
	self.spellIsCasting = nil
	for key in pairs(self.SpellCastInfo) do
		self.SpellCastInfo[key] = nil
	end
end

function HealComm:SPELLCAST_DELAYED()
	if self.spellIsCasting == L["Prayer of Healing"] then
		self:SendAddonMessage("GrpHealdelay/"..arg1.."/")
		self:delayGrpHeal(UnitName("player"), arg1)
	else
		self:SendAddonMessage("Healdelay/"..arg1.."/")
		self:delayHeal(UnitName("player"), arg1)
	end
end

function HealComm:TriggerRegrowthHot()
	local dur = 21
	self:SendAddonMessage("Regr/"..self.savetarget.."/"..dur.."/")
	if not self.Hots[self.savetarget] then
		self.Hots[self.savetarget] = {}
	end
	if not self.Hots[self.savetarget]["Regr"] then
		self.Hots[self.savetarget]["Regr"]= {}
	end
	self.Hots[self.savetarget]["Regr"].start = GetTime()
	self.Hots[self.savetarget]["Regr"].dur = dur
	self:TriggerEvent("HealComm_Hotupdate", roster:GetUnitIDFromName(self.savetarget), "Regrowth")
end

function HealComm:SPELLCAST_STOP()
	if not self.SpellCastInfo then return end
	local targetUnit = roster:GetUnitIDFromName(self.SpellCastInfo[3])
	if targetUnit then
		if self.SpellCastInfo[1] == L["Renew"] then
			local dur = getSetBonus() and 18 or 15
			self:SendAddonMessage("Renew/"..self.SpellCastInfo[3].."/"..dur.."/")
			if not self.Hots[self.SpellCastInfo[3]] then
				self.Hots[self.SpellCastInfo[3]] = {}
			end
			if not self.Hots[self.SpellCastInfo[3]]["Renew"] then
				self.Hots[self.SpellCastInfo[3]]["Renew"]= {}
			end
			self.Hots[self.SpellCastInfo[3]]["Renew"].start = GetTime()
			self.Hots[self.SpellCastInfo[3]]["Renew"].dur = dur
			self:TriggerEvent("HealComm_Hotupdate", targetUnit, "Renew")
		elseif self.SpellCastInfo[1] == L["Rejuvenation"] then
			local dur = getSetBonus() and 15 or 12
			self:SendAddonMessage("Reju/"..self.SpellCastInfo[3].."/"..dur.."/")
			if not self.Hots[self.SpellCastInfo[3]] then
				self.Hots[self.SpellCastInfo[3]] = {}
			end
			if not self.Hots[self.SpellCastInfo[3]]["Reju"] then
				self.Hots[self.SpellCastInfo[3]]["Reju"]= {}
			end
			self.Hots[self.SpellCastInfo[3]]["Reju"].start = GetTime()
			self.Hots[self.SpellCastInfo[3]]["Reju"].dur = dur
			self:TriggerEvent("HealComm_Hotupdate", targetUnit, "Rejuvenation")
		elseif self.SpellCastInfo[1] == L["Regrowth"] then
			self.savetarget = self.SpellCastInfo[3]
			self:ScheduleEvent("TriggerRegrowthHot", self.TriggerRegrowthHot, 0.3, self)
		end
	end
	self.CurrentSpellRank = nil
	self.CurrentSpellName =  nil
	for key in pairs(self.SpellCastInfo) do
		self.SpellCastInfo[key] = nil
	end
end

function HealComm:CHAT_MSG_ADDON()
	if arg1 == "HealComm" and arg4 ~= UnitName("player") then
		local result = strsplit(arg2,"/")
		if result[1] == "Heal" then
			self:startHeal(arg4, result[2], result[3], result[4])
		elseif arg2 == "Healstop" then
			self:stopHeal(arg4)
		elseif result[1] == "Healdelay" then
			self:delayHeal(arg4, result[2])
		elseif result[1] == "Resurrection" and result[2] == "stop" then
			self:cancelResurrection(arg4)
		elseif result[1] == "Resurrection" and result[3] == "start" then
			self:startResurrection(arg4, result[2])
		elseif result[1] == "GrpHeal" then
			self:startGrpHeal(arg4, result[2], result[3], result[4], result[5], result[6], result[7], result[8])
		elseif arg2 == "GrpHealstop" then
			self:stopGrpHeal(arg4)
		elseif result[1] == "GrpHealdelay" then
			self:delayGrpHeal(arg4, result[2])
		elseif result[1] == "Renew" then
			if not self.Hots[result[2]] then
				self.Hots[result[2]] = {}
			end
			if not self.Hots[result[2]]["Renew"] then
				self.Hots[result[2]]["Renew"]= {}
			end
			self.Hots[result[2]]["Renew"].dur = result[3]
			self.Hots[result[2]]["Renew"].start = GetTime()
			local targetUnit = roster:GetUnitIDFromName(result[2])
			self:TriggerEvent("HealComm_Hotupdate", targetUnit, "Renew")
		elseif result[1] == "Reju" then
			if not self.Hots[result[2]] then
				self.Hots[result[2]] = {}
			end
			if not self.Hots[result[2]]["Reju"] then
				self.Hots[result[2]]["Reju"]= {}
			end
			self.Hots[result[2]]["Reju"].dur = result[3]
			self.Hots[result[2]]["Reju"].start = GetTime()
			local targetUnit = roster:GetUnitIDFromName(result[2])
			self:TriggerEvent("HealComm_Hotupdate", targetUnit, "Rejuvenation")
		elseif result[1] == "Regr" then
			if not self.Hots[result[2]] then
				self.Hots[result[2]] = {}
			end
			if not self.Hots[result[2]]["Regr"] then
				self.Hots[result[2]]["Regr"]= {}
			end
			self.Hots[result[2]]["Regr"].dur = result[3]
			self.Hots[result[2]]["Regr"].start = GetTime()
			local targetUnit = roster:GetUnitIDFromName(result[2])
			self:TriggerEvent("HealComm_Hotupdate", targetUnit, "Regrowth")
		end
	end
end

function HealComm:UNIT_AURA()
	local name = UnitName(arg1)
	if self.Hots[name] and (self.Hots[name]["Regr"] or self.Hots[name]["Reju"] or self.Hots[name]["Renew"]) then
		local regr,reju,renew
		for i=1,32 do
			if not UnitBuff(arg1,i) then
				break
			end
			healcommTip:ClearLines()
			healcommTip:SetUnitBuff(arg1,i)
			regr = regr or healcommTipTextLeft1:GetText() == L["Regrowth"]
			reju = reju or healcommTipTextLeft1:GetText() == L["Rejuvenation"]
			renew = renew or healcommTipTextLeft1:GetText() == L["Renew"]
		end
		if not regr then
			self.Hots[name]["Regr"] = nil
			self:TriggerEvent("HealComm_Hotupdate", arg1, "Regrowth")
		end
		if not reju then
			self.Hots[name]["Reju"] = nil
			self:TriggerEvent("HealComm_Hotupdate", arg1, "Rejuvenation")
		end
		if not renew then
			self.Hots[name]["Renew"] = nil
			self:TriggerEvent("HealComm_Hotupdate", arg1, "Renew")
		end			
	end
end

function HealComm:getRegrTime(unit)
	if unit == UNKNOWNOBJECT or unit == UKNOWNBEING then
		return
 	end
	local dbUnit = self.Hots[UnitName(unit)]
	if dbUnit and dbUnit["Regr"] and (dbUnit["Regr"].start + dbUnit["Regr"].dur) > GetTime() then
		return dbUnit["Regr"].start, dbUnit["Regr"].dur
	else
		return
	end
end
	
function HealComm:getRejuTime(unit)
	if unit == UNKNOWNOBJECT or unit == UKNOWNBEING then
		return
 	end
	local dbUnit = self.Hots[UnitName(unit)]
	if dbUnit and dbUnit["Reju"] and (dbUnit["Reju"].start + dbUnit["Reju"].dur) > GetTime() then
		return dbUnit["Reju"].start, dbUnit["Reju"].dur
	else
		return
	end
end

function HealComm:getRenewTime(unit)
	if unit == UNKNOWNOBJECT or unit == UKNOWNBEING then
		return
 	end
	local dbUnit = self.Hots[UnitName(unit)]
	if dbUnit and dbUnit["Renew"] and (dbUnit["Renew"].start + dbUnit["Renew"].dur) > GetTime() then
		return dbUnit["Renew"].start, dbUnit["Renew"].dur
	else
		return
	end
end

function HealComm:getHeal(unit)
	if unit == UNKNOWNOBJECT or unit == UKNOWNBEING then
		return 0
 	end
	local healamount = 0
	if self.Heals[unit] then
		for k,v in self.Heals[unit] do
			healamount = healamount+v.amount
		end
	end
	for k,v in pairs(self.GrpHeals) do
		for j,c in pairs(v.targets) do
			if unit == c then
				healamount = healamount+v.amount
			end
		end
	end
	return healamount
end

function HealComm:UnitisResurrecting(unit)
	local resstime
	if self.pendingResurrections[unit] then
		for k,v in pairs(self.pendingResurrections[unit]) do
			if v < GetTime() then
				self.pendingResurrections[unit][k] = nil
			elseif not resstime or resstime > v then
				resstime = v
			end
		end
	end
	return resstime
end

function HealComm:getNumHeals(unit)
	if unit == UNKNOWNOBJECT or unit == UKNOWNBEING then
		return 0
 	end
	local heals = 0
	if self.Heals[unit] then
		for _ in self.Heals[unit] do
			heals = heals + 1
		end
	end
	for _,v in pairs(self.GrpHeals) do
		for _,c in pairs(v.targets) do
			if unit == c then
				heals = heals + 1
			end
		end
	end
	return heals
end


function HealComm:CastSpell(spellId, spellbookTabNum)
	self.hooks.CastSpell(spellId, spellbookTabNum)
	
	if self.CurrentSpellName and not SpellIsTargeting() then return end
	
	local spellName, rank = GetSpellName(spellId, spellbookTabNum)
	if rank then _,_,rank = string.find(rank,"(%d+)") end
	
	self.CurrentSpellName = spellName
	self.CurrentSpellRank = rank
	if not SpellIsTargeting() then
		if ( UnitIsVisible("target") and UnitIsConnected("target") and UnitCanAssist("player", "target") ) then
			-- Spell is being cast on the current target.  
			if UnitIsPlayer("target") then
				self:ProcessSpellCast("target")
			end
		else
			self:ProcessSpellCast("player")
		end
	end
end

function HealComm:CastSpellByName(spellName, onSelf)
	self.hooks.CastSpellByName(spellName, onSelf)
	
	if self.CurrentSpellName and not SpellIsTargeting() then return end
	
	local _,_,rank = string.find(spellName,"(%d+)")
	local _, _, spellName = string.find(spellName, "^([^%(]+)")
	spellName = string.lower(spellName)
	local i = 1
	while GetSpellName(i, BOOKTYPE_SPELL) do
		local s, r = GetSpellName(i, BOOKTYPE_SPELL)
		if string.lower(s) == spellName then
			spellName = s
			if rank then
				break
			else
				while s == spellName do
					rank = r
					i = i+1
					s, r = GetSpellName(i, BOOKTYPE_SPELL)
				end
				break
			end
		end
		i = i+1
	end
	if rank then
		_,_,rank = string.find(rank,"(%d+)")
	end
	if spellName then
		self.CurrentSpellName = spellName
		self.CurrentSpellRank = rank
		
		if not SpellIsTargeting() then
			if UnitIsVisible("target") and UnitIsConnected("target") and UnitCanAssist("player", "target") and onSelf ~= 1 then
				if UnitIsPlayer("target") then
					self:ProcessSpellCast("target")
				end
			else
				self:ProcessSpellCast("player")
			end
		end
	end
end

function HealComm:OnMouseDown(object)
	local unit = "mouseover"
	if ( self.CurrentSpellName and GameTooltipTextLeft1:IsVisible() ) then
		local _, _, name = string.find(GameTooltipTextLeft1:GetText(), L["^Corpse of (.+)$"])
		if ( name ) then
			unit = roster:GetUnitIDFromName(name)
		end
	end
	if ( self.CurrentSpellName and SpellIsTargeting() and UnitExists(unit) ) then
		self:ProcessSpellCast(unit)
	end
	if ( self.hooks[object]["OnMouseDown"] ) then
		self.hooks[object]["OnMouseDown"]()
	end
end

function HealComm:UseAction(slot, checkCursor, onSelf)
	healcommTip:ClearLines()
	healcommTip:SetAction(slot)
	local spellName = healcommTipTextLeft1:GetText()
	
	self.hooks.UseAction(slot, checkCursor, onSelf)
	
	-- Test to see if this is a macro
	if GetActionText(slot) or (self.CurrentSpellName and not SpellIsTargeting()) then
		return
	end
	
	self.CurrentSpellName = spellName
	local rank = healcommTipTextRight1:GetText()
	if rank then
		_,_,rank = string.find(rank,"(%d+)")
	end
	self.CurrentSpellRank = rank or 1
	
	if not SpellIsTargeting() then
		if ( UnitIsVisible("target") and UnitIsConnected("target") and UnitCanAssist("player", "target") and onSelf ~= 1) then
			-- Spell is being cast on the current target
			if UnitIsPlayer("target") then
				self:ProcessSpellCast("target")
			end
		else
			-- Spell is being cast on the player
			self:ProcessSpellCast("player")
		end
	end
end

function HealComm:SpellTargetUnit(unit)
	local shallTargetUnit
	if ( SpellIsTargeting() ) then
		shallTargetUnit = true
	end
	self.hooks.SpellTargetUnit(unit)
	if ( shallTargetUnit and self.CurrentSpellName and not SpellIsTargeting() ) then
		if UnitIsPlayer(unit) then
			self:ProcessSpellCast(unit)
		end
		self.CurrentSpellName = nil
		self.CurrentSpellRank = nil
	end
end

function HealComm:SpellStopTargeting()
	self.hooks.SpellStopTargeting()
	self.CurrentSpellName = nil
	self.CurrentSpellRank = nil
end

function HealComm:TargetUnit(unit)
	-- Look to see if we're currently waiting for a target internally
	-- If we are, then well glean the target info here.
	if ( self.CurrentSpellName and UnitExists(unit) ) and UnitIsPlayer(unit) then
		self:ProcessSpellCast(unit)
	end
	self.hooks.TargetUnit(unit)
end

function HealComm:ProcessSpellCast(unit)
	local power, mod = self:GetUnitSpellPower(unit, self.CurrentSpellName)
	self.SpellCastInfo[1] = self.CurrentSpellName
	self.SpellCastInfo[2] = self.CurrentSpellRank
	self.SpellCastInfo[3] = UnitName(unit)
	self.SpellCastInfo[4] = power
	self.SpellCastInfo[5] = mod
end

AceLibrary:Register(HealComm, MAJOR_VERSION, MINOR_VERSION, activate, nil, external)
HealComm = nil