--[[

	Atlas, a World of Warcraft instance map browser
	Copyright 2005 - 2008 Dan Gilbert
	Email me at loglow@gmail.com

	This file is part of Atlas.

	Atlas is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Atlas is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Atlas; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

--]]

-- Atlas Data
-- Compiled by Dan Gilbert
-- loglow@gmail.com
-- Many thanks to all contributors!
-- Now with GUIDs!
-- Now externally localized!

local BLUE = "|cff6666ff";
local GREY = "|cff999999";
local GREN = "|cff66cc33";
local _RED = "|cffcc6666";
local ORNG = "|cffcc9933";
local PURP = "|cff9900ff";
local WHIT = "|cffffffff";
local INDENT = "      ";

local ZONE = 1;
local NPC = 2;
local ITEM = 3;
local OBJECT = 4;
local FACTION = 5;
local QUEST = 6;

AtlasMaps = {

--************************************************
-- Kalimdor Instances
--************************************************

	RagefireChasm = {
		ZoneName = { AtlasLocale["Ragefire Chasm"], 2437 };
		Acronym = AtlasLocale["RFC"];
		Location = { AtlasLocale["Orgrimmar"], 1637 };
		LevelRange = "12-18";
		MinLevel = "8";
		PlayerLimit = "5";
		Continent = AtlasLocale["Kalimdor"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Maur Grimtotem"], NPC, 11834 };
		{ GREY..INDENT..AtlasLocale["Oggleflint <Ragefire Chieftain>"], NPC, 11517 };
		{ GREY.."2) "..AtlasLocale["Taragaman the Hungerer"], NPC, 11520 };
		{ GREY.."3) "..AtlasLocale["Jergosh the Invoker"], NPC, 11518 };
		{ GREY.."4) "..AtlasLocale["Bazzalan"], NPC, 11519 };
	};
	WailingCaverns = {
		ZoneName = { AtlasLocale["Wailing Caverns"], 718 };
		Acronym = AtlasLocale["WC"];
		Location = { AtlasLocale["The Barrens"], 17 };
		LevelRange = "16-25";
		MinLevel = "10";
		PlayerLimit = "5";
		Continent = AtlasLocale["Kalimdor"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Disciple of Naralex"], NPC, 3678 };
		{ GREY..INDENT..AtlasLocale["Mysterious Wailing Caverns Chest"], OBJECT, 180055 };
		{ GREY.."2) "..AtlasLocale["Lord Cobrahn <Fanglord>"], NPC, 3669 };
		{ GREY.."3) "..AtlasLocale["Lady Anacondra <Fanglord>"], NPC, 3671 };
		{ GREY.."4) "..AtlasLocale["Kresh"], NPC, 3653 };
		{ GREY.."5) "..AtlasLocale["Lord Pythas <Fanglord>"], NPC, 3670 };
		{ GREY.."6) "..AtlasLocale["Skum"], NPC, 3674 };
		{ GREY.."7) "..AtlasLocale["Lord Serpentis <Fanglord>"].." ("..AtlasLocale["Upper"]..")", NPC, 3673 };
		{ GREY.."8) "..AtlasLocale["Verdan the Everliving"].." ("..AtlasLocale["Upper"]..")", NPC, 5775 };
		{ GREY.."9) "..AtlasLocale["Mutanus the Devourer"], NPC, 3654 };
		{ GREY..INDENT..AtlasLocale["Naralex"], NPC, 3679 };
		{ GREY.."10) "..AtlasLocale["Deviate Faerie Dragon"].." ("..AtlasLocale["Rare"]..")", NPC, 5912 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["Embrace of the Viper"] };
	};
	BlackfathomDeeps = {
		ZoneName = { AtlasLocale["Blackfathom Deeps"], 719 };
		Acronym = AtlasLocale["BFD"];
		Location = { AtlasLocale["Ashenvale"], 331 };
		LevelRange = "20-28";
		MinLevel = "19";
		PlayerLimit = "5";
		Continent = AtlasLocale["Kalimdor"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Ghamoo-ra"], NPC, 4887 };
		{ GREY.."2) "..AtlasLocale["Lorgalis Manuscript"], ITEM, 5359 };
		{ GREY.."3) "..AtlasLocale["Lady Sarevess"], NPC, 4831 };
		{ GREY.."4) "..AtlasLocale["Argent Guard Thaelrid <The Argent Dawn>"], NPC, 4787 };
		{ GREY.."5) "..AtlasLocale["Gelihast"], NPC, 6243 };
		{ GREY..INDENT..AtlasLocale["Shrine of Gelihast"] };
		{ GREY.."6) "..AtlasLocale["Lorgus Jett"].." ("..AtlasLocale["Varies"]..")", NPC, 12902 };
		{ GREY.."7) "..AtlasLocale["Fathom Stone"], OBJECT, 177964 };
		{ GREY..INDENT..AtlasLocale["Baron Aquanis"], NPC, 12876 };
		{ GREY.."8) "..AtlasLocale["Twilight Lord Kelris"], NPC, 4832 };
		{ GREY.."9) "..AtlasLocale["Old Serra'kis"], NPC, 4830 };
		{ GREY.."10) "..AtlasLocale["Aku'mai"], NPC, 4829 };
		{ GREY..INDENT..AtlasLocale["Morridune"], NPC, 6729 };
		{ GREY..INDENT..AtlasLocale["Altar of the Deeps"] };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
	};
	RazorfenKraul = {
		ZoneName = { AtlasLocale["Razorfen Kraul"], 491 };
		Acronym = AtlasLocale["RFK"];
		Location = { AtlasLocale["The Barrens"], 17 };
		LevelRange = "23-33";
		MinLevel = "19";
		PlayerLimit = "5";
		Continent = AtlasLocale["Kalimdor"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Roogug"], NPC, 6168 };
		{ GREY.."2) "..AtlasLocale["Aggem Thorncurse <Death's Head Prophet>"], NPC, 4424 };
		{ GREY.."3) "..AtlasLocale["Death Speaker Jargba <Death's Head Captain>"], NPC, 4428 };
		{ GREY.."4) "..AtlasLocale["Overlord Ramtusk"], NPC, 4420 };
		{ GREY..INDENT..AtlasLocale["Razorfen Spearhide"].." ("..AtlasLocale["Rare"]..")", NPC, 4438 };
		{ GREY.."5) "..AtlasLocale["Agathelos the Raging"], NPC, 4422 };
		{ GREY.."6) "..AtlasLocale["Blind Hunter"].." ("..AtlasLocale["Rare"]..")", NPC, 4425 };
		{ GREY.."7) "..AtlasLocale["Charlga Razorflank <The Crone>"], NPC, 4421 };
		{ GREY.."8) "..AtlasLocale["Willix the Importer"], NPC, 4508 };
		{ GREY..INDENT..AtlasLocale["Heralath Fallowbrook"], NPC, 4510 };
		{ GREY.."9) "..AtlasLocale["Earthcaller Halmgar"].." ("..AtlasLocale["Rare"]..")", NPC, 4842 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
	};
	RazorfenDowns = {
		ZoneName = { AtlasLocale["Razorfen Downs"], 722 };
		Acronym = AtlasLocale["RFD"];
		Location = { AtlasLocale["The Barrens"], 17 };
		LevelRange = "33-42";
		MinLevel = "30";
		PlayerLimit = "5";
		Continent = AtlasLocale["Kalimdor"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Tuten'kash"], NPC, 7355 };
		{ GREY.."2) "..AtlasLocale["Henry Stern"], NPC, 8696 };
		{ GREY..INDENT..AtlasLocale["Belnistrasz"], NPC, 8516 };
		{ GREY..INDENT..AtlasLocale["Sah'rhee"], NPC, 8767 };
		{ GREY..INDENT..AtlasLocale["Lady Falther'ess"].." ("..AtlasLocale["Scourge Invasion"]..")", NPC, 14686 };
		{ GREY.."3) "..AtlasLocale["Mordresh Fire Eye"], NPC, 7357 };
		{ GREY.."4) "..AtlasLocale["Glutton"], NPC, 8567 };
		{ GREY.."5) "..AtlasLocale["Ragglesnout"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Varies"]..")", NPC, 7354 };
		{ GREY.."6) "..AtlasLocale["Amnennar the Coldbringer"], NPC, 7358 };
		{ GREY.."7) "..AtlasLocale["Plaguemaw the Rotting"], NPC, 7356 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
	};
	ZulFarrak = {
		ZoneName = { AtlasLocale["Zul'Farrak"], 978 };
		Acronym = AtlasLocale["ZF"];
		Location = { AtlasLocale["Tanaris"], 440 };
		LevelRange = "42-48";
		MinLevel = "35";
		PlayerLimit = "5";
		Continent = AtlasLocale["Kalimdor"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Mallet of Zul'Farrak"].." ("..AtlasLocale["Gahz'rilla"]..")", ITEM, 9240 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Antu'sul <Overseer of Sul>"], NPC, 8127 };
		{ GREY.."2) "..AtlasLocale["Theka the Martyr"], NPC, 7272 };
		{ GREY.."3) "..AtlasLocale["Witch Doctor Zum'rah"], NPC, 7271 };
		{ GREY..INDENT..AtlasLocale["Zul'Farrak Dead Hero"], NPC, 7276 };
		{ GREY.."4) "..AtlasLocale["Nekrum Gutchewer"], NPC, 7796 };
		{ GREY..INDENT..AtlasLocale["Shadowpriest Sezz'ziz"], NPC, 7275 };
		{ GREY..INDENT..AtlasLocale["Dustwraith"].." ("..AtlasLocale["Rare"]..")", NPC, 10081 };
		{ GREY.."5) "..AtlasLocale["Sergeant Bly"], NPC, 7604 };
		{ GREY..INDENT..AtlasLocale["Weegli Blastfuse"], NPC, 7607 };
		{ GREY..INDENT..AtlasLocale["Murta Grimgut"], NPC, 7608 };
		{ GREY..INDENT..AtlasLocale["Raven"], NPC, 7605 };
		{ GREY..INDENT..AtlasLocale["Oro Eyegouge"], NPC, 7606 };
		{ GREY..INDENT..AtlasLocale["Sandfury Executioner"], NPC, 7274 };
		{ GREY.."6) "..AtlasLocale["Hydromancer Velratha"], NPC, 7795 };
		{ GREY..INDENT..AtlasLocale["Gahz'rilla"].." ("..AtlasLocale["Summon"]..")", NPC, 7273 };
		{ GREY..INDENT..AtlasLocale["Elder Wildmane"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 15578 };
		{ GREY.."7) "..AtlasLocale["Chief Ukorz Sandscalp"], NPC, 7267 };
		{ GREY..INDENT..AtlasLocale["Ruuzlu"], NPC, 7797 };
		{ GREY.."8) "..AtlasLocale["Zerillis"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Wanders"]..")", NPC, 10082 };
		{ GREY.."9) "..AtlasLocale["Sandarr Dunereaver"].." ("..AtlasLocale["Rare"]..")", NPC, 10080 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
	};
	Maraudon = {
		ZoneName = { AtlasLocale["Maraudon"], 2100 };
		Acronym = AtlasLocale["Mara"];
		Location = { AtlasLocale["Desolace"], 405 };
		LevelRange = "42-51";
		MinLevel = "30";
		PlayerLimit = "5";
		Continent = AtlasLocale["Kalimdor"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Scepter of Celebras"].." ("..AtlasLocale["Portal"]..")", ITEM, 17191 };
		{ BLUE.."A) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Orange"]..")" };
		{ BLUE.."B) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Purple"]..")" };
		{ BLUE.."C) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Portal"]..")" };
		{ GREY.."1) "..AtlasLocale["Veng <The Fifth Khan>"], NPC, 13738 };
		{ GREY.."2) "..AtlasLocale["Noxxion"], NPC, 13282 };
		{ GREY.."3) "..AtlasLocale["Razorlash"], NPC, 12258 };
		{ GREY.."4) "..AtlasLocale["Maraudos <The Fourth Khan>"], NPC, 13739 };
		{ GREY.."5) "..AtlasLocale["Lord Vyletongue"], NPC, 12236 };
		{ GREY.."6) "..AtlasLocale["Meshlok the Harvester"].." ("..AtlasLocale["Rare"]..")", NPC, 12237 };
		{ GREY.."7) "..AtlasLocale["Celebras the Cursed"], NPC, 12225 };
		{ GREY.."8) "..AtlasLocale["Landslide"], NPC, 12203 };
		{ GREY.."9) "..AtlasLocale["Tinkerer Gizlock"], NPC, 13601 };
		{ GREY.."10) "..AtlasLocale["Rotgrip"], NPC, 13596 };
		{ GREY.."11) "..AtlasLocale["Princess Theradras"], NPC, 12201 };
		{ GREY.."12) "..AtlasLocale["Elder Splitrock"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 15556 };
	};
	DireMaulEast = {
		ZoneName = { AtlasLocale["Dire Maul"].." ("..AtlasLocale["East"]..")", 2557 };
		Acronym = AtlasLocale["DME"];
		Location = { AtlasLocale["Feralas"], 357 };
		LevelRange = "55-58";
		MinLevel = "50";
		PlayerLimit = "5";
		Continent = AtlasLocale["Kalimdor"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Brazier of Invocation"].." ("..AtlasLocale["D2 Summon"]..")", ITEM, 22057 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Entrance"] };
		{ BLUE.."C) "..AtlasLocale["Entrance"] };
		{ BLUE.."D) "..AtlasLocale["Exit"] };
		{ GREY.."1) "..AtlasLocale["Pusillin"].." ("..AtlasLocale["Chase Begins"]..")", NPC, 14354 };
		{ GREY.."2) "..AtlasLocale["Pusillin"].." ("..AtlasLocale["Chase Ends"]..")", NPC, 14354 };
		{ GREY.."3) "..AtlasLocale["Zevrim Thornhoof"], NPC, 11490 };
		{ GREY..INDENT..AtlasLocale["Hydrospawn"], NPC, 13280 };
		{ GREY..INDENT..AtlasLocale["Lethtendris"], NPC, 14327 };
		{ GREY..INDENT..AtlasLocale["Pimgib"], NPC, 14349 };
		{ GREY.."4) "..AtlasLocale["Old Ironbark"], NPC, 11491 };
		{ GREY.."5) "..AtlasLocale["Alzzin the Wildshaper"], NPC, 11492 };
		{ GREY..INDENT..AtlasLocale["Isalien"].." ("..AtlasLocale["Summon"]..")", NPC, 16097 };
		{ GREY..INDENT..AtlasLocale["Felvine Shard"], OBJECT, 179559 };
		{ GREN.."1') "..AtlasLocale["A Dusty Tome"].." ("..AtlasLocale["Varies"]..")", OBJECT, 179547 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
		{ GREY..INDENT..AtlasLocale["Dire Maul Books"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["Ironweave Battlesuit"] };
	};
	DireMaulNorth = {
		ZoneName = { AtlasLocale["Dire Maul"].." ("..AtlasLocale["North"]..")", 2557 };
		Acronym = AtlasLocale["DMN"];
		Location = { AtlasLocale["Feralas"], 357 };
		LevelRange = "57-60";
		MinLevel = "50";
		PlayerLimit = "5";
		Continent = AtlasLocale["Kalimdor"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Crescent Key"], ITEM, 18249 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Gordok Courtyard Key"], ITEM, 18266 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Gordok Inner Door Key"], ITEM, 18268 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Library"] };
		{ BLUE.."C) "..AtlasLocale["Dire Maul"].." ("..AtlasLocale["West"]..")", ZONE, 2557 };
		{ GREY.."1) "..AtlasLocale["Guard Mol'dar"], NPC, 14326 };
		{ GREY.."2) "..AtlasLocale["Stomper Kreeg <The Drunk>"], NPC, 14322 };
		{ GREY.."3) "..AtlasLocale["Guard Fengus"], NPC, 14321 };
		{ GREY.."4) "..AtlasLocale["Knot Thimblejack"], NPC, 14338 };
		{ GREY..INDENT..AtlasLocale["Guard Slip'kik"], NPC, 14323 };
		{ GREY.."5) "..AtlasLocale["Captain Kromcrush"], NPC, 14325 };
		{ GREY.."6) "..AtlasLocale["King Gordok"], NPC, 11501 };
		{ GREY..INDENT..AtlasLocale["Cho'Rush the Observer"], NPC, 14324 };
		{ GREY..INDENT..AtlasLocale["Tribute Run"], OBJECT, 190005 };
		{ GREN.."1') "..AtlasLocale["Library"] };
		{ GREN..INDENT..AtlasLocale["Falrin Treeshaper"], NPC, 16032 };
		{ GREN..INDENT..AtlasLocale["Lorekeeper Lydros"], NPC, 14368 };
		{ GREN..INDENT..AtlasLocale["Lorekeeper Javon"], NPC, 14381 };
		{ GREN..INDENT..AtlasLocale["Lorekeeper Kildrath"], NPC, 14383 };
		{ GREN..INDENT..AtlasLocale["Lorekeeper Mykos"], NPC, 14382 };
		{ GREN..INDENT..AtlasLocale["Shen'dralar Provisioner"], NPC, 14371 };
		{ GREN..INDENT..AtlasLocale["Skeletal Remains of Kariel Winthalus"], OBJECT, 179544 };
		{ GREN.."2') "..AtlasLocale["A Dusty Tome"].." ("..AtlasLocale["Varies"]..")", OBJECT, 179547 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
		{ GREY..INDENT..AtlasLocale["Dire Maul Books"] };
	};
	DireMaulWest = {
		ZoneName = { AtlasLocale["Dire Maul"].." ("..AtlasLocale["West"]..")", 2557 };
		Acronym = AtlasLocale["DMW"];
		Location = { AtlasLocale["Feralas"], 357 };
		LevelRange = "57-60";
		MinLevel = "50";
		PlayerLimit = "5";
		Continent = AtlasLocale["Kalimdor"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Crescent Key"], ITEM, 18249 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["J'eevee's Jar"].." ("..AtlasLocale["Lord Hel'nurath"]..")", ITEM, 18663 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Pylons"] };
		{ BLUE.."C) "..AtlasLocale["Dire Maul"].." ("..AtlasLocale["North"]..")", ZONE, 2557 };
		{ GREY.."1) "..AtlasLocale["Shen'dralar Ancient"], NPC, 14358 };
		{ GREY.."2) "..AtlasLocale["Tendris Warpwood"], NPC, 11489 };
		{ GREY..INDENT..AtlasLocale["Ancient Equine Spirit"], NPC, 14566 };
		{ GREY.."3) "..AtlasLocale["Illyanna Ravenoak"], NPC, 11488 };
		{ GREY..INDENT..AtlasLocale["Ferra"], NPC, 14308 };
		{ GREY.."4) "..AtlasLocale["Magister Kalendris"], NPC, 11487 };
		{ GREY.."5) "..AtlasLocale["Tsu'zee"].." ("..AtlasLocale["Rare"]..")", NPC, 11467 };
		{ GREY.."6) "..AtlasLocale["Immol'thar"], NPC, 11496 };
		{ GREY..INDENT..AtlasLocale["Lord Hel'nurath"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Summon"]..")", NPC, 14506 };
		{ GREY.."7) "..AtlasLocale["Prince Tortheldrin"], NPC, 11486 };
		{ GREY..INDENT..AtlasLocale["The Prince's Chest"], OBJECT, 179545 };
		{ GREY.."8) "..AtlasLocale["Revanchion"].." ("..AtlasLocale["Scourge Invasion"]..")", NPC, 11467 };
		{ GREN.."1') "..AtlasLocale["Library"] };
		{ GREN..INDENT..AtlasLocale["Falrin Treeshaper"], NPC, 16032 };
		{ GREN..INDENT..AtlasLocale["Lorekeeper Lydros"], NPC, 14368 };
		{ GREN..INDENT..AtlasLocale["Lorekeeper Javon"], NPC, 14381 };
		{ GREN..INDENT..AtlasLocale["Lorekeeper Kildrath"], NPC, 14383 };
		{ GREN..INDENT..AtlasLocale["Lorekeeper Mykos"], NPC, 14382 };
		{ GREN..INDENT..AtlasLocale["Shen'dralar Provisioner"], NPC, 14371 };
		{ GREN..INDENT..AtlasLocale["Skeletal Remains of Kariel Winthalus"], OBJECT, 179544 };
		{ GREN.."2') "..AtlasLocale["A Dusty Tome"].." ("..AtlasLocale["Varies"]..")", OBJECT, 179547 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
		{ GREY..INDENT..AtlasLocale["Dire Maul Books"] };
	};
	OnyxiasLair = {
		ZoneName = { AtlasLocale["Onyxia's Lair"], 2159 };
		Acronym = AtlasLocale["Ony"];
		Location = { AtlasLocale["Dustwallow Marsh"], 15 };
		LevelRange = "60+";
		MinLevel = "60";
		PlayerLimit = "40";
		Continent = AtlasLocale["Kalimdor"];
		{ ORNG..AtlasLocale["Attunement Required"] };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Drakefire Amulet"], ITEM, 16309 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Onyxian Warders"], NPC, 12129 };
		{ GREY.."2) "..AtlasLocale["Whelp Eggs"] };
		{ GREY.."3) "..AtlasLocale["Onyxia"], NPC, 10184 };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ ORNG..AtlasLocale["Damage: "]..AtlasLocale["Fire"] };
	};
	TheTempleofAhnQiraj = {
		ZoneName = { AtlasLocale["Temple of Ahn'Qiraj"], 3428 };
		Acronym = AtlasLocale["AQ40"];
		Location = { AtlasLocale["Silithus"], 1377 };
		LevelRange = "60+";
		MinLevel = "60";
		PlayerLimit = "40";
		Continent = AtlasLocale["Kalimdor"];
		{ ORNG..AtlasLocale["Rep"]..": "..AtlasLocale["Brood of Nozdormu"], FACTION, 910 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["The Prophet Skeram"].." ("..AtlasLocale["Outside"]..")", NPC, 15263 };
		{ GREY.."2) "..AtlasLocale["Bug Trio"].." ("..AtlasLocale["Optional"]..")" };
		{ GREY..INDENT..AtlasLocale["Vem"], NPC, 15544 };
		{ GREY..INDENT..AtlasLocale["Lord Kri"], NPC, 15511 };
		{ GREY..INDENT..AtlasLocale["Princess Yauj"], NPC, 15543 };
		{ GREY.."3) "..AtlasLocale["Battleguard Sartura"], NPC, 15516 };
		{ GREY.."4) "..AtlasLocale["Fankriss the Unyielding"], NPC, 15510 };
		{ GREY.."5) "..AtlasLocale["Viscidus"].." ("..AtlasLocale["Optional"]..")", NPC, 15299 };
		{ GREY.."6) "..AtlasLocale["Princess Huhuran"], NPC, 15509 };
		{ GREY.."7) "..AtlasLocale["Twin Emperors"] };
		{ GREY..INDENT..AtlasLocale["Emperor Vek'lor"], NPC, 15276 };
		{ GREY..INDENT..AtlasLocale["Emperor Vek'nilash"], NPC, 15275 };
		{ GREY.."8) "..AtlasLocale["Ouro"].." ("..AtlasLocale["Optional"]..")", NPC, 15517 };
		{ GREY.."9) "..AtlasLocale["C'Thun"], NPC, 15589 };
		{ GREN.."1') "..AtlasLocale["Andorgos <Brood of Malygos>"], NPC, 15502 };
		{ GREN..INDENT..AtlasLocale["Vethsera <Brood of Ysera>"], NPC, 15504 };
		{ GREN..INDENT..AtlasLocale["Kandrostrasz <Brood of Alexstrasza>"], NPC, 15503 };
		{ GREN.."2') "..AtlasLocale["Arygos"], NPC, 15380 };
		{ GREN..INDENT..AtlasLocale["Caelestrasz"], NPC, 15379 };
		{ GREN..INDENT..AtlasLocale["Merithra of the Dream"], NPC, 15378 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
		{ GREY..INDENT..AtlasLocale["AQ Enchants"] };
		{ GREY..INDENT..AtlasLocale["AQ40 Sets"] };
		{ GREY..INDENT..AtlasLocale["AQ Opening Quest Chain"] };
		{ "" };
		{ ORNG..AtlasLocale["Damage: "]..AtlasLocale["Nature"] };
	};
	TheRuinsofAhnQiraj = {
		ZoneName = { AtlasLocale["Ruins of Ahn'Qiraj"], 3429 };
		Acronym = AtlasLocale["AQ20"];
		Location = { AtlasLocale["Silithus"], 1377 };
		LevelRange = "60+";
		MinLevel = "60";
		PlayerLimit = "20";
		Continent = AtlasLocale["Kalimdor"];
		{ ORNG..AtlasLocale["Rep"]..": "..AtlasLocale["Cenarion Circle"], FACTION, 609 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Kurinnaxx"], NPC, 15348 };
		{ GREY..INDENT..AtlasLocale["Lieutenant General Andorov"], NPC, 15471 };
		{ GREY..INDENT..AtlasLocale["Four Kaldorei Elites"], NPC, 15473 };
		{ GREY.."2) "..AtlasLocale["General Rajaxx"], NPC, 15341 };
		{ GREY..INDENT..AtlasLocale["Captain Qeez"], NPC, 15391 };
		{ GREY..INDENT..AtlasLocale["Captain Tuubid"], NPC, 15392 };
		{ GREY..INDENT..AtlasLocale["Captain Drenn"], NPC, 15389 };
		{ GREY..INDENT..AtlasLocale["Captain Xurrem"], NPC, 15390 };
		{ GREY..INDENT..AtlasLocale["Major Yeggeth"], NPC, 15386 };
		{ GREY..INDENT..AtlasLocale["Major Pakkon"], NPC, 15388 };
		{ GREY..INDENT..AtlasLocale["Colonel Zerran"], NPC, 15385 };
		{ GREY.."3) "..AtlasLocale["Moam"].." ("..AtlasLocale["Optional"]..")", NPC, 15340 };
		{ GREY.."4) "..AtlasLocale["Buru the Gorger"].." ("..AtlasLocale["Optional"]..")", NPC, 15370 };
		{ GREY.."5) "..AtlasLocale["Ayamiss the Hunter"].." ("..AtlasLocale["Optional"]..")", NPC, 15369 };
		{ GREY.."6) "..AtlasLocale["Ossirian the Unscarred"], NPC, 15339 };
		{ GREN.."1') "..AtlasLocale["Safe Room"] };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
		{ GREY..INDENT..AtlasLocale["Class Books"] };
		{ GREY..INDENT..AtlasLocale["AQ Enchants"] };
		{ GREY..INDENT..AtlasLocale["AQ20 Sets"] };
		{ "" };
		{ ORNG..AtlasLocale["Damage: "]..AtlasLocale["Nature"] };
	};

--************************************************
-- Eastern Kingdoms Instances
--************************************************
	
	BlackrockDepths = {
		ZoneName = { AtlasLocale["Blackrock Depths"], 1584 };
		Acronym = AtlasLocale["BRD"];
		Location = { AtlasLocale["Blackrock Mountain"], 25 };
		LevelRange = "52-58";
		MinLevel = "40";
		PlayerLimit = "5";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Shadowforge Key"], ITEM, 11000 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Prison Cell Key"], ITEM, 11140 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Banner of Provocation"].." ("..AtlasLocale["D2 Summon"]..")", ITEM, 21986 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Lord Roccor"], NPC, 9025 };
		{ GREY.."2) "..AtlasLocale["Kharan Mighthammer"], NPC, 9021 };
		{ GREY.."3) "..AtlasLocale["Commander Gor'shak <Kargath Expeditionary Force>"], NPC, 9020 };
		{ GREY.."4) "..AtlasLocale["Marshal Windsor"], NPC, 9023 };
		{ GREY.."5) "..AtlasLocale["High Interrogator Gerstahn <Twilight's Hammer Interrogator>"], NPC, 9018 };
		{ GREY.."6) "..AtlasLocale["Ring of Law"] };
		{ GREY..INDENT..AtlasLocale["Anub'shiah"].." ("..AtlasLocale["Random"]..")", NPC, 9031 };
		{ GREY..INDENT..AtlasLocale["Eviscerator"].." ("..AtlasLocale["Random"]..")", NPC, 9029 };
		{ GREY..INDENT..AtlasLocale["Gorosh the Dervish"].." ("..AtlasLocale["Random"]..")", NPC, 9027 };
		{ GREY..INDENT..AtlasLocale["Grizzle"].." ("..AtlasLocale["Random"]..")", NPC, 9028 };
		{ GREY..INDENT..AtlasLocale["Hedrum the Creeper"].." ("..AtlasLocale["Random"]..")", NPC, 9032 };
		{ GREY..INDENT..AtlasLocale["Ok'thor the Breaker"].." ("..AtlasLocale["Random"]..")", NPC, 9030 };
		{ GREY..INDENT..AtlasLocale["Theldren"].." ("..AtlasLocale["Summon"]..")", NPC, 16059 };
		{ GREY..INDENT..AtlasLocale["Lefty"].." ("..AtlasLocale["BRDRogue"]..GREY..")", NPC, 16049 };
		{ GREY..INDENT..AtlasLocale["Malgen Longspear"].." ("..AtlasLocale["BRDHunter"]..GREY..")", NPC, 16052 };
		{ GREY..INDENT..AtlasLocale["Gnashjaw <Malgen Longspear's Pet>"].." ("..AtlasLocale["BRDPet"]..GREY..")", NPC, 16095 };
		{ GREY..INDENT..AtlasLocale["Korv"].." ("..AtlasLocale["BRDShaman"]..GREY..")", NPC, 16050 };
		{ GREY..INDENT..AtlasLocale["Rezznik"].." ("..AtlasLocale["BRDEngineer"]..GREY..")", NPC, 16050 };
		{ GREY..INDENT..AtlasLocale["Rotfang"].." ("..AtlasLocale["BRDRogue"]..GREY..")", NPC, 16050 };
		{ GREY..INDENT..AtlasLocale["Snokh Blackspine"].." ("..AtlasLocale["BRDMage"]..GREY..")", NPC, 16050 };
		{ GREY..INDENT..AtlasLocale["Va'jashni"].." ("..AtlasLocale["BRDPriest"]..GREY..")", NPC, 16055 };
		{ GREY..INDENT..AtlasLocale["Volida"].." ("..AtlasLocale["BRDMage"]..GREY..")", NPC, 16055 };
		{ GREY..INDENT..AtlasLocale["Houndmaster Grebmar"].." ("..AtlasLocale["Lower"]..")", NPC, 9319 };
		{ GREY..INDENT..AtlasLocale["Elder Morndeep"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 15549 };
		{ GREY..INDENT..AtlasLocale["High Justice Grimstone"], NPC, 10096 };
		{ GREY.."7) "..AtlasLocale["Monument of Franclorn Forgewright"], OBJECT, 164689 };
		{ GREY..INDENT..AtlasLocale["Pyromancer Loregrain"].." ("..AtlasLocale["Rare"]..")", NPC, 9024 };
		{ GREY.."8) "..AtlasLocale["The Vault"] };
		{ GREY..INDENT..AtlasLocale["Warder Stilgiss"].." ("..AtlasLocale["Rare"]..")", NPC, 9041 };
		{ GREY..INDENT..AtlasLocale["Verek"].." ("..AtlasLocale["Rare"]..")", NPC, 9042 };
		{ GREY..INDENT..AtlasLocale["Watchman Doomgrip"], NPC, 9476 };
		{ GREY.."9) "..AtlasLocale["Fineous Darkvire <Chief Architect>"], NPC, 9056 };
		{ GREY.."10) "..AtlasLocale["Lord Incendius"], NPC, 9017 };
		{ GREY..INDENT..AtlasLocale["The Black Anvil"] };
		{ GREY.."11) "..AtlasLocale["Bael'Gar"], NPC, 9016 };
		{ GREY.."12) "..AtlasLocale["Shadowforge Lock"] };
		{ GREY.."13) "..AtlasLocale["General Angerforge"], NPC, 9033 };
		{ GREY.."14) "..AtlasLocale["Golem Lord Argelmach"], NPC, 8983 };
		{ GREY..INDENT..AtlasLocale["Field Repair Bot 74A"], NPC, 14337 };
		{ GREY..INDENT..AtlasLocale["Blacksmithing Plans"], OBJECT, 173232 };
		{ GREY.."15) "..AtlasLocale["The Grim Guzzler"] };
		{ GREY..INDENT..AtlasLocale["Hurley Blackbreath"], NPC, 9537 };
		{ GREY..INDENT..AtlasLocale["Lokhtos Darkbargainer <The Thorium Brotherhood>"], NPC, 12944 };
		{ GREY..INDENT..AtlasLocale["Mistress Nagmara"], NPC, 9500 };
		{ GREY..INDENT..AtlasLocale["Phalanx"], NPC, 9502 };
		{ GREY..INDENT..AtlasLocale["Plugger Spazzring"], NPC, 9499 };
		{ GREY..INDENT..AtlasLocale["Private Rocknot"], NPC, 9503 };
		{ GREY..INDENT..AtlasLocale["Ribbly Screwspigot"], NPC, 9543 };
		{ GREY.."16) "..AtlasLocale["Ambassador Flamelash"], NPC, 9156 };
		{ GREY.."17) "..AtlasLocale["Panzor the Invincible"].." ("..AtlasLocale["Rare"]..")", NPC, 8923 };
		{ GREY..INDENT..AtlasLocale["Blacksmithing Plans"], OBJECT, 173232 };
		{ GREY.."18) "..AtlasLocale["Summoner's Tomb"] };
		{ GREY..INDENT..AtlasLocale["Chest of The Seven"], OBJECT, 169243 };
		{ GREY.."19) "..AtlasLocale["The Lyceum"] };
		{ GREY.."20) "..AtlasLocale["Magmus"], NPC, 9938 };
		{ GREY.."21) "..AtlasLocale["Emperor Dagran Thaurissan"], NPC, 9019 };
		{ GREY..INDENT..AtlasLocale["Princess Moira Bronzebeard <Princess of Ironforge>"], NPC, 8929 };
		{ GREY..INDENT..AtlasLocale["High Priestess of Thaurissan"], NPC, 10076 };
		{ GREY.."22) "..AtlasLocale["The Black Forge"] };
		{ GREY.."23) "..AtlasLocale["Molten Core"], ZONE, 2717 };
		{ GREY..INDENT..AtlasLocale["Core Fragment"], OBJECT, 179553 };
		{ GREY.."24) "..AtlasLocale["Overmaster Pyron"], NPC, 9026 };
		{ GREY.."25) "..AtlasLocale["Blacksmithing Plans"], OBJECT, 173232 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["The Gladiator"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["Ironweave Battlesuit"] };
	};
	BlackrockSpireLower = {
		ZoneName = { AtlasLocale["Blackrock Spire"]..""..AtlasLocale["Lower"], 1583 };
		Acronym = AtlasLocale["LBRS"];
		Location = { AtlasLocale["Blackrock Mountain"], 25 };
		LevelRange = "55-60";
		MinLevel = "55";
		PlayerLimit = "10";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Brazier of Invocation"].." ("..AtlasLocale["D2 Summon"]..")", ITEM, 22057 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Upper Blackrock Spire"].." ("..AtlasLocale["UBRS"]..")", ZONE, 1583 };
		{ BLUE.."C-F) "..AtlasLocale["Connections"] };
		{ GREY.."1) "..AtlasLocale["Vaelan"].." ("..AtlasLocale["Upper"]..")", NPC, 10296 };
		{ GREY.."2) "..AtlasLocale["Warosh <The Cursed>"].." ("..AtlasLocale["Wanders"]..")", NPC, 10799 };
		{ GREY..INDENT..AtlasLocale["Elder Stonefort"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 15560 };
		{ GREY.."3) "..AtlasLocale["Roughshod Pike"], OBJECT, 175886 };
		{ GREY.."4) "..AtlasLocale["Spirestone Butcher"].." ("..AtlasLocale["Rare"]..")", NPC, 9219 };
		{ GREY.."5) "..AtlasLocale["Highlord Omokk"], NPC, 9196 };
		{ GREY.."6) "..AtlasLocale["Spirestone Battle Lord"].." ("..AtlasLocale["Rare"]..")", NPC, 9218 };
		{ GREY..INDENT..AtlasLocale["Spirestone Lord Magus"].." ("..AtlasLocale["Rare"]..")", NPC, 9217 };
		{ GREY.."7) "..AtlasLocale["Shadow Hunter Vosh'gajin"], NPC, 9236 };
		{ GREY..INDENT..AtlasLocale["Fifth Mosh'aru Tablet"], OBJECT, 175949 };
		{ GREY.."8) "..AtlasLocale["Bijou"], NPC, 10257 };
		{ GREY.."9) "..AtlasLocale["War Master Voone"], NPC, 9237 };
		{ GREY..INDENT..AtlasLocale["Mor Grayhoof"].." ("..AtlasLocale["Summon"]..")", NPC, 16080 };
		{ GREY..INDENT..AtlasLocale["Sixth Mosh'aru Tablet"], OBJECT, 175950 };
		{ GREY.."10) "..AtlasLocale["Bijou's Belongings"], OBJECT, 175334 };
		{ GREY.."11) "..AtlasLocale["Human Remains"].." ("..AtlasLocale["Lower"]..")", OBJECT, 176090 };
		{ GREY..INDENT..AtlasLocale["Unfired Plate Gauntlets"].." ("..AtlasLocale["Lower"]..")", OBJECT, 176089 };
		{ GREY.."12) "..AtlasLocale["Bannok Grimaxe <Firebrand Legion Champion>"].." ("..AtlasLocale["Rare"]..")", NPC, 9596 };
		{ GREY.."13) "..AtlasLocale["Mother Smolderweb"], NPC, 10596 };
		{ GREY.."14) "..AtlasLocale["Crystal Fang"].." ("..AtlasLocale["Rare"]..")", NPC, 10376 };
		{ GREY.."15) "..AtlasLocale["Urok's Tribute Pile"], OBJECT, 175621 };
		{ GREY..INDENT..AtlasLocale["Urok Doomhowl"].." ("..AtlasLocale["Summon"]..")", NPC, 10584 };
		{ GREY.."16) "..AtlasLocale["Quartermaster Zigris <Bloodaxe Legion>"], NPC, 9736 };
		{ GREY.."17) "..AtlasLocale["Halycon"], NPC, 10220 };
		{ GREY..INDENT..AtlasLocale["Gizrul the Slavener"], NPC, 10268 };
		{ GREY.."18) "..AtlasLocale["Ghok Bashguud <Bloodaxe Champion>"].." ("..AtlasLocale["Rare"]..")", NPC, 9718 };
		{ GREY.."19) "..AtlasLocale["Overlord Wyrmthalak"], NPC, 9568 };
		{ GREN.."1') "..AtlasLocale["Burning Felguard"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Summon"]..")", NPC, 10263 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["Ironweave Battlesuit"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["Spider's Kiss"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["D1/D2 Sets"] };
	};
	BlackrockSpireUpper = {
		ZoneName = { AtlasLocale["Blackrock Spire"]..""..AtlasLocale["Upper"], 1583 };
		Acronym = AtlasLocale["UBRS"];
		Location = { AtlasLocale["Blackrock Mountain"], 25 };
		LevelRange = "56-60";
		MinLevel = "55";
		PlayerLimit = "10";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Seal of Ascension"], ITEM, 12344 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Brazier of Invocation"].." ("..AtlasLocale["D2 Summon"]..")", ITEM, 22057 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Lower Blackrock Spire"].." ("..AtlasLocale["LBRS"]..")", ZONE, 1583 };
		{ BLUE.."C-E) "..AtlasLocale["Connections"] };
		{ GREY.."1) "..AtlasLocale["Pyroguard Emberseer"], NPC, 9816 };
		{ GREY.."2) "..AtlasLocale["Solakar Flamewreath"], NPC, 10264 };
		{ GREY..INDENT..AtlasLocale["Father Flame"], OBJECT, 175245 };
		{ GREY.."3) "..AtlasLocale["Darkstone Tablet"], OBJECT, 175385 };
		{ GREY..INDENT..AtlasLocale["Doomrigger's Coffer"], OBJECT, 175382 };
		{ GREY.."4) "..AtlasLocale["Jed Runewatcher <Blackhand Legion>"].." ("..AtlasLocale["Rare"]..")", NPC, 10509 };
		{ GREY.."5) "..AtlasLocale["Goraluk Anvilcrack <Blackhand Legion Armorsmith>"].." ("..AtlasLocale["Rare"]..")", NPC, 10899 };
		{ GREY.."6) "..AtlasLocale["Warchief Rend Blackhand"], NPC, 10429 };
		{ GREY..INDENT..AtlasLocale["Gyth <Rend Blackhand's Mount>"], NPC, 10339 };
		{ GREY.."7) "..AtlasLocale["Awbee"], NPC, 10740 };
		{ GREY.."8) "..AtlasLocale["The Beast"], NPC, 10430 };
		{ GREY..INDENT..AtlasLocale["Lord Valthalak"].." ("..AtlasLocale["Summon"]..")", NPC, 16042 };
		{ GREY..INDENT..AtlasLocale["Finkle Einhorn"], NPC, 10776 };
		{ GREY.."9) "..AtlasLocale["General Drakkisath"], NPC, 10363 };
		{ GREY..INDENT..AtlasLocale["Drakkisath's Brand"], OBJECT, 179880 };
		{ GREY.."10) "..AtlasLocale["Blackwing Lair"].." ("..AtlasLocale["BWL"]..")", ZONE, 2677 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["Ironweave Battlesuit"] };
		{ GREY..INDENT..AtlasLocale["D1/D2 Sets"] };
	};
	BlackwingLair = {
		ZoneName = { AtlasLocale["Blackwing Lair"], 2677 };
		Acronym = AtlasLocale["BWL"];
		Location = { AtlasLocale["Blackrock Spire"], 1583 };
		LevelRange = "60+";
		MinLevel = "60";
		PlayerLimit = "40";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ ORNG..AtlasLocale["Attunement Required"] };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Connection"] };
		{ BLUE.."C) "..AtlasLocale["Connection"] };
		{ GREY.."1) "..AtlasLocale["Razorgore the Untamed"], NPC, 12435 };
		{ GREY.."2) "..AtlasLocale["Vaelastrasz the Corrupt"], NPC, 13020 };
		{ GREY.."3) "..AtlasLocale["Broodlord Lashlayer"], NPC, 12017 };
		{ GREY.."4) "..AtlasLocale["Firemaw"], NPC, 11983 };
		{ GREY.."5) "..AtlasLocale["Master Elemental Shaper Krixix"], NPC, 14401 };
		{ GREY.."6) "..AtlasLocale["Ebonroc"], NPC, 14601 };
		{ GREY.."7) "..AtlasLocale["Flamegor"], NPC, 11981 };
		{ GREY.."8) "..AtlasLocale["Chromaggus"], NPC, 14020 };
		{ GREY.."9) "..AtlasLocale["Nefarian"], NPC, 11583 };
		{ GREN.."1') "..AtlasLocale["Alchemy Lab"] };
		{ GREN.."2') "..AtlasLocale["Draconic for Dummies"], OBJECT, 180666 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
		{ GREY..INDENT..AtlasLocale["T2 Sets"] };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ ORNG..AtlasLocale["Damage: "]..AtlasLocale["Fire"] };
	};
	Gnomeregan = {
		ZoneName = { AtlasLocale["Gnomeregan"], 133 };
		Acronym = AtlasLocale["Gnome"];
		Location = { AtlasLocale["Dun Morogh"], 1 };
		LevelRange = "24-32";
		MinLevel = "23";
		PlayerLimit = "5";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Workshop Key"].." ("..AtlasLocale["Back"]..")", ITEM, 6893 };
		{ BLUE.."A) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Front"]..")" };
		{ BLUE.."B) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Back"]..")" };
		{ GREY.."1) "..AtlasLocale["Blastmaster Emi Shortfuse"], NPC, 7998 };
		{ GREY..INDENT..AtlasLocale["Grubbis"], NPC, 7361 };
		{ GREY..INDENT..AtlasLocale["Chomper"], NPC, 6215 };
		{ GREY.."2) "..AtlasLocale["Clean Room"] };
		{ GREY..INDENT..AtlasLocale["Tink Sprocketwhistle <Engineering Supplies>"], NPC, 9676 };
		{ GREY..INDENT..AtlasLocale["The Sparklematic 5200"], OBJECT, 142487 };
		{ GREY..INDENT..AtlasLocale["Mail Box"] };
		{ GREY.."3) "..AtlasLocale["Kernobee"], NPC, 7850 };
		{ GREY..INDENT..AtlasLocale["Alarm-a-bomb 2600"], NPC, 7897 };
		{ GREY..INDENT..AtlasLocale["Matrix Punchograph 3005-B"], OBJECT, 142475 };
		{ GREY.."4) "..AtlasLocale["Viscous Fallout"], NPC, 7079 };
		{ GREY.."5) "..AtlasLocale["Electrocutioner 6000"], NPC, 6235 };
		{ GREY..INDENT..AtlasLocale["Matrix Punchograph 3005-C"], OBJECT, 142476 };
		{ GREY.."6) "..AtlasLocale["Crowd Pummeler 9-60"].." ("..AtlasLocale["Upper"]..")", NPC, 6229 };
		{ GREY..INDENT..AtlasLocale["Matrix Punchograph 3005-D"], OBJECT, 142696 };
		{ GREY.."7) "..AtlasLocale["Dark Iron Ambassador"].." ("..AtlasLocale["Rare"]..")", NPC, 6228 };
		{ GREY.."8) "..AtlasLocale["Mekgineer Thermaplugg"], NPC, 7800 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
	};
	MoltenCore = {
		ZoneName = { AtlasLocale["Molten Core"], 2717 };
		Acronym = AtlasLocale["MC"];
		Location = { AtlasLocale["Blackrock Depths"], 1584 };
		LevelRange = "60+";
		MinLevel = "60";
		PlayerLimit = "40";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ ORNG..AtlasLocale["Attunement Required"] };
		{ ORNG..AtlasLocale["Rep"]..": "..AtlasLocale["Hydraxian Waterlords"], FACTION, 749 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Aqual Quintessence"].." ("..AtlasLocale["Boss"]..")", ITEM, 17333 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Eternal Quintessence"].." ("..AtlasLocale["Boss"]..")", ITEM, 22754 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Lucifron"], NPC, 12118 };
		{ GREY.."2) "..AtlasLocale["Magmadar"], NPC, 11982 };
		{ GREY.."3) "..AtlasLocale["Gehennas"], NPC, 12259 };
		{ GREY.."4) "..AtlasLocale["Garr"], NPC, 12057 };
		{ GREY.."5) "..AtlasLocale["Shazzrah"], NPC, 12264 };
		{ GREY.."6) "..AtlasLocale["Baron Geddon"], NPC, 12056 };
		{ GREY.."7) "..AtlasLocale["Golemagg the Incinerator"], NPC, 11988 };
		{ GREY.."8) "..AtlasLocale["Sulfuron Harbinger"], NPC, 12098 };
		{ GREY.."9) "..AtlasLocale["Majordomo Executus"], NPC, 12018 };
		{ GREY.."10) "..AtlasLocale["Ragnaros"], NPC, 11502 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
		{ GREY..INDENT..AtlasLocale["Random Boss Loot"] };
		{ GREY..INDENT..AtlasLocale["T1 Sets"] };
		{ GREY..INDENT..AtlasLocale["T2 Sets"] };
		{ "" };
		{ "" };
		{ "" };
		{ ORNG..AtlasLocale["Damage: "]..AtlasLocale["Fire"] };
	};
	SMLibrary = {
		ZoneName = { AtlasLocale["Scarlet Monastery"]..": "..AtlasLocale["Library"], 796 };
		Acronym = AtlasLocale["SM Lib"];
		Location = { AtlasLocale["Tirisfal Glades"], 85 };
		LevelRange = "31-37";
		MinLevel = "25";
		PlayerLimit = "5";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Houndmaster Loksey"], NPC, 3974 };
		{ GREY.."2) "..AtlasLocale["Arcanist Doan"], NPC, 6487 };
		{ GREN.."1') "..AtlasLocale["Doan's Strongbox"], OBJECT, 103821 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["Chain of the Scarlet Crusade"] };
	};
	SMArmory = {
		ZoneName = { AtlasLocale["Scarlet Monastery"]..": "..AtlasLocale["Armory"], 796 };
		Acronym = AtlasLocale["SM Arm"];
		Location = { AtlasLocale["Tirisfal Glades"], 85 };
		LevelRange = "33-40";
		MinLevel = "25";
		PlayerLimit = "5";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["The Scarlet Key"], ITEM, 7146 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Herod <The Scarlet Champion>"], NPC, 3975 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["Chain of the Scarlet Crusade"] };
	};
	SMCathedral = {
		ZoneName = { AtlasLocale["Scarlet Monastery"]..": "..AtlasLocale["Cathedral"], 796 };
		Acronym = AtlasLocale["SM Cath"];
		Location = { AtlasLocale["Tirisfal Glades"], 85 };
		LevelRange = "36-42";
		MinLevel = "25";
		PlayerLimit = "5";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["The Scarlet Key"], ITEM, 7146 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["High Inquisitor Fairbanks"], NPC, 4542 };
		{ GREY.."2) "..AtlasLocale["Scarlet Commander Mograine"], NPC, 3976 };
		{ GREY.."3) "..AtlasLocale["High Inquisitor Whitemane"], NPC, 3977 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["Chain of the Scarlet Crusade"] };
	};
	SMGraveyard = {
		ZoneName = { AtlasLocale["Scarlet Monastery"]..": "..AtlasLocale["Graveyard"], 796 };
		Acronym = AtlasLocale["SM GY"];
		Location = { AtlasLocale["Tirisfal Glades"], 85 };
		LevelRange = "28-35";
		MinLevel = "25";
		PlayerLimit = "5";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Interrogator Vishas"], NPC, 3983 };
		{ GREY..INDENT..AtlasLocale["Vorrel Sengutz"], NPC, 3981 };
		{ GREY.."2) "..AtlasLocale["Scorn"].." ("..AtlasLocale["Scourge Invasion"]..")", NPC, 14693 };
		{ GREY.."3) "..AtlasLocale["Bloodmage Thalnos"], NPC, 4543 };
		{ GREN.."1') "..AtlasLocale["Ironspine"].." ("..AtlasLocale["Rare"]..")", NPC, 6489 };
		{ GREN..INDENT..AtlasLocale["Azshir the Sleepless"].." ("..AtlasLocale["Rare"]..")", NPC, 6490 };
		{ GREN..INDENT..AtlasLocale["Fallen Champion"].." ("..AtlasLocale["Rare"]..")", NPC, 6488 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["Chain of the Scarlet Crusade"] };
	};
	Scholomance = {
		ZoneName = { AtlasLocale["Scholomance"], 2057 };
		Acronym = AtlasLocale["Scholo"];
		Location = { AtlasLocale["Western Plaguelands"], 28 };
		LevelRange = "58-60";
		MinLevel = "45";
		PlayerLimit = "5";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ ORNG..AtlasLocale["Rep"]..": "..AtlasLocale["Argent Dawn"], FACTION, 529 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Skeleton Key"], ITEM, 13704 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Viewing Room Key"].." ("..AtlasLocale["Viewing Room"]..")", ITEM, 13873 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Blood of Innocents"].." ("..AtlasLocale["Kirtonos the Herald"]..")", ITEM, 13523 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Brazier of Invocation"].." ("..AtlasLocale["D2 Summon"]..")", ITEM, 22057 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Divination Scryer"].." ("..AtlasLocale["Death Knight Darkreaver"]..")", ITEM, 18746 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Connection"] };
		{ BLUE.."C) "..AtlasLocale["Connection"] };
		{ GREY.."1) "..AtlasLocale["Blood Steward of Kirtonos"], NPC, 14861 };
		{ GREY..INDENT..AtlasLocale["The Deed to Southshore"], OBJECT, 176486 };
		{ GREY.."2) "..AtlasLocale["Kirtonos the Herald"].." ("..AtlasLocale["Summon"]..")", NPC, 10506 };
		{ GREY.."3) "..AtlasLocale["Jandice Barov"], NPC, 10503 };
		{ GREY..INDENT..AtlasLocale["Journal of Jandice Barov"], OBJECT, 180794 };
		{ GREY.."4) "..AtlasLocale["The Deed to Tarren Mill"], OBJECT, 176487 };
		{ GREY..INDENT..AtlasLocale["Lord Blackwood"].." ("..AtlasLocale["Scourge Invasion"]..")", NPC, 14695 };
		{ GREY.."5) "..AtlasLocale["Rattlegore"].." ("..AtlasLocale["Lower"]..")", NPC, 11622 };
		{ GREY..INDENT..AtlasLocale["Death Knight Darkreaver"].." ("..AtlasLocale["Summon"]..")", NPC, 14516 };
		{ GREY.."6) "..AtlasLocale["Marduk Blackpool"], NPC, 10433 };
		{ GREY..INDENT..AtlasLocale["Vectus"], NPC, 10432 };
		{ GREY.."7) "..AtlasLocale["Ras Frostwhisper"], NPC, 10508 };
		{ GREY..INDENT..AtlasLocale["The Deed to Brill"], OBJECT, 176484 };
		{ GREY..INDENT..AtlasLocale["Kormok"].." ("..AtlasLocale["Summon"]..")", NPC, 16118 };
		{ GREY.."8) "..AtlasLocale["Instructor Malicia"], NPC, 10505 };
		{ GREY.."9) "..AtlasLocale["Doctor Theolen Krastinov <The Butcher>"], NPC, 11261 };
		{ GREY.."10) "..AtlasLocale["Lorekeeper Polkelt"], NPC, 10901 };
		{ GREY.."11) "..AtlasLocale["The Ravenian"], NPC, 10507 };
		{ GREY.."12) "..AtlasLocale["Lord Alexei Barov"], NPC, 10504 };
		{ GREY..INDENT..AtlasLocale["The Deed to Caer Darrow"], OBJECT, 176485 };
		{ GREY.."13) "..AtlasLocale["Lady Illucia Barov"], NPC, 10502 };
		{ GREY.."14) "..AtlasLocale["Darkmaster Gandling"], NPC, 1853 };
		{ GREN.."1') "..AtlasLocale["Torch Lever"] };
		{ GREN.."2') "..AtlasLocale["Old Treasure Chest"], OBJECT, 176944 };
		{ GREN.."3') "..AtlasLocale["Alchemy Lab"] };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["Necropile Raiment"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["Cadaverous Garb"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["Bloodmail Regalia"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["Deathbone Guardian"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["Ironweave Battlesuit"] };
		{ GREY..INDENT..AtlasLocale["D1/D2 Sets"] };
	};
	ShadowfangKeep = {
		ZoneName = { AtlasLocale["Shadowfang Keep"], 209 };
		Acronym = AtlasLocale["SFK"];
		Location = { AtlasLocale["Silverpine Forest"], 130 };
		LevelRange = "17-25";
		MinLevel = "10";
		PlayerLimit = "5";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Rethilgore <The Cell Keeper>"], NPC, 3914 };
		{ GREY..INDENT..AtlasLocale["Sorcerer Ashcrombe"], NPC, 3850 };
		{ GREY..INDENT..AtlasLocale["Deathstalker Adamant"], NPC, 3849 };
		{ GREY.."2) "..AtlasLocale["Deathstalker Vincent"], NPC, 4444 };
		{ GREY.."3) "..AtlasLocale["Fel Steed"], NPC, 3864 };
		{ GREY..INDENT..AtlasLocale["Jordan's Hammer"], OBJECT, 91138 };
		{ GREY.."4) "..AtlasLocale["Razorclaw the Butcher"], NPC, 3886 };
		{ GREY.."5) "..AtlasLocale["Baron Silverlaine"], NPC, 3887 };
		{ GREY.."6) "..AtlasLocale["Commander Springvale"], NPC, 4278 };
		{ GREY.."7) "..AtlasLocale["Sever"].." ("..AtlasLocale["Scourge Invasion"]..")", NPC, 4279 };
		{ GREY.."8) "..AtlasLocale["Odo the Blindwatcher"], NPC, 4279 };
		{ GREY.."9) "..AtlasLocale["Deathsworn Captain"].." ("..AtlasLocale["Rare"]..")", NPC, 3872 };
		{ GREY.."10) "..AtlasLocale["Fenrus the Devourer"], NPC, 4274 };
		{ GREY..INDENT..AtlasLocale["Arugal's Voidwalker"], NPC, 4627 };
		{ GREY..INDENT..AtlasLocale["The Book of Ur"], OBJECT, 36738 };
		{ GREY.."11) "..AtlasLocale["Wolf Master Nandos"], NPC, 3927 };
		{ GREY.."12) "..AtlasLocale["Archmage Arugal"], NPC, 4275 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
	};
	Stratholme = {
		ZoneName = { AtlasLocale["Stratholme"], 2017 };
		Acronym = AtlasLocale["Strat"];
		Location = { AtlasLocale["Eastern Plaguelands"], 139 };
		LevelRange = "58-60";
		MinLevel = "53";
		PlayerLimit = "5";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ ORNG..AtlasLocale["Rep"]..": "..AtlasLocale["Argent Dawn"], FACTION, 529 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["The Scarlet Key"].." ("..AtlasLocale["Living Side"]..")", ITEM, 7146 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Key to the City"].." ("..AtlasLocale["Undead Side"]..")", ITEM, 12382 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Various Postbox Keys"].." ("..AtlasLocale["Postmaster Malown"]..")" };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Brazier of Invocation"].." ("..AtlasLocale["D2 Summon"]..")", ITEM, 22057 };
		{ BLUE.."A) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Front"]..")" };
		{ BLUE.."B) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Side"]..")" };
		{ GREY.."1) "..AtlasLocale["Skul"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Varies"]..")", NPC, 10393 };
		{ GREY..INDENT..AtlasLocale["Stratholme Courier"], NPC, 11082 };
		{ GREY..INDENT..AtlasLocale["Fras Siabi"], NPC, 11058 };
		{ GREY.."2) "..AtlasLocale["Atiesh <Hand of Sargeras>"].." ("..AtlasLocale["Summon"]..")", NPC, 16387 };
		{ GREY..INDENT..AtlasLocale["Balzaphon"].." ("..AtlasLocale["Scourge Invasion"]..")", NPC, 14684 };
		{ GREY.."3) "..AtlasLocale["Hearthsinger Forresten"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Varies"]..")", NPC, 10558 };
		{ GREY.."4) "..AtlasLocale["The Unforgiven"], NPC, 10516 };
		{ GREY.."5) "..AtlasLocale["Elder Farwhisper"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 15607 };
		{ GREY.."6) "..AtlasLocale["Timmy the Cruel"], NPC, 10808 };
		{ GREY.."7) "..AtlasLocale["Malor the Zealous"], NPC, 11032 };
		{ GREY..INDENT..AtlasLocale["Malor's Strongbox"], OBJECT, 176112 };
		{ GREY.."8) "..AtlasLocale["Crimson Hammersmith"].." ("..AtlasLocale["Summon"]..")", NPC, 11120 };
		{ GREY..INDENT..AtlasLocale["Blacksmithing Plans"], OBJECT, 173232 };
		{ GREY.."9) "..AtlasLocale["Cannon Master Willey"], NPC, 10997 };
		{ GREY.."10) "..AtlasLocale["Archivist Galford"], NPC, 10811 };
		{ GREY.."11) "..AtlasLocale["Grand Crusader Dathrohan"], NPC, 10812 };
		{ GREY..INDENT..AtlasLocale["Balnazzar"], NPC, 10813 };
		{ GREY..INDENT..AtlasLocale["Sothos"].." & "..AtlasLocale["Jarien"].." ("..AtlasLocale["Summon"]..")", NPC, 16102 };
		{ GREY.."12) "..AtlasLocale["Magistrate Barthilas"].." ("..AtlasLocale["Varies"]..")", NPC, 10435 };
		{ GREY.."13) "..AtlasLocale["Aurius"], NPC, 10917 };
		{ GREY.."14) "..AtlasLocale["Stonespine"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Wanders"]..")", NPC, 10809 };
		{ GREY.."15) "..AtlasLocale["Baroness Anastari"], NPC, 10436 };
		{ GREY..INDENT..AtlasLocale["Black Guard Swordsmith"].." ("..AtlasLocale["Summon"]..")", NPC, 11121 };
		{ GREY..INDENT..AtlasLocale["Blacksmithing Plans"], OBJECT, 173232 };
		{ GREY.."16) "..AtlasLocale["Nerub'enkan"], NPC, 10437 };
		{ GREY.."17) "..AtlasLocale["Maleki the Pallid"], NPC, 10438 };
		{ GREY.."18) "..AtlasLocale["Ramstein the Gorger"], NPC, 10439 };
		{ GREY.."19) "..AtlasLocale["Baron Rivendare"], NPC, 10440 };
		{ GREY..INDENT..AtlasLocale["Ysida Harmon"], NPC, 16031 };
		{ GREN.."1') "..AtlasLocale["Crusaders' Square Postbox"], OBJECT, 176349 };
		{ GREN.."2') "..AtlasLocale["Market Row Postbox"], OBJECT, 176346 };
		{ GREN.."3') "..AtlasLocale["Festival Lane Postbox"], OBJECT, 176350 };
		{ GREN.."4') "..AtlasLocale["Elders' Square Postbox"], OBJECT, 176351 };
		{ GREN.."5') "..AtlasLocale["King's Square Postbox"], OBJECT, 176352 };
		{ GREN.."6') "..AtlasLocale["Fras Siabi's Postbox"], OBJECT, 176353 };
		{ GREN..INDENT..AtlasLocale["Third Postbox Opened"]..": "..AtlasLocale["Postmaster Malown"], NPC, 11143 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["The Postmaster"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["Ironweave Battlesuit"] };
		{ GREY..INDENT..AtlasLocale["D1/D2 Sets"] };
	};
	TheDeadmines = {
		ZoneName = { AtlasLocale["The Deadmines"], 1581 };
		Acronym = AtlasLocale["DM"];
		Location = { AtlasLocale["Westfall"], 40 };
		LevelRange = "16-22";
		MinLevel = "13";
		PlayerLimit = "5";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Exit"] };
		{ GREY.."1) "..AtlasLocale["Rhahk'Zor <The Foreman>"], NPC, 644 };
		{ GREY.."2) "..AtlasLocale["Miner Johnson"].." ("..AtlasLocale["Rare"]..")", NPC, 3586 };
		{ GREY.."3) "..AtlasLocale["Sneed <Lumbermaster>"], NPC, 643 };
		{ GREY..INDENT..AtlasLocale["Sneed's Shredder <Lumbermaster>"], NPC, 642 };
		{ GREY.."4) "..AtlasLocale["Gilnid <The Smelter>"], NPC, 1763 };
		{ GREY.."5) "..AtlasLocale["Defias Gunpowder"], OBJECT, 17155 };
		{ GREY.."6) "..AtlasLocale["Mr. Smite <The Ship's First Mate>"], NPC, 646 };
		{ GREY..INDENT..AtlasLocale["Cookie <The Ship's Cook>"], NPC, 645 };
		{ GREY..INDENT..AtlasLocale["Captain Greenskin"], NPC, 647 };
		{ GREY..INDENT..AtlasLocale["Edwin VanCleef <Defias Kingpin>"], NPC, 639 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["Defias Leather"] };
	};
	TheStockade = {
		ZoneName = { AtlasLocale["The Stockade"], 717 };
		Acronym = AtlasLocale["Stocks"];
		Location = { AtlasLocale["Stormwind City"], 1519 };
		LevelRange = "21-27";
		MinLevel = "15";
		PlayerLimit = "5";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Targorr the Dread"].." ("..AtlasLocale["Varies"]..")", NPC, 1696 };
		{ GREY.."2) "..AtlasLocale["Kam Deepfury"], NPC, 1666 };
		{ GREY.."3) "..AtlasLocale["Hamhock"], NPC, 1717 };
		{ GREY.."4) "..AtlasLocale["Bazil Thredd"], NPC, 1716 };
		{ GREY.."5) "..AtlasLocale["Dextren Ward"], NPC, 1663 };
		{ GREY.."6) "..AtlasLocale["Bruegal Ironknuckle"].." ("..AtlasLocale["Rare"]..")", NPC, 1720 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
	};
	TheSunkenTemple = {
		ZoneName = { AtlasLocale["Sunken Temple"], 1417 };
		Acronym = AtlasLocale["ST"];
		Location = { AtlasLocale["Swamp of Sorrows"], 8 };
		LevelRange = "46-53";
		MinLevel = "45";
		PlayerLimit = "5";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ ORNG..AtlasLocale["AKA"]..": "..AtlasLocale["The Temple of Atal'Hakkar"] };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Yeh'kinya's Scroll"].." ("..AtlasLocale["Avatar of Hakkar"]..")", ITEM, 10818 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Connection"] };
		{ BLUE.."C) "..AtlasLocale["Balcony Minibosses"].." ("..AtlasLocale["Upper"]..")" };
		{ BLUE..INDENT..AtlasLocale["Gasher"], NPC, 5713 };
		{ BLUE..INDENT..AtlasLocale["Loro"], NPC, 5714 };
		{ BLUE..INDENT..AtlasLocale["Hukku"], NPC, 5715 };
		{ BLUE..INDENT..AtlasLocale["Zolo"], NPC, 5712 };
		{ BLUE..INDENT..AtlasLocale["Mijan"], NPC, 5717 };
		{ BLUE..INDENT..AtlasLocale["Zul'Lor"], NPC, 5716 };
		{ GREY.."1) "..AtlasLocale["Altar of Hakkar"], OBJECT, 148836 };
		{ GREY..INDENT..AtlasLocale["Atal'alarion <Guardian of the Idol>"], NPC, 8580 };
		{ GREY.."2) "..AtlasLocale["Spawn of Hakkar"].." ("..AtlasLocale["Wanders"]..")", NPC, 5708 };
		{ GREY.."3) "..AtlasLocale["Avatar of Hakkar"], NPC, 8443 };
		{ GREY.."4) "..AtlasLocale["Jammal'an the Prophet"], NPC, 5710 };
		{ GREY..INDENT..AtlasLocale["Ogom the Wretched"], NPC, 5711 };
		{ GREY.."5) "..AtlasLocale["Elder Starsong"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 15593 };
		{ GREY.."6) "..AtlasLocale["Dreamscythe"], NPC, 5721 };
		{ GREY..INDENT..AtlasLocale["Weaver"], NPC, 5720 };
		{ GREY.."7) "..AtlasLocale["Morphaz"], NPC, 5719 };
		{ GREY..INDENT..AtlasLocale["Hazzas"], NPC, 5722 };
		{ GREY.."8) "..AtlasLocale["Shade of Eranikus"], NPC, 5709 };
		{ GREY..INDENT..AtlasLocale["Essence Font"], OBJECT, 148512 };
		{ GREY..INDENT..AtlasLocale["Malfurion Stormrage"].." ("..AtlasLocale["Summon"]..")", NPC, 15362 };
		{ GREN.."1'-6') "..AtlasLocale["Statue Activation Order"] };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
	};
	Uldaman = {
		ZoneName = { AtlasLocale["Uldaman"], 1337 };
		Acronym = AtlasLocale["Ulda"];
		Location = { AtlasLocale["Badlands"], 3 };
		LevelRange = "36-42";
		MinLevel = "29";
		PlayerLimit = "5";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Staff of Prehistoria"].." ("..AtlasLocale["Ironaya"]..")", ITEM, 7733 };
		{ BLUE.."A) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Front"]..")" };
		{ BLUE.."B) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Back"]..")" };
		{ GREY.."1) "..AtlasLocale["Baelog"], NPC, 6906 };
		{ GREY..INDENT..AtlasLocale["Eric \"The Swift\""], NPC, 6907 };
		{ GREY..INDENT..AtlasLocale["Olaf"], NPC, 6908 };
		{ GREY..INDENT..AtlasLocale["Baelog's Chest"], OBJECT, 123329 };
		{ GREY..INDENT..AtlasLocale["Conspicuous Urn"], OBJECT, 125477 };
		{ GREY.."2) "..AtlasLocale["Remains of a Paladin"], NPC, 6912 };
		{ GREY.."3) "..AtlasLocale["Revelosh"], NPC, 6910 };
		{ GREY.."4) "..AtlasLocale["Ironaya"], NPC, 7228 };
		{ GREY.."5) "..AtlasLocale["Obsidian Sentinel"], NPC, 7023 };
		{ GREY.."6) "..AtlasLocale["Annora <Enchanting Trainer>"], NPC, 11073 };
		{ GREY.."7) "..AtlasLocale["Ancient Stone Keeper"], NPC, 7206 };
		{ GREY.."8) "..AtlasLocale["Galgann Firehammer"], NPC, 7291 };
		{ GREY..INDENT..AtlasLocale["Tablet of Will"], OBJECT, 142088 };
		{ GREY..INDENT..AtlasLocale["Shadowforge Cache"], OBJECT, 113757 };
		{ GREY.."9) "..AtlasLocale["Grimlok <Stonevault Chieftain>"], NPC, 4854 };
		{ GREY.."10) "..AtlasLocale["Archaedas <Ancient Stone Watcher>"].." ("..AtlasLocale["Lower"]..")", NPC, 2748 };
		{ GREY.."11) "..AtlasLocale["The Discs of Norgannon"].." ("..AtlasLocale["Lower"]..")", OBJECT, 131474 };
		{ GREY..INDENT..AtlasLocale["Ancient Treasure"].." ("..AtlasLocale["Lower"]..")", OBJECT, 141979 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
	};
	ZulGurub = {
		ZoneName = { AtlasLocale["Zul'Gurub"], 19 };
		Acronym = AtlasLocale["ZG"];
		Location = { AtlasLocale["Stranglethorn Vale"], 33 };
		LevelRange = "60+";
		MinLevel = "51";
		PlayerLimit = "20";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ ORNG..AtlasLocale["Rep"]..": "..AtlasLocale["Zandalar Tribe"], FACTION, 270 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Gurubashi Mojo Madness"].." ("..AtlasLocale["Edge of Madness"]..")", ITEM, 19931 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Mudskunk Lure"].." ("..AtlasLocale["Gahz'ranka"]..")", ITEM, 19974 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["High Priestess Jeklik"].." ("..AtlasLocale["Bat"]..")", NPC, 14517 };
		{ GREY.."2) "..AtlasLocale["High Priest Venoxis"].." ("..AtlasLocale["Snake"]..")", NPC, 14507 };
		{ GREY.."3) "..AtlasLocale["Zanza the Restless"], NPC, 15042 };
		{ GREY.."4) "..AtlasLocale["High Priestess Mar'li"].." ("..AtlasLocale["Spider"]..")", NPC, 14510 };
		{ GREY.."5) "..AtlasLocale["Bloodlord Mandokir"].." ("..AtlasLocale["Raptor"]..", "..AtlasLocale["Optional"]..")", NPC, 11382 };
		{ GREY..INDENT..AtlasLocale["Ohgan"], NPC, 14988 };
		{ GREY.."6) "..AtlasLocale["Edge of Madness"].." ("..AtlasLocale["Optional"]..")" };
		{ GREY..INDENT..AtlasLocale["Gri'lek"].." ("..AtlasLocale["Random"]..")", NPC, 15082 };
		{ GREY..INDENT..AtlasLocale["Hazza'rah"].." ("..AtlasLocale["Random"]..")", NPC, 15083 };
		{ GREY..INDENT..AtlasLocale["Renataki"].." ("..AtlasLocale["Random"]..")", NPC, 15084 };
		{ GREY..INDENT..AtlasLocale["Wushoolay"].." ("..AtlasLocale["Random"]..")", NPC, 15085 };
		{ GREY.."7) "..AtlasLocale["Gahz'ranka"].." ("..AtlasLocale["Optional"]..", "..AtlasLocale["Summon"]..")", NPC, 15114 };
		{ GREY.."8) "..AtlasLocale["High Priest Thekal"].." ("..AtlasLocale["Tiger"]..")", NPC, 14509 };
		{ GREY..INDENT..AtlasLocale["Zealot Zath"].." ("..AtlasLocale["BRDRogue"]..GREY..")", NPC, 11348 };
		{ GREY..INDENT..AtlasLocale["Zealot Lor'Khan"].." ("..AtlasLocale["BRDShaman"]..GREY..")", NPC, 11347 };
		{ GREY.."9) "..AtlasLocale["High Priestess Arlokk"].." ("..AtlasLocale["Panther"]..")", NPC, 14515 };
		{ GREY.."10) "..AtlasLocale["Jin'do the Hexxer"].." ("..AtlasLocale["Optional"]..")", NPC, 11380 };
		{ GREY.."11) "..AtlasLocale["Hakkar"], NPC, 14834 };
		{ GREN.."1') "..AtlasLocale["Muddy Churning Waters"], OBJECT, 180369 };
		{ GREN.."2') "..AtlasLocale["Jinxed Hoodoo Pile"], OBJECT, 180228 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
		{ GREY..INDENT..AtlasLocale["Random Boss Loot"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["Primal Blessing"] };
		{ GREY..INDENT..AtlasLocale["Set: "]..AtlasLocale["The Twin Blades of Hakkari"] };
		{ GREY..INDENT..AtlasLocale["ZG Ring Sets"] };
		{ GREY..INDENT..AtlasLocale["ZG Sets"] };
		{ GREY..INDENT..AtlasLocale["ZG Enchants"] };
		{ "" };
		{ ORNG..AtlasLocale["Damage: "]..AtlasLocale["Nature"] };
	};
	Naxxramas = {
		ZoneName = { AtlasLocale["Naxxramas"], 3456 };
		Acronym = AtlasLocale["Naxx"];
		Location = { AtlasLocale["Eastern Plaguelands"], 139 };
		LevelRange = "60+";
		MinLevel = "55";
		PlayerLimit = "40";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ ORNG..AtlasLocale["Attunement Required"] };
		{ ORNG..AtlasLocale["Rep"]..": "..AtlasLocale["Argent Dawn"], FACTION, 529 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE..INDENT..AtlasLocale["Archmage Tarsis Kir-Moldir"], NPC, 16381 };
		{ BLUE..INDENT..AtlasLocale["Mr. Bigglesworth"].." ("..AtlasLocale["Wanders"]..")", NPC, 16998 };
		{ GREY..AtlasLocale["Abomination Wing"] };
		{ GREY..INDENT.."1) "..AtlasLocale["Patchwerk"], NPC, 16028 };
		{ GREY..INDENT.."2) "..AtlasLocale["Grobbulus"], NPC, 15931 };
		{ GREY..INDENT.."3) "..AtlasLocale["Gluth"], NPC, 15932 };
		{ GREY..INDENT.."4) "..AtlasLocale["Thaddius"], NPC, 15928 };
		{ ORNG..AtlasLocale["Spider Wing"] };
		{ ORNG..INDENT.."1) "..AtlasLocale["Anub'Rekhan"], NPC, 15956 };
		{ ORNG..INDENT.."2) "..AtlasLocale["Grand Widow Faerlina"], NPC, 15953 };
		{ ORNG..INDENT.."3) "..AtlasLocale["Maexxna"], NPC, 15952 };
		{ PURP..AtlasLocale["Plague Wing"] };
		{ PURP..INDENT.."1) "..AtlasLocale["Noth the Plaguebringer"], NPC, 15954 };
		{ PURP..INDENT.."2) "..AtlasLocale["Heigan the Unclean"], NPC, 15936 };
		{ PURP..INDENT.."3) "..AtlasLocale["Loatheb"], NPC, 16011 };
		{ _RED..AtlasLocale["Deathknight Wing"] };
		{ _RED..INDENT.."1) "..AtlasLocale["Instructor Razuvious"], NPC, 16061 };
		{ _RED..INDENT.."2) "..AtlasLocale["Gothik the Harvester"], NPC, 16060 };
		{ _RED..INDENT.."3) "..AtlasLocale["The Four Horsemen"] };
		{ _RED..INDENT..INDENT..AtlasLocale["Thane Korth'azz"], NPC, 16064 };
		{ _RED..INDENT..INDENT..AtlasLocale["Lady Blaumeux"], NPC, 16065 };
		{ _RED..INDENT..INDENT..AtlasLocale["Highlord Mograine <The Ashbringer>"], NPC, 16062 };
		{ _RED..INDENT..INDENT..AtlasLocale["Sir Zeliek"], NPC, 16063 };
		{ _RED..INDENT.."1') "..AtlasLocale["Master Craftsman Omarion"], NPC, 16365 };
		{ _RED..INDENT.."2') "..AtlasLocale["Icebellow Anvil"], OBJECT, 181168 };
		{ GREN..AtlasLocale["Frostwyrm Lair"] };
		{ GREN..INDENT.."1) "..AtlasLocale["Sapphiron"], NPC, 15989 };
		{ GREN..INDENT.."2) "..AtlasLocale["Kel'Thuzad"], NPC, 15990 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
		{ GREY..INDENT..AtlasLocale["T3 Sets"] };
		{ "" };
		{ ORNG..AtlasLocale["Damage: "]..AtlasLocale["Nature"]..", "..AtlasLocale["Fire"]..", "..AtlasLocale["Arcane"]..", "..AtlasLocale["Shadow"]..", "..AtlasLocale["Frost"]};
	};
	
--************************************************
-- Instance Entrance Maps
--************************************************

	BlackfathomDeepsEnt = {
		ZoneName = { AtlasLocale["Blackfathom Deeps"].." ("..AtlasLocale["Entrance"]..")", 719 };
		Location = { AtlasLocale["Ashenvale"], 331 };
		Acronym = AtlasLocale["BFD"];
		Continent = AtlasLocale["Kalimdor"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Blackfathom Deeps"], ZONE, 719 };
	};
	BlackrockMountainEnt = {
		ZoneName = { AtlasLocale["Blackrock Mountain"].." ("..AtlasLocale["Entrance"]..")", 25 };
		Location = { AtlasLocale["Blackrock Mountain"], 51, 46 };
		Acronym = AtlasLocale["BRM"];
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ BLUE.."A) "..AtlasLocale["Searing Gorge"], ZONE, 51 };
		{ BLUE.."B) "..AtlasLocale["Burning Steppes"], ZONE, 46 };
		{ BLUE.."C) "..AtlasLocale["Blackrock Depths"].." ("..AtlasLocale["BRD"]..")", ZONE, 1584 };
		{ BLUE..INDENT..AtlasLocale["Molten Core"].." ("..AtlasLocale["MC"]..") ("..AtlasLocale["through "]..AtlasLocale["BRD"]..")", ZONE, 2717 };
		{ BLUE.."D) "..AtlasLocale["Lower Blackrock Spire"].." ("..AtlasLocale["LBRS"]..")", ZONE, 1583 };
		{ BLUE..INDENT..AtlasLocale["Upper Blackrock Spire"].." ("..AtlasLocale["UBRS"]..")", ZONE, 1583 };
		{ BLUE..INDENT..AtlasLocale["Blackwing Lair"].." ("..AtlasLocale["BWL"]..") ("..AtlasLocale["through "]..AtlasLocale["UBRS"]..")", ZONE, 2677 };
		{ BLUE..INDENT..AtlasLocale["Bodley"].." ("..AtlasLocale["Ghost"]..")", NPC, 16033 };
		{ GREY.."1) "..AtlasLocale["Overmaster Pyron"].." ("..AtlasLocale["Wanders"]..")", NPC, 9026 };
		{ GREY.."2) "..AtlasLocale["Lothos Riftwaker"].." ("..AtlasLocale["MC"].. " "..AtlasLocale["Teleport"]..")", NPC, 14387 };
		{ GREY.."3) "..AtlasLocale["Franclorn Forgewright"].." ("..AtlasLocale["Ghost"]..")", NPC, 8888 };
		{ GREY.."4) "..AtlasLocale["Meeting Stone"].." ("..AtlasLocale["BRD"]..")" };
		{ GREY.."5) "..AtlasLocale["Orb of Command"].." ("..AtlasLocale["BWL"].. " "..AtlasLocale["Teleport"]..")", OBJECT, 179879 };
		{ GREY.."6) "..AtlasLocale["Meeting Stone"].." ("..AtlasLocale["LBRS"]..", "..AtlasLocale["UBRS"]..")" };
		{ GREY.."7) "..AtlasLocale["Scarshield Quartermaster <Scarshield Legion>"].." ("..AtlasLocale["Rare"]..")", NPC, 9046 };
		{ GREY.."8) "..AtlasLocale["The Behemoth"].." ("..AtlasLocale["Rare"]..")", NPC, 8924 };
	};
	GnomereganEnt = {
		ZoneName = { AtlasLocale["Gnomeregan"].." ("..AtlasLocale["Entrance"]..")", 133 };
		Location = { AtlasLocale["Dun Morogh"], 1 };
		Acronym = AtlasLocale["Gnome"];
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE..INDENT..AtlasLocale["Meeting Stone"] };
		{ BLUE.."B) "..AtlasLocale["Gnomeregan"].." ("..AtlasLocale["Front"]..")", ZONE, 133 };
		{ BLUE.."C) "..AtlasLocale["Gnomeregan"].." ("..AtlasLocale["Back"]..")", ZONE, 133 };
		{ GREY.."1) "..AtlasLocale["Elevator"] };
		{ GREY.."2) "..AtlasLocale["Transpolyporter"] };
		{ GREY..INDENT..AtlasLocale["Sprok <Away Team>"], NPC, 8320 };
		{ GREY.."3) "..AtlasLocale["Matrix Punchograph 3005-A"], OBJECT, 142345 };
		{ GREY..INDENT..AtlasLocale["Namdo Bizzfizzle <Engineering Supplies>"], NPC, 2683 };
		{ GREY.."4) "..AtlasLocale["Techbot"], NPC, 6231 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Trash Mobs"] };
	};
	MaraudonEnt = {
		ZoneName = { AtlasLocale["Maraudon"].." ("..AtlasLocale["Entrance"]..")", 2100 };
		Location = { AtlasLocale["Desolace"], 405 };
		Acronym = AtlasLocale["Mara"];
		Continent = AtlasLocale["Kalimdor"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE..INDENT..AtlasLocale["The Nameless Prophet"], NPC, 13718 };
		{ BLUE.."B) "..AtlasLocale["Maraudon"].." ("..AtlasLocale["Purple"]..")", ZONE, 2100 };
		{ BLUE.."C) "..AtlasLocale["Maraudon"].." ("..AtlasLocale["Orange"]..")", ZONE, 2100 };
		{ BLUE.."D) "..AtlasLocale["Maraudon"].." ("..AtlasLocale["Portal"]..")", ZONE, 2100 };
		{ GREY.."1) "..AtlasLocale["Kolk <The First Kahn>"], NPC, 13742 };
		{ GREY.."2) "..AtlasLocale["Gelk <The Second Kahn>"], NPC, 13741 };
		{ GREY.."3) "..AtlasLocale["Magra <The Third Kahn>"], NPC, 13740 };
		{ GREY.."4) "..AtlasLocale["Cavindra"], NPC, 13697 };
		{ GREY.."5) "..AtlasLocale["Cursed Centaur"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Varies"]..")", NPC, 11688 };
	};
	TheDeadminesEnt = {
		ZoneName = { AtlasLocale["The Deadmines"].." ("..AtlasLocale["Entrance"]..")", 1581 };
		Location = { AtlasLocale["Westfall"], 40 };
		Acronym = AtlasLocale["DM"];
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["The Deadmines"], ZONE, 1581 };
		{ GREY.."1) "..AtlasLocale["Marisa du'Paige"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Varies"]..")", NPC, 599 };
		{ GREY.."2) "..AtlasLocale["Brainwashed Noble"].." ("..AtlasLocale["Rare"]..")", NPC, 596 };
		{ GREY.."3) "..AtlasLocale["Foreman Thistlenettle"], NPC, 626 };
	};
	TheSunkenTempleEnt = {
		ZoneName = { AtlasLocale["Sunken Temple"].." ("..AtlasLocale["Entrance"]..")", 1417 };
		Location = { AtlasLocale["Swamp of Sorrows"], 8 };
		Acronym = AtlasLocale["ST"];
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE..INDENT..AtlasLocale["Meeting Stone"] };
		{ BLUE..INDENT..AtlasLocale["Jade"].." ("..AtlasLocale["Rare"]..")", NPC, 1063 };
		{ BLUE.."B) "..AtlasLocale["Sunken Temple"], ZONE, 1417 };
		{ GREY.."1) "..AtlasLocale["Kazkaz the Unholy"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Upper"]..")", NPC, 5401 };
		{ GREY.."2) "..AtlasLocale["Zekkis"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Lower"]..")", NPC, 5400 };
		{ GREY.."3) "..AtlasLocale["Veyzhak the Cannibal"].." ("..AtlasLocale["Rare"]..")", NPC, 5399 };
	};
	UldamanEnt = {
		ZoneName = { AtlasLocale["Uldaman"].." ("..AtlasLocale["Entrance"]..")", 1337 };
		Location = { AtlasLocale["Badlands"], 3 };
		Acronym = AtlasLocale["Ulda"];
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Uldaman"], ZONE, 1337 };
		{ GREY.."1) "..AtlasLocale["Hammertoe Grez"], NPC, 2909 };
		{ GREY.."2) "..AtlasLocale["Magregan Deepshadow"].." ("..AtlasLocale["Wanders"]..")", NPC, 2932 };
		{ GREY.."3) "..AtlasLocale["Tablet of Ryun'Eh"], ITEM, 4631 };
		{ GREY.."4) "..AtlasLocale["Krom Stoutarm's Chest"], OBJECT, 124389 };
		{ GREY.."5) "..AtlasLocale["Garrett Family Chest"], OBJECT, 124388 };
		{ GREN.."1') "..AtlasLocale["Digmaster Shovelphlange"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Varies"]..")", NPC, 7057 };
	};
	WailingCavernsEnt = {
		ZoneName = { AtlasLocale["Wailing Caverns"].." ("..AtlasLocale["Entrance"]..")", 718 };
		Location = { AtlasLocale["The Barrens"], 17 };
		Acronym = AtlasLocale["WC"];
		Continent = AtlasLocale["Kalimdor"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Wailing Caverns"], ZONE, 718 };
		{ GREY.."1) "..AtlasLocale["Mad Magglish"].." ("..AtlasLocale["Varies"]..")", NPC, 3655 };
		{ GREY.."2) "..AtlasLocale["Trigore the Lasher"].." ("..AtlasLocale["Rare"]..")", NPC, 3652 };
		{ GREY.."3) "..AtlasLocale["Boahn <Druid of the Fang>"].." ("..AtlasLocale["Rare"]..")", NPC, 3672 };
		{ "" };
		{ ORNG..AtlasLocale["Above the Entrance:"] };
		{ GREY..INDENT..AtlasLocale["Ebru <Disciple of Naralex>"], NPC, 5768 };
		{ GREY..INDENT..AtlasLocale["Nalpak <Disciple of Naralex>"], NPC, 5767 };
		{ GREY..INDENT..AtlasLocale["Kalldan Felmoon <Specialist Leatherworking Supplies>"], NPC, 5783 };
		{ GREY..INDENT..AtlasLocale["Waldor <Leatherworking Trainer>"], NPC, 5784 };
	};
	DireMaulEnt = {
		ZoneName = { AtlasLocale["Dire Maul"].." ("..AtlasLocale["Entrance"]..")", 2557 };
		Location = { AtlasLocale["Feralas"], 357 };
		Acronym = AtlasLocale["DM"];
		Continent = AtlasLocale["Kalimdor"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Dire Maul"].." ("..AtlasLocale["East"]..")", ZONE, 2557 };
		{ BLUE.."C) "..AtlasLocale["Dire Maul"].." ("..AtlasLocale["North"]..")", ZONE, 2557 };
		{ BLUE.."D) "..AtlasLocale["Dire Maul"].." ("..AtlasLocale["West"]..")", ZONE, 2557 };
		{ GREY.."1) "..AtlasLocale["Dire Pool"] };
		{ GREY.."2) "..AtlasLocale["Dire Maul Arena"] };
		{ GREY..INDENT..AtlasLocale["Mushgog"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Random"]..")", NPC, 11447 };
		{ GREY..INDENT..AtlasLocale["Skarr the Unbreakable"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Random"]..")", NPC, 11498 };
		{ GREY..INDENT..AtlasLocale["The Razza"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Random"]..")", NPC, 11497 };
		{ GREY..INDENT..AtlasLocale["Elder Mistwalker"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 15587 };
		{ GREY.."3) "..AtlasLocale["Griniblix the Spectator"], NPC, 14395 };
	};
	SMEnt = {
		ZoneName = { AtlasLocale["Scarlet Monastery"].." ("..AtlasLocale["Entrance"]..")", 796 };
		Location = { AtlasLocale["Tirisfal Glades"], 85 };
		Acronym = AtlasLocale["SM"];
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Graveyard"], ZONE, 796 };
		{ BLUE.."C) "..AtlasLocale["Cathedral"], ZONE, 796 };
		{ BLUE.."D) "..AtlasLocale["Armory"], ZONE, 796 };
		{ BLUE.."E) "..AtlasLocale["Library"], ZONE, 796 };
	};
	Azuregos = {
		ZoneName = { AtlasLocale["Azuregos"], NPC, 6109 };
		Location = { AtlasLocale["Azshara"], ZONE, 16 };
		LevelRange = "60+";
		MinLevel = "--";
		PlayerLimit = "40";
		{ GREY.."1) "..AtlasLocale["Azuregos"], NPC, 6109 };
		{ GREY..INDENT..AtlasLocale["Spirit of Azuregos"], NPC, 15481 };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ ORNG..AtlasLocale["Damage: "]..AtlasLocale["Frost"] };
	};
	FourDragons = {
		ZoneName = { AtlasLocale["Emerald Dragons"] };
		Location = { AtlasLocale["Various"] };
		LevelRange = "60+";
		MinLevel = "--";
		PlayerLimit = "40";
		{ GREY.."1) "..AtlasLocale["Duskwood"], ZONE, 10 };
		{ GREY.."2) "..AtlasLocale["The Hinterlands"], ZONE, 47 };
		{ GREY.."3) "..AtlasLocale["Feralas"], ZONE, 357 };
		{ GREY.."4) "..AtlasLocale["Ashenvale"], ZONE, 331 };
		{ "" };
		{ GREN..INDENT..AtlasLocale["Lethon"], NPC, 14888 };
		{ GREN..INDENT..AtlasLocale["Emeriss"], NPC, 14889 };
		{ GREN..INDENT..AtlasLocale["Taerar"], NPC, 14890 };
		{ GREN..INDENT..AtlasLocale["Ysondre"], NPC, 14887 };
		{ "" };
		{ GREY..INDENT..AtlasLocale["Emerald Dragons Trash"] };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ ORNG..AtlasLocale["Damage: "]..AtlasLocale["Nature"]..", "..AtlasLocale["Shadow"] };
	};
	LordKazzak = {
		ZoneName = { AtlasLocale["Lord Kazzak"], NPC, 18728 };
		Location = { AtlasLocale["Blasted Lands"], ZONE, 4 };
		LevelRange = "60+";
		MinLevel = "--";
		PlayerLimit = "40";
		{ GREY.."1) "..AtlasLocale["Lord Kazzak"], NPC, 18728 };
		{ GREY.."2) "..AtlasLocale["Nethergarde Keep"] };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ ORNG..AtlasLocale["Damage: "]..AtlasLocale["Shadow"] };
	};
	AlteracValleyNorth = {
		ZoneName = { AtlasLocale["Alterac Valley"].." ("..AtlasLocale["North"]..")", 2597 };
		Acronym = AtlasLocale["AV"];
		Location = { AtlasLocale["Alterac Mountains"], 36 };
		LevelRange = "51-60";
		MinLevel = "51";
		PlayerLimit = "40";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ ORNG..AtlasLocale["Rep"]..": "..AtlasLocale["Stormpike Guard"], FACTION, 730 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Dun Baldar"] };
		{ BLUE..INDENT..AtlasLocale["Vanndar Stormpike <Stormpike General>"], NPC, 11948 };
		{ BLUE..INDENT..AtlasLocale["Dun Baldar North Marshal"], NPC, 14762 };
		{ BLUE..INDENT..AtlasLocale["Dun Baldar South Marshal"], NPC, 14763 };
		{ BLUE..INDENT..AtlasLocale["Icewing Marshal"], NPC, 14764 };
		{ BLUE..INDENT..AtlasLocale["Stonehearth Marshal"], NPC, 14765 };
		{ BLUE..INDENT..AtlasLocale["Iceblood Marshal"], NPC, 14766 };
		{ BLUE..INDENT..AtlasLocale["Tower Point Marshal"], NPC, 14767 };
		{ BLUE..INDENT..AtlasLocale["East Frostwolf Marshal"], NPC, 14768 };
		{ BLUE..INDENT..AtlasLocale["West Frostwolf Marshal"], NPC, 14769 };
		{ BLUE..INDENT..AtlasLocale["Prospector Stonehewer"], NPC, 13816 };
		{ _RED.."1) "..AtlasLocale["Irondeep Mine"] };
		{ GREY..INDENT..AtlasLocale["Morloch"].." ("..AtlasLocale["Neutral"]..")", NPC, 11657 };
		{ GREY..INDENT..AtlasLocale["Umi Thorson"].." ("..AtlasLocale["Alliance"]..")", NPC, 13078 };
		{ GREY..INDENT..AtlasLocale["Keetar"].." ("..AtlasLocale["Horde"]..")", NPC, 13079 };
		{ GREY.."2) "..AtlasLocale["Arch Druid Renferal"], NPC, 13442 };
		{ ORNG.."3) "..AtlasLocale["Dun Baldar North Bunker"] };
		{ GREY..INDENT..AtlasLocale["Wing Commander Mulverick"].." ("..AtlasLocale["Horde"]..")", NPC, 13181 };
		{ GREY.."4) "..AtlasLocale["Murgot Deepforge"], NPC, 13257 };
		{ GREY..INDENT..AtlasLocale["Dirk Swindle <Bounty Hunter>"], NPC, 14188 };
		{ GREY..INDENT..AtlasLocale["Athramanis <Bounty Hunter>"], NPC, 14187 };
		{ GREY..INDENT..AtlasLocale["Lana Thunderbrew <Blacksmithing Supplies>"], NPC, 4257 };
		{ _RED.."5) "..AtlasLocale["Stormpike Aid Station"] };
		{ GREY.."6) "..AtlasLocale["Stormpike Stable Master <Stable Master>"], NPC, 13617 };
		{ GREY..INDENT..AtlasLocale["Stormpike Ram Rider Commander"], NPC, 13577 };
		{ GREY..INDENT..AtlasLocale["Svalbrad Farmountain <Trade Goods>"], NPC, 5135 };
		{ GREY..INDENT..AtlasLocale["Kurdrum Barleybeard <Reagents & Poison Supplies>"], NPC, 5139 };
		{ GREY.."7) "..AtlasLocale["Stormpike Quartermaster"], NPC, 12096 };
		{ GREY..INDENT..AtlasLocale["Jonivera Farmountain <General Goods>"], NPC, 5134 };
		{ GREY..INDENT..AtlasLocale["Brogus Thunderbrew <Food & Drink>"], NPC, 4255 };
		{ GREY.."8) "..AtlasLocale["Wing Commander Ichman"].." ("..AtlasLocale["Rescued"]..")", NPC, 13437 };
		{ GREY..INDENT..AtlasLocale["Wing Commander Slidore"].." ("..AtlasLocale["Rescued"]..")", NPC, 13438 };
		{ GREY..INDENT..AtlasLocale["Wing Commander Vipore"].." ("..AtlasLocale["Rescued"]..")", NPC, 13439 };
		{ ORNG.."9) "..AtlasLocale["Dun Baldar South Bunker"] };
		{ GREY..INDENT..AtlasLocale["Corporal Noreg Stormpike"], NPC, 13447 };
		{ GREY..INDENT..AtlasLocale["Gaelden Hammersmith <Stormpike Supply Officer>"], NPC, 13216 };
		{ _RED.."10) "..AtlasLocale["Stormpike Graveyard"] };
		{ GREY.."11) "..AtlasLocale["Icewing Cavern"] };
		{ GREY..INDENT..AtlasLocale["Stormpike Banner"], OBJECT, 179024 };
		{ GREY.."12) "..AtlasLocale["Stormpike Lumber Yard"] };
		{ GREY..INDENT..AtlasLocale["Wing Commander Jeztor"].." ("..AtlasLocale["Horde"]..")", NPC, 13180 };
		{ ORNG.."13) "..AtlasLocale["Icewing Bunker"] };
		{ GREY..INDENT..AtlasLocale["Wing Commander Guse"].." ("..AtlasLocale["Horde"]..")", NPC, 13179 };
		{ _RED.."14) "..AtlasLocale["Stonehearth Graveyard"] };
		{ GREY.."15) "..AtlasLocale["Stormpike Ram Rider Commander"], NPC, 13577 };
		{ ORNG.."16) "..AtlasLocale["Stonehearth Outpost"] };
		{ GREY..INDENT..AtlasLocale["Captain Balinda Stonehearth <Stormpike Captain>"], NPC, 11949 };
		{ _RED.."17) "..AtlasLocale["Snowfall Graveyard"] };
		{ GREY..INDENT..AtlasLocale["Ichman's Beacon"], ITEM, 17505 };
		{ GREY..INDENT..AtlasLocale["Mulverick's Beacon"].." ("..AtlasLocale["Horde"]..")", ITEM, 17323 };
		{ GREY..INDENT..AtlasLocale["Korrak the Bloodrager"], NPC, 12159 };
		{ ORNG.."18) "..AtlasLocale["Stonehearth Bunker"] };
		{ GREY.."19) "..AtlasLocale["Ivus the Forest Lord"].." ("..AtlasLocale["Summon"]..")", NPC, 13419 };
		{ GREY.."20) "..AtlasLocale["Western Crater"] };
		{ GREY..INDENT..AtlasLocale["Vipore's Beacon"], ITEM, 17506 };
		{ GREY..INDENT..AtlasLocale["Jeztor's Beacon"].." ("..AtlasLocale["Horde"]..")", ITEM, 17325 };
		{ GREY.."21) "..AtlasLocale["Eastern Crater"] };
		{ GREY..INDENT..AtlasLocale["Slidore's Beacon"], ITEM, 17507 };
		{ GREY..INDENT..AtlasLocale["Guse's Beacon"].." ("..AtlasLocale["Horde"]..")", ITEM, 17324 };
		{ GREY.."22) "..AtlasLocale["Steamsaw"].." ("..AtlasLocale["Horde"]..")", OBJECT, 178664 };
		{ "" };
		{ GREN..INDENT..AtlasLocale["Friendly Reputation Rewards"] };
		{ GREN..INDENT..AtlasLocale["Honored Reputation Rewards"] };
		{ GREN..INDENT..AtlasLocale["Revered Reputation Rewards"] };
		{ GREN..INDENT..AtlasLocale["Exalted Reputation Rewards"] };
		{ "" };
		{ _RED..AtlasLocale["Red"]..": ".._RED..AtlasLocale["Graveyards, Capturable Areas"] };
		{ ORNG..AtlasLocale["Orange"]..": "..ORNG..AtlasLocale["Bunkers, Towers, Destroyable Areas"] };
		{ GREY..AtlasLocale["White"]..": "..GREY..AtlasLocale["Assault NPCs, Quest Areas"] };
	};
	AlteracValleySouth = {
		ZoneName = { AtlasLocale["Alterac Valley"].." ("..AtlasLocale["South"]..")", 2597 };
		Acronym = AtlasLocale["AV"];
		Location = { AtlasLocale["Hillsbrad Foothills"], 36 };
		LevelRange = "51-60";
		MinLevel = "51";
		PlayerLimit = "40";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ ORNG..AtlasLocale["Rep"]..": "..AtlasLocale["Frostwolf Clan"], FACTION, 729 };
		{ BLUE.."A) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Horde"]..")" };
		{ BLUE.."B) "..AtlasLocale["Frostwolf Keep"] };
		{ BLUE..INDENT..AtlasLocale["Drek'Thar <Frostwolf General>"], NPC, 11946 };
		{ BLUE..INDENT..AtlasLocale["Duros"], NPC, 12122 };
		{ BLUE..INDENT..AtlasLocale["Drakan"], NPC, 12121 };
		{ BLUE..INDENT..AtlasLocale["West Frostwolf Warmaster"], NPC, 14777 };
		{ BLUE..INDENT..AtlasLocale["East Frostwolf Warmaster"], NPC, 14772 };
		{ BLUE..INDENT..AtlasLocale["Tower Point Warmaster"], NPC, 14776 };
		{ BLUE..INDENT..AtlasLocale["Iceblood Warmaster"], NPC, 14773 };
		{ BLUE..INDENT..AtlasLocale["Stonehearth Warmaster"], NPC, 14775 };
		{ BLUE..INDENT..AtlasLocale["Icewing Warmaster"], NPC, 14774 };
		{ BLUE..INDENT..AtlasLocale["Dun Baldar North Warmaster"], NPC, 14770 };
		{ BLUE..INDENT..AtlasLocale["Dun Baldar South Warmaster"], NPC, 14771 };
		{ GREY.."1) "..AtlasLocale["Lokholar the Ice Lord"].." ("..AtlasLocale["Summon"]..")", NPC, 13256 };
		{ ORNG.."2) "..AtlasLocale["Iceblood Garrison"] };
		{ GREY..INDENT..AtlasLocale["Captain Galvangar <Frostwolf Captain>"], NPC, 11947 };
		{ ORNG.."3) "..AtlasLocale["Iceblood Tower"] };
		{ _RED.."4) "..AtlasLocale["Iceblood Graveyard"] };
		{ GREY..INDENT..AtlasLocale["Wing Commander Ichman"].." ("..AtlasLocale["Alliance"]..")", NPC, 13437 };
		{ ORNG.."5) "..AtlasLocale["Tower Point"] };
		{ GREY..INDENT..AtlasLocale["Wing Commander Slidore"].." ("..AtlasLocale["Alliance"]..")", NPC, 13438 };
		{ GREY.."6) "..AtlasLocale["Coldtooth Mine"] };
		{ GREY..INDENT..AtlasLocale["Taskmaster Snivvle"].." ("..AtlasLocale["Neutral"]..")", NPC, 11677 };
		{ GREY..INDENT..AtlasLocale["Masha Swiftcut"].." ("..AtlasLocale["Horde"]..")", NPC, 13088 };
		{ GREY..INDENT..AtlasLocale["Aggi Rumblestomp"].." ("..AtlasLocale["Alliance"]..")", NPC, 13086 };
		{ _RED.."7) "..AtlasLocale["Frostwolf Graveyard"] };
		{ GREY.."8) "..AtlasLocale["Wing Commander Vipore"].." ("..AtlasLocale["Alliance"]..")", NPC, 13439 };
		{ GREY..INDENT..AtlasLocale["Jotek"], NPC, 13798 };
		{ GREY..INDENT..AtlasLocale["Smith Regzar"], NPC, 13176 };
		{ GREY..INDENT..AtlasLocale["Primalist Thurloga"], NPC, 13236 };
		{ GREY..INDENT..AtlasLocale["Sergeant Yazra Bloodsnarl"], NPC, 13448 };
		{ GREY.."9) "..AtlasLocale["Frostwolf Stable Master <Stable Master>"], NPC, 13616 };
		{ GREY..INDENT..AtlasLocale["Frostwolf Wolf Rider Commander"], NPC, 13441 };
		{ GREY.."10) "..AtlasLocale["Frostwolf Quartermaster"], NPC, 12097 };
		{ ORNG.."11) "..AtlasLocale["West Frostwolf Tower"] };
		{ ORNG.."12) "..AtlasLocale["East Frostwolf Tower"] };
		{ GREY.."13) "..AtlasLocale["Wing Commander Guse"].." ("..AtlasLocale["Rescued"]..")", NPC, 13179 };
		{ GREY..INDENT..AtlasLocale["Wing Commander Jeztor"].." ("..AtlasLocale["Rescued"]..")", NPC, 13180 };
		{ GREY..INDENT..AtlasLocale["Wing Commander Mulverick"].." ("..AtlasLocale["Rescued"]..")", NPC, 13181 };
		{ _RED.."14) "..AtlasLocale["Frostwolf Relief Hut"] };
		{ GREY.."15) "..AtlasLocale["Wildpaw Cavern"] };
		{ GREY..INDENT..AtlasLocale["Frostwolf Banner"], OBJECT, 179025 };
		{ GREY.."16) "..AtlasLocale["Steamsaw"].." ("..AtlasLocale["Alliance"]..")", OBJECT, 178665 };
		{ "" };
		{ GREN..INDENT..AtlasLocale["Friendly Reputation Rewards"] };
		{ GREN..INDENT..AtlasLocale["Honored Reputation Rewards"] };
		{ GREN..INDENT..AtlasLocale["Revered Reputation Rewards"] };
		{ GREN..INDENT..AtlasLocale["Exalted Reputation Rewards"] };
		{ "" };
		{ _RED..AtlasLocale["Red"]..": ".._RED..AtlasLocale["Graveyards, Capturable Areas"] };
		{ ORNG..AtlasLocale["Orange"]..": "..ORNG..AtlasLocale["Bunkers, Towers, Destroyable Areas"] };
		{ GREY..AtlasLocale["White"]..": "..GREY..AtlasLocale["Assault NPCs, Quest Areas"] };
	};
	ArathiBasin = {
		ZoneName = { AtlasLocale["Arathi Basin"], 3358 };
		Acronym = AtlasLocale["AB"];
		Location = { AtlasLocale["Arathi Highlands"], 45 };
		LevelRange = "20-60";
		MinLevel = "20";
		PlayerLimit = "15";
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ ORNG..AtlasLocale["Rep"]..": "..AtlasLocale["The Defilers"].." ("..AtlasLocale["Horde"]..")", FACTION, 510 };
		{ ORNG..AtlasLocale["Rep"]..": "..AtlasLocale["The League of Arathor"].." ("..AtlasLocale["Alliance"]..")", FACTION, 509 };
		{ BLUE.."A) "..AtlasLocale["Trollbane Hall"].." ("..AtlasLocale["Alliance"]..")" };
		{ BLUE.."B) "..AtlasLocale["Defiler's Den"].." ("..AtlasLocale["Horde"]..")" };
		{ GREY.."1) "..AtlasLocale["Stables"] };
		{ GREY.."2) "..AtlasLocale["Gold Mine"] };
		{ GREY.."3) "..AtlasLocale["Blacksmith"] };
		{ GREY.."4) "..AtlasLocale["Lumber Mill"] };
		{ GREY.."5) "..AtlasLocale["Farm"] };
		{ "" };
		{ GREN..INDENT..AtlasLocale["Friendly Reputation Rewards"] };
		{ GREN..INDENT..AtlasLocale["Honored Reputation Rewards"] };
		{ GREN..INDENT..AtlasLocale["Revered Reputation Rewards"] };
		{ GREN..INDENT..AtlasLocale["Exalted Reputation Rewards"] };
	};
	WarsongGulch = {
		ZoneName = { AtlasLocale["Warsong Gulch"], 3277 };
		Acronym = AtlasLocale["WSG"];
		Location = { AtlasLocale["Ashenvale"].." / "..AtlasLocale["The Barrens"], 331, 17 };
		LevelRange = "10-60";
		MinLevel = "10";
		PlayerLimit = "10";
		Continent = AtlasLocale["Kalimdor"];
		{ ORNG..AtlasLocale["Rep"]..": "..AtlasLocale["Warsong Outriders"].." ("..AtlasLocale["Horde"]..")", FACTION, 889 };
		{ ORNG..AtlasLocale["Rep"]..": "..AtlasLocale["Silverwing Sentinels"].." ("..AtlasLocale["Alliance"]..")", FACTION, 890 };
		{ BLUE.."A) "..AtlasLocale["Silverwing Hold"].." ("..AtlasLocale["Alliance"]..")" };
		{ BLUE.."B) "..AtlasLocale["Warsong Lumber Mill"].." ("..AtlasLocale["Horde"]..")" };
		{ "" };
		{ GREN..INDENT..AtlasLocale["Friendly Reputation Rewards"] };
		{ GREN..INDENT..AtlasLocale["Honored Reputation Rewards"] };
		{ GREN..INDENT..AtlasLocale["Revered Reputation Rewards"] };
		{ GREN..INDENT..AtlasLocale["Exalted Reputation Rewards"] };
	};
	DLEast = {
		ZoneName = { AtlasLocale["Dungeon Locations"].." ("..AtlasLocale["Eastern Kingdoms"]..")" };
		Location = { AtlasLocale["Eastern Kingdoms"] };
		Continent = AtlasLocale["Eastern Kingdoms"];
		{ BLUE.."A) "..AtlasLocale["Alterac Valley"]..", ".._RED..AtlasLocale["Alterac Mountains"].." / "..AtlasLocale["Hillsbrad Foothills"], ZONE, 2597, 36, 267 };
		{ BLUE.."B) "..AtlasLocale["Arathi Basin"]..", ".._RED..AtlasLocale["Arathi Highlands"], ZONE, 3358, 45 };
		{ GREY.."1) "..AtlasLocale["Scarlet Monastery"]..", ".._RED..AtlasLocale["Tirisfal Glades"], ZONE, 796, 85 };
		{ GREY.."2) "..AtlasLocale["Stratholme"]..", ".._RED..AtlasLocale["Eastern Plaguelands"], ZONE, 2017, 139 };
		{ GREY.."3) "..AtlasLocale["Naxxramas"]..", ".._RED..AtlasLocale["Eastern Plaguelands"], ZONE, 3456, 139 };
		{ GREY.."4) "..AtlasLocale["Scholomance"]..", ".._RED..AtlasLocale["Western Plaguelands"], ZONE, 2057, 28 };
		{ GREY.."5) "..AtlasLocale["Shadowfang Keep"]..", ".._RED..AtlasLocale["Silverpine Forest"], ZONE, 209, 130 };
		{ GREY.."6) "..AtlasLocale["Gnomeregan"]..", ".._RED..AtlasLocale["Dun Morogh"], ZONE, 133, 1 };
		{ GREY.."7) "..AtlasLocale["Uldaman"]..", ".._RED..AtlasLocale["Badlands"], ZONE, 1337, 3 };
		{ GREY.."8) "..AtlasLocale["Blackwing Lair"]..", ".._RED..AtlasLocale["Blackrock Spire"], ZONE, 2677, 1583 };
		{ GREY..INDENT..AtlasLocale["Blackrock Depths"]..", ".._RED..AtlasLocale["Blackrock Mountain"], ZONE, 1584, 25 };
		{ GREY..INDENT..AtlasLocale["Blackrock Spire"]..", ".._RED..AtlasLocale["Blackrock Mountain"], ZONE, 1583, 25 };
		{ GREY..INDENT..AtlasLocale["Molten Core"]..", ".._RED..AtlasLocale["Blackrock Depths"], ZONE, 2717, 1584 };
		{ GREY.."9) "..AtlasLocale["The Stockade"]..", ".._RED..AtlasLocale["Stormwind City"], ZONE, 717, 1519 };
		{ GREY.."10) "..AtlasLocale["The Deadmines"]..", ".._RED..AtlasLocale["Westfall"], ZONE, 1581, 40 };
		{ GREY.."11) "..AtlasLocale["Sunken Temple"]..", ".._RED..AtlasLocale["Swamp of Sorrows"], ZONE, 1417, 8 };
		{ GREY.."12) "..AtlasLocale["Zul'Gurub"]..", ".._RED..AtlasLocale["Stranglethorn Vale"], ZONE, 19, 33 };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ BLUE..AtlasLocale["Blue"]..": "..ORNG..AtlasLocale["Battlegrounds"] };
		{ GREY..AtlasLocale["White"]..": "..ORNG..AtlasLocale["Instances"] };
	};
	DLWest = {
		ZoneName = { AtlasLocale["Dungeon Locations"].." ("..AtlasLocale["Kalimdor"]..")" };
		Location = { AtlasLocale["Kalimdor"] };
		Continent = AtlasLocale["Kalimdor"];
		{ BLUE.."A) "..AtlasLocale["Warsong Gulch"]..", ".._RED..AtlasLocale["The Barrens"].." / "..AtlasLocale["Ashenvale"], ZONE, 3277, 17, 331 };
		{ GREY.."1) "..AtlasLocale["Blackfathom Deeps"]..", ".._RED..AtlasLocale["Ashenvale"], ZONE, 719, 331 };
		{ GREY.."2) "..AtlasLocale["Ragefire Chasm"]..", ".._RED..AtlasLocale["Orgrimmar"], ZONE, 2437, 1637 };
		{ GREY.."3) "..AtlasLocale["Wailing Caverns"]..", ".._RED..AtlasLocale["The Barrens"], ZONE, 718, 17 };
		{ GREY.."4) "..AtlasLocale["Maraudon"]..", ".._RED..AtlasLocale["Desolace"], ZONE, 2100, 405 };
		{ GREY.."5) "..AtlasLocale["Dire Maul"]..", ".._RED..AtlasLocale["Feralas"], ZONE, 2557, 357 };
		{ GREY.."6) "..AtlasLocale["Razorfen Kraul"]..", ".._RED..AtlasLocale["The Barrens"], ZONE, 491, 17 };
		{ GREY.."7) "..AtlasLocale["Razorfen Downs"]..", ".._RED..AtlasLocale["The Barrens"], ZONE, 722, 17 };
		{ GREY.."8) "..AtlasLocale["Onyxia's Lair"]..", ".._RED..AtlasLocale["Dustwallow Marsh"], ZONE, 2159, 15 };
		{ GREY.."9) "..AtlasLocale["Zul'Farrak"]..", ".._RED..AtlasLocale["Tanaris"], ZONE, 978, 440 };
		{ GREY.."10) "..AtlasLocale["Ruins of Ahn'Qiraj"]..", ".._RED..AtlasLocale["Silithus"], ZONE, 3429, 1377 };
		{ GREY..INDENT..AtlasLocale["Temple of Ahn'Qiraj"]..", ".._RED..AtlasLocale["Silithus"], ZONE, 3428, 1377 };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ BLUE..AtlasLocale["Blue"]..": "..ORNG..AtlasLocale["Battlegrounds"] };
		{ GREY..AtlasLocale["White"]..": "..ORNG..AtlasLocale["Instances"] };
	};
	FPAllianceEast = {
		ZoneName = { AtlasLocale["Alliance"].." ("..AtlasLocale["Eastern Kingdoms"]..")" };
		Location = { AtlasLocale["Eastern Kingdoms"] };
		{ GREY.."1) "..AtlasLocale["Light's Hope Chapel"]..", "..BLUE..AtlasLocale["Eastern Plaguelands"], ZONE, 139 };
		{ GREY.."2) "..AtlasLocale["Chillwind Point"]..", "..BLUE..AtlasLocale["Western Plaguelands"], ZONE, 28 };
		{ GREY.."3) "..AtlasLocale["Aerie Peak"]..", "..BLUE..AtlasLocale["The Hinterlands"], ZONE, 47 };
		{ GREY.."4) "..AtlasLocale["Southshore"]..", "..BLUE..AtlasLocale["Hillsbrad Foothills"], ZONE, 267 };
		{ GREY.."5) "..AtlasLocale["Refuge Pointe"]..", "..BLUE..AtlasLocale["Arathi Highlands"], ZONE, 45 };
		{ GREY.."6) "..AtlasLocale["Menethil Harbor"]..", "..BLUE..AtlasLocale["Wetlands"], ZONE, 11 };
		{ GREY.."7) "..AtlasLocale["Ironforge"]..", "..BLUE..AtlasLocale["Dun Morogh"], ZONE, 1 };
		{ GREY.."8) "..AtlasLocale["Thelsamar"]..", "..BLUE..AtlasLocale["Loch Modan"], ZONE, 38 };
		{ GREY.."9) "..AtlasLocale["Thorium Point"]..", "..BLUE..AtlasLocale["Searing Gorge"], ZONE, 51 };
		{ GREY.."10) "..AtlasLocale["Morgan's Vigil"]..", "..BLUE..AtlasLocale["Burning Steppes"], ZONE, 46 };
		{ GREY.."11) "..AtlasLocale["Stormwind City"]..", "..BLUE..AtlasLocale["Elwynn Forest"], ZONE, 12 };
		{ GREY.."12) "..AtlasLocale["Lakeshire"]..", "..BLUE..AtlasLocale["Redridge Mountains"], ZONE, 44 };
		{ GREY.."13) "..AtlasLocale["Sentinel Hill"]..", "..BLUE..AtlasLocale["Westfall"], ZONE, 40 };
		{ GREY.."14) "..AtlasLocale["Darkshire"]..", "..BLUE..AtlasLocale["Duskwood"], ZONE, 10 };
		{ GREY.."15) "..AtlasLocale["Nethergarde Keep"]..", "..BLUE..AtlasLocale["Blasted Lands"], ZONE, 4 };
		{ GREY.."16) "..AtlasLocale["Booty Bay"]..", "..BLUE..AtlasLocale["Stranglethorn Vale"], ZONE, 33 };
	};
	FPAllianceWest = {
		ZoneName = { AtlasLocale["Alliance"].." ("..AtlasLocale["Kalimdor"]..")" };
		Location = { AtlasLocale["Kalimdor"] };
		{ GREY.."1) "..AtlasLocale["Rut'Theran Village"]..", "..BLUE..AtlasLocale["Teldrassil"], ZONE, 141 };
		{ GREY.."2) "..GREN..AtlasLocale["Nighthaven"]..GREY..", "..BLUE..AtlasLocale["Moonglade"]..GREN.." ("..AtlasLocale["Druid-only"]..")", ZONE, 493 };
		{ GREY..INDENT..AtlasLocale["South of the path along Lake Elune'ara"]..", "..BLUE..AtlasLocale["Moonglade"], ZONE, 493 };
		{ GREY.."3) "..AtlasLocale["Everlook"]..", "..BLUE..AtlasLocale["Winterspring"], ZONE, 618 };
		{ GREY.."4) "..AtlasLocale["Auberdine"]..", "..BLUE..AtlasLocale["Darkshore"], ZONE, 148 };
		{ GREY.."5) "..AtlasLocale["Talonbranch Glade"]..", "..BLUE..AtlasLocale["Felwood"], ZONE, 361 };
		{ GREY.."6) "..AtlasLocale["Stonetalon Peak"]..", "..BLUE..AtlasLocale["Stonetalon Mountains"], ZONE, 406 };
		{ GREY.."7) "..AtlasLocale["Astranaar"]..", "..BLUE..AtlasLocale["Ashenvale"], ZONE, 331 };
		{ GREY.."8) "..AtlasLocale["Talrendis Point"]..", "..BLUE..AtlasLocale["Azshara"], ZONE, 16 };
		{ GREY.."9) "..AtlasLocale["Nijel's Point"]..", "..BLUE..AtlasLocale["Desolace"], ZONE, 405 };
		{ GREY.."10) "..AtlasLocale["Ratchet"]..", "..BLUE..AtlasLocale["The Barrens"], ZONE, 17 };
		{ GREY.."11) "..AtlasLocale["Theramore Isle"]..", "..BLUE..AtlasLocale["Dustwallow Marsh"], ZONE, 15 };
		{ GREY.."12) "..AtlasLocale["Feathermoon Stronghold"]..", "..BLUE..AtlasLocale["Feralas"], ZONE, 357 };
		{ GREY.."13) "..AtlasLocale["Thalanaar"]..", "..BLUE..AtlasLocale["Feralas"], ZONE, 357 };
		{ GREY.."14) "..AtlasLocale["Marshal's Refuge"]..", "..BLUE..AtlasLocale["Un'Goro Crater"], ZONE, 490 };
		{ GREY.."15) "..AtlasLocale["Cenarion Hold"]..", "..BLUE..AtlasLocale["Silithus"], ZONE, 1377 };
		{ GREY.."16) "..AtlasLocale["Gadgetzan"]..", "..BLUE..AtlasLocale["Tanaris"], ZONE, 440 };
	};
	FPHordeEast = {
		ZoneName = { AtlasLocale["Horde"].." ("..AtlasLocale["Eastern Kingdoms"]..")" };
		Location = { AtlasLocale["Eastern Kingdoms"] };
		{ GREY.."1) "..AtlasLocale["Light's Hope Chapel"]..", ".._RED..AtlasLocale["Eastern Plaguelands"], ZONE, 139 };
		{ GREY.."2) "..AtlasLocale["Undercity"]..", ".._RED..AtlasLocale["Tirisfal Glades"], ZONE, 85 };
		{ GREY.."3) "..AtlasLocale["The Sepulcher"]..", ".._RED..AtlasLocale["Silverpine Forest"], ZONE, 130 };
		{ GREY.."4) "..AtlasLocale["Tarren Mill"]..", ".._RED..AtlasLocale["Hillsbrad Foothills"], ZONE, 267 };
		{ GREY.."5) "..AtlasLocale["Revantusk Village"]..", ".._RED..AtlasLocale["The Hinterlands"], ZONE, 47 };
		{ GREY.."6) "..AtlasLocale["Hammerfall"]..", ".._RED..AtlasLocale["Arathi Highlands"], ZONE, 45 };
		{ GREY.."7) "..AtlasLocale["Thorium Point"]..", ".._RED..AtlasLocale["Searing Gorge"], ZONE, 51 };
		{ GREY.."8) "..AtlasLocale["Kargath"]..", ".._RED..AtlasLocale["Badlands"], ZONE, 3 };
		{ GREY.."9) "..AtlasLocale["Flame Crest"]..", ".._RED..AtlasLocale["Burning Steppes"], ZONE, 46 };
		{ GREY.."10) "..AtlasLocale["Stonard"]..", ".._RED..AtlasLocale["Swamp of Sorrows"], ZONE, 8 };
		{ GREY.."11) "..AtlasLocale["Grom'Gol Base Camp"]..", ".._RED..AtlasLocale["Stranglethorn Vale"], ZONE, 33 };
		{ GREY.."12) "..AtlasLocale["Booty Bay"]..", ".._RED..AtlasLocale["Stranglethorn Vale"], ZONE, 33 };
	};
	FPHordeWest = {
		ZoneName = { AtlasLocale["Horde"].." ("..AtlasLocale["Kalimdor"]..")" };
		Location = { AtlasLocale["Kalimdor"] };
		{ GREY.."1) "..GREN..AtlasLocale["Nighthaven"]..GREY..", ".._RED..AtlasLocale["Moonglade"]..GREN.." ("..AtlasLocale["Druid-only"]..")", ZONE, 493 };
		{ GREY..INDENT..AtlasLocale["West of the path to Timbermaw Hold"]..", ".._RED..AtlasLocale["Moonglade"], ZONE, 493 };
		{ GREY.."2) "..AtlasLocale["Everlook"]..", ".._RED..AtlasLocale["Winterspring"], ZONE, 618 };
		{ GREY.."3) "..AtlasLocale["Bloodvenom Post"]..", ".._RED..AtlasLocale["Felwood"], ZONE, 361 };
		{ GREY.."4) "..AtlasLocale["Zoram'gar Outpost"]..", ".._RED..AtlasLocale["Ashenvale"], ZONE, 331 };
		{ GREY.."5) "..AtlasLocale["Valormok"]..", ".._RED..AtlasLocale["Azshara"], ZONE, 16 };
		{ GREY.."6) "..AtlasLocale["Splintertree Post"]..", ".._RED..AtlasLocale["Ashenvale"], ZONE, 331 };
		{ GREY.."7) "..AtlasLocale["Orgrimmar"]..", ".._RED..AtlasLocale["Durotar"], ZONE, 14 };
		{ GREY.."8) "..AtlasLocale["Sun Rock Retreat"]..", ".._RED..AtlasLocale["Stonetalon Mountains"], ZONE, 406 };
		{ GREY.."9) "..AtlasLocale["Crossroads"]..", ".._RED..AtlasLocale["The Barrens"], ZONE, 17 };
		{ GREY.."10) "..AtlasLocale["Ratchet"]..", ".._RED..AtlasLocale["The Barrens"], ZONE, 17 };
		{ GREY.."11) "..AtlasLocale["Shadowprey Village"]..", ".._RED..AtlasLocale["Desolace"], ZONE, 405 };
		{ GREY.."12) "..AtlasLocale["Thunder Bluff"]..", ".._RED..AtlasLocale["Mulgore"], ZONE, 215 };
		{ GREY.."13) "..AtlasLocale["Camp Taurajo"]..", ".._RED..AtlasLocale["The Barrens"], ZONE, 17 };
		{ GREY.."14) "..AtlasLocale["Brackenwall Village"]..", ".._RED..AtlasLocale["Dustwallow Marsh"], ZONE, 15 };
		{ GREY.."15) "..AtlasLocale["Camp Mojache"]..", ".._RED..AtlasLocale["Feralas"], ZONE, 357 };
		{ GREY.."16) "..AtlasLocale["Freewind Post"]..", ".._RED..AtlasLocale["Thousand Needles"], ZONE, 400 };
		{ GREY.."17) "..AtlasLocale["Marshal's Refuge"]..", ".._RED..AtlasLocale["Un'Goro Crater"], ZONE, 490 };
		{ GREY.."18) "..AtlasLocale["Cenarion Hold"]..", ".._RED..AtlasLocale["Silithus"], ZONE, 1377 };
		{ GREY.."19) "..AtlasLocale["Gadgetzan"]..", ".._RED..AtlasLocale["Tanaris"], ZONE, 440 };
	};
};