﻿--[[
constants.en.lua
This file defines an AceLocale table for all the various text strings needed
by AtlasLoot.  In this implementation, if a translation is missing, it will fall
back to the English translation.

The ["text"] = true; shortcut can ONLY be used for English (the root translation).
]]

--Table for all data to be inserted into.  Included here as it is the first file loaded
AtlasLoot_Data = {};

--Create the library instance
local AL = AceLibrary("AceLocale-2.2"):new("AtlasLoot");

--Allow reporting of what translations are missing
AL:EnableDebugging();

--Allow the language to be changed dynamically for debugging purposes
AL:EnableDynamicLocales();

--Register translations
AL:RegisterTranslations("enUS", function() return {
	["AtlasLoot"] = true,
	["Atlas"] = true,
	["AtlasLoot Enhanced"] = true,
	["No match found for"] = true,
	["Search"] = true,
	["Clear"] = true,
	["Select Loot Table"] = true,
	["Select Sub-Table"] = true,
	["Drop Rate: "] = true,
	["DKP"] = true,
	["Priority:"] = true,
	["Click boss name to view loot."] = true,
	["ALT+Click to use WishList."] = true,
	["Left-click to open AtlasLoot.\nMiddle-click for AtlasLoot options.\nRight-click and drag to move this button."] = true,
	["Various Locations"] = true,
	["This is a loot browser only.  To view maps as well, install either Atlas or Alphamap."] = true,
	["Toggle AL Panel"] = true,
	[" is safe."] = true,
	["Server queried for "] = true,
	[".  Right click on any other item to refresh the loot page."] = true,
	["Level 60"] = true,
	["|cffff0000(unsafe)"] = true,
	["Misc"] = true,
	["Test"] = true,
	["Rewards"] = true,
	["Raid"] = true,
	["Choose Table ..."] = true,
	["Close Menu"] = true,
	["Unknown"] = true,
	["Skill:"] = true,
	["Level:"] = true,
	["QuickLook"] = true,
	["Add to QuickLooks:"] = true,
	["Assign this loot table\n to QuickLook"] = true,
	["Query Server"] = true,
	["Classic Instances"] = true,
	["Dungeons & Raids"] = true,
	["Button Position"] = true,
	["Button Radius"] = true,
	["Reset Position"] = true,
	["Minimap button has been reset!"] = true,
	["has been reset!"] = true,
	["|cff9d9d9dALT+Click to clear|r"] = true,
	["Atlasloot Options"] = true,
	["Safe Chat Links |cff1eff00(recommended)|r"] = true,
	["Enable all Chat Links |cffff0000(use at own risk)|r"] = true,
	["Default Tooltips"] = true,
	["Lootlink Tooltips"] = true,
	["|cff9d9d9dLootlink Tooltips|r"] = true,
	["ItemSync Tooltips"] = true,
	["|cff9d9d9dItemSync Tooltips|r"] = true,
	["Use EquipCompare"] = true,
	["|cff9d9d9dUse EquipCompare|r"] = true,
	["Make Loot Table Opaque"] = true,
	["Show IDs at all times"] = true,
	["Hide AtlasLoot Panel"] = true,
	["Show Minimap Button"] = true,
	["Set Minimap Button Position"] = true,
	["Suppress text spam when querying items"] = true,
	["AutoQuery items on loot tables |cffff0000(disconnection risk)|r"] = true,
	["Uncached"] = true,
	["Done"] = true,
	["WishList"] = true,
	["Search Result: %s"] = true,
	["Last Result"] = true,
	["Search on"] = true,
	["All modules"] = true,
	["If checked, AtlasLoot will load and search across all the modules."] = true,
	["Search options"] = true,
	["Partial matching"] = true,
	["If checked, AtlasLoot searches item names for a partial match."] = true,
	["You don't have any module selected to search on!"] = true,
	["Queries the server for all items"] = true,
	["on this page. The items will be"] = true,
	["refreshed when you next mouse"] = true,
	["over them."] = true,
	["reset"] = true,
	["default"] = true,
	["panel"] = true,
	["options"] = true,
	["Reset complete!"] = true,
	["Default settings applied!"] = true,
	["Default Settings"] = true,
	["AtlasLoot Error!"] = true,
	["WishList Full!"] = true,
	["To cast "] = true,
	[" the following items are needed:"] = true,
	[" you need this: "] = true,
	["To craft "] = true,
	[" the following reagents are needed:"] = true,
	[" added to the WishList."] = true,
	[" already in the WishList!"] = true,
	[" deleted from the WishList."] = true,
	[" not listed in loot table registry, please report this message to the AtlasLoot forums at http://www.atlasloot.net"] = true,
	[" is unavailable, the following load on demand module is required: "] = true,
	["Status of the following module could not be determined: "] = true,
	[" could not be accessed, the following module may be out of date: "] = true,
	["sucessfully loaded."] = true,
	["Loading available tables for searching"] = true,
	["All Available Modules Loaded"] = true,
	["|cff1eff00Left-Click|r Browse Loot Tables"] = true,
	["|cffff0000Right-Click|r View Options"] = true,
	["|cffff0000Shift-Click|r View Options"] = true,
	["|cffccccccRight-Click + Drag|r Move Minimap Button"] = true,
	["Options"] = true,
	["Collections"] = true,
	["Factions"] = true,
	["World Events"] = true,
	["Load Modules"] = true,
	["Crafting"] = true,
	["Crafted Sets - Blacksmithing"] = true,
	["Crafted Sets - Tailoring"] = true,
	["Crafted Sets - Leatherworking"] = true,
	["Welcome to Atlasloot Enhanced.  Please take a moment to set your preferences."] = true,
	["New feature in 4.02.01: Type '/atlasloot options' to bring up the options menu and '/atlasloot reset' to reset AtlasLoot after a disconnect."] = true,
	["New feature in 4.03.00: Introducing the Wishlist!  Simply alt-click on any item to add it to the wishlist.  To delete an item from the wishlist, open up your wishlist and alt-click the item to remove it.  It's that simple.  Buttons to view the wishlist have been added to the Atlas interface and the loot browser."] = true,
	["New feature in 4.05.00: Advanced searching functionality is now available. You can type in a partial item name, for example typing 'elixir' gives all items in the database with 'elixir' in the name.  Big thanks to Kurax for his help."] = true,
	["New feature in 4.05.00: All professions are now included in the AtlasLoot_Crafting module."] = true,
	["Welcome to Atlasloot Enhanced.  Please take a moment to set your preferences for tooltips and links in the chat window.\n\n  This options screen can be reached again at any later time by typing '/atlasloot'."] = true,
	["Setup"] = true,
	["It has been detected that your version of Atlas does not match the version that Atlasloot is tuned for ("] = true,
	[").  Depending on changes, there may be the occasional error, so please visit http://www.atlasmod.com as soon as possible to update."] = true,
	["OK"] = true,
	["Incompatible Atlas Detected"] = true,
	["Unsafe Item"] = true,
	["Item Unavailable"] = true,
	["ItemID:"] = true,
	["SpellID:"] = true,
	["This item is not available on your server or your battlegroup yet."] = true,
	["This item is unsafe.  To view this item without the risk of disconnection, you need to have first seen it in the game world. This is a restriction enforced by Blizzard since Patch 1.10."] = true,
	["You can right-click to attempt to query the server.  You may be disconnected."] = true,
	["Mount"] = true,
	["Enchant"] = true,
	["Trade Goods"] = true,
	["Scope"] = true,
	["Pet"] = true,
	["Darkmoon Faire Card"] = true,
	["Book"] = true,
	["Banner"] = true,
	["Set"] = true,
	["Set: "] = true,
	["Token"] = true,
	["Token Hand-Ins"] = true,
	["Crafting Reagent"] = true,
	["Skinning Knife"] = true,
	["Herbalism Knife"] = true,
	["Fish"] = true,
	["Combat Pet"] = true,
	["Fireworks"] = true,
	["Cloak"] = true,
	["Weapons"] = true,
	["Classes"] = true,
	["This Item Begins a Quest"] = true,
	["Quest Item"] = true,
	["Quest Reward"] = true,
	["Shared"] = true,
	["Unique"] = true,
	["Right Half"] = true,
	["Left Half"] = true,
	["28 Slot Soul Shard"] = true,
	["28 Slot Soul"] = true,
	["24 Slot"] = true,
	["20 Slot"] = true,
	["18 Slot"] = true,
	["16 Slot"] = true,
	["10 Slot"] = true,
	["(185)"] = true,
	["(160)"] = true,
	["(300)"] = true,
	["(295)"] = true,
	["(290)"] = true,
	["(285)"] = true,
	["(275)"] = true,
	["(265)"] = true,
	["(200)"] = true,
	["(125)"] = true,
	["(1)"] = true,
	["Schematic: Field Repair Bot 74A"] = true,
	["Container"] = true,
	["Blacksmithing Plans"] = true,
	["Consumable"] = true,
	["(has random enchantment)"] = true,
	["Needed to purchase rewards"] = true,
	["Use to purchase rewards"] = true,
	["Use to purchase rewards (Horde)"] = true,
	["Use to purchase rewards (Alliance)"] = true,
	["World Bosses"] = true,
	["Reputation Factions"] = true,
	["Sets/Collections"] = true,
	["Card Game Item"] = true,
	["Tier 1"] = true,
	["Tier 2"] = true,
	["Tier 3"] = true,
	["Conjured Item"] = true,
	["Used to summon boss"] = true,
	["Coin"] = true,
	["Bijou"] = true,
	["Doll"] = true,
	["Phase 1"] = true,
	["Phase 2"] = true,
	["Phase 3"] = true,
	["Fire"] = true,
	["Water"] = true,
	["Wind"] = true,
	["Earth"] = true,
	["Air"] = true,
	["Warpwood Pod"] = true,
	["Scarab Coffer"] = true,
	["Greater Scarab Coffer"] = true,
	["Master Angler"] = true,
	["First Prize"] = true,
	["Rare Fish Rewards"] = true,
	["Rare Fish"] = true,
	["Rare"] = true,
	["random stats"] = true,
	["random resistance"] = true,
	["random color"] = true,
	["<Right Click to Open>"] = true,
	["Heroic"] = true,
	["Summon"] = true,
	["Random"] = true,
	["Weapons"] = true,
	["Misc. Rewards"] = true,
	["Superior Rewards"] = true,
	["Epic Rewards"] = true,
	["Level 10-19 Rewards"] = true,
	["Level 20-29 Rewards"] = true,
	["Level 30-39 Rewards"] = true,
	["Level 40-49 Rewards"] = true,
	["Level 50-59 Rewards"] = true,
	["Level 60 Rewards"] = true,
	["Path of the Conqueror"] = true,
	["Path of the Invoker"] = true,
	["Path of the Protector"] = true,
	["Scourge Invasion Bosses"] = true,
	["Dragonscale"] = true,
	["Tribal"] = true,
	["Elemental"] = true,
	["Lockpicking"] = true,
	["Red Scepter Shard"] = true,
	["Blue Scepter Shard"] = true,
	["Green Scepter Shard"] = true,
	["Scepter of the Shifting Sands"] = true,
	["Primal Hakkari Kossack"] = true,
	["Primal Hakkari Shawl"] = true,
	["Primal Hakkari Bindings"] = true,
	["Primal Hakkari Sash"] = true,
	["Primal Hakkari Stanchion"] = true,
	["Primal Hakkari Aegis"] = true,
	["Primal Hakkari Girdle"] = true,
	["Primal Hakkari Armsplint"] = true,
	["Primal Hakkari Tabard"] = true,
	["Qiraji Ornate Hilt"] = true,
	["Qiraji Martial Drape"] = true,
	["Qiraji Magisterial Ring"] = true,
	["Qiraji Ceremonial Ring"] = true,
	["Qiraji Regal Drape"] = true,
	["Qiraji Spiked Hilt"] = true,
	["Qiraji Bindings of Dominance"] = true,
	["Qiraji Bindings of Command"] = true,
	["Vek'nilash's Circlet"] = true,
	["Vek'lor's Diadem"] = true,
	["Ouro's Intact Hide"] = true,
	["Skin of the Great Sandworm"] = true,
	["Husk of the Old God"] = true,
	["Carapace of the Old God"] = true,
	["Imperial Plate"] = true,
	["The Darksoul"] = true,
	["Fel Iron Plate"] = true,
	["Adamantite Battlegear"] = true,
	["Flame Guard"] = true,
	["Enchanted Adamantite Armor"] = true,
	["Khorium Ward"] = true,
	["Faith in Felsteel"] = true,
	["Burning Rage"] = true,
	["Bloodsoul Embrace"] = true,
	["Fel Iron Chain"] = true,
	["Bloodvine Garb"] = true,
	["Netherweave Vestments"] = true,
	["Imbued Netherweave"] = true,
	["Arcanoweave Vestments"] = true,
	["The Unyielding"] = true,
	["Whitemend Wisdom"] = true,
	["Spellstrike Infusion"] = true,
	["Battlecast Garb"] = true,
	["Soulcloth Embrace"] = true,
	["Primal Mooncloth"] = true,
	["Shadow's Embrace"] = true,
	["Wrath of Spellfire"] = true,
	["Volcanic Armor"] = true,
	["Ironfeather Armor"] = true,
	["Stormshroud Armor"] = true,
	["Devilsaur Armor"] = true,
	["Blood Tiger Harness"] = true,
	["Primal Batskin"] = true,
	["Wild Draenish Armor"] = true,
	["Thick Draenic Armor"] = true,
	["Fel Skin"] = true,
	["Strength of the Clefthoof"] = true,
	["Green Dragon Mail"] = true,
	["Blue Dragon Mail"] = true,
	["Black Dragon Mail"] = true,
	["Scaled Draenic Armor"] = true,
	["Felscale Armor"] = true,
	["Felstalker Armor"] = true,
	["Fury of the Nether"] = true,
	["Primal Intent"] = true,
	["Windhawk Armor"] = true,
	["Netherscale Armor"] = true,
	["Netherstrike Armor"] = true,
	["Defias Leather"] = true,
	["Embrace of the Viper"] = true,
	["Chain of the Scarlet Crusade"] = true,
	["The Gladiator"] = true,
	["Ironweave Battlesuit"] = true,
	["Necropile Raiment"] = true,
	["Cadaverous Garb"] = true,
	["Bloodmail Regalia"] = true,
	["Deathbone Guardian"] = true,
	["The Postmaster"] = true,
	["Scourge Invasion"] = true,
	["Regalia of Undead Cleansing"] = true,
	["Undead Slayer's Armor"] = true,
	["Garb of the Undead Slayer"] = true,
	["Battlegear of Undead Slaying"] = true,
	["Shard of the Gods"] = true,
	["Zul'Gurub Rings"] = true,
	["Major Mojo Infusion"] = true,
	["Overlord's Resolution"] = true,
	["Prayer of the Primal"] = true,
	["Zanzil's Concentration"] = true,
	["Spirit of Eskhandar"] = true,
	["The Twin Blades of Hakkari"] = true,
	["Primal Blessing"] = true,
	["Dal'Rend's Arms"] = true,
	["Spider's Kiss"] = true,
	["Haruspex's Garb"] = true,
	["Predator's Armor"] = true,
	["Illusionist's Attire"] = true,
	["Freethinker's Armor"] = true,
	["Confessor's Raiment"] = true,
	["Madcap's Outfit"] = true,
	["Augur's Regalia"] = true,
	["Demoniac's Threads"] = true,
	["Vindicator's Battlegear"] = true,
	["Symbols of Unending Life"] = true,
	["Trappings of the Unseen Path"] = true,
	["Trappings of Vaulted Secrets"] = true,
	["Battlegear of Eternal Justice"] = true,
	["Finery of Infinite Wisdom"] = true,
	["Emblems of Veiled Shadows"] = true,
	["Gift of the Gathering Storm"] = true,
	["Implements of Unspoken Names"] = true,
	["Battlegear of Unyielding Strength"] = true,
	["Genesis Raiment"] = true,
	["Striker's Garb"] = true,
	["Enigma Vestments"] = true,
	["Avenger's Battlegear"] = true,
	["Garments of the Oracle"] = true,
	["Deathdealer's Embrace"] = true,
	["Stormcaller's Garb"] = true,
	["Doomcaller's Attire"] = true,
	["Conqueror's Battlegear"] = true,
	["Wildheart Raiment"] = true,
	["Beaststalker Armor"] = true,
	["Magister's Regalia"] = true,
	["Lightforge Armor"] = true,
	["Vestments of the Devout"] = true,
	["Shadowcraft Armor"] = true,
	["The Elements"] = true,
	["Dreadmist Raiment"] = true,
	["Battlegear of Valor"] = true,
	["Feralheart Raiment"] = true,
	["Beastmaster Armor"] = true,
	["Sorcerer's Regalia"] = true,
	["Soulforge Armor"] = true,
	["Vestments of the Virtuous"] = true,
	["Darkmantle Armor"] = true,
	["The Five Thunders"] = true,
	["Deathmist Raiment"] = true,
	["Battlegear of Heroism"] = true,
	["Cenarion Raiment"] = true,
	["Giantstalker Armor"] = true,
	["Arcanist Regalia"] = true,
	["Lawbringer Armor"] = true,
	["Vestments of Prophecy"] = true,
	["Nightslayer Armor"] = true,
	["The Earthfury"] = true,
	["Felheart Raiment"] = true,
	["Battlegear of Might"] = true,
	["Stormrage Raiment"] = true,
	["Dragonstalker Armor"] = true,
	["Netherwind Regalia"] = true,
	["Judgement Armor"] = true,
	["Vestments of Transcendence"] = true,
	["Bloodfang Armor"] = true,
	["The Ten Storms"] = true,
	["Nemesis Raiment"] = true,
	["Battlegear of Wrath"] = true,
	["Dreamwalker Raiment"] = true,
	["Cryptstalker Armor"] = true,
	["Frostfire Regalia"] = true,
	["Redemption Armor"] = true,
	["Vestments of Faith"] = true,
	["Bonescythe Armor"] = true,
	["The Earthshatterer"] = true,
	["Plagueheart Raiment"] = true,
	["Dreadnaught's Battlegear"] = true,
	["The Highlander's Intent"] = true,
	["The Highlander's Purpose"] = true,
	["The Highlander's Will"] = true,
	["The Highlander's Determination"] = true,
	["The Highlander's Fortitude"] = true,
	["The Highlander's Resolution"] = true,
	["The Highlander's Resolve"] = true,
	["The Defiler's Intent"] = true,
	["The Defiler's Purpose"] = true,
	["The Defiler's Will"] = true,
	["The Defiler's Determination"] = true,
	["The Defiler's Fortitude"] = true,
	["The Defiler's Resolution"] = true,
	["Lieutenant Commander's Refuge"] = true,
	["Lieutenant Commander's Pursuance"] = true,
	["Lieutenant Commander's Arcanum"] = true,
	["Lieutenant Commander's Redoubt"] = true,
	["Lieutenant Commander's Investiture"] = true,
	["Lieutenant Commander's Guard"] = true,
	["Lieutenant Commander's Stormcaller"] = true,
	["Lieutenant Commander's Dreadgear"] = true,
	["Lieutenant Commander's Battlearmor"] = true,
	["Champion's Refuge"] = true,
	["Champion's Pursuance"] = true,
	["Champion's Arcanum"] = true,
	["Champion's Redoubt"] = true,
	["Champion's Investiture"] = true,
	["Champion's Guard"] = true,
	["Champion's Stormcaller"] = true,
	["Champion's Dreadgear"] = true,
	["Champion's Battlearmor"] = true,
	["Field Marshal's Sanctuary"] = true,
	["Field Marshal's Pursuit"] = true,
	["Field Marshal's Regalia"] = true,
	["Field Marshal's Aegis"] = true,
	["Field Marshal's Raiment"] = true,
	["Field Marshal's Vestments"] = true,
	["Field Marshal's Earthshaker"] = true,
	["Field Marshal's Threads"] = true,
	["Field Marshal's Battlegear"] = true,
	["Warlord's Sanctuary"] = true,
	["Warlord's Pursuit"] = true,
	["Warlord's Regalia"] = true,
	["Warlord's Aegis"] = true,
	["Warlord's Raiment"] = true,
	["Warlord's Vestments"] = true,
	["Warlord's Earthshaker"] = true,
	["Warlord's Threads"] = true,
	["Warlord's Battlegear"] = true,
	["Set: Embrace of the Viper"] = true,
	["Set: Defias Leather"] = true,
	["Set: The Gladiator"] = true,
	["Set: Chain of the Scarlet Crusade"] = true,
	["Set: The Postmaster"] = true,
	["Set: Necropile Raiment"] = true,
	["Set: Cadaverous Garb"] = true,
	["Set: Bloodmail Regalia"] = true,
	["Set: Deathbone Guardian"] = true,
	["Set: Dal'Rend's Arms"] = true,
	["Set: Spider's Kiss"] = true,
	["Temple of Ahn'Qiraj Sets"] = true,
	["AQ40 Class Sets"] = true,
	["Ruins of Ahn'Qiraj Sets"] = true,
	["AQ20 Class Sets"] = true,
	["AQ Enchants"] = true,
	["AQ Opening Quest Chain"] = true,
	["Pre 60 Sets"] = true,
	["Crafted Sets"] = true,
	["Crafted Epic Weapons"] = true,
	["Zul'Gurub Sets"] = true,
	["ZG Class Sets"] = true,
	["ZG Enchants"] = true,
	["Dungeon 1/2 Sets"] = true,
	["Dungeon Set 1"] = true,
	["Dungeon Set 1"] = true,
	["Dungeon 1 Set"] = true,
	["Dungeon 2 Set"] = true,
	["D2 Summonable"] = true,
	["Tier 1 Sets"] = true,
	["Tier 2 Sets"] = true,
	["Tier 3 Sets"] = true,
	["PvP Sets"] = true,
	["PvP Rewards (Level 60)"] = true,
	["PvP Accessories (Level 60)"] = true,
	["PvP Accessories - Alliance"] = true,
	["PvP Accessories - Horde"] = true,
	["PvP Rewards"] = true,
	["PvP Armor Sets"] = true,
	["PvP Weapons"] = true,
	["PvP Weapons (Level 60)"] = true,
	["PvP Accessories"] = true,
	["PvP Honor System"] = true,
	["PvP Reputation Sets"] = true,
	["Arathi Basin Sets"] = true,
	["Class Books"] = true,
	["Tribute Run"] = true,
	["Dire Maul Books"] = true,
	["Random Boss Loot"] = true,
	["Class Set Pieces"] = true,
	["Epic Set"] = true,
	["Rare Set"] = true,
	["Legendary Items"] = true,
	["Artifact Items"] = true,
	["Accesories and Weapons"] = true,
	["Accessories"] = true,
	["Armor and Weapons"] = true,
	["Fire Resistance Gear"] = true,
	["Arcane Resistance Gear"] = true,
	["Nature Resistance Gear"] = true,
	["Frost Resistance Gear"] = true,
	["Shadow Resistance Gear"] = true,
	["Rare Pets"] = true,
	["Rare Mounts"] = true,
	["Old Mounts"] = true,
	["PvP Mounts"] = true,
	["Unobtainable Mounts"] = true,
	["Tabards"] = true,
	["BoE World Epics"] = true,
	["BoE World Blues"] = true,
	["World Epics"] = true,
	["World Blues"] = true,
	["Level 10-19"] = true,
	["Level 20-29"] = true,
	["Level 30-39"] = true,
	["Level 40-49"] = true,
	["Level 50-60"] = true,
	["Trash Mobs"] = true,
	["Dungeon Set 2 Summonable"] = true,
	["Theldren"] = true,
	["Sothos and Jarien"] = true,
	["Druid of the Fang"] = true,
	["Defias Strip Miner"] = true,
	["Defias Pirate"] = true,
	["Overseer/Taskmaster"] = true,
	["Prisoner/Insurgent/Convict"] = true,
	["Defender"] = true,
	["Protector"] = true,
	["Myrmidon"] = true,
	["Champion"] = true,
	["Centurion"] = true,
	["Guardsman"] = true,
	["Scarlet Trainee"] = true,
	["Plagued Hatchling"] = true,
	["Herod/Mograine"] = true,
	["Scarlet Protector/Guardsman"] = true,
	["Shadowforge Flame Keeper"] = true,
	["Hammered Patron"] = true,
	["Scarshield Warlock"] = true,
	["Olaf"] = true,
	["Eric 'The Swift'"] = true,
	["The Sunken Temple"] = true,
	["Spawn of Hakkar"] = true,
	["Balcony Minibosses"] = true,
	["Shadow of Doom"] = true,
	["Bone Witch"] = true,
	["Lumbering Horror"] = true,
	["Unchained Doombringer"] = true,
	["Crimson Sorcerer"] = true,
	["Thuzadin Shadowcaster"] = true,
	["Crimson Inquisitor"] = true,
	["Crimson Battle Mage"] = true,
	["Ghoul Ravener"] = true,
	["Spectral Citizen"] = true,
	["Spectral Researcher"] = true,
	["Scholomance Adept"] = true,
	["Scholomance Dark Summoner"] = true,
	["Twilight Corrupter"] = true,
	["Blackhand Elite"] = true,
	["Blackhand Assassin"] = true,
	["Firebrand Pyromancer"] = true,
	["Firebrand Invoker"] = true,
	["Firebrand Grunt"] = true,
	["Firebrand Legionnaire"] = true,
	["Death Talon Wyrmguard"] = true,
	["Dark Iron Agent"] = true,
	["Molten Destroyer"] = true,
	["Spire Spider/Spiderling"] = true,
	["Spirestone Warlord"] = true,
	["Spirestone Mystic"] = true,
	["Anvilrage Captain"] = true,
	["Anvilrage Marshal"] = true,
	["Doomforge Arcanasmith"] = true,
	["Weapon Technician"] = true,
	["Doomforge Craftsman"] = true,
	["Murk Worm"] = true,
	["Atal'ai Witch Doctor"] = true,
	["Raging Skeleton"] = true,
	["Ethereal Priest"] = true,
	["Sethekk Ravenguard"] = true,
	["Time-Lost Shadowmage"] = true,
	["Coilfang Sorceress"] = true,
	["Coilfang Oracle"] = true,
	["Shattered Hand Centurion"] = true,
	["Eredar Deathbringer"] = true,
	["Arcatraz Sentinel"] = true,
	["Gargantuan Abyssal"] = true,
	["Sunseeker Botanist"] = true,
	["Sunseeker Astromage"] = true,
	["Durnholde Rifleman"] = true,
	["Rift Keeper/Rift Lord"] = true,
	["Crimson Templar"] = true,
	["Azure Templar"] = true,
	["Hoary Templar"] = true,
	["Earthen Templar"] = true,
	["The Duke of Cynders"] = true,
	["The Duke of Fathoms"] = true,
	["The Duke of Zephyrs"] = true,
	["The Duke of Shards"] = true,
	["Aether-tech Assistant"] = true,
	["Aether-tech Adept"] = true,
	["Aether-tech Master"] = true,
	["Trelopades"] = true,
	["King Dorfbruiser"] = true,
	["Gorgolon the All-seeing"] = true,
	["Matron Li-sahar"] = true,
	["Solus the Eternal"] = true,
	["Balzaphon"] = true,
	["Lord Blackwood"] = true,
	["Revanchion"] = true,
	["Scorn"] = true,
	["Sever"] = true,
	["Lady Falther'ess"] = true,
	["Smokywood Pastures Vendor"] = true,
	["Shartuul"] = true,
	["Darkscreecher Akkarai"] = true,
	["Karrog"] = true,
	["Gezzarak the Huntress"] = true,
	["Vakkiz the Windrager"] = true,
	["Terokk"] = true,
	["Armbreaker Huffaz"] = true,
	["Fel Tinkerer Zortan"] = true,
	["Forgosh"] = true,
	["Gul'bor"] = true,
	["Malevus the Mad"] = true,
	["Porfus the Gem Gorger"] = true,
	["Wrathbringer Laz-tarash"] = true,
	["Bash'ir Landing Stasis Chambers"] = true,
	["Templars"] = true,
	["Dukes"] = true,
	["High Council"] = true,
	["Headless Horseman"] = true,
	["Barleybrew Brewery"] = true,
	["Thunderbrew Brewery"] = true,
	["Gordok Brewery"] = true,
	["Drohn's Distillery"] = true,
	["T'chali's Voodoo Brewery"] = true,
	["Scarshield Quartermaster"] = true,
	["Overmaster Pyron"] = true,
	["Father Flame"] = true,
	["Thomas Yance"] = true,
	["Knot Thimblejack"] = true,
	["Shen'dralar Provisioner"] = true,
	["Namdo Bizzfizzle"] = true,
	["The Nameles Prophet"] = true,
	["Henry Stern"] = true,
	["Aggem Thorncurse"] = true,
	["Roogug"] = true,
	["Rajaxx's Captains"] = true,
	["Razorfen Spearhide"] = true,
	["Rethilgore"] = true,
	["Kalldan Felmoon"] = true,
	["Magregan Deepshadow"] = true,
	["Lord Ahune"] = true,
	["Coren Direbrew"] = true,
	["Don Carlos"] = true,
	["Fel Steed"] = true,
	["Monument of Franclorn Forgewright"] = true,
	["The Grim Guzzler"] = true,
	["Summoner's Tomb"] = true,
	["Stratholme Courier"] = true,
	["Atiesh"] = true,
	["Sothos"] = true,
	["Jarien"] = true,
	["East"] = true,
	["West"] = true,
	["North"] = true,
	["Muddy Churning Waters"] = true,
	["Rajaxx's Captains"] = true,
	["World Drop"] = true,
	["LBRS"] = true,
	["UBRS"] = true,
	["Scholo"] = true,
	["Strat"] = true,
	["MC"] = true,
	["Dark Coffer"] = true,
	["The Secret Safe"] = true,
	["The Vault"] = true,
	["Ogre Tannin Basket"] = true,
	["Fengus's Chest"] = true,
	["The Prince's Chest"] = true,
	["Doan's Strongbox"] = true,
	["Frostwhisper's Embalming Fluid"] = true,
	["Unforged Rune Covered Breastplate"] = true,
	["Malor's Strongbox"] = true,
	["Unfinished Painting"] = true,
	["Felvine Shard"] = true,
	["Baelog's Chest"] = true,
	["Lorgalis Manuscript"] = true,
	["Fathom Core"] = true,
	["Conspicuous Urn"] = true,
	["Gift of Adoration"] = true,
	["Box of Chocolates"] = true,
	["Treat Bag"] = true,
	["Gaily Wrapped Present"] = true,
	["Festive Gift"] = true,
	["Ticking Present"] = true,
	["Gently Shaken Gift"] = true,
	["Carefully Wrapped Present"] = true,
	["Winter Veil Gift"] = true,
	["Smokywood Pastures Extra-Special Gift"] = true,
	["Brightly Colored Egg"] = true,
	["Lunar Festival Fireworks Pack"] = true,
	["Lucky Red Envelope"] = true,
	["Small Rocket Recipes"] = true,
	["Large Rocket Recipes"] = true,
	["Cluster Rocket Recipes"] = true,
	["Large Cluster Rocket Recipes"] = true,
	["Timed Reward Chest"] = true,
	["Timed Reward Chest 1"] = true,
	["Timed Reward Chest 2"] = true,
	["Timed Reward Chest 3"] = true,
	["Timed Reward Chest 4"] = true,
	["The Talon King's Coffer"] = true,
	["Krom Stoutarm's Chest"] = true,
	["Garrett Family Chest"] = true,
	["Reinforced Fel Iron Chest"] = true,
	["DM North Tribute Chest"] = true,
	["Abyssal Council"] = true,
	["Children's Week"] = true,
	["Elemental Invasion"] = true,
	["Feast of Winter Veil"] = true,
	["Gurubashi Arena Booty Run"] = true,
	["Hallow's End"] = true,
	["Harvest Festival"] = true,
	["Love is in the Air"] = true,
	["Lunar Festival"] = true,
	["Midsummer Fire Festival"] = true,
	["Noblegarden"] = true,
	["Stranglethorn Fishing Extravaganza"] = true,
	["Highlord Omokk"] = true,
	["Shadow Hunter Vosh'gajin"] = true,
	["War Master Voone"] = true,
	["Mor Grayhoof"] = true,
	["Mother Smolderweb"] = true,
	["Gizrul the Slavener"] = true,
	["Overlord Wyrmthalak"] = true,
	["Pyroguard Emberseer"] = true,
	["Solakar Flamewreath"] = true,
	["Warchief Rend Blackhand"] = true,
	["Gyth"] = true,
	["The Beast"] = true,
	["General Drakkisath"] = true,
	["Razorgore the Untamed"] = true,
	["Vaelastrasz the Corrupt"] = true,
	["Broodlord Lashlayer"] = true,
	["Firemaw"] = true,
	["Ebonroc"] = true,
	["Flamegor"] = true,
	["Chromaggus"] = true,
	["Nefarian"] = true,
	["Lucifron"] = true,
	["Magmadar"] = true,
	["Gehennas"] = true,
	["Garr"] = true,
	["Shazzrah"] = true,
	["Baron Geddon"] = true,
	["Golemagg the Incinerator"] = true,
	["Sulfuron Harbinger"] = true,
	["Ragnaros"] = true,
	["Patchwerk"] = true,
	["Grobbulus"] = true,
	["Gluth"] = true,
	["Thaddius"] = true,
	["Anub'Rekhan"] = true,
	["Grand Widow Faerlina"] = true,
	["Maexxna"] = true,
	["Instructor Razuvious"] = true,
	["Gothik the Harvester"] = true,
	["The Four Horsemen"] = true,
	["Noth the Plaguebringer"] = true,
	["Heigan the Unclean"] = true,
	["Loatheb"] = true,
	["Sapphiron"] = true,
	["Kel'Thuzad"] = true,
	["Onyxia"] = true,
	["Kirtonos the Herald"] = true,
	["Jandice Barov"] = true,
	["Rattlegore"] = true,
	["Ras Frostwhisper"] = true,
	["Instructor Malicia"] = true,
	["Doctor Theolen Krastinov"] = true,
	["Lorekeeper Polkelt"] = true,
	["The Ravenian"] = true,
	["Lord Alexei Barov"] = true,
	["Darkmaster Gandling"] = true,
	["Hearthsinger Forresten"] = true,
	["The Unforgiven"] = true,
	["Timmy the Cruel"] = true,
	["Cannon Master Willey"] = true,
	["Archivist Galford"] = true,
	["Balnazzar"] = true,
	["Baroness Anastari"] = true,
	["Nerub'enkan"] = true,
	["Maleki the Pallid"] = true,
	["Magistrate Barthilas"] = true,
	["Ramstein the Gorger"] = true,
	["Keys"] = true, 
	["Blackfathom Deeps"] = true,
	["Lady Sarevess"] = true,
	["Gelihast"] = true,
	["Ghamoo-ra"] = true,
	["Baron Aquanis"] = true,
	["Twilight Lord Kelris"] = true,
	["Old Serra'kis"] = true,
	["Aku'mai"] = true,
	["Lord Roccor"] = true,
	["High Interrogator Gerstahn"] = true,
	["Houndmaster Grebmar"] = true,
	["Pyromancer Loregrain"] = true,
	["Warder Stilgiss"] = true,
	["Verek"] = true,
	["Fineous Darkvire"] = true,
	["Lord Incendius"] = true,
	["Bael'Gar"] = true,
	["General Angerforge"] = true,
	["Golem Lord Argelmach"] = true,
	["Ambassador Flamelash"] = true,
	["Panzor the Invincible"] = true,
	["Magmus"] = true,
	["Princess Moira Bronzebeard"] = true,
	["Emperor Dagran Thaurissan"] = true,
	["Blackrock Depths"] = true,
	["Lower Blackrock Spire"] = true,
	["Spirestone Butcher"] = true,
	["Highlord Omokk"] = true,
	["Spirestone Battle Lord"] = true,
	["Spirestone Lord Magus"] = true,
	["Shadow Hunter Vosh'gajin"] = true,
	["War Master Voone"] = true,
	["Mor Grayhoof"] = true,
	["Bannok Grimaxe"] = true,
	["Mother Smolderweb"] = true,
	["Crystal Fang"] = true,
	["Urok Doomhowl"] = true,
	["Quartermaster Zigris"] = true,
	["Halycon"] = true,
	["Gizrul the Slavener"] = true,
	["Ghok Bashguud"] = true,
	["Overlord Wyrmthalak"] = true,
	["Burning Felguard"] = true,
	["Pyroguard Emberseer"] = true,
	["Solakar Flamewreath"] = true,
	["Upper Blackrock Spire"] = true,
	["Jed Runewatcher"] = true,
	["Goraluk Anvilcrack"] = true,
	["Warchief Rend Blackhand"] = true,
	["Gyth"] = true,
	["The Beast"] = true,
	["Lord Valthalak"] = true,
	["General Drakkisath"] = true,
	["Razorgore the Untamed"] = true,
	["Vaelastrasz the Corrupt"] = true,
	["Broodlord Lashlayer"] = true,
	["Firemaw"] = true,
	["Ebonroc"] = true,
	["Flamegor"] = true,
	["Chromaggus"] = true,
	["Nefarian"] = true,
	["Blackwing Lair"] = true,
	["The Deadmines"] = true,
	["Pusillin"] = true,
	["Zevrim Thornhoof"] = true,
	["Hydrospawn"] = true,
	["Lethtendris"] = true,
	["Pimgib"] = true,
	["Alzzin the Wildshaper"] = true,
	["Isalien"] = true,
	["Dire Maul (East)"] = true,
	["Dire Maul (North)"] = true,
	["Guard Mol'dar"] = true,
	["Stomper Kreeg"] = true,
	["Guard Fengus"] = true,
	["Guard Slip'kik"] = true,
	["Captain Kromcrush"] = true,
	["Cho'Rush the Observer"] = true,
	["King Gordok"] = true,
	["Tendris Warpwood"] = true,
	["Illyanna Ravenoak"] = true,
	["Magister Kalendris"] = true,
	["Tsu'zee"] = true,
	["Immol'thar"] = true,
	["Lord Hel'nurath"] = true,
	["Prince Tortheldrin"] = true,
	["Dire Maul (West)"] = true,
	["Techbot"] = true,
	["Grubbis"] = true,
	["Viscous Fallout"] = true,
	["Electrocutioner 6000"] = true,
	["Crowd Pummeler 9-60"] = true,
	["Dark Iron Ambassador"] = true,
	["Mekgineer Thermaplugg"] = true,
	["Gnomeregan"] = true,
	["Kolk"] = true,
	["Gelk"] = true,
	["Magra"] = true,
	["Veng"] = true,
	["Noxxion"] = true,
	["Razorlash"] = true,
	["Maraudos"] = true,
	["Lord Vyletongue"] = true,
	["Meshlok the Harvester"] = true,
	["Celebras the Cursed"] = true,
	["Landslide"] = true,
	["Tinkerer Gizlock"] = true,
	["Rotgrip"] = true,
	["Princess Theradras"] = true,
	["Maraudon"] = true,
	["Lucifron"] = true,
	["Magmadar"] = true,
	["Gehennas"] = true,
	["Garr"] = true,
	["Shazzrah"] = true,
	["Baron Geddon"] = true,
	["Golemagg the Incinerator"] = true,
	["Sulfuron Harbinger"] = true,
	["Majordomo Executus"] = true,
	["Ragnaros"] = true,
	["Molten Core"] = true,
	["Patchwerk"] = true,
	["Grobbulus"] = true,
	["Gluth"] = true,
	["Thaddius"] = true,
	["Anub'Rekhan"] = true,
	["Faerlina"] = true,
	["Maexxna"] = true,
	["Razuvious"] = true,
	["Gothik"] = true,
	["The Four Horsemen"] = true,
	["Noth"] = true,
	["Heigan"] = true,
	["Loatheb"] = true,
	["Sapphiron"] = true,
	["Kel'Thuzad"] = true,
	["Naxxramas"] = true,
	["Onyxia"] = true,
	["Onyxia's Lair"] = true,
	["Ragefire Chasm"] = true,
	["Tuten'kash"] = true,
	["Mordresh Fire Eye"] = true,
	["Glutton"] = true,
	["Ragglesnout"] = true,
	["Amnennar the Coldbringer"] = true,
	["Plaguemaw the Rotting"] = true,
	["Razorfen Downs"] = true,
	["Death Speaker Jargba"] = true,
	["Overlord Ramtusk"] = true,
	["Agathelos the Raging"] = true,
	["Blind Hunter"] = true,
	["Charlga Razorflank"] = true,
	["Earthcaller Halmgar"] = true,
	["Razorfen Kraul"] = true,
	["Ruins of Ahn'Qiraj"] = true,
	["Kurinnaxx"] = true,
	["Lieutenant General Andorov"] = true,
	["General Rajaxx"] = true,
	["Moam"] = true,
	["Buru the Gorger"] = true,
	["Ayamiss the Hunter"] = true,
	["Ossirian the Unscarred"] = true,
	["Herod"] = true,
	["Scarlet Monastery"] = true,
	["High Inquisitor Fairbanks"] = true,
	["Scarlet Commander Mograine"] = true,
	["High Inquisitor Whitemane"] = true,
	["Interrogator Vishas"] = true,
	["Ironspine"] = true,
	["Azshir the Sleepless"] = true,
	["Fallen Champion"] = true,
	["Bloodmage Thalnos"] = true,
	["Houndmaster Loksey"] = true,
	["Arcanist Doan"] = true,
	["Blood Steward of Kirtonos"] = true,
	["Kirtonos the Herald"] = true,
	["Jandice Barov"] = true,
	["Rattlegore"] = true,
	["Death Knight Darkreaver"] = true,
	["Marduk Blackpool"] = true,
	["Vectus"] = true,
	["Ras Frostwhisper"] = true,
	["Kormok"] = true,
	["Instructor Malicia"] = true,
	["Doctor Theolen Krastinov"] = true,
	["Lorekeeper Polkelt"] = true,
	["The Ravenian"] = true,
	["Lord Alexei Barov"] = true,
	["Lady Illucia Barov"] = true,
	["Darkmaster Gandling"] = true,
	["Scholomance"] = true,
	["Razorclaw the Butcher"] = true,
	["Baron Silverlaine"] = true,
	["Commander Springvale"] = true,
	["Odo the Blindwatcher"] = true,
	["Fenrus the Devourer"] = true,
	["Arugal's Voidwalker"] = true,
	["Wolf Master Nandos"] = true,
	["Archmage Arugal"] = true,
	["Deathsworn Captain"] = true,
	["Shadowfang Keep"] = true,
	["The Stockade"] = true,
	["Skul"] = true,
	["Fras Siabi"] = true,
	["Hearthsinger Forresten"] = true,
	["The Unforgiven"] = true,
	["Timmy the Cruel"] = true,
	["Crimson Hammersmith"] = true,
	["Cannon Master Willey"] = true,
	["Archivist Galford"] = true,
	["Balnazzar"] = true,
	["Stonespine"] = true,
	["Nerub'enkan"] = true,
	["Baroness Anastari"] = true,
	["Black Guard Swordsmith"] = true,
	["Maleki the Pallid"] = true,
	["Magistrate Barthilas"] = true,
	["Ramstein the Gorger"] = true,
	["Baron Rivendare"] = true,
	["Stratholme"] = true,
	["Atal'alarion"] = true,
	["Dreamscythe"] = true,
	["Weaver"] = true,
	["Avatar of Hakkar"] = true,
	["Jammal'an the Prophet"] = true,
	["Ogom the Wretched"] = true,
	["Morphaz"] = true,
	["Hazzas"] = true,
	["Shade of Eranikus"] = true,
	["The Temple of Atal'Hakkar"] = true,
	["Temple of Ahn'Qiraj"] = true,
	["The Prophet Skeram"] = true,
	["The Bug Family"] = true,
	["Battleguard Sartura"] = true,
	["Fankriss the Unyielding"] = true,
	["Viscidus"] = true,
	["Princess Huhuran"] = true,
	["The Twin Emperors"] = true,
	["Ouro"] = true,
	["C'Thun"] = true,
	["Digmaster Shovelphlange"] = true,
	["Revelosh"] = true,
	["Baelog"] = true,
	["Ironaya"] = true,
	["Obsidian Sentinel"] = true,
	["Ancient Stone Keeper"] = true,
	["Galgann Firehammer"] = true,
	["Grimlok"] = true,
	["Archaedas"] = true,
	["Uldaman"] = true,
	["Wailing Caverns"] = true,
	["Mad Magglish"] = true,
	["Trigore the Lasher"] = true,
	["Boahn"] = true,
	["Lord Cobrahn"] = true,
	["Lady Anacondra"] = true,
	["Kresh"] = true,
	["Lord Pythas"] = true,
	["Skum"] = true,
	["Lord Serpentis"] = true,
	["Verdan the Everliving"] = true,
	["Mutanus the Devourer"] = true,
	["Deviate Faerie Dragon"] = true,
	["Antu'sul"] = true,
	["Theka the Martyr"] = true,
	["Witch Doctor Zum'rah"] = true,
	["Nekrum Gutchewer"] = true,
	["Shadowpriest Sezz'ziz"] = true,
	["Dustwraith"] = true,
	["Sergeant Bly"] = true,
	["Sandfury Executioner"] = true,
	["Hydromancer Velratha"] = true,
	["Gahz'rilla"] = true,
	["Chief Ukorz Sandscalp"] = true,
	["Zerillis"] = true,
	["Zul'Farrak"] = true,
	["High Priestess Jeklik"] = true,
	["High Priest Venoxis"] = true,
	["High Priestess Mar'li"] = true,
	["Bloodlord Mandokir"] = true,
	["Gri'lek"] = true,
	["Hazza'rah"] = true,
	["Renataki"] = true,
	["Wushoolay"] = true,
	["Gahz'ranka"] = true,
	["High Priest Thekal"] = true,
	["High Priestess Arlokk"] = true,
	["Jin'do the Hexxer"] = true,
	["Hakkar"] = true,
	["Zul'Gurub"] = true,
	["Emerald Dragons"] = true,
	["Druid"] = true,
	["Hunter"] = true,
	["Mage"] = true,
	["Paladin"] = true,
	["Priest"] = true,
	["Rogue"] = true,
	["Shaman"] = true,
	["Warlock"] = true,
	["Warrior"] = true,
	["Head"] = true,
	["Neck"] = true,
	["Shoulder"] = true,
	["Back"] = true,
	["Chest"] = true,
	["Shirt"] = true,
	["Tabard"] = true,
	["Wrist"] = true,
	["Hands"] = true,
	["Waist"] = true,
	["Legs"] = true,
	["Feet"] = true,
	["Ring"] = true,
	["Trinket"] = true,
	["Held In Off-hand"] = true,
	["Relic"] = true,
	["Relics"] = true,
	["One-Hand"] = true,
	["Two-Hand"] = true,
	["Main Hand"] = true,
	["Off Hand"] = true,
	["Axe"] = true,
	["Bow"] = true,
	["Crossbow"] = true,
	["Dagger"] = true,
	["Gun"] = true,
	["Mace"] = true,
	["Polearm"] = true,
	["Shield"] = true,
	["Staff"] = true,
	["Sword"] = true,
	["Thrown"] = true,
	["Wand"] = true,
	["Fist Weapon"] = true,
	["Idol"] = true,
	["Totem"] = true,
	["Libram"] = true,
	["Arrow"] = true,
	["Bullet"] = true,
	["Quiver"] = true,
	["Ammo Pouch"] = true,
	["Bag"] = true,
	["Potion"] = true,
	["Food"] = true,
	["Drink"] = true,
	["Bandage"] = true,
	["Trade Goods"] = true,
	["Gem"] = true,
	["Reagent"] = true,
	["Binds when picked up"] = true,
	["Key"] = true,
	["Book"] = true,
	["Scope"] = true,
	["Mount"] = true,
	["Pet"] = true,
	["Banner"] = true,
	["Token"] = true,
	["Darkmoon Faire Card"] = true,
	["Enchant"] = true,
	["Poisons"] = true,
	["Skinning Knife"] = true,
	["Herbalism Knife"] = true,
	["Fishing Pole"] = true,
	["Fish"] = true,
	["Combat Pet"] = true,
	["Fireworks"] = true,
	["Horde"] = true, 
	["Alliance"] = true, 
	["Silverwing Sentinels"] = true, 
	["Warsong Outriders"] = true,
	["Anub'shiah"] = true,
	["Eviscerator"] = true,
	["Gorosh the Dervish"] = true,
	["Grizzle"] = true,
	["Hedrum the Creeper"] = true,
	["Ok'thor the Breaker"] = true,
	["Gasher"] = true,
	["Hukku"] = true,
	["Loro"] = true,
	["Mijan"] = true,
	["Zolo"] = true,
	["Zul'Lor"] = true,
	["Chest of The Seven"] = true,
	["Postmaster Malown"] = true,
	["Hurley Blackbreath"] = true,
	["Phalanx"] = true,
	["Ribbly Screwspigot"] = true,
	["Plugger Spazzring"] = true,
	["Prince Skaldrenox"] = true,
	["Lord Skwol"] = true,
	["High Marshal Whirlaxis"] = true,
	["Baron Kazum"] = true,
	["Baron Charr"] = true,
	["Princess Tempestria"] = true,
	["Avalanchion"] = true,
	["The Windreaver"] = true,
	["Lord Kri"] = true,
	["Vem"] = true,
	["Princess Yauj"] = true,
	["Shattrath City"] = true,
	["Taragaman the Hungerer"] = true,
	["Jergosh the Invoker"] = true,
	["Zelemar the Wrathful"] = true,
	["Targorr the Dread"] = true,
	["Kam Deepfury"] = true,
	["Bazil Thredd"] = true,
	["Dextren Ward"] = true,
	["Bruegal Ironknuckle"] = true,
	["Ahn'Qiraj"] = true,
	["Un'Goro Crater"] = true,
	["Winterspring"] = true,
	["Azshara"] = true,
	["Silithus"] = true,
	["Azeroth"] = true,
	["Outland"] = true,
	["Graveyard"] = true,
	["Armory"] = true,
	["Cathedral"] = true,
	["Library"] = true,
	["Blade's Edge Mountains"] = true,
	["Stranglethorn Vale"] = true,
	["Spirit of Azuregos"] = true,
	["Azuregos"] = true,
	["Lord Kazzak"] = true,
	["Doomwalker"] = true,
	["Emeriss"] = true,
	["Lethon"] = true,
	["Taerar"] = true,
	["Ysondre"] = true,
	["Neutral"] = true,
	["Friendly"] = true,
	["Honored"] = true,
	["Revered"] = true,
	["Exalted"] = true,
	["Argent Dawn"] = true,
	["Bloodsail Buccaneers"] = true,
	["Brood of Nozdormu"] = true,
	["Cenarion Circle"] = true,
	["Darkmoon Faire"] = true,
	["The Defilers"] = true,
	["Frostwolf Clan"] = true,
	["Hydraxian Waterlords"] = true,
	["Gelkis Clan Centaur"] = true,
	["The League of Arathor"] = true,
	["Magram Clan Centaur"] = true,
	["Stormpike Guard"] = true,
	["Thorium Brotherhood"] = true,
	["Timbermaw Hold"] = true,
	["Wintersaber Trainers"] = true,
	["Zandalar Tribe"] = true,
	["Apprentice"] = true,
	["Journeyman"] = true,
	["Expert"] = true,
	["Artisan"] = true,
	["Alchemy"] = true,
	["Blacksmithing"] = true,
	["Armorsmith"] = true,
	["Weaponsmith"] = true,
	["Master Axesmith"] = true,
	["Master Hammersmith"] = true,
	["Master Swordsmith"] = true,
	["Enchanting"] = true,
	["Engineering"] = true,
	["Gnomish Engineering"] = true,
	["Goblin Engineering"] = true,
	["Gnomish"] = true,
	["Goblin"] = true,
	["Leatherworking"] = true,
	["Dragonscale Leatherworking"] = true,
	["Elemental Leatherworking"] = true,
	["Tribal Leatherworking"] = true,
	["Herbalism"] = true,
	["Mining"] = true,
	["Smelting"] = true,
	["Tailoring"] = true,
	["Cooking"] = true,
	["First Aid"] = true,
	["Alterac Valley"] = true,
	["Arathi Basin"] = true,
	["Warsong Gulch"] = true,
	["Hellfire Peninsula"] = true,
	["Nagrand"] = true,
	["Terokkar Forest"] = true,
	["Zangarmarsh"] = true,
	["Cloth"] = true,
	["Leather"] = true,
	["Mail"] = true,
	["Plate"] = true,
	["Dire Maul"] = true,
	["Auchindoun"] = true,
	["Caverns of Time"] = true,
	["Coilfang Reservoir"] = true,
	["Hellfire Citadel"] = true,
	["Tempest Keep"] = true,
	["Marisa du'Paige"] = true,
	["Brainwashed Noble"] = true,
	["Foreman Thistlenettle"] = true,
	["Jordan's Hammer"] = true,
	["The Book of Ur"] = true,
	["Rhahk'Zor"] = true,
	["Miner Johnson"] = true,
	["Sneed"] = true,
	["Sneed's Shredder"] = true,
	["Gilnid"] = true,
	["Captain Greenskin"] = true,
	["Edwin VanCleef"] = true,
	["Mr. Smite"] = true,
	["Cookie"] = true,
	["Reliquary of Souls"] = true,
	["Vazruden the Herald"] = true,
	["Roughshod Pike"] = true,
	["Human Remains"] = true,
	["Defias Gunpowder"] = true,
	["A Dusty Tome"] = true,
	["Entrance"] = true,
	["Matrix Punchograph 3005-A"] = true,
	["Matrix Punchograph 3005-B"] = true,
	["Matrix Punchograph 3005-C"] = true,
	["Matrix Punchograph 3005-D"] = true,
	["Jinxed Hoodoo Pile"] = true,
	["Rank 14 Weapons"] = true,
	["Friendly Reputation Rewards"] = true,
	["Honored Reputation Rewards"] = true,
	["Revered Reputation Rewards"] = true,
	["Exalted Reputation Rewards"] = true,
	["ZG Rings"] = true,
	["51-60 Friendly Rewards"] = true,
	["51-60 Honored Rewards"] = true,
	["51-60 Revered Rewards"] = true,
	["51-60 Exalted Rewards"] = true,
	["20-29 Friendly Rewards"] = true,
	["30-39 Friendly Rewards"] = true,
	["40-49 Friendly Rewards"] = true,
	["50-59 Friendly Rewards"] = true,
	["10-19 Honored Rewards"] = true,
	["20-29 Honored Rewards"] = true,
	["30-39 Honored Rewards"] = true,
	["40-49 Honored Rewards"] = true,
	["50-59 Honored Rewards"] = true,
	["10-19 Revered Rewards"] = true,
	["20-29 Revered Rewards"] = true,
	["30-39 Revered Rewards"] = true,
	["40-49 Revered Rewards"] = true,
	["50-59 Revered Rewards"] = true,
	["40-49 Exalted Rewards"] = true,
	["50-59 Exalted Rewards"] = true,
	["60 Exalted Rewards"] = true,
	["PvP Trinkets"] = true,
	["Cooking Fire"] = true,
	["Moonwell"] = true,
	["Alchemy Lab"] = true,
	["Anvil"] = true,
	["Black Anvil"] = true,
	["Icebellow Anvil"] = true,
	["Forge"] = true,
	["Black Forge"] = true,
	["Blacksmith Hammer"] = true,
	["Clam Meat"] = true,
	["Felcloth"] = true,
	["Refreshing Spring Water"] = true,
	["Lava Core"] = true,
	["Fiery Core"] = true,
	["Arcanite Bar"] = true,
	["Dark Iron Bar"] = true,
	["Huge Emerald"] = true,
	["Dust of Deterioration"] = true,
	["Leaded Vial"] = true,
	["One-Handed Axes"] = true,
	["Two-Handed Axes"] = true,
	["One-Handed Maces"] = true,
	["Two-Handed Maces"] = true,
	["One-Handed Swords"] = true,
	["Two-Handed Swords"] = true,
	["Daggers"] = true,
	["Fist Weapons"] = true,
	["Polearms"] = true,
	["Staves"] = true,
	["Bows"] = true,
	["Crossbows"] = true,
	["Guns"] = true,
	["Shields"] = true,
	["Wands"] = true,
	["Trinkets"] = true,
	["Rings"] = true,
	["Legs"] = true,
	["Waists"] = true,
	["Wrists"] = true,
	["Chests"] = true,
	["Backs"] = true,
	["Shoulders"] = true,
	["Necks"] = true,
	["Heads"] = true,
	["Off-Hands"] = true,
	["Ivus the Forest Lord"] = true,
	["Lokholar the Ice Lord"] = true,
	["The specified item does not exist or is not cached!"] = true,
	["Master Craftsman Omarion"] = true,
	["The Behemoth"] = true,
	} end)
	