assert(Automaton, "Automaton not found!")

------------------------------
--      Are you local?      --
------------------------------

local L = AceLibrary("AceLocale-2.2"):new("Automaton_Purchases")

----------------------------
--      Localization      --
----------------------------

L:RegisterTranslations("enUS", function() return {
	["Purchases"] = true,
	["Automatically restock items"] = true,
	["Reagent"] = true,
	["Set item to buy"] = true,
	["Quantity (stack)"] = true,
	["Set the number of purchased items"] = true,
	["Complete the purchase"] = true,
	["Costs a total of"] = true,
	["Rang"] = true,

	["Rogue"] = true,
	["Mage"] = true,
	["Priest"] = true,
	["Druid"] = true,
	["Paladin"] = true,
	["Shaman"] = true,
	["Warlock"] = true,
	["Hunter"] = true,
	["Warrior"] = true,

	["Vanish"] = true,
	["Pick Lock"] = true,
	["Arcane Brilliance"] = true,
	["Teleport: Stormwind"] = true,
	["Portal: Stormwind"] = true,
	["Prayer of Fortitude"] = true,
	["Rebirth"] = true,
	["Gift of the Wild"] = true,
	["Greater Blessing of Might"] = true,
	["Divine Intervention"] = true,
	["Reincarnation"] = true,

	["Flash Powder"] = true,
	["Thieves' Tools"] = true,
	["Arcane Powder"] = true,
	["Rune of Teleportation"] = true,
	["Rune of Portals"] = true,
	["Holy Candle"] = true,
	["Sacred Candle"] = true,
	["Maple Seed"] = true,
	["Stranglethorn Seed"] = true,
	["Ashwood Seed"] = true,
	["Hornbeam Seed"] = true,
	["Ironwood Seed"] = true,
	["Wild Berries"] = true,
	["Wild Thornroot"] = true,
	["Symbol of Kings"] = true,
	["Symbol of Divinity"] = true,
	["Ankh"] = true,
	["Demonic Figurine"] = true,
	["Infernal Stone"] = true,


	["Jadenvis Seawatcher"] = true,
	["Keldric Boucher"] = true,
	["Kyra Boucher"] = true,
	["Chepi"] = true,
	["Brother Cassius"] = true,
	["Hula'mahi"] = true,
	["Hagrus"] = true,
	["Tarhus"] = true,
	["Cyroen"] = true,
	["Alaindia"] = true,
	["Barim Jurgenstaad"] = true,
	["Balai Lok'Wein"] = true,
	["Khur Hornstriker"] = true,
	["Kurdrum Barleybeard"] = true,
	["Jaysin Lanyda"] = true,
	["Owen Vaughn"] = true,
	["Hannah Akeley"] = true,
	["Thomas Mordan"] = true,
	["Falkan Armonis"] = true,
	["Magenius"] = true,
	["Mystic Yayo'jin"] = true,
	["Alyssa Eva"] = true,
	["Thultazor"] = true,
	["Llana"] = true,
	["Ginny Longberry"] = true,
	["Yaelika Farclaw"] = true,
	["Horthus"] = true,

	["Kyrai"] = true,
	["Patrice Dwyer"] = true,
	["Sloan McCoy"] = true,
	["Smudge Thunderwood"] = true,
	["Sly Garrett"] = true,
	["Gerald Crawley"] = true,
	["Fahran Silentblade"] = true,
	["Tynnus Venomsprout"] = true,
	["Malissa"] = true,
	["Ezekiel Graves"] = true,
	["Samor Festivus"] = true,
	["Jasper Fel"] = true,
	["Rekkul"] = true,



	-- ["Bought "] = true,
	-- [" items."] = true,
	-- ["Already have "] = true,
} end)

L:RegisterTranslations("zhCN", function() return {
	["Purchases"] = "商人-购买材料",
	["Automatically restock items"] = "与商人对话时，自动补充特定材料",
	["Reagent"] = "施法材料",
	["Set item to buy"] = "设置购买项目",
	["Quantity (stack)"] = "数量（组）",
	["Set the number of purchased items"] = "设置购买物品的数量（组）",
	["Complete the purchase"] = "完成购买",
	["Costs a total of"] = "共计花费",
	["Rang"] = "等级",

	-- 职业
	["Rogue"] = "盗贼",
	["Mage"] = "法师",
	["Priest"] = "牧师",
	["Druid"] = "德鲁伊",
	["Paladin"] = "圣骑士",
	["Shaman"] = "萨满祭司",
	["Warlock"] = "术士",
	["Hunter"] = "猎人",
	["Warrior"] = "战士",

	-- 技能
	["Vanish"] = "消失",
	["Pick Lock"] = "开锁",
	["Arcane Brilliance"] = "奥术光辉",
	["Teleport: Stormwind"] = "传送：暴风城",
	["Portal: Stormwind"] = "传送门：暴风城",
	["Prayer of Fortitude"] = "坚韧祷言",
	["Rebirth"] = "复生",
	["Gift of the Wild"] = "野性赐福",
	["Greater Blessing of Might"] = "强效力量祝福",
	["Divine Intervention"] = "神圣干涉",
	["Reincarnation"] = "复生",

	-- 施法材料
	["Flash Powder"] = "闪光粉",
	["Thieves' Tools"] = "盗贼工具",
	["Arcane Powder"] = "魔粉",
	["Rune of Teleportation"] = "传送符文",
	["Rune of Portals"] = "传送门符文",
	["Holy Candle"] = "圣洁蜡烛",
	["Sacred Candle"] = "神圣蜡烛",
	["Maple Seed"] = "枫树种子",
	["Stranglethorn Seed"] = "荆棘种子",
	["Ashwood Seed"] = "灰木种子",
	["Hornbeam Seed"] = "角树种子",
	["Ironwood Seed"] = "铁木种子",
	["Wild Berries"] = "野生浆果",
	["Wild Thornroot"] = "野生棘根草",
	["Symbol of Kings"] = "王者印记",
	["Symbol of Divinity"] = "神圣符印",
	["Ankh"] = "十字章",
	["Demonic Figurine"] = "恶魔雕像",
	["Infernal Stone"] = "地狱火石",

	-- 施法材料NPC
	["Jadenvis Seawatcher"] = "亚德维斯·观海者",
	["Keldric Boucher"] = "凯德雷克·布舍尔",
	["Kyra Boucher"] = "凯拉·布舍尔",
	["Chepi"] = "切比",
	["Brother Cassius"] = "卡苏斯修士",
	["Hula'mahi"] = "哈拉玛",
	["Hagrus"] = "哈格鲁斯",
	["Tarhus"] = "塔霍斯",
	["Cyroen"] = "塞罗恩",
	["Alaindia"] = "奥兰蒂亚",
	["Barim Jurgenstaad"] = "巴瑞姆·贾根斯塔德",
	["Balai Lok'Wein"] = "巴莱·洛克维",
	["Khur Hornstriker"] = "库尔·锐角",
	["Kurdrum Barleybeard"] = "库德拉姆·麦须",
	["Jaysin Lanyda"] = "杰森·兰达",
	["Owen Vaughn"] = "欧文·沃弗恩",
	["Hannah Akeley"] = "汉娜·阿克雷",
	["Thomas Mordan"] = "汤玛斯·莫丹",
	["Falkan Armonis"] = "法尔坎·阿莫尼斯",
	["Magenius"] = "玛基努斯",
	["Mystic Yayo'jin"] = "秘法师雅尔金",
	["Alyssa Eva"] = "艾莉莎·伊瓦",
	["Thultazor"] = "苏塔佐尔",
	["Llana"] = "蓝纳",
	["Ginny Longberry"] = "吉恩",	--"金妮·长莓",
	["Yaelika Farclaw"] = "雅里卡·长爪",
	["Horthus"] = "霍苏斯",


	-- 毒药商人
	["Kyrai"] = "凯尔莱",
	["Patrice Dwyer"] = "帕崔斯·杜耶尔",
	["Sloan McCoy"] = "斯洛安·麦考伊",
	["Smudge Thunderwood"] = "斯穆德·雷木",
	["Sly Garrett"] = "斯莱·加勒特",
	["Gerald Crawley"] = "格拉德·克劳雷",
	["Fahran Silentblade"] = "法兰·沉默之刃",
	["Tynnus Venomsprout"] = "泰努斯·毒芽",
	["Malissa"] = "玛丽萨",
	["Ezekiel Graves"] = "艾泽基尔·格瑞乌斯",
	["Samor Festivus"] = "萨莫尔·菲斯蒂沃斯",
	["Jasper Fel"] = "贾斯伯·菲尔",
	["Rekkul"] = "雷库尔",
	



	-- ["Bought "] = "买了 ",
	-- [" items."] = " 物品.",
	-- ["Already have "] = "已经有 ",
} end)

----------------------------------
--      Module Declaration      --
----------------------------------

Automaton_Purchases = Automaton:NewModule("Purchases")
Automaton_Purchases.modulename = L["Purchases"]
Automaton_Purchases.moduledesc = L["Automatically restock items"]
Automaton_Purchases.options = {
	-- reagent = {
	-- 	type = "text", name = L["Reagent"], desc = L["Set item to buy"], order = 2,
	-- 	get = function() return Automaton_Purchases.db.profile.reagent end,
	-- 	set = function(v) Automaton_Purchases.db.profile.reagent = v end,
	-- 	validate = {L["Ankh"], L["Arcane Powder"], L["Ashwood Seed"], L["Demonic Figurine"], L["Holy Candle"], L["Hornbeam Seed"], L["Infernal Stone"], L["Infernal Stone"], L["Maple Seed"], L["Rune of Portals"], L["Rune of Teleportation"], L["Sacred Candle"], L["Stranglethorn Seed"], L["Symbol of Divinity"], L["Symbol of Kings"], L["Wild Berries"], L["Wild Thornroot"]}
	-- },
	quantity = {
		type = "range", name = L["Quantity (stack)"], desc = L["Set the number of purchased items"], order = 3,
		get = function() return Automaton_Purchases.db.profile.quantity end,
		set = function(v) Automaton_Purchases.db.profile.quantity = v end,
		min = 0,
		max = 5,
		step = 1,
		bigStep = 1,
	},
}

------------------------------
--      Initialization      --
------------------------------

function Automaton_Purchases:OnInitialize()
	self.db = Automaton:AcquireDBNamespace("Purchases")
	Automaton:RegisterDefaults("Purchases", "profile", {
		disabled = true,
		quantity = 0,
		--reagent = L["Ankh"],
	})
	Automaton:SetDisabledAsDefault(self, "Purchases")
	
	self:RegisterOptions(self.options)
end

function Automaton_Purchases:OnEnable()
	self:RegisterEvent("MERCHANT_SHOW")
end

function Automaton_Purchases:OnDisable()
	self:UnregisterAllEvents()
end

------------------------------
--      Event Handlers      --
------------------------------

-- function Automaton_Purchases:MERCHANT_SHOW()
-- 	quantity = Automaton_Purchases.db.profile.quantity
-- 	--reagent = Automaton_Purchases.db.profile.reagent

-- 	for i = 1, GetMerchantNumItems() do
-- 		local MerchantItem = GetMerchantItemInfo(i)
-- 		if MerchantItem == reagent then
-- 			local amountInBag = tonumber(self:SearchItem(reagent))
-- 			local needed = quantity - amountInBag
-- 			if needed > 0 then
-- 				BuyMerchantItem(i, needed)
-- 				self:Print(L["Bought "]..needed..L[" items."])
-- 				else
-- 				self:Print(L["Already have "]..amountInBag..L[" items."])
-- 			end
-- 		end
-- 	end
-- end

-- function Automaton_Purchases:SearchItem(itemname)
-- 	local count = 0
-- 	for bag = 0, 4 do
-- 		if GetContainerNumSlots(bag) > 0 then
-- 			for slot = 0, GetContainerNumSlots(bag) do
-- 				if GetContainerItemLink(bag, slot) then
-- 					local _,_,link = string.find(GetContainerItemLink(bag, slot), "(item:%d+:%d+:%d+:%d+)")
-- 					local item = GetItemInfo(link)
-- 					if item == itemname then
-- 						local _,q = GetContainerItemInfo(bag, slot)
-- 						count = count + q
-- 					end
-- 				end
-- 			end
-- 		end
-- 	end
-- 	return count
-- end

---------------------------------------------------




local Automaton_Purchases_NPCsName = {
	L["Jadenvis Seawatcher"],
	L["Keldric Boucher"],
	L["Kyra Boucher"],
	L["Chepi"],
	L["Brother Cassius"],
	L["Hula'mahi"],
	L["Hagrus"],
	L["Tarhus"],
	L["Cyroen"],
	L["Alaindia"],
	L["Barim Jurgenstaad"],
	L["Balai Lok'Wein"],
	L["Khur Hornstriker"],
	L["Kurdrum Barleybeard"],
	L["Jaysin Lanyda"],
	L["Owen Vaughn"],
	L["Hannah Akeley"],
	L["Thomas Mordan"],
	L["Falkan Armonis"],
	L["Magenius"],
	L["Mystic Yayo'jin"],
	L["Alyssa Eva"],
	L["Thultazor"],
	L["Llana"],
	L["Ginny Longberry"],
	L["Yaelika Farclaw"],
	L["Horthus"],


	-- 毒药商人用于购买盗贼工具和闪光粉
	L["Kyrai"],
	L["Patrice Dwyer"],
	L["Sloan McCoy"],
	L["Smudge Thunderwood"],
	L["Sly Garrett"],
	L["Gerald Crawley"],
	L["Fahran Silentblade"],
	L["Tynnus Venomsprout"],
	L["Malissa"],
	L["Ezekiel Graves"],
	L["Samor Festivus"],
	L["Jasper Fel"],
	L["Rekkul"],

};

-- local Automaton_Purchases_Reagent = {
-- 	["盗贼"] = {-- 材料, 堆叠数量	材料索引与技能等级Rank的关系为：2*Rank-1 ;堆叠数量与技能等级关系为: 2*Rank 
-- 		["消失"] = {"闪光粉", 20},
-- 		["开锁"] = {"盗贼工具", 1}
-- 	},
-- 	["法师"] = {
-- 		["奥术光辉"]	= 	{"魔粉", 20},
-- 		["传送：暴风城"] = 	{"传送符文", 10},
-- 		["传送门：暴风城"] = {"传送门符文", 10}
-- 	},
-- 	["牧师"] = {
-- 		["坚韧祷言"] = {"圣洁蜡烛", 20 , "神圣蜡烛", 20}
-- 	},

-- 	["德鲁伊"] = {		-- 升级速度快，低级施法材料购买少点。
-- 		["复生"] = {"枫树种子", 3 , "荆棘种子", 3 , "灰木种子", 3 , "角树种子", 3 , "铁木种子", 20}, 
-- 		["野性赐福"] = {"野生浆果", 20 , "野生棘根草", 20}
-- 	},
-- 	["圣骑士"] = {
-- 		["强效力量祝福"] = {"王者印记", 100},
-- 		["神圣干涉"] = {"神圣符印", 5}
-- 	},
-- 	["萨满祭司"] = {
-- 		["复生"] = {"十字章", 5}
-- 	},
-- 	["术士"] = {},	-- "地狱火石","恶魔雕像"
-- 	["猎人"] = {},
-- 	["战士"] = {},
-- };

local Automaton_Purchases_Reagent = {
	[L["Rogue"]] = {		-- 材料, 	堆叠数量	材料索引与技能等级Rank的关系为：2*Rank-1 ;堆叠数量与技能等级关系为: 2*Rank 
		[L["Vanish"]] = {L["Flash Powder"], 20},
		[L["Pick Lock"]] = {L["Thieves' Tools"], 1}
	},
	[L["Mage"]] = {
		[L["Arcane Brilliance"]]	= 	{L["Arcane Powder"], 20},
		[L["Teleport: Stormwind"]] = 	{L["Rune of Teleportation"], 10},
		[L["Portal: Stormwind"]] = {L["Rune of Portals"], 10}
	},
	[L["Priest"]] = {
		[L["Prayer of Fortitude"]] = {L["Holy Candle"], 20 , L["Sacred Candle"], 20}
	},

	[L["Druid"]] = {		-- 升级速度快，低级施法材料购买少点。
		[L["Rebirth"]] = {L["Maple Seed"], 3 , L["Stranglethorn Seed"], 3 , L["Ashwood Seed"], 3 , L["Hornbeam Seed"], 3 , L["Ironwood Seed"], 20}, 
		[L["Gift of the Wild"]] = {L["Wild Berries"], 20 , L["Wild Thornroot"], 20}
	},
	[L["Paladin"]] = {
		[L["Greater Blessing of Might"]] = {L["Symbol of Kings"], 100},
		[L["Divine Intervention"]] = {L["Symbol of Divinity"], 5}
	},
	[L["Shaman"]] = {
		[L["Reincarnation"]] = {L["Ankh"], 5}
	},
	[L["Warlock"]] = {},	-- "地狱火石","恶魔雕像"
	[L["Hunter"]] = {},
	[L["Warrior"]] = {},
};

local Automaton_Purchases_ReagentTime = 0;

function Automaton_Purchases:IsNameInNPCname(name)
	for i=1,self:getLength(Automaton_Purchases_NPCsName) do
		if Automaton_Purchases_NPCsName[i] == name then
			return true;
		end
	end
	return false;
end
-- Finds spell position in spellbook 返回技能在法术书中的编号
function Automaton_Purchases:GetSpellPosition(spell)
	local spellposition = nil;
	local i = 1
	while true do
		local spellName, spellRank = GetSpellName(i, BOOKTYPE_SPELL)
		if not spellName then
			do break end
		end
		if spellName == spell then
			spellposition = i
			do break end
		end
		i = i + 1
	end
	return spellposition
end

-- Finds highest rank of a spell	返回指定技能已学的最高等级，如果没有等级则返回1
function Automaton_Purchases:GetSpellRank(spell)
	local rank = 1;
	local i = 1;
	while true do
		local spellName, spellRank = GetSpellName(i, BOOKTYPE_SPELL)
		if not spellName then
			do break end
		end
		if spellName == spell then
			if spellRank ~= "" and spellRank ~= nil and spellRank ~= "被动" then
				if (tonumber(string.sub(spellRank,strlen(L["Rang"])+2)) > rank) then 
					rank = tonumber(string.sub(spellRank,strlen(L["Rang"])+2)) 
				end;
			else
				do break end
			end;
		end;
		i = i + 1;
	end
	return rank;
end

-- Retrieve the name of an item in an inventory slot	返回指定位置物品的名字
function Automaton_Purchases:GetItemName(bag,slot)
	linktext = GetContainerItemLink(bag, slot);
	if linktext then
		local _,_,name = string.find(linktext,"^.*%[(.*)%].*$");
		return name;
	else 
		return "";
	end
end

-- 返回指定物品在背包中的数量
function Automaton_Purchases:GetItemCountNow(itemName)
	itemCount = 0;
	for i=NUM_BAG_FRAMES,0,-1 do
		for j=GetContainerNumSlots(i),1,-1 do
			if (self:GetItemName(i,j) == itemName) then 
				texture,count = GetContainerItemInfo(i,j);
				itemCount = itemCount + count;
			end
		end
	end
	return itemCount;
end


function Automaton_Purchases:CalculateMoney(money)
	local gold = floor(money / (COPPER_PER_SILVER * SILVER_PER_GOLD));
	local silver = floor((money - (gold * COPPER_PER_SILVER * SILVER_PER_GOLD)) / COPPER_PER_SILVER);
	local copper = money - gold * COPPER_PER_SILVER * SILVER_PER_GOLD - silver * COPPER_PER_SILVER;

	return "|c00ffff66"..gold.."g |r |c00c0c0c0"..silver.."s |r |c00FA913D"..copper.."c |r";
end

function Automaton_Purchases:getLength(t)
	local res = 0;
	for k,v in pairs(t) do
		res = res + 1;
	end;
	return res;
end

-- Spams the default chat frame
function Automaton_Purchases:Spam(message, alert)
	if not message and not message == 0 then 
		message = "nil";
	end;
	if( DEFAULT_CHAT_FRAME ) then
		DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFF00Automaton_Purchases:|r " .. message);
	end
	if( UIErrorsFrame and alert == 1 ) then
		UIErrorsFrame:AddMessage("|cFFFFFFFFAutomaton_Purchases::|r " .. message, 1.0, 1.0, 1.0, 1.0, UIERRORS_HOLD_TIME);
	end
end

function Automaton_Purchases:split(str, reps)
	local r = {}
	if str == nil then return nil end
	string.gsub(str, "[^"..reps.."]+", function(w) table.insert(r, w) end)
	return r
end


function Automaton_Purchases:MERCHANT_SHOW()
	if GetTime() < (Automaton_Purchases_ReagentTime + 1) then return end;
	if not self:IsNameInNPCname(UnitName("target")) then return end;
	local quantity = Automaton_Purchases.db.profile.quantity
	local reaCost = 0;																		-- 共计花费金额
	local itemTable = {};
	local playerClass = UnitClass("Player");
	local MerchantNumItems = math.min(GetMerchantNumItems(),21);													-- 返回商人出售物品种类数量.
	
	
	for i=1,MerchantNumItems do
		local itemName, texture, price, count = GetMerchantItemInfo(i);
		if itemName == nil then
			self:Spam("由于1.12版本遍历售卖列表函数问题，本次自动购买失败，请尝试重新对话商人打开列表或手动购买。")
			return;
		end
		itemTable[itemName] = i .. "|" .. price .. "|" .. count;		-- 商人售卖列表中的索引 | 单价 | 每次最少购买数量
	end

	local tmpNumNeed = 0;
	local tmpList = "";
	for k,v in pairs(Automaton_Purchases_Reagent[playerClass]) do							-- k:技能  v:材料表
		if self:GetSpellPosition(k) ~= nil then												-- 判断法术书中是否有这个技能
			local spellHighestRank = math.min(self:GetSpellRank(k), (self:getLength(v) / 2 ));	-- 获得此技能的最高等级与材料种类的个数之间的最小值（因为有些职业不同等级使用的材料是相同的，比如盗贼的消失）
			local reagentName = v[spellHighestRank * 2 - 1];								-- 获取技能所需的施法材料名称
			if itemTable[reagentName] ~= nil then
				local itemMaxStack = v[spellHighestRank * 2];								-- 获取施法材料的最大堆叠数量
				local tab = self:split(itemTable[reagentName], "|");						--tab[1]:index	tab[2]:price	tab[3]:count
				-- 因为王者印记每次至少要买20个，所以取 需要数量除以20后向下取整，避免背包中超过1组
				local numNeed = math.floor((itemMaxStack * quantity - self:GetItemCountNow(reagentName)) / tab[3]); 	-- 计算需要购买的数量：一组的数量 * 组数 - 包里有的数量
				tmpNumNeed = numNeed;
				if numNeed > 0 then
					if (GetMoney() > (tab[2] * numNeed)) then
						while numNeed > itemMaxStack do										-- 当需要购买的数量大于一组时，循环购买整组，直到不满一组，购买剩余部分
							BuyMerchantItem(tab[1],itemMaxStack);
							reaCost = reaCost + (tab[2] * itemMaxStack);
							numNeed = numNeed - itemMaxStack;
						end;
						BuyMerchantItem(tab[1],numNeed);
						reaCost = reaCost + (tab[2] * numNeed);
						tmpList = tmpList..reagentName .. " x"..tmpNumNeed * tab[3].."  ";
					end;
				end;
			end
		end;
	end;
	if reaCost > 0 then
		local money = self:CalculateMoney(reaCost);
		self:Spam("|cffffffff" .. L["Complete the purchase"] .. " : |r"..tmpList.. "\n" .. L["Costs a total of"] .. " :|r"..money);
		Automaton_Purchases_ReagentTime = GetTime();
	end
end