
----------------------------------
--      Module Declaration      --
----------------------------------

local module, L = BigWigs:ModuleDeclaration("Ossirian the Unscarred", "Ruins of Ahn'Qiraj")


----------------------------
--      Localization      --
----------------------------

L:RegisterTranslations("zhCN", function() return {
	cmd = "Ossirian",

	supreme_cmd = "supreme",
	supreme_name = "无敌警报",
	supreme_desc = "无敌模式警报",

	debuff_cmd = "debuff",
	debuff_name = "虚弱警报",
	debuff_desc = "奥斯里安受到虚弱效果影响时发出警报",

	supremetrigger = "无疤者奥斯里安获得了奥斯里安之力的效果。",
	supremewarn = "无疤者奥斯里安无敌模式!",
	supremedelaywarn = "无敌模式 %d 秒!",
	debufftrigger = "无疤者奥斯里安受到了(.+)虚弱效果的影响。",
	crystaltrigger = "奥斯里安水晶开始施放(.+)虚弱。",
	crystal_bar = "虚弱施放!",
	debuffwarn = "奥斯里安现在弱点 %s!",
	supreme_bar = "无敌",
	expose = "虚弱",
	
	["cyclone_trigger"] = "包围之风",
	["stomp_trigger"] = "战争践踏",
	
	["WarStomp"] = "战争践踏(AOE击飞)",
	["Cyclone"] = "飓风术",

	["Shadow"] = "暗影",
	["Fire"] = "火焰",
	["Frost"] = "冰霜",
	["Nature"] = "自然",
	["Arcane"] = "奥术",
	
    ["ShadowIcon"] = "Spell_Shadow_ChillTouch",
    ["FireIcon"] = "Spell_Fire_Fire",
    ["FrostIcon"] = "Spell_Frost_ChillingBlast",
    ["NatureIcon"] = "Spell_Nature_Acid_01",
    ["ArcaneIcon"] = "Spell_Arcane_PortalOrgrimmar",
} end )

L:RegisterTranslations("deDE", function() return {
	supreme_name = "Stärke des Ossirian",
	supreme_desc = "Warnung vor Stärke des Ossirian.",

	debuff_name = "Debuff",
	debuff_desc = "Warnung vor Debuff.",

	supremetrigger = "Ossirian der Narbenlose bekommt 'Stärke des Ossirian'.",
	supremewarn = "Stärke des Ossirian!",
	supremedelaywarn = "Stärke des Ossirian in %d Sekunden!",
	debufftrigger = "Ossirian der Narbenlose ist von (.*)schwäche betroffen.",
	crystaltrigger = "Ossirian Crystal Trigger dies.", -- translation missing
	debuffwarn = "Ossirian für 45 Sekunden anfällig gegen: %s",
	supreme_bar = "Stärke des Ossirian",
	expose = "Schwäche",

	["cyclone_trigger"] = "Enveloping Winds",
	["stomp_trigger"] = "War Stomp",

	["WarStomp"] = "War Stomp",
	["Cyclone"] = "Cyclone",

	["Shadow"] = "Schatten",
	["Fire"] = "Feuer",
	["Frost"] = "Frost",
	["Nature"] = "Natur",
	["Arcane"] = "Arkan",

	["ShadowIcon"] = "Spell_Shadow_ChillTouch",
	["FireIcon"] = "Spell_Fire_Fire",
	["FrostIcon"] = "Spell_Frost_ChillingBlast",
	["NatureIcon"] = "Spell_Nature_Acid_01",
	["ArcaneIcon"] = "Spell_Arcane_PortalOrgrimmar",
} end )


---------------------------------
--      	Variables 		   --
---------------------------------

-- module variables
module.revision = 20006 -- To be overridden by the module!
module.enabletrigger = module.translatedName -- string or table {boss, add1, add2}
--module.wipemobs = { L["add_name"] } -- adds which will be considered in CheckForEngage
module.toggleoptions = {"supreme", "debuff", "bosskill"}

-- locals
local timer = {
	weakness = 45,
	supreme = 45,
	firstCyclone = 20,
	cyclone = 15,
	earliestWarstomp = 25,
	latestWarstomp = 35,
}
local icon = {
	supreme = "Spell_Shadow_CurseOfTounges",
	warstomp = "Ability_BullRush",
	cyclone = "Spell_Nature_Cyclone",
}
local syncName = {
	weakness = "OssirianWeakness"..module.revision,
	crystal = "OssirianCrystal"..module.revision,
	supreme = "OssirianSupreme"..module.revision,
	warstomp = "OssirianWarstomp"..module.revision,
	cyclone = "OssirianCyclone"..module.revision,
}

local currentWeakness = nil
local timeLastWeaken = nil


------------------------------
--      Initialization      --
------------------------------

--module:RegisterYellEngage(L["start_trigger"])

-- called after module is enabled
function module:OnEnable()
	self:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS")
	self:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_CREATURE_DAMAGE")

	self:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", "Debuff")
	self:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", "Debuff")
	self:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", "Debuff")
	self:RegisterEvent("CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE", "Debuff")
	self:RegisterEvent("CHAT_MSG_SPELL_CREATURE_VS_PARTY_DAMAGE", "Debuff")
	self:RegisterEvent("CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE", "Debuff")

	self:ThrottleSync(3, syncName.weakness)
	self:ThrottleSync(3, syncName.crystal)
	self:ThrottleSync(3, syncName.supreme)
	self:ThrottleSync(3, syncName.cyclone)
	self:ThrottleSync(3, syncName.warstomp)
end

-- called after module is enabled and after each wipe
function module:OnSetup()
	timeLastWeaken = GetTime()
	self:RegisterEvent("CHAT_MSG_COMBAT_HOSTILE_DEATH")
end

-- called after boss is engaged
function module:OnEngage()
	self:Bar(L["Cyclone"], timer.firstCyclone, icon.cyclone)
	self:Bar(L["WarStomp"], timer.earliestWarstomp, icon.warstomp)
end

-- called after boss is disengaged (wipe(retreat) or victory)
function module:OnDisengage()
end


------------------------------
--      Event Handlers	    --
------------------------------

function module:CHAT_MSG_COMBAT_HOSTILE_DEATH(msg)
	BigWigs:CheckForBossDeath(msg, self)

	-- if the same weakness triggers back to back, the normal combat log entry is missing for the weakness
	-- this event is triggered 2s later
	if string.find(msg, L["crystaltrigger"]) then
		self:Sync(syncName.crystal)
	end
end

function module:CHAT_MSG_SPELL_PERIODIC_CREATURE_DAMAGE( msg )
	local _, _, debuffName = string.find(msg, L["debufftrigger"])
	if debuffName and debuffName ~= L["expose"] and L:HasReverseTranslation(debuffName) then
		self:Sync(syncName.weakness .. " " .. L:GetReverseTranslation(debuffName))
	end
end

function module:CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS( msg )
	if string.find(msg, L["supremetrigger"]) then
		self:Sync(syncName.supreme)
	end
end


------------------------------
--      Synchronization	    --
------------------------------

function module:BigWigs_RecvSync(sync, rest, nick)
	if sync == syncName.weakness and rest then
		self:Weakness(rest)
	elseif sync == syncName.crystal then
		self:Crystal()
	elseif sync == syncName.supreme then
		self:Supreme()
	elseif sync == syncName.cyclone then
		self:Cyclone()
	elseif sync == syncName.warstomp then
		self:IntervalBar(L["WarStomp"], timer.earliestWarstomp, timer.latestWarstomp, icon.warstomp)
	end
end

------------------------------
--      Sync Handlers	    --
------------------------------

function module:Cyclone()
	self:CancelScheduledEvent("bw_ossirian_cyclone")
	self:Bar(L["Cyclone"], timer.cyclone, icon.cyclone)
	self:ScheduleEvent("bw_ossirian_cyclone", self.Cyclone, timer.cyclone, self)
end

function module:Weakness(weakness, delay)
	if not weakness then
		return
	end
	if not delay then
		delay = 0
	end

	timeLastWeaken = GetTime()
	currentWeakness = weakness

	if self.db.profile.debuff then
		self:Message(string.format(L["debuffwarn"], L[tostring(weakness)]), "Important")
		self:Bar(L[weakness], timer.weakness - delay, L[weakness .. "Icon"])
	end

	self:RemoveBar(L["supreme_bar"])
	self:CancelDelayedMessage(string.format(L["supremedelaywarn"], 15))
	self:CancelDelayedMessage(string.format(L["supremedelaywarn"], 10))
	self:CancelDelayedMessage(string.format(L["supremedelaywarn"], 5))

	if self.db.profile.supreme then
		self:DelayedMessage(timer.supreme - delay, string.format(L["supremedelaywarn"], 15), "Attention", nil, nil, true)
		self:DelayedMessage(timer.supreme - delay, string.format(L["supremedelaywarn"], 10), "Urgent", nil, nil, true)
		self:DelayedMessage(timer.supreme - delay, string.format(L["supremedelaywarn"], 5), "Important", nil, nil, true)
		self:Bar(L["supreme_bar"], timer.supreme - delay, icon.supreme)
	end
end

function module:Crystal()
	if timeLastWeaken + 3 < GetTime() then -- crystal trigger occurs 2s after weaken trigger
		self:Weakness(currentWeakness, 2)
	end
end

function module:Supreme()
	if self.db.profile.supreme then
		self:Message(L["supremewarn"], "Attention", nil, "Beware")
	end
end

function module:Debuff(msg)
	if string.find(msg, L["cyclone_trigger"])then
		self:Sync(syncName.cyclone)
	end
	if string.find(msg, L["stomp_trigger"])then
		self:Sync(syncName.warstomp)
	end
end