--[[
--
--	DamageMeters Localization Data (Chinese)
--
--]]

if ( GetLocale() == "zhCN" ) then
-- General --
DamageMeters_PRINTCOLOR = "|cFF8F8FFF"

-- Bindings --
BINDING_HEADER_DAMAGEMETERSHEADER 		= "DamageMeters";
BINDING_NAME_DAMAGEMETERS_TOGGLESHOW	= "显示/隐藏面板";
BINDING_NAME_DAMAGEMETERS_CYCLEQUANT	= "循环显示类别";
BINDING_NAME_DAMAGEMETERS_CYCLEQUANTBACK= "反向循环显示类别";
BINDING_NAME_DAMAGEMETERS_CLEAR			= "清除数据";
BINDING_NAME_DAMAGEMETERS_TOGGLEPAUSED	= "开始/暂停";
BINDING_NAME_DAMAGEMETERS_SHOWREPORTFRAME = "显示报告面板";
BINDING_NAME_DAMAGEMETERS_SWAPMEMORY	= "交换内存数据";
BINDING_NAME_DAMAGEMETERS_TOGGLESHOWMAX	= "显示全部栏";
BINDING_NAME_DAMAGEMETERS_SYNCREADY		= "同步准备命令";
BINDING_NAME_DAMAGEMETERS_TOGGLESHOWFIGHTASPS = "显示每秒数据";
BINDING_NAME_DAMAGEMETERS_TOGGLENORMALANDFIGHT = "显示总量或单次战斗数据";
BINDING_NAME_DAMAGEMETERS_TOGGLEMINIMODE = "迷你面板";
BINDING_NAME_DAMAGEMETERS_SYNCPAUSE = "同步暂停命令";
BINDING_NAME_DAMAGEMETERS_SYNCUNPAUSE = "同步继续命令";
BINDING_NAME_DAMAGEMETERS_SYNCCLEAR = "同步清除";

--[[ work in progress
-- command, function, help string
DM_HELPDEF = {
	-- Main commands.
	{ "help", DamageMeters_Help, DM_CMD_HELP },
	{ "cmd", DamageMeters_ListCommands, DM_CMD_CMD },
	{ "version", DamageMeters_ShowVersion, DM_CMD_VERSION },
	{ "show", DamageMeters_ToggleShow, DM_CMD_SHOW },
	{ "hide", DamageMeters_Hide, DM_CMD_HIDE },
	{ "clear", DamageMeters_Clear, DM_CMD_CLEAR },
	{ "report", DamageMeters_Report, DM_CMD_REPORT },
	{ "sort", DamageMeters_SetSort, DM_CMD_SORT },
	{ "count", DamageMeters_SetCount, DM_CMD_SETCOUNT },
	{ "autocount", DamageMeters_SetAutoCount, DM_CMD_AUTOCOUNT },
	{ "lock", DamageMeters_ToggleLock, DM_CMD_LOCK },
	{ "pause", DamageMeters_TogglePause, DM_CMD_PAUSE },
	{ "ready", DamageMeters_SetReady, DM_CMD_READY },
	{ "resetpos", DamageMeters_ResetPos, DM_CMD_RESETPOS },
	{ "pop", DamageMeters_Populate, DM_CMD_POP },
	{ "listbanned", DamageMeters_ListBanned, DM_CMD_LISTBANNED },
	{ "clearbanned", DamageMeters_ClearBanned, DM_CMD_CLEARBANNED },

	-- Memory
	{ "save", DamageMeters_Save, DM_CMD_SAVE },
	{ "restore", DamageMeters_Restore, DM_CMD_RESTORE },
	{ "swap", DamageMeters_Swap, DM_CMD_SWAP },
	{ "memclear", DamageMeters_MemClear, DM_CMD_MEMCLEAR },

	-- These all have menu options.
	{ "color", DamageMeters_SetColorScheme, DM_CMD_COLOR },
	{ "quant", DamageMeters_SetQuantity, DM_CMD_QUANT },
	{ "text", DamageMeters_SetTextOptions, DM_CMD_TEXT },
	{ "visinparty", DamageMeters_SetVisibleInParty, DM_CMD_VISINPARTY },
	{ "lockpos", DamageMeters_ToggleLockPos, DM_CMD_LOCKPAUSE },
	{ "grouponly", DamageMeters_ToggleGroupMembersOnly, DM_CMD_GROUPONLY },
	{ "addpettoplayer", DamageMeters_ToggleAddPetToPlayer, DM_CMD_ADDPETTOPLAYER },
	{ "resetoncombat", DamageMeters_ToggleResetWhenCombatStarts, DM_CMD_RESETONCOMBAT },
	{ "total", DamageMeters_ToggleTotal, DM_CMD_TOTAL },
	{ "showmax", DamageMeters_ToggleMaxBars, DM_CMD_SHOWMAX },	

	-- Sync commands.
	{ "sync", DamageMeters_Sync, DM_CMD_SYNC },
	{ "syncchan", DamageMeters_SyncChan, DM_CMD_SYNCCHAN },
	{ "syncleave", DamageMeters_SyncLeaveChanCmd, DM_CMD_SYNCLEAVE },
	{ "syncsend", DamageMeters_SyncReport, DM_CMD_SYNCSEND },
	{ "syncrequest", DamageMeters_SyncRequest, DM_CMD_SYNCREQUEST },
	{ "syncclear", DamageMeters_SyncClear, DM_CMD_SYNCCLEAR },
	{ "syncmsg", DamageMeters_SendSyncMsg, DM_CMD_SYNCMSG },
	{ "syncbroadcastchan", DamageMeters_SyncBroadcastChan, DM_CMD_SYNCBROADCASTCHAN },
	{ "syncping", DamageMeters_SyncPingRequest, DM_CMD_SYNCPING },
	{ "syncpause", DamageMeters_SyncPause, DM_CMD_SYNCPAUSE },
	{ "syncunpause", DamageMeters_SyncUnpause, DM_CMD_SYNCUNPAUSE },
	{ "syncready", DamageMeters_SyncReady, DM_CMD_SYNCREADY },
	{ "synckick", DamageMeters_SyncKick, DM_CMD_SYNCKICK },
	{ "synclabel", DamageMeters_SyncLabel, DM_CMD_SYNCLABEL },
	{ "syncstart", DamageMeters_SyncStart, DM_CMD_SYNCSTART },
	{ "synchalt", DamageMeters_SyncHalt, DM_CMD_SYNCHALT },
	{ "synce", DamageMeters_SyncEmote, DM_CMD_SYNCEMOTE },

	-- Debug commands.
	{ "reset", DamageMeters_Reset, DM_CMD_RESET },
	{ "test", DamageMeters_Test, DM_CMD_TEST },
	{ "add", DamageMeters_Add, DM_CMD_ADD },
	{ "dumptable", DamageMeters_DumpTable, DM_CMD_DUMPTABLE },
	{ "debug", DM_ToggleDMPrintD, DM_CMD_DEBUG },
	{ "dumpmsg", DM_DumpMsg, DM_CMD_DUMPMSG },
	{ "print", DM_ConsolePrint, DM_CMD_PRINT },
};
]]--

-- Help --
DamageMeters_helpTable = {
		"以下指令能输入控制台:",
		"/dm help : 伤害统计的使用帮助.",
		"/dm cmd : 显示可用指令(/dm ).",
		"/dm show : 选择是否面板可见. 注意面板不可见后统计将继续.",
		"/dm hide : 隐藏面板.",
		"/dm clear [#] : 除了#号,整个列表将删除. 如果#号不指定,整个列表将被删除.",
		"/dm report [help] [total] [c/s/p/r/w/h/g/f[#]] [whispertarget/channelNAME] - 列出当前数据的报告: 使用'/dm report help'查看更多细节.",
		"/dm sort [#] - 设置排列类型. 不指定将显示可用排列类型列表.",
		"/dm count [#] - 设置统计个数,如果 # 不指定那么显示最大统计数.",
		"/dm save - 保存当前列表.",
		"/dm restore - 恢复前一个保存列表,覆盖任何新数据.",
		--"/dm merge - 当前数据将与前一个保存列表合并.",
		"/dm swap - 当前列表将与前一个保存列表互换.",
		"/dm memclear - 清除保存列表.",
		"/dm resetpos - 重置窗口位置 (对找不到窗口有帮助).",
		"/dm text 0/<[r][n][p][l][v]> - 设置文字显示. r - 排行. n - 玩家名字. p - 百分比. l - 第一的百分比. v - 值.",
		"/dm color # - 设置颜色. 不指定将显示可用设置列表.",
		"/dm quant # - 设置显示类别. 不指定将显示可用设置列表.",
		"/dm visinparty [y/n] - 设置窗口是否只在小队/团队中可见.",
		"/dm autocount # - 伤害统计将自动显示最多到#的单位数据. 如果#为0,自动统计将关闭.",
		"/dm listbanned - 显示所有被禁止单位.",
		"/dm clearbanned - 解禁所有被禁止单位.",

		"/dm sync [d#] [e] - 在同步频道与其他玩家同步数据. (将使用 dmsyncsend 和 dmsyncrequest.) 如果指定了D的数值,那么同步将在那么多秒后进行. 如果指定了E,那么详细数据将被传送.",
		--"/dm syncchan - 设置同步频道.",
		--"/dm syncleave - 离开当前同步频道.",
		"/dm syncsend - 在同步频道上发送同步信息.",
		"/dm syncrequest - 在你的频道上发送请求并自动与其他玩家同步.",
		"/dm syncclear - 发送同步清除指令.",
		"/dm syncmsg msg - 在同步频道发送聊天信息给其他人,也能使用 /dm m.",
		--"/dm syncbroadcastchan - 向队员广播当前同步频道. 也能使用/dm syncb.",
		"/dm syncping - 在同步频道联系其他玩家,并返回他们的DM版本.",
		"/dm syncpause - 在同步频道发送暂停指令.",
		"/dm syncunpause - 在同步频道发送继续指令.",
		"/dm syncready - 发送一个指令使频道内每人准备就绪.",
		--"/dm synckick player - 将某人踢出同步频道.",
		"/dm synclabel label - 标记当前团队进程(默认标签为1).",
		"/dm syncstart label - 自动使用 dmsynclabel, dmsyncpause, 和 dmsyncclear 的方便的命令.",
		"/dm synchalt - 中止任何同步进程(清除接收和发送消息序列).",

		"/dm pop - 与队员(小队/团队)合并数据.",
		"/dm lock - 选择是否锁定列表.新的玩家不能加入一个锁定列表,但是已存在的玩家数据将继续统计.",
		"/dm pause - 选择是否暂停数据统计.",
		"/dm lockpos - 选择是否锁定面板.",
		"/dm grouponly - 选择是否拒绝任何不在小队/团队中的玩家.  (宠物将忽略这个设置.)",
		"/dm addpettoplayer - 选择是否将宠物数据作为你的数据.",
		"/dm resetoncombat = 选择是否在战斗开始时重置数据.",
		"/dm version - 显示版本信息.",
		"/dm total - 显示总计.",
		"/dm showmax - 选择是否显示最大统计数.",
};

-- Filters --
DamageMeters_Filter_STRING1 = "队内成员";
DamageMeters_Filter_STRING2 = "所有友方角色";

-- Relationships --
DamageMeters_Relation_STRING = {
		"自己",
		"自己的宠物",
		"队友",
		"友方角色"};

-- Color Schemes -- 
DamageMeters_colorScheme_STRING = {
		"关系",
		"职业"};

-- Quantities -- 
DM_QUANTSTRING_DAMAGEDONE = "总伤害";
DM_QUANTSTRING_HEALINGDONE = "有效治疗";
DM_QUANTSTRING_DAMAGETAKEN = "总承受伤害";
DM_QUANTSTRING_HEALINGTAKEN = "总接受治疗";
DM_QUANTSTRING_DAMAGEDONE_FIGHT = "本次战斗伤害";
DM_QUANTSTRING_HEALINGDONE_FIGHT = "本次战斗有效治疗";
DM_QUANTSTRING_DAMAGETAKEN_FIGHT = "本次战斗承受伤害";
DM_QUANTSTRING_HEALINGTAKEN_FIGHT = "本次战斗接受治疗";
DM_QUANTSTRING_DAMAGEDONE_PS = "每秒伤害";
DM_QUANTSTRING_HEALINGDONE_PS = "每秒治疗";
DM_QUANTSTRING_DAMAGETAKEN_PS = "每秒承受伤害";
DM_QUANTSTRING_HEALINGTAKEN_PS = "每秒接受治疗";
DM_QUANTSTRING_IDLETIME = "空闲时间";
DM_QUANTSTRING_NETDAMAGE = "净伤害量(输出伤害-受到伤害)";
DM_QUANTSTRING_NETHEALING = "净治疗量(输出治疗-受到治疗)";
DM_QUANTSTRING_DAMAGEPLUSHEALING = "总输出治疗伤害量";
DM_QUANTSTRING_CURING = "施放清除法术";
DM_QUANTSTRING_CURING_FIGHT = "本次战斗清除";
DM_QUANTSTRING_CURING_PS = "每秒清除";
DM_QUANTSTRING_OVERHEAL = "过量治疗";
DM_QUANTSTRING_OVERHEAL_FIGHT = "本次战斗过量治疗";
DM_QUANTSTRING_OVERHEAL_PS = "每秒过量治疗";
DM_QUANTSTRING_HEALTH = "生命值";
DM_QUANTSTRING_OVERHEAL_PERCENTAGE = "过量治疗百分比";
DM_QUANTSTRING_ABSHEAL = "输出治疗";
DM_QUANTSTRING_ABSHEAL_FIGHT = "本次战斗输出治疗";
DM_QUANTSTRING_ABSHEAL_PS = "每秒输出治疗";

DMI_NAMES = {
	DM_QUANTSTRING_DAMAGEDONE,
	DM_QUANTSTRING_HEALINGDONE,
	DM_QUANTSTRING_DAMAGETAKEN,
	DM_QUANTSTRING_HEALINGTAKEN,
	DM_QUANTSTRING_CURING,
	DM_QUANTSTRING_OVERHEAL,
	DM_QUANTSTRING_ABSHEAL,
};

DM_QUANTABBREV_DAMAGEDONE = "D";
DM_QUANTABBREV_HEALINGDONE = "H";
DM_QUANTABBREV_DAMAGETAKEN = "DT";
DM_QUANTABBREV_HEALINGTAKEN = "HT";
DM_QUANTABBREV_CURING = "Cu";
DM_QUANTABBREV_OVERHEAL = "Oh";
DM_QUANTABBREV_ABSHEAL = "RawHD";

DM_QUANTABBREV_DAMAGEDONE_PS = "DPS";
DM_QUANTABBREV_HEALINGDONE_PS = "HPS";
DM_QUANTABBREV_DAMAGETAKEN_PS = "DTPS";
DM_QUANTABBREV_HEALINGTAKEN_PS = "HTPS";
DM_QUANTABBREV_CURING_PS = "CuPS";
DM_QUANTABBREV_OVERHEAL_PS = "OHPS";
DM_QUANTABBREV_ABSHEAL_PS = "RawHDPS";

DM_QUANTABBREV_IDLETIME = "IT";	
DM_QUANTABBREV_NETDAMAGE = "NetD";
DM_QUANTABBREV_NETHEALING = "NetH";
DM_QUANTABBREV_DAMAGEPLUSHEALING = "D+H";
DM_QUANTABBREV_HEALTH = "HP";
DM_QUANTABBREV_OVERHEAL_PERCENTAGE = "Oh%";


-- Sort --
DamageMeters_Sort_STRING = {
		"降序", 
		"升序",
		"字母排序"};

-- Class Names
DamageMeters_ChinaClass = {
        ["猎人"] = "HUNTER",
        ["萨满祭司"] = "SHAMAN",
        ["战士"] = "WARRIOR",
        ["法师"] = "MAGE",
        ["圣骑士"] = "PALADIN",
        ["牧师"] = "PRIEST",
        ["德鲁伊"] = "DRUID",
        ["盗贼"] = "ROGUE",
        ["术士"] = "WARLOCK"
};

function DamageMeters_GetClassColor(className)
	return RAID_CLASS_COLORS[string.upper(DamageMeters_ChinaClass[className])];
end

-- This associates the string names of damage types (schools) with the DM_DMGTYPE constants.
DM_DMGNAMETOID = {
	Arcane = DM_DMGTYPE_ARCANE,
	Fire = DM_DMGTYPE_FIRE,
	Nature = DM_DMGTYPE_NATURE,
	Frost = DM_DMGTYPE_FROST,
	Shadow = DM_DMGTYPE_SHADOW,
	Holy = DM_DMGTYPE_HOLY,
	Physical = DM_DMGTYPE_PHYSICAL,
};

DM_DMGTYPENAMES = {
	"奥术",
	"火焰",
	"自然",
	"冰霜",
	"暗影",
	"神圣",
	"物理",
	"标准",
};

-- Errors --
DM_ERROR_INVALIDARG = "伤害统计: 无效数目.";
DM_ERROR_MISSINGARG = "伤害统计: 数目丢失.";
DM_ERROR_NOSAVEDTABLE = "伤害统计: 没有保存列表.";
DM_ERROR_BADREPORTTARGET = "伤害统计: 无效报告目标 = ";
DM_ERROR_MISSINGWHISPERTARGET = "伤害统计: 指定对象不存在.";
DM_ERROR_MISSINGCHANNEL = "伤害统计: 指定同步频道不存在.";
DM_ERROR_NOSYNCCHANNEL = "伤害统计: 使用同步指令前请用 dmsyncchan 指定同步频道.";
DM_ERROR_JOINSYNCCHANNEL = "伤害统计: 使用同步指令必须加入同步频道 ('%s').";
DM_ERROR_SYNCTOOSOON = "伤害统计: 同步请求发送过快; 忽略.";
DM_ERROR_POPNOPARTY = "伤害统计: 不能传送列表,你不在队伍内.";
DM_ERROR_NOROOMFORPLAYER = "伤害统计: 不能将宠物数据与玩家合并因为不能将玩家添加至列表(列表已满?).";
DM_ERROR_BROADCASTNOGROUP = "伤害统计: 必须再小队或团队中才能广播频道.";
DM_ERROR_NOPARTY = "伤害统计: 你不在小队中.";
DM_ERROR_NORAID = "伤害统计: 你不在团队中.";

-- Messages --
DM_MSG_SETQUANT = "伤害统计: 设置可见个数为 ";
DM_MSG_CURRENTQUANT = "伤害统计: 当前个数 = ";
DM_MSG_CURRENTSORT = "伤害统计: 当前排列类型 = ";
DM_MSG_SORT = "伤害统计: 设置排列类型为 ";
DM_MSG_CLEAR = "伤害统计: 删除 %d 到 %d.";
--DM_MSG_REMAINING = "伤害统计: %d 单位剩余.";
DM_MSG_REPORTHEADER = "伤害统计: <%s> 报告于 %d/%d 单位:";
DM_MSG_PLAYERREPORTHEADER = "伤害统计: 玩家报告于 %s:";
DM_MSG_SETCOUNTTOMAX = "伤害统计: 未指定统计个数,设为最大.";
DM_MSG_SETCOUNT = "伤害统计: 新的统计个数 = ";
DM_MSG_RESETFRAMEPOS = "伤害统计: 重置面板位置.";
DM_MSG_SAVE = "伤害统计: 保存列表.";
DM_MSG_RESTORE = "伤害统计: 恢复保存列表.";
DM_MSG_MERGE = "伤害统计: 与当前列表合并.";
DM_MSG_SWAP = "伤害统计: 交换 (%d) 列表并保存 (%d) 列表.";
DM_MSG_SETCOLORSCHEME = "伤害统计: 设置颜色显示为 ";
DM_MSG_TRUE = "true";
DM_MSG_FALSE = "false";
DM_MSG_SETVISINPARTY = "伤害统计: 只在队伍中可见设为 ";
DM_MSG_SETAUTOCOUNT = "伤害统计: 设置新的自动统计限制为 ";
DM_MSG_LISTBANNED = "伤害统计: 显示被禁止单位:";
DM_MSG_CLEARBANNED = "伤害统计: 解禁所有被禁止单位.";
DM_MSG_HOWTOSHOW = "伤害统计: 隐藏窗口,使用 /dm show 再次可见.";
DM_MSG_SYNCCHAN = "伤害统计: 同步频道设为 ";
DM_MSG_SYNCREQUESTACK = "伤害统计: 发送同步请求 ";
DM_MSG_SYNCREQUESTACKEVENTS = "伤害统计: 发送同步请求(包含详细数据) ";
DM_MSG_SYNC = "伤害统计: 发送数据.";
DM_MSG_SYNCEVENTS = "伤害统计: 发送数据(包含详细数据).";
DM_MSG_LOCKED = "伤害统计: 列表已锁定.";
DM_MSG_NOTLOCKED = "伤害统计: 列表解锁.";
DM_MSG_PAUSED = "伤害统计: 统计暂停.";
DM_MSG_UNPAUSED = "伤害统计: 统计继续.";
DM_MSG_POSLOCKED = "伤害统计: 位置已锁定.";
DM_MSG_POSNOTLOCKED = "伤害统计: 位置解锁.";
DM_MSG_CLEARRECEIVED = "伤害统计: 同步清除请求接收于 ";
DM_MSG_ADDINGPETTOPLAYER = "伤害统计: 宠物数据将作为你的数据.";
DM_MSG_NOTADDINGPETTOPLAYER = "伤害统计: 宠物数据与你的数据分离.";
DM_MSG_PETMERGE = "伤害统计: 将宠物的 (%s) 信息与你合并.";
DM_MSG_RESETWHENCOMBATSTARTSCHANGE = "伤害统计: 战斗开始时重置数据 = ";
DM_MSG_SHOWFIGHTASPS = "伤害统计: 本次战斗每秒数据显示 = ";
DM_MSG_COMBATDURATION = "战斗持续 = %.2f 秒.";
DM_MSG_RECEIVEDSYNCDATA = "伤害统计: 从 %s 接收数据.";
DM_MSG_TOTAL = "总计";
DM_MSG_VERSION = "伤害统计 %s 已激活,查看指令输入/dm cmd.";
DM_MSG_REPORTHELP = "/dm report指令包含3个部分:\n\n1) 发送目标. 包含以下几点:\n  c - 控制台(只有你可见)%.\n  s - 说\n  p - 小队\n  r - 团队\n  g - 公会\n  o - 公会管理\n  h - 聊天频道.如 /dm report h mychannel\n  w - 悄悄话.如 /dm report w 某某\n  f - 面板: 在窗口中显示报告.\n\n下方的字母将有更高的优先级(最低到最高)%.\n\n2) 随意的限制数,这个数字紧跟在发送目标后.\n如: /dm report p5\n\n3) 默认情况下,报告只发送当前显示类别. 如果'total'被指定在发送目标前, 那么报告将发送每个类别. 完整报告是规整的以方便剪切-粘贴到一个文本文件,所以最好指定面板显示.\n如: /dm report total f\n\n一个例子: 向玩家'Charia'发送列表中前3名的资料:\n/dm report w3 Charia";
DM_MSG_COLLECTORS = "数据收集者: (%s)";
DM_MSG_ACCUMULATING = "伤害统计: 数据累积已开启.";
DM_MSG_REPORTTOTALDPS = "总计 = %.1f (%.1f 可见)";
DM_MSG_REPORTTOTAL = "总计 = %d (%d 可见)";
DM_MSG_SYNCMSG = "[DMM] |Hplayer:%s|h[%s]|h: %s";
DM_MSG_MEMCLEAR = "伤害统计: 清除保存列表.";
DM_MSG_MAXBARS = "伤害统计: 显示最大统计个数设置为 %s.";
DM_MSG_MINBARS = "伤害统计: 设置最小化到 %s.";
DM_MSG_LEADERREPORTHEADER = "伤害统计: 团长报告于 %d/%d 单位:\n #";
-- This causes disconnects...maybe its too long?  ..maybe WoW doesn't like the \n character?
--DM_MSG_FULLREPORTHEADER = "伤害统计: 完整报告于 %d/%d 单位:\n玩家        伤害量     治疗量     承受伤害      接受治疗        击中   致命\n_______________________________________________________________________________";
DM_MSG_FULLREPORTHEADER1 = "伤害统计: 完整报告于 %d/%d 单位:";
DM_MSG_FULLREPORTHEADER2 = "玩家        伤害量     治疗量     承受伤害      接受治疗        击中   致命";
DM_MSG_FULLREPORTHEADER3 = "_______________________________________________________________________________";
DM_MSG_CLEARACKNOWLEDGED = "伤害统计: 清除已知玩家 %s.";
DM_MSG_EVENTREPORTHEADER = "伤害统计: %d/%d 单位的详细数据报告:\n";
DM_MSG_PLAYERONLYEVENTDATAOFF = "伤害统计: 记录所有玩家的详细数据.";
DM_MSG_PLAYERONLYEVENTDATAON = "伤害统计: 只记录自己的详细数据.";
DM_MSG_SYNCCHANBROADCAST = "伤害统计: 将队内同步频道设置为: ";
DM_MSG_SYNCINGROUPON = "伤害统计: 你将只与队员同步.";
DM_MSG_SYNCINGROUPOFF = "伤害统计: 你将与任何人同步.";
DM_MSG_AUTOSYNCJOINON = "伤害统计: 你会自动加入同步频道.";
DM_MSG_AUTOSYNCJOINOFF = "伤害统计: 你不再自动加入同步频道.";
DM_MSG_SYNCHELP = "数据同步是多个伤害统计插件(DamageMeters)互相传输数据的过程. 它主要用在玩家经常因为互相距离太远而接收不到其他人的战斗信息的副本中.\n\n同步设置快速指引:\n\n1) 一个玩家(称他为Leader)设置一个频道名并加入, 比如 /dm syncchan ourchannel.\n2) Leader使用 /dm syncbroadcastchan (或者/dm syncb). 任何使用较新版本伤害统计插件的玩家都会自动加入这个频道.\n3) Leader为当前副本进程选择一个名字--比如 Onyxia ,使用 /dm syncstart 来设置(/dm syncstart Onyxia). 这样会清除每个玩家的数据并暂停,并且标记当前副本进程.\n3) 一旦每个人都在频道了,在开始RAID前, Leader应该使用 /dm syncready 或者 /dm syncunpause 来使插件开始工作.\n4) 开始RAID吧! \n5) 最后使用 /dm sync 来同步数据.  这样会造成一些延迟所以最好打几仗再使用一次(虽然没必要每仗结束后都使用).  如果希望得到详细数据,使用(/dm sync e), 那么同步过程将更长一点.\n\n注意: Leader没有任何特别, 任何有伤害统计插件的玩家都能使用这些指令. 只是让一个人来负责简单一些.";
DM_MSG_PINGING = "伤害统计: 正在与其他玩家连接...";
DM_MSG_SYNCONLYPLAYEREVENTSON = "伤害统计: 自己的详细数据将被传送.";
DM_MSG_SYNCONLYPLAYEREVENTSOFF = "伤害统计: 所有玩家的详细数据将被传送.";
DM_MSG_SYNCPAUSE = "伤害统计:  %s 请求暂停统计.";
DM_MSG_SYNCUNPAUSE = "伤害统计:  %s 请求继续统计.";
DM_MSG_SYNCREADY = "伤害统计:  %s 准备就绪.";
DM_MSG_SYNCPAUSEREQ = "伤害统计: 发送暂停指令...";
DM_MSG_SYNCUNPAUSEREQ = "伤害统计: 发送继续指令...";
DM_MSG_SYNCREADYREQ = "伤害统计: 发送已准备就绪...";
DM_MSG_PRESSCONTROLEVENT = "按CTRL查看详细数据";
DM_MSG_PRESSCONTROLQUANTITY = "按CTRL查看统计数据";
DM_MSG_PRESSALTSINGLEQUANTITY = "按ALT查看当前数据";
DM_MSG_PAUSEDTITLE = "暂停";
DM_MSG_READYTITLE = "准备就绪";
DM_MSG_EVENTDATALEVEL = {
	"伤害统计: 不分析详细数据.",
	"伤害统计: 只分析自己的详细数据.",
	"伤害统计: 分析所有玩家的详细数据."
};
DM_MSG_SYNCEVENTDATALEVEL = {
	"伤害统计: 不传送详细数据.",
	"伤害统计: 传送自己的详细数据.",
	"伤害统计: 传送所有玩家的详细数据."
};
DM_MSG_HELP = "- 输入 /dm cmd 显示所有指令.\n- 如果你不可见DM面板,请使用 /dm resetpos.";
DM_MSG_LEAVECHAN = "伤害统计: 离开频道 '%s'.";
DM_MSG_READYUNPAUSING = "伤害统计: 详细数据已接收,发送继续传输指令...";
DM_MSG_KICKED = "伤害统计: 你被 %s 移出同步频道.";
DM_MSG_SETLABEL = "伤害统计: 当前进程标记为 <%s>. (标签 = %d)";
DM_MSG_SESSIONMISMATCH = "伤害统计: 接收到不同进程同步数据.自动清除.";
DM_MSG_SHOWINGFIGHTEVENTSONLY = "仅显示本次战斗详细数据.";
DM_MSG_SYNCCLEARREQ = "伤害统计: 发送清除请求...";
DM_MSG_CURRENTBARWIDTH = "伤害统计: 当前显示条宽度 = %d.\n使用 (/dm setbarwidth default) 来重置宽度到默认值.";
DM_MSG_NEWBARWIDTH = "伤害统计: 新的显示条宽度 = %d.";
DM_MSG_PLAYERJOINEDSYNCCHAN = "伤害统计: 玩家 %s 加入同步频道. [版本 %s]";
DM_MSG_SYNCSESSIONMISMATCH = "玩家 %s 的进程 (%s:%d) 不符: 玩家数据清除.";
DM_MSG_SYNCHALTRECEIVED = "伤害统计: 同步中止命令接收于 %s.";
DM_MSG_SYNCHALTSENT = "伤害统计: 发送中止命令...";
DM_MSG_SYNCSESSIONCURRENT = "伤害统计: 你已经在一个同步中.";
DM_MSG_SYNCNOSESSIONS = "伤害统计: 没有发现同步";
-- RPS
DM_MSG_RPS_CHALLENGE = "你和 %s 玩石头剪刀布!  你出了 %s.";
DM_MSG_RPS_CHALLENGED = "%s 和你玩石头剪刀布!  使用 /dm rpsr [player] [r/p/s] (r=石头 p=布 s=剪刀) 回应.";
DM_MSG_RPS_MISSING_PLAYER = "错误: 请求无效.  当前只能有一名玩家和你猜拳所以其他玩家请求被忽略.";
DM_MSG_RPS_NOTCHALLENGED = "错误: %s 并没有和你玩石头剪刀布.";
DM_MSG_RPS_YOUPLAY = "你出了 %s.";
DM_MSG_RPS_PLAYS = "%s 出了 %s.";
DM_MSG_RPS_DEFEATED = "%s 打败了你.";
DM_MSG_RPS_VICTORIOUS = "你打败了 %s!"
DM_MSG_RPS_TIE = "你和 %s 玩厌了.";

--[[ Note: This is only to help construct the DM_MSG_REPORTHELP string.
/dm report指令包含3个部分:

1) 发送目标. 包含以下几点:
  c - 控制台(只有你可见)%.
  s - 说
  p - 小队
  r - 团队
  g - 公会
  h - 聊天频道.如 /dm report h mychannel
  w - 悄悄话.如 /dm report w 某某
  f - 面板: 在窗口中显示报告.

下方的字母将有更高的优先级(最低到最高)%.

2) 随意的限制数,这个数字紧跟在发送目标后.
如: /dm report p5

3) 默认情况下,报告只发送当前显示类别. 如果'total'被指定在发送目标前, 那么报告将发送每个类别. 完整报告是规整的以方便剪切-粘贴到一个文本文件,所以最好指定面板显示.
如: /dm report total f

一个例子: 向玩家'Charia'发送列表中前3名的资料:
/dm report w3 Charia
]]--

--[[ Note: This is only to help construct the DM_MSG_SYNCHELP string.
DamageMeters Sync'ing (short for synchronization) is a process whereby multiple DM users can transmit their data to each other.  Its primary use is for instances where the players are often far from each other and thus miss some of each other's combat messages.\n\nSync Quick-Start Guide:\n\n1) Someone (I'll call her the Sync Leader) chooses a channel name and joins it, ie. /dm syncchan ourchannel.\n2) The Sync Leader then calls /dm syncbroadcastchan (or just /dm syncb).  Anyone who is running a sufficiently recent version of DM will automatically be joined into that channel.\n3) The Sync Leader choses a name for the session--for example, Onyxia-- then calls /dm syncstart with that name. (/dm syncstart Onyxia_.  This will clear everyone's data and pause them, as well as mark them with this label.\n3) Once everyone is in the channel, but before the activity begins, the Sync  Leader should call /dm syncready or /dm syncunpause so that data collection can happen.\n4) Play!  Collect data!\n5) Finally, the Sync Leader calls /dm sync whenever she wants the raid to share data.  Since it can cause a little slowdown it is best to do this between fights (though not necessarily between every fight).  If event data is desired, call (/dm sync e), though it takes a lot longer to sync.\n\nNote: There is nothing special about the Sync Leader: any player can perform any of these commands.  It just seems simpler to have one person in charge of it.
]]--

-- Menu Options --
DM_MENU_CLEAR = "清除";
DM_MENU_RESETPOS = "重置位置";
DM_MENU_HIDE = "隐藏面板";
DM_MENU_SHOW = "显示面板";
DM_MENU_VISINPARTY = "只在队伍中可见";
DM_MENU_REPORT = "生成报告";
DM_MENU_BARCOUNT = "统计个数";
DM_MENU_AUTOCOUNTLIMIT = "自动统计限制";
DM_MENU_SORT = "排列类型";
DM_MENU_VISIBLEQUANTITY = "显示类别";
--DM_MENU_COLORSCHEME = "颜色显示";
DM_MENU_MEMORY = "内存计数";
DM_MENU_SAVE = "保存";
DM_MENU_RESTORE = "恢复";
DM_MENU_MERGE = "合并";
DM_MENU_SWAP = "交换";
DM_MENU_DELETE = "删除";
DM_MENU_BAN = "禁止";
DM_MENU_CLEARABOVE = "清除以上";
DM_MENU_CLEARBELOW = "清除以下";
--DM_MENU_LOCK = "锁定列表";
--DM_MENU_UNLOCK = "解锁列表";
DM_MENU_PAUSE = "暂停统计";
--DM_MENU_UNPAUSE = "继续统计";
DM_MENU_LOCKPOS = "锁定位置";
DM_MENU_UNLOCKPOS = "解锁位置";
DM_MENU_GROUPMEMBERSONLY = "只监视队内成员";
DM_MENU_ADDPETTOPLAYER = "将宠物数据做为自己的数据";
DM_MENU_TEXT = "文字选项";
DM_MENU_TEXT_RANK = "排行";
DM_MENU_TEXT_NAME = "姓名";
DM_MENU_TEXT_TOTALPERCENTAGE = "百分比";
DM_MENU_TEXT_LEADERPERCENTAGE = "与第一相比";
DM_MENU_TEXT_VALUE = "值";
DM_MENU_TEXT_DELTA = "差值";
DM_MENU_SETCOLORFORALL = "将所有颜色设为";
DM_MENU_DEFAULTCOLORS = "恢复默认颜色";
DM_MENU_RESETONCOMBATSTARTS = "战斗开始时重置数据";
DM_MENU_SHOWFIGHTASPS = "显示本次战斗的每秒数据";
DM_MENU_REFRESHBUTTON = "刷新";
DM_MENU_TOTAL = "总计";
DM_MENU_CHOOSEREPORT = "选择报告";
-- Note reordered this list in version 2.2.0
DM_MENU_REPORTNAMES = {"面板", "控制台", "说", "小队", "团队", "公会", "公会管理"};
DM_MENU_TEXTCYCLE = "循环";
DM_MENU_QUANTCYCLE = "循环显示";
DM_MENU_HELP = "帮助";
DM_MENU_ACCUMULATEINMEMORY = "数据累计";
DM_MENU_POSITION = "位置";
DM_MENU_RESIZELEFT = "向左延伸";
DM_MENU_RESIZEUP = "向上延伸";
DM_MENU_SHOWMAX = "显示最大";
DM_MENU_SHOWTOTAL = "显示全部";
DM_MENU_LEADERS = "Leaders";
DM_MENU_PLAYERREPORT = "玩家报告";
DM_MENU_EVENTREPORT = "详细数据报告";
DM_MENU_EVENTDATA = "详细数据";
DM_MENU_EVENTDATA_NONE = "不分析详细数据";
DM_MENU_EVENTDATA_PLAYER = "分析自己的详细数据";
DM_MENU_EVENTDATA_ALL = "分析所有玩家的详细数据";
--DM_MENU_SYNCEVENTDATA_NONE = "不传送详细数据";
--DM_MENU_SYNCEVENTDATA_PLAYER = "传送自己的详细数据";
--DM_MENU_SYNCEVENTDATA_ALL = "传送所有玩家的详细数据";
DM_MENU_SHOWEVENTDATATOOLTIP = "详细数据";
DM_MENU_EVENTS1 = "事件1-20";
DM_MENU_EVENTS2 = "事件21-40";
DM_MENU_EVENTS3 = "事件41-50";
DM_MENU_SYNC = "数据同步";
DM_MENU_ONLYSYNCWITHGROUP = "只在队内同步";
DM_MENU_PERMITSYNCAUTOJOIN = "加入同步频道";
DM_MENU_CLEARONAUTOJOIN = "加入时清除";
DM_MENU_SYNCBROADCASTCHAN = "广播同步频道";
DM_MENU_SYNCLEAVECHAN = "离开频道";
DM_MENU_SYNCONLYPLAYEREVENTS = "只同步自己的详细数据";
DM_MENU_ENABLEDMM = "显示DMM消息";
DM_MENU_NOSYNCCHAN = "未设置同步频道";
DM_MENU_SYNCCHAN = "当前同步频道 = ";
DM_MENU_SESSION = "当前进程 = ";
DM_MENU_SAVEDSESSION = "进程 = ";
DM_MENU_JOINSYNCCHAN = "加入频道请使用 /dm syncchan";
DM_MENU_PARSEEVENTMESSAGES = "分析接收详细数据中";
DM_MENU_SENDINGBAR = "发送中...";
DM_MENU_PROCESSINGBAR = "处理中...";
DM_MENU_QUANTITYFILTER = "循环显示";
DM_MENU_MINIMIZE = "最小化";
DM_MENU_LEFTJUSTIFYTEXT = "左对齐";
DM_MENU_RESTOREDEFAULTOPTIONS = "恢复默认设置";
DM_MENU_PLAYERALWAYSVISIBLE = "自己总是可见";
DM_MENU_APPLYFILTERTOMANUALCYCLING = "循环所有类别";
DM_MENU_APPLYFILTERTOAUTOCYCLING = "循环选中类别";
DM_MENU_GENERAL = "一般选项";
DM_MENU_GROUPDPSMODE = "全局DPS模式";
DM_MENU_CLEARBANNED = "解除所有禁止单位";
DM_MENU_CONSTANTVISUALUPDATE = "状态条连续更新";
DM_MENU_CLEARWHENJOINPARTY = "加入队伍时清除";
DM_MENU_AUTOSYNC = "自动同步";
DM_MENU_STARTNEWSESSION = "开始新的通信";
DM_MENU_SYNCGROUPDATA = "同步组数据";
DM_MENU_SYNCREADY = "请求就绪";
DM_MENU_SYNCPAUSE = "请求暂停";
DM_MENU_SYNCCLEAR = "请求清除";
DM_MENU_REPORTCHANNEL = "频道";
DM_MENU_REPORTWHISPER = "密语";
DM_MENU_ENABLESYNC = "激活数据同步";
DM_MENU_SYNCREQSESSION = "请求同步ID";
DM_MENU_HIDESCROLLBAR = "隐藏滚动条";

-- Misc
DM_CLASS = "职业"; -- The word for player class, like Druid or Warrior.
DM_TOOLTIP = "\n空闲时间 = %.1fs\n关系 = %s";
DM_YOU = "你"
DM_CRITSTR = "重击";
DM_UNKNOWNENTITY = "未知单位";
DM_SYNCSPELLNAME = "[Sync]";
DM_NEWSESSIONID = "输入新的同步ID: "
DM_REPORTCHANNEL = "报告到指定频道,请输入频道名字或编号: "
DM_REPORTWHISPER = "报告给玩家,请输入一个玩家的名字: "

DM_DMG_MELEE = "[近战攻击]";
DM_DMG_FALLING = "[摔伤]";
DM_DMG_LAVA = "[岩浆]";
DM_DMG_DAMAGESHIELD = "[伤害反弹]";
DM_DMG_DEATH = "[死亡]";
DM_DMG_COMBAT = "[脱离战斗]";

DamageMeters_RPSmoveStrings = 
{ 
	r = "石头", 
	p = "布", 
	s = "剪刀" 
};

-------------------------------------------------------------------------------

--[[ This system based on the one in Gello's Recap, which itself was based on the one in Telo's MobHealth.
- source and dest = 0 means the player

TODO: These are all special cases in English because they contain apostrophes. 
Julie's Dagger
Rammstein's Lightning Bolts
Night Dragon's Breath

]]--

--[[
This table defines types of messages that DM parses and how to parse them.

The index of the table is a human-readable name, which by convention is
normally the name of the string variable (as defined in GlobalStrings.lua) that
is being parsed.  Every type of message that is parsed for the "Damage Done", 
"Healing Done", "Damage Taken", and "Healing Taken" quantities must be defined in this
table.

The key to the system is the "pattern" member.  This is usually (there are some 
special cases) a string defined in GlobalStrings.lua.  An example is COMBATHITSELFOTHER =
"You hit %s for %d.".  When DM loads up it goes through this list and converts all the 
patterns into "regular expression" search strings.  So, for example, the above becomes
"You hit (.+) for (%d+)%."  

When a match is found there will be an array of "elements" for
each unknown in the pattern.  In the above pattern, elements[1] will be the string name
of who was hit, and elements[2] will be how much damage was done.  Each msgInfo has fields
in which you specify which elements mean what.  So, in the msgInfo for this example we set
"dest=1" and "amount=2".  

The fields of each entry are defined as follows:
- source: The index of the element that specifies the source of the amount.  The source is the 
person doing damage or doing the healing in the case of "Damage done" and "healing done" messages,
but it is the the person being hit in the case of "damage received" messages.  When source=0, it 
means the player (us) is the source.
- dest: The name of the entity being effected.  Again, dest=0 means the player.
- amount: The index of the element that contains the quantity of damage/healing done.
- spell: This is the index of the element which references the spell that is doing the damage/healing.
Alternately, if it is a string that spell will be used explicitly.  Spell=0 or nil defaults to regular
melee damage.
- damageType: Also known as "school", this is the index of the element which specifies the type of
damage done, ie. "physical", "fire", "frost", etc.
- crit: This is one of three defined values: DM_HIT, DM_CRT, DM_DOT.  Set this to specify whether
the message represents a spell that hit normally, critically hit, or was a non-crittable spell. 
(Damage Over Time spells, DOTs, cannot crit, hence the name.)
- pattern: This is the pattern, usually a string from GlobalStrings.lua.
- custom: If this is set to true, the pattern will not be transformed when DM is loaded.  Use
this for custom patterns.
]]--

DamageMeters_msgInfo = {
	-- CHAT_MSG_COMBAT_SELF_HITS
		_COMBATHITSELFOTHER = 
			{ source=0, dest=1, amount=2, spell=0, damageType=0, crit=DM_HIT, pattern="COMBATHITSELFOTHER" }, -- You hit (.+) for (%d+)
		_COMBATHITCRITSELFOTHER = 
			{ source=0, dest=1, amount=2, spell=0, damageType=0, crit=DM_CRT, pattern="COMBATHITCRITSELFOTHER" }, -- You crit (.+) for (%d+)
		_VSENVIRONMENTALDAMAGE_FALLING_SELF = 
			{ source=0, dest=0, amount=1, spell=DM_DMG_FALLING, damageType=0, crit=DM_DOT, pattern="VSENVIRONMENTALDAMAGE_FALLING_SELF" }, -- You fall and lose (%d+) health
		_VSENVIRONMENTALDAMAGE_LAVA_SELF = 
			{ source=0, dest=0, amount=1, spell=DM_DMG_LAVA, damageType=0, crit=DM_DOT, pattern="VSENVIRONMENTALDAMAGE_LAVA_SELF" }, -- You lose %d health for swimming in lava.

		
	-- CHAT_MSG_SPELL_SELF_DAMAGE
		_SPELLLOGSCHOOLSELFOTHER =
			{ source=0, dest=2, amount=3, spell=1, damageType=4, crit=DM_HIT, pattern="SPELLLOGSCHOOLSELFOTHER" }, -- Your (.+) hits (.+) for (%d+) (.+)%.
		_SPELLLOGCRITSCHOOLSELFOTHER =
			{ source=0, dest=2, amount=3, spell=1, damageType=4, crit=DM_CRT, pattern="SPELLLOGCRITSCHOOLSELFOTHER" }, -- "Your %s crits %s for %d %s damage.";
		_SPELLLOGSELFOTHER =
			{ source=0, dest=2, amount=3, spell=1, damageType=0, crit=DM_HIT, pattern="SPELLLOGSELFOTHER" }, -- Your (.+) hits (.+) for (%d+)
		_SPELLLOGCRITSELFOTHER = 
			{ source=0, dest=2, amount=3, spell=1, damageType=0, crit=DM_CRT, pattern="SPELLLOGCRITSELFOTHER" }, -- Your (.+) crits (.+) for (%d+)

	-- "CHAT_MSG_SPELL_PERIODIC_CREATURE_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_DAMAGE"
		-- No such message.
		--_PERIODICAURADAMAGEABSORBEDSELFOTHER =
		--	{ source=0, dest=1, amount=2, spell=4, damageType=3, crit=DM_DOT, pattern="PERIODICAURADAMAGEABSORBEDSELFOTHER" }, -- = "%s suffers %d %s damage from your %s (%d absorbed)."
		_PERIODICAURADAMAGESELFOTHER =
			{ source=0, dest=2, amount=3, spell=1, damageType=3, crit=DM_DOT, pattern="PERIODICAURADAMAGESELFOTHER" }, -- (.+) suffers (%d+) (.+) damage from your (.+).
		-- No such message.
		--_PERIODICAURADAMAGEABSORBEDOTHEROTHER =
		--	{ source=4, dest=1, amount=2, spell=5, damageType=3, crit=DM_DOT, pattern="PERIODICAURADAMAGEABSORBEDOTHEROTHER" }, -- %s suffers %d %s damage from %s's %s (%d absorbed).
		_PERIODICAURADAMAGEOTHEROTHER =
			{ source=1, dest=3, amount=4, spell=2, damageType=0, crit=DM_DOT, pattern="PERIODICAURADAMAGEOTHEROTHER" }, -- (.+) suffers (%d+) (.+) damage from (.+)'s (.+)

	-- "CHAT_MSG_COMBAT_PARTY_HITS" or "CHAT_MSG_COMBAT_FRIENDLYPLAYER_HITS" or	"CHAT_MSG_COMBAT_PET_HITS")
		_COMBATHITOTHEROTHER = 
			{ source=1, dest=2, amount=3, spell=7, damageType=0, crit=DM_HIT, pattern="(.+)击中(.+)造成(%d+)点" }, -- (.+) hits (.+) for (%d+)
		_COMBATHITCRITOTHEROTHER =
			{ source=1, dest=2, amount=3, spell=7, damageType=0, crit=DM_CRT, pattern="(.+)的致命一击对(.+)造成(%d+)" }, -- (.+) crits (.+) for (%d+)
		_VSENVIRONMENTALDAMAGE_FALLING_OTHER =
			{ source=1, dest=1, amount=2, spell=DM_DMG_FALLING, damageType=0, crit=DM_DOT, pattern="VSENVIRONMENTALDAMAGE_FALLING_OTHER" }, -- %s falls and loses %d health.
		_VSENVIRONMENTALDAMAGE_LAVA_OTHER =
			{ source=1, dest=1, amount=2, spell=DM_DMG_LAVA, damageType=0, crit=DM_DOT, pattern="VSENVIRONMENTALDAMAGE_LAVA_OTHER" }, -- %s loses %d health for swimming in lava.

	-- "CHAT_MSG_SPELL_PARTY_DAMAGE"  "CHAT_MSG_SPELL_FRIENDLYPLAYER_DAMAGE" "CHAT_MSG_SPELL_PET_DAMAGE"
		_SPELLLOGOTHEROTHER =
			{ source=1, dest=3, amount=4, spell=2, damageType=0, crit=DM_HIT, pattern="SPELLLOGOTHEROTHER" }, -- (.+)'s (.+) hits (.+) for (%d+)
		_SPELLLOGCRITOTHEROTHER =
			{ source=1, dest=3, amount=4, spell=2, damageType=0, crit=DM_CRT, pattern="SPELLLOGCRITOTHEROTHER" }, -- (.+)'s (.+) crits (.+) for (%d+)
		_SPELLSPLITDAMAGEOTHEROTHER =
			{ source=1, dest=3, amount=4, spell=2, damageType=0, crit=DM_DOT, pattern="SPELLSPLITDAMAGEOTHEROTHER" }, -- (.+)'s (.+) causes (.+) (%d+) damage

	-- CHAT_MSG_SPELL_DAMAGESHIELDS_ON_SELF
		_DAMAGESHIELDSELFOTHER =
			{ source=0, dest=3, amount=1, spell=DM_DMG_DAMAGESHIELD, damageType=0, crit=DM_DOT, pattern="DAMAGESHIELDSELFOTHER" }, -- You reflect (%d+) (.+) damage to (.+)

	-- CHAT_MSG_SPELL_DAMAGESHIELDS_ON_OTHERS
		_DAMAGESHIELDOTHEROTHER = 
			{ source=1, dest=4, amount=2, spell=DM_DMG_DAMAGESHIELD, damageType=0, crit=DM_DOT, pattern="DAMAGESHIELDOTHEROTHER" }, -- (.+) reflects (%d+) (.+) damage to (.+)
		-- ? soul link or something?
		_SPELLSPLITDAMAGESELFOTHER = 
			{ source=0, dest=2, amount=3, spell=1, damageType=0, crit=DM_DOT, pattern="SPELLSPLITDAMAGESELFOTHER" }, -- Your (.+) causes (.+) (%d+) damage
		
-- DAMAGE TAKEN
	--"CHAT_MSG_COMBAT_CREATURE_VS_SELF_HITS" -- this gets complicated with pets.
	--"CHAT_MSG_COMBAT_CREATURE_VS_PARTY_HITS" 
	--"CHAT_MSG_COMBAT_CREATURE_VS_CREATURE_HITS" 
		_COMBATHITOTHERSELF = 
			{ source=1, dest=0, amount=2, crit=DM_HIT, pattern="COMBATHITOTHERSELF" }, -- "%s hits you for %d.";
		_COMBATHITCRITOTHERSELF =
			{ source=1, dest=0, amount=2, crit=DM_CRT, pattern="COMBATHITCRITOTHERSELF" }, -- "%s crits you for %d.";
		_COMBATHITOTHEROTHER =
			{ source=1, dest=2, amount=3, crit=DM_HIT, pattern="(.+)击中(.+)造成(%d+)点" }, -- "%s hits %s for %d.";
		_COMBATHITCRITOTHEROTHER =
			{ source=1, dest=2, amount=3, crit=DM_CRT, pattern="(.+)的致命一击对(.+)造成(%d+)" }, -- "%s crits %s for %d.";
		_COMBATHITCRITSCHOOLOTHEROTHER = 
			{ source=1, dest=2, amount=3, damageType=4, crit=DM_CRT, pattern="COMBATHITCRITSCHOOLOTHEROTHER" }, -- "%s crits %s for %d %s damage.";
		_COMBATHITSCHOOLOTHEROTHER = 
			{ source=1, dest=2, amount=3, damageType=4, crit=DM_HIT, pattern="COMBATHITSCHOOLOTHEROTHER" }, -- "%s hits %s for %d %s damage.";
		_COMBATHITCRITSCHOOLOTHERSELF = 
			{ source=1, dest=0, amount=2, damageType=3, crit=DM_CRT, pattern="COMBATHITCRITSCHOOLOTHERSELF" }, -- "%s crits you for %d %s damage.";
		_COMBATHITSCHOOLOTHERSELF = 
			{ source=1, dest=0, amount=2, damageType=3, crit=DM_HIT, pattern="COMBATHITSCHOOLOTHERSELF" }, -- "%s hits you for %d %s damage.";
	

	--"CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE" or
	--"CHAT_MSG_SPELL_CREATURE_VS_PARTY_DAMAGE" or
	--"CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE") then
		_SPELLLOGOTHERSELF = 
			{ source=1, dest=0, amount=3, spell=2, damageType=0, crit=DM_HIT, pattern="SPELLLOGOTHERSELF" }, -- "%s's %s hits you for %d.";
		_SPELLLOGSCHOOLOTHERSELF = 
			{ source=1, dest=0, amount=3, spell=2, damageType=4, crit=DM_HIT, pattern="SPELLLOGSCHOOLOTHERSELF" }, --  "%s's %s hits you for %d %s damage.";
		_SPELLLOGCRITSCHOOLOTHERSELF =
			{ source=1, dest=0, amount=3, spell=2, damageType=4, crit=DM_CRT, pattern="SPELLLOGCRITSCHOOLOTHERSELF" }, --  "%s's %s crits you for %d %s damage.";
		_SPELLLOGCRITOTHERSELF =
			{ source=1, dest=0, amount=3, spell=2, crit=DM_CRT, pattern="SPELLLOGCRITOTHERSELF" }, -- "%s's %s crits you for %d.";
		-- bunch of junk in here in the old code
		_SPELLRESISTOTHERSELF =
			{ source=1, dest=0, amount=0, spell=2, crit=DM_HIT, pattern="SPELLRESISTOTHERSELF" }, -- "%s's %s was resisted.";
		
		_SPELLLOGSCHOOLOTHEROTHER =
			{ source=1, dest=3, amount=4, spell=2, damageType=5, crit=DM_HIT, pattern="SPELLLOGSCHOOLOTHEROTHER" }, --  "%s's %s hits %s for %d %s damage.";
		_SPELLLOGCRITSCHOOLOTHEROTHER =
			{ source=1, dest=3, amount=4, spell=2, damageType=5, crit=DM_CRT, pattern="SPELLLOGCRITSCHOOLOTHEROTHER" }, --  "%s's %s crits %s for %d %s damage.";
		_SPELLRESISTOTHEROTHER =
			{ source=1, dest=3, amount=0, spell=2, crit=DM_HIT, pattern="SPELLRESISTOTHEROTHER" }, -- "%s's %s was resisted by %s.";

	--"CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE"
		_PERIODICAURADAMAGEOTHERSELF =
			{ source=3, dest=0, amount=1, spell=4, damageType=2, crit=DM_DOT, pattern="PERIODICAURADAMAGEOTHERSELF" }, -- "You suffer %d %s damage from %s's %s."
		_PERIODICAURADAMAGESELFSELF =
			{ source=0, dest=0, amount=1, spell=3, damageType=2, crit=DM_DOT, pattern="PERIODICAURADAMAGESELFSELF" }, -- "You suffer %d %s damage from your %s."
		-- pet
		_PERIODICAURADAMAGEOTHEROTHER =
			{ source=1, dest=3, amount=4, spell=2, damageType=3, crit=DM_DOT, pattern="PERIODICAURADAMAGEOTHEROTHER" }, -- "%s suffers %d %s damage from %s's %s."

--HEALING
	-- "CHAT_MSG_SPELL_SELF_BUFF" "CHAT_MSG_SPELL_PARTY_BUFF" "CHAT_MSG_SPELL_FRIENDLYPLAYER_BUFF" "CHAT_MSG_SPELL_HOSTILEPLAYER_BUFF"
		_HEALEDSELFSELF =
			{ source=0, dest=0, amount=2, spell=1, crit=DM_HIT, pattern="HEALEDSELFSELF" }, -- "Your %s heals you for %d.";
		_HEALEDCRITSELFSELF =
			{ source=0, dest=0, amount=2, spell=1, crit=DM_CRT, pattern="HEALEDCRITSELFSELF" }, -- "Your %s critically heals you for %d.";
		_HEALEDSELFOTHER =
			{ source=0, dest=2, amount=3, spell=1, crit=DM_HIT, pattern="HEALEDSELFOTHER" }, -- "Your %s heals %s for %d."
		-- missing some here, ie. HEALEDSELFSELF "Your %s heals you for %d."
		_HEALEDCRITSELFOTHER =
			{ source=0, dest=2, amount=3, spell=1, crit=DM_CRT, pattern="HEALEDCRITSELFOTHER" }, -- "Your %s critically heals %s for %d.";
		__NIGHTDRAGONSBREATHOTHER = 
			{ source=1, dest=2, amount=3, spell="Night Dragon's Breath", crit=DM_HIT, pattern="(.+)'s Night Dragon's Breath heals (.+) for (%d+)%.", custom=true }, -- "%s's Night Dragon's Breath heals %s for %d.";
		__NIGHTDRAGONSBREATHOTHERCRIT = 
			{ source=1, dest=2, amount=3, spell="Night Dragon's Breath", crit=DM_CRT, pattern="(.+)'s Night Dragon's Breath critically heals (.+) for (%d+)%.", custom=true }, -- "%s's Night Dragon's Breath heals %s for %d.";
		_HEALEDOTHERSELF = 
			{ source=1, dest=0, amount=3, spell=2, crit=DM_HIT, pattern="HEALEDOTHERSELF" }, -- "%s's %s heals %s you %d.";
		_HEALEDCRITOTHERSELF = 
			{ source=1, dest=0, amount=3, spell=2, crit=DM_CRT, pattern="HEALEDCRITOTHERSELF" }, -- "%s's %s critically heals %s you %d.";
		_HEALEDOTHEROTHER =
			{ source=1, dest=3, amount=4, spell=2, crit=DM_HIT, pattern="HEALEDOTHEROTHER" }, -- "%s's %s heals %s for %d.";
		_HEALEDCRITOTHEROTHER =
			{ source=1, dest=3, amount=4, spell=2, crit=DM_CRT, pattern="HEALEDCRITOTHEROTHER" }, -- "%s's %s critically heals %s for %d.";
	
	--"CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS" "CHAT_MSG_SPELL_PERIODIC_PARTY_BUFFS" "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_BUFFS" "CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_BUFFS" -- why?
		__JULIESBLESSINGOTHER =
			{ source=3, dest=1, amount=2, spell="Julie's Blessing", crit=DM_HIT, pattern="(.+) gains (%d+) health from (.+)'s Julie's Blessing%.", custom=true }, 

		_PERIODICAURAHEALOTHERSELF =
			{ source=1, dest=0, amount=3, spell=2, crit=DM_DOT, pattern="PERIODICAURAHEALOTHERSELF" }, -- "You gain %d health from %s's %s."
		_PERIODICAURAHEALSELFSELF =
			{ source=0, dest=0, amount=2, spell=1, crit=DM_DOT, pattern="PERIODICAURAHEALSELFSELF" }, -- "You gain %d health from %s."
		_PERIODICAURAHEALSELFOTHER =
			{ source=0, dest=1, amount=2, spell=3, crit=DM_DOT, pattern="PERIODICAURAHEALSELFOTHER" }, -- "%s gains %d health from your %s."
		_PERIODICAURAHEALOTHEROTHER =
			{ source=3, dest=1, amount=2, spell=4, crit=DM_DOT, pattern="PERIODICAURAHEALOTHEROTHER" }, -- "%s gains %d health from %s's %s."
		
--CURING	
};

--[[ DamageMeters_eventCaseTable

This table defines which msgInfos are checked for which events.  Although its a bit of a pain
maintaining this big list there are several big reasons why we do so.  First and foremost, we
gain some information about the players involved in a message from the event type.  For example,
we can deduce that if the event was CHAT_MSG_COMBAT_CREATURE_VS_SELF_HITS and the message was of the 
type "[Someone] hit [someone] for [amount] damage." that the entity being hit was not us but rather
a pet or totem of ours.  The second reason for this table is to greatly reduce the amount of patterns
each event is compared against.  The final reason is that sometimes the order of parsing is critical.

Here is an example:

HEALEDOTHEROTHER = "%s's %s heals %s for %d."
HEALEDCRITOTHEROTHER - "%s's %s critically heals %s for %d."

If we feed the following message into the above patterns, the 
HEALEDOTHEROTHER will generate the following elements:

"Dandelion's Healing Touch critically heals Sterne for 1234."
->
"Dandelion", "Healing Touch critically", "Sterne", 1234

Hence, we must in this case test for HEALEDCRITOTHEROTHER before HEALEDOTHEROTHER.

]]--

DamageMeters_eventCaseTable = {
	[DM_MSGTYPE_DAMAGE] = {
		CHAT_MSG_COMBAT_SELF_HITS = { 
			[1] = { n = "_COMBATHITSELFOTHER" }, -- ok
			[2] = { n = "_COMBATHITCRITSELFOTHER" }, -- ok
			[3] = { n = "_VSENVIRONMENTALDAMAGE_FALLING_SELF", msgType=DM_MSGTYPE_DAMAGERECEIVED }, -- ok
			[4] = { n = "_VSENVIRONMENTALDAMAGE_LAVA_SELF", msgType=DM_MSGTYPE_DAMAGERECEIVED }, -- ok
		},
		CHAT_MSG_SPELL_SELF_DAMAGE = {
			-- These two are for school-less "spells" like Heroic Strike.
			[1] = { n = "_SPELLLOGSELFOTHER" }, -- ok
			[2] = { n = "_SPELLLOGCRITSELFOTHER" }, -- ok
			-- These are for regular spells (ie. with Frost damage, etc).
			[3] = { n = "_SPELLLOGSCHOOLSELFOTHER" }, -- ok
			[4] = { n = "_SPELLLOGCRITSCHOOLSELFOTHER" }, -- ok
		},

		CHAT_MSG_SPELL_PERIODIC_CREATURE_DAMAGE = {
			[1] = { n = "_PERIODICAURADAMAGESELFOTHER" }, -- ok (rend)
			[2] = { n = "_PERIODICAURADAMAGEOTHEROTHER" }, -- ok
		},
		CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_DAMAGE = {
			[1] = { n = "_PERIODICAURADAMAGESELFOTHER" }, 
			[2] = { n = "_PERIODICAURADAMAGEOTHEROTHER" }, -- ok
		},

		CHAT_MSG_COMBAT_PARTY_HITS = {
			[1] = { n = "_COMBATHITOTHEROTHER", sourceRelation=DamageMeters_Relation_PARTY }, -- ok
			[2] = { n = "_COMBATHITCRITOTHEROTHER", sourceRelation=DamageMeters_Relation_PARTY }, -- ok
			[3] = { n = "_VSENVIRONMENTALDAMAGE_FALLING_OTHER", sourceRelation=DamageMeters_Relation_PARTY },
			[4] = { n = "_VSENVIRONMENTALDAMAGE_LAVA_OTHER", sourceRelation=DamageMeters_Relation_PARTY },
		},
		CHAT_MSG_COMBAT_FRIENDLYPLAYER_HITS = {
			[1] = { n = "_COMBATHITOTHEROTHER" }, -- ok
			[2] = { n = "_COMBATHITCRITOTHEROTHER" }, -- ok
			[3] = { n = "_VSENVIRONMENTALDAMAGE_FALLING_OTHER", sourceRelation=DamageMeters_Relation_FRIENDLY }, -- ok
			[4] = { n = "_VSENVIRONMENTALDAMAGE_LAVA_OTHER", sourceRelation=DamageMeters_Relation_FRIENDLY },
		},
		CHAT_MSG_COMBAT_PET_HITS = {
			[1] = { n = "_COMBATHITOTHEROTHER", sourceRelation=DamageMeters_Relation_PET }, -- ok
			[2] = { n = "_COMBATHITCRITOTHEROTHER", sourceRelation=DamageMeters_Relation_PET }, --ok
			[3] = { n = "_VSENVIRONMENTALDAMAGE_FALLING_OTHER", destRelation=DamageMeters_Relation_PET, msgType=DM_MSGTYPE_DAMAGERECEIVED }, -- ok
			[4] = { n = "_VSENVIRONMENTALDAMAGE_LAVA_OTHER", destRelation=DamageMeters_Relation_PET, msgType=DM_MSGTYPE_DAMAGERECEIVED }, -- ok
		},

		CHAT_MSG_SPELL_PARTY_DAMAGE = {
			[1] = { n = "_SPELLLOGCRITSCHOOLOTHEROTHER", sourceRelation=DamageMeters_Relation_PARTY }, -- ok
			[2] = { n = "_SPELLLOGSCHOOLOTHEROTHER", sourceRelation=DamageMeters_Relation_PARTY }, -- ok
			[3] = { n = "_SPELLLOGCRITOTHEROTHER", sourceRelation=DamageMeters_Relation_PARTY }, -- ok
			[4] = { n = "_SPELLLOGOTHEROTHER", sourceRelation=DamageMeters_Relation_PARTY }, -- ok
			[5] = { n = "_SPELLSPLITDAMAGEOTHEROTHER", sourceRelation=DamageMeters_Relation_PARTY },
		},
		CHAT_MSG_SPELL_FRIENDLYPLAYER_DAMAGE = {
			[1] = { n = "_SPELLLOGCRITSCHOOLOTHEROTHER" }, -- ok
			[2] = { n = "_SPELLLOGSCHOOLOTHEROTHER" }, -- ok
			[3] = { n = "_SPELLLOGCRITOTHEROTHER" }, -- ok
			[4] = { n = "_SPELLLOGOTHEROTHER" }, -- ok 
			[5] = { n = "_SPELLSPLITDAMAGEOTHEROTHER" },
		},
		CHAT_MSG_SPELL_PET_DAMAGE = {
			[1] = { n = "_SPELLLOGOTHEROTHER", sourceRelation=DamageMeters_Relation_PET }, -- ok
			[2] = { n = "_SPELLLOGCRITOTHEROTHER", sourceRelation=DamageMeters_Relation_PET }, -- ok
			-- Totems do school damage.
			[3] = { n = "_SPELLLOGCRITSCHOOLOTHEROTHER", sourceRelation=DamageMeters_Relation_PET },
			[4] = { n = "_SPELLLOGSCHOOLOTHEROTHER", sourceRelation=DamageMeters_Relation_PET }, -- ok
			[5] = { n = "_SPELLSPLITDAMAGEOTHEROTHER", sourceRelation=DamageMeters_Relation_PET },
		},

		CHAT_MSG_SPELL_DAMAGESHIELDS_ON_SELF = {
			[1] = { n = "_DAMAGESHIELDSELFOTHER" }, -- ok
		},
		CHAT_MSG_SPELL_DAMAGESHIELDS_ON_OTHERS = {
			[1] = { n = "_DAMAGESHIELDOTHEROTHER" }, -- ok
			[2] = { n = "_SPELLSPLITDAMAGESELFOTHER" },
		},
	},

	[DM_MSGTYPE_DAMAGERECEIVED] = {
		CHAT_MSG_COMBAT_CREATURE_VS_SELF_HITS = {
			[1] = { n = "_COMBATHITCRITOTHERSELF" }, -- ok
			[2] = { n = "_COMBATHITOTHERSELF" }, -- ok
			[3] = { n = "_COMBATHITCRITSCHOOLOTHERSELF" }, -- ok
			[4] = { n = "_COMBATHITSCHOOLOTHERSELF" }, -- ok

			[5] = { n = "_COMBATHITOTHEROTHER", destRelation=DamageMeters_Relation_PET }, -- ok
			[6] = { n = "_COMBATHITCRITOTHEROTHER", destRelation=DamageMeters_Relation_PET },
			[7] = { n = "_COMBATHITCRITSCHOOLOTHEROTHER", destRelation=DamageMeters_Relation_PET }, -- ok
			[8] = { n = "_COMBATHITSCHOOLOTHEROTHER", destRelation=DamageMeters_Relation_PET }, -- ok
		},
		CHAT_MSG_COMBAT_CREATURE_VS_PARTY_HITS = {
			[1] = { n = "_COMBATHITCRITOTHEROTHER", destRelation=DamageMeters_Relation_PARTY }, 
			[2] = { n = "_COMBATHITOTHEROTHER", destRelation=DamageMeters_Relation_PARTY }, -- ok
			[3] = { n = "_COMBATHITCRITSCHOOLOTHEROTHER", destRelation=DamageMeters_Relation_PARTY }, 
			[4] = { n = "_COMBATHITSCHOOLOTHEROTHER", destRelation=DamageMeters_Relation_PARTY }, -- ok
		},
		CHAT_MSG_COMBAT_CREATURE_VS_CREATURE_HITS = {
			[1] = { n = "_COMBATHITCRITOTHEROTHER" }, -- ok
			[2] = { n = "_COMBATHITOTHEROTHER" }, -- ok
			[3] = { n = "_COMBATHITCRITSCHOOLOTHEROTHER" }, 
			[4] = { n = "_COMBATHITSCHOOLOTHEROTHER" },
		},

		-- absorb messages.
		--CHAT_MSG_COMBAT_CREATURE_VS_SELF_MISSES = {},
		--CHAT_MSG_COMBAT_CREATURE_VS_PARTY_MISSES = {},
		--CHAT_MSG_COMBAT_CREATURE_VS_CREATURE_MISSES = {},

		CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE = {
			[1] = { n = "_SPELLLOGCRITSCHOOLOTHERSELF" }, --! test
			[2] = { n = "_SPELLLOGSCHOOLOTHERSELF" }, -- ok
			[3] = { n = "_SPELLLOGCRITOTHERSELF" }, -- ok
			[4] = { n = "_SPELLLOGOTHERSELF" }, -- ok
			[5] = { n = "_SPELLRESISTOTHERSELF" }, -- ok

			[6] = { n = "_SPELLLOGCRITSCHOOLOTHEROTHER", destRelation=DamageMeters_Relation_PET },
			[7] = { n = "_SPELLLOGSCHOOLOTHEROTHER", destRelation=DamageMeters_Relation_PET }, -- ok
			[8] = { n = "_SPELLLOGCRITOTHEROTHER", destRelation=DamageMeters_Relation_PET },
			[9] = { n = "_SPELLLOGOTHEROTHER", destRelation=DamageMeters_Relation_PET },
			[10] = { n = "_SPELLRESISTOTHEROTHER", destRelation=DamageMeters_Relation_PET }, -- ok
		},
		CHAT_MSG_SPELL_CREATURE_VS_PARTY_DAMAGE = {
			[1] = { n = "_SPELLLOGCRITSCHOOLOTHEROTHER", destRelation=DamageMeters_Relation_PARTY }, -- ok
			[2] = { n = "_SPELLLOGSCHOOLOTHEROTHER", destRelation=DamageMeters_Relation_PARTY }, -- ok
			[3] = { n = "_SPELLLOGCRITOTHEROTHER", destRelation=DamageMeters_Relation_PARTY }, --! hmm
			[4] = { n = "_SPELLLOGOTHEROTHER", destRelation=DamageMeters_Relation_PARTY }, -- ok
			[5] = { n = "_SPELLRESISTOTHEROTHER", destRelation=DamageMeters_Relation_PARTY }, -- ok
		},
		CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE = {
			[1] = { n = "_SPELLLOGCRITSCHOOLOTHEROTHER" }, -- ok
			[2] = { n = "_SPELLLOGSCHOOLOTHEROTHER" }, -- ok
			[3] = { n = "_SPELLLOGCRITOTHEROTHER" }, -- ok
			[4] = { n = "_SPELLLOGOTHEROTHER" }, -- ok
			[5] = { n = "_SPELLRESISTOTHEROTHER" }, -- ok
		},

		-- Unsure against what players this occurs for.  Happens vs. self and pets for sure.
		CHAT_MSG_SPELL_HOSTILEPLAYER_DAMAGE = {
			[1] = { n = "_SPELLLOGCRITSCHOOLOTHERSELF" }, --ok
			[2] = { n = "_SPELLLOGSCHOOLOTHERSELF" }, -- ok
			[3] = { n = "_SPELLLOGCRITOTHERSELF" }, -- ok
			[4] = { n = "_SPELLLOGOTHERSELF" }, -- ok
			[5] = { n = "_SPELLRESISTOTHERSELF" }, -- ok

			[6] = { n = "_SPELLLOGCRITSCHOOLOTHEROTHER" }, -- ok
			[7] = { n = "_SPELLLOGSCHOOLOTHEROTHER" }, -- ok
			[8] = { n = "_SPELLLOGCRITOTHEROTHER" }, -- ok
			[9] = { n = "_SPELLLOGOTHEROTHER" }, -- ok
			[10] = { n = "_SPELLRESISTOTHEROTHER" }, -- ok
		},

		CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE = {
			[1] = { n = "_PERIODICAURADAMAGESELFSELF" }, --! hmm, would need to get a mob to reflect a dot onto me.
			[2] = { n = "_PERIODICAURADAMAGEOTHERSELF" }, -- ok
			[3] = { n = "_PERIODICAURADAMAGEOTHEROTHER", destRelation=DamageMeters_Relation_PET }, -- ok
		},

		CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE = {
			[1] = { n = "_PERIODICAURADAMAGEOTHEROTHER" }, -- ok
		},
		CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE = {
			[1] = { n = "_PERIODICAURADAMAGEOTHEROTHER" }, -- ok
		},

		CHAT_MSG_COMBAT_HOSTILEPLAYER_HITS = {
			[1] = { n = "_COMBATHITOTHERSELF" }, -- ok
			[2] = { n = "_COMBATHITCRITOTHERSELF" }, -- ok
			[3] = { n = "_COMBATHITOTHEROTHER" }, -- ok (sometimes pets but we couldn't know)
			[4] = { n = "_COMBATHITCRITOTHEROTHER" }, -- ok
			[5] = { n = "_VSENVIRONMENTALDAMAGE_FALLING_OTHER" }, -- ok (this monitors the damage our enemys take in pvp.  we don't really care about this)
			[6] = { n = "_VSENVIRONMENTALDAMAGE_LAVA_OTHER" },
		},
	},

-- Healing : 
	[DM_MSGTYPE_HEALING] = {
		CHAT_MSG_SPELL_SELF_BUFF = {
			[1] = { n="_HEALEDCRITSELFSELF" }, -- ok
			[2] = { n="_HEALEDSELFSELF" },	-- ok
			[3] = { n="_HEALEDCRITSELFOTHER" }, --ok
			[4] = { n="_HEALEDSELFOTHER" }, -- ok

			--[5] = { n="_HEALEDOTHEROTHER" }, -- this might theoretically happen if there was a direct heal (non-hot) for a pet class, but i don't think there are any
			--[6] = { n="_HEALEDCRITOTHEROTHER" },
		},
		CHAT_MSG_SPELL_PARTY_BUFF = {
			[1] = { n="__NIGHTDRAGONSBREATHOTHERCRIT", sourceRelation=DamageMeters_Relation_PARTY, destRelation=DamageMeters_Relation_PARTY },
			[2] = { n="__NIGHTDRAGONSBREATHOTHER", sourceRelation=DamageMeters_Relation_PARTY, destRelation=DamageMeters_Relation_PARTY },
			[3] = { n="_HEALEDCRITOTHERSELF", sourceRelation=DamageMeters_Relation_PARTY, destRelation=DamageMeters_Relation_SELF }, --! test, and shouldn't there be relations?
			[4] = { n="_HEALEDOTHERSELF", sourceRelation=DamageMeters_Relation_PARTY, destRelation=DamageMeters_Relation_SELF }, --!
			[5] = { n="_HEALEDCRITOTHEROTHER", sourceRelation=DamageMeters_Relation_PARTY }, -- ok
			[6] = { n="_HEALEDOTHEROTHER", sourceRelation=DamageMeters_Relation_PARTY }, -- ok
		},
		CHAT_MSG_SPELL_FRIENDLYPLAYER_BUFF = {
			[1] = { n="__NIGHTDRAGONSBREATHOTHERCRIT" }, -- ok
			[2] = { n="__NIGHTDRAGONSBREATHOTHER" },
			[3] = { n="_HEALEDCRITOTHERSELF", destRelation=DamageMeters_Relation_SELF }, --! test, and shouldn't there be relations?
			[4] = { n="_HEALEDOTHERSELF", destRelation=DamageMeters_Relation_SELF }, --!
			[5] = { n="_HEALEDCRITOTHEROTHER" }, -- ok
			[6] = { n="_HEALEDOTHEROTHER" }, -- ok
		},
		CHAT_MSG_SPELL_HOSTILEPLAYER_BUFF = {
			[1] = { n="__NIGHTDRAGONSBREATHOTHERCRIT" },
			[2] = { n="__NIGHTDRAGONSBREATHOTHER" },
			[3] = { n="_HEALEDCRITOTHERSELF", destRelation=DamageMeters_Relation_SELF }, --! test, and shouldn't there be relations?
			[4] = { n="_HEALEDOTHERSELF", destRelation=DamageMeters_Relation_SELF }, --!
			[5] = { n="_HEALEDCRITOTHEROTHER" }, -- ok
			[6] = { n="_HEALEDOTHEROTHER" }, -- ok
		},

		-- guessing
		CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS = {
			[1] = { n="_PERIODICAURAHEALOTHERSELF" }, -- ok
			[2] = { n="_PERIODICAURAHEALSELFSELF" }, -- ok
			[3] = { n="_PERIODICAURAHEALSELFOTHER" }, -- ok (ie. Mend Pet)
		},
		-- guessing
		CHAT_MSG_SPELL_PERIODIC_PARTY_BUFFS = {
			[1] = { n="__JULIESBLESSINGOTHER", sourceRelation=DamageMeters_Relation_PARTY },
			[2] = { n="_PERIODICAURAHEALSELFOTHER", sourceRelation=DamageMeters_Relation_PARTY, destRelation=DamageMeters_Relation_PARTY }, -- ok
			[3] = { n="_PERIODICAURAHEALOTHEROTHER", sourceRelation=DamageMeters_Relation_PARTY, destRelation=DamageMeters_Relation_PARTY }, -- ok
		};
		-- guessing
		CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_BUFFS = {
			[1] = { n="__JULIESBLESSINGOTHER" },
			[2] = { n="_PERIODICAURAHEALSELFOTHER" }, -- ok
			[3] = { n="_PERIODICAURAHEALOTHEROTHER" }, -- ok
		};
		-- guessing
		CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_BUFFS = {
			[1] = { n="_PERIODICAURAHEALOTHERSELF" }, --!
			[2] = { n="_PERIODICAURAHEALSELFSELF" }, --!
			[3] = { n="_PERIODICAURAHEALSELFOTHER" }, --!
			[4] = { n="_PERIODICAURAHEALOTHEROTHER" }, --! ok, but irrelevant, i think
		};
	},
};

-------------------------------------------------------------------------------

--[[
I lifted this system from some other mod (can't remember which, maybe DPSPlus).
Basically, the DM_Spellometer_Patterns works a lot like my own system, but 
the patterns are quite a bit more complicated in this case.  In English, the two
patterns represent all 4 of the following:

DISPELLEDOTHEROTHER = "%1$s对%3$s施放了%2$s。";
DISPELLEDOTHERSELF = "%s对你施放了%s。";
DISPELLEDSELFOTHER = "你对%2$s施放了%1$s。";
DISPELLEDSELFSELF = "你施放了%s。";

]]--

DM_Spellometer_Patterns = {
   { pattern="^(.+)对(.*)施放了(.+)。$", caster=1, spell=3, target=2 },
   { pattern="^(.+)对你施放了(.+)。$", caster = 1, spell=2, target=nil },
   { pattern="^你对(.+)施放了(.+)。$", caster = nil, spell=2, target=1 },
   { pattern="^你施放了(.+)。$", caster = nil, spell=2, target=nil },
};

-- This list contains all of the "cure" spells we want to track.
DM_CURESPELLS = {
	"驱散魔法",
	"解除诅咒", 
	"解除次级诅咒",
	"消毒术", 
	"驱毒术",
	"祛病术",
	"驱除疾病",
	"清洁术",
	"纯净术",
	"清毒图腾",
	"祛病图腾",
	"先祖之魂",
	"复生",
	"救赎",
	"复活术",
	"电击",
};

-------------------------------------------------------------------------------

end -- if ( GetLocale() == "zhCN" ) 