local DebuffFilter_DefaultSettings = {
	buffs = "yes",
	scale = 1,
	buff_orientation = "rightleft",
	time_orientation = "bottom",
	count = "no",
	tooltips = "yes",
	buff_list = {
		["盾墙"] = 1,
		["冲动"] = 1,
		["剑刃乱舞"] = 1,
		["神圣力量"] = 1,
	},
}

local DebuffFilter = {};

DebuffFilter.backdrop = nil;

DebuffFilter.FrameOrientation = {
	leftright = { point="LEFT", relpoint="RIGHT", x=1, y=0, count_y=0, next_orient="topbottom", next_time="left" },
	topbottom = { point="TOP", relpoint="BOTTOM", x=0, y=-1, count_y=8, next_orient="rightleft", next_time="bottom" },
	rightleft = { point="RIGHT", relpoint="LEFT", x=-1, y=0, count_y=0, next_orient="bottomtop", next_time="right" },
	bottomtop = { point="BOTTOM", relpoint="TOP", x=0, y=1, count_y=-8, next_orient="leftright", next_time="bottom" },
}

DebuffFilter.TimeOrientation = {
	bottom = { next_time = "top" },
	top = { next_time = "bottom" },
	left = { next_time = "right" },
	right = { next_time = "left" },
}

DebuffFilter.Frames = {
	buffs = { frame="DebuffFilter_BuffFrame", orient_key="buff_orientation", list="buff_list", name="buff" , target="", add_cmd="add", del_cmd="del", list_cmd="list", button="DebuffFilter_BuffButton", start=0, num=1, relnum=2, x=4, y=4 },
}

DebuffFilter_Targets = {
	hostile = "target",
	friendly = "targettarget",
}

local function DebuffFilter_Initialize()
	if (not DebuffFilter_Config) then
		DebuffFilter_Config = {};
	end

	if (not DebuffFilter_Config[DebuffFilter_Player]) then
		DebuffFilter_Config[DebuffFilter_Player] = {};
	end

	for i in DebuffFilter_DefaultSettings do
		if (not DebuffFilter_Config[DebuffFilter_Player][i]) then
			DebuffFilter_Config[DebuffFilter_Player][i] = DebuffFilter_DefaultSettings[i];
		end
	end

	for i in DebuffFilter.Frames do
		local frame = DebuffFilter.Frames[i]["frame"];
		local orient_key = DebuffFilter.Frames[i]["orient_key"];

		if (DebuffFilter_Config[DebuffFilter_Player][i] == "no") then
			getglobal(frame):Hide();
		end

		DebuffFilter_FrameOrientation(DebuffFilter_Config[DebuffFilter_Player][orient_key], frame);
	end

	DebuffFilter_TimeOrientation(DebuffFilter_Config[DebuffFilter_Player]["time_orientation"]);

	SlashCmdList["DFILTER"] = DebuffFilter_command;
	SLASH_DFILTER1 = "/dfilter";
end

function DebuffFilter_OnMouseDown(arg1)
	if (arg1 == "LeftButton" and IsShiftKeyDown()) then
		this:GetParent():StartMoving();
	elseif (arg1 == "RightButton" and IsShiftKeyDown()) then
		local frame, name, orient_key, orientation, time_orientation;
		
		frame = this:GetParent():GetName();

		for i in DebuffFilter.Frames do
			if (DebuffFilter.Frames[i]["frame"] == frame) then
				name = DebuffFilter.Frames[i]["name"];
				orient_key = DebuffFilter.Frames[i]["orient_key"];
				orientation = DebuffFilter_Config[DebuffFilter_Player][orient_key];
				break;
			end
		end

		for i in DebuffFilter.FrameOrientation do
			if (i == orientation) then
				local next_orient = DebuffFilter.FrameOrientation[i]["next_orient"];

				DebuffFilter_Config[DebuffFilter_Player][orient_key] = next_orient;
				DebuffFilter_FrameOrientation(next_orient, frame);
				DebuffFilter_Print(name .. " orientation: " .. DebuffFilter.FrameOrientation[i]["next_orient"]);

				time_orientation = DebuffFilter.FrameOrientation[i]["next_time"];

				break;
			end
		end

		if (frame == "DebuffFilter_BuffFrame") then
			DebuffFilter_Config[DebuffFilter_Player]["time_orientation"] = time_orientation;
			DebuffFilter_TimeOrientation(time_orientation);
		end

	elseif (arg1 == "RightButton" and IsControlKeyDown()) then
		local time_orientation = DebuffFilter_Config[DebuffFilter_Player]["time_orientation"];

		local next_time = DebuffFilter.TimeOrientation[time_orientation]["next_time"];
		DebuffFilter_Config[DebuffFilter_Player]["time_orientation"] = next_time;
		DebuffFilter_TimeOrientation(next_time);
		DebuffFilter_Print("buff time orientation: " .. next_time);
	elseif (arg1 == "LeftButton" and IsControlKeyDown()) then
		local Focus_Buffname = getglobal("GameTooltipTextLeft1"):GetText()
		DebuffFilter_command("del "..Focus_Buffname)
	end
end

function DebuffFilter_OnMouseUp(arg1)
	if (arg1 == "LeftButton") then
		this:GetParent():StopMovingOrSizing();
	end
end

function DebuffFilter_OnLoad()
	DebuffFilter_Player = (UnitName("player").." - "..GetRealmName());
	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("PLAYER_AURAS_CHANGED");
end

function DebuffFilter_BuffFrame_Update()
	if (DebuffFilter_Config[DebuffFilter_Player]["buffs"] == "no") then
		return;
	end

	local count = 0;
	local width = 0;

	for i = 0, 15, 1 do
		local name = "DebuffFilter_BuffButton" .. i;
		local button = getglobal(name);
		local buffindex, untilcancelled = GetPlayerBuff(i, "HELPFUL");
		local bufftext = getglobal(name .. "Count");
		local bufftime = getglobal(name .. "Duration");
		
		if (buffindex >= 0) then
			count = count + 1;
			DebuffFilter_BuffFrameCount:SetText(count);

			DebuffFilter_Tooltip:ClearLines();
			DebuffFilter_Tooltip:SetPlayerBuff(buffindex);

			if (DebuffFilter_Config[DebuffFilter_Player]["buff_list"][DebuffFilter_TooltipTextLeft1:GetText()] == 1) then
				getglobal(name .. "Icon"):SetTexture(GetPlayerBuffTexture(buffindex));

				local buffapplications = GetPlayerBuffApplications(buffindex);
				local bufftimeleft = GetPlayerBuffTimeLeft(buffindex);

				if (buffapplications > 1) then
					bufftext:SetText(buffapplications);
				else
					bufftext:SetText("");
				end

				if (untilcancelled ~= 1) then
					if (11 >= bufftimeleft) then
						bufftime:SetTextColor(1, 0, 0);
					else
						bufftime:SetTextColor(1, 0.82, 0);
					end

					bufftime:SetText(SecondsToTimeAbbrev(bufftimeleft));
				else
					bufftime:SetText("N/A");
				end

				button:SetWidth(30);
				button:SetHeight(30);
				button:Show();

				width = width + 1;

				if (DebuffFilter_Config[DebuffFilter_Player]["count"] == "yes") then
					DebuffFilter_BuffFrameCount:Show();
				end
			else
				button:Hide();
				bufftext:SetText("");
				bufftime:SetText("");
				button:SetWidth(-4);
				button:SetHeight(-4);
			end
		else
			button:Hide();
			bufftext:SetText("");
			bufftime:SetText("");
			button:SetWidth(-4);
			button:SetHeight(-4);
		end
	end

	if (width == 0) then
		DebuffFilter_BuffFrameCount:Hide();
	end
end

function DebuffFilter_OnEvent(event)
	if (event == "VARIABLES_LOADED") then
		this:UnregisterEvent("VARIABLES_LOADED");
		DebuffFilter_Initialize();
	elseif (event == "PLAYER_ENTERING_WORLD") then
		this:UnregisterEvent("PLAYER_ENTERING_WORLD");
		DebuffFilterFrame:SetScale(DebuffFilter_Config[DebuffFilter_Player]["scale"] * UIParent:GetScale());
	elseif (event == "PLAYER_AURAS_CHANGED") then
		DebuffFilter_BuffFrame_Update();
	end
end

function DebuffFilter_BuffButton_OnUpdate(elapsed)
	this.update = this.update + elapsed;
	if (this.update >= 1) then
		this.update = this.update - 1;
		local buffindex, untilcancelled = GetPlayerBuff(this:GetID(), "HELPFUL");
		local buffapplications = GetPlayerBuffApplications(buffindex);
		local bufftimeleft = GetPlayerBuffTimeLeft(buffindex);
		local bufftext = getglobal(this:GetName() .. "Count");
		local bufftime = getglobal(this:GetName() .. "Duration");

		if (buffapplications > 1) then
			bufftext:SetText(buffapplications);
		else
			bufftext:SetText("");
		end

		if (untilcancelled == 1) then
			bufftime:SetText("N/A");
			return;
		end

		if (11 >= bufftimeleft) then
			bufftime:SetTextColor(1, 0, 0);
		else
			bufftime:SetTextColor(1, 0.82, 0);
		end

		bufftime:SetText(SecondsToTimeAbbrev(bufftimeleft));
	end
end

function DebuffFilter_FrameOrientation(orientation, frame)
	local name, start, num, relnum, xtemp, ytemp, countframe, point, relpoint, x, y;

	for i in DebuffFilter.Frames do
		if (DebuffFilter.Frames[i]["frame"] == frame) then
			name = DebuffFilter.Frames[i]["button"];
			start = getglobal(name .. DebuffFilter.Frames[i]["start"]);
			num = DebuffFilter.Frames[i]["num"];
			relnum = DebuffFilter.Frames[i]["relnum"];
			xtemp = DebuffFilter.Frames[i]["x"];
			ytemp = DebuffFilter.Frames[i]["y"];

			break;
		end
	end

	countframe = getglobal(frame .. "Count");

	start:ClearAllPoints();
	countframe:ClearAllPoints();

	for i in DebuffFilter.FrameOrientation do
		if (i == orientation) then
			point, relpoint = DebuffFilter.FrameOrientation[i]["point"], DebuffFilter.FrameOrientation[i]["relpoint"];
			x, y = xtemp * DebuffFilter.FrameOrientation[i]["x"], ytemp * DebuffFilter.FrameOrientation[i]["y"];
			start:SetPoint(DebuffFilter.FrameOrientation[i]["point"], frame, DebuffFilter.FrameOrientation[i]["point"], 0, 0);
			countframe:SetPoint(relpoint, frame, point, 0, DebuffFilter.FrameOrientation[i]["count_y"]);

			break;
		end
	end

	for i = 2, 16, 1 do
		local button, relbutton;

		button = getglobal(name .. i-num);
		relbutton = name .. (i-relnum);
		
		button:ClearAllPoints();
		button:SetPoint(point, relbutton, relpoint, x, y);
	end
end

function DebuffFilter_TimeOrientation(orientation)
	for i = 0, 15, 1 do
		local name = "DebuffFilter_BuffButton" .. i;
		local bufftime = getglobal(name .. "Duration");

		bufftime:ClearAllPoints();

		if (orientation == "bottom") then
			bufftime:SetPoint("TOP", name, "BOTTOM", 0, 0);
		elseif (orientation == "top") then
			bufftime:SetPoint("BOTTOM", name, "TOP", 0, 2);
		elseif (orientation == "left") then
			bufftime:SetPoint("RIGHT", name, "LEFT", -4, 0);
		elseif (orientation == "right") then
			bufftime:SetPoint("LEFT", name, "RIGHT", 4, 0);
		end
	end
end

function DebuffFilter_Print(msg)
	DEFAULT_CHAT_FRAME:AddMessage("|cff00ff00Buff监视|r " .. msg);
end

function DebuffFilter_command(arg1)
	local i, j, cmd, param = string.find(arg1, "^([^ ]+) (.+)$");
	if (not cmd) then
		cmd = arg1;
	end

	cmd = string.lower(cmd);

	if cmd == "buffs" then
		if (DebuffFilter_Config[DebuffFilter_Player][cmd] == "yes") then
			DebuffFilter_Config[DebuffFilter_Player][cmd] = "no";
			getglobal(DebuffFilter.Frames[cmd]["frame"]):Hide();
			DebuffFilter_Print(DebuffFilter.Frames[cmd]["name"] .. " filtering disabled.");
		else
			DebuffFilter_Config[DebuffFilter_Player][cmd] = "yes";
			getglobal(DebuffFilter.Frames[cmd]["frame"] .. "_Update")(DebuffFilter_Targets[DebuffFilter.Frames[cmd]["target"]]);
			getglobal(DebuffFilter.Frames[cmd]["frame"]):Show();
			DebuffFilter_Print(DebuffFilter.Frames[cmd]["name"] .. " filtering enabled.");
		end
	elseif (cmd == "scale") then
		if tonumber(param) and (tonumber(param) >= 0.5) and (tonumber(param) <=3.0) then
			DebuffFilter_Config[DebuffFilter_Player]["scale"] = tonumber(param);
			DebuffFilterFrame:SetScale(DebuffFilter_Config[DebuffFilter_Player]["scale"] * UIParent:GetScale());
			DebuffFilter_BuffFrame:ClearAllPoints();
			DebuffFilter_BuffFrame:SetPoint("LEFT", "PlayerFrame", "RIGHT", -35, 90);
			DebuffFilter_Print("scale set to " .. DebuffFilter_Config[DebuffFilter_Player]["scale"] .. ".");
		else
			DebuffFilter_Print("please choose a number between 0.5 and 3.  Current scale: " .. DebuffFilter_Config[DebuffFilter_Player]["scale"] .. ".");
		end
	elseif (cmd == "backdrop") then
		if (DebuffFilter.backdrop == 1) then
			DebuffFilter.backdrop = 0;
			for i in DebuffFilter.Frames do
				getglobal(DebuffFilter.Frames[i]["frame"] .. "Backdrop"):Hide();
			end
			DebuffFilter_Print("now hiding backdrop.");
		else
			DebuffFilter.backdrop = 1;
			for i in DebuffFilter.Frames do
				getglobal(DebuffFilter.Frames[i]["frame"] .. "Backdrop"):Show();
			end
			DebuffFilter_Print("now showing backdrop.");
		end
	elseif (cmd == "count") then
		if (DebuffFilter_Config[DebuffFilter_Player]["count"] == "yes") then
			DebuffFilter_Config[DebuffFilter_Player]["count"] = "no";
			for i in DebuffFilter.Frames do
				getglobal(DebuffFilter.Frames[i]["frame"] .. "Count"):Hide();
			end
			DebuffFilter_Print("no longer showing debuff/buff count.");
		else
			DebuffFilter_Config[DebuffFilter_Player]["count"] = "yes";
			DebuffFilter_Print("now showing debuff/buff count.");
		end
	elseif (cmd == "tooltips") then
		if (DebuffFilter_Config[DebuffFilter_Player]["tooltips"] == "yes") then
			DebuffFilter_Config[DebuffFilter_Player]["tooltips"] = "no";
			DebuffFilter_Print("tooltips disabled.");
		else
			DebuffFilter_Config[DebuffFilter_Player]["tooltips"] = "yes";
			DebuffFilter_Print("tooltips enabled.");
		end
	elseif (cmd == "add") and param then
		for i in DebuffFilter.Frames do
			if (DebuffFilter.Frames[i]["add_cmd"] == cmd) then
				DebuffFilter_Config[DebuffFilter_Player][DebuffFilter.Frames[i]["list"]][param] = 1;
				getglobal(DebuffFilter.Frames[i]["frame"] .. "_Update")(DebuffFilter_Targets[DebuffFilter.Frames[i]["target"]]);
				DebuffFilter_Print("已监视" .. DebuffFilter.Frames[i]["name"] .. ": \"|cff00ccff" .. param .. "|r\"");

				break;
			end
		end
	elseif (cmd == "del") and param then
		for i in DebuffFilter.Frames do
			if (DebuffFilter.Frames[i]["del_cmd"] == cmd) then
				if (DebuffFilter_Config[DebuffFilter_Player][DebuffFilter.Frames[i]["list"]][param]) then
					DebuffFilter_Config[DebuffFilter_Player][DebuffFilter.Frames[i]["list"]][param] = nil;
					getglobal(DebuffFilter.Frames[i]["frame"] .. "_Update")(DebuffFilter_Targets[DebuffFilter.Frames[i]["target"]]);
					DebuffFilter_Print("不再监视" .. DebuffFilter.Frames[i]["name"] .. ": \"|cff00ccff" .. param .. "|r\"");
				else
					DebuffFilter_Print("未发现 " .. DebuffFilter.Frames[i]["name"] .. ": \"|cff00ccff" .. param .. "|r\"");
				end

				break;
			end
		end
	elseif (cmd == "list") then
		for i in DebuffFilter.Frames do
			if (DebuffFilter.Frames[i]["list_cmd"] == cmd) then
				DebuffFilter_Print("currently monitored " .. DebuffFilter.Frames[i]["name"] .. "s:");
				for ii in DebuffFilter_Config[DebuffFilter_Player][DebuffFilter.Frames[i]["list"]] do
					DEFAULT_CHAT_FRAME:AddMessage("\"|cff00ccff" .. ii .. "|r\"");
				end

				break;
			end
		end
	elseif (cmd == "status") then
		DebuffFilter_Print("current settings:");
		DebuffFilter_Print("current scale: |cff00ccff" .. DebuffFilter_Config[DebuffFilter_Player]["scale"] .. "|r");
		DebuffFilter_Print("current player buff orientation: |cff00ccff" .. DebuffFilter_Config[DebuffFilter_Player]["buff_orientation"] .. "|r");
		DebuffFilter_Print("current time orientation: |cff00ccff" .. DebuffFilter_Config[DebuffFilter_Player]["time_orientation"] .. "|r");
		DebuffFilter_Print("show debuff/buff count: |cff00ccff" .. DebuffFilter_Config[DebuffFilter_Player]["count"] .. "|r");
		DebuffFilter_Print("show tooltips: |cff00ccff" .. DebuffFilter_Config[DebuffFilter_Player]["tooltips"] .. "|r");
		DebuffFilter_Print("player buff filtering: |cff00ccff" .. DebuffFilter_Config[DebuffFilter_Player]["buffs"] .. "|r");
	else
		DEFAULT_CHAT_FRAME:AddMessage("Debuff 过滤器命令:");
		DEFAULT_CHAT_FRAME:AddMessage("/dfilter |cff00ccffbuffs|r: 是否打开 buff 监视");
		DEFAULT_CHAT_FRAME:AddMessage("/dfilter |cff00ccffscale [0.5-3.0]|r: buff 大小");
		DEFAULT_CHAT_FRAME:AddMessage("/dfilter |cff00ccffbackdrop|r: 切换背景帮助移动 buff 框架");
		DEFAULT_CHAT_FRAME:AddMessage("/dfilter |cff00ccffcount|r: 切换buff 计数显示");
		DEFAULT_CHAT_FRAME:AddMessage("/dfilter |cff00ccfftooltips|r: 切换提示和关闭");
		DEFAULT_CHAT_FRAME:AddMessage("/dfilter |cff00ccffstatus|r: 显示当前设置");
		DEFAULT_CHAT_FRAME:AddMessage("/dfilter <|cff00ccffadd|r > |cff00ccff[|cff00ff00buff|cff00ccff]|r: 添加一个buff监控");
		DEFAULT_CHAT_FRAME:AddMessage("/dfilter <|cff00ccffdel|r > |cff00ccff[|cff00ff00buff|cff00ccff]|r: 清除一个buff监控");
		DEFAULT_CHAT_FRAME:AddMessage("/dfilter |cff00ccfflist|r : 查看当前监控buff列表.");
		DEFAULT_CHAT_FRAME:AddMessage("移动框架, shift+左键拖动 buff.");
		DEFAULT_CHAT_FRAME:AddMessage("改变时间显示未知, shift+右键或者 ctrl+右键.");
	end
end