local BUFFS = {
	["冲动"] = {
		ICON = 'Spell_Shadow_ShadowWordDominate',
		DURATION = 15,
	},
	["疾跑"] = {
		ICON = 'Ability_Rogue_Sprint',
		DURATION = 15,
	},
	["闪避"] = {
		ICON = 'Spell_Shadow_ShadowWard',
		DURATION = 15,
	},
	["剑刃乱舞"] = {
		ICON = 'Ability_GhoulFrenzy',
		DURATION = 15,
	},
	["能量灌注"] = {
		ICON = 'Spell_Holy_PowerInfusion',
		DURATION = 15,
	},
	["奥术强化"] = {
		ICON = 'Spell_Nature_Lightning',
		DURATION = 15,
	},
	["寒冰屏障"] = {
		ICON = 'Spell_Frost_Frost',
		DURATION = 10,
	},
	["自然之握"] = {
		ICON = 'Spell_Nature_NaturesWrath',
		DURATION = 45,
	},
	["急奔"] = {
		ICON = 'Ability_Druid_Dash',
		DURATION = 15,
	},
	["树皮术"] = {
		ICON = 'Spell_Nature_StoneClawTotem',
		DURATION = 15,
	},
	["猛虎之怒"] = {
		ICON = 'Ability_Mount_JungleTiger',
		DURATION = 6,
	},
	["威慑"] = {
		ICON = 'Ability_Whirlwind',
		DURATION = 10,
	},
	["急速射击"] = {
		ICON = 'Ability_Hunter_RunningShot',
		DURATION = 15,
	},
	["圣盾术"] = {
		ICON = 'Spell_Holy_DivineIntervention',
		DURATION = 12,
	},
	["保护祝福"] = {
		ICON = 'Spell_Holy_SealOfProtection',
		DURATION = 10,
	},
	["自由祝福"] = {
		ICON = 'Spell_Holy_SealOfValor',
		DURATION = 10,
	},
	["牺牲"] = {
		ICON = 'Spell_Shadow_SacrificialShield',
		DURATION = 30,
	},
	["狂暴之怒"] = {
		ICON = 'Spell_Nature_AncestralGuardian',
		DURATION = 10,
	},
	["血性狂暴"] = {
		ICON = 'Ability_Racial_BloodRage',
		DURATION = 10,
	},
	["横扫攻击"] = {
		ICON = 'Ability_Rogue_SliceDice',
		DURATION = 20,
	},
	["破釜沉舟"] = {
		ICON = 'Spell_Holy_AshesToAshes',
		DURATION = 20,
	},
	["反击风暴"] = {
		ICON = 'Ability_Warrior_Challange',
		DURATION = 15,
	},
	["盾墙"] = {
		ICON = 'Ability_Warrior_ShieldWall',
		DURATION = 10,
	},
	["鲁莽"] = {
		ICON = 'Ability_CriticalStrike',
		DURATION = 15,
	},
	["死亡之愿"] = {
		ICON = 'Spell_Shadow_DeathPact',
		DURATION = 30,
	},
	["亡灵意志"] = {
		ICON = 'Spell_Shadow_RaiseDead',
		DURATION = 5,
	},
	["感知"] = {
		ICON = 'Spell_Nature_Sleep',
		DURATION = 20,
	},
}

local EMPTY = {}

local buffs = {}

local handlers = {}
do
	local f = CreateFrame'Frame'
	f:SetScript('OnEvent', function()
		handlers[event](this)
	end)
	for _, event in {
		'PLAYER_LOGIN',
		'CHAT_MSG_COMBAT_HONOR_GAIN', 'CHAT_MSG_COMBAT_HOSTILE_DEATH',
		'CHAT_MSG_SPELL_AURA_GONE_OTHER', 'CHAT_MSG_SPELL_BREAK_AURA',
		'CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_BUFFS',
	} do f:RegisterEvent(event) end
end

local SPOOFED_UNIT_AURA
do
	local frames = {}
	function SPOOFED_UNIT_AURA()
		for frame, handler in frames do
			local saved_this, saved_event, saved_arg1 = this, event, arg1
			this, event, arg1 = frame, 'UNIT_AURA', 'target'
			handler()
			this, event, arg1 = saved_this, saved_event, saved_arg1
		end
	end
	function handlers.PLAYER_LOGIN()
		local f
		while true do
			f = EnumerateFrames(f)
			if not f then
				break
			end
			local handler = f.GetScript and f:GetScript'OnEvent'
			if handler then
				f:SetScript('OnEvent', function()
					if event == 'UNIT_AURA' then
						frames[this] = handler
					end
					return handler()
				end)
				do
					local orig = f.RegisterEvent
					function f:RegisterEvent(event)
						if event == 'UNIT_AURA' then
							frames[self] = handler
						end
						return orig(self, event)
					end
				end
				do
					local orig = f.UnregisterEvent
					function f:UnregisterEvent(event)
						if event == 'UNIT_AURA' then
							frames[self] = nil
						end
						return orig(self, event)
					end
				end
			end
		end
	end
end

do
	local orig = UnitBuff
	function UnitBuff(unitid, index)
		local offset = 0
		while orig('target', offset + 1) do
			offset = offset + 1
		end
		if unitid == 'target' and UnitIsEnemy('target', 'player') and UnitIsPlayer('target') then
			local icon = ((buffs[UnitName'target'] or EMPTY)[index - offset] or EMPTY).icon
			if icon then
				return [[Interface\Icons\]] .. icon, 1
			end
		else
			return orig(unitid, index)
		end
	end
end

local function updateBuffs(unit)
	if UnitName'target' == unit then
		SPOOFED_UNIT_AURA()
	end
end

local function removeBuff(unit, name)
	for i = getn(buffs[unit] or EMPTY), 1, -1 do
		if BUFFS[name] and buffs[unit][i].icon == BUFFS[name].ICON then
			tremove(buffs[unit], i)
		end
	end
end

CreateFrame'Frame':SetScript('OnUpdate', function()
	local removed
	for unit, unitBuffs in buffs do
		for i = getn(unitBuffs), 1, -1 do
			if GetTime() > unitBuffs[i].expiration then
				tremove(unitBuffs, i)
				removed = true
			end
		end
		if removed then
			updateBuffs(unit)
		end		
	end
end)

function handlers.CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_BUFFS()
	for unit, buff in string.gfind(arg1, '(.+)获得了(.+)的效果。') do
		if BUFFS[buff] then
			removeBuff(unit, buff)
			buffs[unit] = buffs[unit] or {}
			tinsert(buffs[unit], {
				icon = BUFFS[buff].ICON,
				expiration = GetTime() + BUFFS[buff].DURATION
			})
			updateBuffs(unit)
		end
	end
end

function handlers.CHAT_MSG_SPELL_AURA_GONE_OTHER()
	for effect, unit in string.gfind(arg1, '(.+)效果从(.+)身上消失。') do
		removeBuff(unit, effect)
		updateBuffs(unit)
	end
end

function handlers.CHAT_MSG_SPELL_BREAK_AURA()
	for unit, effect in string.gfind(arg1, "(.+)的(.+)被移除了。") do
		removeBuff(unit, effect)
		updateBuffs(unit)
	end
end

function handlers.CHAT_MSG_COMBAT_HOSTILE_DEATH()
	for unit in string.gfind(arg1, '(.+)死亡了。') do
		buffs[unit] = nil
		updateBuffs(unit)
	end
end

function handlers.CHAT_MSG_COMBAT_HONOR_GAIN()
	for unit in string.gfind(arg1, '(.+)死亡了。') do
		buffs[unit] = nil
		updateBuffs(unit)
	end
end