En_FramesPoint = CreateFrame("Frame")
En_FramesPoint:RegisterEvent("VARIABLES_LOADED")
En_FramesPoint:SetScript("OnEvent", function() EUF_Frame_DefaultPoint() end)
PetFrame:SetFrameStrata("LOW")

--定位各个头像的位置
local _,_,_,x,y = PlayerFrame:GetPoint()

function EUF_Frame_DefaultPoint()
	PlayerFrame:ClearAllPoints()
	PlayerFrame:SetPoint("BOTTOMRIGHT", UIParent, "BOTTOM", -45, 235)
	PetFrame:ClearAllPoints()
	PetFrame:SetPoint("TOPLEFT","PlayerFrame","TOPLEFT", x + 95, y - 65)
	PetFrameHealthBarText:ClearAllPoints()
	PetFrameHealthBarText:SetPoint("TOPLEFT","PetFrameHealthBar","CENTER", x - 4, y + 10)
	PetFrameManaBarText:ClearAllPoints()
	PetFrameManaBarText:SetPoint("TOPLEFT","PetFrameManaBar","CENTER", x, y + 8)
	TargetFrame:ClearAllPoints()
	TargetFrame:SetPoint("TOPLEFT", "PlayerFrame", "TOPRIGHT", x + 110, y + 5)
	TargetofTargetFrame:ClearAllPoints()
	TargetofTargetFrame:SetPoint("TOPLEFT", "TargetFrame", "BOTTOM", x + 38, y + 32)
end

--移动框架,战斗状态禁止移动
local EN_moveFrames = {
	PlayerFrame,
	PetFrame,
	TargetFrame,
	TargetofTargetFrame,
	PartyMemberFrame1,
}

for _, frame in pairs(EN_moveFrames) do
	frame:SetMovable(true) frame:EnableMouse(true)
    frame:SetScript("OnDragStart", function() if IsAltKeyDown() and not UnitAffectingCombat("player") then this:StartMoving() end end)
	frame:SetScript("OnDragStop",  function() this:StopMovingOrSizing() end)
	frame:RegisterForDrag("LeftButton")
end

--重置框架、副本
UnitPopupButtons["RESET_INSTANCES_FIX"] = { text = "重置副本", dist = 0 }
UnitPopupButtons["ResetEn_FramePoint_FIX"] = { text = "重置头像", dist = 0 }

UnitPopupMenus["SELF"] = { "LOOT_METHOD", "LOOT_THRESHOLD", "LOOT_PROMOTE", "LEAVE", "RAID_TARGET_ICON", "RESET_INSTANCES_FIX", "ResetEn_FramePoint_FIX", "CANCEL" }

hooksecurefunc("UnitPopup_OnClick", function()
	local button = this.value
    if button == "RESET_INSTANCES_FIX" then
		StaticPopup_Show("CONFIRM_RESET_INSTANCES")
    elseif button == "ResetEn_FramePoint_FIX" then
		ResetEn_FramePoint(arg)
	end
end)

function ResetEn_FramePoint(arg)
  StaticPopupDialogs["ResetEn_FramePoint"] = {
	text = "是否重置所有头像位置？",
	button1 = TEXT(ACCEPT),
	button2 = TEXT(CANCEL),
	OnAccept = function()
		for _,frame in pairs(EN_moveFrames) do
			frame:SetUserPlaced(false)
			frame:ClearAllPoints()
		end
		if PlayerFrame:IsShown() then
			EUF_Frame_DefaultPoint()
		end
	end,
	timeout = 0,
	hideOnEscape = 1
  }
  StaticPopup_Show("ResetEn_FramePoint")
end