local LibSmooth = LibStub:GetLibrary("LibSmoothStatusBar-1.0")
local dir = "Interface\\TargetingFrame\\"
local En_TarHpText, En_TarMpText, CombatFlash

--宽血条美化
function En_UFI_Frame()
	--蓝条颜色
	ManaBarColor[0] = { r = 0, g = 0.47, b = 1, prefix = TEXT(MANA) }

	TargetFrame:SetFrameStrata("BACKGROUND")
	PlayerFrameTexture:SetTexture(dir.."UI-TargetingFrame.blp")
    PlayerStatusTexture:SetTexture(dir.."UI-Player-Status.blp")

	PlayerFrameHealthBar:ClearAllPoints()
	PlayerFrameHealthBar:SetPoint("TOPLEFT", 106, -24)
	PlayerFrameHealthBar:SetPoint("BOTTOMRIGHT", -6, 49)
	TargetFrameHealthBar:ClearAllPoints()
	TargetFrameHealthBar:SetPoint("TOPRIGHT", -106, -24)
	TargetFrameHealthBar:SetPoint("BOTTOMLEFT", 6, 49)
	
	if PlayerFrameBackground and PlayerFrameBackground.bg then PlayerFrameBackground.bg:Hide() end
	TargetFrameNameBackground:Hide()
	
	--玩家
	--姓名	
	PlayerName:SetFont(STANDARD_TEXT_FONT, 15, "OUTLINE")
	PlayerName:ClearAllPoints()
	PlayerName:SetPoint("CENTER", "PlayerFrameTexture", "CENTER", 50, 25)
	--血条数值
	PlayerFrameHealthBarText:ClearAllPoints()
	PlayerFrameHealthBarText:SetPoint("CENTER", "PlayerFrameHealthBar", "CENTER", 0, -5)
	
	--目标
	--姓名
	TargetName:SetFont(STANDARD_TEXT_FONT, 15, "OUTLINE")
	TargetName:ClearAllPoints()
	TargetName:SetPoint("CENTER", "TargetFrameTexture", "CENTER", -50, 25)
	TargetDeadText:ClearAllPoints()
	--HP
    En_TarHpText = this:CreateFontString("En_TarHpText", "ARTWORK", "TextStatusBarText")
	En_TarHpText:SetPoint("CENTER", "TargetFrameHealthBar", "CENTER", 0, -5)
    En_TarHpText:SetTextColor(1, 1, 1, 1)
	--MP
    En_TarMpText = this:CreateFontString("En_TarMpText", "ARTWORK", "TextStatusBarText")
	En_TarMpText:SetPoint("CENTER", "TargetFrameManaBar", "CENTER", 0, 0)
    En_TarMpText:SetTextColor(1, 1, 1, 1)

	--宠物
	PetName:SetFont(STANDARD_TEXT_FONT, 13)
	PetFrameHealthBarText:SetFont(STANDARD_TEXT_FONT, 11, "OUTLINE")
	PetFrameManaBarText:SetFont(STANDARD_TEXT_FONT, 11, "OUTLINE")

	--目标战斗状态
	CombatFlash = this:CreateTexture(nil, ARTWORK)
	CombatFlash:SetTexture("Interface\\CharacterFrame\\UI-StateIcon")
	CombatFlash:SetTexCoord(0.5, 1, 0, 0.5)
	CombatFlash:SetWidth(28)
	CombatFlash:SetHeight(28)
	CombatFlash:SetPoint("CENTER", "TargetFrame", "BOTTOMRIGHT", -52, 35)
end

--覆盖StatusBar的文字信息显示
function TextStatusBar_UpdateTextString(textStatusBar)
	if ( not textStatusBar ) then
		textStatusBar = this
	end
	local Barstring = textStatusBar.TextString

	if Barstring then
		local v  = math.floor(textStatusBar:GetValue())
		local valueMax = select(2, textStatusBar:GetMinMaxValues())
		
		if ( valueMax > 0 ) then
			textStatusBar:Show()

			if ( v == 0 and textStatusBar.zeroText ) then
				Barstring:SetText(textStatusBar.zeroText)
				textStatusBar.isZero = 1
				Barstring:Show()
			else
				textStatusBar.isZero = nil
				if textStatusBar.unit == "player" then
					if textStatusBar.tooltipTitle == ENERGY or textStatusBar.tooltipTitle == RAGE then
						Barstring:SetText(v)
					else
						Barstring:SetText(Over1E3toK(v).."/"..Over1E3toK(valueMax))
					end
				else
					if ( textStatusBar.prefix ) then
						Barstring:SetText(textStatusBar.prefix.." "..Over1E3toK(v).."/"..Over1E3toK(valueMax));
					else
						Barstring:SetText(Over1E3toK(v).."/"..Over1E3toK(valueMax));
					end
				end
				if ( GetCVar("statusBarText") == "1" and textStatusBar.textLockable ) then
					Barstring:Show()
				elseif ( textStatusBar.lockShow > 0 ) then
					Barstring:Show()
				else
					Barstring:Hide()
				end
			end
		else
			textStatusBar:Hide()
		end
	end
end

--阵营图标
PlayerPVPIcon.Show = PlayerPVPIcon.Hide
TargetPVPIcon.Show = TargetPVPIcon.Hide
for i = 1, 4 do getglobal("PartyMemberFrame"..i.."PVPIcon"):Hide() end
PartyMemberFrame_UpdatePvPStatus = function() end

--目标头目等级框架
function TargetFrame_CheckClassification()
	local classification = UnitClassification"target"
	if classification == "worldboss" or classification == "elite" then
		TargetFrameTexture:SetTexture(dir.."UI-TargetingFrame-Elite.blp")
	elseif classification == "rareelite" then
		TargetFrameTexture:SetTexture(dir.."UI-TargetingFrame-Rare-Elite.blp")
	elseif classification == "rare" then
		TargetFrameTexture:SetTexture(dir.."UI-TargetingFrame-Rare.blp")
	else
		TargetFrameTexture:SetTexture(dir.."UI-TargetingFrame.blp")
	end
end

function Update_En_UFIText()
	local TarHPCur, TarHPMax = UnitHealth("target"), UnitHealthMax("target")
	local TarPowerCur, TarPowerMax = UnitMana("target"), UnitManaMax("target")
	local powerType = UnitPowerType("target")
	
	--目标
	if TargetFrame:IsVisible() then
		En_TarHpText:Show()
		if MobHealthFrame then
			local MobCur, MobMax = MobHealth3:GetUnitHealth("target", UnitHealth("target"), UnitHealthMax("target"))
			if MobMax and MobMax > 0 then
				En_TarHpText:SetText(Over1E3toK(MobCur).."/"..Over1E3toK(MobMax))
			else
				En_TarHpText:SetText(Over1E3toK(TarHPCur).."/"..Over1E3toK(TarHPMax))
			end
		else
			En_TarHpText:SetText(Over1E3toK(TarHPCur).."/"..Over1E3toK(TarHPMax))
		end
		if TarPowerCur and TarPowerCur > 0 then
			if powerType ~= 0 then
				En_TarMpText:SetText(TarPowerCur)
			else
				En_TarMpText:SetText(Over1E3toK(TarPowerCur).."/"..Over1E3toK(TarPowerMax))
			end
			En_TarMpText:Show()
		else
			En_TarMpText:Hide()
		end
	else
		En_TarHpText:Hide()
		En_TarMpText:Hide()
	end

	if TargetFrame:IsVisible() and UnitAffectingCombat("target") == 1 then
		local time = GetTime()
		local x = (tonumber(string.format("%0.1f",  math.mod(time, 1))))*10
		local alpha = math.sin(x/1.5+1)/2+0.5
		CombatFlash:Show()
		CombatFlash:SetAlpha(alpha)
	else
		CombatFlash:Hide()
	end 
end

--猎人宠物框架
--隐藏宠物状态图像
PetFrame_SetHappiness = function() PetFrameHappiness:Hide() end

local PetHappinessColors = {
	[1] = {1, 0, 0},
	[2] = {1, 1, 0},
	[3] = {0, 1, 0},
}

--宠物血条根据宠物高兴状态染色
function En_PetFrameHappiness()
	if UnitExists("pet") then
		local hasPetUI, isHunterPet = HasPetUI()
		local happiness = GetPetHappiness()	
		if hasPetUI and isHunterPet then
			PetFrameHealthBar:SetStatusBarColor(PetHappinessColors[happiness][1], PetHappinessColors[happiness][2], PetHappinessColors[happiness][3])
		end
	end
end

hooksecurefunc("PetFrame_OnEvent", function(event)
	if event == "UNIT_HAPPINESS" then
		En_PetFrameHappiness()
	end
	if event == "PLAYER_PET_CHANGED" then
		En_PetFrameHappiness()
	end
end)

--血条平滑效果
local barstosmooth = {
	PlayerFrameHealthBar, PlayerFrameManaBar,
	TargetFrameHealthBar, TargetFrameManaBar,
}

function En_HealthBar_OnValueChanged(value, smooth)
	if not value then return end
	
	local frame = this:GetName()
	if frame == "PlayerFrameHealthBar" then
		PlayerFrameHealthBar:SetStatusBarColor(UnitColor("player"))
	elseif frame == "TargetFrameHealthBar" then
		TargetFrameHealthBar:SetStatusBarColor(UnitColor("target"))		
	elseif frame == "PetFrameHealthBar" then
		En_PetFrameHappiness()
	elseif frame == "GameTooltipStatusBar" then
		GameTooltipStatusBar:SetStatusBarColor(SetPercentColor(UnitHealth("mouseover"), UnitHealthMax("mouseover")))
	end
	
	for i, v in pairs (barstosmooth) do if v then LibSmooth:SmoothBar(v) end end
end
hooksecurefunc("HealthBar_OnValueChanged", En_HealthBar_OnValueChanged, true)

local En_UFIFrame = CreateFrame("Frame", nil, UIParent)
En_UFIFrame:SetFrameStrata("LOW")
En_UFIFrame:RegisterEvent("ADDON_LOADED")

En_UFIFrame:SetScript("OnEvent", function()
	if arg1 == "En_UnitFrames" then
		En_UFI_Frame()
		En_PetFrameHappiness()
	end
end)

En_UFIFrame:SetScript("OnUpdate", function() Update_En_UFIText() end)