﻿local _G = getfenv(0)
local EzTFrame = CreateFrame("Frame")
EzTFrame:RegisterEvent("PLAYER_LOGIN")
EzTFrame:RegisterEvent("START_LOOT_ROLL")	
EzTFrame:RegisterEvent("CONFIRM_LOOT_ROLL")
EzTFrame:RegisterEvent("LOOT_BIND_CONFIRM") 
EzTFrame:RegisterEvent("LOOT_CLOSED");
EzTFrame:RegisterEvent("MAIL_CLOSED");
EzTFrame:RegisterEvent("TRADE_CLOSED");
EzTFrame:RegisterEvent("BANKFRAME_CLOSED");
EzTFrame:RegisterEvent("BAG_UPDATE");

EzTCONFIG = { -- 设定配置选项
	GreenRoll = nil,
	BlueRoll = nil,
	QLRoll = nil,
	ZGRoll = nil,
	OpenClam = nil,
	Passpopup = nil,
}

--[[====================================================================================================]]--
local EzTUIObjects = {} -- 和读取配置有关
local EzTUIStrings = { -- 设定列表名称
	[0] = "放弃|CFF00CCCC[自动]",
	[1] = "需求|CFF00CCCC[自动]",
	[2] = "贪婪|CFF00CCCC[自动]",	
--[[====================================================================================================]]--
	[10] = "放弃|CFF00CCCC[自动]",
	[11] = "需求|CFF00CCCC[自动]",
	[12] = "贪婪|CFF00CCCC[自动]",
--[[====================================================================================================]]--
	[20] = "放弃|CFF00CCCC[自动]",
	[21] = "需求|CFF00CCCC[自动]",
	[22] = "贪婪|CFF00CCCC[自动]",	
--[[====================================================================================================]]--
	[30] = "放弃|CFF00CCCC[自动]",
	[31] = "需求|CFF00CCCC[自动]",
	[32] = "贪婪|CFF00CCCC[自动]",
	[40] = "开贝壳、手提箱",
	[41] = "拾取绑定",
}
--[[====================================================================================================]]--
function EzTGetOption(num) -- 读取列表设置
	local labelString = getglobal(this:GetName().."Text") -- 读取列表设置
	local label = EzTUIStrings[num] or ""
	EzTUIObjects[num] = this
	if num == 00 and EzTCONFIG.GreenRoll == 0 -- 如果选择1 配置也为"放弃"
	or num == 01 and EzTCONFIG.GreenRoll == 1
	or num == 02 and EzTCONFIG.GreenRoll == 2
	or num == 10 and EzTCONFIG.BlueRoll == 0	
	or num == 11 and EzTCONFIG.BlueRoll == 1	
	or num == 12 and EzTCONFIG.BlueRoll == 2	
	or num == 20 and EzTCONFIG.QLRoll == 0
	or num == 21 and EzTCONFIG.QLRoll == 1	
	or num == 22 and EzTCONFIG.QLRoll == 2	
	or num == 30 and EzTCONFIG.ZGRoll == 0
	or num == 31 and EzTCONFIG.ZGRoll == 1	
	or num == 32 and EzTCONFIG.ZGRoll == 2
	or num == 40 and EzTCONFIG.OpenClam == 0
	or num == 41 and EzTCONFIG.Passpopup == 0
	or nil then
		this:SetChecked(true) -- 那么设置选项为已选
	else
		this:SetChecked(nil) -- 否则为空
	end
	labelString:SetText(label)
end

--[[====================================================================================================]]--

function EzTSetOption(num) -- 设置列表选项触发
	local checked = this:GetChecked() -- 定义选项
	if num == 00 then -- 如果选择1
		EzTCONFIG.GreenRoll = 0 -- 那么等于放弃
		if not checked then EzTCONFIG.GreenRoll = nil end -- 如果选项为空 那么等于手动
		EzTUIObjects[01]:SetChecked(nil) -- 需求为空
		EzTUIObjects[02]:SetChecked(nil) -- 贪婪为空
	elseif num == 01 then
		EzTCONFIG.GreenRoll = 1
		if not checked then EzTCONFIG.GreenRoll = nil end
		EzTUIObjects[00]:SetChecked(nil)
		EzTUIObjects[02]:SetChecked(nil)
	elseif num == 02 then
		EzTCONFIG.GreenRoll = 2
		if not checked then EzTCONFIG.GreenRoll = nil end
		EzTUIObjects[00]:SetChecked(nil)
		EzTUIObjects[01]:SetChecked(nil)
	elseif num == 10 then
		EzTCONFIG.BlueRoll = 0
		if not checked then EzTCONFIG.BlueRoll = nil end
		EzTUIObjects[11]:SetChecked(nil)
		EzTUIObjects[12]:SetChecked(nil)
	elseif num == 11 then
		EzTCONFIG.BlueRoll = 1
		if not checked then EzTCONFIG.BlueRoll = nil end
		EzTUIObjects[10]:SetChecked(nil)
		EzTUIObjects[12]:SetChecked(nil)
	elseif num == 12 then
		EzTCONFIG.BlueRoll = 2
		if not checked then EzTCONFIG.BlueRoll = nil end
		EzTUIObjects[10]:SetChecked(nil)
		EzTUIObjects[11]:SetChecked(nil)
	elseif num == 20 then
		EzTCONFIG.QLRoll = 0
		if not checked then EzTCONFIG.QLRoll = nil end
		EzTUIObjects[21]:SetChecked(nil)
		EzTUIObjects[22]:SetChecked(nil)
	elseif num == 21 then
		EzTCONFIG.QLRoll= 1
		if not checked then EzTCONFIG.QLRoll = nil end
		EzTUIObjects[20]:SetChecked(nil)
		EzTUIObjects[22]:SetChecked(nil)
	elseif num == 22 then
		EzTCONFIG.QLRoll = 2
		if not checked then EzTCONFIG.QLRoll = nil end
		EzTUIObjects[20]:SetChecked(nil)
		EzTUIObjects[21]:SetChecked(nil)
	elseif num == 30 then
		EzTCONFIG.ZGRoll = 0
		if not checked then EzTCONFIG.ZGRoll = nil end
		EzTUIObjects[31]:SetChecked(nil)
		EzTUIObjects[32]:SetChecked(nil)
	elseif num == 31 then
		EzTCONFIG.ZGRoll= 1
		if not checked then EzTCONFIG.ZGRoll = nil end
		EzTUIObjects[30]:SetChecked(nil)
		EzTUIObjects[32]:SetChecked(nil)
	elseif num == 32 then
		EzTCONFIG.ZGRoll = 2
		if not checked then EzTCONFIG.ZGRoll = nil end
		EzTUIObjects[30]:SetChecked(nil)
		EzTUIObjects[31]:SetChecked(nil)
	elseif num == 40 then
		EzTCONFIG.OpenClam = 0
		if not checked then EzTCONFIG.OpenClam = nil end
	elseif num == 41 then
		EzTCONFIG.Passpopup = 0
		if not checked then EzTCONFIG.Passpopup = nil end
	end
end

local function ZGRoll(id, quality)
	if EzTCONFIG.ZGRoll ~= nil then
		RollOnLoot(id, EzTCONFIG.ZGRoll)
	end
end

local function QLRoll(id, quality)
	if EzTCONFIG.QLRoll ~= nil then
		RollOnLoot(id, EzTCONFIG.QLRoll)
	end
end

local function GreenRoll(id, quality)
	if EzTCONFIG.GreenRoll ~= nil then
		RollOnLoot(id, EzTCONFIG.GreenRoll)
	end
end

local function BlueRoll(id, quality)
	if EzTCONFIG.BlueRoll ~= nil then
		RollOnLoot(id, EzTCONFIG.BlueRoll)
	end
end

--自动开贝壳
local auto_clams  = {
	5523,  -- Small Barnacled Clam
	5524,  -- Thick-shelled Clam
	7973,  -- Big-mouth Clam
	15874,  -- Soft-shelled Clam
	9276,
}
	
function ForbiddenFrame()
	local auctionframe = false;
	if (AuctionFrame and AuctionFrame:IsVisible()) then
		auctionframe = true
	end
	if (LootFrame:IsVisible() or
	    TradeFrame:IsVisible() or
	    BankFrame:IsVisible() or
	    MailFrame:IsVisible() or
	    auctionframe or
	MerchantFrame:IsVisible()) then
	return true
else
	return false
	end
end

function ExtractLinkID(link)
	local id = tonumber(select(3, string.find(link, "Hitem:(.+):%d+:%d+:%d+%\124")))
	return id
end

function IsClam(link)
	local index
	for index = 1, table.getn(auto_clams) do
		if (ExtractLinkID(link) == auto_clams[index]) then
			return true
		end
	end
	return false
end
		
function CanClam(bag, slot)
	EzTGTP_GameTooltip:SetBagItem(bag, slot)
	local text2 = EzTGTP_GameTooltipTextLeft2:GetText()
	if (text2 and text2 == ITEM_OPENABLE) then
		return true
	else
		return false
	end
end

--自动忽略拾取绑定
local function AutoConfirmLoot(arg1)
	if GetNumPartyMembers() == 0 and GetNumRaidMembers() == 0 then
		local dialog = StaticPopup_FindVisible("LOOT_BIND", arg1)
		if dialog then
			_G[dialog:GetName().."Button1"]:Click()
		end
	end
end

local function EzTOnEvent()
	--创建选择框
	if event == "PLAYER_LOGIN" then
		EzTCreateCheckBoxGroup()
		EzTGTP_GameTooltip = CreateFrame("GameTooltip", "EzTGTP_GameTooltip", UIParent, "GameTooltipTemplate")
		EzTGTP_GameTooltip:SetOwner(EzTFrame, "ANCHOR_NONE")
	end

	--各装备的拾取
	if event == "START_LOOT_ROLL" then
		for i=1, NUM_GROUP_LOOT_FRAMES do
			if IsAddOnLoaded'SmallerRollFrames' then
				Frame = getglobal("SmallGroupLootFrame"..i)
			else
				Frame = getglobal("GroupLootFrame"..i)
			end
			if Frame:IsVisible() then
				local id = Frame.rollID
				local _, name, _, quality = GetLootRollItemInfo(id)
				if string.find(name ,"哈卡莱宝石") or string.find(name ,"硬币") then
					ZGRoll(arg1, quality)
				elseif string.find(name, "雕像") or string.find(name, "甲虫")  or string.find(name, "共鸣水晶") then
					QLRoll(arg1, quality)
				elseif quality == 2 and EzTCONFIG.GreenRoll ~= nil then
					GreenRoll(arg1, quality)
				elseif quality == 3 and EzTCONFIG.BlueRoll ~= nil then
					BlueRoll(arg1, quality)
				end
			end
		end
	end

	--自动开贝壳
	if EzTCONFIG.OpenClam == 0 then
		if event == "LOOT_CLOSED" or event == "MAIL_CLOSED" or event == "TRADE_CLOSED" or event == "BANKFRAME_CLOSED" or event == "BAG_UPDATE" then
			if (not ForbiddenFrame()) then
				local bag, slot
				for bag = 0, 4 do
					for slot = 1, GetContainerNumSlots(bag) do
						local link = GetContainerItemLink(bag, slot)
						if (link and IsClam(link) and CanClam(bag, slot)) then
							UseContainerItem(bag, slot)
						end
					end
				end
			end
		end
	end	
	
	--忽略绑定确认
	if EzTCONFIG.Passpopup == 0 then
		if event == "CONFIRM_LOOT_ROLL" or event == "LOOT_BIND_CONFIRM" then
			QueueFunction(AutoConfirmLoot, arg1)
		end
	end
end

EzTFrame:SetScript("OnEvent", EzTOnEvent)