﻿local CheckBoxTables = { -- 定义多选列表
	["|CFF00FF66绿装选择方式"] = {
		[0] = "GreenRoll",
		[1] = { "EzTCheckbox00", "都不选为手动"},
		[2] = { "EzTCheckbox01", "都不选为手动"},
		[3] = { "EzTCheckbox02", "都不选为手动"}
	},
	
	["|CFF3366CC蓝装选择方式"] = {
		[0] = "BlueRoll",
		[1] = { "EzTCheckbox10", "都不选为手动"},
		[2] = { "EzTCheckbox11", "都不选为手动"},
		[3] = { "EzTCheckbox12", "都不选为手动"}
	},
	
	["|CFF009966其拉雕像甲虫坐骑"] = {
		[0] = "QLRoll",
		[1] = { "EzTCheckbox20", "都不选为手动"},
		[2] = { "EzTCheckbox21", "都不选为手动"},
		[3] = { "EzTCheckbox22", "都不选为手动"}
	},
	
	["|CFFFF7744祖格宝石硬币"] = {
		[0] = "ZGRoll",
		[1] = { "EzTCheckbox30", "都不选为手动"},
		[2] = { "EzTCheckbox31", "都不选为手动"},
		[3] = { "EzTCheckbox32", "都不选为手动"}
	},

	["|CFFFFFF33其他设置"] = {
		[0] = "EasySet1",
		[1] = { "EzTCheckbox40", "拾取需手动开启的物品后自动打开"},
		[2] = { "EzTCheckbox41", "不在队伍（团队）时自动确认拾取绑定物品"},
		
	},
}

--[[====================================================================================================]]--

local function CheckBoxGroup1(hParent, offsetX, offsetY, sTitle, tCheck) -- 批量设置列表位置1
	local Frame = CreateFrame("Frame", tCheck[0], hParent)
	Frame:SetPoint("TOPLEFT", hParent, "TOPLEFT", offsetX, offsetY)
	Frame:SetWidth(11)
	Frame:SetHeight(11)
	local FontsTitle = Frame:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall")
	FontsTitle:SetPoint("TOPLEFT", Frame, "TOPLEFT", 0, 0)
	FontsTitle:SetTextColor(1, 1, 1, 1)
	FontsTitle:SetText(sTitle)
	Frame.FontsTitle = FontsTitle
	Frame.cb = {}
	for k,v in ipairs(tCheck) do
		local cb = CreateFrame("CheckButton", v[1], Frame, "UICheckButtonTemplate")
		cb:SetPoint("TOPLEFT", Frame, "BOTTOMLEFT", 0, -(4+(k-1)*25))
		cb:SetWidth(32)
		cb:SetHeight(32)
		if v[2] then cb.tooltipTitle = v[2] end
		if v[3] then cb.tooltipText = v[3] end
		local num = tonumber(string.sub(v[1], string.find(v[1], "%d+")))
		cb:SetScript("OnShow", function()
			EzTGetOption(num)
		end)
		cb:SetScript("OnClick", function()
			EzTSetOption(num)
		end)
		cb:SetScript("OnEnter", function()
			if this.tooltipTitle then
				GameTooltip:SetOwner(this, "ANCHOR_TOPRIGHT")
				GameTooltip:SetBackdropColor(.01, .01, .01, .91)
				GameTooltip:SetText(this.tooltipTitle)
				if this.tooltipText then
					GameTooltip:AddLine(this.tooltipText, 1, 1, 1)
				end
				GameTooltip:Show()
			end
		end)
		cb:SetScript("OnLeave", function()
			GameTooltip:Hide()
		end)
		Frame.cb[k] = cb
	end
	return Frame
end

local function CheckBoxGroup2(hParent, offsetX, offsetY, sTitle, tCheck) -- 批量设置列表位置2
	local Frame = CreateFrame("Frame", tCheck[0], hParent)
	Frame:SetPoint("TOPLEFT", hParent, "TOPLEFT", offsetX, offsetY)
	Frame:SetWidth(11)
	Frame:SetHeight(11)
	local FontsTitle = Frame:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall")
	FontsTitle:SetPoint("TOPLEFT", Frame, "TOPLEFT", 0, 0)
	FontsTitle:SetTextColor(1, 1, 1, 1)
	FontsTitle:SetText(sTitle)
	Frame.FontsTitle = FontsTitle
	Frame.cb = {}
	for k,v in ipairs(tCheck) do
		local cb = CreateFrame("CheckButton", v[1], Frame, "UICheckButtonTemplate")
		cb:SetPoint("TOPLEFT", Frame, "BOTTOMLEFT", 0, -(4+(k-1)*30))
		cb:SetWidth(32)
		cb:SetHeight(32)
		if v[2] then cb.tooltipTitle = v[2] end
		if v[3] then cb.tooltipText = v[3] end
		local num = tonumber(string.sub(v[1], string.find(v[1], "%d+")))
		cb:SetScript("OnShow", function()
			EzTGetOption(num)
		end)
		cb:SetScript("OnClick", function()
			EzTSetOption(num)
		end)
		cb:SetScript("OnEnter", function()
			if this.tooltipTitle then
				GameTooltip:SetOwner(this, "ANCHOR_TOPRIGHT")
				GameTooltip:SetBackdropColor(.01, .01, .01, .91)
				GameTooltip:SetText(this.tooltipTitle)
				if this.tooltipText then
					GameTooltip:AddLine(this.tooltipText, 1, 1, 1)
				end
				GameTooltip:Show()
			end
		end)
		cb:SetScript("OnLeave", function()
			GameTooltip:Hide()
		end)
		Frame.cb[k] = cb
	end
	return Frame
end

function EzTCreateCheckBoxGroup() -- 创建主窗口函数
	local Frame = CreateFrame("Frame", "EzTUIFrame")
	local str = "|CFF00FF66绿装选择方式"
	Frame.GreenRoll = CheckBoxGroup1(LootFilterOptions, 22, -35, str, CheckBoxTables[str]) -- 用CheckBoxTables1函数批量设置列表的位置
	local str = "|CFF3366CC蓝装选择方式"
	Frame.BlueRoll = CheckBoxGroup1(LootFilterOptions, 130, -35, str, CheckBoxTables[str])
	local str = "|CFF009966其拉雕像甲虫坐骑"
	Frame.QLRoll = CheckBoxGroup1(LootFilterOptions, 240, -35, str, CheckBoxTables[str])
	local str = "|CFFFF7744祖格宝石硬币"
	Frame.ZGRoll = CheckBoxGroup1(LootFilterOptions, 350, -35, str, CheckBoxTables[str])
	local str = "|CFFFFFF33其他设置"
	Frame.EasySet1 = CheckBoxGroup2(LootFilterOptions, 20, -140, str, CheckBoxTables[str]) -- 用CheckBoxTables2函数批量设置列表的位置
	return Frame
end