LootFilterVars = {};

LootFilter = {
	VERSION = "Lite1.0",
	LOOT_TIMEOUT = 20,
	LOOT_PARSE_DELAY = 2,
	REALMPLAYER= "",

	timerArr= {},
	hooked= false,
	lastUpdate= 0,
	hasFocus= 0;
};


LootFilter.print = function(value)
	if (value == nil) then
		value= "";
	end;
	DEFAULT_CHAT_FRAME:AddMessage("|cffFF0066拾取过滤|r - "..value, 1.0, 1.0, 1.0);
end;

LootFilter.schedule = function(delay, func, arg)
	table.insert(LootFilter.timerArr, {time=time()+delay, func=func, args=arg});
	if (not LootFilter.hooked) then
		LootFilter.hook();
	end;
end;

LootFilter.WorldFrame_OnUpdate = function()
	LootFilter.hook();
	local curtime= time();
	if (LootFilter.lastUpdate < curtime) then
		if (table.getn(LootFilter.timerArr) == 0) then
			LootFilter.unhook();
			return;
		end;
		for i=1, table.getn(LootFilter.timerArr), 1 do
			if (LootFilter.timerArr[i].time <= curtime) then
				func= LootFilter.timerArr[i].func;
				args= LootFilter.timerArr[i].args;
				table.remove(LootFilter.timerArr,i);
				func(args);
				return;
			end;
		end;
		LootFilter.lastUpdate= curtime+1;
	end;
end;

LootFilter.hook = function()
	Original_WorldFrame_OnUpdate= WorldFrame_OnUpdate;
	WorldFrame_OnUpdate= LootFilter.WorldFrame_OnUpdate;
	LootFilter.hooked= true;
end;

LootFilter.unhook = function()
	WorldFrame_OnUpdate= Original_WorldFrame_OnUpdate;
	LootFilter.hooked= false;
end;

LootFilter.setTitle = function()
	LootFilterFrameTitleText:SetText("拾取过滤 "..LootFilter.VERSION);
	table.insert(UISpecialFrames, "LootFilterOptions");--ESC可以自动关闭窗口，BY狗血编剧男
end;

LootFilter.matches = function(itemName, searchName, itemSubType)
	if (itemName == nil) or (searchName == nil) then
		return false;
	end;
	if (itemSubType ~= "") and (string.find(searchName, "##", 1, true) == 1) then
		if (string.lower(itemSubType) == string.lower(string.sub(searchName, 3))) then
			return true;
		end;
	elseif (string.find(searchName, "#", 1, true) == 1) then
		if (string.find(string.lower(itemName), string.lower(string.sub(searchName, 2)))) then
			return true;
		end;
	elseif (string.lower(itemName) == string.lower(searchName)) then
		return true;
	end;
	return false;
end;

LootFilter.deleteItemFromInventory = function(searchItem)
	local item= searchItem;
	local pipe= string.find(item, "|", 1, true);
	searchItem= string.sub(item, 1, pipe-1);
	searchName= string.sub(item, pipe+1);
	for j=0 , 4 , 1 do
		x = GetContainerNumSlots(j);
		for i=0 , x , 1 do
			local item = GetContainerItemInfo(j, i);
			if LootFilter.matches(item, searchItem, "") then
				local itemName= "";
				local itemlink= GetContainerItemLink(j,i);
				if (itemlink ~= nil) then
					for a,itemid in string.gmatch(itemlink, "([^:]+):(%w+)") do
						itemid= tonumber(itemid);
						if (itemid >= 1) then
							local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount = GetItemInfo(itemid)
							if LootFilter.matches(itemName, searchName, "") then
								local delete= true;

								if (delete) then
									delete= false;
									for i=1, table.getn(LootFilterVars[LootFilter.REALMPLAYER].namesdelete), 1 do
										if LootFilter.matches(searchName, LootFilterVars[LootFilter.REALMPLAYER].namesdelete[i], itemSubType) then
											delete= true;
											break;
										end;
									end;
								end;

								if (not delete) then
									table.remove(LootFilterVars[LootFilter.REALMPLAYER].itemStack, 1);
									return true;
								end;

								PickupContainerItem(j, i);
								if (CursorHasItem()) then
									DeleteCursorItem();
									table.remove(LootFilterVars[LootFilter.REALMPLAYER].itemStack, 1);
									if (LootFilterVars[LootFilter.REALMPLAYER].notifydelete) then
										LootFilter.print("已自动摧毁"..itemlink);
									end;
									return true;
								else
									return false;
								end;
				
							end;

						end;
					end;
				else -- item got moved?
					return false; 
				end;
			end
		end
	end;
	return false;
end

LootFilter.findItems = function(maxtime)
	numitems= table.getn(LootFilterVars[LootFilter.REALMPLAYER].itemStack);
	if (numitems == 0) then
		return;
	end;

	if (time() > maxtime) then -- timeout, the item could not be found remove it from stack
		table.remove(LootFilterVars[LootFilter.REALMPLAYER].itemStack, 1);
		LootFilter.schedule(1, LootFilter.findItems, time()+LootFilter.LOOT_TIMEOUT);
		return;
	end;

	if (LootFilter.deleteItemFromInventory(LootFilterVars[LootFilter.REALMPLAYER].itemStack[1])) then -- loot succesful
		LootFilter.schedule(1, LootFilter.findItems, time()+LootFilter.LOOT_TIMEOUT);
	else -- could not find loot, lets try again
		LootFilter.schedule(1, LootFilter.findItems, maxtime);
	end;
end

LootFilter.getNamesDelete = function()
	local result= "";
	for i=1, table.getn(LootFilterVars[LootFilter.REALMPLAYER].namesdelete), 1 do
		result= result..LootFilterVars[LootFilter.REALMPLAYER].namesdelete[i].."\n";
	end;
	this:SetText(result);
end;

LootFilter.setNamesDelete = function()
	LootFilterVars[LootFilter.REALMPLAYER].namesdelete= {};
	local result= LootFilterEditBox2:GetText().."\n";
	if (result ~= nil) then
		for w in string.gmatch(result, "[^\n]+\n") do
			w = string.gsub(w, "\n", "");
			table.insert(LootFilterVars[LootFilter.REALMPLAYER].namesdelete, w);
		end;
	end;
end;

LootFilter.setItemValue= function ()
	local value = tonumber(LootFilterEditBox3:GetText());
	LootFilterVars[LootFilter.REALMPLAYER].itemValue= value;
end;

LootFilter.getItemValue = function()
	if (LootFilterVars[LootFilter.REALMPLAYER].itemValue == nil) or (LootFilterVars[LootFilter.REALMPLAYER].itemValue == "") then
		value= "0";
	else
		value= LootFilterVars[LootFilter.REALMPLAYER].itemValue;
	end;
	this:SetText(value);
end;

LootFilter.ItemValueChange = function()
	local value= tonumber(LootFilterEditBox3:GetText())
	if ((value == nil) or (value < 0) or (value == "")) then
		this:SetText("0");
		LootFilterCheckboxItemValue:SetChecked(false);
		LootFilterVars[LootFilter.REALMPLAYER].filterItemValue= false;
	end
end

LootFilter.getOption = function(num)
	local labelString = getglobal(this:GetName().."Text");
	local label= "";
	if (num == 99) then
		this:SetChecked(LootFilterVars[LootFilter.REALMPLAYER].enabled);
		label= "启用自动删除";
	elseif (num == 199) then
		this:SetChecked(LootFilterVars[LootFilter.REALMPLAYER].notifydelete);
		label= "删除时提示";
	elseif (num == 299) then
		this:SetChecked(LootFilterVars[LootFilter.REALMPLAYER].filterItemValue);
		label= "灵魂碎片上限";
	end;

	labelString:SetText(label);
end;

LootFilter.setOption = function(num)
	local check;
	if (this:GetChecked()) then
		check= true;
	else
		check= false;
	end;
	if (num == 99) then
		LootFilterVars[LootFilter.REALMPLAYER].enabled= check;
	elseif (num == 199) then
		LootFilterVars[LootFilter.REALMPLAYER].notifydelete= check;
	elseif (num == 299) then
		LootFilterVars[LootFilter.REALMPLAYER].filterItemValue= check;
	end;
end;

LootFilter.updateFocus = function(num , value)
	if (value) then
		this:SetFocus();
		LootFilter.hasFocus= num;
	else
		this:ClearFocus();
		LootFilter.hasFocus= 0;
	end;
end;

LootFilter.findItemWithLock = function()
	for j=0 , 4 , 1 do
		x = GetContainerNumSlots(j);
		for i=0 , x , 1 do
			local _, _, locked = GetContainerItemInfo(j,i);
			if (locked) then
				local itemlink= GetContainerItemLink(j,i);
				if (itemlink ~= nil) then
					for a,itemid in string.gmatch(itemlink, "([^:]+):(%w+)") do
						itemid= tonumber(itemid);
						if (itemid >= 1) then
							local itemName = GetItemInfo(itemid);
							return itemName;
						end;
					end;
				end;
			end;
		end;
	end;
	return "";
end;

function GetShardsID(link)
	_, _, id = string.find(link, "Hitem:(.+):%d+:%d+:%d+%\124")
	return tonumber(id)
end

LootFilter.OnEvent = function()

	if (event == "LOOT_OPENED") and (LootFilterVars[LootFilter.REALMPLAYER].enabled) then
		numitems= GetNumLootItems();
		if (table.getn(LootFilterVars[LootFilter.REALMPLAYER].itemStack) == 0) then
			LootFilterVars[LootFilter.REALMPLAYER].itemLinkStack = {};
		end;
		for i=1, numitems, 1 do
			if (not LootSlotIsCoin(i)) then
				icon, name, quantity, quality= GetLootSlotInfo(i);
				if (icon ~= nil) then
					table.insert(LootFilterVars[LootFilter.REALMPLAYER].itemStack, icon.."|"..name);
					table.insert(LootFilterVars[LootFilter.REALMPLAYER].itemLinkStack, GetLootSlotLink(i));
				end;
			end;
		end;
	end;

	if (event == "LOOT_CLOSED") then
		LootFilter.schedule(LootFilter.LOOT_PARSE_DELAY, LootFilter.findItems, time()+LootFilter.LOOT_TIMEOUT);
	end;

	if (event == "ITEM_LOCK_CHANGED") then
		if (LootFilter.hasFocus > 0) then
			itemName= LootFilter.findItemWithLock();
			if (itemName ~= nil) and (itemName ~= "") then
				if (LootFilter.hasFocus == 2) then
					LootFilterEditBox2:SetText(LootFilterEditBox2:GetText()..itemName.."\n");
				end;
			end;
		end;
	end;
	
	if (event == "CHAT_MSG_LOOT") then
		if (LootFilterVars[LootFilter.REALMPLAYER].filterItemValue == true) then
			local _, _, CreateShards = string.find(arg1, "你制造了：(.+)。")
			local _, _, GetShards = string.find(arg1, "你获得了物品：(.+)。")
			local numShards = 0, bag, slot
			for bag = 4, 0, -1 do
				for slot = 1, GetContainerNumSlots(bag), 1 do
					link = GetContainerItemLink(bag, slot)
					if (((GetShards and GetShardsID(GetShards) == 6265) or (CreateShards and GetShardsID(CreateShards) == 6265)) and (link and GetShardsID(link) == 6265)) then
						numShards = numShards + 1
						if numShards >= tonumber(LootFilterVars[LootFilter.REALMPLAYER].itemValue) then
							PickupContainerItem(bag, slot)
							DeleteCursorItem()
						end
					end
				end
			end
		end
	end;

	if (event == "ADDON_LOADED") then

		if (arg1 == "LootFilter") then
			LootFilter.REALMPLAYER= GetCVar("realmName")..UnitName("player");

			if (LootFilterVars[LootFilter.REALMPLAYER] == nil) then
				LootFilterVars[LootFilter.REALMPLAYER]= {};
			end;

			if (LootFilterVars[LootFilter.REALMPLAYER].namesdelete == nil) then
				LootFilterVars[LootFilter.REALMPLAYER].namesdelete= {};
			end;
			if (LootFilterVars[LootFilter.REALMPLAYER].itemStack == nil) then
				if (LootFilterVars.itemStack ~= nil) then
					LootFilterVars[LootFilter.REALMPLAYER].itemStack= LootFilterVars.itemStack;
					LootFilterVars.itemStack= nil;
				else
					LootFilterVars[LootFilter.REALMPLAYER].itemStack= {};
				end;
			end;
			if (LootFilterVars[LootFilter.REALMPLAYER].itemLinkStack == nil) then
				LootFilterVars[LootFilter.REALMPLAYER].itemLinkStack= {};
			end;
			if (LootFilterVars[LootFilter.REALMPLAYER].enabled == nil) then
				if (LootFilterVars.enabled ~= nil) then
					LootFilterVars[LootFilter.REALMPLAYER].enabled= LootFilterVars.enabled;
					LootFilterVars.enabled= nil;
				else
					LootFilterVars[LootFilter.REALMPLAYER].enabled= true;
				end;
			end;
			if (LootFilterVars[LootFilter.REALMPLAYER].notifydelete == nil) then
				LootFilterVars[LootFilter.REALMPLAYER].notifydelete= true;
			end;
			if (LootFilterVars[LootFilter.REALMPLAYER].filterItemValue == nil) then
				LootFilterVars[LootFilter.REALMPLAYER].filterItemValue= false;
			end;
		end;
		LootFilter.checkDepencies();
	end;
end;

LootFilter.checkDepencies = function()
	LootFilterCheckboxItemValue:Show();
	LootFilterEditBox3:Show();
	LootFilterTextBackground3:Show();
end;

LootFilter.OnLoad = function()
	this:RegisterEvent("LOOT_OPENED");
	this:RegisterEvent("LOOT_CLOSED");
	this:RegisterEvent("ADDON_LOADED");
	this:RegisterEvent("ITEM_LOCK_CHANGED");
	this:RegisterEvent("CHAT_MSG_LOOT");
end;