------------------------------------- VARIABLES ---------------------------------------
SLIB_NOM = "插件命令控制台";
SLIB_VERS = "1.0";

------------- valeurs par defaut
SlashLibSaved = {};
SlashLibSaved["closeRun"] = true;

SlashLibSavedData = {};
SlashLibSavedData[1] = {"1.初始设置","/run print(\"镜头最大距离为50(0-50)\")\n/run print(\"A键向左平移，D键向右平移\")\n/script MyInitSet()",3};
SlashLibSavedData[2] = {"2.Tab距离设置","/script Tab_SetFrame:Show()",3};
SlashLibSavedData[3] = {"3.buff框架设置","/Buffalo config",1};
SlashLibSavedData[4] = {"4.buff监视","/dfilter",1};
SlashLibSavedData[5] = {"5.战斗信息(目标)","/dex",1};
SlashLibSavedData[6] = {"6.战斗信息(玩家)","/script DSCT_showMenu()",3};
SlashLibSavedData[7] = {"7.聊天框","/sccn",1};
SlashLibSavedData[8] = {"8.攻击条：解锁/锁定","/script if IsAddOnLoaded'Attackbar' then if Abar_Frame:IsShown() then Abar_Frame:Hide() else Abar_Frame:Show() end else print('未加载Attackbar') end",3};
SlashLibSavedData[9] = {"9.血条姓名板","/sp",1};
SlashLibSavedData[10] = {"10.Roll点美化","/smrf",1};
SlashLibSavedData[11] = {"11.动作条","/zbar",1};
SlashLibSavedData[12] = {"12.团队：伤害统计","/script DamageMeters_ToggleShow()",3};
SlashLibSavedData[13] = {"13.团队：仇恨统计","/script KTM_ToggleFrame()",3};
SlashLibSavedData[14] = {"14.团队：一键驱散","/script if not DecursiveMainBar:IsVisible() then DecursiveMainBar:Show() else DecursiveMainBar:Hide() end",3};
SlashLibSavedData[15] = {"15.团队：血条框架","/notgrid",3};
SlashLibSavedData[16] = {"16.团队：标记","/bb",3};
-------------
TABLEVISBTNS = {};
SLIBLIGNE = {};
SLIBSCROLLHEIGHT = 22; -- hauteur ligne
SLIBVISLINE = 14; -- nombre de lignes visibles dans la main UI -- nombre de lignes visibles : SLIBVISLINE * SLIBSCROLLHEIGHT = hauteur ScrollFrame et aussi nombre de boutons-lignes
SLIBVISLINELIST = 22; -- nombre de lignes visibles dans la liste des slash-cmds
SLIBLISTALLCMDS = {};
local SEPLIGNE = "\n";

---------------------------------------------------------------------------------------
-------------------------- CHARGEMENT / COMMANDES /BINDINGS ---------------------------
function slibChargement()
	SlashCmdList["SLIBSHOWUI"] = slibUIShow;
		SLASH_SLIBSHOWUI1 = "/slashlib";
		SLASH_SLIBSHOWUI2 = "/cj";

	-------------- bindings
	BINDING_HEADER_SLASHLIB = SLIB_NOM;
	BINDING_NAME_SLIBshow = "显示控制台";

	-------------- suite
	slibLigneInit();
end

---------------------------------------------------------------------------------------
------------------------------------------ UI -----------------------------------------
function slibUIShow()
	if (SlibFrame:IsVisible()) then
		slibUIClose();
	else
		slibUIClose(); -- menage
		SlibFrame:Show(); -- ne pas intervertir avec la ligne suivante !
		slibScrollerUpdate(); -- ne pas intervertir avec la ligne precedente !
	end;
end

function slibScrollerUpdate()
	TABLEVISBTNS = {};
	local line; -- 1 through SLIBVISLINE
	local linePlusOffset; -- an index into our data calculated from the scroll offset
	local nbreLiMax = getn(SlashLibSavedData); -- nombre de lignes
	FauxScrollFrame_Update(SlibFrameScroller,nbreLiMax,SLIBVISLINE,SLIBSCROLLHEIGHT);

	for line = 1,SLIBVISLINE,1 do
		linePlusOffset = line + FauxScrollFrame_GetOffset(SlibFrameScroller);
		if (linePlusOffset <= nbreLiMax) then
			TABLEVISBTNS[line] = SlashLibSavedData[linePlusOffset];
			TABLEVISBTNS[line][4] = linePlusOffset;
			getglobal("SlibFrameLine_"..line.."_BtnTitre_TxtTitre"):SetText(TABLEVISBTNS[line][1]);
			getglobal("SlibFrameLine_"..line.."_BtnCmd_Tex"):SetTexture(0.3,0.3,0.3,0.4);
			local genre = TABLEVISBTNS[line][3];
			if (genre == 2) then -- emote
				getglobal("SlibFrameLine_"..line.."_BtnTitre_TxtTitre"):SetTextColor(0.4,0.7,0.9);
			elseif (genre == 3) then -- macro
				getglobal("SlibFrameLine_"..line.."_BtnTitre_TxtTitre"):SetTextColor(0.9,0.4,0.4);
			else
				getglobal("SlibFrameLine_"..line.."_BtnTitre_TxtTitre"):SetTextColor(0.9,0.9,0.4);
			end;
			getglobal("SlibFrameLine_"..line.."_BtnCmd_TxtCmd"):SetText(string.gsub(SlashLibSavedData[linePlusOffset][2],SEPLIGNE,"..."));
			getglobal("SlibFrameLine_"..line):Show();
		else
			getglobal("SlibFrameLine_"..line):Hide();
		end;
	end;
	SlibFrameScroller:Show(); -- ???
end

function slibUIDo(nomBouton)
	slibGetLibLigne(nomBouton);
	if (SLIBLIGNE["cmd"] ~= "") then
		if (SlashLibSaved["closeRun"]) then SlibFrame:Hide(); end;
		slibDoSlashCmd(SLIBLIGNE["cmd"]);
	else
		print(SLIB_NOM..": 错误 - 命令 #"..SLIBLIGNE["numLi"].." 不存在!");
	end;
end

function slibUINew()
	slibUIEditResetTex();
	SlibNameDef:SetText("");
	SlibCmdDef:SetText("");
	slibUIEditAllumeRadios(1); -- genre "slash-cmd" par defaut
	slibLigneInit();
	SlibEditFrame:Show();
	SlibNameDef:SetFocus();
end

function slibUIClose()
	SlibListCmdsFrame:Hide();
	SlibEditFrame:Hide();
	SlibNameDef:SetText("");
	SlibCmdDef:SetText("");
	SlibFrame:Hide();
end

function slibUIEdit(nomBouton)
	slibGetLibLigne(nomBouton);
	if (SLIBLIGNE["numLi"] > 0) then
		slibUIEditResetTex();
		getglobal("SlibFrameLine_"..SLIBLIGNE["numLi"].."_BtnCmd_Tex"):SetTexture(1,1,0,0.9);
		SlibNameDef:SetText(SLIBLIGNE["nom"]);
		SlibCmdDef:SetText(SLIBLIGNE["cmd"]);
		slibUIEditAllumeRadios(SLIBLIGNE["genre"]);
		SlibEditFrame:Show();
		SlibNameDef:SetFocus();
	end;
end

function slibUIEditResetTex()
	for i = 1,SLIBVISLINE,1 do
		getglobal("SlibFrameLine_"..i.."_BtnCmd_Tex"):SetTexture(0.3,0.3,0.3,0.4);
	end;
end

function slibUIEditSave()
	local nom = SlibNameDef:GetText();
	if (nom ~= "") then
		local commande = SlibCmdDef:GetText();
		local novoLigne = {nom,commande,slibUIEditGetNumRadio()};
		if (SLIBLIGNE["numLi"] == 0) then -- new
			table.insert(SlashLibSavedData,novoLigne);
		else
			SlashLibSavedData[SLIBLIGNE["numLiOr"]] = novoLigne;
		end;
		---------
		SlashLibSavedData = sortTable(SlashLibSavedData,1,"1","200");
		---------
		slibScrollerUpdate();
		slibUIEditResetTex();
		SlibListCmdsFrame:Hide();
		SlibEditFrame:Hide();
	else
		print(SLIB_NOM..": 键入个名字，定义为这个新的命令行!");
	end;
end

function slibUIEditDelete(nomBouton)
	if (nomBouton ~= nil and nomBouton ~= "") then -- si appel depuis l'UI principale (clic liste)
		slibGetLibLigne(nomBouton);
	end;
	if (SLIBLIGNE["numLi"] > 0) then -- appel normal : btn "delete" UI edition
		table.remove(SlashLibSavedData,SLIBLIGNE["numLiOr"]);
		slibScrollerUpdate();
		SlibEditFrame:Hide();
	else
		print(SLIB_NOM..": 空的不能删除!");
	end;
end

function slibUIEditCancel()
	SlibListCmdsFrame:Hide();
	SlibEditFrame:Hide();
	SlibNameDef:SetText("");
	SlibCmdDef:SetText("");
	slibUIEditResetTex();
	slibLigneInit(); -- secu
end

function slibUIEditAllumeRadios(numBtn)
	SlibRadBtn1:SetChecked(0);
	SlibRadBtn2:SetChecked(0);
	SlibRadBtn3:SetChecked(0);
	if (numBtn ~= nil and numBtn ~= "") then
		local nbre = strToNumber(numBtn);
		if (nbre > 1 and nbre <= 3) then
			getglobal("SlibRadBtn"..numBtn):SetChecked(1);
		else
			SlibRadBtn1:SetChecked(1);
		end;
	else
		print(SLIB_NOM..": 错误 - 无效按钮!");
	end;
end

function slibUIEditGetNumRadio()
	local i;
	for i = 1,3,1 do
		if (getglobal("SlibRadBtn"..i):GetChecked() == 1) then return i; end;
	end;
	return 1; -- defaut
end

function slibUIEditListShow()
	if (SlibListCmdsFrame:IsVisible()) then
		SlibListCmdsFrame:Hide();
	else
		listeAllSlashCmd(); -- remplissage SLIBLISTALLCMDS
		SlibListCmdsFrame:Show(); -- ne pas intervertir avec la ligne suivante !
		slibScrollerListUpdate(); -- ne pas intervertir avec la ligne precedente !
	end;
end

function slibScrollerListUpdate()
	local line; -- 1 through nbreLiVis
	local linePlusOffset; -- an index into our data calculated from the scroll offset
	local nbreLiMax = getn(SLIBLISTALLCMDS); -- nombre de lignes
	FauxScrollFrame_Update(SlibListFrameScroller,nbreLiMax,SLIBVISLINELIST,SLIBSCROLLHEIGHT);
	
	for line = 1,SLIBVISLINELIST,1 do
		linePlusOffset = line + FauxScrollFrame_GetOffset(SlibListFrameScroller);
		if (linePlusOffset <= nbreLiMax) then
			getglobal("SlibListLigneBtn_"..line.."_Texte"):SetText(SLIBLISTALLCMDS[linePlusOffset]);
			getglobal("SlibListLigneBtn_"..line):Show();
		else
			getglobal("SlibListLigneBtn_"..line):Hide();
		end;
	end;
	SlibListFrameScroller:Show(); -- ???
end

function slibUIEditListClick(txtBouton)
	if (txtBouton ~= nil) then
		if (string.sub(txtBouton,1,1) == "/") then
			if (IsControlKeyDown()) then -- DO (TEST)
				SlibCmdDef:SetText(SlibCmdDef:GetText()..txtBouton);
			else -- AJOUT EDIT
				slibDoSlashCmd(txtBouton);
			end;
		else
			print(SLIB_NOM..": 错误 - "..txtBouton.." 不是个有效命令行!");
		end;
	else
		print(SLIB_NOM..": 错误 - 无效命令行(NIL)!");
	end;
end

---------------------------------------------------------------------------------------
------------------------------------ FCNS INTERNES ------------------------------------
function slibLigneInit()
	SLIBLIGNE = {};
	SLIBLIGNE["numLi"] = 0;
	SLIBLIGNE["nom"] = "";
	SLIBLIGNE["cmd"] = "";
	SLIBLIGNE["genre"] = 1; -- genre : 1 = slash-cmd, 2 = Emote et 3 = Macro
	SLIBLIGNE["numLiOr"] = 0;
end

function slibGetLibLigne(nomBouton)
	if (nomBouton ~= nil) then
		local numBtn = strToNumber(extractValeur(nomBouton,"_"));

		if (numBtn > 0 and numBtn <= getn(TABLEVISBTNS)) then
			SLIBLIGNE["numLi"] = numBtn;
			SLIBLIGNE["nom"] = TABLEVISBTNS[numBtn][1];
			SLIBLIGNE["cmd"] = TABLEVISBTNS[numBtn][2];
			SLIBLIGNE["genre"] = TABLEVISBTNS[numBtn][3];
			SLIBLIGNE["numLiOr"] = TABLEVISBTNS[numBtn][4];
		else
			slibLigneInit();
			print(SLIB_NOM..": 错误 - 无法找到 #"..nilSiNul(numBtn).."!");
		end;
	else
		slibLigneInit();
		print(SLIB_NOM..": 错误 - 空行!");
	end;
end

function slibDoSlashCmd(chaineCmd)
	local chaine = chaineCmd..SEPLIGNE;
	local pos1,pos2,chaineTemp;
	local i = 1;
	while string.find(chaine,SEPLIGNE,1,true) ~= nil do
		pos1,pos2 = string.find(chaine,SEPLIGNE,1,true);
		chaineTemp = string.sub(chaine,1,pos1 - 1);
		-------- envoi ligne de commande
		if (string.sub(chaineTemp,1,1) == "/") then
			DEFAULT_CHAT_FRAME.editBox:SetText(chaineTemp);
			ChatEdit_SendText(DEFAULT_CHAT_FRAME.editBox,0);
		else
			print(SLIB_NOM..": 错误 - "..chaineTemp.." 不是有效命令!");
		end;
		--------
		chaine = string.sub(chaine,pos2 + 1);
		i = i + 1;
		if (i > 50) then return; end; -- secu
	end;
end

function listeAllSlashCmd()
	SLIBLISTALLCMDS = {};
	local prevCommande = "";
	for index,value in pairs(SlashCmdList) do -- SlashCmdList = table Blizzard des slash-cmds
		local i = 1;
		local cmdString = TEXT(getglobal("SLASH_"..index..i));
		while (cmdString) do
			if (cmdString ~= prevCommande) then
				table.insert(SLIBLISTALLCMDS,cmdString);
				prevCommande = cmdString;
			end;
			i = i + 1;
			cmdString = TEXT(getglobal("SLASH_"..index..i));
		end;
	end;
	table.sort(SLIBLISTALLCMDS);
end

---------------------------------------------------------------------------------------
--排序（按照数字1-200排序）
function sortTable(tableOr,cle,sens,genre)
	local tableTemp = {};
	for i in ipairs(tableOr)do
		table.insert(tableTemp,i);
	end;
	if (sens == nil) then sens = "1"; end;
	sens = string.upper(string.sub(sens,1,1));
	if (genre == nil) then genre = "200"; end;
	genre = string.upper(string.sub(genre,1,1));
	for i in ipairs(tableTemp)do
		tableTemp[i] = tableOr[tableTemp[i]];
	end
	return tableTemp;
end

function extractValeur(chaine,sep)
	-- renvoit la portion de la chaine passee situee entre les 2 premiers sep (ou vide si sep n'est pas trouve)
	if (chaine ~= nil and sep ~= nil) then
		local pos = string.find(chaine,"_",1,true);
		if (pos ~= nil) then
			local chaineTemp = string.sub(chaine,pos + 1);
			pos = string.find(chaineTemp,"_",1,true);
			if (pos ~= nil) then
				return (string.sub(chaineTemp,1,pos - 1));
			else
				return chaineTemp;
			end;
		else
			return "";
		end;
	else
		return nil;
	end;
end

function strToNumber(chaine)
	local valeur = tonumber(string.gsub(string.gsub(chaine,"\"",""),"\'",""),10);
	if (valeur == nil) then valeur = 0; end;
	return valeur;
end

function booleanToSr(valeur)
	if (valeur) then return "true"; else return "false"; end;
end

function booleanToBin(valeur)
	return (valeur == 1);
end

function videSiNul(valeur)
	if (valeur == nil) then return ""; else return valeur; end;
end

function nilSiNul(valeur)
	if (valeur == nil) then return "NIL"; else return valeur; end;
end
------------------------------------- AIDE ONLINE -------------------------------------
function slibSlashListe()
	local i;
	local aideOnline =  {};
	aideOnline[1] = "/cj: 显示命令行";
	print("------------------------");
	for i = 1,getn(aideOnline),1 do
		print("   "..aideOnline[i].."\n");
	end;
	print("------------------------");
end

--聊天框创建"命令"按钮
local MySlashButton = CreateFrame("Button", "MySlashButton", ChatFrame)
SetSize(MySlashButton, 17, 17)
MySlashButton:SetNormalTexture("Interface\\AddOns\\MySlash\\UiLogo.tga")
MySlashButton:SetPushedTexture("Interface\\AddOns\\MySlash\\UiLogo.tga")
MySlashButton:GetPushedTexture():SetTexCoord(.09,.91,.09,.91)
MySlashButton:SetHighlightTexture("Interface\\Buttons\\UI-Common-MouseHilight", "ADD")
MySlashButton:GetHighlightTexture():SetTexCoord(.09,.91,.09,.91)
MySlashButton:SetPoint("BOTTOMRIGHT", ChatFrame1, "TOPRIGHT", -22, 5)

MySlashButton:SetScript("OnMouseDown", function()
	if arg1 == "LeftButton" then
		PlaySound("igChatEmoteButton")
		slibUIShow()
		slibUIEditListShow()
	end	
end)

MySlashButton:SetScript("OnEnter", function() 
	GameTooltip:SetOwner(this, "ANCHOR_TOP", 0, 6)
	GameTooltip:AddLine("命令")
	GameTooltip:Show()
end)

MySlashButton:SetScript("OnLeave", function() GameTooltip:Hide() end)
EnableAutohide(MySlashButton, 0.5)

function MyInitSet()
	--镜头最大距离50(0-50)
	SetCVar("cameraDistanceMax", 50)
	--A左平移，D右平移
	SetBinding("A", "STRAFELEFT")
	SetBinding("D", "STRAFERIGHT")
	SaveBindings(GetCurrentBindingSet())
end

--Tab距离
Tab_Set = 10
local Tab_SetFrame = CreateFrame("Frame", "Tab_SetFrame", UIParent)
SetSize(Tab_SetFrame, 180, 100)
Tab_SetFrame:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background", edgeFile = "Interface/Tooltips/UI-Tooltip-Border", tile = true, tileSize = 16, edgeSize = 16, insets = { left = 4, right = 4, top = 4, bottom = 4 }})
Tab_SetFrame:SetBackdropColor(0, 0, 0, 0.5)
Tab_SetFrame:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
Tab_SetFrame:Hide()

Tab_SetFrame.Slider = CreateFrame("Slider", "TabSlider", Tab_SetFrame, "OptionsSliderTemplate")
Tab_SetFrame.Slider:SetPoint("CENTER", 0, 10)
Tab_SetFrame.Slider:SetMinMaxValues(1, 50)
Tab_SetFrame.Slider:SetValueStep(1)
getglobal(Tab_SetFrame.Slider:GetName() .. "Low"):SetText(1)
getglobal(Tab_SetFrame.Slider:GetName() .. "High"):SetText(50)
Tab_SetFrame.Slider:SetScript("OnValueChanged", function()
	if GetMouseFocus() == this then
		getglobal(this:GetName() .. 'Text'):SetText("Tab距离："..arg1)
		if Tab_Set ~= nil then
			Tab_Set = arg1
		end
	end
end)

local function GetTabValue()
	if Tab_Set ~= nil then
		return Tab_Set
	else
		return 10
	end
end

Tab_SetFrame:SetScript("OnShow", function()
	getglobal(Tab_SetFrame.Slider:GetName() .. 'Text'):SetText("Tab距离："..GetTabValue())
	Tab_SetFrame.Slider:SetValue(GetTabValue())
end)

Tab_SetFrame.Confirm = CreateFrame("Button", "TabSliderConfirm", Tab_SetFrame, "UIPanelButtonTemplate")
SetSize(Tab_SetFrame.Confirm, 40, 25)
Tab_SetFrame.Confirm:SetFont(STANDARD_TEXT_FONT, 14)
Tab_SetFrame.Confirm:SetPoint("CENTER", 0, -25)	
Tab_SetFrame.Confirm:SetText("确认")
Tab_SetFrame.Confirm:SetScript("OnMouseDown", function()
	SlashCmdList["CONSOLE"]("targetNearestDistance "..Tab_Set)
	SlashCmdList["CONSOLE"]("targetNearestDistanceRadius "..Tab_Set)
end)

Tab_SetFrame.Confirm:SetScript("OnMouseUp", function()
	Tab_SetFrame:Hide()
end)