--显示施法材料剩余数量
local S_ActionCountLine = AceLibrary("Gratuity-2.0")

function ShowActionSpellCount()
	local text = getglobal(this:GetName().."Count")
	local action = ActionButton_GetPagedID(this)

	local texture = GetActionTexture(action)
	if texture then
		S_ActionCountLine:SetAction(action)
		local Reagent = select(3, S_ActionCountLine:Find(SPELL_REAGENTS.."(.+)"))
		if Reagent then
			local count = select(5,FindItemInfo(Reagent))
			if count <= 0 then
				count = 0
			end
			text:SetText(HexColors(SetPercentColor(count, 10))..count)
		end
	end
end

hooksecurefunc("ActionButton_OnEvent", function(event)
	if Clean_UpFrame:IsShown() then
		this:UnregisterEvent("BAG_UPDATE")
	else
		this:RegisterEvent("BAG_UPDATE")
	end
	if ( event == "BAG_UPDATE" ) then
		ShowActionSpellCount()
	end
	if ( event == "ACTIONBAR_SLOT_CHANGED" ) then
		if ( arg1 == -1 or arg1 == ActionButton_GetPagedID(this) ) then
			ShowActionSpellCount()
		end
	end
	if ( event == "ACTIONBAR_PAGE_CHANGED" or event == "PLAYER_AURAS_CHANGED" or event == "UPDATE_BONUS_ACTIONBAR" ) then
		ShowActionSpellCount()
	end
	if ( event == "UNIT_INVENTORY_CHANGED" ) then
		if ( arg1 == "player" ) then
			ShowActionSpellCount()
		end
	end
end)