--来自modui的图标边框
local sections  = {"TOPLEFT", "TOPRIGHT", "BOTTOMLEFT", "BOTTOMRIGHT", "TOP", "BOTTOM", "LEFT", "RIGHT"}

S_iconBorder = function(self, offset)
    if type(self) ~= "table" or not self.CreateTexture or self.borderTextures then return end

	local S_BorderTextures = {}
	offset = offset or 0

	for i = 1, 8 do
		local section = sections[i]
		local x = self:CreateTexture(nil, "OVERLAY", nil, 1)
		x:SetTexture("Interface\\AddOns\\S_CastBar\\texture\\border-"..section..".tga")
		S_BorderTextures[sections[i]] = x
	end

	S_BorderTextures.TOPLEFT:SetWidth(8)
	S_BorderTextures.TOPLEFT:SetHeight(8)
	S_BorderTextures.TOPLEFT:SetPoint("BOTTOMRIGHT", self, "TOPLEFT", 4 + offset, -4 - offset)

	S_BorderTextures.TOPRIGHT:SetWidth(8)
	S_BorderTextures.TOPRIGHT:SetHeight(8)
	S_BorderTextures.TOPRIGHT:SetPoint("BOTTOMLEFT", self, "TOPRIGHT", -4 - offset, -4 - offset)

	S_BorderTextures.BOTTOMLEFT:SetWidth(8)
	S_BorderTextures.BOTTOMLEFT:SetHeight(8)
	S_BorderTextures.BOTTOMLEFT:SetPoint("TOPRIGHT", self, "BOTTOMLEFT", 4 + offset, 4 + offset)

	S_BorderTextures.BOTTOMRIGHT:SetWidth(8)
	S_BorderTextures.BOTTOMRIGHT:SetHeight(8)
	S_BorderTextures.BOTTOMRIGHT:SetPoint("TOPLEFT", self, "BOTTOMRIGHT", -4 - offset, 4 + offset)

	S_BorderTextures.TOP:SetHeight(8)
	S_BorderTextures.TOP:SetPoint("TOPLEFT", S_BorderTextures.TOPLEFT, "TOPRIGHT", 0, 0)
	S_BorderTextures.TOP:SetPoint("TOPRIGHT", S_BorderTextures.TOPRIGHT, "TOPLEFT", 0, 0)

	S_BorderTextures.BOTTOM:SetHeight(8)
	S_BorderTextures.BOTTOM:SetPoint("BOTTOMLEFT", S_BorderTextures.BOTTOMLEFT, "BOTTOMRIGHT", 0, 0)
	S_BorderTextures.BOTTOM:SetPoint("BOTTOMRIGHT", S_BorderTextures.BOTTOMRIGHT, "BOTTOMLEFT", 0, 0)

	S_BorderTextures.LEFT:SetWidth(8)
	S_BorderTextures.LEFT:SetPoint("TOPLEFT", S_BorderTextures.TOPLEFT, "BOTTOMLEFT", 0, 0)
	S_BorderTextures.LEFT:SetPoint("BOTTOMLEFT", S_BorderTextures.BOTTOMLEFT, "TOPLEFT", 0, 0)

	S_BorderTextures.RIGHT:SetWidth(8)
	S_BorderTextures.RIGHT:SetPoint("TOPRIGHT", S_BorderTextures.TOPRIGHT, "BOTTOMRIGHT", 0, 0)
	S_BorderTextures.RIGHT:SetPoint("BOTTOMRIGHT", S_BorderTextures.BOTTOMRIGHT, "TOPRIGHT", 0, 0)

	self.borderTextures = S_BorderTextures
end