local S_CastBar_Tooltip = AceLibrary("Gratuity-2.0")
local S_CastingBarTime = CreateFrame("Frame")
local S_CastBar_SpellName, InCasting_SpellName, S_icon = nil, nil
local dir = "Interface\\Icons\\"
CastingBarFrame:RegisterEvent("VARIABLES_LOADED")

--没有技能图标的请在这里添加
local DefaultIcons = {
	["采集草药"]	= "spell_nature_naturetouchgrow",
	["采矿"]		= "trade_mining",
	["剥皮"]		= "inv_misc_pelt_wolf_01",
	["开锁"]		= "INV_Misc_Gear_03",
	["火炮"]		= "INV_Ammo_Bullet_01",
}

--支持Clique点击施法插件显示技能图标
local Clique_Click_Frame = {
	"PlayerFrame",
	"PetFrame",
	"PartyMemberFrame",
	"TargetFrame",
	"TargetofTargetFrame",
	"NotGridContainer",
}

--引导法术增加跳数
SpellToTicks = {
    -- 术士
	["吸取灵魂"]	= 5,
	["火焰之雨"]	= 4,
    -- 德鲁伊
	["宁静"]		= 4,
    -- 牧师
	["精神鞭笞"]	= 3,
}
		
--图标
CastingBarFrame.Icon = CreateFrame("Frame", nil, CastingBarFrame)
CastingBarFrame.Icon:SetWidth(22)
CastingBarFrame.Icon:SetHeight(22)
CastingBarFrame.Icon:SetPoint("RIGHT", CastingBarFrame, "LEFT", -10, 2.5)
CastingBarFrame.Icon.Texture = CastingBarFrame.Icon:CreateTexture(nil, "ARTWORK")
CastingBarFrame.Icon.Texture:SetAllPoints()
CastingBarFrame.Icon.Texture:SetTexCoord(.1, .9, .1, .9)
CastingBarText:SetFont(STANDARD_TEXT_FONT, 14, "OUTLINE")
CastingBarText:SetShadowOffset(0, 0)
CastingBarText:ClearAllPoints()
CastingBarText:SetPoint("TOP", 0, 5)

--延迟条
CastingBarFrame.lag = CastingBarFrame:CreateTexture(nil, "BACKGROUND")
CastingBarFrame.lag:SetHeight(CastingBarFrame:GetHeight() - 2)
CastingBarFrame.lag:SetPoint("RIGHT", CastingBarFrame, "RIGHT", 0, 2)
CastingBarFrame.lag:SetTexture(.9, 0, 0, 1)
	
Barticks = setmetatable({},{
    __index = function(t,k)
        local spark = CastingBarFrame:CreateTexture(nil, "OVERLAY")
        t[k] = spark
        spark:SetTexture("Interface\\CastingBar\\UI-CastingBar-Spark")
        spark:SetVertexColor(1, 1, 1, 0.8)
        spark:SetBlendMode("ADD")
        spark:SetWidth(15)
        return spark
    end
})

function CastingBarFrameTicksSet(ticks)
    if (ticks and ticks > 0) then
        local delta = (CastingBarFrame:GetWidth() / ticks)
        for k = 1, ticks do
            local tick = Barticks[k]
            tick:ClearAllPoints()
            tick:SetHeight(CastingBarFrame:GetHeight() * 2.0)
            tick:SetPoint("CENTER", CastingBarFrame, "LEFT", delta * (k - 1), 0)
            tick:Show()
        end
    else
        for _, tick in ipairs(Barticks) do
            tick:Hide()
        end
    end
end
	
--hook UseAction函数
hooksecurefunc("UseAction", function(slot, checkCursor, onSelf)
	if not GetActionText(slot) then
		S_icon = GetActionTexture(slot)
		S_CastBar_Tooltip:SetAction(slot)
		S_CastBar_SpellName = S_CastBar_Tooltip:GetLine(1)
	end
end)

--hook UseContainerItem函数
hooksecurefunc("UseContainerItem", function(bag, slot)
	S_icon = GetContainerItemInfo(bag, slot)
end)

--hook CastSpell函数
hooksecurefunc("CastSpell", function(id, bookType)
	S_icon = GetSpellTexture(id, bookType)
end)

--hook CastSpellByName函数
hooksecurefunc("CastSpellByName", function(spell)
	local _, _, spellName = string.find(spell, "^([^%(]+)")
	local _,_,spellrank = string.find(spell,"(%d+)")

	if spellrank then
		S_icon = select(3,GetSpellInfo(spell))
	else
		S_icon = select(3,GetSpellInfo(spellName))
	end

	if spellname then
		S_CastBar_SpellName = spellname
	end
end)

--hook CastingBarFrame_OnEvent事件
hooksecurefunc("CastingBarFrame_OnEvent", function()
	local GetFocus_Frame, Clique_spellname, Clique_spellrank = GetMouseFocus() and GetMouseFocus():GetName() or "", nil
	
	if event == "SPELLCAST_START" then
		InCasting_SpellName = arg1
		
		if TradeSkillFrame then
			for i=1, GetNumTradeSkills(), 1 do
				local skillName = GetTradeSkillInfo(i)
				if skillName == arg1 then
					S_icon = GetTradeSkillIcon(i)
				end
			end
		end

		if (spellBookFrame and string.find(GetFocus_Frame, "SpellButton")) or arg1 == ATTACK then
			S_icon = select(3,GetSpellInfo(arg1))
		end

		CastingBarFrameTicksSet(0)
	elseif event == "SPELLCAST_CHANNEL_START" then
		InCasting_SpellName = arg2

		if arg2 ~= CHANNELING then
			S_icon = select(3,GetSpellInfo(arg2))
		end
		
		--引导法术增加跳数
		if SpellToTicks[S_CastBar_SpellName] then
			CastingBarFrameTicksSet(SpellToTicks[S_CastBar_SpellName])
		else
			CastingBarFrameTicksSet(0)
		end
	end
		
	if event == "VARIABLES_LOADED" then
		--默认位置
		CastingBarFrame:ClearAllPoints()
		CastingBarFrame:SetPoint("BOTTOM", UIParent, "BOTTOM", 15, 140)
		CastingBarFrame.SetPoint = function() end
		CastingBarFrame.ClearAllPoints = function() end
		
		--可移动施法条
		CastingBarFrame:RegisterForDrag("LeftButton")
		CastingBarFrame:SetMovable(true)
		CastingBarFrame:EnableMouse(true)
		CastingBarFrame:SetScript("OnDragStart", function()
			if not UnitAffectingCombat("player") then
				this:StartMoving()
			end
		end)
		CastingBarFrame:SetScript("OnDragStop", function() this:StopMovingOrSizing() end)
		CastingBarFrame:RegisterForDrag("LeftButton")
	end
	
	if CastingBarFrame.casting or CastingBarFrame.channeling then
		S_iconBorder(CastingBarFrame.Icon)

		local GetBarText = tostring(CastingBarText:GetText())

		--指定的技能图标
		if DefaultIcons[GetBarText] then
			S_icon = dir .. DefaultIcons[GetBarText]
		elseif string.find(GetBarText, "打开") then
			S_icon = dir .. "Spell_Nature_MoonKey"
		elseif string.byte(GetBarText) < 127 then
			S_icon = dir .. "INV_Misc_QuestionMark"
		end

		--支持Clique点击施法插件显示技能图标		
		if IsAddOnLoaded("Clique") then
			for _,v in Clique.db.char do
				for i=1, table.getn(Clique_Click_Frame) do
					if string.find(GetFocus_Frame, Clique_Click_Frame[i]) then
						for _,entry in ipairs(v) do
							Clique_spellname = entry.name
							if entry.rank then
								Clique_spellrank = LEVEL.." "..entry.rank
							else
								Clique_spellrank = ""
							end
							break
						end
					end
				end
			end
			if Clique_spellname then
				local id, bookType = GetSpellIndex(Clique_spellname, Clique_spellrank)
				S_icon = GetSpellTexture(id, bookType)
			end
		end

		if S_icon then
			CastingBarFrame.Icon:Show()
			CastingBarFrame.Icon.Texture:SetTexture(S_icon)
		end
		
		local lag = select(3,GetNetStats())
		local castingmin, castingmax = CastingBarFrame:GetMinMaxValues()
		local lagvalue = ( lag / 1000 ) / ( castingmax - castingmin )		

		--显示延迟条
		if lagvalue < 0 then
			lagvalue = 0
		elseif lagvalue > 1 then
			lagvalue = 1
		end
		CastingBarFrame.lag:SetWidth(CastingBarFrame:GetWidth() * lagvalue)
	end
end)

CastingBarFrame:SetScript("OnHide", function()
	CastingBarFrame.Icon:Hide()
end)

local function CastingBarTime_toString(end_time)
	return string.format("%.1fs", end_time - GetTime())
end

S_CastingBarTime:SetScript("OnUpdate", function()
	--施法条计时
	if ( CastingBarFrame.casting ) then
		CastingBarText:SetText(InCasting_SpellName.." "..CastingBarTime_toString(CastingBarFrame.maxValue))
	elseif ( CastingBarFrame.channeling ) then
		CastingBarText:SetText(InCasting_SpellName.." "..CastingBarTime_toString(CastingBarFrame.endTime))
	end
end)