﻿-- Chatbar主框体 --
local chatFrame = SELECTED_DOCK_FRAME
local editBox = chatFrame.editBox
COLORSCHEME_BORDER   = { 0.3,0.3,0.3,1 }

function Getchannel_name()
	local localtime, servertime = tonumber(date("%H", time())), tonumber(format("%02d", GetGameTime()))
	
	if abs(localtime - servertime) > 2 then
		channel_name = "World"
	else
		channel_name = "世界频道"
	end
	return channel_name
end

local chatbar = CreateFrame("Frame", "chatbar", UIParent)
chatbar:SetWidth(300) -- 主框体宽度
chatbar:SetHeight(20) -- 主框体高度
chatbar:SetPoint("TOPLEFT" ,ChatFrame1, "BOTTOMLEFT", 0, -10)
chatbar:RegisterEvent("PLAYER_LOGIN")
chatbar:SetScript("OnEvent", function()
	--屏蔽频道进出提示
	ChatFrame_RemoveMessageGroup(ChatFrame1, "CHANNEL")
end)

-- "说(/s)" --
local ChannelSay = CreateFrame("Button", "ChannelSay", UIParent)
ChannelSay:SetWidth(20)  -- 按钮宽度
ChannelSay:SetHeight(20)  -- 按钮高度
ChannelSay:SetPoint("LEFT",chatbar,"LEFT",0,0)   -- 锚点
ChannelSay:RegisterForClicks("LeftButtonUp")
ChannelSay:SetScript("OnClick", function() ChannelSay_OnClick() end)
ChannelSay:SetScript("OnEnter", function() 
	GameTooltip:SetOwner(this, "ANCHOR_TOP", 0, 6)
	GameTooltip:AddLine("说")
	GameTooltip:Show()
end)
ChannelSay:SetScript("OnLeave", function() GameTooltip:Hide() end)
ChannelSayText = ChannelSay:CreateFontString("ChannelSayText", "OVERLAY")
ChannelSayText:SetFont(STANDARD_TEXT_FONT, 15, "OUTLINE") -- 字体设置
ChannelSayText:SetJustifyH("CENTER")
ChannelSayText:SetWidth(25)
ChannelSayText:SetHeight(25)
ChannelSayText:SetText("说") -- 显示的文字
ChannelSayText:SetPoint("CENTER", 0, 0)
ChannelSayText:SetTextColor(1,1,1) -- 颜色

function ChannelSay_OnClick()
    ChatFrame_OpenChat("/s ", chatFrame)
end

-- "喊(/y)" --
local ChannelYell = CreateFrame("Button", "ChannelYell", UIParent)
ChannelYell:SetWidth(20) 
ChannelYell:SetHeight(20) 
ChannelYell:SetPoint("LEFT",ChannelSay,"RIGHT",0,0) 
ChannelYell:RegisterForClicks("LeftButtonUp")
ChannelYell:SetScript("OnClick", function() ChannelYell_OnClick() end)
ChannelYell:SetScript("OnEnter", function() 
	GameTooltip:SetOwner(this, "ANCHOR_TOP", 0, 6)
	GameTooltip:AddLine("喊话")
	GameTooltip:Show()
end)
ChannelYell:SetScript("OnLeave", function() GameTooltip:Hide() end)
ChannelYellText = ChannelYell:CreateFontString("ChannelYellText", "OVERLAY")
ChannelYellText:SetFont(STANDARD_TEXT_FONT, 15, "OUTLINE")
ChannelYellText:SetJustifyH("CENTER")
ChannelYellText:SetWidth(25)
ChannelYellText:SetHeight(25)
ChannelYellText:SetText("喊")
ChannelYellText:SetPoint("CENTER", 0, 0)
ChannelYellText:SetTextColor(255/255, 64/255, 64/255)

function ChannelYell_OnClick()
    ChatFrame_OpenChat("/y ", chatFrame)
end

-- "悄悄话(/w)" --
local ChannelWhisper = CreateFrame("Button", "ChannelWhisper", UIParent)
ChannelWhisper:SetWidth(20) 
ChannelWhisper:SetHeight(20) 
ChannelWhisper:SetPoint("LEFT",ChannelYell,"RIGHT",0,0) 
ChannelWhisper:RegisterForClicks("LeftButtonUp")
ChannelWhisper:SetScript("OnClick", function() ChannelWhisper_OnClick() end)
ChannelWhisper:SetScript("OnEnter", function() 
	GameTooltip:SetOwner(this, "ANCHOR_TOP", 0, 6)
	GameTooltip:AddLine("悄悄话")
	GameTooltip:Show()
end)
ChannelWhisper:SetScript("OnLeave", function() GameTooltip:Hide() end)
ChannelWhisperText = ChannelWhisper:CreateFontString("ChannelWhisperText", "OVERLAY")
ChannelWhisperText:SetFont(STANDARD_TEXT_FONT, 15, "OUTLINE")
ChannelWhisperText:SetJustifyH("CENTER")
ChannelWhisperText:SetWidth(25)
ChannelWhisperText:SetHeight(25)
ChannelWhisperText:SetText("密")
ChannelWhisperText:SetPoint("CENTER", 0, 0)
ChannelWhisperText:SetTextColor(240/255, 128/255, 128/255)

function ChannelWhisper_OnClick()
    ChatFrame_OpenChat("/w ", chatFrame)
end

-- "队伍(/p)" --
local ChannelParty = CreateFrame("Button", "ChannelParty", UIParent)
ChannelParty:SetWidth(20) 
ChannelParty:SetHeight(20) 
ChannelParty:SetPoint("LEFT",ChannelWhisper,"RIGHT",0,0) 
ChannelParty:RegisterForClicks("LeftButtonUp")
ChannelParty:SetScript("OnClick", function() ChannelParty_OnClick() end)
ChannelParty:SetScript("OnEnter", function() 
	GameTooltip:SetOwner(this, "ANCHOR_TOP", 0, 6)
	GameTooltip:AddLine("队伍")
	GameTooltip:Show()
end)
ChannelParty:SetScript("OnLeave", function() GameTooltip:Hide() end)
ChannelPartyText = ChannelParty:CreateFontString("ChannelPartyText", "OVERLAY")
ChannelPartyText:SetFont(STANDARD_TEXT_FONT, 15, "OUTLINE")
ChannelPartyText:SetJustifyH("CENTER")
ChannelPartyText:SetWidth(25)
ChannelPartyText:SetHeight(25)
ChannelPartyText:SetText("队")
ChannelPartyText:SetPoint("CENTER", 0, 0)
ChannelPartyText:SetTextColor(170/255, 170/255, 255/255)

function ChannelParty_OnClick()
    ChatFrame_OpenChat("/p ", chatFrame)
end

-- "公会(/g)" --
local ChannelGuild = CreateFrame("Button", "ChannelGuild", UIParent)
ChannelGuild:SetWidth(20) 
ChannelGuild:SetHeight(20) 
ChannelGuild:SetPoint("LEFT",ChannelParty,"RIGHT",0,0) 
ChannelGuild:RegisterForClicks("LeftButtonUp")
ChannelGuild:SetScript("OnClick", function() ChannelGuild_OnClick() end)
ChannelGuild:SetScript("OnEnter", function() 
	GameTooltip:SetOwner(this, "ANCHOR_TOP", 0, 6)
	GameTooltip:AddLine("公会")
	GameTooltip:Show()
end)
ChannelGuild:SetScript("OnLeave", function() GameTooltip:Hide() end)
ChannelGuildText = ChannelGuild:CreateFontString("ChannelGuildText", "OVERLAY")
ChannelGuildText:SetFont(STANDARD_TEXT_FONT, 15, "OUTLINE")
ChannelGuildText:SetJustifyH("CENTER")
ChannelGuildText:SetWidth(25)
ChannelGuildText:SetHeight(25)
ChannelGuildText:SetText("会")
ChannelGuildText:SetPoint("CENTER", 0, 0)
ChannelGuildText:SetTextColor(64/255, 255/255, 64/255)

function ChannelGuild_OnClick()
    ChatFrame_OpenChat("/g ", chatFrame)
end

-- "团队(/raid)" --
local ChannelRaid = CreateFrame("Button", "ChannelRaid", UIParent)
ChannelRaid:SetWidth(20) 
ChannelRaid:SetHeight(20) 
ChannelRaid:SetPoint("LEFT",ChannelGuild,"RIGHT",0,0) 
ChannelRaid:RegisterForClicks("LeftButtonUp")
ChannelRaid:SetScript("OnClick", function() ChannelRaid_OnClick() end)
ChannelRaid:SetScript("OnEnter", function() 
	GameTooltip:SetOwner(this, "ANCHOR_TOP", 0, 6)
	GameTooltip:AddLine("团队")
	GameTooltip:Show()
end)
ChannelRaid:SetScript("OnLeave", function() GameTooltip:Hide() end)
ChannelRaidText = ChannelRaid:CreateFontString("ChannelRaidText", "OVERLAY")
ChannelRaidText:SetFont(STANDARD_TEXT_FONT, 15, "OUTLINE")
ChannelRaidText:SetJustifyH("CENTER")
ChannelRaidText:SetWidth(25)
ChannelRaidText:SetHeight(25)
ChannelRaidText:SetText("团")
ChannelRaidText:SetPoint("CENTER", 0, 0)
ChannelRaidText:SetTextColor(255/255, 127/255, 0)

function ChannelRaid_OnClick()
    ChatFrame_OpenChat("/raid ", chatFrame)
end

-- "世界频道" --
local ChannelWorld = CreateFrame("Button", "ChannelWorld", UIParent)
ChannelWorld:SetWidth(20) 
ChannelWorld:SetHeight(20) 
ChannelWorld:SetPoint("LEFT",ChannelRaid,"RIGHT",0,0) 
ChannelWorld:RegisterForClicks("LeftButtonUp")
ChannelWorld:SetScript("OnClick", function() ChannelWorld_OnClick() end)
ChannelWorld:SetScript("OnEnter", function() 
	GameTooltip:SetOwner(this, "ANCHOR_TOP", 0, 6)
	GameTooltip:AddLine("世界频道")
	GameTooltip:Show()
end)
ChannelWorld:SetScript("OnLeave", function() GameTooltip:Hide() end)
ChannelWorldText = ChannelWorld:CreateFontString("ChannelWorldText", "OVERLAY")
ChannelWorldText:SetFont(STANDARD_TEXT_FONT, 15, "OUTLINE")
ChannelWorldText:SetJustifyH("CENTER")
ChannelWorldText:SetWidth(25)
ChannelWorldText:SetHeight(25)
ChannelWorldText:SetText("世")
ChannelWorldText:SetPoint("CENTER", 0, 0)
ChannelWorldText:SetTextColor(1, .8, .6) 

function ChannelWorld_OnClick()
	for k, v in pairs({GetChannelList()}) do
		if not string.find(v, Getchannel_name()) then
			JoinChannelByName(Getchannel_name(), nil, 1)
		else
			for i=0, 10 do
				local id, name = GetChannelName(i);
				if name == Getchannel_name() then
					ChatFrame_OpenChat("/"..id.." ", chatFrame)
				end
			end	
		end
	end
end

-- "中国" --
local ChannelChina = CreateFrame("Button", "ChannelChina", UIParent)
ChannelChina:SetWidth(20) 
ChannelChina:SetHeight(20) 
ChannelChina:SetPoint("LEFT",ChannelWorld,"RIGHT",0,0) 
ChannelChina:RegisterForClicks("LeftButtonUp")
ChannelChina:SetScript("OnClick", function() ChannelChina_OnClick() end)
ChannelChina:SetScript("OnEnter", function() 
	GameTooltip:SetOwner(this, "ANCHOR_TOP", 0, 6)
	GameTooltip:AddLine("中国")
	GameTooltip:Show()
end)
ChannelChina:SetScript("OnLeave", function() GameTooltip:Hide() end)
ChannelRaidText = ChannelChina:CreateFontString("ChannelRaidText", "OVERLAY")
ChannelRaidText:SetFont(STANDARD_TEXT_FONT, 15, "OUTLINE")
ChannelRaidText:SetJustifyH("CENTER")
ChannelRaidText:SetWidth(25)
ChannelRaidText:SetHeight(25)
ChannelRaidText:SetText("中")
ChannelRaidText:SetPoint("CENTER", 0, 0)
ChannelRaidText:SetTextColor(0.902, 0, 0)

function ChannelChina_OnClick()
	for k, v in pairs({GetChannelList()}) do
		if not string.find(v, "中国") then
			JoinChannelByName("中国", nil, 1)
		else
			for i=0, 10 do
				local id, name = GetChannelName(i);
				if name == "中国" then
					ChatFrame_OpenChat("/"..id.." ", chatFrame)
				end
			end	
		end
	end
end

-- Roll --
local roll = CreateFrame("Button", "rollMacro", UIParent)
roll:SetWidth(20)
roll:SetHeight(20)
roll:SetPoint("LEFT",ChannelChina,"RIGHT",5,-1)
roll:RegisterForClicks("LeftButtonUp")
roll:SetScript("OnClick", function() ChannelRoll_OnClick() end)
roll:SetScript("OnEnter", function() 
	GameTooltip:SetOwner(this, "ANCHOR_TOP", 0, 6)
	GameTooltip:AddLine("Roll")
	GameTooltip:Show()
end)
roll:SetScript("OnLeave", function() GameTooltip:Hide() end)
roll.t = roll:CreateTexture()
roll.t:SetAllPoints()
roll.t:SetWidth(25)
roll.t:SetHeight(25)
roll.t:SetTexture("Interface\\Buttons\\UI-GroupLoot-Dice-Up")

function ChannelRoll_OnClick()
	DEFAULT_CHAT_FRAME.editBox:SetText("/roll")
	ChatEdit_SendText(DEFAULT_CHAT_FRAME.editBox,0)	
end