S_Fish = {}
local ActionStartTime = 0
local ActionDoubleTime = 0
local ACTIONDOWNWAIT = 0.2
local ACTIONDOUBLEWAIT = 0.4
local StartedFishing = nil
local CastingNow = false
local FishingSpellID = nil
local FishingSkillName = nil

local function GetSetting(setting)
	if not S_Fish_Player or not S_Fish_Player["Settings"] then
		S_Fish_Player = {
			["Settings"] = {
				["EnhanceSoundSoundVolume"] = 1,
			},
		}
		end
	return S_Fish_Player["Settings"][setting]
end
S_Fish.GetSetting = GetSetting

local OldBindingKey
local function UpdateBindings(onoff)
	if onoff then
		if not OldKeyBinding then
			OldKeyBinding = GetBindingKey("TURNORACTION")
			if OldKeyBinding then
				SetBinding(OldKeyBinding, "S_Fish_PERFORMCAST")
			end
		end
	else
		if OldKeyBinding then
			SetBinding(OldKeyBinding, "TURNORACTION")
			OldKeyBinding = nil
		end
	end
end
S_Fish.UpdateBindings = UpdateBindings

local function IsFishingPole()
	local slot = GetInventorySlotInfo("MainHandSlot")
	local itemTexture = GetInventoryItemTexture("player", slot)
	
	if itemTexture and string.find(itemTexture, "INV_Fishingpole") then
		local link = GetInventoryItemLink("player", slot)
		local _, id, _ = S_Fish.SplitLink(link)
		return (id ~= 19944)
	end
	
	return false
end
S_Fish.IsFishingPole = IsFishingPole

local function HijackCheck()
	return IsFishingPole() 
end

local SavedWFOnMouseUp
local SavedWFOnMouseDown
local function WF_OnMouseDown()
	if arg1 == "RightButton" and HijackCheck() then
		S_Fish.ActionStartCheck()
	end
	if SavedWFOnMouseDown then
		SavedWFOnMouseDown()
	end
end

local resetClickToMove = false
local function WF_OnMouseUp()
	local retval
	if SavedWFOnMouseUp then
		retval = SavedWFOnMouseUp()
	end
	if arg1 == "RightButton" then
		if HijackCheck() then
			S_Fish.StopCastingCheck()
		elseif resetClickToMove then
			SetCVar("autointeract", "1")
			resetClickToMove = nil
		end
	end
   return retval
end

local function SafeHookScript(frame, handlername, newscript)
	local oldValue = frame:GetScript(handlername)
	frame:SetScript(handlername, newscript)
	return oldValue
end

S_Fish.SplitLink = function(link)
	if link then
		local _,_, color, item, name = string.find(link, "|c(%x+)|Hitem:(%d+:%d+:%d+:%d+)|h%[(.-)%]|h|r")
		return color, item, name
	end
end

local function FindSpellID(thisone)
	local id = 1
	local spellTexture = GetSpellTexture(id, BOOKTYPE_SPELL)
	
	while spellTexture do
		if spellTexture and spellTexture == thisone then
			return id
		end
		id = id + 1
		spellTexture = GetSpellTexture(id, BOOKTYPE_SPELL)
	end
	
	return nil
end

local function GetFishingSpellID()
	if not FishingSpellID or not FishingSkillName then
		FishingSpellID = FindSpellID("Interface\\Icons\\Trade_Fishing")
	end
	if FishingSpellID and not FishingSkillName then
		FishingSkillName = GetSpellName(FishingSpellID, BOOKTYPE_SPELL)
	end
end

local function InvokeFishing()
	GetFishingSpellID()
	if FishingSpellID then
		CastSpell(FishingSpellID, BOOKTYPE_SPELL)
	end
end

local function StartFishingMode()
	if not StartedFishing then
		StartedFishing = GetTime()
		S_Fish.EnhanceFishingSounds(true)
	end
end
S_Fish.StartFishingMode = StartFishingMode

local function StopFishingMode()
	if StartedFishing then
		S_Fish.EnhanceFishingSounds(false)
		StartedFishing = nil
	end
	if resetClickToMove then
		SetCVar("autointeract", "1")
		resetClickToMove = nil
	end
end
S_Fish.StopFishingMode = StopFishingMode

local function FishingMode()
	if IsFishingPole() then
		StartFishingMode()
	else
		StopFishingMode()
	end
end
S_Fish.FishingMode = FishingMode

S_Fish.ActionStartCheck = function()
	if GetCVar("autointeract") == "1" then
		resetClickToMove = true
		SetCVar("autointeract", "0")
	end
	ActionStartTime = GetTime()
end

S_Fish.StopCastingCheck = function()
	if not ActionStartTime then
		ActionStartTime = 0
	end
	
	if not ActionDoubleTime then
		ActionDoubleTime = 0
	end
	
	local time = GetTime()
	local pressTime = time - ActionStartTime
	local doubleTime = time - ActionDoubleTime
	
	if not SpellIsTargeting() then
		if ActionStartTime > 0 and ACTIONDOWNWAIT >= pressTime then
			if CastingNow and (ActionDoubleTime == 0 or ACTIONDOUBLEWAIT < doubleTime) then
				ActionDoubleTime = GetTime()
			else
				ActionDoubleTime = 0
				UpdateBindings(true)
			end
		end
	end
end

S_Fish.PerformCast = function()
	if IsMouselooking() then
		MouselookStop()
	end
	UpdateBindings(false)
	InvokeFishing()
end

S_Fish.TrapWorldMouse = function()
	SavedWFOnMouseUp = SafeHookScript(WorldFrame, "OnMouseUp", WF_OnMouseUp)
	SavedWFOnMouseDown = SafeHookScript(WorldFrame, "OnMouseDown", WF_OnMouseDown)
end

local S_FishFrame = CreateFrame("Frame")

local events = {"PLAYER_LOGIN", "PLAYER_LOGOUT", "VARIABLES_LOADED", "ITEM_LOCK_CHANGED", "SPELLS_CHANGED", "SPELLCAST_CHANNEL_START", "SPELLCAST_CHANNEL_STOP", "SPELLCAST_START", "SPELLCAST_STOP", "SPELLCAST_INTERRUPTED", "SPELLCAST_FAILED", "SKILL_LINES_CHANGED"}

for i,event in pairs(events) do
	S_FishFrame:RegisterEvent(event)
end	

S_FishFrame:SetScript("OnEvent", function()
	if event == "VARIABLES_LOADED" then
		S_Fish.TrapWorldMouse()
	elseif event == "PLAYER_LOGIN" then
		FishingMode()
	elseif event == "PLAYER_LOGOUT" then
		StopFishingMode()
	elseif event == "ITEM_LOCK_CHANGED" then
		FishingMode()
	elseif event == "SPELLS_CHANGED" then
		FishingSpellID = nil
	else
		if event == "SPELLCAST_CHANNEL_START" then
			CastingNow = true
		elseif event == "SPELLCAST_CHANNEL_STOP" then
			CastingNow = false
		end
	end
end)

S_Fish["EFSV"] = {}
S_Fish["EFSV"]["MusicVolume"] = tonumber(GetCVar("MusicVolume"))
S_Fish["EFSV"]["AmbienceVolume"] = tonumber(GetCVar("AmbienceVolume"))
S_Fish["EFSV"]["SoundVolume"] =tonumber(GetCVar("SoundVolume"))
local SoundWasEnhanced
S_Fish.EnhanceFishingSounds = function(turniton)
	if turniton then
		S_Fish["EFSV"]["MusicVolume"] = tonumber(GetCVar("MusicVolume"))
		S_Fish["EFSV"]["AmbienceVolume"] = tonumber(GetCVar("AmbienceVolume"))
		S_Fish["EFSV"]["SoundVolume"] =tonumber(GetCVar("SoundVolume"))
		for setting in S_Fish["EFSV"] do
			SetCVar(setting, GetSetting("EnhanceSound"..setting))
		end
		SoundWasEnhanced = true
	else
		if SoundWasEnhanced then
			for setting, value in S_Fish["EFSV"] do
				SetCVar(setting, value)
			end
			SoundWasEnhanced = false
		end
	end
end