local tmpCount = 0

function resetDB()
	S_CountDB = {}
	S_CountDB[currentCharacter] = {}
end

function InventoryCounter_UpdateBagsAndBank()
	S_Position = "银行"
	S_CountDB[currentCharacter][S_Position] = nil
	S_CountDB[currentCharacter][S_Position] = {}
  
	for bag = -1, 10 do
		if bag == 0 then
		  S_Position = "背包"
		  S_CountDB[currentCharacter][S_Position] = nil
		  S_CountDB[currentCharacter][S_Position] = {}
		end
		if bag == 5 then
		  S_Position = "银行"
		end
		local bagSize = GetContainerNumSlots(bag)
		if bagSize > 0 then
			for slot = 1, bagSize do
				local _, itemCount = GetContainerItemInfo(bag, slot)
				local itemLink = GetContainerItemLink(bag, slot)
				if itemCount and itemCount > 1 then
					local itemstring = string.sub(itemLink, string.find(itemLink, "%[")+1, string.find(itemLink, "%]")-1)
					tmpCount = S_CountDB[currentCharacter][S_Position][itemstring]
					if not tmpCount then
						S_CountDB[currentCharacter][S_Position][itemstring] = itemCount
					else
						S_CountDB[currentCharacter][S_Position][itemstring] = tmpCount + itemCount
					end
				end
			end
		end
	end
end

S_ItemTip_Frame = CreateFrame("Frame", "S_ItemTip_Frame", GameTooltipTemplate)
S_ItemTip_Frame:RegisterEvent("VARIABLES_LOADED")
S_ItemTip_Frame:RegisterEvent("BAG_UPDATE")
S_ItemTip_Frame:RegisterEvent("BANKFRAME_OPENED")
S_ItemTip_Frame:RegisterEvent("PLAYERBANKSLOTS_CHANGED")
S_ItemTip_Frame:SetScript("OnEvent", function (self)
    if event == "VARIABLES_LOADED" then
		currentCharacter = UnitName("player")
		if not S_CountDB then
			S_CountDB = {}
		end
		if not S_CountDB[currentCharacter] then
			S_CountDB[currentCharacter] = {}
		end
    end
	
    if event == "BAG_UPDATE" then
		S_Position = "背包"
		S_CountDB[currentCharacter][S_Position] = nil
		S_CountDB[currentCharacter][S_Position] = {}
		for bag = 0, 4 do
			bagSize = GetContainerNumSlots(bag)
			if bagSize > 0 then
				for slot = 1, bagSize do
					local _, itemCount = GetContainerItemInfo(bag, slot)
					local itemLink = GetContainerItemLink(bag, slot)
					if itemCount and itemCount > 1 then
						local itemstring = string.sub(itemLink, string.find(itemLink, "%[")+1, string.find(itemLink, "%]")-1)
						tmpCount = S_CountDB[currentCharacter][S_Position][itemstring]
						if not tmpCount then
							S_CountDB[currentCharacter][S_Position][itemstring] = itemCount
						else
							S_CountDB[currentCharacter][S_Position][itemstring] = tmpCount + itemCount
						end
					end
				end
			end
		end
    end
    if event == "BANKFRAME_OPENED" then
		InventoryCounter_UpdateBagsAndBank()
    end
    if event == "PLAYERBANKSLOTS_CHANGED" then
		InventoryCounter_UpdateBagsAndBank()
    end
end)
 
S_ItemTipCountFrame = CreateFrame("Frame", "S_ItemTipCountFrame", GameTooltip)

S_ItemTipCountFrame:SetScript("OnShow", function(self)
    if S_CountDB then
		local lbl = getglobal("GameTooltipTextLeft1")
		local tipsframe = GetMouseFocus() and GetMouseFocus():GetName() or ""
		if lbl and (tipsframe ~= "WorldFrame") and (tipsframe ~= "Minimap") and not string.find(tipsframe, "pfMiniMapPin") and getglobal('GameTooltipTextLeft2'):GetText()~= ITEM_BIND_QUEST then
			local itemName, totalCount, initLineAdded = lbl:GetText(), 0, nil
			for char,_ in pairs(S_CountDB) do
				for slot,_ in pairs(S_CountDB[char]) do
					local count = S_CountDB[char][slot][itemName]
					if count then
						if not initLineAdded then
							GameTooltip:AddLine(" ", 0, 0, 0, 0)
							initLineAdded = true
						end
						totalCount = totalCount + count
						GameTooltip:AddDoubleLine(char .. "[" .. slot .. "]", count, 0.65, 0.75, 0.85, 0.65, 0.75, 0.85)
					end
				end
			end
			if (totalCount>1) then
				GameTooltip:AddDoubleLine("合计", totalCount, 0, 0.8, 1, 0, 0.8, 1)
			end
		end
    end
    GameTooltip:Show()
end)

S_ItemTipCountFrame:SetScript("OnHide", function()
	GameTooltip:Hide()
end)