--Shagu的装备评分，修改by狗血编剧男
--鼠标
local LIDL = LibStub("LibItemLevel-1.0")

ItemSocre = CreateFrame( "Frame" , "ItemSocreTooltip", GameTooltip )
ItemSocre:RegisterEvent("UPDATE_MOUSEOVER_UNIT")
ItemSocre:SetScript("OnEvent", function()
	local score, r, g, b = ItemSocre:ScanUnit("mouseover")
	if score and score > 0 then
		GameTooltip:AddLine("装备等级 " .. score, r,g,b)
		GameTooltip:Show()
	end
end)

ItemSocre:SetScript("OnShow", function()
	if GameTooltip.itemLink then
		local _, _, itemID = string.find(GameTooltip.itemLink, "item:(%d+):%d+:%d+:%d+")
		local _, _, itemLink = string.find(GameTooltip.itemLink, "(item:%d+:%d+:%d+:%d+)")

		local itemLevel = LIDL.Item_Level[tonumber(itemID)] or 0
		local itemRarity
		if itemLink then
			_, _, itemRarity = GetItemInfo(itemLink)
		end

		if itemRarity and (itemLevel > 0) then
			local score = ItemSocre:Calculate(itemRarity, itemLevel)
			if score and score > 0 then
			  GameTooltip:AddLine("装备等级 " .. score, 1, 1, 0)
			  GameTooltip:Show()
			end
		end
	end
end)

ItemSocre:SetScript("OnHide", function()
	GameTooltip.itemLink = nil
end)

--玩家
if IsAddOnLoaded("StatCompare") then
	StatCompareSelfFrame:RegisterEvent("PLAYER_ENTERING_WORLD")
	StatCompareSelfFrame:RegisterEvent("UNIT_NAME_UPDATE")
	StatCompareSelfFrame:RegisterEvent("UNIT_PORTRAIT_UPDATE")
	StatCompareSelfFrame:RegisterEvent("UNIT_INVENTORY_CHANGED")
	StatCompareSelfFrame:RegisterEvent("BAG_UPDATE")
	StatCompareSelfFrame:SetScript("OnEvent", function()
		local score, r, g, b = ItemSocre:ScanUnit("player")
		if score and score > 0 then
			PlayerItemGS:SetText("装备等级: " .. score)
			PlayerItemGS:SetTextColor(r, g, b)
		else
			PlayerItemGS:SetText()
		end
	end)
end

--目标
ItemSocreHookInspectUnit = InspectUnit
function InspectUnit(unit)
	ItemSocreHookInspectUnit(unit)
	local score, r, g, b = ItemSocre:ScanUnit("target")
	if IsAddOnLoaded("StatCompare") then
		if score and score > 0 then
			TargetItemGS:SetText("装备等级 " .. score)
			TargetItemGS:SetTextColor(r, g, b)
		else
			TargetItemGS:SetText()
		end
	end
end

function ItemSocre:Calculate(rarity, ilvl)
	if not rarity then return nil end
	return ilvl
end

function ItemSocre:ScanUnit(unit)
	if not UnitIsPlayer(unit) then return nil end

	local count, score, r, g, b = 0, 0, 1, 1, 0
  
	for i=1,19 do
		if GetInventoryItemLink(unit, i) then
			local _, _, itemID = string.find(GetInventoryItemLink(unit, i), "item:(%d+):%d+:%d+:%d+")
			local _, _, itemLink = string.find(GetInventoryItemLink(unit, i), "(item:%d+:%d+:%d+:%d+)");

			local itemLevel = LIDL.Item_Level[tonumber(itemID)] or 0
			local itemName, _, itemRarity = GetItemInfo(itemLink)
			
			if itemName and (itemLevel > 0) then
				score = score + ItemSocre:Calculate(itemRarity, itemLevel)
				count = count + 1
			end
		end
	end

	if count <= 0 then count = 1 end
	score = tonumber(string.format("%0.1f", (score / count)))
  
	if score ~= 0 then return score, r, g, b else return nil end
end

function ItemSocre:GetItemLinkByName(name)
	for itemID = 1, 25818 do
		local itemName, hyperLink, itemQuality = GetItemInfo(itemID)
		if (itemName and itemName == name) then
			local _, _, _, hex = GetItemQualityColor(tonumber(itemQuality))
			return hex.. "|H"..hyperLink.."|h["..itemName.."]|h|r"
		end
	end
end

-- hooks
local HookSetBagItem = GameTooltip.SetBagItem
function GameTooltip.SetBagItem(self, container, slot)
	GameTooltip.itemLink = GetContainerItemLink(container, slot)
	_, GameTooltip.itemCount = GetContainerItemInfo(container, slot)
	return HookSetBagItem(self, container, slot)
end

local HookSetQuestLogItem = GameTooltip.SetQuestLogItem
function GameTooltip.SetQuestLogItem(self, itemType, index)
	GameTooltip.itemLink = GetQuestLogItemLink(itemType, index)
	if not GameTooltip.itemLink then return end
	return HookSetQuestLogItem(self, itemType, index)
end

local HookSetQuestItem = GameTooltip.SetQuestItem
function GameTooltip.SetQuestItem(self, itemType, index)
	GameTooltip.itemLink = GetQuestItemLink(itemType, index)
	return HookSetQuestItem(self, itemType, index)
end

local HookSetLootItem = GameTooltip.SetLootItem
function GameTooltip.SetLootItem(self, slot)
	GameTooltip.itemLink = GetLootSlotLink(slot)
	HookSetLootItem(self, slot)
end

local HookSetInboxItem = GameTooltip.SetInboxItem
function GameTooltip.SetInboxItem(self, mailID, attachmentIndex)
	local itemName, itemTexture, inboxItemCount, inboxItemQuality = GetInboxItem(mailID)
	GameTooltip.itemLink = ItemSocre:GetItemLinkByName(itemName)
	return HookSetInboxItem(self, mailID, attachmentIndex)
end

local HookSetInventoryItem = GameTooltip.SetInventoryItem
function GameTooltip.SetInventoryItem(self, unit, slot)
	GameTooltip.itemLink = GetInventoryItemLink(unit, slot)
	return HookSetInventoryItem(self, unit, slot)
end

local HookSetLootRollItem = GameTooltip.SetLootRollItem
function GameTooltip.SetLootRollItem(self, id)
	GameTooltip.itemLink = GetLootRollItemLink(id)
	return HookSetLootRollItem(self, id)
end

local HookSetMerchantItem = GameTooltip.SetMerchantItem
function GameTooltip.SetMerchantItem(self, merchantIndex)
	GameTooltip.itemLink = GetMerchantItemLink(merchantIndex)
	return HookSetMerchantItem(self, merchantIndex)
end

local HookSetCraftItem = GameTooltip.SetCraftItem
function GameTooltip.SetCraftItem(self, skill, slot)
	GameTooltip.itemLink = GetCraftReagentItemLink(skill, slot)
	return HookSetCraftItem(self, skill, slot)
end

local HookSetCraftSpell = GameTooltip.SetCraftSpell
function GameTooltip.SetCraftSpell(self, slot)
	GameTooltip.itemLink = GetCraftItemLink(slot)
	return HookSetCraftSpell(self, slot)
end

local HookSetTradeSkillItem = GameTooltip.SetTradeSkillItem
function GameTooltip.SetTradeSkillItem(self, skillIndex, reagentIndex)
	if reagentIndex then
		GameTooltip.itemLink = GetTradeSkillReagentItemLink(skillIndex, reagentIndex)
	else
		GameTooltip.itemLink = GetTradeSkillItemLink(skillIndex)
	end
	return HookSetTradeSkillItem(self, skillIndex, reagentIndex)
end

local HookSetAuctionSellItem = GameTooltip.SetAuctionSellItem
function GameTooltip.SetAuctionSellItem(self)
	local itemName, _, itemCount = GetAuctionSellItemInfo()
	GameTooltip.itemCount = itemCount
	GameTooltip.itemLink = ItemSocre:GetItemLinkByName(itemName)
	return HookSetAuctionSellItem(self)
end

local HookSetTradePlayerItem = GameTooltip.SetTradePlayerItem
function GameTooltip.SetTradePlayerItem(self, index)
	GameTooltip.itemLink = GetTradePlayerItemLink(index)
	return HookSetTradePlayerItem(self, index)
end

local HookSetTradeTargetItem = GameTooltip.SetTradeTargetItem
function GameTooltip.SetTradeTargetItem(self, index)
	GameTooltip.itemLink = GetTradeTargetItemLink(index)
	return HookSetTradeTargetItem(self, index)
end