local L = AceLibrary("AceLocale-2.2"):new("S_MiniMapalpha")
L:RegisterTranslations("enUS", function() return {
	["Alpha"] = true,
	["Minimap alpha"] = true,
} end)

L:RegisterTranslations("zhCN", function() return {
	["Alpha"] = "透明度",
	["Minimap alpha"] = "小地图的透明度",
} end)

local alpha = S_MiniMap:NewModule("Alpha")

function alpha:OnInitialize()
	local self = self
	self.db = S_MiniMap:AcquireDBNamespace("Alpha")
	S_MiniMap:RegisterDefaults("Alpha", "profile", {alpha = 1})

	S_MiniMap.Options.args.alpha = {
		name = L["Alpha"],
		type = "range",
		desc = L["Minimap alpha"],
		min = 0,
		max = 1,
		step = 0.05,
		isPercent = true,
		handler = self,
		get = function() return self.db.profile.alpha end,
		set = "SetAlpha",
	}

	self:SetAlpha()
end


function alpha:SetAlpha(v)
	if v then self.db.profile.alpha = v end
	Minimap:SetAlpha(self.db.profile.alpha)
end

