local L = AceLibrary("AceLocale-2.2"):new("S_MiniMapscale")
L:RegisterTranslations("enUS", function() return {
	["Scale map"] = true,
	["Minimap scale"] = true,
} end)

L:RegisterTranslations("zhCN", function() return {
	["Scale map"] = "小地图比例",
	["Minimap scale"] = "调整小地图的大小",
} end)

local scale = S_MiniMap:NewModule("Scale")


function scale:OnInitialize()
	local self = self
	self.db = S_MiniMap:AcquireDBNamespace("Scale")
	S_MiniMap:RegisterDefaults("Scale", "profile", {
		mapscale = 1.1,
	})

	S_MiniMap.Options.args.mapscale = {
		name = L["Scale map"],
		type = "range",
		desc = L["Minimap scale"],
		min = 0.5,
		max = 1.5,
		step = 0.05,
		isPercent = true,
		handler = self,
		get = function() return self.db.profile.mapscale end,
		set = "SetMapScale",
	}
	self:SetMapScale()
end


function scale:SetMapScale(v)
	if v then self.db.profile.mapscale = v end
	Minimap:SetScale(self.db.profile.mapscale)
end