local L = AceLibrary("AceLocale-2.2"):new("S_MiniMaptrackingUI")
L:RegisterTranslations("enUS", function() return {
	["show tracking icon"] = true,
	["show/hide tracking icon"] = true,
} end)

L:RegisterTranslations("zhCN", function() return {
	["show tracking icon"] = "显示追踪",
	["show/hide tracking icon"] = "是否显示追踪图标",
} end)

local trackingUI = S_MiniMap:NewModule("trackingUI")

function trackingUI:OnInitialize()
	self.db = S_MiniMap:AcquireDBNamespace("trackingUI")
	S_MiniMap:RegisterDefaults("trackingUI", "profile", {showtracking = true})
	S_MiniMap.Options.args.trackingUI = {
		name = L["show tracking icon"],
		type = "toggle",
		desc = L["show/hide tracking icon"],
		get = function() return self.db.profile.showtracking end,
		set = function(v) self.db.profile.showtracking = v end,
	}
	self:SetShow()
end

--来自pfUI的小地图追踪
  MiniMapTrackingFrame:UnregisterAllEvents()
  MiniMapTrackingFrame:Hide()

  local function HasEntries(tbl)
    for _ in pairs(tbl) do
      return true
    end
    return nil
  end
  
  local config = {
    pulse =  "1"
  }

  local knownTrackingSpellTextures = {
    any = {
      "Racial_Dwarf_FindTreasure", -- Find Treasure
      "Spell_Nature_Earthquake", -- Find Minerals
      "INV_Misc_Flower_02" -- Find Herbs
    },
    HUNTER = {
      "Ability_Tracking", -- Track Beasts, 4+
      "Spell_Holy_PrayerOfHealing", -- Track Humanoids, 10+
      "Spell_Shadow_DarkSummoning", -- Track Undead, 18+
      "Ability_Stealth", -- Track Hidden, 24+
      "Spell_Frost_SummonWaterElemental", -- Track Elementals, 26+
      "Spell_Shadow_SummonFelHunter", -- Track Deamons, 32+
      "Ability_Racial_Avatar", -- Track Giants, 40+
      "INV_Misc_Head_Dragon_01" -- Track Dragonkin, 50+
    },
    PALADIN = {
      "Spell_Holy_SenseUndead" -- Sense Undead, 20+
    },
    WARLOCK = {
      "Spell_Shadow_Metamorphosis" -- Sense Demons, 24+
    },
    DRUID = {
      "Ability_Tracking" -- Track Humanoids, 32+, Cat Form only!
    }
  }

  local state = {
    texture = nil,
    spells = {}
  }

  tracking = CreateFrame("Button", "pfUITracking", UIParent)
  tracking:SetFrameStrata("LOW")
  tracking:SetBackdrop({
	bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 8,
	edgeFile = " ", edgeSize = 8,
	insets = {left = -1, right = -1, top = -1, bottom = -1},
  })
  tracking:SetBackdropColor(0,0,0,1)
  tracking:SetPoint("TOPLEFT", Minimap, -5, -5)
  tracking:SetWidth(16)
  tracking:SetHeight(16)
  
  tracking.icon = tracking:CreateTexture("BACKGROUND")
  tracking.icon:SetTexCoord(.08, .92, .08, .92)
  tracking.icon:SetAllPoints(tracking)

  tracking.menu = CreateFrame("Frame", "pfUIDropDownMenuTracking", nil, "UIDropDownMenuTemplate")
  
  tracking:RegisterEvent("PLAYER_ENTERING_WORLD")
  tracking:RegisterEvent("PLAYER_AURAS_CHANGED")
  tracking:RegisterEvent("SPELLS_CHANGED")
  tracking:RegisterEvent("UPDATE_SHAPESHIFT_FORMS")
  tracking:SetScript("OnEvent", function()
    if event == "SPELLS_CHANGED" then
		state.spells = {}
	end
		
    this:RefreshSpells()
    local texture = GetTrackingTexture()
    if texture and texture ~= state.texture then
      state.texture = texture
      this.pulse = nil
      this.icon:SetTexture(texture)
      this.icon:SetVertexColor(1,1,1,1)
      this:Show()
    elseif not texture then
      state.texture = nil

      if config.pulse and HasEntries(state.spells) then
        this.pulse = true
        this.icon:SetTexture("Interface\\Icons\\INV_Misc_QuestionMark")
        this.icon:SetVertexColor(1,1,1,1)
        this:Show()
      else
        this.pulse = nil
        this:Hide()
      end
    end
  end)

  tracking:SetScript("OnUpdate", function()
    if this.pulse then
      local _,_,_,alpha = this.icon:GetVertexColor()
      local fpsmod = GetFramerate() / 30
      if not alpha or alpha >= 0.9 then
        this.modifier = -0.03 / fpsmod
      elseif alpha <= .5 then
        this.modifier = 0.03  / fpsmod
      end

      this.icon:SetVertexColor(1,1,1,alpha + this.modifier)
    end
  end)

  tracking:RegisterForClicks("LeftButtonUp", "RightButtonUp")
  tracking:SetScript("OnClick", function()
    if arg1 == "RightButton" then
      tracking:InitMenu()
      ToggleDropDownMenu(1, nil, tracking.menu, this, -5, -5)
    end
    if arg1 == "LeftButton" and state.texture then
      CancelTrackingBuff()
    end
  end)

  tracking:SetScript("OnEnter", function()
    GameTooltip_SetDefaultAnchor(GameTooltip, this)
    if state.texture then
      GameTooltip:SetTrackingSpell()
    else
      GameTooltip:SetText("无追踪")
    end
    GameTooltip:Show()
  end)

  tracking:SetScript("OnLeave", function()
    GameTooltip:Hide()
  end)

  function tracking:RefreshSpells()
    local _, playerClass = UnitClass("player")
    local isCatForm = tracking:PlayerIsDruidInCatForm(playerClass)

    for tabIndex = 1, GetNumSpellTabs() do
      local _, _, offset, numSpells = GetSpellTabInfo(tabIndex)
      for spellIndex = offset + 1, offset + numSpells do
        local spellTexture = GetSpellTexture(spellIndex, BOOKTYPE_SPELL)

        -- scan for generic tracking icons
        for _, texture in pairs(knownTrackingSpellTextures["any"]) do
          if spellTexture and strfind(spellTexture, texture) and not state.spells[texture] then
            state.spells[texture] = {
              index = spellIndex,
              name = GetSpellName(spellIndex, BOOKTYPE_SPELL),
              texture = spellTexture
            }
          end
        end

        -- scan class specific tracking icons
        if knownTrackingSpellTextures[playerClass] then
          for _, texture in pairs(knownTrackingSpellTextures[playerClass]) do
            if spellTexture and strfind(spellTexture, texture) and not state.spells[texture] then
                state.spells[texture] = {
                  index = spellIndex,
                  name = GetSpellName(spellIndex, BOOKTYPE_SPELL),
                  texture = spellTexture
                }
            end
          end
        end
      end
    end

    -- remove humanoid tracking for non-cat druids
    if playerClass == "DRUID" and not isCatForm then
      state.spells["Ability_Tracking"] = nil
    end
  end

  function tracking:PlayerIsDruidInCatForm(playerClass)
    if playerClass == "DRUID" then
      for i = 0, 31 do
        local texture = GetPlayerBuffTexture(i)
        if not texture then break end
        if strfind(texture, "Ability_Druid_CatForm") then
          return true
        end
      end
    end
    return false
  end

  function tracking:InitMenu()
    UIDropDownMenu_Initialize(tracking.menu, function ()
      UIDropDownMenu_AddButton({text = "小地图追踪", isTitle = 1})
      for _, spell in pairs(state.spells) do
        UIDropDownMenu_AddButton({
          text = spell.name,
          icon = spell.texture,
          tCoordLeft = .1,
          tCoordRight = .9,
          tCoordTop = .1,
          tCoordBottom = .9,
          checked = spell.texture == state.texture,
          arg1 = spell,
          func = function (arg1)
            CastSpell(arg1.index, BOOKTYPE_SPELL)
            CloseDropDownMenus()
          end
        })
      end
    end, "MENU");
  end
  
function trackingUI:SetShow(v)
	Minimap:SetScript("OnUpdate", function()
	if self.db.profile.showtracking then 
		if HasEntries(state.spells) then
			tracking:Show()
		end
	else
		tracking:Hide()
	end
	end)
end