local L = AceLibrary("AceLocale-2.2"):new("S_MiniMap")
S_MiniMap = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0", "AceConsole-2.0", "AceModuleCore-2.0")

L:RegisterTranslations("enUS", function() return {
	["S_MiniMap"] = true,
	["Reload"] = true,
	["Reload the minimap frame position"] = true,
	["A modular Minimap enhancing addon."] = true,
} end)

L:RegisterTranslations("zhCN", function() return {
	["S_MiniMap"] = "小地图",
	["Reload"] = "重置",
	["Reload the minimap frame position"] = "重置小地图",
	["A modular Minimap enhancing addon."] = "S_MiniMap方形小地图",
} end)


function S_MiniMap:OnInitialize()
	self:RegisterDB("S_MiniMapDB")
	self.Options = {
		name = L["S_MiniMap"],
		desc = L["A modular Minimap enhancing addon."],
		type = "group",
		args = {
			reload = {
				name = L["Reload"],
				type = "execute",
				desc = L["Reload the minimap frame position"],
				func = function() Minimap:ClearAllPoints() Minimap:SetPoint("TOPRIGHT", UIParent, -10,-10) Minimap:SetMaskTexture("Interface\\BUTTONS\\WHITE8X8") end,
			},
		}
	}
	self:RegisterChatCommand({"/sminimap"}, self.Options)

	--初始位置、不能超出屏幕
	Minimap:SetPoint("TOPRIGHT", UIParent, -10,-10)
	Minimap:SetFrameStrata("BACKGROUND")
	Minimap:SetFrameLevel(1)
	Minimap:SetClampedToScreen(true)
	
	--方形
	Minimap:SetMaskTexture("Interface\\BUTTONS\\WHITE8X8")
	
	--隐藏不必要的按钮
	local Hide_MiniMapButton = {
	"MinimapBorder",				--边框
	"MinimapBorderTop",				--边框
	"MinimapZoneTextButton",		--小地图区域名
	"MinimapToggleButton",			--开关按钮
	"MinimapZoomIn",				--缩小
	"MinimapZoomOut",				--放大
	"GameTimeFrame",				--系统时间
	}
	
	for i, v in pairs(Hide_MiniMapButton) do
		getglobal(v).Show = function() end
		getglobal(v):Hide()
	end
	
	--鼠标滚轮控制小地图缩放
	local MinimapZoom = CreateFrame("Frame", nil, Minimap)
	MinimapZoom:SetFrameStrata("LOW")
	MinimapZoom:EnableMouse(false)
	MinimapZoom:SetPoint("TOPLEFT", Minimap, "TOPLEFT")
	MinimapZoom:SetPoint("BOTTOMRIGHT", Minimap, "BOTTOMRIGHT")
	MinimapZoom:EnableMouseWheel(true)
	MinimapZoom:SetScript("OnMouseWheel", function()
		if arg1 > 0 then Minimap_ZoomIn() else Minimap_ZoomOut() end
	end)

	--Alt拖动
	Minimap:SetMovable(true)
	Minimap:EnableMouse(true)
	Minimap:RegisterForDrag("LeftButton")
	Minimap:SetScript("OnDragStart", function() if IsAltKeyDown() then Minimap:StartMoving() end end)
	Minimap:SetScript("OnDragStop", function() Minimap:StopMovingOrSizing() end)
	
	--战场图标
	MiniMapBattlefieldFrame:ClearAllPoints()
	MiniMapBattlefieldFrame:SetPoint("BOTTOMRIGHT", Minimap, 4, -4)
	MiniMapBattlefieldBorder:Hide()
	MiniMapBattlefieldFrame:SetScript("OnClick", function()
    GameTooltip:Hide()
    if MiniMapBattlefieldFrame.status == "active" then
		if arg1 == "RightButton" then
			ToggleDropDownMenu(1, nil, MiniMapBattlefieldDropDown, "MiniMapBattlefieldFrame", -95, -5)
		elseif IsShiftKeyDown() then
			ToggleBattlefieldMinimap()
		else
			ToggleWorldStateScoreFrame()
     end
    elseif arg1 == "RightButton" then
		ToggleDropDownMenu(1, nil, MiniMapBattlefieldDropDown, "MiniMapBattlefieldFrame", -95, -5)
    end
	end)
	
	--集合石
	MiniMapMeetingStoneFrame:ClearAllPoints()
	MiniMapMeetingStoneFrame:SetPoint("BOTTOMLEFT", Minimap, -3, -3)
	MiniMapMeetingStoneBorder:Hide()
	
	--邮箱图标
	MiniMapMailFrame:ClearAllPoints()
	MiniMapMailFrame:SetPoint("TOPRIGHT", Minimap, "TOPRIGHT", 3, 3)
	MiniMapMailBorder:Hide()
	MiniMapMailIcon:SetTexture("Interface\\AddOns\\S_MiniMap\\media\\mail.tga")
end