--重定义任务框架为双倍宽度
UIPanelWindows["QuestLogFrame"] = { area = "override", pushable = 0, xoffset = -16, yoffset = 12, bottomClampOverride = 140+12, width = 724, height = 513, whileDead = 1 };

--任务日志
SetSize(QuestLogFrame, 724, 513)
QuestLogTitleText:ClearAllPoints();
QuestLogTitleText:SetPoint("TOP", QuestLogFrame, "TOP", 0, -18);
QuestFramePushQuestButton:ClearAllPoints();
QuestFramePushQuestButton:SetPoint("BOTTOMLEFT", QuestLogFrame, "BOTTOMLEFT", 17, 54);
QuestLogFrameAbandonButton:ClearAllPoints();
QuestLogFrameAbandonButton:SetPoint("LEFT", QuestFramePushQuestButton, "RIGHT", 0, 0);

--滚动条
QuestLogDetailScrollFrame:ClearAllPoints();
QuestLogDetailScrollFrame:SetPoint("TOPLEFT", QuestLogListScrollFrame, "TOPRIGHT", 41, 0);
QuestLogDetailScrollFrame:SetHeight(362);

--没有正在进行的任务
QuestLogNoQuestsText:ClearAllPoints();
QuestLogNoQuestsText:SetPoint("TOP", QuestLogListScrollFrame, 0, -90);

--将任务列表扩展到最大高度
QuestLogListScrollFrame:SetHeight(362);

--创建其他行
local oldQuestsDisplayed = QUESTS_DISPLAYED;
QUESTS_DISPLAYED = QUESTS_DISPLAYED + 17;

for i = oldQuestsDisplayed + 1, QUESTS_DISPLAYED do
    local button = CreateFrame("Button", "QuestLogTitle" .. i, QuestLogFrame, "QuestLogTitleButtonTemplate");
    button:SetID(i);
    button:Hide();
    button:ClearAllPoints();
    button:SetPoint("TOPLEFT", getglobal("QuestLogTitle" .. (i-1)), "BOTTOMLEFT", 0, 1);
end

--替换原本的任务框架材质
local regions = { QuestLogFrame:GetRegions() }

local xOffsets = { Left = 3; Middle = 259; Right = 515; }
local yOffsets =  { Top = 0; Bot = -256; }

local textures = {
    TopLeft = "Interface\\AddOns\\S_WideQuestLog\\media\\DW_TopLeft";
    TopMiddle = "Interface\\AddOns\\S_WideQuestLog\\media\\DW_TopMid";
    TopRight = "Interface\\AddOns\\S_WideQuestLog\\media\\DW_TopRight";

    BotLeft = "Interface\\AddOns\\S_WideQuestLog\\media\\DW_BotLeft";
    BotMiddle = "Interface\\AddOns\\S_WideQuestLog\\media\\DW_BotMid";
    BotRight = "Interface\\AddOns\\S_WideQuestLog\\media\\DW_BotRight";
}

local PATTERN = "^Interface\\QuestFrame\\UI%-QuestLog%-(([A-Z][a-z]+)([A-Z][a-z]+))$";
for _, region in ipairs(regions) do
    if (region:IsObjectType("Texture")) then
        local texturefile = region:GetTexture();
        local which, yofs, xofs = string.match(texturefile, PATTERN);
        xofs = xofs and xOffsets[xofs];
        yofs = yofs and yOffsets[yofs];
        if (xofs and yofs and textures[which]) then
            region:ClearAllPoints();
            region:SetPoint("TOPLEFT", QuestLogFrame, "TOPLEFT", xofs, yofs);
            region:SetTexture(textures[which]);
			SetSize(region, 256, 256);
            textures[which] = nil;
        end
    end
end

--添加新材质
for name, path in pairs(textures) do
    local yofs, xofs = string.match(name, "^([A-Z][a-z]+)([A-Z][a-z]+)$");
    xofs = xofs and xOffsets[xofs];
    yofs = yofs and yOffsets[yofs];
    if (xofs and yofs) then
        local region = QuestLogFrame:CreateTexture(nil, "ARTWORK");
        region:ClearAllPoints();
        region:SetPoint("TOPLEFT", QuestLogFrame, "TOPLEFT", xofs, yofs);
		SetSize(region, 256, 256);
        region:SetTexture(path);
    end
end

--补缺空的材质
local topOfs = 0.37;
local topH = 256 * (1 - topOfs);

local botCap = 0.83;
local botH = 128 *  botCap;

local xSize = 256 + 64;
local ySize = topH + botH;

local nxSize = QuestLogDetailScrollFrame:GetWidth() + 26;
local nySize = QuestLogDetailScrollFrame:GetHeight() + 8;

local function relocateEmpty(t, w, h, x, y)
    local nx = x / xSize * nxSize - 10;
    local ny = y / ySize * nySize + 8;
    local nw = w / xSize * nxSize;
    local nh = h / ySize * nySize;
	
	SetSize(t, nw, nh)
    t:ClearAllPoints();
    t:SetPoint("TOPLEFT", QuestLogDetailScrollFrame, "TOPLEFT", nx, ny);
end

local txset = { EmptyQuestLogFrame:GetRegions(); }
for _, t in ipairs(txset) do
    if (t:IsObjectType("Texture")) then
        local p = t:GetTexture();
        if (type(p) == "string") then
            p = string.match(p, "-([^-]+)$");
            if (p) then
                if (p == "TopLeft") then
                    t:SetTexCoord(0, 1, topOfs, 1);
                    relocateEmpty(t, 256, topH, 0, 0);
                elseif (p == "TopRight") then
                    t:SetTexCoord(0, 1, topOfs, 1);
                    relocateEmpty(t, 64, topH, 256, 0);
                elseif (p == "BotLeft") then
                    t:SetTexCoord(0, 1, 0, botCap);
                    relocateEmpty(t, 256, botH, 0, -topH);
                elseif (p == "BotRight") then
                    t:SetTexCoord(0, 1, 0, botCap);
                    relocateEmpty(t, 64, botH, 256, -topH);
                else
                    t:Hide();
                end
            end
        end
    end
end

--任务等级显示
Orig_GetQuestLogTitle = GetQuestLogTitle
function New_GetQuestLogTitle(questIndex)
	local questLogTitleText, oldLevel, questTag, isHeader, isCollapsed, isComplete = Orig_GetQuestLogTitle(questIndex)
	local level = oldLevel
	if ( not isHeader and level ) then
		if ( questLogTitleText ) then
			questLogTitleText = " [" .. ( level or "??" ) .. ( questTag and "+" or "") .. "] " .. questLogTitleText
		end
	end
	return questLogTitleText, oldLevel, questTag, isHeader, isCollapsed, isComplete
end
GetQuestLogTitle = New_GetQuestLogTitle

if pfQuest then
	local S_pfQuestTrackButton = CreateFrame("Button", "S_pfQuestTrackButton", QuestLogFrame, "UIPanelButtonTemplate")
	SetSize(S_pfQuestTrackButton, 130, 25)
	S_pfQuestTrackButton:SetFont(STANDARD_TEXT_FONT, 14)
	S_pfQuestTrackButton:SetPoint("LEFT", "QuestLogTrackTitle", "RIGHT", 15, 0)	
	S_pfQuestTrackButton:SetText("显示|cff33ffccpf|cffffffffQuest|r任务追踪")

	S_pfQuestTrackButton:SetScript("OnMouseDown", function()
		SlashCmdList["PFDB"]("tracker")
	end)
	
	local f = CreateFrame("Frame")
	f:SetScript("OnUpdate", function()
		if pfQuestMapTracker:IsShown() then
			S_pfQuestTrackButton:Hide()
		else
			S_pfQuestTrackButton:Show()
		end
	end)
end

