﻿local onestorage = AceLibrary("OneStorage-2.0")

if GetLocale() == "zhCN" then
	AMMO = "弹药"
	SOUL = "灵魂"
	PROF = "专业"
	CONTAINER = "背包"
else
	AMMO = "Ammo"
	SOUL = "Soul"
	PROF = "Prof"
	CONTAINER = "Container"
end

-- 父级框架
local panel = CreateFrame("Frame", nil, UIParent)
local lastmoney, income = 0, 0

-- 创建信息基本框架
local Stat = CreateFrame("Frame", "diminfo_Bag")
Stat:EnableMouse(true)
Stat:SetFrameStrata("BACKGROUND")
Stat:SetFrameLevel(3)

-- 创建文字，请到ConfidiminifoG.lua修改字体、大小、位置
local Text  = panel:CreateFontString(nil, "OVERLAY")
Text:SetFont(STANDARD_TEXT_FONT, 14, "OUTLINE")
Text:SetPoint("LEFT", Durability, "RIGHT", 15, 0)
Stat:SetAllPoints(Text)

local function OnEvent()
	-- 记录收入与支出
	if event == 'PLAYER_LOGIN' then
		lastmoney = GetMoney()
		income = 0
	elseif event == 'PLAYER_MONEY' then
    	local newmoney = GetMoney()
    	if newmoney ~= lastmoney then
    		local inc_dec = (newmoney - lastmoney)
    		income = income + inc_dec
            lastmoney = newmoney
        end
	end

	-- 是否有箭袋、灵魂袋、专业袋的情况
	local usedSlots, usedAmmoSlots, usedSoulSlots, usedProfSlots, ammoQuantity, totalSlots = 0, 0, 0, 0, 0, 0
	local d_Bags = {0, 1, 2, 3, 4}
	
	for _, bag in d_Bags do
	local tmp, qty = 0, 0
		for slot = 1, GetContainerNumSlots(bag) do
			local texture, itemCount = GetContainerItemInfo(bag, slot)
			if( texture) then
				tmp = tmp + 1
				qty = qty + itemCount
			end
		end
			
		local isAmmo, isSoul, isProf = onestorage:GetBagTypes(bag)
			
		if isAmmo then
			usedAmmoSlots = usedAmmoSlots + tmp
			ammoQuantity = ammoQuantity + qty
		elseif isSoul then
			usedSoulSlots = usedSoulSlots + tmp
		elseif isProf then
			usedProfSlots = usedProfSlots + tmp
		else
			usedSlots = usedSlots + tmp
			totalSlots = totalSlots + GetContainerNumSlots(bag)
		end
	end
	
	freeSlots = totalSlots - usedSlots

	Text:SetText(CONTAINER..HexColors(SetPercentColor(freeSlots, totalSlots))..usedSlots.."|r".."/"..totalSlots)
end

--鼠标提示
Stat:SetScript("OnEnter", function()
	local gold = floor(GetMoney())
	
	GameTooltip:SetOwner(this, "ANCHOR_BOTTOMRIGHT")
	GameTooltip:ClearLines()
	GameTooltip:AddLine(CONTAINER)
	GameTooltip:AddLine("左键:背包", .3, 1, .6)
	if IsAddOnLoaded'Accountant' then
		GameTooltip:AddLine("右键:收支明细", .3, 1, .6)
	end
	if income > 0 then
		GameTooltip:AddLine(" ")
		GameTooltip:AddLine("本次登录净利润")
		SetTooltipMoney(GameTooltip, income)
	end
	GameTooltip:Show()
	end)

Stat:SetScript("OnLeave", function() GameTooltip:Hide() end)
	
-- 鼠标左键打开背包
local function OnClick()
	if arg1 == "LeftButton" then
		OpenAllBags()
	else
		if IsAddOnLoaded'Accountant' then
			AccountantButton_OnClick()
		end
	end
end

Stat:RegisterEvent("PLAYER_LOGIN")
Stat:RegisterEvent("BAG_UPDATE")
Stat:RegisterEvent("PLAYER_MONEY")
Stat:SetScript("OnEvent", OnEvent)
Stat:SetScript("OnMouseDown", OnClick)