-- 父级框架
local panel = CreateFrame("Frame", nil, UIParent)

-- 创建信息基本框架
local Stat = CreateFrame("Frame", "diminfo_Guild")
Stat:EnableMouse(true)
Stat:SetFrameStrata("BACKGROUND")
Stat:SetFrameLevel(3)

-- 创建文字，请到ConfidiminifoG.lua修改字体、大小、位置
local Text  = panel:CreateFontString(nil, "OVERLAY")
Text:SetFont(STANDARD_TEXT_FONT, 14, "OUTLINE")
Text:SetPoint("LEFT", diminfo_Time, "RIGHT", 20, 0)
Stat:SetAllPoints(Text)

-- 在线人数
local function OnEvent()
	Text:SetText("报错0")
end
	
-- 鼠标提示
Stat:SetScript("OnEnter", function()
	GameTooltip:SetOwner(this, "ANCHOR_BOTTOMRIGHT", 0, -10)		
	GameTooltip:ClearLines()
	GameTooltip:AddLine("Lua错误")
	GameTooltip:AddLine("Lua错误报告", .3, 1, .6)
	GameTooltip:Show()
end)

Stat:SetScript("OnLeave", function() GameTooltip:Hide() end)

Stat:SetScript("OnUpdate", function()
	if IsAddOnLoaded("BaudErrorFrame") then
		if BaudErrorFrameMinimapButton:IsShown() then
			Text:Hide()
		else
			Text:Show()
		end
	end
end)

-- 左键点击Lua错误报告
Stat:SetScript("OnMouseDown", function()
	if arg1 == "LeftButton" then
		if BaudErrorFrame:IsShown() then
			BaudErrorFrame:Hide();
		else
			BaudErrorFrame:Show();
		end
	end
end)

Stat:RegisterEvent("PLAYER_ENTERING_WORLD")
Stat:SetScript("OnEvent", OnEvent)