﻿-- 父级框架
local panel = CreateFrame("Frame", nil, UIParent)

-- 创建信息基本框架
local Stat = CreateFrame("Frame", "social")
Stat:EnableMouse(true)
Stat:SetFrameStrata("BACKGROUND")
Stat:SetFrameLevel(3)
	
-- 创建文字，请到ConfidiminifoG.lua修改字体、大小、位置
local Text  = panel:CreateFontString(nil, "OVERLAY")
Text:SetFont(STANDARD_TEXT_FONT, 14, "OUTLINE")
Text:SetPoint("LEFT", diminfopanel, "RIGHT", -140, 0)
Stat:SetAllPoints(Text)

local function GetNumberFriends()
	local onlineFriends, numFriends = 0, GetNumFriends()

	for i = 1, numFriends do if select(5, GetFriendInfo(i)) then onlineFriends = onlineFriends + 1 end end

	return onlineFriends
end

-- 在线人数	
local function OnEvent()
	local onlineFriends = GetNumberFriends()
	Text:SetText(FRIENDS..onlineFriends)
end

-- 鼠标提示
Stat:SetScript("OnEnter", function()
	local guildName, guildRank = GetGuildInfo("player")
	local guildonline, guildtotal = 0, GetNumGuildMembers(true)
	local guildMotD = GetGuildRosterMOTD()
	local guildinfotext = GetGuildInfoText()
	
	for i = 0, guildtotal do 
		local guildconnected = select(9, GetGuildRosterInfo(i)) 
		if guildconnected then 
			guildonline = guildonline + 1 
		end 
	end
	
	GameTooltip:SetOwner(this, "ANCHOR_BOTTOMRIGHT", 0, -10)	
	GameTooltip:ClearLines()
	GameTooltip:AddLine("好友")
	GameTooltip:AddLine("左键:好友名单", .3, 1, .6)
	
	if guildName then
		GameTooltip:AddLine("右键:公会名单", .3, 1, .6)
		GameTooltip:AddLine(" ")
		GameTooltip:AddLine("公会："..guildName,nil, nil, nil, 5)		--避免长公会名，最长显示5行
		GameTooltip:AddLine("在线人数："..guildonline)
		GameTooltip:AddLine("总人数："..guildtotal)
		GameTooltip:AddLine(RANK..": ".."|cffffffff"..guildRank)
		-- 公会今日信息
		if guildMotD ~= "" then
			GameTooltip:AddLine(" ")
			GameTooltip:AddLine(GUILD_MOTD)
			GameTooltip:AddLine(guildMotD, 0, .8 , 1, 20)			--最长显示20行
		end
		--公会信息
		if guildinfotext ~= "" then
			GameTooltip:AddLine(" ")
			GameTooltip:AddLine("公会信息")
			GameTooltip:AddLine(guildinfotext, 0, .8, 1, 30)				--最长显示30行
		end
	else
		GameTooltip:AddLine(" ")
		GameTooltip:AddLine("您还没有公会")
	end
	GameTooltip:Show()
end)
	
Stat:SetScript("OnLeave", function()
	GameTooltip:Hide()
end)

-- 每10秒更新公会在线人数
Stat:SetScript("OnUpdate", function()
    if ( this.tick or 10) > GetTime() then
		return
	else
		this.tick = GetTime() + 10
	end
	
	GuildRoster()
end)

-- 左键点击打开好友列表
Stat:SetScript("OnMouseUp", function()
	if arg1 == "LeftButton" then 
		ToggleFriendsFrame(1)
	else
		if IsInGuild() then
			if not GuildFrame then
				LoadAddOn("Blizzard_GuildUI")
			end
			ToggleFriendsFrame(3)
		end
	end
end)

Stat:RegisterEvent("PLAYER_ENTERING_WORLD")
Stat:RegisterEvent("FRIENDLIST_UPDATE")
Stat:SetScript("OnEvent", OnEvent)